/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class Utilities {
    static String numberToString(int i, boolean numeric, boolean isEuropeanNumberFormat, boolean isGroupingUsed) {
        return Utilities.decimalToString(i, numeric, isEuropeanNumberFormat, isGroupingUsed, 2);
    }

    static String numberToString(int i, boolean numeric, boolean isEuropeanNumberFormat, boolean isGroupingUsed, int priceDecimalPlaces) {
        if (priceDecimalPlaces == 2) {
            return Utilities.decimalToString(i, numeric, isEuropeanNumberFormat, isGroupingUsed, 2);
        }
        i = (i + 5 * Utilities.pow(10, priceDecimalPlaces - 3)) / Utilities.pow(10, priceDecimalPlaces - 2);
        return Utilities.decimalToString(i, numeric, isEuropeanNumberFormat, isGroupingUsed, 2);
    }

    static String holdingToString(int i, boolean isEuropeanNumberFormat, boolean isGroupingUsed) {
        return Utilities.decimalToString(i, false, isEuropeanNumberFormat, isGroupingUsed, 0);
    }

    static String holdingToString(int i, boolean isEuropeanNumberFormat, boolean isGroupingUsed, int holdingDecimalPlaces) {
        if (holdingDecimalPlaces == 0) {
            return Utilities.decimalToString(i, false, isEuropeanNumberFormat, isGroupingUsed, 0);
        }
        i = (i + 5 * Utilities.pow(10, holdingDecimalPlaces - 1)) / Utilities.pow(10, holdingDecimalPlaces);
        return Utilities.decimalToString(i, false, isEuropeanNumberFormat, isGroupingUsed, 0);
    }

    static String rateToString(int i, boolean numeric, boolean isEuropeanNumberFormat) {
        return Utilities.decimalToString(i, numeric, isEuropeanNumberFormat, false, 5);
    }

    static String decimalToString(int i, boolean numeric, boolean isEuropeanNumberFormat, boolean isGroupingUsed, int decimalPlaces) {
        if (numeric) {
            return "" + i;
        }
        String thousandSeparator = ",";
        String decimalSeparator = ".";
        if (isEuropeanNumberFormat) {
            thousandSeparator = ".";
            decimalSeparator = ",";
        }
        String s = "" + Math.abs(i);
        int extraPlace = 0;
        if (decimalPlaces > 0) {
            while (s.length() < decimalPlaces + 1) {
                s = "0" + s;
            }
            s = s.substring(0, s.length() - decimalPlaces) + decimalSeparator + s.substring(s.length() - decimalPlaces);
            extraPlace = 1;
        }
        if (isGroupingUsed) {
            if (Math.abs(i) > Utilities.pow(10, decimalPlaces + 3) - 1) {
                s = s.substring(0, s.length() - decimalPlaces - extraPlace - 3) + thousandSeparator + s.substring(s.length() - decimalPlaces - extraPlace - 3, s.length());
            }
            if (Math.abs(i) > Utilities.pow(10, decimalPlaces + 6) - 1) {
                s = s.substring(0, s.length() - decimalPlaces - extraPlace - 7) + thousandSeparator + s.substring(s.length() - decimalPlaces - extraPlace - 7, s.length());
            }
        }
        if (i < 0) {
            s = "-" + s;
        }
        return s;
    }

    static int expressionToNumber(String s, boolean isEuropeanNumberFormat) {
        int total = 0;
        if (!s.startsWith("+") && !s.startsWith("-")) {
            s = "+" + s;
        }
        while (true) {
            boolean positiveSign = false;
            if (s.startsWith("+")) {
                positiveSign = true;
            }
            int i = s.substring(1).indexOf("+") + 1;
            int j = s.substring(1).indexOf("-") + 1;
            int p = s.length();
            if (i >= 1) {
                p = Math.min(p, i);
            }
            if (j >= 1) {
                p = Math.min(p, j);
            }
            String s1 = new String(s.substring(1, p));
            int k = Utilities.stringToNumber(s1, 0, false, isEuropeanNumberFormat);
            total = positiveSign ? (total += k) : (total -= k);
            if (p >= s.length()) break;
            s = s.substring(p);
        }
        return total;
    }

    static int holdingToNumber(String s, int initialValue) {
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException numberFormatException) {
            return initialValue;
        }
    }

    static int stringToNumber(String s, int initialValue, boolean numeric, boolean isEuropeanNumberFormat) {
        return Utilities.stringToDecimal(s, initialValue, numeric, isEuropeanNumberFormat, 2);
    }

    static int stringToRate(String s, int initialValue, boolean numeric, boolean isEuropeanNumberFormat) {
        return Utilities.stringToDecimal(s, initialValue, numeric, isEuropeanNumberFormat, 5);
    }

    static int stringToDecimal(String s, int initialValue, boolean numeric, boolean isEuropeanNumberFormat, int decimalPlaces) {
        int i;
        try {
            if (numeric) {
                return Integer.valueOf(s);
            }
        }
        catch (NumberFormatException nfe) {
            return initialValue;
        }
        String thousandSeparator = ",";
        String decimalSeparator = ".";
        if (isEuropeanNumberFormat) {
            thousandSeparator = ".";
            decimalSeparator = ",";
        }
        if ((i = (s = Utilities.eliminateThousandSeparator(s, thousandSeparator)).indexOf(decimalSeparator)) < 0) {
            s = s + decimalSeparator;
            i = s.indexOf(decimalSeparator);
        }
        s = s + "00000";
        s = s.substring(0, i + 1 + decimalPlaces);
        int k1 = 0;
        int k2 = 0;
        try {
            if (i > 0) {
                k1 = Integer.valueOf(s.substring(0, i)) * Utilities.pow(10, decimalPlaces);
            }
            k2 = decimalPlaces <= 0 ? 0 : Integer.valueOf(s.substring(i + 1, i + 1 + decimalPlaces));
            if (s.substring(0, 1).equals("-")) {
                return k1 - k2;
            }
            return k1 + k2;
        }
        catch (NumberFormatException nfe) {
            return initialValue;
        }
    }

    static int homeToForeign(int home, int rate) {
        long lhome = home;
        long lrate = rate;
        long lmultiplier = 100000L;
        long lforeign = lhome * lrate / lmultiplier;
        return (int)lforeign;
    }

    static int foreignToHome(int foreign, int rate) {
        long lforeign = foreign;
        long lrate = rate;
        long lmultiplier = 100000L;
        long lhome = lforeign * lmultiplier / lrate;
        return (int)lhome;
    }

    static long longToDays(long longDate) {
        return (longDate + 3600000L) / 86400000L;
    }

    static String eliminateThousandSeparator(String s1, String s2) {
        int i;
        String s = s1;
        while ((i = s.indexOf(s2)) >= 0) {
            s = s.substring(0, i) + s.substring(i + 1);
        }
        return s;
    }

    static int pow(int base, int power) {
        if (power == 0) {
            return 1;
        }
        if (power == 1) {
            return base;
        }
        int result = base;
        for (int i = 2; i <= power; ++i) {
            result *= base;
        }
        return result;
    }

    static String androidColorToString(int color) {
        return Utilities.colorToString(color + 0x1000000);
    }

    static String colorToString(int color) {
        int i1 = color / 65536;
        int i2 = (color - i1 * 65536) / 256;
        int i3 = color - i1 * 65536 - i2 * 256;
        return "" + i1 + "," + i2 + "," + i3;
    }

    static int androidStringToColor(String s) {
        return Utilities.stringToColor(s) - 0x1000000;
    }

    static int stringToColor(String s) {
        int col3;
        int col2;
        int col1;
        int i1 = s.indexOf(",");
        int i2 = s.substring(i1 + 1).indexOf(",");
        if (i1 <= 0 || i2 <= 0) {
            return 0;
        }
        if ((i2 += i1 + 1) == s.length() - 1) {
            return 0;
        }
        try {
            col1 = Integer.parseInt(s.substring(0, i1));
            col2 = Integer.parseInt(s.substring(i1 + 1, i2));
            col3 = Integer.parseInt(s.substring(i2 + 1));
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
        return col1 * 65536 + col2 * 256 + col3;
    }

    public static void enableAntialiasing(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }
}

