/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTextField;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.AccountView;
import org.freepoc.Jabp4.Category;
import org.freepoc.Jabp4.CategoryStore;
import org.freepoc.Jabp4.CategoryView;
import org.freepoc.Jabp4.CurrencyStore;
import org.freepoc.Jabp4.CurrencyView;
import org.freepoc.Jabp4.DateChooser;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.GenericShowForm;
import org.freepoc.Jabp4.GetDateForm;
import org.freepoc.Jabp4.InvestmentView;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.LongId;
import org.freepoc.Jabp4.MoveForm;
import org.freepoc.Jabp4.NameId;
import org.freepoc.Jabp4.Regular;
import org.freepoc.Jabp4.RegularForm2;
import org.freepoc.Jabp4.RegularList;
import org.freepoc.Jabp4.RegularStore;
import org.freepoc.Jabp4.Split;
import org.freepoc.Jabp4.SplitStore;
import org.freepoc.Jabp4.StandingOrder;
import org.freepoc.Jabp4.StandingOrderForm;
import org.freepoc.Jabp4.StandingOrderView;
import org.freepoc.Jabp4.TimedMessage;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.TransactionForm;
import org.freepoc.Jabp4.TransactionStore;
import org.freepoc.Jabp4.Utilities;

public class TransactionView
extends Canvas
implements ActionListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
Runnable {
    Jabp parent;
    Account a;
    Transaction t;
    Transaction t1;
    Transaction oldT;
    Regular r;
    Regular r1;
    RegularStore rs;
    TimedMessage tm;
    Vector canvasMenu;
    TransactionStore ts;
    Date date;
    Calendar calendar;
    String msg = "";
    String oldName = "";
    Font font;
    FontMetrics fm;
    Point point;
    Image image;
    Graphics g1;
    boolean paintWholeScreen = true;
    boolean showedOutOfSpaceMessage = false;
    boolean dragScreen = false;
    boolean isSplit = false;
    boolean showCanvasMenu = false;
    boolean showingPopupMenu = false;
    boolean showSwitchViewsMenu = false;
    boolean showRegularsMenu = false;
    boolean editRegularMenu = false;
    int numMenuItems;
    int startMenuPos;
    int currentMenuPos;
    int menuWidth;
    int menuHeight;
    int menuWidthPos;
    int menuHeightPos;
    int rt;
    int fs;
    int width;
    int height;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int lastDragX;
    int lastDragY;
    int numItems;
    int numItemsPage;
    int lineHeight;
    int fontHeight;
    int fontWidth;
    int currentPos;
    int previousPos;
    int oldId;
    int startPos;
    int dateWidth;
    int numberWidth;
    int reconciledWidth;
    int descriptionWidth;
    int descriptionPosition;
    int amountPosition;
    int spacing;
    int referenceWidth;
    int referencePosition;
    int categoryWidth;
    int categoryPosition;
    int runMode;
    int minDescriptionWidth;
    int currencyRate;
    int saveAsRegularFlag = 0;
    String showMatchedCategories = "";
    long timePointerOnScreen;
    boolean pointerExecute = false;
    boolean alwaysDisplayMenu = false;
    boolean calculateCanvasMenuPosition = true;
    boolean start;
    boolean oneClickFlag;

    public TransactionView(Jabp context, Account account) {
        this.parent = context;
        this.start = true;
        this.oneClickFlag = false;
        this.a = account;
        this.parent.lastAccount = account.name;
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.saveAsRegularFlag = 0;
        this.rs = new RegularStore(this.parent, false);
        this.parent.dataIntegrityCheck("Regulars", this.rs.getNumRegulars(), this.parent.regularHt.size());
        this.ts = new TransactionStore(this.parent, this.a, false);
        int n = 0;
        for (int i = 0; i < this.parent.accountHt.size(); ++i) {
            n += ((Hashtable)this.parent.transactionHt.get(((NameId)this.parent.accountHt.get((Object)Integer.valueOf((int)i))).name)).size();
        }
        this.parent.dataIntegrityCheck("Transactions", this.ts.getNumAllTransactions(), n);
        this.numItems = this.ts.getNumTransactions();
        this.rt = this.a.current;
        if (!this.a.currency.equals(this.parent.homeCurrency)) {
            CurrencyStore ccys = null;
            ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
            this.currencyRate = ccys.getCurrencyFromName((String)this.a.currency).rate;
            if (this.parent.ccyv == null) {
                ccys.closeCurrencyStore();
                ccys = null;
            }
        }
        this.runMode = 0;
        this.referenceWidth = this.parent.referenceWidthInPixels;
        this.categoryWidth = this.parent.categoryWidthInPixels;
        this.calendar = Calendar.getInstance();
        this.font = this.parent.font;
        this.setFont(this.font);
        this.fm = this.getFontMetrics(this.font);
        this.lineHeight = this.parent.fontHeight + this.parent.lineSpacing * 2;
        this.setPositionsBasedOnSortOrder();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.setupCanvasMenu();
    }

    void setStartParameters() {
        this.numItemsPage = this.getSize().height / this.lineHeight - 2;
        this.setPositionsBasedOnSortOrder();
    }

    void setPositionsBasedOnSortOrder() {
        this.currentX = 0;
        if (this.ts.normalSortOrder) {
            this.startPos = 0;
            this.currentPos = 0;
            this.currentY = this.lineHeight;
        } else {
            this.startPos = Math.max(this.numItems - this.parent.av.numItemsPage, 0);
            this.currentPos = this.numItems - this.startPos - 1;
            this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
        }
    }

    void adjustPositionsIfNecessary() {
        if (this.currentPos > this.numItemsPage - 1) {
            this.startPos += this.currentPos - this.numItemsPage + 1;
            this.currentPos = this.numItemsPage - 1;
            this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.start) {
            this.start = false;
            this.setStartParameters();
        }
        if (this.width != this.getWidth() || this.height != this.getHeight() - this.parent.heightAdjustment) {
            this.width = this.getWidth();
            this.height = this.getHeight() - this.parent.heightAdjustment;
            this.setPositions();
            this.adjustPositionsIfNecessary();
            this.paintWholeScreen = true;
        }
        this.parent.lastUsedScreen = 1;
        this.parent.lastUsedView = 1;
        this.setPositions();
        this.g1.clearRect(0, 0, this.width, this.height);
        this.g1.setFont(this.font);
        this.showHeader();
        this.showPage();
        this.showFooter();
        if (this.parent.useCanvasMenu && this.showCanvasMenu) {
            this.displayCanvasMenu();
        }
        g.drawImage(this.image, 0, 0, this);
        this.paintWholeScreen = true;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    void showPage() {
        this.g1.setColor(new Color(this.parent.colorBackground));
        this.g1.fillRect(0, this.lineHeight, this.width, this.height - this.lineHeight * 2);
        this.g1.setColor(new Color(this.parent.colorFont));
        if (this.numItems == 0) {
            this.g1.drawString("Click here to add transaction", this.parent.widthAdjustment, this.lineHeight * 2);
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                this.g1.setColor(new Color(this.parent.colorCursor));
                this.g1.fillRect(0, this.lineHeight * i + this.lineHeight, this.width, this.lineHeight);
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            this.t = this.ts.getTransactionFromIndex(i + this.startPos);
            this.buildLine(this.t, this.lineHeight * i + this.lineHeight);
        }
        this.t = this.ts.getTransactionFromIndex(this.startPos + this.currentPos);
    }

    void showHeader() {
        int vpos = this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        if (this.msg.equals("")) {
            this.g1.setColor(new Color(this.parent.colorHeading));
            this.g1.fillRect(0, 0, this.width, this.lineHeight);
            this.g1.setColor(new Color(this.parent.colorFont));
            this.g1.drawString(this.a.name, this.parent.widthAdjustment, vpos);
            if (this.parent.runningTotal) {
                if (this.rt < 0) {
                    this.g1.setColor(new Color(this.parent.colorNegative));
                } else {
                    this.g1.setColor(new Color(this.parent.colorFont));
                }
                String s = this.a.currency.equals(this.parent.homeCurrency) ? Utilities.numberToString(this.rt, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) : this.a.currency + " " + Utilities.numberToString(Utilities.homeToForeign(this.rt, this.currencyRate), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
                this.g1.drawString(s, this.amountPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
            }
        } else {
            this.g1.setColor(new Color(this.parent.colorHeading));
            this.g1.fillRect(0, 0, this.width, this.lineHeight);
            this.g1.setColor(new Color(this.parent.colorFont));
            this.g1.drawString(this.msg, this.parent.widthAdjustment, vpos);
        }
    }

    void showFooter() {
        int w5;
        int vpos = this.height - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorHeading));
        this.g1.fillRect(0, this.height - this.lineHeight, this.width, this.lineHeight);
        int i1 = this.a.current;
        int i2 = this.a.today;
        int i3 = this.a.reconciled;
        String s = "";
        if (!this.a.currency.equals(this.parent.homeCurrency)) {
            i1 = Utilities.homeToForeign(i1, this.currencyRate);
            i2 = Utilities.homeToForeign(i2, this.currencyRate);
            i3 = Utilities.homeToForeign(i3, this.currencyRate);
            s = "* ";
        }
        String currentLabel = "Current:";
        String todayLabel = "Today:";
        String reconciledLabel = "Reconciled:";
        String s0 = s + currentLabel;
        int w0 = this.fm.stringWidth(s0);
        String s1 = Utilities.numberToString(i1, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        int w1 = this.fm.stringWidth(s1);
        String s2 = Utilities.numberToString(i2, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        int w2 = this.fm.stringWidth(s2);
        String s3 = Utilities.numberToString(i3, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        int w3 = this.fm.stringWidth(s3);
        int w4 = this.fm.stringWidth(" " + todayLabel);
        if (w0 + w1 + w4 + w2 + (w5 = this.fm.stringWidth(" " + reconciledLabel)) + w3 > this.width - this.parent.widthAdjustment * 2) {
            currentLabel = "C:";
            todayLabel = "T:";
            reconciledLabel = "R:";
            s0 = s + currentLabel;
            w0 = this.fm.stringWidth(s0);
            w4 = this.fm.stringWidth(" " + todayLabel);
            w5 = this.fm.stringWidth(" " + currentLabel);
        }
        if (w0 + w1 + w4 + w2 + w4 + w3 < this.width - this.parent.widthAdjustment * 2) {
            this.g1.setColor(new Color(this.parent.colorFont));
            this.g1.drawString(s0, this.parent.widthAdjustment, vpos);
            if (i1 < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            }
            this.g1.drawString(s1, this.parent.widthAdjustment + w0, vpos);
            this.g1.setColor(new Color(this.parent.colorFont));
            this.g1.drawString(" " + todayLabel, this.parent.widthAdjustment + w0 + w1, vpos);
            if (i2 < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            }
            this.g1.drawString(s2, this.parent.widthAdjustment + w0 + w1 + w4, vpos);
            this.g1.setColor(new Color(this.parent.colorFont));
            this.g1.drawString(" " + reconciledLabel, this.parent.widthAdjustment + w0 + w1 + w4 + w2, vpos);
            if (i3 < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            }
            this.g1.drawString(s3, this.parent.widthAdjustment + w0 + w1 + w4 + w2 + w5, vpos);
        } else if (this.parent.showBalanceType) {
            this.g1.setColor(new Color(this.parent.colorFont));
            this.g1.drawString(s0, this.parent.widthAdjustment, vpos);
            if (i1 < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            }
            this.g1.drawString(s1, this.parent.widthAdjustment + w0, vpos);
            this.g1.setColor(new Color(this.parent.colorFont));
            this.g1.drawString(" " + reconciledLabel, this.parent.widthAdjustment + w0 + w1, vpos);
            if (i3 < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            }
            this.g1.drawString(s3, this.parent.widthAdjustment + w0 + w1 + w5, vpos);
        } else {
            this.g1.setColor(new Color(this.parent.colorFont));
            this.g1.drawString(s + todayLabel, this.parent.widthAdjustment, vpos);
            if (i2 < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            }
            this.g1.drawString(s2, this.parent.widthAdjustment + w0, vpos);
            this.g1.setColor(new Color(this.parent.colorFont));
            this.g1.drawString(" " + reconciledLabel, this.parent.widthAdjustment + w0 + w2, vpos);
            if (i3 < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            }
            this.g1.drawString(s3, this.parent.widthAdjustment + w0 + w2 + w5, vpos);
        }
    }

    void drawUp() {
        if (this.showCanvasMenu) {
            if (this.currentMenuPos > 0) {
                --this.currentMenuPos;
            } else {
                --this.startMenuPos;
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (this.startPos + this.currentPos > 0) {
            int from = this.startPos + this.currentPos;
            this.oldY = this.currentY;
            this.currentY -= this.lineHeight;
            --this.currentPos;
            if (this.currentY < this.lineHeight) {
                this.currentY = this.lineHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
                this.repaint();
            } else {
                this.repaint(0, this.lineHeight * this.currentPos + this.lineHeight, this.width, this.lineHeight * 2);
            }
            int to = this.startPos + this.currentPos;
            this.adjustRunningTotal(from, to);
            return;
        }
    }

    void drawDown() {
        if (this.showCanvasMenu) {
            if (this.currentMenuPos < Math.min(this.numItemsPage, this.numMenuItems) - 1) {
                ++this.currentMenuPos;
            } else {
                ++this.startMenuPos;
                if (this.startMenuPos + this.currentPos > Math.min(this.numItemsPage, this.numMenuItems) - 1) {
                    this.startMenuPos = Math.min(this.numItemsPage, this.numMenuItems) - 1 - this.currentPos;
                }
            }
            this.repaint();
            return;
        }
        if (this.startPos + this.currentPos < this.numItems - 1) {
            int from = this.startPos + this.currentPos;
            this.oldY = this.currentY;
            this.currentY += this.lineHeight;
            ++this.currentPos;
            if (this.currentY + this.lineHeight * 2 > this.height) {
                this.currentY -= this.lineHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
                this.repaint();
            } else {
                this.repaint(0, this.lineHeight * (this.currentPos - 1) + this.lineHeight, this.width, this.lineHeight * 2);
            }
            int to = this.startPos + this.currentPos;
            this.adjustRunningTotal(from, to);
            return;
        }
    }

    String setReconciled(boolean b) {
        if (b) {
            return "r";
        }
        return "";
    }

    void buildLine(Transaction transaction, int y) {
        int k;
        int i;
        int vpos = y + this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorFont));
        this.g1.drawString(this.setPageDate(transaction.longDate), this.parent.widthAdjustment, vpos);
        int j = transaction.description.length();
        int adjDescriptionWidth = this.descriptionWidth;
        if (this.referenceWidth > 0 && transaction.reference.equals("")) {
            adjDescriptionWidth += this.referenceWidth;
        }
        for (i = 0; i < j; ++i) {
            k = j - i;
            if (this.fm.stringWidth(transaction.description.substring(0, k)) > adjDescriptionWidth) continue;
            this.g1.drawString(transaction.description.substring(0, k), this.descriptionPosition, vpos);
            break;
        }
        if (this.referenceWidth > 0) {
            j = transaction.reference.length();
            for (i = 0; i < j; ++i) {
                k = j - i;
                if (this.fm.stringWidth(transaction.reference.substring(0, k)) > this.referenceWidth) continue;
                this.g1.drawString(transaction.reference.substring(0, k), this.referencePosition, vpos);
                break;
            }
        }
        if (this.categoryWidth > 0) {
            String s1 = transaction.category;
            if (transaction.transferFlag) {
                s1 = "[" + transaction.transferAccount + "]";
            }
            if (transaction.splitFlag) {
                s1 = "[Split]";
            }
            j = s1.length();
            for (int i2 = 0; i2 < j; ++i2) {
                int k2 = j - i2;
                if (this.fm.stringWidth(s1.substring(0, k2)) > this.categoryWidth) continue;
                this.g1.drawString(s1.substring(0, k2), this.categoryPosition, vpos);
                break;
            }
        }
        if (transaction.amount < 0) {
            this.g1.setColor(new Color(this.parent.colorNegative));
        }
        String s = Utilities.numberToString(transaction.amount, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        this.g1.drawString(s, this.amountPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
        this.g1.setColor(new Color(this.parent.colorFont));
        this.g1.drawString(this.setReconciled(transaction.reconciled), this.width - this.reconciledWidth - this.parent.widthAdjustment, vpos);
    }

    String setPageDate(long ldate) {
        if (this.parent.adjustDaylightSavings) {
            this.parent.genericDate.setTime(ldate + 3600000L);
        } else {
            this.parent.genericDate.setTime(ldate);
        }
        this.parent.cal.setTime(this.parent.genericDate);
        String s0 = "" + this.parent.cal.get(5);
        if (s0.length() < 2) {
            s0 = "0" + s0;
        }
        int i = this.parent.cal.get(2) + 1;
        String s1 = "" + i;
        if (s1.length() < 2) {
            s1 = "0" + s1;
        }
        if (this.parent.dateFormat == 0) {
            return s0 + "/" + s1;
        }
        if (this.parent.dateFormat == 1) {
            return s1 + "/" + s0;
        }
        String s3 = ("" + this.parent.cal.get(1)).substring(2, 4);
        if (this.parent.dateFormat == 2) {
            return s0 + "/" + s1 + "/" + s3;
        }
        if (this.parent.dateFormat == 3) {
            return s1 + "/" + s0 + "/" + s3;
        }
        return "";
    }

    void setPositions() {
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.image = this.createImage(this.width, this.height);
        this.g1 = this.image.getGraphics();
        Utilities.enableAntialiasing(this.g1);
        this.numberWidth = this.parent.isGroupingUsed ? this.fm.stringWidth("999,999.99") : this.fm.stringWidth("999999.99");
        this.dateWidth = this.fm.stringWidth("99/99");
        if (this.parent.dateFormat > 1) {
            this.dateWidth = this.fm.stringWidth("99/99/99");
        }
        this.reconciledWidth = this.fm.stringWidth("r");
        this.minDescriptionWidth = this.fm.stringWidth("Long Description");
        this.numItemsPage = this.height / this.lineHeight - 2;
        this.spacing = this.fm.stringWidth("  ");
        this.referenceWidth = (this.width - this.minDescriptionWidth - this.parent.widthAdjustment * 2 - this.numberWidth - this.dateWidth - this.reconciledWidth - this.spacing * 5) / 2;
        this.referenceWidth = this.categoryWidth = Math.max(this.referenceWidth, this.fm.stringWidth("Reference"));
        this.descriptionWidth = this.width - this.parent.widthAdjustment * 2 - this.numberWidth - this.dateWidth - this.reconciledWidth - this.referenceWidth - this.categoryWidth - this.spacing * 5;
        if (this.parent.preferCategoryInTransactionView) {
            if (this.descriptionWidth < this.minDescriptionWidth || this.referenceWidth == 0) {
                this.descriptionWidth += this.referenceWidth + this.spacing;
                this.referenceWidth = 0;
            }
            if (this.descriptionWidth < this.minDescriptionWidth || this.categoryWidth == 0) {
                this.descriptionWidth += this.categoryWidth + this.spacing;
                this.categoryWidth = 0;
            }
        } else {
            if (this.descriptionWidth < this.minDescriptionWidth || this.categoryWidth == 0) {
                this.descriptionWidth += this.categoryWidth + this.spacing;
                this.categoryWidth = 0;
            }
            if (this.descriptionWidth < this.minDescriptionWidth || this.referenceWidth == 0) {
                this.descriptionWidth += this.referenceWidth + this.spacing;
                this.referenceWidth = 0;
            }
        }
        this.descriptionPosition = this.dateWidth + this.parent.widthAdjustment + this.spacing;
        this.referencePosition = this.descriptionPosition + this.descriptionWidth + this.spacing;
        this.categoryPosition = this.referencePosition + this.referenceWidth;
        if (this.referenceWidth > 0) {
            this.categoryPosition += this.spacing;
        }
        this.amountPosition = this.categoryPosition + this.categoryWidth;
        if (this.categoryWidth > 0) {
            this.amountPosition += this.spacing;
        }
    }

    void adjustRunningTotal(int from, int to) {
        if (!this.parent.runningTotal) {
            return;
        }
        if (from == to) {
            return;
        }
        if (from < 0 || to < 0) {
            return;
        }
        int k = 0;
        if (this.ts.normalSortOrder) {
            if (from < to) {
                for (int i = from; i < to; ++i) {
                    this.t = this.ts.getTransactionFromIndex(i);
                    k -= this.t.amount;
                }
            } else {
                for (int i = to; i < from; ++i) {
                    this.t = this.ts.getTransactionFromIndex(i);
                    k += this.t.amount;
                }
            }
        } else if (from < to) {
            for (int i = from; i < to; ++i) {
                this.t = this.ts.getTransactionFromIndex(i + 1);
                k += this.t.amount;
            }
        } else {
            for (int i = to; i < from; ++i) {
                this.t = this.ts.getTransactionFromIndex(i + 1);
                k -= this.t.amount;
            }
        }
        this.rt += k;
        this.repaint();
    }

    Date findDate(Date date1) {
        DialogManager dm = new DialogManager(this.parent, "Specify date");
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf2 = null;
        if (this.parent.dateType == 0 || this.parent.dateType == 2) {
            sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf2 = new SimpleDateFormat("dd/MM/yy HH");
        }
        if (this.parent.dateType == 1 || this.parent.dateType == 3) {
            sdf = new SimpleDateFormat("MM/dd/yyyy");
            sdf2 = new SimpleDateFormat("MM/dd/yy HH");
        }
        JTextField textDate = dm.addJTextFieldWithButton("Date", sdf.format(date1), ">");
        dm.addOKCancelButtons();
        dm.centerShow();
        if (dm.checkButtons()) {
            try {
                date1 = sdf2.parse(dm.getUserText(textDate) + " 02");
            }
            catch (ParseException pe) {
                this.tm = new TimedMessage(this.parent, "Date error");
                return new Date();
            }
            if (dm.checkButtonText().equals(">")) {
                GregorianCalendar gc = new GregorianCalendar();
                gc.setTime(date1);
                DateChooser dc = new DateChooser((Frame)this.parent, gc);
                if (dc.showDateChooser() == 1) {
                    gc = dc.getDate();
                }
                date1 = gc.getTime();
                return this.findDate(date1);
            }
            return date1;
        }
        return null;
    }

    void runThread() {
        Thread thread2 = new Thread(this);
        thread2.start();
    }

    @Override
    public void run() {
    }

    int newTransaction(Transaction transaction) {
        this.t1 = transaction;
        if (this.t1.description.equals("")) {
            return 0;
        }
        if (this.t1.account.equals("")) {
            this.t1.account = this.a.name;
        }
        this.t1.id = this.ts.saveNewTransaction(this.t1);
        if (this.t1.id < 0) {
            Toast.makeText(this.parent, "Error saving transaction", 2000).show();
            return 0;
        }
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.ts.toByteArray(this.t1), 7);
        }
        if (this.t == null) {
            this.t = this.t1;
        }
        this.updateAccountTotal1(this.a);
        this.a.updateBalance(this.t1, null, this.parent.todayDays);
        this.updateAccountTotal2(this.a);
        this.parent.av.as.saveExistingAccount(this.a);
        if (!this.t1.transferFlag) {
            CategoryStore cs = null;
            cs = this.parent.cv == null ? new CategoryStore(this.parent, true) : this.parent.cv.cs;
            if (this.t1.splitFlag) {
                for (int i = 0; i < this.t1.ss.size(); ++i) {
                    Split s = this.t1.ss.getSplit(i);
                    Category c = cs.getCategoryFromName(s.category);
                    this.updateCategoryTotal1(c);
                    c.updateBalance(s, null);
                    this.updateCategoryTotal2(c);
                    cs.saveExistingCategory(c);
                }
            } else {
                Category c = cs.getCategoryFromName(this.t1.category);
                this.updateCategoryTotal1(c);
                c.updateBalance(this.t1, null);
                this.updateCategoryTotal2(c);
                cs.saveExistingCategory(c);
            }
            if (this.parent.cv == null) {
                cs.closeCategoryStore();
                Object var3_2 = null;
            }
        }
        ++this.numItems;
        this.rt = this.a.current;
        if (this.ts.normalSortOrder) {
            this.adjustRunningTotal(0, this.startPos + this.currentPos);
        } else {
            if (this.numItems - 1 < this.numItemsPage) {
                this.currentY += this.lineHeight;
                ++this.currentPos;
            } else {
                ++this.startPos;
            }
            if (this.numItems > 1) {
                this.adjustRunningTotal(this.numItems - 1, this.startPos + this.currentPos);
            }
        }
        this.repaint();
        this.parent.storeMatchedPosition = 0;
        this.parent.matchedString = "";
        return this.t1.id;
    }

    void editTransaction(Transaction transaction, boolean reconcileOnly) {
        Category c;
        int i;
        if (transaction.description.equals("")) {
            Toast.makeText(this.parent, "Blank description", 2000).show();
            return;
        }
        this.t1 = transaction;
        if (this.t1.account.equals("")) {
            this.t1.account = this.a.name;
        }
        if (reconcileOnly) {
            this.ts.saveExistingTransaction(this.t1);
        } else {
            this.ts.deleteTransaction(this.oldT);
            this.t1.id = this.ts.saveNewTransactionWithoutIndex(this.t1);
            this.ts.updateIndex(this.startPos + this.currentPos, this.t1);
        }
        if (this.parent.syncMode) {
            if (reconcileOnly) {
                this.parent.sync.saveSyncRecord(this.ts.toByteArray(this.t1), 10);
            } else {
                this.parent.sync.saveSyncRecord(this.ts.toByteArray(this.oldT), -7);
                this.parent.sync.saveSyncRecord(this.ts.toByteArray(this.t1), 7);
            }
        }
        this.updateAccountTotal1(this.a);
        this.a.updateBalance(this.t1, this.oldT, this.parent.todayDays);
        this.updateAccountTotal2(this.a);
        this.parent.av.as.saveExistingAccount(this.a);
        if (reconcileOnly) {
            this.repaint();
            return;
        }
        if (Utilities.longToDays(this.t1.longDate) != Utilities.longToDays(this.oldT.longDate)) {
            this.ts.deleteIndex(this.startPos + this.currentPos);
            this.ts.addIndex(this.t1);
        }
        CategoryStore cs = null;
        cs = this.parent.cv == null ? new CategoryStore(this.parent, true) : this.parent.cv.cs;
        if (!this.oldT.transferFlag) {
            if (this.oldT.splitFlag) {
                for (i = 0; i < this.oldT.ss.size(); ++i) {
                    Split olds = this.oldT.ss.getSplit(i);
                    c = cs.getCategoryFromName(olds.category);
                    this.updateCategoryTotal1(c);
                    c.updateBalance(null, olds);
                    this.updateCategoryTotal2(c);
                    cs.saveExistingCategory(c);
                }
            } else {
                c = cs.getCategoryFromName(this.oldT.category);
                this.updateCategoryTotal1(c);
                c.updateBalance(null, this.oldT);
                this.updateCategoryTotal2(c);
                cs.saveExistingCategory(c);
            }
        }
        if (this.t1.transferFlag) {
            if (!this.t1.transferAccount.equals(this.t1.account) && !this.t1.transferAccount.equals("")) {
                boolean flag = false;
                Account a2 = this.parent.av.as.getAccountFromName(this.t1.transferAccount);
                this.ts.setIndex(this.a);
                this.ts.getIndex(a2);
                Transaction t2 = null;
                int n2 = this.ts.getNumTransactions();
                long longDate1 = Utilities.longToDays(this.oldT.longDate);
                for (int j = 0; j < n2; ++j) {
                    int k = j;
                    if (!this.ts.normalSortOrder) {
                        k = n2 - 1 - j;
                    }
                    t2 = this.ts.getTransactionFromIndex(k);
                    long longDate2 = Utilities.longToDays(t2.longDate);
                    if (longDate2 < longDate1) break;
                    if (longDate2 != longDate1 || !t2.transferFlag || !t2.description.equals(this.oldT.description) || t2.amount != -this.oldT.amount) continue;
                    flag = true;
                    break;
                }
                if (flag) {
                    this.oldT = new Transaction();
                    this.oldT.clone(t2);
                    t2.description = this.t1.description;
                    t2.amount = -this.t1.amount;
                    t2.longDate = this.t1.longDate;
                    t2.reference = this.t1.reference;
                    this.ts.deleteTransaction(this.oldT);
                    this.ts.deleteIndex(this.oldT);
                    t2.id = this.ts.saveNewTransaction(t2);
                    if (this.parent.syncMode) {
                        this.parent.sync.saveSyncRecord(this.ts.toByteArray(this.oldT), -7);
                        this.parent.sync.saveSyncRecord(this.ts.toByteArray(t2), 7);
                    }
                    this.updateAccountTotal1(a2);
                    a2.updateBalance(t2, this.oldT, this.parent.todayDays);
                    this.updateAccountTotal2(a2);
                    this.parent.av.as.saveExistingAccount(a2);
                }
                this.ts.setIndex(a2);
                this.ts.getIndex(this.a);
                a2 = null;
            }
        } else if (this.t1.splitFlag) {
            for (i = 0; i < this.t1.ss.size(); ++i) {
                Split s = this.t1.ss.getSplit(i);
                c = cs.getCategoryFromName(s.category);
                this.updateCategoryTotal1(c);
                c.updateBalance(s, null);
                this.updateCategoryTotal2(c);
                cs.saveExistingCategory(c);
            }
        } else {
            c = cs.getCategoryFromName(this.t1.category);
            this.updateCategoryTotal1(c);
            c.updateBalance(this.t1, null);
            this.updateCategoryTotal2(c);
            cs.saveExistingCategory(c);
        }
        if (this.parent.cv == null) {
            cs.closeCategoryStore();
            cs = null;
        }
        this.oldY = this.currentY;
        this.rt = this.a.current;
        if (this.ts.normalSortOrder) {
            this.adjustRunningTotal(0, this.startPos + this.currentPos);
        } else if (this.numItems > 1) {
            this.adjustRunningTotal(this.numItems - 1, this.startPos + this.currentPos);
        }
        this.repaint();
    }

    void deleteTransaction(Transaction transaction) {
        this.deleteTransaction(transaction, true);
    }

    void deleteTransaction(Transaction transaction, boolean syncDelete) {
        this.t1 = transaction;
        this.updateAccountTotal1(this.a);
        this.a.updateBalance(null, this.t1, this.parent.todayDays);
        this.updateAccountTotal2(this.a);
        this.parent.av.as.saveExistingAccount(this.a);
        CategoryStore cs = null;
        cs = this.parent.cv == null ? new CategoryStore(this.parent, true) : this.parent.cv.cs;
        if (this.t1.transferFlag) {
            if (!this.t1.transferAccount.equals(this.t1.account) && !this.t1.transferAccount.equals("")) {
                boolean flag = false;
                Account a2 = this.parent.av.as.getAccountFromName(this.t1.transferAccount);
                this.ts.setIndex(this.a);
                this.ts.getIndex(a2);
                Transaction t2 = null;
                int n2 = this.ts.getNumTransactions();
                long longDate1 = Utilities.longToDays(this.t1.longDate);
                for (int j = 0; j < n2; ++j) {
                    int k = j;
                    if (!this.ts.normalSortOrder) {
                        k = n2 - 1 - j;
                    }
                    t2 = this.ts.getTransactionFromIndex(k);
                    long longDate2 = Utilities.longToDays(t2.longDate);
                    if (longDate2 < longDate1) break;
                    if (longDate2 != longDate1 || !t2.transferFlag || !t2.description.equals(this.t1.description) || t2.amount != -this.t1.amount) continue;
                    flag = true;
                    break;
                }
                if (flag) {
                    this.ts.deleteTransaction(t2);
                    if (this.parent.syncMode && syncDelete) {
                        this.parent.sync.saveSyncRecord(this.ts.toByteArray(t2), -7);
                    }
                    this.ts.deleteIndex(t2);
                    this.updateAccountTotal1(a2);
                    a2.updateBalance(null, t2, this.parent.todayDays);
                    this.updateAccountTotal2(a2);
                    this.parent.av.as.saveExistingAccount(a2);
                }
                this.ts.setIndex(a2);
                this.ts.getIndex(this.a);
                a2 = null;
            }
        } else if (this.t1.splitFlag) {
            for (int i = 0; i < this.t1.ss.size(); ++i) {
                Split s = this.t1.ss.getSplit(i);
                Category c = cs.getCategoryFromName(s.category);
                this.updateCategoryTotal1(c);
                c.updateBalance(null, s);
                this.updateCategoryTotal2(c);
                cs.saveExistingCategory(c);
            }
        } else {
            Category c = cs.getCategoryFromName(this.t1.category);
            this.updateCategoryTotal1(c);
            c.updateBalance(null, this.t1);
            this.updateCategoryTotal2(c);
            cs.saveExistingCategory(c);
        }
        if (this.parent.cv == null) {
            cs.closeCategoryStore();
            cs = null;
        }
        this.ts.deleteTransaction(this.t1);
        if (this.parent.syncMode && syncDelete) {
            this.parent.sync.saveSyncRecord(this.ts.toByteArray(this.t1), -7);
        }
        this.ts.deleteIndex(this.startPos + this.currentPos);
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.lineHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
        this.rt = this.a.current;
        if (this.ts.normalSortOrder) {
            this.adjustRunningTotal(0, this.startPos + this.currentPos);
        } else if (this.numItems > 1) {
            this.adjustRunningTotal(this.numItems - 1, this.startPos + this.currentPos);
        }
        this.repaint();
    }

    void reconcileTransaction(Transaction transaction) {
        this.t1 = transaction;
        this.oldT = new Transaction();
        this.oldT.clone(this.t1);
        this.t1.reconciled = !this.t1.reconciled;
        this.editTransaction(this.t1, true);
    }

    void moveTransaction(Transaction transaction, String moveAccount) {
        Account a1 = this.parent.av.as.getAccountFromName(moveAccount);
        if (a1 == null) {
            return;
        }
        this.t1 = transaction;
        if (this.t1.account.equals("")) {
            this.t1.account = this.a.name;
        }
        this.updateAccountTotal1(this.a);
        this.a.updateBalance(null, this.t1, this.parent.todayDays);
        this.updateAccountTotal2(this.a);
        this.parent.av.as.saveExistingAccount(this.a);
        this.ts.deleteTransaction(this.t1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.ts.toByteArray(this.t1), -7);
        }
        this.ts.deleteIndex(this.startPos + this.currentPos);
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.lineHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
        this.rt = this.a.current;
        if (this.ts.normalSortOrder) {
            this.adjustRunningTotal(0, this.startPos + this.currentPos);
        } else if (this.numItems > 1) {
            this.adjustRunningTotal(this.numItems - 1, this.startPos + this.currentPos);
        }
        this.t1.account = moveAccount;
        this.ts.setIndex(this.a);
        this.ts.getIndex(a1);
        this.t1.id = this.ts.saveNewTransaction(this.t1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.ts.toByteArray(this.t1), 7);
        }
        this.ts.setIndex(a1);
        this.ts.getIndex(this.a);
        this.updateAccountTotal1(a1);
        a1.updateBalance(this.t1, null, this.parent.todayDays);
        this.updateAccountTotal2(a1);
        this.parent.av.as.saveExistingAccount(a1);
        if (this.t1.transferFlag && !this.t1.transferAccount.equals(this.t1.account) && !this.t1.transferAccount.equals("")) {
            Account a2 = this.parent.av.as.getAccountFromName(this.t1.transferAccount);
            this.ts.getIndex(a2);
            boolean flag = false;
            Transaction t2 = null;
            int n2 = this.ts.getNumTransactions();
            long longDate1 = Utilities.longToDays(this.t1.longDate);
            for (int j = 0; j < n2; ++j) {
                int k = j;
                if (!this.ts.normalSortOrder) {
                    k = n2 - 1 - j;
                }
                t2 = this.ts.getTransactionFromIndex(k);
                long longDate2 = Utilities.longToDays(t2.longDate);
                if (longDate2 < longDate1) break;
                if (longDate2 != longDate1 || !t2.transferFlag || !t2.description.equals(this.t1.description) || t2.amount != -this.t1.amount || !t2.transferAccount.equals(this.a.name)) continue;
                flag = true;
                break;
            }
            if (flag) {
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(this.ts.toByteArray(t2), -7);
                }
                this.ts.deleteTransaction(t2);
                this.ts.deleteIndex(t2);
                t2.transferAccount = moveAccount;
                t2.id = this.ts.saveNewTransaction(t2);
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(this.ts.toByteArray(t2), 7);
                }
                this.ts.setIndex(a2);
                a2 = null;
            }
            this.ts.getIndex(this.a);
        }
        this.repaint();
    }

    void goToTransaction(Transaction t2) {
        int from = this.startPos + this.currentPos;
        long longFindDate = Utilities.longToDays(t2.longDate);
        int p = this.numItems - 1;
        for (int i = 0; i < this.numItems; ++i) {
            int j = i;
            if (!this.ts.normalSortOrder) {
                j = this.numItems - 1 - i;
            }
            LongId li1 = (LongId)this.ts.ht.get(new Integer(j));
            if (longFindDate == Utilities.longToDays(li1.lo) && t2.id == li1.id) {
                p = j;
                break;
            }
            if (longFindDate <= Utilities.longToDays(li1.lo)) continue;
            p = j;
            break;
        }
        this.startPos = p;
        this.currentPos = 0;
        this.currentY = this.lineHeight;
        int to = this.startPos + this.currentPos;
        this.adjustRunningTotal(from, to);
        this.msg = "";
        this.repaint();
    }

    void goToDate(long longFindDate) {
        int from = this.startPos + this.currentPos;
        int p = this.numItems - 1;
        for (int i = 0; i < this.numItems; ++i) {
            int j = i;
            if (!this.ts.normalSortOrder) {
                j = this.numItems - 1 - i;
            }
            LongId li1 = (LongId)this.ts.ht.get(new Integer(j));
            if (longFindDate < Utilities.longToDays(li1.lo)) continue;
            p = j;
            break;
        }
        this.startPos = p;
        this.currentPos = 0;
        this.currentY = this.lineHeight;
        int to = this.startPos + this.currentPos;
        this.adjustRunningTotal(from, to);
        this.msg = "";
        this.repaint();
    }

    void updateAccountTotal1(Account account) {
        this.parent.av.totalCurrent -= account.current;
        this.parent.av.totalToday -= account.today;
        this.parent.av.totalReconciled -= account.reconciled;
    }

    void updateAccountTotal2(Account account) {
        this.parent.av.totalCurrent += account.current;
        this.parent.av.totalToday += account.today;
        this.parent.av.totalReconciled += account.reconciled;
        this.parent.av.checkMinMax(account);
    }

    void updateCategoryTotal1(Category category) {
        if (this.parent.cv != null) {
            this.parent.cv.totalCurrent -= category.current;
        }
    }

    void updateCategoryTotal2(Category category) {
        if (this.parent.cv != null) {
            this.parent.cv.totalCurrent += category.current;
            this.parent.cv.checkMinMax(category);
        }
    }

    void saveAsRegular() {
        int id;
        this.r = new Regular();
        this.r = this.r.createFromTransaction(this.t1);
        if (this.saveAsRegularFlag == 1) {
            this.r.amount = 0;
        }
        if (this.r.splitFlag) {
            this.r.ss = new SplitStore();
            for (int i = 0; i < this.r.ss.size(); ++i) {
                Split split = new Split();
                split = this.r.ss.getSplit(i);
                if (this.saveAsRegularFlag == 1) {
                    split.amount = 0;
                }
                this.r.ss.setSplit(split, i);
            }
        }
        if ((id = this.rs.lookUpId(this.r)) == 0) {
            this.r.id = this.rs.saveNewRegular(this.r);
            if (this.parent.syncMode) {
                this.parent.sync.saveSyncRecord(this.rs.toByteArray(this.r), 5);
            }
        } else {
            this.rs.saveExistingRegular(this.r);
            if (this.parent.syncMode) {
                this.parent.sync.saveSyncRecord(this.rs.toByteArray(this.r), -5);
                this.parent.sync.saveSyncRecord(this.rs.toByteArray(this.r), 5);
            }
        }
        this.saveAsRegularFlag = 0;
    }

    void incrementDate() {
        this.changeDateByOneDay(true);
    }

    void decrementDate() {
        this.changeDateByOneDay(false);
    }

    void changeDateByOneDay(boolean increase) {
        this.oldT = new Transaction();
        this.oldT.clone(this.t);
        this.t.longDate = increase ? (this.t.longDate += 86400000L) : (this.t.longDate -= 86400000L);
        this.editTransaction(this.t, false);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int j;
        String s = ae.getSource().toString();
        String s1 = s.substring((j = s.indexOf("[")) + 1, j + 5);
        if (s1.equals("menu")) {
            MenuItem mi = (MenuItem)ae.getSource();
            this.commandAction(mi.getLabel());
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        this.lastDragX = x;
        this.lastDragY = y;
        this.pointerExecute = false;
        this.alwaysDisplayMenu = false;
        this.timePointerOnScreen = System.currentTimeMillis();
        this.calculateCanvasMenuPosition = true;
        if (this.showCanvasMenu) {
            this.calculateCanvasMenuPosition = false;
            this.currentMenuPos = (y - this.menuHeightPos) / this.lineHeight;
            this.repaint();
            return;
        }
        if (y < this.lineHeight) {
            if (this.numItems == 0) {
                return;
            }
            int from = this.startPos + this.currentPos;
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.lineHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            int to = this.startPos + this.currentPos;
            this.adjustRunningTotal(from, to);
            this.repaint();
            return;
        }
        if (y > this.height - this.lineHeight) {
            if (this.numItems == 0) {
                return;
            }
            int from = this.startPos + this.currentPos;
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
            int to = this.startPos + this.currentPos;
            this.adjustRunningTotal(from, to);
            this.repaint();
            return;
        }
        this.pointerExecute = true;
        int newPos = (y - this.lineHeight) / this.lineHeight;
        if (this.startPos + newPos >= this.numItems) {
            this.alwaysDisplayMenu = true;
            return;
        }
        int from = this.startPos + this.currentPos;
        int to = this.startPos + newPos;
        this.adjustRunningTotal(from, to);
        this.currentPos = newPos;
        this.currentY = (this.currentPos + 1) * this.lineHeight;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        if (Math.abs(this.lastDragX - x) > 250) {
            this.commandAction("Switch Views");
            return;
        }
        if (this.dragScreen) {
            this.dragScreen = false;
            return;
        }
        if (this.showCanvasMenu) {
            this.showCanvasMenu = false;
            this.repaint();
            if (x < this.menuWidthPos || x > this.menuWidthPos + this.menuWidth || y < this.menuHeightPos || y > this.menuHeightPos + this.menuHeight) {
                this.setupCanvasMenu();
                this.showSwitchViewsMenu = false;
                return;
            }
            int k = (y - this.menuHeightPos) / this.lineHeight + this.startMenuPos;
            if (this.showSwitchViewsMenu) {
                this.showSwitchViewsMenu = false;
                this.processSwitchViewsMenu(k);
            } else if (this.showRegularsMenu) {
                this.showRegularsMenu = false;
                this.processRegularsMenu(k);
            } else {
                this.processMenuCommand(k);
            }
            return;
        }
        this.timePointerOnScreen = System.currentTimeMillis() - this.timePointerOnScreen;
        if (this.timePointerOnScreen > (long)this.parent.longTapDelay) {
            if (y < this.lineHeight) {
                this.startPos = 0;
                this.currentPos = 0;
                this.currentY = this.lineHeight;
                if (this.ts.normalSortOrder) {
                    this.rt = this.a.current;
                } else {
                    this.t = this.ts.getTransactionFromIndex(0);
                    this.rt = this.a.open + this.t.amount;
                }
                this.repaint();
                return;
            }
            if (y > this.height - this.lineHeight) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                if (this.ts.normalSortOrder) {
                    this.t = this.ts.getTransactionFromIndex(this.numItems - 1);
                    this.rt = this.a.open + this.t.amount;
                } else {
                    this.rt = this.a.current;
                }
                this.repaint();
                return;
            }
        }
        if (this.alwaysDisplayMenu) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.repaint();
            } else {
                this.displayPopupMenu();
            }
            return;
        }
        if (!this.pointerExecute) {
            return;
        }
        if (this.parent.showMenuTransactionView && this.timePointerOnScreen <= (long)this.parent.longTapDelay || !this.parent.showMenuTransactionView && this.timePointerOnScreen > (long)this.parent.longTapDelay) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.repaint();
            } else {
                this.displayPopupMenu();
            }
            return;
        }
        this.t = this.ts.getTransactionFromIndex(this.startPos + this.currentPos);
        this.reconcileTransaction(this.t);
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        int from = this.startPos + this.currentPos;
        int scroll = (y - this.lastDragY) / this.lineHeight;
        if (scroll == 0) {
            return;
        }
        if (scroll > 0) {
            if (this.showCanvasMenu) {
                this.startMenuPos -= scroll;
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
                this.currentMenuPos += scroll;
                if (this.currentMenuPos > Math.min(this.numMenuItems, this.numItemsPage) - 1) {
                    this.currentMenuPos = Math.min(this.numMenuItems, this.numItemsPage) - 1;
                }
            } else {
                this.startPos -= scroll;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                this.currentPos += scroll;
                if (this.currentPos > Math.min(this.numItems, this.numItemsPage) - 1) {
                    this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                }
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
        }
        if (scroll < 0) {
            if (this.showCanvasMenu) {
                this.startMenuPos -= scroll;
                if (this.startMenuPos + this.numItemsPage > this.numMenuItems - 1) {
                    this.startMenuPos = this.numMenuItems - this.numItemsPage;
                }
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
                this.currentMenuPos += scroll;
                if (this.currentMenuPos < 0) {
                    this.currentMenuPos = 0;
                }
            } else {
                this.startPos -= scroll;
                if (this.startPos + this.currentPos > this.numItems - 1) {
                    this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                    this.startPos = this.numItems - 1 - this.currentPos;
                    this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                }
                this.currentPos += scroll;
                if (this.currentPos < 0) {
                    this.currentPos = 0;
                }
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
        }
        this.lastDragY = y;
        int to = this.startPos + this.currentPos;
        this.adjustRunningTotal(from, to);
        this.repaint();
        this.dragScreen = true;
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        int notches = mwe.getWheelRotation();
        if (notches == 0) {
            return;
        }
        if (notches > 0) {
            for (int i = 0; i < notches; ++i) {
                this.drawDown();
            }
        } else {
            notches = -notches;
            for (int i = 0; i < notches; ++i) {
                this.drawUp();
            }
        }
    }

    void displayPopupMenu() {
        if (this.showingPopupMenu) {
            this.showingPopupMenu = false;
            return;
        }
        PopupMenu pm = new PopupMenu();
        MenuItem miHome = new MenuItem("Home");
        MenuItem miNew = new MenuItem("New");
        MenuItem miNewTransRegular = new MenuItem("New Trans (Regular)");
        MenuItem miNewSplit = new MenuItem("New Split");
        MenuItem miEdit = new MenuItem("Edit");
        MenuItem miSaveAsRegular = new MenuItem("Save As Regular");
        MenuItem miSaveAsStandingOrder = new MenuItem("Save As Standing Order");
        MenuItem miCopyTransaction = new MenuItem("Copy Transaction");
        MenuItem miDelete = new MenuItem("Delete");
        MenuItem miReconcile = new MenuItem("Reconcile");
        MenuItem miMove = new MenuItem("Move");
        MenuItem miShow = new MenuItem("Show");
        MenuItem miToggleReferenceCategory = new MenuItem("Toggle Reference/Category");
        MenuItem miToggleDefaultAction = new MenuItem("Toggle Default Action");
        MenuItem miToggleSortOrder = new MenuItem("Toggle Sort Order");
        MenuItem miSwitchViews = new MenuItem("Switch Views");
        MenuItem miGoTo = new MenuItem("Go To Date");
        MenuItem miSync = new MenuItem("Sync This Entry");
        miHome.addActionListener(this);
        miNew.addActionListener(this);
        miNewTransRegular.addActionListener(this);
        miNewSplit.addActionListener(this);
        miEdit.addActionListener(this);
        miSaveAsRegular.addActionListener(this);
        miSaveAsStandingOrder.addActionListener(this);
        miCopyTransaction.addActionListener(this);
        miDelete.addActionListener(this);
        miReconcile.addActionListener(this);
        miMove.addActionListener(this);
        miShow.addActionListener(this);
        miToggleReferenceCategory.addActionListener(this);
        miToggleDefaultAction.addActionListener(this);
        miToggleSortOrder.addActionListener(this);
        miSwitchViews.addActionListener(this);
        miGoTo.addActionListener(this);
        miSync.addActionListener(this);
        pm.add(miHome);
        pm.add(miNew);
        pm.add(miNewTransRegular);
        pm.add(miNewSplit);
        pm.add(miEdit);
        pm.add(miSaveAsRegular);
        pm.add(miSaveAsStandingOrder);
        pm.add(miCopyTransaction);
        pm.add(miDelete);
        pm.add(miReconcile);
        pm.add(miMove);
        pm.add(miShow);
        pm.add(miToggleReferenceCategory);
        pm.add(miToggleDefaultAction);
        pm.add(miToggleSortOrder);
        pm.add(miSwitchViews);
        pm.add(miGoTo);
        pm.add(miSync);
        this.add(pm);
        int x = 0;
        int y = 0;
        if (this.point == null) {
            pm.show(this, x, y);
        } else {
            Point move = this.movePopup(18, x, y);
            pm.show(this, move.x + this.point.x, move.y + this.point.y);
        }
        this.showingPopupMenu = true;
    }

    void displaySwitchViewsMenu() {
        if (this.showingPopupMenu) {
            this.showingPopupMenu = false;
            return;
        }
        PopupMenu pm = new PopupMenu();
        MenuItem miAccounts = new MenuItem("Accounts");
        MenuItem miTransactions = new MenuItem("Transactions");
        MenuItem miCategories = new MenuItem("Categories");
        MenuItem miStandingOrders = new MenuItem("Standing Orders");
        MenuItem miInvestments = new MenuItem("Investments");
        MenuItem miCurrencies = new MenuItem("Currencies");
        miAccounts.addActionListener(this);
        miTransactions.addActionListener(this);
        miCategories.addActionListener(this);
        miStandingOrders.addActionListener(this);
        miInvestments.addActionListener(this);
        miCurrencies.addActionListener(this);
        pm.add(miAccounts);
        pm.add(miTransactions);
        pm.add(miCategories);
        pm.add(miStandingOrders);
        pm.add(miInvestments);
        pm.add(miCurrencies);
        this.add(pm);
        int x = 0;
        int y = 0;
        if (this.point == null) {
            pm.show(this, x, y);
        } else {
            Point move = this.movePopup(6, x, y);
            pm.show(this, move.x + this.point.x, move.y + this.point.y);
        }
        this.showingPopupMenu = true;
    }

    Point movePopup(int n, int x, int y) {
        int popupHeight = n * this.lineHeight * 4 / 3;
        if (this.parent.useCanvasMenu && x + this.point.x + this.menuWidth > this.width) {
            x = this.width - this.menuWidth - this.point.x;
        }
        if (y + this.point.y + popupHeight > this.height) {
            y = this.height - popupHeight - this.point.y;
        }
        Point move = new Point(x, y);
        return move;
    }

    void setupCanvasMenu() {
        this.startMenuPos = 0;
        this.currentMenuPos = 0;
        this.canvasMenu = new Vector(17);
        this.canvasMenu.addElement("Home");
        this.canvasMenu.addElement("New");
        this.canvasMenu.addElement("New Trans (Regular)");
        this.canvasMenu.addElement("New Split");
        this.canvasMenu.addElement("Edit");
        this.canvasMenu.addElement("Save As Regular");
        this.canvasMenu.addElement("Save As Standing Order");
        this.canvasMenu.addElement("Copy Transaction");
        this.canvasMenu.addElement("Delete");
        this.canvasMenu.addElement("Reconcile");
        this.canvasMenu.addElement("Move");
        this.canvasMenu.addElement("Show");
        this.canvasMenu.addElement("Toggle Reference/Category");
        this.canvasMenu.addElement("Toggle Default Action");
        this.canvasMenu.addElement("Toggle Sort Order");
        this.canvasMenu.addElement("Switch Views");
        this.canvasMenu.addElement("Go To Date");
        this.canvasMenu.addElement("Sync This Entry");
        this.menuWidth = this.fm.stringWidth("Toggle Reference/Category") + 6;
    }

    void setupRegularsMenu() {
        this.startMenuPos = 0;
        this.currentMenuPos = 0;
        int n = this.rs.getNumRegulars();
        this.canvasMenu = new Vector(n + 1);
        int k = this.fm.stringWidth("(Menu)");
        this.canvasMenu.addElement("(Menu)");
        for (int i = 0; i < n; ++i) {
            String s = this.rs.getRegularFromIndex((int)i).description;
            this.canvasMenu.addElement(s);
            k = Math.max(k, this.fm.stringWidth(s));
        }
        this.menuWidth = k + 6;
    }

    void displayRegularsMenu() {
        int i;
        int n = this.rs.getNumRegulars();
        PopupMenu pm = new PopupMenu();
        pm.add(new MenuItem("(Menu)"));
        for (i = 0; i < n; ++i) {
            String s = this.rs.getRegularFromIndex((int)i).description;
            pm.add(new MenuItem(s));
        }
        for (i = 0; i < n + 1; ++i) {
            pm.getItem(i).addActionListener(this);
        }
        this.add(pm);
        int x = 0;
        int y = 0;
        if (this.point == null) {
            pm.show(this, x, y);
        } else {
            Point move = this.movePopup(n + 1, x, y);
            pm.show(this, move.x + this.point.x, move.y + this.point.y);
        }
    }

    void setupSwitchViewsMenu() {
        this.startMenuPos = 0;
        this.currentMenuPos = 0;
        this.canvasMenu = new Vector(6);
        this.canvasMenu.addElement("Accounts");
        this.canvasMenu.addElement("Transactions");
        this.canvasMenu.addElement("Categories");
        this.canvasMenu.addElement("Standing Orders");
        this.canvasMenu.addElement("Investments");
        this.canvasMenu.addElement("Currencies");
        this.menuWidth = this.fm.stringWidth("Standing Orders") + 6;
    }

    void displayCanvasMenu() {
        this.numMenuItems = this.canvasMenu.size();
        this.menuWidthPos = (this.width - this.menuWidth) / 2;
        if (this.menuWidthPos < 0) {
            this.menuWidthPos = 0;
        }
        this.menuHeightPos = (this.height - this.lineHeight * 2 - this.numMenuItems * this.lineHeight) / 2;
        if (this.menuHeightPos < this.lineHeight) {
            this.menuHeightPos = this.lineHeight;
        }
        this.menuHeight = Math.min(this.height - this.lineHeight * 2, this.numMenuItems * this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorMessage));
        this.g1.fillRect(this.menuWidthPos, this.menuHeightPos, this.menuWidth, this.menuHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        for (int i = 0; i < this.numItemsPage && i + this.startMenuPos <= this.numMenuItems - 1; ++i) {
            int vpos = i * this.lineHeight + this.lineHeight + this.menuHeightPos - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
            if (i == this.currentMenuPos) {
                this.g1.setColor(new Color(this.parent.colorCursor));
                this.g1.fillRect(this.menuWidthPos, this.lineHeight * i + this.menuHeightPos, this.menuWidth, this.lineHeight);
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            this.g1.drawString((String)this.canvasMenu.elementAt(i + this.startMenuPos), this.menuWidthPos + 3, vpos);
        }
    }

    void processMenuCommand(int k) {
        this.invalidate();
        this.commandAction((String)this.canvasMenu.elementAt(k));
    }

    void processSwitchViewsMenu(int k) {
        this.setupCanvasMenu();
        switch (k) {
            case 0: {
                this.commandAction("Accounts");
                break;
            }
            case 1: {
                this.commandAction("Transactions");
                break;
            }
            case 2: {
                this.commandAction("Categories");
                break;
            }
            case 3: {
                this.commandAction("Standing Orders");
                break;
            }
            case 4: {
                this.commandAction("Investments");
                break;
            }
            case 5: {
                this.commandAction("Currencies");
            }
        }
    }

    void processRegularsMenu(int k) {
        this.setupCanvasMenu();
        if (k == 0) {
            this.editRegularMenu = true;
            this.commandAction("New Trans (Regular)");
            this.editRegularMenu = false;
            return;
        }
        Regular r = this.rs.getRegularFromIndex(k - 1);
        this.copyRegularToTransaction(r);
    }

    void copyRegularToTransaction(Regular r) {
        this.t1 = new Transaction();
        this.t1.account = this.a.name;
        this.t1.description = r.description;
        this.t1.amount = r.amount;
        this.t1.longDate = this.parent.lastUsedDate.getTime();
        this.t1.reference = r.reference;
        this.t1.category = r.category;
        this.t1.transferFlag = r.transferFlag;
        this.t1.transferAccount = r.transferAccount;
        this.t1.splitFlag = r.splitFlag;
        if (this.t1.splitFlag) {
            this.t1.ss = new SplitStore();
            for (int i = 0; i < r.ss.size(); ++i) {
                Split split = new Split();
                split = r.ss.getSplit(i);
                this.t1.ss.addSplit(split);
            }
        }
        this.parent.trf = new TransactionForm(this.parent, this.t1, false, "New");
    }

    public void commandAction(String cmd) {
        this.showingPopupMenu = false;
        if (this.parent.saveStateOnHome) {
            this.parent.ixs.selfDestruct();
        }
        if (cmd.equals("Exit")) {
            if (this.parent.useCanvasMenu && this.showCanvasMenu) {
                this.showCanvasMenu = false;
                this.repaint();
                return;
            }
            this.parent.finishAndQuit();
            return;
        }
        if (cmd.equals("Home")) {
            if (this.parent.av == null) {
                this.parent.av = new AccountView(this.parent);
            }
            this.parent.setContentView(this.parent.av);
            return;
        }
        if (cmd.equals("New")) {
            Transaction t2 = new Transaction();
            t2.account = this.a.name;
            this.parent.trf = new TransactionForm(this.parent, t2, false, "New");
            return;
        }
        if (cmd.equals("New Split")) {
            Transaction t2 = new Transaction();
            t2.account = this.a.name;
            t2.splitFlag = true;
            t2.ss = new SplitStore();
            this.parent.trf = new TransactionForm(this.parent, t2, false, "New");
            return;
        }
        if (cmd.equals("Edit")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to edit", 2000).show();
                return;
            }
            this.oldT = new Transaction();
            this.oldT.clone(this.t);
            this.parent.trf = new TransactionForm(this.parent, this.t, false, "Edit");
            return;
        }
        if (cmd.equals("Delete")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to delete", 2000).show();
                return;
            }
            this.parent.trf = new TransactionForm(this.parent, this.t, false, "Delete");
            return;
        }
        if (cmd.equals("Show")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to show", 2000).show();
                return;
            }
            this.parent.gsf = new GenericShowForm(this.parent, this.t, 2);
            this.parent.setContentView(this.parent.gsf);
            return;
        }
        if (cmd.equals("New Trans (Regular)")) {
            int n = this.rs.getNumRegulars();
            if (n == 0) {
                Toast.makeText(this.parent, "No regular transactions set up", 2000).show();
                return;
            }
            if (this.parent.useCanvasMenu && !this.editRegularMenu) {
                this.showCanvasMenu = true;
                this.showRegularsMenu = true;
                this.setupRegularsMenu();
                this.repaint();
                return;
            }
            new RegularList(this.parent, false);
            return;
        }
        if (cmd.equals("Save As Regular")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "No transactions set up", 2000).show();
                return;
            }
            Regular r = new Regular();
            r = r.createFromTransaction(this.t);
            new RegularForm2(this.parent, r, "New");
            return;
        }
        if (cmd.equals("Reconcile")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "No transactions set up", 2000).show();
                return;
            }
            this.reconcileTransaction(this.t);
            this.repaint();
            return;
        }
        if (cmd.equals("Save As Standing Order")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "No transactions set up", 2000).show();
                return;
            }
            if (this.t.splitFlag) {
                Toast.makeText(this.parent, "Cannot use split transaction", 2000).show();
                return;
            }
            StandingOrder so = new StandingOrder();
            so = so.createFromTransaction(this.t);
            if (this.parent.sov == null) {
                this.parent.sov = new StandingOrderView(this.parent);
            }
            this.parent.sof = new StandingOrderForm(this.parent, so, "New");
            return;
        }
        if (cmd.equals("Copy Transaction")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "No transactions set up", 2000).show();
                return;
            }
            Transaction t2 = new Transaction();
            t2 = t2.clone(this.t);
            t2.longDate = this.parent.lastUsedDate.getTime();
            t2.reconciled = this.a.type.equals("Cash");
            this.parent.trf = new TransactionForm(this.parent, t2, false, "Copy");
            return;
        }
        if (cmd.equals("Move")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "No transactions set up", 2000).show();
                return;
            }
            new MoveForm(this.parent, this.t);
            return;
        }
        if (cmd.equals("Go To Date")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "No transactions set up", 2000).show();
                return;
            }
            new GetDateForm(this.parent, 0);
            return;
        }
        if (cmd.equals("Switch Views")) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.showSwitchViewsMenu = true;
                this.setupSwitchViewsMenu();
                this.repaint();
                return;
            }
            this.displaySwitchViewsMenu();
            return;
        }
        if (cmd.equals("Toggle Reference/Category")) {
            if (this.parent.preferCategoryInTransactionView) {
                this.parent.preferCategoryInTransactionView = false;
                Toast.makeText(this.parent, "Preferred column is Reference", 2000).show();
            } else {
                this.parent.preferCategoryInTransactionView = true;
                Toast.makeText(this.parent, "Preferred column is Category", 2000).show();
            }
            this.setPositions();
            this.repaint();
            return;
        }
        if (cmd.equals("Toggle Default Action")) {
            if (this.parent.showMenuTransactionView) {
                this.parent.showMenuTransactionView = false;
                Toast.makeText(this.parent, "Default action: reconcile\nLong click action: show menu", 2000).show();
            } else {
                this.parent.showMenuTransactionView = true;
                Toast.makeText(this.parent, "Default action: show menu\nLong click action: reconcile", 2000).show();
            }
            return;
        }
        if (cmd.equals("Toggle Sort Order")) {
            this.ts.changeSortOrder();
            this.setPositionsBasedOnSortOrder();
            this.rt = this.a.current;
            this.repaint();
            return;
        }
        if (cmd.equals("Sync This Entry")) {
            if (!this.parent.syncMode) {
                Toast.makeText(this.parent, "Sync mode is turned off", 2000).show();
                return;
            }
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "No transactions set up", 2000).show();
                return;
            }
            this.parent.sync.saveSyncRecord(this.ts.toByteArray(this.t), 7);
            Toast.makeText(this.parent, "Entry written to sync file", 2000).show();
            return;
        }
        if (cmd.equals("Accounts") || cmd.equals("Home")) {
            if (this.parent.av == null) {
                this.parent.av = new AccountView(this.parent);
            }
            this.parent.setContentView(this.parent.av);
            this.repaint();
            return;
        }
        if (cmd.equals("Transactions")) {
            Toast.makeText(this.parent, "Already in Transactions View", 2000).show();
            this.repaint();
            return;
        }
        if (cmd.equals("Categories")) {
            if (this.parent.cv == null) {
                this.parent.cv = new CategoryView(this.parent);
            }
            this.parent.setContentView(this.parent.cv);
            this.repaint();
            return;
        }
        if (cmd.equals("Standing Orders")) {
            if (this.parent.sov == null) {
                this.parent.sov = new StandingOrderView(this.parent);
            }
            this.parent.setContentView(this.parent.sov);
            this.repaint();
            return;
        }
        if (cmd.equals("Investments")) {
            if (this.parent.iv == null) {
                this.parent.iv = new InvestmentView(this.parent);
            }
            this.parent.setContentView(this.parent.iv);
            this.repaint();
            return;
        }
        if (cmd.equals("Currencies")) {
            if (this.parent.ccyv == null) {
                this.parent.ccyv = new CurrencyView(this.parent);
            }
            this.parent.setContentView(this.parent.ccyv);
            this.repaint();
            return;
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int keyCode = keyEvent.getKeyCode();
        switch (keyCode) {
            case 33: 
            case 37: {
                int from = this.startPos + this.currentPos;
                if (this.startPos == 0) {
                    this.currentPos = 0;
                    this.currentY = this.lineHeight;
                } else {
                    this.startPos -= this.numItemsPage;
                    if (this.startPos < 0) {
                        this.startPos = 0;
                    }
                }
                int to = this.startPos + this.currentPos;
                this.adjustRunningTotal(from, to);
                break;
            }
            case 34: 
            case 39: {
                int from = this.startPos + this.currentPos;
                this.startPos += this.numItemsPage;
                if (this.startPos + this.currentPos > this.numItems - 1) {
                    this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                    this.startPos = this.numItems - 1 - this.currentPos;
                    this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                }
                int to = this.startPos + this.currentPos;
                this.adjustRunningTotal(from, to);
                break;
            }
            case 38: {
                this.drawUp();
                break;
            }
            case 40: {
                this.drawDown();
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int keyCode = keyEvent.getKeyCode();
        switch (keyCode) {
            case 36: {
                this.startPos = 0;
                this.currentPos = 0;
                this.currentY = this.lineHeight;
                if (this.ts.normalSortOrder) {
                    this.rt = this.a.current;
                    break;
                }
                this.t = this.ts.getTransactionFromIndex(0);
                this.rt = this.a.open + this.t.amount;
                break;
            }
            case 35: {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                if (this.ts.normalSortOrder) {
                    this.t = this.ts.getTransactionFromIndex(this.numItems - 1);
                    this.rt = this.a.open + this.t.amount;
                    break;
                }
                this.rt = this.a.current;
                break;
            }
            case 10: 
            case 525: {
                if (this.showCanvasMenu) {
                    this.showCanvasMenu = false;
                    if (this.showSwitchViewsMenu) {
                        this.showSwitchViewsMenu = false;
                        this.processSwitchViewsMenu(this.startMenuPos + this.currentMenuPos);
                        break;
                    }
                    if (this.showRegularsMenu) {
                        this.showRegularsMenu = false;
                        this.processRegularsMenu(this.startMenuPos + this.currentMenuPos);
                        break;
                    }
                    this.processMenuCommand(this.startMenuPos + this.currentMenuPos);
                    break;
                }
                if (this.numItems == 0) break;
                if (this.parent.useCanvasMenu) {
                    this.showCanvasMenu = true;
                    break;
                }
                if (keyCode != 525) break;
                this.displayPopupMenu();
                break;
            }
            case 27: {
                this.parent.onBackPressed();
                break;
            }
            case 521: {
                this.incrementDate();
                break;
            }
            case 45: {
                this.decrementDate();
                break;
            }
            case 78: {
                this.commandAction("New");
                break;
            }
            case 69: {
                this.commandAction("Edit");
                break;
            }
            case 68: {
                this.commandAction("Delete");
                break;
            }
            case 76: {
                this.commandAction("New Trans (Regular)");
                break;
            }
            case 32: 
            case 82: {
                this.commandAction("Reconcile");
                break;
            }
            case 77: {
                this.commandAction("Move");
                break;
            }
            case 71: {
                this.commandAction("Go To Date");
                break;
            }
            case 83: {
                this.commandAction("Show");
                break;
            }
            case 72: {
                this.commandAction("Home");
                break;
            }
            case 86: {
                this.commandAction("Switch Views");
                break;
            }
            case 67: {
                this.commandAction("Copy Transaction");
                break;
            }
            case 75: {
                this.parent.gsf = new GenericShowForm(this.parent, null, 9);
                this.parent.setContentView(this.parent.gsf);
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                int i = keyCode - 49;
                int n = this.parent.av.numItems;
                if (i > n - 1) {
                    Toast.makeText(this.parent, "Too few accounts", 1000).show();
                    break;
                }
                String s = this.parent.av.as.getAccountFromIndex2((int)i).name;
                if (s.equals(this.a.name)) {
                    Toast.makeText(this.parent, "You are already in " + s, 1000).show();
                    break;
                }
                this.a = this.parent.av.as.getAccountFromIndex2(i);
                this.ts.closeTransactionStore();
                this.rs.closeRegularStore();
                this.parent.tv = new TransactionView(this.parent, this.a);
                this.parent.setContentView(this.parent.tv);
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

