/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.Category;
import org.freepoc.Jabp4.CategoryStore;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.LongId;
import org.freepoc.Jabp4.RecordStore;
import org.freepoc.Jabp4.Sort;
import org.freepoc.Jabp4.Split;
import org.freepoc.Jabp4.SplitStore;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.Utilities;

public class TransactionStore {
    Jabp parent;
    Account a;
    Hashtable ht;
    RecordStore rs;
    boolean normalSortOrder = true;

    public TransactionStore(Jabp context, Account account, boolean fastDiskAccess) {
        this.parent = context;
        this.a = account;
        this.openTransactionStore(fastDiskAccess);
        this.getIndex(this.a);
    }

    void openTransactionStore(boolean fastDiskAccess) {
        this.rs = new RecordStore(this.parent, "Transactions", fastDiskAccess);
    }

    void closeTransactionStore() {
        this.setIndex(this.a);
        if (this.rs != null) {
            this.rs.closeRecordStore();
        }
    }

    void closeTransactionStoreWithoutSavingIndex() {
        if (this.rs != null) {
            this.rs.closeRecordStore();
        }
    }

    int getNumTransactions() {
        return this.ht.size();
    }

    int getNumAllTransactions() {
        return this.rs.getNumRecords();
    }

    byte[] toByteArray(Transaction t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeUTF(t.account);
            dos.writeLong(t.longDate);
            dos.writeUTF(t.description);
            dos.writeInt(t.amount);
            dos.writeUTF(t.reference);
            dos.writeUTF(t.category);
            dos.writeBoolean(t.reconciled);
            dos.writeBoolean(t.transferFlag);
            if (t.transferFlag) {
                dos.writeUTF(t.transferAccount);
                dos.writeInt(0);
            }
            dos.writeBoolean(t.splitFlag);
            if (t.splitFlag) {
                dos.writeInt(t.ss.size());
                for (int i = 0; i < t.ss.size(); ++i) {
                    Split s = t.ss.getSplit(i);
                    dos.writeInt(s.amount);
                    dos.writeUTF(s.category);
                }
            }
            dos.close();
        }
        catch (IOException ie) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    Transaction fromByteArray(byte[] bytes) {
        Transaction t = new Transaction();
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            t.account = dis.readUTF();
            t.longDate = dis.readLong();
            t.description = dis.readUTF();
            t.amount = dis.readInt();
            t.reference = dis.readUTF();
            t.category = dis.readUTF();
            t.reconciled = dis.readBoolean();
            t.transferFlag = dis.readBoolean();
            if (t.transferFlag) {
                t.transferAccount = dis.readUTF();
                dis.readInt();
            }
            t.splitFlag = dis.readBoolean();
            if (t.splitFlag) {
                t.ss = new SplitStore();
                int k = dis.readInt();
                for (int i = 0; i < k; ++i) {
                    Split s = new Split();
                    s.amount = dis.readInt();
                    s.category = dis.readUTF();
                    t.ss.addSplit(s);
                }
            }
            dis.close();
        }
        catch (IOException ie) {
            System.err.println(ie + " ts4a");
        }
        return t;
    }

    Transaction getTransaction(int id) {
        Transaction t = new Transaction();
        byte[] bytes = this.rs.getRecord(id);
        t = this.fromByteArray(bytes);
        t.id = id;
        return t;
    }

    void setToStart() {
        this.rs.setToStart();
    }

    Transaction readNextTransaction() {
        Transaction t = new Transaction();
        byte[] bytes = this.rs.readRecord();
        if (bytes == null) {
            return null;
        }
        int id = this.rs.getCurrentFilePosition() - bytes.length - 5;
        t = this.fromByteArray(bytes);
        t.id = id;
        return t;
    }

    Transaction getTransactionFromIndex(int i) {
        int id = ((LongId)this.ht.get((Object)new Integer((int)i))).id;
        return this.getTransaction(id);
    }

    void deleteTransaction(Transaction t) {
        this.rs.deleteRecord(t.id);
    }

    int saveNewTransactionWithoutIndex(Transaction t) {
        t.id = this.rs.getNextRecordID();
        byte[] bytes = this.toByteArray(t);
        this.rs.addRecord(bytes, 0, bytes.length);
        return t.id;
    }

    int saveNewTransaction(Transaction t) {
        t.id = this.rs.getNextRecordID();
        byte[] bytes = this.toByteArray(t);
        this.rs.addRecord(bytes, 0, bytes.length);
        this.addIndex(t);
        return t.id;
    }

    void saveExistingTransaction(Transaction t) {
        byte[] bytes = this.toByteArray(t);
        this.rs.setRecord(t.id, bytes, 0, bytes.length);
    }

    void saveExistingTransaction(Transaction t, boolean movePointer, boolean moveIndex, int index) {
        if (movePointer) {
            this.deleteTransaction(t);
            this.saveNewTransactionWithoutIndex(t);
        } else {
            this.saveExistingTransaction(t);
        }
        if (moveIndex) {
            this.deleteIndex(index);
            this.addIndex(t);
        } else {
            this.updateIndex(index, t);
        }
    }

    void deleteIndex(int index) {
        int n = this.ht.size();
        for (int i = index; i < n - 1; ++i) {
            int j = i + 1;
            LongId longId = (LongId)this.ht.get(new Integer(j));
            this.ht.put(new Integer(i), longId);
        }
        this.ht.remove(new Integer(n - 1));
    }

    boolean isDuplicateTransfer(Transaction t) {
        if (!t.transferFlag) {
            return false;
        }
        boolean found = false;
        int n = this.ht.size();
        long tlong = Utilities.longToDays(t.longDate);
        for (int i = 0; i < n; ++i) {
            LongId li1 = (LongId)this.ht.get(new Integer(i));
            long tlong1 = Utilities.longToDays(li1.lo);
            if (tlong > tlong1) break;
            if (tlong < tlong1 || tlong != tlong1) continue;
            Transaction t1 = this.getTransactionFromIndex(i);
            if (!t1.transferFlag || t.amount != t1.amount || !t.transferAccount.equals(t1.transferAccount)) continue;
            if (t1.reconciled != t.reconciled) {
                t1.reconciled = t.reconciled;
                this.saveExistingTransaction(t1);
            }
            found = true;
            break;
        }
        return found;
    }

    void addIndex(Transaction t) {
        long tlong2;
        LongId li1;
        int i;
        int p = 0;
        int n = this.ht.size();
        long tlong = Utilities.longToDays(t.longDate);
        if (this.normalSortOrder) {
            p = n;
            for (i = 0; i < n; ++i) {
                li1 = (LongId)this.ht.get(new Integer(i));
                tlong2 = Utilities.longToDays(li1.lo);
                if (tlong < tlong2) continue;
                p = i;
                break;
            }
        } else {
            p = 0;
            for (i = n - 1; i >= 0; --i) {
                li1 = (LongId)this.ht.get(new Integer(i));
                tlong2 = Utilities.longToDays(li1.lo);
                if (tlong < tlong2) continue;
                p = i + 1;
                break;
            }
        }
        if (p < n) {
            for (i = n - 1; i >= p; --i) {
                int j = i + 1;
                LongId li2 = (LongId)this.ht.get(new Integer(i));
                this.ht.put(new Integer(j), li2);
            }
        }
        LongId li3 = new LongId(t.longDate, t.id);
        this.ht.put(new Integer(p), li3);
    }

    int findIndex(Transaction t) {
        int n = this.ht.size();
        int j = -1;
        for (int i = 0; i < n; ++i) {
            j = i;
            LongId longId = (LongId)this.ht.get(new Integer(i));
            if (t.id == longId.id) break;
        }
        return j;
    }

    void updateIndex(int index, Transaction t) {
        this.ht.put(new Integer(index), new LongId(t.longDate, t.id));
    }

    void deleteIndex(Transaction t) {
        this.deleteIndex(this.findIndex(t));
    }

    void getIndex(Account a1) {
        this.ht = this.parent.transactionHt.containsKey(a1.name) ? (Hashtable)this.parent.transactionHt.get(a1.name) : new Hashtable();
        this.normalSortOrder = this.parent.normalSortOrder;
        int n = this.ht.size();
        if (n > 1) {
            long tlong2;
            long tlong1 = Utilities.longToDays(((LongId)this.ht.get((Object)new Integer((int)0))).lo);
            if (tlong1 < (tlong2 = Utilities.longToDays(((LongId)this.ht.get((Object)new Integer((int)(n - 1)))).lo))) {
                this.normalSortOrder = false;
            }
            if (tlong1 > tlong2) {
                this.normalSortOrder = true;
            }
        }
    }

    void setIndex(Account a1) {
        if (!a1.name.equals("")) {
            this.parent.transactionHt.put(a1.name, this.ht);
        }
    }

    Vector buildCategoriesFromDates(Date fromDate, Date toDate, Account a1, boolean allAccounts) {
        long longFromDate = Utilities.longToDays(fromDate.getTime());
        long longToDate = Utilities.longToDays(toDate.getTime());
        CategoryStore cs = null;
        cs = this.parent.cv == null ? new CategoryStore(this.parent, true) : this.parent.cv.cs;
        int n = cs.getNumCategories();
        Vector<Integer> v = new Vector<Integer>(n);
        Integer ii = new Integer(0);
        for (int i = 0; i < n; ++i) {
            v.addElement(ii);
        }
        Transaction t1 = null;
        this.setToStart();
        int count = 0;
        while ((t1 = this.readNextTransaction()) != null) {
            long longTransactionDate = Utilities.longToDays(t1.longDate);
            if (longTransactionDate >= longFromDate && longTransactionDate <= longToDate && (allAccounts || a1.name.equals(t1.account)) && !t1.transferFlag) {
                if (t1.splitFlag) {
                    for (int i = 0; i < t1.ss.size(); ++i) {
                        Split s1 = t1.ss.getSplit(i);
                        int index = cs.lookUpIndex(s1.category);
                        int j = (Integer)v.elementAt(index);
                        v.setElementAt(new Integer(j -= s1.amount), index);
                    }
                } else {
                    int index = cs.lookUpIndex(t1.category);
                    int j = (Integer)v.elementAt(index);
                    v.setElementAt(new Integer(j -= t1.amount), index);
                }
            }
            ++count;
        }
        if (this.parent.cv == null) {
            cs.closeCategoryStore();
            cs = null;
        }
        return v;
    }

    int[] buildSelectedCategory(Category c) {
        int[] ints = new int[9];
        CategoryStore cs = null;
        cs = this.parent.cv == null ? new CategoryStore(this.parent, true) : this.parent.cv.cs;
        int n = cs.getNumCategories();
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.parent.todayDate);
        Date date = new Date();
        int todayMonth = cal.get(1) * 12 + cal.get(2);
        int k1 = c.name.indexOf(":");
        for (int i = 0; i < 9; ++i) {
            ints[i] = 0;
        }
        Transaction t1 = null;
        this.setToStart();
        int count = 0;
        while ((t1 = this.readNextTransaction()) != null) {
            date.setTime(t1.longDate);
            cal.setTime(date);
            int tMonth = cal.get(1) * 12 + cal.get(2);
            if (c.name.equals(t1.category)) {
                if (tMonth == todayMonth) {
                    ints[0] = ints[0] - t1.amount;
                }
                if (tMonth == todayMonth - 1) {
                    ints[1] = ints[1] - t1.amount;
                }
                if (tMonth < todayMonth && tMonth >= todayMonth - 3) {
                    ints[2] = ints[2] - t1.amount;
                }
                if (tMonth < todayMonth && tMonth >= todayMonth - 12) {
                    ints[3] = ints[3] - t1.amount;
                }
            }
            int k2 = t1.category.indexOf(":");
            if (k1 > -1 && k2 > -1 && c.name.substring(0, k1).equals(t1.category.substring(0, k2))) {
                ints[4] = ints[4] - t1.amount;
                if (tMonth == todayMonth) {
                    ints[5] = ints[5] - t1.amount;
                }
                if (tMonth == todayMonth - 1) {
                    ints[6] = ints[6] - t1.amount;
                }
                if (tMonth < todayMonth && tMonth >= todayMonth - 3) {
                    ints[7] = ints[7] - t1.amount;
                }
                if (tMonth < todayMonth && tMonth >= todayMonth - 12) {
                    ints[8] = ints[8] - t1.amount;
                }
            }
            if (t1.splitFlag) {
                for (int i = 0; i < t1.ss.size(); ++i) {
                    Split s = t1.ss.getSplit(i);
                    if (c.name.equals(s.category)) {
                        if (tMonth == todayMonth) {
                            ints[0] = ints[0] - s.amount;
                        }
                        if (tMonth == todayMonth - 1) {
                            ints[1] = ints[1] - s.amount;
                        }
                        if (tMonth < todayMonth && tMonth >= todayMonth - 3) {
                            ints[2] = ints[2] - s.amount;
                        }
                        if (tMonth < todayMonth && tMonth >= todayMonth - 12) {
                            ints[3] = ints[3] - s.amount;
                        }
                    }
                    k2 = s.category.indexOf(":");
                    if (k1 <= -1 || k2 <= -1 || !c.name.substring(0, k1).equals(s.category.substring(0, k2))) continue;
                    ints[4] = ints[4] - s.amount;
                    if (tMonth == todayMonth) {
                        ints[5] = ints[5] - s.amount;
                    }
                    if (tMonth == todayMonth - 1) {
                        ints[6] = ints[6] - s.amount;
                    }
                    if (tMonth < todayMonth && tMonth >= todayMonth - 3) {
                        ints[7] = ints[7] - s.amount;
                    }
                    if (tMonth >= todayMonth || tMonth < todayMonth - 12) continue;
                    ints[8] = ints[8] - s.amount;
                }
            }
            if (this.parent.cv == null || ++count != count / 100 * 100) continue;
            this.parent.cv.msg = count + " transactions";
            this.parent.cv.invalidate();
        }
        if (this.parent.cv == null) {
            cs.closeCategoryStore();
            cs = null;
        }
        return ints;
    }

    int futureTransactions(long ldate, String s) {
        int total = 0;
        long futureDate = Utilities.longToDays(ldate);
        int n = this.parent.av.as.getNumAccounts();
        block0: for (int i = 0; i < n; ++i) {
            Account a1 = this.parent.av.as.getAccountFromIndex(i);
            if (!s.equals("All accounts") && !s.equals(a1.name)) continue;
            this.getIndex(a1);
            int n1 = this.ht.size();
            for (int j = 0; j < n1; ++j) {
                int k = j;
                if (!this.normalSortOrder) {
                    k = n1 - 1 - j;
                }
                LongId li1 = (LongId)this.ht.get(new Integer(k));
                long tlong = Utilities.longToDays(li1.lo);
                if (tlong <= this.parent.todayDays) continue block0;
                if (tlong > futureDate) continue;
                Transaction t = this.getTransaction(li1.id);
                total += t.amount;
            }
        }
        return total;
    }

    void changeSortOrder() {
        int i;
        this.normalSortOrder = !this.normalSortOrder;
        int n = this.ht.size();
        Vector<LongId> v = new Vector<LongId>(n);
        for (i = 0; i < n; ++i) {
            v.addElement((LongId)this.ht.get(new Integer(i)));
        }
        Sort.sortLongId(v, 0, n - 1, this.normalSortOrder);
        for (i = 0; i < n; ++i) {
            this.ht.put(new Integer(i), v.elementAt(i));
        }
        v = null;
    }

    int getSize() {
        return this.rs.getSize();
    }
}

