/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Frame;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.AccountStore;
import org.freepoc.Jabp4.Category;
import org.freepoc.Jabp4.CategoryForm;
import org.freepoc.Jabp4.CategoryStore;
import org.freepoc.Jabp4.Currency;
import org.freepoc.Jabp4.CurrencyStore;
import org.freepoc.Jabp4.DateChooser;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.QuickStartForm;
import org.freepoc.Jabp4.Split;
import org.freepoc.Jabp4.SplitForm;
import org.freepoc.Jabp4.SplitStore;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.TransactionStore;
import org.freepoc.Jabp4.TransferForm;
import org.freepoc.Jabp4.Utilities;

public class TransactionForm
extends Component {
    Jabp parent;
    Transaction t;
    String action = "";
    boolean fromQuickStartForm = false;

    public TransactionForm(Jabp context, Transaction transaction, boolean fromQuickStartForm1, String action1) {
        this.parent = context;
        this.action = action1;
        this.parent.lastUsedScreen = 36;
        this.t = transaction;
        this.fromQuickStartForm = fromQuickStartForm1;
        if (this.action.equals("New") || this.action.equals("Copy")) {
            this.createTransaction(this.t);
        }
        if (this.action.equals("Edit")) {
            this.updateTransaction(this.t);
        }
        if (this.action.equals("Delete")) {
            this.deleteTransaction(this.t);
        }
    }

    void createTransaction(Transaction t) {
        DialogManager dm = new DialogManager(this.parent, "New transaction");
        String selectedAccount = t.account;
        if (selectedAccount.equals("")) {
            selectedAccount = this.fromQuickStartForm ? (this.parent.lastQuickStartAccount.equals("") ? this.parent.lastAccount : this.parent.lastQuickStartAccount) : this.parent.lastAccount;
        }
        JComboBox account = null;
        if (this.fromQuickStartForm) {
            account = dm.addJComboBox("Account");
            AccountStore as = null;
            as = this.parent.av == null ? new AccountStore(this.parent, true) : this.parent.av.as;
            Account a = null;
            int n = as.getNumAccounts();
            for (int i = 0; i < n; ++i) {
                a = as.getAccountFromIndex(i);
                dm.addJComboBoxItem(account, a.name);
                if (!a.name.equals(selectedAccount)) continue;
                dm.setSelectedJComboBox(account, i);
                if (!a.type.equals("Cash")) continue;
                t.reconciled = true;
            }
            if (this.parent.av == null) {
                as.closeAccountStore();
            }
        } else if (this.parent.av.as.getAccountFromName((String)selectedAccount).type.equals("Cash")) {
            t.reconciled = true;
        }
        JTextField description = dm.addJTextField("Description", t.description);
        String s = "";
        if (t.amount != 0) {
            s = Utilities.numberToString(Math.abs(t.amount), this.parent.numericEntry, this.parent.isEuropeanNumberFormat, false);
        }
        JTextField amount = dm.addJTextField("Amount", s);
        boolean state = false;
        if (t.amount > 0) {
            state = true;
        }
        CheckboxGroup debitOrCredit = dm.addCheckboxGroup();
        dm.addCheckboxItem("DR/CR", "DR", !state, "CR", state, debitOrCredit);
        JTextField reference = dm.addJTextField("Reference", t.reference);
        if (t.longDate == 0L) {
            t.longDate = this.parent.lastUsedDate.getTime();
        }
        Date date = new Date(t.longDate);
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf2 = null;
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf2 = new SimpleDateFormat("dd/MM/yy HH");
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            sdf = new SimpleDateFormat("MM/dd/yyyy");
            sdf2 = new SimpleDateFormat("MM/dd/yy HH");
        }
        JTextField textDate = dm.addJTextFieldWithButtons("Date", sdf.format(date));
        CheckboxGroup cbIsReconciled = dm.addCheckboxGroup();
        dm.addCheckboxItem("Reconciled", "No", !t.reconciled, "Yes", t.reconciled, cbIsReconciled);
        CheckboxGroup isTransferOrSplit = dm.addCheckboxGroup();
        dm.addCheckboxItem("Type", "Normal", !t.transferFlag && !t.splitFlag, "Transfer", t.transferFlag, "Split", t.splitFlag, isTransferOrSplit);
        JComboBox category = null;
        JList categories = null;
        if (t.splitFlag) {
            categories = dm.addJList("Categories");
        } else {
            category = dm.addJComboBox("Category");
        }
        CategoryStore cs = null;
        cs = this.parent.cv == null ? new CategoryStore(this.parent, true) : this.parent.cv.cs;
        Category c = null;
        int n = cs.getNumCategories();
        if (n == 0) {
            cs.setUpCategories();
            n = cs.getNumCategories();
        }
        for (int i = 0; i < n; ++i) {
            c = cs.getCategoryFromIndex(i);
            if (t.splitFlag) {
                dm.addJListItem(categories, c.name);
                int n1 = t.ss.size();
                if (n1 <= 0) continue;
                for (int j = 0; j < n1; ++j) {
                    Split split = t.ss.getSplit(j);
                    if (!c.name.equals(split.category)) continue;
                    dm.selectJListItem(categories, i);
                }
                continue;
            }
            dm.addJComboBoxItem(category, c.name);
            if (t.category.equals("")) {
                if (!c.name.equals("None")) continue;
                dm.setSelectedJComboBox(category, c.name);
                continue;
            }
            if (!c.name.equals(t.category)) continue;
            dm.setSelectedJComboBox(category, c.name);
        }
        if (this.parent.cv == null) {
            cs.closeCategoryStore();
        }
        JComboBox currency = dm.addJComboBox("Currency");
        CurrencyStore ccys = null;
        ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
        Currency ccy = null;
        n = ccys.getNumCurrencies();
        for (int i = 0; i < n; ++i) {
            ccy = ccys.getCurrencyFromIndex(i);
            dm.addJComboBoxItem(currency, ccy.code);
            if (this.fromQuickStartForm || this.action.equals("Copy")) {
                if (!ccy.code.equals(this.parent.homeCurrency)) continue;
                dm.setSelectedJComboBox(currency, i);
                continue;
            }
            if (!ccy.code.equals(this.parent.av.as.getAccountFromName((String)t.account).currency)) continue;
            dm.setSelectedJComboBox(currency, i);
        }
        if (this.parent.ccyv == null) {
            ccys.closeCurrencyStore();
        }
        dm.addButton("Cancel");
        dm.addButton("New Cat");
        dm.addButton("Match");
        dm.addButton("Create");
        dm.centerShow();
        if (!dm.checkButtons()) {
            dm.dispose();
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            if (this.fromQuickStartForm) {
                this.parent.qsf = new QuickStartForm(this.parent);
            }
            return;
        }
        if (dm.checkButtonText().equals("Create") || dm.checkButtonText().equals(">") || dm.checkButtonText().equals("-") || dm.checkButtonText().equals("+")) {
            if (this.fromQuickStartForm) {
                t.account = dm.getSelectedJComboBoxString(account);
            }
            this.parent.lastAccount = t.account;
            this.parent.lastQuickStartAccount = t.account;
            int foreignAmount = 0;
            s = dm.getUserText(description).trim();
            if (s.equals("")) {
                Toast.makeText(this.parent, "Blank description", 2000).show();
                dm.dispose();
                this.createTransaction(t);
                return;
            }
            t.description = s;
            this.checkForNumericInputType(dm.getUserText(amount));
            t.amount = this.parent.numericEntry ? Utilities.stringToNumber(dm.getUserText(amount), 0, true, this.parent.isEuropeanNumberFormat) : Utilities.expressionToNumber(dm.getUserText(amount), this.parent.isEuropeanNumberFormat);
            if (dm.getSelectedCheckbox(debitOrCredit).getLabel().equals("DR")) {
                t.amount = -t.amount;
            }
            t.reference = dm.getUserText(reference);
            try {
                t.longDate = sdf2.parse(dm.getUserText(textDate) + " 02").getTime();
                this.parent.lastUsedDate.setTime(t.longDate);
            }
            catch (ParseException e) {
                Toast.makeText(this.parent, "Incorrect date", 2000).show();
                t.longDate = date.getTime();
                dm.dispose();
                this.createTransaction(t);
                return;
            }
            boolean previousReconciled = t.reconciled;
            t.reconciled = dm.getSelectedCheckbox(cbIsReconciled).getLabel().equals("Yes");
            boolean previousTransferFlag = t.transferFlag;
            boolean previousSplitFlag = t.splitFlag;
            if (dm.getSelectedCheckbox(isTransferOrSplit).getLabel().equals("Normal")) {
                t.splitFlag = false;
                t.transferFlag = false;
            }
            if (dm.getSelectedCheckbox(isTransferOrSplit).getLabel().equals("Transfer")) {
                t.transferFlag = true;
                t.splitFlag = false;
            }
            if (dm.getSelectedCheckbox(isTransferOrSplit).getLabel().equals("Split")) {
                t.transferFlag = false;
                t.splitFlag = true;
            }
            if (!t.splitFlag && previousSplitFlag) {
                dm.dispose();
                t.ss = null;
                this.createTransaction(t);
                return;
            }
            if (t.splitFlag && !previousSplitFlag) {
                dm.dispose();
                t.ss = new SplitStore();
                this.createTransaction(t);
                return;
            }
            String selectedCategory = "";
            if (!t.transferFlag && !t.splitFlag) {
                t.category = selectedCategory = dm.getSelectedJComboBoxString(category);
            }
            String selectedCurrency = dm.getSelectedJComboBoxString(currency);
            if (dm.checkButtonText().equals(">")) {
                GregorianCalendar gc = new GregorianCalendar();
                gc.setTimeInMillis(t.longDate);
                DateChooser dc = new DateChooser((Frame)this.parent, gc);
                if (dc.showDateChooser() == 1) {
                    gc = dc.getDate();
                }
                t.longDate = gc.getTimeInMillis();
                dm.dispose();
                this.createTransaction(t);
                return;
            }
            if (dm.checkButtonText().equals("-")) {
                t.longDate -= 86400000L;
                dm.dispose();
                this.createTransaction(t);
                return;
            }
            if (dm.checkButtonText().equals("+")) {
                t.longDate += 86400000L;
                dm.dispose();
                this.createTransaction(t);
                return;
            }
            if (!selectedCurrency.equals(this.parent.homeCurrency)) {
                t.reference = t.reference.equals("") ? selectedCurrency + " " + Utilities.numberToString(Math.abs(t.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) : selectedCurrency + " " + Utilities.numberToString(Math.abs(t.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + "|" + t.reference;
                ccys = null;
                ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
                ccy = ccys.getCurrencyFromName(selectedCurrency);
                foreignAmount = t.amount;
                t.amount = Utilities.foreignToHome(t.amount, ccy.rate);
                ccy = null;
                if (this.parent.ccyv == null) {
                    ccys.closeCurrencyStore();
                    ccys = null;
                }
            }
            if (t.transferFlag) {
                dm.dispose();
                new TransferForm(this.parent, t, 0, this.fromQuickStartForm);
                return;
            }
            if (t.splitFlag) {
                SplitStore ss = new SplitStore();
                for (int i = 0; i < categories.getModel().getSize(); ++i) {
                    if (!dm.isJListIndexSelected(categories, i)) continue;
                    Split split = new Split();
                    split.category = dm.getSelectedJListString(categories, i);
                    ss.addSplit(split);
                }
                if (ss.size() == 0) {
                    Toast.makeText(this.parent, "No category selected", 2000).show();
                    dm.dispose();
                    this.createTransaction(t);
                    return;
                }
                if (ss.size() == 1) {
                    t.splitFlag = false;
                    t.category = ss.getSplit((int)0).category;
                    this.parent.showMatchedCategories = "";
                    this.parent.storeMatchedPosition = 0;
                    this.parent.matchedString = "";
                    if (this.fromQuickStartForm) {
                        this.parent.newTransaction(t);
                        this.parent.lastCreatedTransaction = t;
                        Toast.makeText(this.parent, "Transaction created", 2000).show();
                        this.parent.qsf = new QuickStartForm(this.parent);
                    } else {
                        this.parent.tv.newTransaction(t);
                        Toast.makeText(this.parent, "Transaction created", 2000).show();
                        this.parent.setContentView(this.parent.tv);
                    }
                    return;
                }
                t.ss = ss;
                dm.dispose();
                this.parent.sf = new SplitForm(this.parent, t, 0, selectedCurrency, foreignAmount, this.fromQuickStartForm, "New");
                return;
            }
            t.category = selectedCategory;
            this.parent.showMatchedCategories = "";
            this.parent.storeMatchedPosition = 0;
            this.parent.matchedString = "";
            if (this.fromQuickStartForm) {
                this.parent.newTransaction(t);
                this.parent.lastCreatedTransaction = t;
                Toast.makeText(this.parent, "Transaction created", 1000).show();
                this.parent.qsf = new QuickStartForm(this.parent);
            } else {
                this.parent.tv.newTransaction(t);
                Toast.makeText(this.parent, "Transaction created", 1000).show();
            }
            dm.dispose();
            return;
        }
        if (dm.checkButtonText().equals("Match")) {
            if (this.fromQuickStartForm) {
                t.account = selectedAccount;
            }
            if ((s = dm.getUserText(description).trim()).equals("")) {
                Toast.makeText(this.parent, "Blank description", 2000).show();
                dm.dispose();
                this.createTransaction(t);
                return;
            }
            t.description = s;
            AccountStore as = null;
            as = this.parent.av == null ? new AccountStore(this.parent, true) : this.parent.av.as;
            Account a = as.getAccountFromName(t.account);
            TransactionStore ts = null;
            ts = this.parent.tv == null ? new TransactionStore(this.parent, a, true) : this.parent.tv.ts;
            int numItems = ts.getNumTransactions();
            if (this.parent.storeMatchedPosition == 0) {
                this.parent.matchedString = t.description.toUpperCase();
            }
            if (t.description.length() < this.parent.matchedString.length()) {
                this.parent.matchedString = t.description.toUpperCase();
                this.parent.storeMatchedPosition = 0;
            } else if (!t.description.toUpperCase().contains(this.parent.matchedString)) {
                this.parent.matchedString = t.description.toUpperCase();
                this.parent.storeMatchedPosition = 0;
            }
            int m = Math.min(numItems, this.parent.storeMatchedPosition + this.parent.matchDescriptionNumber);
            boolean matchFlag = false;
            Transaction t2 = new Transaction();
            if (this.parent.storeMatchedPosition <= numItems) {
                for (int i = this.parent.storeMatchedPosition; i < m; ++i) {
                    int j = i;
                    if (!ts.normalSortOrder) {
                        j = numItems - 1 - i;
                    }
                    t2 = ts.getTransactionFromIndex(j);
                    if (this.parent.matchedString.length() > t2.description.length()) continue;
                    if (this.parent.matchDescriptionAnywhere) {
                        if (!t2.description.toUpperCase().contains(this.parent.matchedString)) continue;
                        t2.longDate = this.parent.lastUsedDate.getTime();
                        if (this.fromQuickStartForm && this.parent.hideAmountsInQuickStart) {
                            t2.amount = 0;
                        }
                        t2.reconciled = false;
                        if (a.type.equals("Cash")) {
                            t2.reconciled = true;
                        }
                        this.parent.storeMatchedPosition = i + 1;
                        matchFlag = true;
                        break;
                    }
                    if (!t2.description.toUpperCase().substring(0, this.parent.matchedString.length()).equals(this.parent.matchedString)) continue;
                    t2.longDate = this.parent.lastUsedDate.getTime();
                    if (this.fromQuickStartForm && this.parent.hideAmountsInQuickStart) {
                        t2.amount = 0;
                    }
                    t2.reconciled = false;
                    if (a.type.equals("Cash")) {
                        t2.reconciled = true;
                    }
                    this.parent.storeMatchedPosition = i + 1;
                    matchFlag = true;
                    break;
                }
            }
            if (this.parent.tv == null) {
                ts.closeTransactionStore();
                ts = null;
            }
            if (this.parent.av == null) {
                as.closeAccountStore();
                as = null;
            }
            if (!matchFlag) {
                this.parent.storeMatchedPosition += this.parent.matchDescriptionNumber;
                if (this.parent.storeMatchedPosition >= numItems) {
                    this.parent.storeMatchedPosition = 0;
                    this.parent.matchedString = "";
                    Toast.makeText(this.parent, "Not matched in this account", 2000).show();
                } else {
                    Toast.makeText(this.parent, "Not matched in " + this.parent.storeMatchedPosition + " entries", 2000).show();
                }
                dm.dispose();
                this.createTransaction(t);
                return;
            }
            Toast.makeText(this.parent, "Matched", 1000).show();
            dm.dispose();
            this.createTransaction(t2);
            return;
        }
        if (dm.checkButtonText().equals("New Cat")) {
            t.description = dm.getUserText(description).trim();
            t.amount = this.parent.numericEntry ? Utilities.stringToNumber(dm.getUserText(amount), 0, true, this.parent.isEuropeanNumberFormat) : Utilities.expressionToNumber(dm.getUserText(amount), this.parent.isEuropeanNumberFormat);
            if (dm.getSelectedCheckbox(debitOrCredit).getLabel().equals("DR")) {
                t.amount = -t.amount;
            }
            t.reference = dm.getUserText(reference);
            try {
                t.longDate = sdf2.parse(dm.getUserText(textDate) + " 02").getTime();
                this.parent.lastUsedDate.setTime(t.longDate);
            }
            catch (ParseException e) {
                Toast.makeText(this.parent, "Incorrect date", 2000).show();
                t.longDate = date.getTime();
                dm.dispose();
                this.createTransaction(t);
                return;
            }
            t.reconciled = dm.getSelectedCheckbox(cbIsReconciled).getLabel().equals("Yes");
            new CategoryForm(this.parent, new Category(), true, "New");
            if (!this.parent.lastCategory.equals("")) {
                t.category = this.parent.lastCategory;
            }
            dm.dispose();
            this.createTransaction(t);
            return;
        }
    }

    void updateTransaction(Transaction t) {
        String selectedCurrency;
        DialogManager dm = new DialogManager(this.parent, "Edit transaction");
        String selectedAccount = t.account;
        if (selectedAccount.equals("")) {
            selectedAccount = this.fromQuickStartForm ? (this.parent.lastQuickStartAccount.equals("") ? this.parent.lastAccount : this.parent.lastQuickStartAccount) : this.parent.lastAccount;
        }
        JComboBox account = null;
        if (this.fromQuickStartForm) {
            account = dm.addJComboBox("Account");
            AccountStore as = null;
            as = this.parent.av == null ? new AccountStore(this.parent, true) : this.parent.av.as;
            Account a = null;
            int n = as.getNumAccounts();
            for (int i = 0; i < n; ++i) {
                a = as.getAccountFromIndex(i);
                dm.addJComboBoxItem(account, a.name);
                if (!a.name.equals(selectedAccount)) continue;
                dm.setSelectedJComboBox(account, i);
            }
            if (this.parent.av == null) {
                as.closeAccountStore();
            }
        }
        JTextField description = dm.addJTextField("Description", t.description);
        String s = "";
        if (t.amount != 0) {
            s = Utilities.numberToString(Math.abs(t.amount), this.parent.numericEntry, this.parent.isEuropeanNumberFormat, false);
        }
        JTextField amount = dm.addJTextField("Amount", s);
        boolean state = false;
        if (t.amount > 0) {
            state = true;
        }
        CheckboxGroup debitOrCredit = dm.addCheckboxGroup();
        dm.addCheckboxItem("DR/CR", "DR", !state, "CR", state, debitOrCredit);
        JTextField reference = dm.addJTextField("Reference", t.reference);
        if (t.longDate == 0L) {
            t.longDate = this.parent.lastUsedDate.getTime();
        }
        Date date = new Date(t.longDate);
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf2 = null;
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf2 = new SimpleDateFormat("dd/MM/yy HH");
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            sdf = new SimpleDateFormat("MM/dd/yyyy");
            sdf2 = new SimpleDateFormat("MM/dd/yy HH");
        }
        JTextField textDate = dm.addJTextFieldWithButtons("Date", sdf.format(date));
        CheckboxGroup cbIsReconciled = dm.addCheckboxGroup();
        dm.addCheckboxItem("Reconciled", "No", !t.reconciled, "Yes", t.reconciled, cbIsReconciled);
        CheckboxGroup isTransferOrSplit = dm.addCheckboxGroup();
        dm.addCheckboxItem("Type", "Normal", !t.transferFlag && !t.splitFlag, "Transfer", t.transferFlag, "Split", t.splitFlag, isTransferOrSplit);
        JComboBox category = null;
        JList categories = null;
        if (t.splitFlag) {
            categories = dm.addJList("Categories");
        } else {
            category = dm.addJComboBox("Category");
        }
        CategoryStore cs = null;
        cs = this.parent.cv == null ? new CategoryStore(this.parent, true) : this.parent.cv.cs;
        Category c = null;
        int n = cs.getNumCategories();
        if (n == 0) {
            cs.setUpCategories();
            n = cs.getNumCategories();
        }
        for (int i = 0; i < n; ++i) {
            c = cs.getCategoryFromIndex(i);
            if (t.splitFlag) {
                dm.addJListItem(categories, c.name);
                int n1 = t.ss.size();
                if (n1 <= 0) continue;
                for (int j = 0; j < n1; ++j) {
                    Split split = t.ss.getSplit(j);
                    if (!c.name.equals(split.category)) continue;
                    dm.selectJListItem(categories, i);
                }
                continue;
            }
            dm.addJComboBoxItem(category, c.name);
            if (t.category.equals("")) {
                if (!c.name.equals("None")) continue;
                dm.setSelectedJComboBox(category, c.name);
                continue;
            }
            if (!c.name.equals(t.category)) continue;
            dm.setSelectedJComboBox(category, c.name);
        }
        if (this.parent.cv == null) {
            cs.closeCategoryStore();
        }
        JComboBox currency = dm.addJComboBox("Currency");
        CurrencyStore ccys = null;
        ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
        Currency ccy = null;
        n = ccys.getNumCurrencies();
        for (int i = 0; i < n; ++i) {
            ccy = ccys.getCurrencyFromIndex(i);
            dm.addJComboBoxItem(currency, ccy.code);
            if (this.fromQuickStartForm) {
                if (!ccy.code.equals(this.parent.homeCurrency)) continue;
                dm.setSelectedJComboBox(currency, i);
                continue;
            }
            if (!ccy.code.equals(this.parent.av.as.getAccountFromName((String)t.account).currency)) continue;
            dm.setSelectedJComboBox(currency, i);
        }
        if (this.parent.ccyv == null) {
            ccys.closeCurrencyStore();
        }
        dm.addButton("Cancel");
        dm.addButton("Update");
        dm.centerShow();
        if (!dm.checkButtons()) {
            dm.dispose();
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            return;
        }
        if (this.fromQuickStartForm) {
            t.account = selectedAccount;
        }
        this.parent.lastAccount = t.account;
        this.parent.lastQuickStartAccount = t.account;
        int foreignAmount = 0;
        s = dm.getUserText(description).trim();
        if (s.equals("")) {
            Toast.makeText(this.parent, "Blank description", 2000).show();
            dm.dispose();
            this.updateTransaction(t);
            return;
        }
        t.description = s;
        this.checkForNumericInputType(dm.getUserText(amount));
        t.amount = this.parent.numericEntry ? Utilities.stringToNumber(dm.getUserText(amount), 0, true, this.parent.isEuropeanNumberFormat) : Utilities.expressionToNumber(dm.getUserText(amount), this.parent.isEuropeanNumberFormat);
        if (dm.getSelectedCheckbox(debitOrCredit).getLabel().equals("DR")) {
            t.amount = -t.amount;
        }
        t.reference = dm.getUserText(reference);
        try {
            t.longDate = sdf2.parse(dm.getUserText(textDate) + " 02").getTime();
            this.parent.lastUsedDate.setTime(t.longDate);
        }
        catch (ParseException e) {
            Toast.makeText(this.parent, "Incorrect date", 2000).show();
            t.longDate = date.getTime();
            dm.dispose();
            this.updateTransaction(t);
            return;
        }
        boolean previousReconciled = t.reconciled;
        t.reconciled = dm.getSelectedCheckbox(cbIsReconciled).getLabel().equals("Yes");
        boolean previousTransferFlag = t.transferFlag;
        boolean previousSplitFlag = t.splitFlag;
        if (dm.getSelectedCheckbox(isTransferOrSplit).getLabel().equals("Normal")) {
            t.splitFlag = false;
            t.transferFlag = false;
        }
        if (dm.getSelectedCheckbox(isTransferOrSplit).getLabel().equals("Transfer")) {
            t.transferFlag = true;
            t.splitFlag = false;
        }
        if (t.transferFlag && !previousTransferFlag || !t.transferFlag && previousTransferFlag) {
            Toast.makeText(this.parent, "Cannot change transfer status\nPlease delete and re-enter", 2000).show();
            dm.dispose();
            this.updateTransaction(t);
            return;
        }
        if (dm.getSelectedCheckbox(isTransferOrSplit).getLabel().equals("Split")) {
            t.transferFlag = false;
            t.splitFlag = true;
        }
        if (!t.splitFlag && previousSplitFlag) {
            dm.dispose();
            t.ss = null;
            this.updateTransaction(t);
            return;
        }
        if (t.splitFlag && !previousSplitFlag) {
            dm.dispose();
            t.ss = new SplitStore();
            this.updateTransaction(t);
            return;
        }
        String selectedCategory = "";
        if (!t.transferFlag && !t.splitFlag) {
            t.category = selectedCategory = dm.getSelectedJComboBoxString(category);
        }
        if (!(selectedCurrency = dm.getSelectedJComboBoxString(currency)).equals(this.parent.homeCurrency)) {
            t.reference = t.reference.equals("") ? selectedCurrency + " " + Utilities.numberToString(Math.abs(t.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) : selectedCurrency + " " + Utilities.numberToString(Math.abs(t.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + "|" + t.reference;
            ccys = null;
            ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
            ccy = ccys.getCurrencyFromName(selectedCurrency);
            foreignAmount = t.amount;
            t.amount = Utilities.foreignToHome(t.amount, ccy.rate);
            ccy = null;
            if (this.parent.ccyv == null) {
                ccys.closeCurrencyStore();
                ccys = null;
            }
        }
        if (t.transferFlag && !previousTransferFlag || !t.transferFlag && previousTransferFlag) {
            Toast.makeText(this.parent, "Cannot change transfer status\nPlease delete and re-enter", 2000).show();
            dm.dispose();
            this.updateTransaction(t);
            return;
        }
        if (dm.checkButtonText().equals(">")) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis(t.longDate);
            DateChooser dc = new DateChooser((Frame)this.parent, gc);
            if (dc.showDateChooser() == 1) {
                gc = dc.getDate();
            }
            t.longDate = gc.getTimeInMillis();
            dm.dispose();
            this.updateTransaction(t);
            return;
        }
        if (dm.checkButtonText().equals("-")) {
            t.longDate -= 86400000L;
            dm.dispose();
            this.updateTransaction(t);
            return;
        }
        if (dm.checkButtonText().equals("+")) {
            t.longDate += 86400000L;
            dm.dispose();
            this.updateTransaction(t);
            return;
        }
        if (t.transferFlag) {
            this.parent.tv.editTransaction(t, false);
            Toast.makeText(this.parent, "Transaction updated", 2000).show();
            this.parent.setContentView(this.parent.tv);
            dm.dispose();
            return;
        }
        if (t.splitFlag) {
            int i;
            SplitStore ss = new SplitStore();
            for (i = 0; i < categories.getModel().getSize(); ++i) {
                if (!dm.isJListIndexSelected(categories, i)) continue;
                Split split = new Split();
                split.category = dm.getSelectedJListString(categories, i);
                ss.addSplit(split);
            }
            if (ss.size() == 0) {
                Toast.makeText(this.parent, "No category selected", 2000).show();
                dm.dispose();
                this.updateTransaction(t);
                return;
            }
            if (ss.size() == 1) {
                t.splitFlag = false;
                t.category = ss.getSplit((int)0).category;
                this.parent.tv.editTransaction(t, false);
                this.parent.setContentView(this.parent.tv);
                Toast.makeText(this.parent, "Transaction updated", 2000).show();
                dm.dispose();
                return;
            }
            if (t.ss != null) {
                for (i = 0; i < ss.size(); ++i) {
                    Split sNew = ss.getSplit(i);
                    for (int j = 0; j < t.ss.size(); ++j) {
                        Split sOld = t.ss.getSplit(j);
                        if (!sNew.category.equals(sOld.category)) continue;
                        sNew.amount = sOld.amount;
                        ss.setSplit(sNew, i);
                    }
                }
            }
            t.ss = ss;
            this.parent.sf = new SplitForm(this.parent, t, 0, selectedCurrency, foreignAmount, this.fromQuickStartForm, "Edit");
            dm.dispose();
            return;
        }
        t.category = selectedCategory;
        this.parent.tv.editTransaction(t, false);
        Toast.makeText(this.parent, "Transaction updated", 1000).show();
        dm.dispose();
    }

    void deleteTransaction(Transaction t) {
        DialogManager dm = new DialogManager(this.parent, "Delete transaction");
        JTextField description = dm.addJTextField("Description", t.description);
        String s = "";
        if (t.amount != 0) {
            s = Utilities.numberToString(Math.abs(t.amount), this.parent.numericEntry, this.parent.isEuropeanNumberFormat, false);
        }
        JTextField amount = dm.addJTextField("Amount", s);
        boolean state = false;
        if (t.amount > 0) {
            state = true;
        }
        CheckboxGroup debitOrCredit = dm.addCheckboxGroup();
        dm.addCheckboxItem("DR/CR", "DR", !state, "CR", state, debitOrCredit);
        JTextField reference = dm.addJTextField("Reference", t.reference);
        if (t.longDate == 0L) {
            t.longDate = this.parent.lastUsedDate.getTime();
        }
        Date date = new Date(t.longDate);
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf2 = null;
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf2 = new SimpleDateFormat("dd/MM/yy HH");
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            sdf = new SimpleDateFormat("MM/dd/yyyy");
            sdf2 = new SimpleDateFormat("MM/dd/yy HH");
        }
        JTextField textDate = dm.addJTextFieldWithButton("Date", sdf.format(date), ">");
        CheckboxGroup isReconciled = dm.addCheckboxGroup();
        dm.addCheckboxItem("Reconciled", "No", !t.reconciled, "Yes", t.reconciled, isReconciled);
        CheckboxGroup isTransferOrSplit = dm.addCheckboxGroup();
        dm.addCheckboxItem("Type", "Normal", !t.transferFlag && !t.splitFlag, "Transfer", t.transferFlag, "Split", t.splitFlag, isTransferOrSplit);
        JComboBox category = null;
        JList categories = null;
        if (t.splitFlag) {
            categories = dm.addJList("Categories");
        } else {
            category = dm.addJComboBox("Category");
        }
        CategoryStore cs = null;
        cs = this.parent.cv == null ? new CategoryStore(this.parent, true) : this.parent.cv.cs;
        Category c = null;
        int n = cs.getNumCategories();
        if (n == 0) {
            cs.setUpCategories();
            n = cs.getNumCategories();
        }
        for (int i = 0; i < n; ++i) {
            c = cs.getCategoryFromIndex(i);
            if (t.splitFlag) {
                dm.addJListItem(categories, c.name);
                int n1 = t.ss.size();
                if (n1 <= 0) continue;
                for (int j = 0; j < n1; ++j) {
                    Split split = t.ss.getSplit(j);
                    if (!c.name.equals(split.category)) continue;
                    dm.selectJListItem(categories, i);
                }
                continue;
            }
            dm.addJComboBoxItem(category, c.name);
            if (t.category.equals("")) {
                if (!c.name.equals("None")) continue;
                dm.setSelectedJComboBox(category, c.name);
                continue;
            }
            if (!c.name.equals(t.category)) continue;
            dm.setSelectedJComboBox(category, c.name);
        }
        if (this.parent.cv == null) {
            cs.closeCategoryStore();
        }
        JComboBox currency = dm.addJComboBox("Currency");
        CurrencyStore ccys = null;
        ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
        Currency ccy = null;
        n = ccys.getNumCurrencies();
        for (int i = 0; i < n; ++i) {
            ccy = ccys.getCurrencyFromIndex(i);
            dm.addJComboBoxItem(currency, ccy.code);
            if (this.fromQuickStartForm) {
                if (!ccy.code.equals(this.parent.homeCurrency)) continue;
                dm.setSelectedJComboBox(currency, i);
                continue;
            }
            if (!ccy.code.equals(this.parent.av.as.getAccountFromName((String)t.account).currency)) continue;
            dm.setSelectedJComboBox(currency, i);
        }
        if (this.parent.ccyv == null) {
            ccys.closeCurrencyStore();
        }
        dm.addButton("Cancel");
        dm.addButton("Delete");
        if (this.parent.syncMode) {
            dm.addButton("Delete (no sync)");
        }
        dm.centerShow();
        if (!dm.checkButtons()) {
            dm.dispose();
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            return;
        }
        if (dm.checkButtonText().equals("Delete")) {
            this.parent.tv.deleteTransaction(t);
            Toast.makeText(this.parent, "Transaction deleted", 1000).show();
            dm.dispose();
            return;
        }
        if (dm.checkButtonText().equals("Delete (no sync)")) {
            this.parent.tv.deleteTransaction(t, false);
            Toast.makeText(this.parent, "Transaction deleted", 1000).show();
            dm.dispose();
            return;
        }
    }

    void checkForNumericInputType(String s) {
        if (s.contains(".")) {
            this.parent.numericEntry = false;
            this.parent.isEuropeanNumberFormat = false;
        }
        if (s.contains(",")) {
            this.parent.numericEntry = false;
            this.parent.isEuropeanNumberFormat = true;
        }
    }
}

