/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import org.freepoc.Jabp4.Category;
import org.freepoc.Jabp4.CategoryStore;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.Sort;
import org.freepoc.Jabp4.Utilities;

public class TopExpensesView
extends Canvas
implements ActionListener,
KeyListener,
MouseListener {
    Jabp parent;
    Vector canvasMenu;
    boolean filterFlag;
    Vector filterVector;
    Font font;
    FontMetrics fm;
    Graphics g1;
    Image image;
    Point point;
    boolean showCanvasMenu = false;
    boolean showingPopupMenu = false;
    boolean calculateCanvasMenuPosition = true;
    boolean oneClickFlag;
    boolean start;
    int numMenuItems;
    int startMenuPos;
    int currentMenuPos;
    int menuWidth;
    int menuHeight;
    int menuWidthPos;
    int menuHeightPos;
    int fs;
    int width;
    int height;
    int lastDragX;
    int numItemsPage;
    int lineHeight;
    int fontHeight;
    int fontWidth;
    int numberWidth;
    int nameWidth;
    int amountPosition;
    int currentX;
    int currentY;
    int totalExpenses;
    long timePointerOnScreen;

    public TopExpensesView(Jabp context, boolean filterFlag1, Vector filterVector1) {
        this.parent = context;
        this.filterFlag = filterFlag1;
        if (this.filterFlag) {
            this.filterVector = filterVector1;
        }
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.font = new Font(this.parent.fontName, this.parent.fontWeight, this.parent.fontSize);
        this.setFont(this.font);
        this.fm = this.getFontMetrics(this.font);
        this.fontHeight = this.parent.fontHeight;
        this.lineHeight = this.fontHeight + this.parent.lineSpacing * 2;
        this.setupCanvasMenu();
        this.currentX = 0;
        this.currentY = this.lineHeight;
        this.start = true;
        this.oneClickFlag = false;
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    @Override
    public void paint(Graphics g) {
        if (this.start) {
            this.start = false;
        }
        this.parent.lastUsedScreen = 8;
        this.setPositions();
        this.g1.clearRect(0, 0, this.width, this.height);
        this.g1.setFont(this.font);
        this.showHeader();
        this.showPage();
        this.showFooter();
        if (this.parent.useCanvasMenu && this.showCanvasMenu) {
            this.displayCanvasMenu();
        }
        g.drawImage(this.image, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    void showPage() {
        this.currentY = this.lineHeight;
        this.g1.setColor(new Color(this.parent.colorBackground));
        this.g1.fillRect(0, this.lineHeight, this.width, this.height - this.lineHeight * 2);
        this.g1.setColor(new Color(this.parent.colorFont));
        Vector<Category> v = new Vector<Category>();
        CategoryStore cs = null;
        cs = this.parent.cv == null ? new CategoryStore(this.parent, true) : this.parent.cv.cs;
        int n = cs.getNumCategories();
        this.totalExpenses = 0;
        for (int i = 0; i < n; ++i) {
            Category c = cs.getCategoryFromIndex(i);
            if (this.filterFlag) {
                c.current = (Integer)this.filterVector.elementAt(i);
            }
            v.addElement(c);
            if (c.current <= 0) continue;
            this.totalExpenses += c.current;
        }
        if (this.parent.cv == null) {
            cs.closeCategoryStore();
            cs = null;
        }
        Sort.sortCategory(v, 0, n - 1, true);
        int n1 = Math.min(n, this.numItemsPage);
        for (int i = 0; i < n1; ++i) {
            Category c = (Category)v.elementAt(i);
            if (c.current < 0 || this.currentY + this.lineHeight > this.height - this.lineHeight) continue;
            this.buildLine(c.name, c.current);
        }
        v = null;
    }

    void showHeader() {
        int vpos = this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorHeading));
        this.g1.fillRect(0, 0, this.width, this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        String s = "Top Expenses";
        if (this.filterFlag) {
            s = s + "[*]";
        }
        this.g1.drawString(s, this.parent.widthAdjustment, vpos);
        this.g1.drawString("Amount", this.amountPosition + this.numberWidth - this.fm.stringWidth("Amount"), vpos);
    }

    void showFooter() {
        int vpos = this.height - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorHeading));
        this.g1.fillRect(0, this.height - this.lineHeight, this.width, this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        this.g1.drawString("Total Expenses", this.parent.widthAdjustment, vpos);
        if (this.totalExpenses < 0) {
            this.g1.setColor(new Color(this.parent.colorNegative));
        }
        String s = Utilities.numberToString(this.totalExpenses, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        this.g1.drawString(s, this.amountPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
    }

    void buildLine(String s, int p) {
        int vpos = this.currentY + this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorFont));
        int j = s.length();
        for (int i = 0; i < j; ++i) {
            int k = j - i;
            if (this.fm.stringWidth(s.substring(0, k)) > this.nameWidth) continue;
            this.g1.drawString(s.substring(0, k), this.parent.widthAdjustment, vpos);
            break;
        }
        if (p < 0) {
            this.g1.setColor(new Color(this.parent.colorNegative));
        }
        String s1 = Utilities.numberToString(p, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        this.g1.drawString(s1, this.amountPosition + this.numberWidth - this.fm.stringWidth(s1), vpos);
        this.currentY += this.lineHeight;
    }

    void setPositions() {
        this.fontHeight = this.parent.fontHeight;
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.image = this.createImage(this.width, this.height);
        this.g1 = this.image.getGraphics();
        Utilities.enableAntialiasing(this.g1);
        if (this.parent.lineSpacing == 0) {
            this.parent.lineSpacing = this.fontHeight / 5;
        }
        this.lineHeight = this.fontHeight + this.parent.lineSpacing * 2;
        this.numItemsPage = this.height / this.lineHeight - 2;
        this.numberWidth = this.parent.isGroupingUsed ? this.fm.stringWidth("999,999.99") : this.fm.stringWidth("999999.99");
        this.nameWidth = this.width - this.numberWidth - this.parent.widthAdjustment * 2 - 10;
        this.amountPosition = this.nameWidth + this.parent.widthAdjustment + 10;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int j;
        String s = ae.getSource().toString();
        String s1 = s.substring((j = s.indexOf("[")) + 1, j + 5);
        if (s1.equals("menu")) {
            MenuItem mi = (MenuItem)ae.getSource();
            this.commandAction(mi.getLabel());
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.point = me.getPoint();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.point = me.getPoint();
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.point = me.getPoint();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        this.lastDragX = x;
        this.calculateCanvasMenuPosition = true;
        if (this.showCanvasMenu) {
            this.calculateCanvasMenuPosition = false;
            this.currentMenuPos = (y - this.menuHeightPos) / this.lineHeight;
            this.repaint();
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        if (Math.abs(this.lastDragX - x) > 100) {
            this.commandAction("Close");
            return;
        }
        if (this.showCanvasMenu) {
            this.showCanvasMenu = false;
            this.repaint();
            if (x < this.menuWidthPos || x > this.menuWidthPos + this.menuWidth || y < this.menuHeightPos || y > this.menuHeightPos + this.menuHeight) {
                this.setupCanvasMenu();
                return;
            }
            int k = (y - this.menuHeightPos) / this.lineHeight + this.startMenuPos;
            this.processMenuCommand(k);
            return;
        }
        if (this.parent.useCanvasMenu) {
            this.showCanvasMenu = true;
            this.repaint();
        } else {
            this.displayPopupMenu();
        }
    }

    void displayPopupMenu() {
        if (this.showingPopupMenu) {
            this.showingPopupMenu = false;
            return;
        }
        PopupMenu pm = new PopupMenu();
        MenuItem miClose = new MenuItem("Close");
        miClose.addActionListener(this);
        pm.add(miClose);
        MenuItem miExit = new MenuItem("Exit");
        miExit.addActionListener(this);
        pm.add(miExit);
        this.add(pm);
        int x = 0;
        int y = 0;
        if (this.point == null) {
            pm.show(this, x, y);
        } else {
            pm.show(this, x + this.point.x, y + this.point.y);
        }
        this.showingPopupMenu = true;
    }

    void setupCanvasMenu() {
        this.startMenuPos = 0;
        this.currentMenuPos = 0;
        this.canvasMenu = new Vector(2);
        this.canvasMenu.addElement("Close");
        this.canvasMenu.addElement("Exit");
        this.menuWidth = this.fm.stringWidth("Close") + 6;
    }

    void displayCanvasMenu() {
        this.numMenuItems = this.canvasMenu.size();
        this.menuWidthPos = (this.width - this.menuWidth) / 2;
        if (this.menuWidthPos < 0) {
            this.menuWidthPos = 0;
        }
        this.menuHeightPos = (this.height - this.lineHeight * 2 - this.numMenuItems * this.lineHeight) / 2;
        if (this.menuHeightPos < this.lineHeight) {
            this.menuHeightPos = this.lineHeight;
        }
        this.menuHeight = Math.min(this.height - this.lineHeight * 2, this.numMenuItems * this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorMessage));
        this.g1.fillRect(this.menuWidthPos, this.menuHeightPos, this.menuWidth, this.menuHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        for (int i = 0; i < this.numItemsPage && i + this.startMenuPos <= this.numMenuItems - 1; ++i) {
            int vpos = i * this.lineHeight + this.lineHeight + this.menuHeightPos - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
            if (i == this.currentMenuPos) {
                this.g1.setColor(new Color(this.parent.colorCursor));
                this.g1.fillRect(this.menuWidthPos, this.lineHeight * i + this.menuHeightPos, this.menuWidth, this.lineHeight);
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            this.g1.drawString((String)this.canvasMenu.elementAt(i + this.startMenuPos), this.menuWidthPos + 3, vpos);
        }
    }

    void processMenuCommand(int k) {
        this.invalidate();
        this.commandAction((String)this.canvasMenu.elementAt(k));
    }

    void commandAction(String cmd) {
        this.showingPopupMenu = false;
        if (cmd.equals("Close")) {
            this.parent.setContentView(this.parent.cv);
            return;
        }
        if (cmd.equals("Exit")) {
            this.parent.finishAndQuit();
            return;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if ((e.getKeyCode() == 10 || e.getKeyCode() == 525) && e.getKeyCode() == 525) {
            this.displayPopupMenu();
        }
        if (e.getKeyCode() == 27) {
            this.parent.onBackPressed();
            return;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

