/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.RecordStore;

public class SyncStore {
    RecordStore rs;
    Jabp parent;

    public SyncStore(Jabp context, boolean fastDiskAccess) {
        this.parent = context;
        this.openSyncStore(fastDiskAccess);
    }

    void openSyncStore(boolean fastDiskAccess) {
        this.rs = new RecordStore(this.parent, "JabpSync", fastDiskAccess);
    }

    void closeSyncStore() {
        if (this.rs != null) {
            this.rs.closeRecordStore();
        }
    }

    void deleteSyncStore() {
        this.rs.deleteRecordStore();
    }

    int getNumSyncRecords() {
        return this.rs.getNumRecords();
    }

    void setToStart() {
        this.rs.setToStart();
    }

    int getCurrentFilePosition() {
        return this.rs.getCurrentFilePosition();
    }

    byte[] readNextSyncRecord() {
        byte[] bytes = this.rs.readRecord();
        if (bytes == null) {
            return null;
        }
        return bytes;
    }

    void saveSyncRecord(byte[] bytes, int type) {
        int n = bytes.length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(type);
            dos.writeInt(n);
            dos.write(bytes, 0, n);
            dos.close();
        }
        catch (IOException ie) {
            // empty catch block
        }
        byte[] bytes2 = baos.toByteArray();
        this.rs.addRecord(bytes2, 0, bytes2.length);
    }
}

