/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTextField;
import org.freepoc.Jabp4.AccountView;
import org.freepoc.Jabp4.CategoryView;
import org.freepoc.Jabp4.CurrencyView;
import org.freepoc.Jabp4.DateChooser;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.GenericShowForm;
import org.freepoc.Jabp4.GetDateForm;
import org.freepoc.Jabp4.InvestmentView;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.StandingOrder;
import org.freepoc.Jabp4.StandingOrderForm;
import org.freepoc.Jabp4.StandingOrderStore;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.TransferForm;
import org.freepoc.Jabp4.Utilities;

public class StandingOrderView
extends Canvas
implements ActionListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
Runnable {
    Jabp parent;
    Thread thread;
    StandingOrder so;
    StandingOrder so1;
    StandingOrder oldSO;
    TransferForm trf;
    Vector canvasMenu;
    StandingOrderStore sos;
    String msg = "";
    String oldName = "";
    Font font;
    FontMetrics fm;
    Point point;
    Image image;
    Graphics g1;
    Date date1;
    boolean paintWholeScreen = true;
    boolean dragScreen = false;
    boolean showCanvasMenu = false;
    boolean showingPopupMenu = false;
    boolean showSwitchViewsMenu = false;
    boolean calculateCanvasMenuPosition = true;
    int numMenuItems;
    int startMenuPos;
    int currentMenuPos;
    int menuWidth;
    int menuHeight;
    int menuWidthPos;
    int menuHeightPos;
    int fs;
    int width;
    int height;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int lastDragX;
    int lastDragY;
    int numItems;
    int numItemsPage;
    int lineHeight;
    int fontHeight;
    int fontWidth;
    int currentPos;
    int previousPos;
    int oldId;
    int startPos;
    int spacing;
    int amountPosition;
    int accountWidth;
    int numberWidth;
    int categoryPosition;
    int accountPosition;
    int categoryWidth;
    int dateWidth;
    int descriptionPosition;
    int descriptionWidth;
    int minDescriptionWidth;
    int currencyRate;
    int runMode;
    long timePointerOnScreen;
    boolean pointerExecute = false;
    boolean alwaysDisplayMenu = false;
    boolean start;
    boolean oneClickFlag;
    boolean showEndDates = false;

    StandingOrderView(Jabp context) {
        this.parent = context;
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.sos = new StandingOrderStore(this.parent, false);
        this.parent.dataIntegrityCheck("Standing Orders", this.sos.getNumStandingOrders(), this.parent.standingOrderHt.size());
        this.buildIndexBasedOnToggle();
        this.numItems = this.sos.getNumStandingOrders();
        this.font = this.parent.font;
        this.setFont(this.font);
        this.fm = this.getFontMetrics(this.font);
        this.lineHeight = this.parent.fontHeight + this.parent.lineSpacing * 2;
        this.currentX = 0;
        this.currentY = this.lineHeight;
        this.currentPos = 0;
        this.startPos = 0;
        this.setupCanvasMenu();
        this.runMode = 0;
        this.start = true;
        this.oneClickFlag = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
    }

    @Override
    public void paint(Graphics g) {
        if (this.start) {
            this.start = false;
        }
        if (this.width != this.getWidth() || this.height != this.getHeight() - this.parent.heightAdjustment) {
            this.width = this.getWidth();
            this.height = this.getHeight() - this.parent.heightAdjustment;
            this.paintWholeScreen = true;
        }
        this.parent.lastUsedScreen = 4;
        this.parent.lastUsedView = 4;
        this.setPositions();
        this.g1.clearRect(0, 0, this.width, this.height);
        this.g1.setFont(this.font);
        this.showHeader();
        this.showPage();
        this.showFooter();
        if (this.parent.useCanvasMenu && this.showCanvasMenu) {
            this.displayCanvasMenu();
        }
        g.drawImage(this.image, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    void showPage() {
        this.g1.setColor(new Color(this.parent.colorBackground));
        this.g1.fillRect(0, this.lineHeight, this.width, this.height - this.lineHeight * 2);
        this.g1.setColor(new Color(this.parent.colorFont));
        if (this.numItems == 0) {
            this.g1.drawString("Click here to add standing order", this.parent.widthAdjustment, this.lineHeight * 2);
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                this.g1.setColor(new Color(this.parent.colorCursor));
                this.g1.fillRect(0, this.lineHeight * i + this.lineHeight, this.width, this.lineHeight);
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            this.so = this.sos.getStandingOrderFromIndex2(i + this.startPos);
            this.buildLine(this.so, this.lineHeight * i + this.lineHeight);
        }
        this.so = this.sos.getStandingOrderFromIndex2(this.startPos + this.currentPos);
    }

    void showHeader() {
        int vpos = this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorHeading));
        this.g1.fillRect(0, 0, this.width, this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        if (this.msg.equals("")) {
            this.g1.drawString("Standing Orders", this.parent.widthAdjustment, vpos);
        } else {
            this.g1.drawString(this.msg, this.parent.widthAdjustment, vpos);
        }
    }

    void showFooter() {
        this.g1.setColor(new Color(this.parent.colorHeading));
        this.g1.fillRect(0, this.height - this.lineHeight, this.width, this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
    }

    void drawUp() {
        if (this.showCanvasMenu) {
            if (this.currentMenuPos > 0) {
                --this.currentMenuPos;
            } else {
                --this.startMenuPos;
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (this.startPos + this.currentPos > 0) {
            this.oldY = this.currentY;
            this.currentY -= this.lineHeight;
            --this.currentPos;
            if (this.currentY < this.lineHeight) {
                this.currentY = this.lineHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
                this.repaint();
            } else {
                this.repaint(0, this.lineHeight * this.currentPos + this.lineHeight, this.width, this.lineHeight * 2);
            }
            return;
        }
    }

    void drawDown() {
        if (this.showCanvasMenu) {
            if (this.currentMenuPos < Math.min(this.numItemsPage, this.numMenuItems) - 1) {
                ++this.currentMenuPos;
            } else {
                ++this.startMenuPos;
                if (this.startMenuPos + this.currentPos > Math.min(this.numItemsPage, this.numMenuItems) - 1) {
                    this.startMenuPos = Math.min(this.numItemsPage, this.numMenuItems) - 1 - this.currentPos;
                }
            }
            this.repaint();
            return;
        }
        if (this.startPos + this.currentPos < this.numItems - 1) {
            this.oldY = this.currentY;
            this.currentY += this.lineHeight;
            ++this.currentPos;
            if (this.currentY + this.lineHeight * 2 > this.height) {
                this.currentY -= this.lineHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
                this.repaint();
            } else {
                this.repaint(0, this.lineHeight * (this.currentPos - 1) + this.lineHeight, this.width, this.lineHeight * 2);
            }
            return;
        }
    }

    void buildLine(StandingOrder so2, int y) {
        int k;
        int i;
        int vpos = y + this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorFont));
        if (this.showEndDates) {
            this.g1.drawString(this.setPageDate(so2.longEndDate), this.parent.widthAdjustment, vpos);
        } else {
            this.g1.drawString(this.setPageDate(so2.longProcessingDate), this.parent.widthAdjustment, vpos);
        }
        int j = so2.description.length();
        for (i = 0; i < j; ++i) {
            k = j - i;
            if (this.fm.stringWidth(so2.description.substring(0, k)) > this.descriptionWidth) continue;
            this.g1.drawString(so2.description.substring(0, k), this.descriptionPosition, vpos);
            break;
        }
        if (this.categoryWidth > 0) {
            String s1 = so2.category;
            if (so2.transferFlag) {
                s1 = "[" + so2.transferAccount + "]";
            }
            j = s1.length();
            for (int i2 = 0; i2 < j; ++i2) {
                int k2 = j - i2;
                if (this.fm.stringWidth(s1.substring(0, k2)) > this.categoryWidth) continue;
                this.g1.drawString(s1.substring(0, k2), this.categoryPosition, vpos);
                break;
            }
        }
        if (this.accountWidth > 0) {
            j = so2.account.length();
            for (i = 0; i < j; ++i) {
                k = j - i;
                if (this.fm.stringWidth(so2.account.substring(0, k)) > this.accountWidth) continue;
                this.g1.drawString(so2.account.substring(0, k), this.accountPosition, vpos);
                break;
            }
        }
        if (so2.amount < 0) {
            this.g1.setColor(new Color(this.parent.colorNegative));
        }
        String s = Utilities.numberToString(so2.amount, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        this.g1.drawString(s, this.amountPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
    }

    String setPageDate(long ldate) {
        if (this.parent.adjustDaylightSavings) {
            this.parent.genericDate.setTime(ldate + 3600000L);
        } else {
            this.parent.genericDate.setTime(ldate);
        }
        this.parent.cal.setTime(this.parent.genericDate);
        String s0 = "" + this.parent.cal.get(5);
        if (s0.length() < 2) {
            s0 = "0" + s0;
        }
        int i = this.parent.cal.get(2) + 1;
        String s1 = "" + i;
        if (s1.length() < 2) {
            s1 = "0" + s1;
        }
        if (this.parent.dateFormat == 0) {
            return s0 + "/" + s1;
        }
        if (this.parent.dateFormat == 1) {
            return s1 + "/" + s0;
        }
        String s3 = ("" + this.parent.cal.get(1)).substring(2, 4);
        if (this.parent.dateFormat == 2) {
            return s0 + "/" + s1 + "/" + s3;
        }
        if (this.parent.dateFormat == 3) {
            return s1 + "/" + s0 + "/" + s3;
        }
        return "";
    }

    void setPositions() {
        this.fontHeight = this.parent.fontHeight;
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.image = this.createImage(this.width, this.height);
        this.g1 = this.image.getGraphics();
        Utilities.enableAntialiasing(this.g1);
        if (this.parent.lineSpacing == 0) {
            this.parent.lineSpacing = this.fontHeight / 5;
        }
        this.lineHeight = this.fontHeight + this.parent.lineSpacing * 2;
        this.dateWidth = this.fm.stringWidth("99/99");
        if (this.parent.dateFormat > 1) {
            this.dateWidth = this.fm.stringWidth("99/99/99");
        }
        this.numberWidth = this.parent.numberWidthInPixels == 0 ? (this.parent.isGroupingUsed ? this.fm.stringWidth("999,999.99") : this.fm.stringWidth("999999.99")) : this.parent.numberWidthInPixels;
        this.minDescriptionWidth = this.fm.stringWidth("Long Description");
        this.numItemsPage = this.height / this.lineHeight - 2;
        this.spacing = this.fm.stringWidth("  ");
        this.accountWidth = (this.width - this.minDescriptionWidth - this.parent.widthAdjustment * 2 - this.numberWidth - this.dateWidth - this.spacing * 4) / 2;
        this.accountWidth = this.categoryWidth = Math.max(this.accountWidth, this.fm.stringWidth("Accounts"));
        this.descriptionWidth = this.width - this.parent.widthAdjustment * 2 - this.dateWidth - this.numberWidth - this.categoryWidth - this.accountWidth - this.spacing * 4;
        if (this.descriptionWidth < this.minDescriptionWidth) {
            this.descriptionWidth += this.categoryWidth + this.spacing;
            this.categoryWidth = 0;
        }
        if (this.descriptionWidth < this.minDescriptionWidth) {
            this.descriptionWidth += this.accountWidth + this.spacing;
            this.accountWidth = 0;
        }
        this.descriptionPosition = this.parent.widthAdjustment + this.dateWidth + this.spacing;
        this.categoryPosition = this.descriptionPosition + this.descriptionWidth + this.spacing;
        this.accountPosition = this.categoryWidth > 0 ? this.categoryPosition + this.categoryWidth + this.spacing : this.categoryPosition;
        this.amountPosition = this.accountWidth > 0 ? this.accountPosition + this.accountWidth + this.spacing : this.accountPosition;
    }

    int newStandingOrder(StandingOrder so2) {
        this.so1 = so2;
        this.so1.id = this.sos.saveNewStandingOrder(this.so1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.sos.toByteArray(this.so1), 6);
        }
        if (this.so == null) {
            this.so = this.so1;
        }
        if (this.showEndDates) {
            this.sos.addIndex2(this.so1);
        }
        ++this.numItems;
        this.repaint();
        return this.so1.id;
    }

    void editStandingOrder(StandingOrder so2) {
        this.so1 = so2;
        this.sos.deleteStandingOrder(this.oldSO);
        if (this.showEndDates) {
            this.sos.deleteIndex(this.oldSO);
        } else {
            this.sos.deleteIndex(this.startPos + this.currentPos);
        }
        this.so1.id = this.sos.saveNewStandingOrder(this.so1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.sos.toByteArray(this.oldSO), -6);
            this.parent.sync.saveSyncRecord(this.sos.toByteArray(this.so1), 6);
        }
        if (this.showEndDates) {
            this.buildIndexBasedOnToggle();
        }
        this.oldY = this.currentY;
        this.repaint();
    }

    void deleteStandingOrder(StandingOrder so2) {
        this.so1 = so2;
        this.sos.deleteStandingOrder(this.so1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.sos.toByteArray(this.so1), -6);
        }
        if (this.showEndDates) {
            this.sos.deleteIndex(this.so1);
        } else {
            this.sos.deleteIndex(this.startPos + this.currentPos);
        }
        if (this.showEndDates) {
            this.buildIndexBasedOnToggle();
        }
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.lineHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
        this.repaint();
    }

    void processNow(long longDate) {
        int count = this.sos.processStandingOrders(longDate);
        switch (count) {
            case 0: {
                Toast.makeText(this.parent, "No standing orders processed", 2000).show();
                break;
            }
            case 1: {
                Toast.makeText(this.parent, "1 standing order processed", 2000).show();
                break;
            }
            default: {
                Toast.makeText(this.parent, count + " standing orders processed", 2000).show();
            }
        }
        this.numItems = this.sos.getNumStandingOrders();
        this.buildIndexBasedOnToggle();
    }

    void buildIndexBasedOnToggle() {
        if (!this.showEndDates) {
            this.sos.ht2 = this.sos.ht;
            return;
        }
        this.sos.ht2 = new Hashtable();
        this.sos.setToStart();
        while (true) {
            this.so = this.sos.readNextStandingOrder();
            if (this.so == null) break;
            this.sos.addIndex2(this.so);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int j;
        String s = ae.getSource().toString();
        String s1 = s.substring((j = s.indexOf("[")) + 1, j + 5);
        if (s1.equals("menu")) {
            MenuItem mi = (MenuItem)ae.getSource();
            this.commandAction(mi.getLabel());
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        this.lastDragX = x;
        this.lastDragY = y;
        this.pointerExecute = false;
        this.alwaysDisplayMenu = false;
        this.timePointerOnScreen = System.currentTimeMillis();
        this.calculateCanvasMenuPosition = true;
        if (this.showCanvasMenu) {
            this.calculateCanvasMenuPosition = false;
            this.currentMenuPos = (y - this.menuHeightPos) / this.lineHeight;
            this.repaint();
            return;
        }
        if (y < this.lineHeight) {
            if (this.numItems == 0) {
                return;
            }
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.lineHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (y > this.height - this.lineHeight) {
            if (this.numItems == 0) {
                return;
            }
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
            this.repaint();
            return;
        }
        this.pointerExecute = true;
        int newPos = (y - this.lineHeight) / this.lineHeight;
        if (newPos >= this.numItems) {
            this.alwaysDisplayMenu = true;
            return;
        }
        this.currentPos = newPos;
        this.currentY = (this.currentPos + 1) * this.lineHeight;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        if (Math.abs(this.lastDragX - x) > 250) {
            this.commandAction("Switch Views");
            return;
        }
        if (this.dragScreen) {
            this.dragScreen = false;
            return;
        }
        if (this.showCanvasMenu) {
            this.showCanvasMenu = false;
            this.repaint();
            if (x < this.menuWidthPos || x > this.menuWidthPos + this.menuWidth || y < this.menuHeightPos || y > this.menuHeightPos + this.menuHeight) {
                this.setupCanvasMenu();
                this.showSwitchViewsMenu = false;
                return;
            }
            int k = (y - this.menuHeightPos) / this.lineHeight + this.startMenuPos;
            if (this.showSwitchViewsMenu) {
                this.showSwitchViewsMenu = false;
                this.processSwitchViewsMenu(k);
            } else {
                this.processMenuCommand(k);
            }
            return;
        }
        this.timePointerOnScreen = System.currentTimeMillis() - this.timePointerOnScreen;
        if (this.timePointerOnScreen > (long)this.parent.longTapDelay) {
            if (y < this.lineHeight) {
                this.startPos = 0;
                this.currentPos = 0;
                this.currentY = this.lineHeight;
                this.repaint();
                return;
            }
            if (y > this.height - this.lineHeight) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                this.repaint();
                return;
            }
        }
        if (this.alwaysDisplayMenu || this.timePointerOnScreen > (long)this.parent.longTapDelay) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.repaint();
            } else {
                this.displayPopupMenu();
            }
            return;
        }
        if (!this.pointerExecute) {
            return;
        }
        int newPos = (y - this.lineHeight) / this.lineHeight;
        if (newPos == this.currentPos || newPos >= this.numItems) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.repaint();
            } else {
                this.displayPopupMenu();
            }
            return;
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        int scroll = (y - this.lastDragY) / this.lineHeight;
        if (scroll == 0) {
            return;
        }
        if (scroll > 0) {
            if (this.showCanvasMenu) {
                this.startMenuPos -= scroll;
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
                this.currentMenuPos += scroll;
                if (this.currentMenuPos > Math.min(this.numMenuItems, this.numItemsPage) - 1) {
                    this.currentMenuPos = Math.min(this.numMenuItems, this.numItemsPage) - 1;
                }
            } else {
                this.startPos -= scroll;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                this.currentPos += scroll;
                if (this.currentPos > Math.min(this.numItems, this.numItemsPage) - 1) {
                    this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                }
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
        }
        if (scroll < 0) {
            if (this.showCanvasMenu) {
                this.startMenuPos -= scroll;
                if (this.startMenuPos + this.numItemsPage > this.numMenuItems - 1) {
                    this.startMenuPos = this.numMenuItems - this.numItemsPage;
                }
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
                this.currentMenuPos += scroll;
                if (this.currentMenuPos < 0) {
                    this.currentMenuPos = 0;
                }
            } else {
                this.startPos -= scroll;
                if (this.startPos + this.currentPos > this.numItems - 1) {
                    this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                    this.startPos = this.numItems - 1 - this.currentPos;
                    this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                }
                this.currentPos += scroll;
                if (this.currentPos < 0) {
                    this.currentPos = 0;
                }
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
        }
        this.lastDragY = y;
        this.repaint();
        this.dragScreen = true;
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        int notches = mwe.getWheelRotation();
        if (notches == 0) {
            return;
        }
        if (notches > 0) {
            for (int i = 0; i < notches; ++i) {
                this.drawDown();
            }
        } else {
            notches = -notches;
            for (int i = 0; i < notches; ++i) {
                this.drawUp();
            }
        }
    }

    void displayPopupMenu() {
        if (this.showingPopupMenu) {
            this.showingPopupMenu = false;
            return;
        }
        PopupMenu pm = new PopupMenu();
        MenuItem miHome = new MenuItem("Home");
        MenuItem miNew = new MenuItem("New");
        MenuItem miEdit = new MenuItem("Edit");
        MenuItem miDelete = new MenuItem("Delete");
        MenuItem miShow = new MenuItem("Show");
        MenuItem miProcess = new MenuItem("Process Now");
        MenuItem miSwitchViews = new MenuItem("Switch Views");
        MenuItem miToggleDates = new MenuItem("Toggle Dates");
        miHome.addActionListener(this);
        miNew.addActionListener(this);
        miEdit.addActionListener(this);
        miDelete.addActionListener(this);
        miShow.addActionListener(this);
        miProcess.addActionListener(this);
        miSwitchViews.addActionListener(this);
        miToggleDates.addActionListener(this);
        pm.add(miHome);
        pm.add(miNew);
        pm.add(miEdit);
        pm.add(miDelete);
        pm.add(miShow);
        pm.add(miProcess);
        pm.add(miSwitchViews);
        pm.add(miToggleDates);
        this.add(pm);
        int x = 0;
        int y = 0;
        if (this.point == null) {
            pm.show(this, x, y);
        } else {
            Point move = this.movePopup(8, x, y);
            pm.show(this, move.x + this.point.x, move.y + this.point.y);
        }
        this.showingPopupMenu = true;
    }

    void displaySwitchViewsMenu() {
        if (this.showingPopupMenu) {
            this.showingPopupMenu = false;
            return;
        }
        PopupMenu pm = new PopupMenu();
        MenuItem miAccounts = new MenuItem("Accounts");
        MenuItem miTransactions = new MenuItem("Transactions");
        MenuItem miCategories = new MenuItem("Categories");
        MenuItem miStandingOrders = new MenuItem("Standing Orders");
        MenuItem miInvestments = new MenuItem("Investments");
        MenuItem miCurrencies = new MenuItem("Currencies");
        miAccounts.addActionListener(this);
        miTransactions.addActionListener(this);
        miCategories.addActionListener(this);
        miStandingOrders.addActionListener(this);
        miInvestments.addActionListener(this);
        miCurrencies.addActionListener(this);
        pm.add(miAccounts);
        pm.add(miTransactions);
        pm.add(miCategories);
        pm.add(miStandingOrders);
        pm.add(miInvestments);
        pm.add(miCurrencies);
        this.add(pm);
        int x = 0;
        int y = 0;
        if (this.point == null) {
            pm.show(this, x, y);
        } else {
            Point move = this.movePopup(7, x, y);
            pm.show(this, move.x + this.point.x, move.y + this.point.y);
        }
        this.showingPopupMenu = true;
    }

    Point movePopup(int n, int x, int y) {
        int popupHeight = n * this.lineHeight * 4 / 3;
        if (this.parent.useCanvasMenu && x + this.point.x + this.menuWidth > this.width) {
            x = this.width - this.menuWidth - this.point.x;
        }
        if (y + this.point.y + popupHeight > this.height) {
            y = this.height - popupHeight - this.point.y;
        }
        Point move = new Point(x, y);
        return move;
    }

    boolean getUserDate(Date date2) {
        if (date2 == null) {
            date2 = new Date();
        }
        this.date1 = date2;
        DialogManager dm = new DialogManager(this.parent, "Specify date");
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf2 = null;
        if (this.parent.dateType == 0 || this.parent.dateType == 2) {
            sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf2 = new SimpleDateFormat("dd/MM/yy HH");
        }
        if (this.parent.dateType == 1 || this.parent.dateType == 3) {
            sdf = new SimpleDateFormat("MM/dd/yyyy");
            sdf2 = new SimpleDateFormat("MM/dd/yy HH");
        }
        JTextField textDate = dm.addJTextFieldWithButton("Date", sdf.format(this.date1));
        dm.addOKCancelButtons();
        dm.centerShow();
        if (dm.checkButtons()) {
            try {
                this.date1 = sdf2.parse(dm.getUserText(textDate) + " 02");
            }
            catch (ParseException pe) {
                this.date1 = new Date();
            }
            if (dm.checkButtonText().equals(">")) {
                GregorianCalendar gc = new GregorianCalendar();
                gc.setTime(this.date1);
                DateChooser dc = new DateChooser((Frame)this.parent, gc);
                if (dc.showDateChooser() == 1) {
                    gc = dc.getDate();
                }
                this.date1 = gc.getTime();
                return this.getUserDate(this.date1);
            }
        } else {
            return false;
        }
        return true;
    }

    void setupCanvasMenu() {
        this.startMenuPos = 0;
        this.currentMenuPos = 0;
        this.canvasMenu = new Vector(7);
        this.canvasMenu.addElement("Home");
        this.canvasMenu.addElement("New");
        this.canvasMenu.addElement("Edit");
        this.canvasMenu.addElement("Delete");
        this.canvasMenu.addElement("Show");
        this.canvasMenu.addElement("Process Now");
        this.canvasMenu.addElement("Switch Views");
        this.canvasMenu.addElement("Toggle Dates");
        this.menuWidth = this.fm.stringWidth("Toggle Dates") + 6;
    }

    void setupSwitchViewsMenu() {
        this.startMenuPos = 0;
        this.currentMenuPos = 0;
        this.canvasMenu = new Vector(6);
        this.canvasMenu.addElement("Accounts");
        this.canvasMenu.addElement("Transactions");
        this.canvasMenu.addElement("Categories");
        this.canvasMenu.addElement("Standing Orders");
        this.canvasMenu.addElement("Investments");
        this.canvasMenu.addElement("Currencies");
        this.menuWidth = this.fm.stringWidth("Standing Orders") + 6;
    }

    void displayCanvasMenu() {
        this.numMenuItems = this.canvasMenu.size();
        this.menuWidthPos = (this.width - this.menuWidth) / 2;
        if (this.menuWidthPos < 0) {
            this.menuWidthPos = 0;
        }
        this.menuHeightPos = (this.height - this.lineHeight * 2 - this.numMenuItems * this.lineHeight) / 2;
        if (this.menuHeightPos < this.lineHeight) {
            this.menuHeightPos = this.lineHeight;
        }
        this.menuHeight = Math.min(this.height - this.lineHeight * 2, this.numMenuItems * this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorMessage));
        this.g1.fillRect(this.menuWidthPos, this.menuHeightPos, this.menuWidth, this.menuHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        for (int i = 0; i < this.numItemsPage && i + this.startMenuPos <= this.numMenuItems - 1; ++i) {
            int vpos = i * this.lineHeight + this.lineHeight + this.menuHeightPos - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
            if (i == this.currentMenuPos) {
                this.g1.setColor(new Color(this.parent.colorCursor));
                this.g1.fillRect(this.menuWidthPos, this.lineHeight * i + this.menuHeightPos, this.menuWidth, this.lineHeight);
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            this.g1.drawString((String)this.canvasMenu.elementAt(i + this.startMenuPos), this.menuWidthPos + 3, vpos);
        }
    }

    void processMenuCommand(int k) {
        this.invalidate();
        this.commandAction((String)this.canvasMenu.elementAt(k));
    }

    void processSwitchViewsMenu(int k) {
        this.setupCanvasMenu();
        switch (k) {
            case 0: {
                this.commandAction("Accounts");
                break;
            }
            case 1: {
                this.commandAction("Transactions");
                break;
            }
            case 2: {
                this.commandAction("Categories");
                break;
            }
            case 3: {
                this.commandAction("Standing Orders");
                break;
            }
            case 4: {
                this.commandAction("Investments");
                break;
            }
            case 5: {
                this.commandAction("Currencies");
            }
        }
    }

    void runThread() {
        Thread thread2 = new Thread(this);
        thread2.start();
    }

    @Override
    public void run() {
        if (this.runMode == 1) {
            // empty if block
        }
        if (this.runMode == 2) {
            // empty if block
        }
    }

    public void commandAction(String cmd) {
        this.showingPopupMenu = false;
        if (cmd.equals("Exit")) {
            this.parent.finishAndQuit();
            return;
        }
        if (cmd.equals("Home")) {
            if (this.parent.av == null) {
                this.parent.av = new AccountView(this.parent);
            }
            this.parent.setContentView(this.parent.av);
            return;
        }
        if (cmd.equals("New")) {
            this.parent.sof = new StandingOrderForm(this.parent, new StandingOrder(), "New");
            return;
        }
        if (cmd.equals("Edit")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to edit", 2000).show();
                return;
            }
            this.oldSO = new StandingOrder();
            this.oldSO.clone(this.so);
            this.parent.sof = new StandingOrderForm(this.parent, this.so, "Edit");
            return;
        }
        if (cmd.equals("Delete")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to delete", 2000).show();
                return;
            }
            this.parent.sof = new StandingOrderForm(this.parent, this.so, "Delete");
            return;
        }
        if (cmd.equals("Show")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to show", 2000).show();
                return;
            }
            this.parent.gsf = new GenericShowForm(this.parent, this.so, 3);
            this.parent.setContentView(this.parent.gsf);
            return;
        }
        if (cmd.equals("Process Now")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "No Standing Orders set up", 2000).show();
                return;
            }
            new GetDateForm(this.parent, 1);
            return;
        }
        if (cmd.equals("Switch Views")) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.showSwitchViewsMenu = true;
                this.setupSwitchViewsMenu();
                this.repaint();
                return;
            }
            this.displaySwitchViewsMenu();
            return;
        }
        if (cmd.equals("Toggle Dates")) {
            this.showEndDates = !this.showEndDates;
            this.buildIndexBasedOnToggle();
            this.repaint();
            if (this.showEndDates) {
                Toast.makeText(this.parent, "Showing end dates", 2000).show();
            } else {
                Toast.makeText(this.parent, "Showing next processing dates", 2000).show();
            }
            return;
        }
        if (cmd.equals("Accounts") || cmd.equals("Home")) {
            if (this.parent.av == null) {
                this.parent.av = new AccountView(this.parent);
            }
            this.parent.setContentView(this.parent.av);
            this.repaint();
            return;
        }
        if (cmd.equals("Transactions")) {
            if (this.parent.tv == null) {
                Toast.makeText(this.parent, "No account selected", 2000).show();
            } else {
                this.parent.setContentView(this.parent.tv);
            }
            this.repaint();
            return;
        }
        if (cmd.equals("Categories")) {
            if (this.parent.cv == null) {
                this.parent.cv = new CategoryView(this.parent);
            }
            this.parent.setContentView(this.parent.cv);
            this.repaint();
            return;
        }
        if (cmd.equals("Standing Orders")) {
            Toast.makeText(this.parent, "Already in Standing Orders View", 2000).show();
            this.repaint();
            return;
        }
        if (cmd.equals("Investments")) {
            if (this.parent.iv == null) {
                this.parent.iv = new InvestmentView(this.parent);
            }
            this.parent.setContentView(this.parent.iv);
            this.repaint();
            return;
        }
        if (cmd.equals("Currencies")) {
            if (this.parent.ccyv == null) {
                this.parent.ccyv = new CurrencyView(this.parent);
            }
            this.parent.setContentView(this.parent.ccyv);
            this.repaint();
            return;
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int keyCode = keyEvent.getKeyCode();
        switch (keyCode) {
            case 33: 
            case 37: {
                if (this.startPos == 0) {
                    this.currentPos = 0;
                    this.currentY = this.lineHeight;
                    break;
                }
                this.startPos -= this.numItemsPage;
                if (this.startPos >= 0) break;
                this.startPos = 0;
                break;
            }
            case 34: 
            case 39: {
                this.startPos += this.numItemsPage;
                if (this.startPos + this.currentPos <= this.numItems - 1) break;
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                break;
            }
            case 38: {
                this.drawUp();
                break;
            }
            case 40: {
                this.drawDown();
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int keyCode = keyEvent.getKeyCode();
        switch (keyCode) {
            case 36: {
                this.startPos = 0;
                this.currentPos = 0;
                this.currentY = this.lineHeight;
                break;
            }
            case 35: {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                break;
            }
            case 10: 
            case 525: {
                if (this.showCanvasMenu) {
                    this.showCanvasMenu = false;
                    if (this.showSwitchViewsMenu) {
                        this.showSwitchViewsMenu = false;
                        this.processSwitchViewsMenu(this.startMenuPos + this.currentMenuPos);
                        break;
                    }
                    this.processMenuCommand(this.startMenuPos + this.currentMenuPos);
                    break;
                }
                if (this.numItems == 0) break;
                if (this.parent.useCanvasMenu) {
                    this.showCanvasMenu = true;
                    break;
                }
                if (keyCode != 525) break;
                this.displayPopupMenu();
                break;
            }
            case 27: {
                this.parent.onBackPressed();
                break;
            }
            case 78: {
                this.commandAction("New");
                break;
            }
            case 69: {
                this.commandAction("Edit");
                break;
            }
            case 68: {
                this.commandAction("Delete");
                break;
            }
            case 70: {
                this.commandAction("Find");
                break;
            }
            case 83: {
                this.commandAction("Show");
                break;
            }
            case 80: {
                this.commandAction("Process Now");
                break;
            }
            case 72: {
                this.commandAction("Home");
                break;
            }
            case 86: {
                this.commandAction("Switch Views");
                break;
            }
            case 75: {
                this.parent.gsf = new GenericShowForm(this.parent, null, 9);
                this.parent.setContentView(this.parent.gsf);
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

