/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Hashtable;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.AccountStore;
import org.freepoc.Jabp4.Category;
import org.freepoc.Jabp4.CategoryStore;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.LongId;
import org.freepoc.Jabp4.RecordStore;
import org.freepoc.Jabp4.StandingOrder;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.TransactionStore;
import org.freepoc.Jabp4.Utilities;

public class StandingOrderStore {
    RecordStore rs;
    Jabp parent;
    Hashtable ht;
    Hashtable ht2;

    public StandingOrderStore(Jabp context, boolean fastDiskAccess) {
        this.parent = context;
        this.ht2 = new Hashtable();
        this.ht = this.parent.standingOrderHt;
        this.openStandingOrderStore(fastDiskAccess);
    }

    void openStandingOrderStore(boolean fastDiskAccess) {
        this.rs = new RecordStore(this.parent, "StandingOrders", fastDiskAccess);
    }

    void closeStandingOrderStore() {
        if (this.rs != null) {
            this.rs.closeRecordStore();
        }
    }

    int getNumStandingOrders() {
        return this.rs.getNumRecords();
    }

    byte[] toByteArray(StandingOrder so) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeLong(so.longProcessingDate);
            dos.writeUTF(so.description);
            dos.writeLong(so.longStartDate);
            dos.writeLong(so.longEndDate);
            dos.writeUTF(so.account);
            dos.writeInt(so.amount);
            dos.writeUTF(so.reference);
            dos.writeUTF(so.category);
            dos.writeInt(so.period);
            dos.writeInt(so.interval);
            dos.writeBoolean(so.transferFlag);
            dos.writeUTF(so.transferAccount);
            dos.close();
        }
        catch (IOException ie) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    StandingOrder fromByteArray(byte[] bytes) {
        StandingOrder so = new StandingOrder();
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            so.longProcessingDate = dis.readLong();
            so.description = dis.readUTF();
            so.longStartDate = dis.readLong();
            so.longEndDate = dis.readLong();
            so.account = dis.readUTF();
            so.amount = dis.readInt();
            so.reference = dis.readUTF();
            so.category = dis.readUTF();
            so.period = dis.readInt();
            so.interval = dis.readInt();
            so.transferFlag = dis.readBoolean();
            so.transferAccount = dis.readUTF();
            dis.close();
        }
        catch (IOException ie) {
            System.err.println(ie + " sos4a");
        }
        return so;
    }

    StandingOrder getStandingOrder(int id) {
        StandingOrder so = new StandingOrder();
        byte[] bytes = this.rs.getRecord(id);
        so = this.fromByteArray(bytes);
        so.id = id;
        return so;
    }

    void setToStart() {
        this.rs.setToStart();
    }

    StandingOrder readNextStandingOrder() {
        StandingOrder so = new StandingOrder();
        byte[] bytes = this.rs.readRecord();
        if (bytes == null) {
            return null;
        }
        int id = this.rs.getCurrentFilePosition() - bytes.length - 5;
        so = this.fromByteArray(bytes);
        so.id = id;
        return so;
    }

    StandingOrder getStandingOrderFromIndex(int i) {
        int id = ((LongId)this.ht.get((Object)new Integer((int)i))).id;
        return this.getStandingOrder(id);
    }

    StandingOrder getStandingOrderFromIndex2(int i) {
        int id = ((LongId)this.ht2.get((Object)new Integer((int)i))).id;
        return this.getStandingOrder(id);
    }

    StandingOrder getStandingOrderFromName(String string) {
        StandingOrder so = null;
        this.setToStart();
        while ((so = this.readNextStandingOrder()) != null) {
            if (!so.description.equals(string)) continue;
            return so;
        }
        return null;
    }

    void deleteStandingOrder(StandingOrder so) {
        this.rs.deleteRecord(so.id);
    }

    int saveNewStandingOrder(StandingOrder so) {
        so.id = this.rs.getNextRecordID();
        byte[] bytes = this.toByteArray(so);
        this.rs.addRecord(bytes, 0, bytes.length);
        this.addIndex(so);
        return so.id;
    }

    int saveNewStandingOrderWithoutIndex(StandingOrder so) {
        so.id = this.rs.getNextRecordID();
        byte[] bytes = this.toByteArray(so);
        this.rs.addRecord(bytes, 0, bytes.length);
        return so.id;
    }

    void saveExistingStandingOrder(StandingOrder so) {
        byte[] bytes = this.toByteArray(so);
        this.rs.setRecord(so.id, bytes, 0, bytes.length);
    }

    void saveExistingStandingOrder(StandingOrder so, boolean movePointer, boolean moveIndex, int index) {
        if (movePointer) {
            this.deleteStandingOrder(so);
            this.saveNewStandingOrderWithoutIndex(so);
        } else {
            this.saveExistingStandingOrder(so);
        }
        if (moveIndex) {
            this.deleteIndex(index);
            this.addIndex(so);
        } else {
            this.updateIndex(index, so);
        }
    }

    void deleteIndex(int index) {
        int n = this.ht.size();
        for (int i = index; i < n - 1; ++i) {
            int j = i + 1;
            LongId longId = (LongId)this.ht.get(new Integer(j));
            this.ht.put(new Integer(i), longId);
        }
        this.ht.remove(new Integer(n - 1));
    }

    void addIndex(StandingOrder so) {
        int i;
        int n;
        int p = n = this.ht.size();
        long soLong = Utilities.longToDays(so.longProcessingDate);
        for (i = 0; i < n; ++i) {
            LongId li1 = (LongId)this.ht.get(new Integer(i));
            if (soLong > Utilities.longToDays(li1.lo)) continue;
            p = i;
            break;
        }
        if (p < n) {
            for (i = n - 1; i >= p; --i) {
                int j = i + 1;
                LongId li2 = (LongId)this.ht.get(new Integer(i));
                this.ht.put(new Integer(j), li2);
            }
        }
        LongId li3 = new LongId(so.longProcessingDate, so.id);
        this.ht.put(new Integer(p), li3);
    }

    void addIndex2(StandingOrder so) {
        int i;
        int n;
        int p = n = this.ht2.size();
        long soLong = Utilities.longToDays(so.longEndDate);
        for (i = 0; i < n; ++i) {
            LongId li1 = (LongId)this.ht2.get(new Integer(i));
            if (soLong > Utilities.longToDays(li1.lo)) continue;
            p = i;
            break;
        }
        if (p < n) {
            for (i = n - 1; i >= p; --i) {
                int j = i + 1;
                LongId li2 = (LongId)this.ht2.get(new Integer(i));
                this.ht2.put(new Integer(j), li2);
            }
        }
        LongId li3 = new LongId(so.longEndDate, so.id);
        this.ht2.put(new Integer(p), li3);
    }

    int lookUpIndex(StandingOrder so) {
        int n = this.ht.size();
        int j = -1;
        for (int i = 0; i < n; ++i) {
            LongId longId = (LongId)this.ht.get(new Integer(i));
            if (so.id != longId.id) continue;
            j = i;
            break;
        }
        return j;
    }

    void deleteIndex(StandingOrder so) {
        this.deleteIndex(this.lookUpIndex(so));
    }

    void updateIndex(int index, StandingOrder so) {
        this.ht.put(new Integer(index), new LongId(so.longProcessingDate, so.id));
    }

    int futureStandingOrders(long ldate, String s) {
        int total = 0;
        long futureDate = Utilities.longToDays(ldate);
        StandingOrder so = null;
        this.setToStart();
        block0: while ((so = this.readNextStandingOrder()) != null) {
            if (!s.equals("All accounts") && !s.equals(so.account) && !s.equals(so.transferAccount)) continue;
            while (Utilities.longToDays(so.longProcessingDate) <= futureDate) {
                if (s.equals("All accounts") && !so.transferFlag) {
                    total += so.amount;
                }
                if (s.equals(so.account)) {
                    total += so.amount;
                }
                if (s.equals(so.transferAccount)) {
                    total -= so.amount;
                }
                so.longProcessingDate = this.nextProcessingDate(so);
                if (Utilities.longToDays(so.longProcessingDate) <= Utilities.longToDays(so.longEndDate)) continue;
                continue block0;
            }
        }
        return total;
    }

    int processStandingOrders(long ldate) {
        int count = 0;
        AccountStore as = null;
        as = this.parent.av == null ? new AccountStore(this.parent, true) : this.parent.av.as;
        CategoryStore cs = null;
        cs = this.parent.cv == null ? new CategoryStore(this.parent, true) : this.parent.cv.cs;
        TransactionStore ts = null;
        if (this.parent.tv == null) {
            ts = new TransactionStore(this.parent, new Account(), true);
        } else {
            ts = this.parent.tv.ts;
            ts.setIndex(this.parent.tv.a);
        }
        long todayDate = Utilities.longToDays(ldate);
        int n = this.getNumStandingOrders();
        block0: for (int i = 0; i < n; ++i) {
            StandingOrder so;
            while (true) {
                so = this.getStandingOrderFromIndex(i);
                long soDate = Utilities.longToDays(so.longProcessingDate);
                if (soDate > todayDate) continue block0;
                this.parent.genericDate.setTime(so.longProcessingDate);
                this.parent.cal.setTime(this.parent.genericDate);
                int d = this.parent.cal.get(5);
                int m = this.parent.cal.get(2) + 1;
                Transaction t = new Transaction();
                t.account = so.account;
                t.description = so.description;
                t.amount = so.amount;
                t.longDate = so.longProcessingDate;
                t.category = so.category;
                t.reference = so.reference;
                t.transferFlag = so.transferFlag;
                if (t.transferFlag) {
                    t.transferAccount = so.transferAccount;
                }
                Account a = as.getAccountFromName(t.account);
                ts.getIndex(a);
                t.id = ts.saveNewTransactionWithoutIndex(t);
                ts.addIndex(t);
                ts.setIndex(a);
                if (t.id < 0) {
                    Toast.makeText(this.parent, "Error while creating transaction", 2000).show();
                    return count;
                }
                this.updateAccountTotal1(a);
                a.updateBalance(t, null, this.parent.todayDays);
                this.updateAccountTotal2(a);
                as.saveExistingAccount(a);
                if (this.parent.tv != null && this.parent.tv.a.name.equals(a.name)) {
                    ++this.parent.tv.numItems;
                    this.parent.tv.rt = a.current;
                    this.parent.tv.adjustRunningTotal(0, this.parent.tv.startPos + this.parent.tv.currentPos);
                    this.parent.tv.a.current = a.current;
                    this.parent.tv.a.today = a.today;
                    this.parent.tv.a.reconciled = a.reconciled;
                }
                if (t.transferFlag) {
                    Transaction t1 = new Transaction();
                    t1.clone(t);
                    t1.account = t.transferAccount;
                    t1.transferAccount = t.account;
                    t1.amount = -t.amount;
                    Account a1 = as.getAccountFromName(t1.account);
                    ts.getIndex(a1);
                    t1.id = ts.saveNewTransactionWithoutIndex(t1);
                    ts.addIndex(t1);
                    if (t.id < 0) {
                        Toast.makeText(this.parent, "Error while creating transaction", 2000).show();
                        return count;
                    }
                    ts.setIndex(a1);
                    this.updateAccountTotal1(a1);
                    a1.updateBalance(t1, null, this.parent.todayDays);
                    this.updateAccountTotal2(a1);
                    as.saveExistingAccount(a1);
                    if (this.parent.tv != null && this.parent.tv.a.name.equals(a1.name)) {
                        ++this.parent.tv.numItems;
                        this.parent.tv.rt = a1.current;
                        this.parent.tv.adjustRunningTotal(0, this.parent.tv.startPos + this.parent.tv.currentPos);
                        this.parent.tv.a.current = a1.current;
                        this.parent.tv.a.today = a1.today;
                        this.parent.tv.a.reconciled = a1.reconciled;
                    }
                } else {
                    Category c = cs.getCategoryFromName(t.category);
                    this.updateCategoryTotal1(c);
                    c.updateBalance(t, null);
                    this.updateCategoryTotal2(c);
                    cs.saveExistingCategory(c);
                    c = null;
                }
                so.longProcessingDate = this.nextProcessingDate(so);
                ++count;
                long longProcessingDate = Utilities.longToDays(so.longProcessingDate);
                long longEndDate = Utilities.longToDays(so.longEndDate);
                if (longProcessingDate > longEndDate) break;
                this.saveExistingStandingOrder(so);
            }
            this.deleteStandingOrder(so);
        }
        if (this.parent.tv == null) {
            ts.closeTransactionStore();
            ts = null;
        } else {
            this.parent.tv.ts.getIndex(this.parent.tv.a);
        }
        if (this.parent.cv == null) {
            cs.closeCategoryStore();
            cs = null;
        }
        if (this.parent.av == null) {
            as.closeAccountStore();
            as = null;
        }
        this.ht = new Hashtable();
        this.ht2 = new Hashtable();
        this.parent.standingOrderHt = this.ht;
        if (this.getNumStandingOrders() == 0) {
            return count;
        }
        StandingOrder so = null;
        this.setToStart();
        n = 0;
        while ((so = this.readNextStandingOrder()) != null) {
            this.addIndex(so);
            ++n;
        }
        if (this.parent.sov != null) {
            this.parent.sov.numItems = n;
        }
        if (this.parent.av != null) {
            this.parent.av.invalidate();
        }
        if (this.parent.cv != null) {
            this.parent.cv.invalidate();
        }
        if (this.parent.tv != null) {
            this.parent.tv.invalidate();
        }
        if (this.parent.sov != null) {
            this.parent.sov.invalidate();
        }
        return count;
    }

    long nextProcessingDate(StandingOrder so) {
        Calendar calStartDate = Calendar.getInstance();
        Calendar calProcessingDate = Calendar.getInstance();
        this.parent.genericDate.setTime(so.longStartDate);
        calStartDate.setTime(this.parent.genericDate);
        this.parent.genericDate.setTime(so.longProcessingDate);
        calProcessingDate.setTime(this.parent.genericDate);
        if (so.period == 0) {
            calProcessingDate.add(1, so.interval);
        }
        if (so.period == 1) {
            int daysInMonth;
            int startDayOfMonth = calStartDate.get(5);
            int processingDayOfMonth = calProcessingDate.get(5);
            calProcessingDate.set(5, 1);
            calProcessingDate.add(2, so.interval);
            int k = calProcessingDate.get(2);
            if (k == 0 || k == 2 || k == 4 || k == 6 || k == 7 || k == 9 || k == 11) {
                daysInMonth = 31;
                if (startDayOfMonth > processingDayOfMonth && processingDayOfMonth >= 28) {
                    calProcessingDate.set(5, startDayOfMonth);
                } else {
                    calProcessingDate.set(5, Math.min(daysInMonth, processingDayOfMonth));
                }
            }
            if (k == 3 || k == 5 || k == 8 || k == 10) {
                daysInMonth = 30;
                if ((startDayOfMonth = Math.min(startDayOfMonth, daysInMonth)) > processingDayOfMonth && processingDayOfMonth >= 28) {
                    calProcessingDate.set(5, startDayOfMonth);
                } else {
                    calProcessingDate.set(5, Math.min(daysInMonth, processingDayOfMonth));
                }
            }
            if (k == 1) {
                boolean isLeapYear;
                int year = calProcessingDate.get(1);
                boolean bl = isLeapYear = year % 400 == 0 || year % 100 != 0 && year % 4 == 0;
                if (isLeapYear) {
                    daysInMonth = 29;
                    startDayOfMonth = Math.min(startDayOfMonth, daysInMonth);
                } else {
                    daysInMonth = 28;
                    startDayOfMonth = Math.min(startDayOfMonth, daysInMonth);
                }
                if (startDayOfMonth > processingDayOfMonth && processingDayOfMonth >= 28) {
                    calProcessingDate.set(5, startDayOfMonth);
                } else {
                    calProcessingDate.set(5, Math.min(daysInMonth, processingDayOfMonth));
                }
            }
        }
        if (so.period == 2) {
            calProcessingDate.add(5, so.interval * 7);
        }
        if (so.period == 3) {
            calProcessingDate.add(5, so.interval);
        }
        return calProcessingDate.getTime().getTime();
    }

    boolean checkStandingOrders(long ldate) {
        long todayDate = Utilities.longToDays(ldate);
        int n = this.getNumStandingOrders();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            StandingOrder so = this.getStandingOrderFromIndex(i);
            long soDate = Utilities.longToDays(so.longProcessingDate);
            if (soDate > todayDate) continue;
            return true;
        }
        return false;
    }

    void updateAccountTotal1(Account account) {
        if (this.parent.av != null) {
            this.parent.av.totalCurrent -= account.current;
            this.parent.av.totalToday -= account.today;
            this.parent.av.totalReconciled -= account.reconciled;
        }
    }

    void updateAccountTotal2(Account account) {
        if (this.parent.av != null) {
            this.parent.av.totalCurrent += account.current;
            this.parent.av.totalToday += account.today;
            this.parent.av.totalReconciled += account.reconciled;
            this.parent.av.checkMinMax(account);
        }
    }

    void updateCategoryTotal1(Category category) {
        if (this.parent.cv != null) {
            this.parent.cv.totalCurrent -= category.current;
        }
    }

    void updateCategoryTotal2(Category category) {
        if (this.parent.cv != null) {
            this.parent.cv.totalCurrent += category.current;
            this.parent.cv.checkMinMax(category);
        }
    }

    int getSize() {
        return this.rs.getSize();
    }
}

