/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Frame;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.AccountStore;
import org.freepoc.Jabp4.Category;
import org.freepoc.Jabp4.CategoryStore;
import org.freepoc.Jabp4.Currency;
import org.freepoc.Jabp4.CurrencyStore;
import org.freepoc.Jabp4.DateChooser;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.StandingOrder;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.TransferForm;
import org.freepoc.Jabp4.Utilities;

public class StandingOrderForm
extends Component {
    Jabp parent;
    StandingOrder so;

    public StandingOrderForm(Jabp context, StandingOrder so1, String action) {
        this.parent = context;
        this.parent.lastUsedScreen = 35;
        this.so = so1;
        if (action.equals("New")) {
            this.createStandingOrder(this.so);
        }
        if (action.equals("Edit")) {
            this.updateStandingOrder(this.so);
        }
        if (action.equals("Delete")) {
            this.deleteStandingOrder(this.so);
        }
    }

    void createStandingOrder(StandingOrder so) {
        DialogManager dm = new DialogManager(this.parent, "New standing order");
        JTextField description = dm.addJTextField("Description", so.description);
        String s = "";
        if (so.amount != 0) {
            s = Utilities.numberToString(Math.abs(so.amount), this.parent.numericEntry, this.parent.isEuropeanNumberFormat, false);
        }
        JTextField amount = dm.addJTextField("Amount", s);
        boolean state = false;
        if (so.amount > 0) {
            state = true;
        }
        CheckboxGroup debitOrCredit = dm.addCheckboxGroup();
        dm.addCheckboxItem("DR/CR", "DR", !state, "CR", state, debitOrCredit);
        JTextField reference = dm.addJTextField("Reference", so.reference);
        if (so.longProcessingDate == 0L) {
            so.longProcessingDate = this.parent.lastUsedDate.getTime();
        }
        if (so.longEndDate == 0L) {
            so.longEndDate = this.parent.lastUsedDate.getTime();
        }
        Date processingDate = new Date(so.longProcessingDate);
        Date endDate = new Date(so.longEndDate);
        Date startDate = new Date(so.longStartDate);
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf2 = null;
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf2 = new SimpleDateFormat("dd/MM/yy HH");
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            sdf = new SimpleDateFormat("MM/dd/yyyy");
            sdf2 = new SimpleDateFormat("MM/dd/yy HH");
        }
        JTextField textDate1 = dm.addJTextFieldWithButton("Processing Date", sdf.format(processingDate), "1>");
        JTextField textDate2 = dm.addJTextFieldWithButton("End Date", sdf.format(endDate), "2>");
        JTextField textDate3 = dm.addJTextFieldWithButton("Start Date", sdf.format(startDate), "3>");
        JComboBox period = dm.addJComboBox("Period");
        dm.addJComboBoxItem(period, "Yearly");
        dm.addJComboBoxItem(period, "Monthly");
        dm.addJComboBoxItem(period, "Weekly");
        dm.addJComboBoxItem(period, "Daily");
        dm.setSelectedJComboBox(period, 1);
        JTextField interval = dm.addJTextField("Interval", "1");
        CheckboxGroup isTransfer = dm.addCheckboxGroup();
        dm.addCheckboxItem("Transfer", "Yes", so.transferFlag, "No", !so.transferFlag, isTransfer);
        JComboBox category = dm.addJComboBox("Category");
        CategoryStore cs = null;
        cs = this.parent.cv == null ? new CategoryStore(this.parent, true) : this.parent.cv.cs;
        Category c = null;
        int n = cs.getNumCategories();
        if (n == 0) {
            cs.setUpCategories();
            n = cs.getNumCategories();
        }
        for (int i = 0; i < n; ++i) {
            c = cs.getCategoryFromIndex(i);
            dm.addJComboBoxItem(category, c.name);
            if (so.category.equals("")) {
                if (!c.name.equals("None")) continue;
                dm.setSelectedJComboBox(category, c.name);
                continue;
            }
            if (!c.name.equals(so.category)) continue;
            dm.setSelectedJComboBox(category, c.name);
        }
        if (this.parent.cv == null) {
            cs.closeCategoryStore();
        }
        JComboBox account = dm.addJComboBox("Account");
        AccountStore as = null;
        as = this.parent.av == null ? new AccountStore(this.parent, true) : this.parent.av.as;
        Account a = null;
        n = as.getNumAccounts();
        for (int i = 0; i < n; ++i) {
            a = as.getAccountFromIndex(i);
            dm.addJComboBoxItem(account, a.name);
            if (!so.account.equals(a.name)) continue;
            dm.setSelectedJComboBox(account, i);
        }
        if (this.parent.av == null) {
            as.closeAccountStore();
        }
        JComboBox currency = dm.addJComboBox("Currency");
        CurrencyStore ccys = null;
        ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
        Currency ccy = null;
        n = ccys.getNumCurrencies();
        for (int i = 0; i < n; ++i) {
            ccy = ccys.getCurrencyFromIndex(i);
            dm.addJComboBoxItem(currency, ccy.code);
            if (!ccy.code.equals(this.parent.homeCurrency)) continue;
            dm.setSelectedJComboBox(currency, i);
        }
        if (this.parent.ccyv == null) {
            ccys.closeCurrencyStore();
        }
        dm.addButton("Cancel");
        dm.addButton("Create");
        dm.centerShow();
        if (!dm.checkButtons()) {
            dm.dispose();
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            return;
        }
        s = dm.getUserText(description).trim();
        if (s.equals("")) {
            Toast.makeText(this.parent, "Blank description", 2000).show();
            dm.dispose();
            this.createStandingOrder(so);
            return;
        }
        so.description = s;
        this.checkForNumericInputType(dm.getUserText(amount));
        so.amount = this.parent.numericEntry ? Utilities.stringToNumber(dm.getUserText(amount), 0, true, this.parent.isEuropeanNumberFormat) : Utilities.expressionToNumber(dm.getUserText(amount), this.parent.isEuropeanNumberFormat);
        if (dm.getSelectedCheckbox(debitOrCredit).getLabel().equals("DR")) {
            so.amount = -so.amount;
        }
        so.reference = dm.getUserText(reference);
        try {
            so.longProcessingDate = sdf2.parse(dm.getUserText(textDate1) + " 02").getTime();
            so.longEndDate = sdf2.parse(dm.getUserText(textDate2) + " 02").getTime();
            so.longStartDate = sdf2.parse(dm.getUserText(textDate3) + " 02").getTime();
        }
        catch (ParseException e) {
            Toast.makeText(this.parent, "Incorrect date", 2000).show();
            so.longProcessingDate = processingDate.getTime();
            so.longEndDate = endDate.getTime();
            so.longStartDate = startDate.getTime();
            dm.dispose();
            this.createStandingOrder(so);
            return;
        }
        if (so.longProcessingDate < so.longStartDate || so.longProcessingDate > so.longEndDate) {
            Toast.makeText(this.parent, "Incorrect date", 2000).show();
            so.longProcessingDate = processingDate.getTime();
            so.longEndDate = endDate.getTime();
            so.longStartDate = startDate.getTime();
            dm.dispose();
            this.createStandingOrder(so);
            return;
        }
        so.period = dm.getSelectedJComboBoxItem(period);
        so.interval = dm.getUserInt(interval);
        so.account = dm.getSelectedJComboBoxString(account);
        if (dm.getSelectedCheckbox(isTransfer).getLabel().equals("Yes")) {
            so.transferFlag = true;
        } else {
            so.transferFlag = false;
            so.category = dm.getSelectedJComboBoxString(category);
        }
        s = dm.getSelectedJComboBoxString(currency);
        if (!s.equals(this.parent.homeCurrency)) {
            so.reference = so.reference.equals("") ? s + " " + Utilities.numberToString(Math.abs(so.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) : s + " " + Utilities.numberToString(Math.abs(so.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + "|" + so.reference;
            ccys = null;
            ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
            ccy = ccys.getCurrencyFromName(s);
            so.amount = Utilities.foreignToHome(so.amount, ccy.rate);
            ccy = null;
            if (this.parent.ccyv == null) {
                ccys.closeCurrencyStore();
                ccys = null;
            }
        }
        if (dm.checkButtonText().equals("1>")) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis(so.longProcessingDate);
            DateChooser dc = new DateChooser((Frame)this.parent, gc);
            if (dc.showDateChooser() == 1) {
                gc = dc.getDate();
            }
            so.longProcessingDate = gc.getTimeInMillis();
            dm.dispose();
            this.createStandingOrder(so);
            return;
        }
        if (dm.checkButtonText().equals("2>")) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis(so.longEndDate);
            DateChooser dc = new DateChooser((Frame)this.parent, gc);
            if (dc.showDateChooser() == 1) {
                gc = dc.getDate();
            }
            so.longEndDate = gc.getTimeInMillis();
            dm.dispose();
            this.createStandingOrder(so);
            return;
        }
        if (dm.checkButtonText().equals("3>")) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis(so.longStartDate);
            DateChooser dc = new DateChooser((Frame)this.parent, gc);
            if (dc.showDateChooser() == 1) {
                gc = dc.getDate();
            }
            so.longStartDate = gc.getTimeInMillis();
            dm.dispose();
            this.createStandingOrder(so);
            return;
        }
        if (so.transferFlag) {
            new TransferForm(this.parent, so, 1, false);
            return;
        }
        this.parent.sov.newStandingOrder(so);
        Toast.makeText(this.parent, "Standing Order created", 1000).show();
        dm.dispose();
    }

    void updateStandingOrder(StandingOrder so) {
        DialogManager dm = new DialogManager(this.parent, "Edit standing order");
        JTextField description = dm.addJTextField("Description", so.description);
        JTextField amount = dm.addJTextField("Amount", Utilities.numberToString(Math.abs(so.amount), this.parent.numericEntry, this.parent.isEuropeanNumberFormat, false));
        boolean state = false;
        if (so.amount > 0) {
            state = true;
        }
        CheckboxGroup debitOrCredit = dm.addCheckboxGroup();
        dm.addCheckboxItem("DR/CR", "DR", !state, "CR", state, debitOrCredit);
        JTextField reference = dm.addJTextField("Reference", so.reference);
        if (so.longProcessingDate == 0L) {
            so.longProcessingDate = this.parent.lastUsedDate.getTime();
        }
        if (so.longEndDate == 0L) {
            so.longEndDate = this.parent.lastUsedDate.getTime();
        }
        if (so.longStartDate == 0L) {
            so.longStartDate = this.parent.lastUsedDate.getTime();
        }
        Date processingDate = new Date(so.longProcessingDate);
        Date endDate = new Date(so.longEndDate);
        Date startDate = new Date(so.longStartDate);
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf2 = null;
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf2 = new SimpleDateFormat("dd/MM/yy HH");
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            sdf = new SimpleDateFormat("MM/dd/yyyy");
            sdf2 = new SimpleDateFormat("MM/dd/yy HH");
        }
        JTextField textDate1 = dm.addJTextFieldWithButton("Processing Date", sdf.format(processingDate), "1>");
        JTextField textDate2 = dm.addJTextFieldWithButton("End Date", sdf.format(endDate), "2>");
        JTextField textDate3 = dm.addJTextFieldWithButton("Start Date", sdf.format(startDate), "3>");
        JComboBox period = dm.addJComboBox("Period");
        dm.addJComboBoxItem(period, "Yearly");
        dm.addJComboBoxItem(period, "Monthly");
        dm.addJComboBoxItem(period, "Weekly");
        dm.addJComboBoxItem(period, "Daily");
        dm.setSelectedJComboBox(period, so.period);
        JTextField interval = dm.addJTextField("Interval", "" + so.interval);
        CheckboxGroup isTransfer = dm.addCheckboxGroup();
        dm.addCheckboxItem("Transfer", "Yes", so.transferFlag, "No", !so.transferFlag, isTransfer);
        JComboBox category = dm.addJComboBox("Category");
        CategoryStore cs = null;
        cs = this.parent.cv == null ? new CategoryStore(this.parent, true) : this.parent.cv.cs;
        Category c = null;
        int n = cs.getNumCategories();
        for (int i = 0; i < n; ++i) {
            c = cs.getCategoryFromIndex(i);
            dm.addJComboBoxItem(category, c.name);
            if (!c.name.equals(so.category)) continue;
            dm.setSelectedJComboBox(category, c.name);
        }
        if (this.parent.cv == null) {
            cs.closeCategoryStore();
        }
        JComboBox account = dm.addJComboBox("Account");
        AccountStore as = null;
        as = this.parent.av == null ? new AccountStore(this.parent, true) : this.parent.av.as;
        Account a = null;
        n = as.getNumAccounts();
        for (int i = 0; i < n; ++i) {
            a = as.getAccountFromIndex(i);
            dm.addJComboBoxItem(account, a.name);
            if (!a.name.equals(so.account)) continue;
            dm.setSelectedJComboBox(account, a.name);
        }
        if (this.parent.av == null) {
            as.closeAccountStore();
        }
        JComboBox currency = dm.addJComboBox("Currency");
        CurrencyStore ccys = null;
        ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
        Currency ccy = null;
        n = ccys.getNumCurrencies();
        for (int i = 0; i < n; ++i) {
            ccy = ccys.getCurrencyFromIndex(i);
            dm.addJComboBoxItem(currency, ccy.code);
            if (!ccy.code.equals(this.parent.homeCurrency)) continue;
            dm.setSelectedJComboBox(currency, i);
        }
        if (this.parent.ccyv == null) {
            ccys.closeCurrencyStore();
        }
        dm.addButton("Cancel");
        dm.addButton("Update");
        dm.centerShow();
        if (!dm.checkButtons()) {
            dm.dispose();
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            return;
        }
        String oldName = so.description;
        String newName = dm.getUserText(description).trim();
        if (newName.equals("")) {
            Toast.makeText(this.parent, "Blank description", 2000).show();
            dm.dispose();
            this.updateStandingOrder(so);
            return;
        }
        so.description = newName;
        int k = so.id;
        if (!oldName.equals(newName) && this.parent.sov.sos.getStandingOrderFromName(newName) != null) {
            Toast.makeText(this.parent, newName + " already exists", 2000).show();
            c.name = oldName;
            dm.dispose();
            this.updateStandingOrder(so);
            return;
        }
        so.id = k;
        this.checkForNumericInputType(dm.getUserText(amount));
        so.amount = this.parent.numericEntry ? Utilities.stringToNumber(dm.getUserText(amount), 0, true, this.parent.isEuropeanNumberFormat) : Utilities.expressionToNumber(dm.getUserText(amount), this.parent.isEuropeanNumberFormat);
        if (dm.getSelectedCheckbox(debitOrCredit).getLabel().equals("DR")) {
            so.amount = -so.amount;
        }
        so.reference = dm.getUserText(reference);
        try {
            so.longProcessingDate = sdf2.parse(dm.getUserText(textDate1) + " 02").getTime();
            so.longEndDate = sdf2.parse(dm.getUserText(textDate2) + " 02").getTime();
            so.longStartDate = sdf2.parse(dm.getUserText(textDate3) + " 02").getTime();
        }
        catch (ParseException e) {
            Toast.makeText(this.parent, "Incorrect date", 2000).show();
            so.longProcessingDate = processingDate.getTime();
            so.longEndDate = endDate.getTime();
            so.longStartDate = startDate.getTime();
            dm.dispose();
            this.updateStandingOrder(so);
            return;
        }
        if (so.longProcessingDate < so.longStartDate || so.longProcessingDate > so.longEndDate) {
            Toast.makeText(this.parent, "Incorrect date", 2000).show();
            so.longProcessingDate = processingDate.getTime();
            so.longEndDate = endDate.getTime();
            so.longStartDate = startDate.getTime();
            dm.dispose();
            this.updateStandingOrder(so);
            return;
        }
        so.period = dm.getSelectedJComboBoxItem(period);
        so.interval = dm.getUserInt(interval);
        so.account = dm.getSelectedJComboBoxString(account);
        if (dm.getSelectedCheckbox(isTransfer).getLabel().equals("Yes")) {
            so.transferFlag = true;
        } else {
            so.transferFlag = false;
            so.category = dm.getSelectedJComboBoxString(category);
        }
        String s = dm.getSelectedJComboBoxString(currency);
        if (!s.equals(this.parent.homeCurrency)) {
            so.reference = so.reference.equals("") ? s + " " + Utilities.numberToString(Math.abs(so.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) : s + " " + Utilities.numberToString(Math.abs(so.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + "|" + so.reference;
            ccys = null;
            ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
            ccy = ccys.getCurrencyFromName(s);
            so.amount = Utilities.foreignToHome(so.amount, ccy.rate);
            ccy = null;
            if (this.parent.ccyv == null) {
                ccys.closeCurrencyStore();
                ccys = null;
            }
        }
        if (dm.checkButtonText().equals("1>")) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis(so.longProcessingDate);
            DateChooser dc = new DateChooser((Frame)this.parent, gc);
            if (dc.showDateChooser() == 1) {
                gc = dc.getDate();
            }
            so.longProcessingDate = gc.getTimeInMillis();
            dm.dispose();
            this.updateStandingOrder(so);
            return;
        }
        if (dm.checkButtonText().equals("2>")) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis(so.longEndDate);
            DateChooser dc = new DateChooser((Frame)this.parent, gc);
            if (dc.showDateChooser() == 1) {
                gc = dc.getDate();
            }
            so.longEndDate = gc.getTimeInMillis();
            dm.dispose();
            this.updateStandingOrder(so);
            return;
        }
        if (dm.checkButtonText().equals("3>")) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis(so.longStartDate);
            DateChooser dc = new DateChooser((Frame)this.parent, gc);
            if (dc.showDateChooser() == 1) {
                gc = dc.getDate();
            }
            so.longStartDate = gc.getTimeInMillis();
            dm.dispose();
            this.updateStandingOrder(so);
            return;
        }
        this.parent.sov.editStandingOrder(so);
        Toast.makeText(this.parent, "Standing Order updated", 1000).show();
        dm.dispose();
    }

    void deleteStandingOrder(StandingOrder so) {
        DialogManager dm = new DialogManager(this.parent, "Delete standing order");
        JTextField description = dm.addJTextField("Description", so.description);
        JTextField amount = dm.addJTextField("Amount", Utilities.numberToString(Math.abs(so.amount), this.parent.numericEntry, this.parent.isEuropeanNumberFormat, false));
        boolean state = false;
        if (so.amount > 0) {
            state = true;
        }
        CheckboxGroup debitOrCredit = dm.addCheckboxGroup();
        dm.addCheckboxItem("DR/CR", "DR", !state, "CR", state, debitOrCredit);
        JTextField reference = dm.addJTextField("Reference", so.reference);
        if (so.longProcessingDate == 0L) {
            so.longProcessingDate = this.parent.lastUsedDate.getTime();
        }
        if (so.longEndDate == 0L) {
            so.longEndDate = this.parent.lastUsedDate.getTime();
        }
        if (so.longStartDate == 0L) {
            so.longStartDate = this.parent.lastUsedDate.getTime();
        }
        Date processingDate = new Date(so.longProcessingDate);
        Date endDate = new Date(so.longEndDate);
        Date startDate = new Date(so.longStartDate);
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf2 = null;
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf2 = new SimpleDateFormat("dd/MM/yy HH");
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            sdf = new SimpleDateFormat("MM/dd/yyyy");
            sdf2 = new SimpleDateFormat("MM/dd/yy HH");
        }
        JTextField textDate1 = dm.addJTextFieldWithButton("Processing Date", sdf.format(processingDate), "1>");
        JTextField textDate2 = dm.addJTextFieldWithButton("End Date", sdf.format(endDate), "2>");
        JTextField textDate3 = dm.addJTextFieldWithButton("Start Date", sdf.format(endDate), "3>");
        JComboBox period = dm.addJComboBox("Period");
        dm.addJComboBoxItem(period, "Yearly");
        dm.addJComboBoxItem(period, "Monthly");
        dm.addJComboBoxItem(period, "Weekly");
        dm.addJComboBoxItem(period, "Daily");
        dm.setSelectedJComboBox(period, so.period);
        JTextField interval = dm.addJTextField("Interval", "" + so.interval);
        CheckboxGroup isTransfer = dm.addCheckboxGroup();
        dm.addCheckboxItem("Transfer", "Yes", so.transferFlag, "No", !so.transferFlag, isTransfer);
        JComboBox category = dm.addJComboBox("Category");
        CategoryStore cs = null;
        cs = this.parent.cv == null ? new CategoryStore(this.parent, true) : this.parent.cv.cs;
        Category c = null;
        int n = cs.getNumCategories();
        for (int i = 0; i < n; ++i) {
            c = cs.getCategoryFromIndex(i);
            dm.addJComboBoxItem(category, c.name);
            if (!c.name.equals(so.category)) continue;
            dm.setSelectedJComboBox(category, c.name);
        }
        if (this.parent.cv == null) {
            cs.closeCategoryStore();
        }
        JComboBox account = dm.addJComboBox("Account");
        AccountStore as = null;
        as = this.parent.av == null ? new AccountStore(this.parent, true) : this.parent.av.as;
        Account a = null;
        n = as.getNumAccounts();
        for (int i = 0; i < n; ++i) {
            a = as.getAccountFromIndex(i);
            dm.addJComboBoxItem(account, a.name);
            if (!a.name.equals(so.account)) continue;
            dm.setSelectedJComboBox(account, a.name);
        }
        if (this.parent.av == null) {
            as.closeAccountStore();
        }
        JComboBox currency = dm.addJComboBox("Currency");
        CurrencyStore ccys = null;
        ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
        Currency ccy = null;
        n = ccys.getNumCurrencies();
        for (int i = 0; i < n; ++i) {
            ccy = ccys.getCurrencyFromIndex(i);
            dm.addJComboBoxItem(currency, ccy.code);
            if (!ccy.code.equals(this.parent.homeCurrency)) continue;
            dm.setSelectedJComboBox(currency, i);
        }
        if (this.parent.ccyv == null) {
            ccys.closeCurrencyStore();
        }
        dm.addButton("Cancel");
        dm.addButton("Delete");
        dm.centerShow();
        if (!dm.checkButtons()) {
            dm.dispose();
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            return;
        }
        this.parent.sov.deleteStandingOrder(so);
        Toast.makeText(this.parent, "Standing Order deleted", 1000).show();
        dm.dispose();
    }

    void checkForNumericInputType(String s) {
        if (s.contains(".")) {
            this.parent.numericEntry = false;
            this.parent.isEuropeanNumberFormat = false;
        }
        if (s.contains(",")) {
            this.parent.numericEntry = false;
            this.parent.isEuropeanNumberFormat = true;
        }
    }
}

