/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.CheckboxGroup;
import java.awt.Component;
import javax.swing.JTextField;
import org.freepoc.Jabp4.Currency;
import org.freepoc.Jabp4.CurrencyStore;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.QuickStartForm;
import org.freepoc.Jabp4.Regular;
import org.freepoc.Jabp4.Split;
import org.freepoc.Jabp4.SplitStore;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.TransactionForm;
import org.freepoc.Jabp4.Utilities;

public class SplitForm
extends Component {
    Jabp parent;
    Transaction t;
    Regular r;
    Currency ccy;
    String action;
    String typeString;
    String selectedCurrency;
    int type;
    int amount;
    int foreignAmount;
    boolean fromQuickStartForm;

    public SplitForm(Jabp context, Object object, int type1, String selectedCurrency1, int foreignAmount1, boolean fromQuickStartForm1, String action1) {
        this.parent = context;
        this.parent.lastUsedScreen = 34;
        this.action = action1;
        this.selectedCurrency = selectedCurrency1;
        this.foreignAmount = foreignAmount1;
        this.fromQuickStartForm = fromQuickStartForm1;
        this.type = type1;
        if (this.type == 0) {
            this.t = (Transaction)object;
            this.typeString = "Transaction";
            this.amount = this.t.amount;
            if (!this.t.splitFlag || this.t.ss.size() < 1) {
                Toast.makeText(this.parent, "Not set up as a Split", 2000).show();
                this.parent.setContentView(this.parent.tv);
            }
            if (this.action.equals("New")) {
                this.createTransactionSplits(this.t);
            }
            if (this.action.equals("Edit")) {
                this.updateTransactionSplits(this.t);
            }
        }
        if (this.type == 1) {
            this.r = (Regular)object;
            this.typeString = "Regular";
            this.amount = this.r.amount;
            if (!this.r.splitFlag || this.r.ss.size() < 1) {
                Toast.makeText(this.parent, "Not set up as a Split", 2000).show();
                this.parent.setContentView(this.parent.tv);
            }
            if (this.action.equals("New")) {
                this.createRegularSplits(this.r);
            }
            if (this.action.equals("Edit")) {
                this.createRegularSplits(this.r);
            }
        }
    }

    void createTransactionSplits(Transaction t) {
        Split split;
        int i;
        this.ccy = new Currency();
        if (!this.selectedCurrency.equals(this.parent.homeCurrency)) {
            CurrencyStore ccys = null;
            ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
            this.ccy = ccys.getCurrencyFromName(this.selectedCurrency);
            if (this.parent.ccyv == null) {
                ccys.closeCurrencyStore();
                ccys = null;
            }
            this.amount = this.foreignAmount;
        }
        int n = t.ss.size();
        JTextField[] splitAmountJTextField = new JTextField[n];
        CheckboxGroup[] debitOrCredit = new CheckboxGroup[n];
        DialogManager dm = new DialogManager(this.parent, "Splits Form:" + this.getRemainAmountString(t.ss));
        for (i = 0; i < n; ++i) {
            split = t.ss.getSplit(i);
            int j = i + 1;
            dm.addText("Split " + j, split.category);
            String string = "";
            if (split.amount != 0) {
                string = Utilities.numberToString(Math.abs(split.amount), this.parent.numericEntry, this.parent.isEuropeanNumberFormat, false);
            }
            splitAmountJTextField[i] = dm.addJTextField("Amount " + j, string);
            boolean state = false;
            if (split.amount > 0) {
                state = true;
            }
            debitOrCredit[i] = dm.addCheckboxGroup();
            dm.addCheckboxItem("DR/CR", "DR", !state, "CR", state, debitOrCredit[i]);
        }
        dm.addOKCancelButtons();
        dm.addButton("Check");
        dm.centerShow();
        if (dm.checkButtonText().equals("Check")) {
            for (i = 0; i < n; ++i) {
                split = t.ss.getSplit(i);
                split.amount = this.parent.numericEntry ? Utilities.stringToNumber(dm.getUserText(splitAmountJTextField[i]), 0, true, this.parent.isEuropeanNumberFormat) : Utilities.expressionToNumber(dm.getUserText(splitAmountJTextField[i]), this.parent.isEuropeanNumberFormat);
                if (dm.getSelectedCheckbox(debitOrCredit[i]).getLabel().equals("DR")) {
                    split.amount = -split.amount;
                }
                t.ss.setSplit(split, i);
            }
            dm.dispose();
            this.createTransactionSplits(t);
            return;
        }
        if (dm.checkButtonText().equals("OK")) {
            this.parent.showMatchedCategories = "";
            this.parent.storeMatchedPosition = 0;
            this.parent.matchedString = "";
            for (i = 0; i < n; ++i) {
                split = t.ss.getSplit(i);
                split.amount = this.parent.numericEntry ? Utilities.stringToNumber(dm.getUserText(splitAmountJTextField[i]), 0, true, this.parent.isEuropeanNumberFormat) : Utilities.expressionToNumber(dm.getUserText(splitAmountJTextField[i]), this.parent.isEuropeanNumberFormat);
                if (dm.getSelectedCheckbox(debitOrCredit[i]).getLabel().equals("DR")) {
                    split.amount = -split.amount;
                }
                t.ss.setSplit(split, i);
            }
            int total = this.getSplitTotal(t.ss);
            if (total != this.amount) {
                String s1 = "" + Math.abs(total);
                s1 = total < 0 ? s1 + " DR" : s1 + " CR";
                String s2 = "" + Math.abs(this.amount);
                s2 = this.amount < 0 ? s2 + " DR" : s2 + " CR";
                Toast.makeText(this.parent, "Splits do not add to " + this.typeString + "\nSplits = " + s1 + "\n" + this.typeString + " = " + s2, 2000).show();
                this.createTransactionSplits(t);
                dm.dispose();
                return;
            }
            SplitStore temp = new SplitStore();
            for (int i2 = 0; i2 < n; ++i2) {
                Split s = t.ss.getSplit(i2);
                if (s.amount == 0) continue;
                temp.addSplit(s);
            }
            t.ss = temp;
            n = t.ss.size();
            if (n == 1) {
                Split s = t.ss.getSplit(0);
                t.category = s.category;
                t.splitFlag = false;
                t.ss = null;
            } else if (!this.selectedCurrency.equals(this.parent.homeCurrency)) {
                n = t.ss.size();
                int splitTotal = 0;
                for (int i3 = 0; i3 < n - 1; ++i3) {
                    Split s = t.ss.getSplit(i3);
                    s.amount = Utilities.foreignToHome(s.amount, this.ccy.rate);
                    splitTotal += s.amount;
                    t.ss.setSplit(s, i3);
                }
                Split s = t.ss.getSplit(n - 1);
                s.amount = t.amount - splitTotal;
                t.ss.setSplit(s, n - 1);
            }
            if (this.fromQuickStartForm) {
                this.parent.newTransaction(t);
                this.parent.lastCreatedTransaction = t;
                this.parent.qsf = new QuickStartForm(this.parent);
                dm.dispose();
                return;
            }
            this.parent.tv.newTransaction(t);
            Toast.makeText(this.parent, this.typeString + " created", 1000).show();
            this.parent.setContentView(this.parent.tv);
            dm.dispose();
            return;
        }
        if (dm.checkButtonText().equals("Cancel")) {
            dm.dispose();
            new TransactionForm(this.parent, t, this.fromQuickStartForm, "Edit");
            return;
        }
    }

    void updateTransactionSplits(Transaction t) {
        Split split;
        int i;
        this.ccy = new Currency();
        if (!this.selectedCurrency.equals(this.parent.homeCurrency)) {
            CurrencyStore ccys = null;
            ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
            this.ccy = ccys.getCurrencyFromName(this.selectedCurrency);
            if (this.parent.ccyv == null) {
                ccys.closeCurrencyStore();
                ccys = null;
            }
            this.amount = this.foreignAmount;
        }
        int n = t.ss.size();
        JTextField[] splitAmountJTextField = new JTextField[n];
        CheckboxGroup[] debitOrCredit = new CheckboxGroup[n];
        DialogManager dm = new DialogManager(this.parent, "Splits Form:" + this.getRemainAmountString(t.ss));
        for (i = 0; i < n; ++i) {
            split = t.ss.getSplit(i);
            int j = i + 1;
            dm.addText("Split " + j, split.category);
            String string = "";
            if (split.amount != 0) {
                string = Utilities.numberToString(Math.abs(split.amount), this.parent.numericEntry, this.parent.isEuropeanNumberFormat, false);
            }
            splitAmountJTextField[i] = dm.addJTextField("Amount " + j, string);
            boolean state = false;
            if (split.amount > 0) {
                state = true;
            }
            debitOrCredit[i] = dm.addCheckboxGroup();
            dm.addCheckboxItem("DR/CR", "DR", !state, "CR", state, debitOrCredit[i]);
        }
        dm.addOKCancelButtons();
        dm.addButton("Check");
        dm.centerShow();
        if (dm.checkButtonText().equals("Check")) {
            for (i = 0; i < n; ++i) {
                split = t.ss.getSplit(i);
                split.amount = this.parent.numericEntry ? Utilities.stringToNumber(dm.getUserText(splitAmountJTextField[i]), 0, true, this.parent.isEuropeanNumberFormat) : Utilities.expressionToNumber(dm.getUserText(splitAmountJTextField[i]), this.parent.isEuropeanNumberFormat);
                if (dm.getSelectedCheckbox(debitOrCredit[i]).getLabel().equals("DR")) {
                    split.amount = -split.amount;
                }
                t.ss.setSplit(split, i);
            }
            dm.dispose();
            this.updateTransactionSplits(t);
            return;
        }
        if (dm.checkButtonText().equals("OK")) {
            this.parent.showMatchedCategories = "";
            this.parent.storeMatchedPosition = 0;
            this.parent.matchedString = "";
            for (i = 0; i < n; ++i) {
                split = t.ss.getSplit(i);
                split.amount = this.parent.numericEntry ? Utilities.stringToNumber(dm.getUserText(splitAmountJTextField[i]), 0, true, this.parent.isEuropeanNumberFormat) : Utilities.expressionToNumber(dm.getUserText(splitAmountJTextField[i]), this.parent.isEuropeanNumberFormat);
                if (dm.getSelectedCheckbox(debitOrCredit[i]).getLabel().equals("DR")) {
                    split.amount = -split.amount;
                }
                t.ss.setSplit(split, i);
            }
            int total = this.getSplitTotal(t.ss);
            if (total != this.amount) {
                String s1 = "" + Math.abs(total);
                s1 = total < 0 ? s1 + " DR" : s1 + " CR";
                String s2 = "" + Math.abs(this.amount);
                s2 = this.amount < 0 ? s2 + " DR" : s2 + " CR";
                Toast.makeText(this.parent, "Splits do not add to " + this.typeString + "\nSplits = " + s1 + "\n" + this.typeString + " = " + s2, 2000).show();
                this.updateTransactionSplits(t);
                dm.dispose();
                return;
            }
            SplitStore temp = new SplitStore();
            for (int i2 = 0; i2 < n; ++i2) {
                Split s = t.ss.getSplit(i2);
                if (s.amount == 0) continue;
                temp.addSplit(s);
            }
            t.ss = temp;
            n = t.ss.size();
            if (n == 1) {
                Split s = t.ss.getSplit(0);
                t.category = s.category;
                t.splitFlag = false;
                t.ss = null;
            } else if (!this.selectedCurrency.equals(this.parent.homeCurrency)) {
                n = t.ss.size();
                int splitTotal = 0;
                for (int i3 = 0; i3 < n - 1; ++i3) {
                    Split s = t.ss.getSplit(i3);
                    s.amount = Utilities.foreignToHome(s.amount, this.ccy.rate);
                    splitTotal += s.amount;
                    t.ss.setSplit(s, i3);
                }
                Split s = t.ss.getSplit(n - 1);
                s.amount = t.amount - splitTotal;
                t.ss.setSplit(s, n - 1);
            }
            this.parent.tv.editTransaction(t, false);
            Toast.makeText(this.parent, this.typeString + " updated", 1000).show();
            this.parent.setContentView(this.parent.tv);
            dm.dispose();
            return;
        }
        if (dm.checkButtonText().equals("Cancel")) {
            dm.dispose();
            new TransactionForm(this.parent, t, this.fromQuickStartForm, "New");
            return;
        }
    }

    void createRegularSplits(Regular r) {
        Split split;
        int i;
        int n = r.ss.size();
        JTextField[] splitAmountJTextField = new JTextField[n];
        CheckboxGroup[] debitOrCredit = new CheckboxGroup[n];
        DialogManager dm = new DialogManager(this.parent, "Splits Form:" + this.getRemainAmountString(r.ss));
        for (i = 0; i < n; ++i) {
            split = r.ss.getSplit(i);
            dm.addText("Split " + i + 1, split.category);
            String string = "";
            if (split.amount != 0) {
                string = Utilities.numberToString(Math.abs(split.amount), this.parent.numericEntry, this.parent.isEuropeanNumberFormat, false);
            }
            splitAmountJTextField[i] = dm.addJTextField("Amount " + i + 1, string);
            boolean state = false;
            if (split.amount > 0) {
                state = true;
            }
            debitOrCredit[i] = dm.addCheckboxGroup();
            dm.addCheckboxItem("DR/CR", "DR", !state, "CR", state, debitOrCredit[i]);
        }
        dm.addOKCancelButtons();
        dm.addButton("Check");
        dm.centerShow();
        if (dm.checkButtonText().equals("Check")) {
            for (i = 0; i < n; ++i) {
                split = r.ss.getSplit(i);
                split.amount = this.parent.numericEntry ? Utilities.stringToNumber(dm.getUserText(splitAmountJTextField[i]), 0, true, this.parent.isEuropeanNumberFormat) : Utilities.expressionToNumber(dm.getUserText(splitAmountJTextField[i]), this.parent.isEuropeanNumberFormat);
                if (dm.getSelectedCheckbox(debitOrCredit[i]).getLabel().equals("DR")) {
                    split.amount = -split.amount;
                }
                r.ss.setSplit(split, i);
            }
            dm.dispose();
            this.createRegularSplits(r);
            return;
        }
        if (dm.checkButtonText().equals("OK")) {
            int id;
            for (i = 0; i < n; ++i) {
                split = r.ss.getSplit(i);
                split.amount = this.parent.numericEntry ? Utilities.stringToNumber(dm.getUserText(splitAmountJTextField[i]), 0, true, this.parent.isEuropeanNumberFormat) : Utilities.expressionToNumber(dm.getUserText(splitAmountJTextField[i]), this.parent.isEuropeanNumberFormat);
                if (dm.getSelectedCheckbox(debitOrCredit[i]).getLabel().equals("DR")) {
                    split.amount = -split.amount;
                }
                r.ss.setSplit(split, i);
            }
            int total = this.getSplitTotal(r.ss);
            if (total != this.amount) {
                String s1 = "" + Math.abs(total);
                s1 = total < 0 ? s1 + " DR" : s1 + " CR";
                String s2 = "" + Math.abs(this.amount);
                s2 = this.amount < 0 ? s2 + " DR" : s2 + " CR";
                Toast.makeText(this.parent, "Splits do not add to " + this.typeString + "\nSplits = " + s1 + "\n" + this.typeString + " = " + s2, 2000).show();
                this.createRegularSplits(r);
                dm.dispose();
                return;
            }
            SplitStore temp = new SplitStore();
            for (int i2 = 0; i2 < n; ++i2) {
                Split s = r.ss.getSplit(i2);
                if (s.amount == 0) continue;
                temp.addSplit(s);
            }
            r.ss = temp;
            n = r.ss.size();
            if (n == 1) {
                Split s = r.ss.getSplit(0);
                r.category = s.category;
                r.splitFlag = false;
                r.ss = null;
            }
            if ((id = this.parent.tv.rs.lookUpId(r)) == 0) {
                r.id = this.parent.tv.rs.saveNewRegular(r);
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(this.parent.tv.rs.toByteArray(r), 5);
                }
                Toast.makeText(this.parent, this.typeString + " created", 2000).show();
            } else {
                this.parent.tv.rs.saveExistingRegular(r);
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(this.parent.tv.rs.toByteArray(r), -5);
                    this.parent.sync.saveSyncRecord(this.parent.tv.rs.toByteArray(r), 5);
                }
                Toast.makeText(this.parent, this.typeString + " updated", 1000).show();
            }
            dm.dispose();
            this.parent.setContentView(this.parent.tv);
            return;
        }
        if (dm.checkButtonText().equals("Cancel")) {
            dm.dispose();
            this.parent.setContentView(this.parent.tv);
            return;
        }
    }

    int getSplitTotal(SplitStore ss) {
        int total = 0;
        int n = ss.size();
        for (int i = 0; i < n; ++i) {
            Split s = ss.getSplit(i);
            total += s.amount;
        }
        return total;
    }

    int numberOfZeroSplits(SplitStore ss) {
        int count = 0;
        for (int i = 0; i < ss.size(); ++i) {
            if (ss.getSplit((int)i).amount != 0) continue;
            ++count;
        }
        return count;
    }

    String getRemainAmountString(SplitStore ss) {
        String s = "   Remain: ";
        int remain = this.amount - this.getSplitTotal(ss);
        s = s + Utilities.numberToString(Math.abs(remain), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        s = remain < 0 ? s + " DR" : s + " CR";
        return s;
    }
}

