/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.freepoc.Jabp4.AccountView;
import org.freepoc.Jabp4.ImportExportForm;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.QuickStartForm;
import org.freepoc.Jabp4.Toast;

public class ShowProgressForm
extends JPanel
implements KeyListener {
    Jabp parent;
    JButton button;
    JTextPane showProgress;
    int returnType;

    public ShowProgressForm(Jabp context, int returnType1) {
        this.parent = context;
        this.parent.lastUsedScreen = 33;
        this.returnType = returnType1;
        this.showProgress = new JTextPane();
        this.showProgress.setEditable(false);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.showProgress);
        scrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                e.getAdjustable().setValue(e.getAdjustable().getMaximum());
            }
        });
        this.button = new JButton("Done");
        this.button.setVisible(false);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowProgressForm.this.processDoneButton();
            }
        });
        this.addKeyListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)scrollPane, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridy = 1;
        this.add((Component)this.button, gbc);
        this.parent.pack();
        this.append("Jabp4 messages\n\n", Color.BLUE, 20);
    }

    void append(String msg) {
        this.append(msg, Color.BLACK, 16);
    }

    void append(String msg, Color color) {
        this.append(msg, color, 16);
    }

    void append(String msg, Color color, int fontSize) {
        SimpleAttributeSet attributes = new SimpleAttributeSet(this.showProgress.getInputAttributes());
        StyleConstants.setForeground(attributes, color);
        StyleConstants.setFontSize(attributes, fontSize);
        try {
            this.showProgress.getStyledDocument().insertString(this.showProgress.getDocument().getLength(), msg, attributes);
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
    }

    void processDoneButton() {
        switch (this.returnType) {
            case 0: {
                this.parent.start();
                return;
            }
            case 1: {
                if (this.parent.ief != null && this.parent.ief.isGooglePaySyncFinished) {
                    if (this.parent.checkPendingTransactions()) {
                        return;
                    }
                    Toast.makeText(this.parent, "No pending transactions to process", 2000).show();
                }
                if (this.parent.av == null) {
                    this.parent.av = new AccountView(this.parent);
                }
                this.parent.av.resetDisplay();
                this.parent.setContentView(this.parent.av);
                return;
            }
            case 2: {
                if (this.parent.ief == null) {
                    this.parent.ief = new ImportExportForm(this.parent, false);
                }
                this.parent.ief.start();
                return;
            }
            case 3: {
                this.parent.setContentView(this.parent.cv);
                return;
            }
            case 4: {
                this.parent.qsf = new QuickStartForm(this.parent);
                return;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.processDoneButton();
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

