/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.NameId;
import org.freepoc.Jabp4.RecordStore;
import org.freepoc.Jabp4.Regular;
import org.freepoc.Jabp4.Split;
import org.freepoc.Jabp4.SplitStore;

public class RegularStore {
    RecordStore rs;
    Jabp parent;
    Hashtable ht;

    public RegularStore(Jabp context, boolean fastDiskAccess) {
        this.parent = context;
        this.ht = this.parent.regularHt;
        this.openRegularStore(fastDiskAccess);
    }

    void openRegularStore(boolean fastDiskAccess) {
        this.rs = new RecordStore(this.parent, "Regulars", fastDiskAccess);
    }

    void closeRegularStore() {
        if (this.rs != null) {
            this.rs.closeRecordStore();
        }
    }

    int getNumRegulars() {
        return this.rs.getNumRecords();
    }

    byte[] toByteArray(Regular r) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeUTF(r.description);
            dos.writeInt(r.amount);
            dos.writeUTF(r.reference);
            dos.writeUTF(r.category);
            dos.writeBoolean(r.transferFlag);
            if (r.transferFlag) {
                dos.writeUTF(r.transferAccount);
            }
            dos.writeBoolean(r.splitFlag);
            if (r.splitFlag) {
                dos.writeInt(r.ss.size());
                for (int i = 0; i < r.ss.size(); ++i) {
                    Split s = r.ss.getSplit(i);
                    dos.writeInt(s.amount);
                    dos.writeUTF(s.category);
                }
            }
            dos.close();
        }
        catch (IOException ie) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    Regular fromByteArray(byte[] bytes) {
        Regular r = new Regular();
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            r.description = dis.readUTF();
            r.amount = dis.readInt();
            r.reference = dis.readUTF();
            r.category = dis.readUTF();
            r.transferFlag = dis.readBoolean();
            if (r.transferFlag) {
                r.transferAccount = dis.readUTF();
            }
            r.splitFlag = dis.readBoolean();
            if (r.splitFlag) {
                r.ss = new SplitStore();
                int k = dis.readInt();
                for (int i = 0; i < k; ++i) {
                    Split s = new Split();
                    s.amount = dis.readInt();
                    s.category = dis.readUTF();
                    r.ss.addSplit(s);
                }
            }
            dis.close();
        }
        catch (IOException ie) {
            System.err.println(ie + " rs4a");
        }
        return r;
    }

    Regular getRegular(int id) {
        Regular r = new Regular();
        byte[] bytes = this.rs.getRecord(id);
        r = this.fromByteArray(bytes);
        r.id = id;
        return r;
    }

    void setToStart() {
        this.rs.setToStart();
    }

    Regular readNextRegular() {
        Regular r = new Regular();
        byte[] bytes = this.rs.readRecord();
        if (bytes == null) {
            return null;
        }
        int id = this.rs.getCurrentFilePosition() - bytes.length - 5;
        r = this.fromByteArray(bytes);
        r.id = id;
        return r;
    }

    Regular getRegularFromIndex(int i) {
        int id = ((NameId)this.ht.get((Object)new Integer((int)i))).id;
        return this.getRegular(id);
    }

    Regular getRegularFromName(String string) {
        int n = this.getNumRegulars();
        for (int i = 0; i < n; ++i) {
            String s1 = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!s1.equals(string)) continue;
            int id = ((NameId)this.ht.get((Object)new Integer((int)i))).id;
            return this.getRegular(id);
        }
        Regular r = new Regular();
        r.description = string;
        r.id = this.saveNewRegular(r);
        return r;
    }

    void deleteRegular(Regular r) {
        this.rs.deleteRecord(r.id);
    }

    int saveNewRegular(Regular r) {
        r.id = this.rs.getNextRecordID();
        byte[] bytes = this.toByteArray(r);
        this.rs.addRecord(bytes, 0, bytes.length);
        this.addIndex(r);
        return r.id;
    }

    int saveNewRegularWithoutIndex(Regular r) {
        r.id = this.rs.getNextRecordID();
        byte[] bytes = this.toByteArray(r);
        this.rs.addRecord(bytes, 0, bytes.length);
        return r.id;
    }

    void saveExistingRegular(Regular r) {
        byte[] bytes = this.toByteArray(r);
        this.rs.setRecord(r.id, bytes, 0, bytes.length);
    }

    void saveExistingRegular(Regular r, boolean movePointer, boolean moveIndex, int index) {
        if (movePointer) {
            this.deleteRegular(r);
            this.saveNewRegularWithoutIndex(r);
        } else {
            this.saveExistingRegular(r);
        }
        if (moveIndex) {
            this.deleteIndex(index);
            this.addIndex(r);
        } else {
            this.updateIndex(index, r);
        }
    }

    int lookUpId(Regular r) {
        r.id = -1;
        int n = this.ht.size();
        for (int i = 0; i < n; ++i) {
            String string = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!string.equals(r.description)) continue;
            r.id = ((NameId)this.ht.get((Object)new Integer((int)i))).id;
            break;
        }
        return r.id;
    }

    int lookUpIndex(Regular r) {
        int n = this.ht.size();
        int j = -1;
        for (int i = 0; i < n; ++i) {
            String string = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!string.equals(r.description)) continue;
            j = i;
            break;
        }
        return j;
    }

    void deleteIndex(Regular r) {
        this.deleteIndex(this.lookUpIndex(r));
    }

    void deleteIndex(int index) {
        int n = this.ht.size();
        for (int i = index; i < n - 1; ++i) {
            int j = i + 1;
            NameId nameId = (NameId)this.ht.get(new Integer(j));
            this.ht.put(new Integer(i), nameId);
        }
        this.ht.remove(new Integer(n - 1));
    }

    void addIndex(Regular r) {
        int i;
        int n;
        int p = n = this.ht.size();
        for (i = 0; i < n; ++i) {
            NameId nameId = (NameId)this.ht.get(new Integer(i));
            if (r.description.compareTo(nameId.name) >= 0) continue;
            p = i;
            break;
        }
        if (p < n) {
            for (i = n - 1; i >= p; --i) {
                int j = i + 1;
                NameId nameId = (NameId)this.ht.get(new Integer(i));
                this.ht.put(new Integer(j), nameId);
            }
        }
        NameId nameId = new NameId(r.description, r.id);
        this.ht.put(new Integer(p), nameId);
    }

    void updateIndex(int index, Regular r) {
        this.ht.put(new Integer(index), new NameId(r.description, r.id));
    }

    int getSize() {
        return this.rs.getSize();
    }
}

