/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.freepoc.Jabp4.Encrypt;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.Toast;

public class RecordStore {
    String directory;
    String name;
    Jabp parent;
    RandomAccessFile raf;
    RandomAccessFile raf2;
    RandomAccessFile raf3;
    int activeRecords;
    int deletedSpace;

    public RecordStore(Jabp context, String name1, boolean fastDiskAccess) {
        this.name = name1;
        this.parent = context;
        this.directory = this.parent.getDir(this.name, 0).toString();
        if (this.raf != null) {
            this.closeRecordStore();
        }
        String s = "rwd";
        if (fastDiskAccess) {
            s = "rw";
        }
        try {
            this.raf = new RandomAccessFile(this.directory + "/Datafile", s);
            this.raf2 = new RandomAccessFile(this.directory + "/Header", s);
            this.raf3 = new RandomAccessFile(this.directory + "/Temporary", s);
        }
        catch (IOException e) {
            Toast.makeText(this.parent, "Could not open files for " + this.name + "\nError: " + e.toString(), 2000).show();
            System.out.println("Could not open files for " + this.name + "\nError: " + e.toString());
            return;
        }
        this.getHeader();
    }

    public void closeRecordStore() {
        if (this.raf == null) {
            return;
        }
        try {
            this.raf.close();
            this.raf2.close();
            this.raf3.close();
        }
        catch (IOException e) {
            Toast.makeText(this.parent, "Could not close files for " + this.name + "\nError: " + e.toString(), 2000).show();
            System.out.println("Could not close files for " + this.name + "\nError: " + e.toString());
        }
    }

    public void deleteRecordStore() {
        File f1 = new File(this.directory + "/Datafile");
        File f2 = new File(this.directory + "/Header");
        File f3 = new File(this.directory + "/Temporary");
        f1.delete();
        f2.delete();
        f3.delete();
    }

    public void getHeader() {
        try {
            this.raf2.seek(0L);
            this.activeRecords = this.raf2.readInt();
            this.deletedSpace = this.raf2.readInt();
            return;
        }
        catch (EOFException e) {
        }
        catch (IOException e) {
            Toast.makeText(this.parent, "Could not get header for " + this.name + "\nError: " + e.toString(), 2000).show();
            System.out.println("Could not get header for " + this.name + "\nError: " + e.toString());
        }
        this.activeRecords = 0;
        this.deletedSpace = 0;
    }

    public void putHeader() {
        try {
            this.raf2.seek(0L);
            this.raf2.writeInt(this.activeRecords);
            this.raf2.writeInt(this.deletedSpace);
        }
        catch (IOException e) {
            Toast.makeText(this.parent, "Could not put header for " + this.name + "\nError: " + e.toString(), 2000).show();
            System.out.println("Could not put header for " + this.name + "\nError: " + e.toString());
        }
    }

    public int getNextRecordID() {
        try {
            return (int)this.raf.length();
        }
        catch (IOException e) {
            Toast.makeText(this.parent, "Could not get next record ID for " + this.name + "\nError: " + e.toString(), 2000).show();
            System.out.println("Could not get next record ID for " + this.name + "\nError: " + e.toString());
            return -1;
        }
    }

    public void setToStart() {
        try {
            this.raf.seek(0L);
        }
        catch (IOException e) {
            Toast.makeText(this.parent, "Could not seek to 0for" + this.name + "\nError: " + e.toString(), 2000).show();
            System.out.println("Could not seek to 0for" + this.name + "\nError: " + e.toString());
        }
    }

    public void seek(int position) {
        try {
            this.raf.seek(position);
        }
        catch (IOException e) {
            Toast.makeText(this.parent, "Could not seek to " + position + "for" + this.name + "\nError: " + e.toString(), 2000).show();
            System.out.println("Could not seek to " + position + "for" + this.name + "\nError: " + e.toString());
        }
    }

    public int getCurrentFilePosition() {
        try {
            return (int)this.raf.getFilePointer();
        }
        catch (IOException e) {
            Toast.makeText(this.parent, "Could not get file position for" + this.name + "\nError: " + e.toString(), 2000).show();
            System.out.println("Could not get file position for" + this.name + "\nError: " + e.toString());
            return -1;
        }
    }

    public byte[] readRecord() {
        try {
            byte[] content;
            boolean validRecord;
            do {
                validRecord = this.raf.readBoolean();
                int length = this.raf.readInt();
                content = new byte[length];
                this.raf.read(content);
            } while (!validRecord);
            content = Encrypt.encrypt(content);
            return content;
        }
        catch (EOFException e) {
            return null;
        }
        catch (IOException e) {
            Toast.makeText(this.parent, "Could not read record for" + this.name + "\nError: " + e.toString(), 2000).show();
            System.out.println("Could not read record for" + this.name + "\nError: " + e.toString());
            return null;
        }
    }

    public int writeRecordToTemporary(byte[] content) {
        try {
            int id = (int)this.raf3.length();
            this.raf3.seek(this.raf3.length());
            this.raf3.writeBoolean(true);
            this.raf3.writeInt(content.length);
            content = Encrypt.encrypt(content);
            this.raf3.write(content);
            return id;
        }
        catch (IOException e) {
            Toast.makeText(this.parent, "Could not write temp record for" + this.name + "\nError: " + e.toString(), 2000).show();
            System.out.println("Could not write temp record for" + this.name + "\nError: " + e.toString());
            return -1;
        }
    }

    public void switchFiles() {
        try {
            this.raf.close();
            this.raf3.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        File f1 = new File(this.directory + "/Datafile");
        File f2 = new File(this.directory + "/Temporary");
        f1.delete();
        f2.renameTo(f1);
    }

    public byte[] getRecord(int id) {
        try {
            if (id < 0) {
                Toast.makeText(this.parent, "Could not get record " + id + " for" + this.name, 2000).show();
                System.out.println("Could not get record " + id + " for" + this.name);
                return null;
            }
            this.raf.seek(id);
            if (!this.raf.readBoolean()) {
                Toast.makeText(this.parent, "Unexpected boolean false for " + this.name, 2000).show();
                System.out.println("Unexpected boolean false for" + this.name);
                return null;
            }
            int length = this.raf.readInt();
            byte[] content = new byte[length];
            this.raf.read(content);
            content = Encrypt.encrypt(content);
            return content;
        }
        catch (IOException e) {
            Toast.makeText(this.parent, "Could not get record " + id + " for" + this.name + "\nError: " + e.toString(), 2000).show();
            System.out.println("Could not get record " + id + " for" + this.name + "\nError: " + e.toString());
            return null;
        }
    }

    public int addRecord(byte[] content, int start, int end) {
        try {
            int id = (int)this.raf.length();
            this.raf.seek(this.raf.length());
            this.raf.writeBoolean(true);
            this.raf.writeInt(end - start);
            content = Encrypt.encrypt(content);
            this.raf.write(content, start, end);
            ++this.activeRecords;
            this.putHeader();
            return id;
        }
        catch (IOException e) {
            Toast.makeText(this.parent, "Could not add record for" + this.name + "\nError: " + e.toString(), 2000).show();
            System.out.println("Could not add record for" + this.name + "\nError: " + e.toString());
            return -1;
        }
    }

    public void setRecord(int id, byte[] content, int start, int end) {
        try {
            if (id < 0) {
                System.out.println("Method rs.setRecord(), negative id = " + id);
                return;
            }
            this.raf.seek(id);
            this.raf.writeBoolean(true);
            this.raf.writeInt(end - start);
            content = Encrypt.encrypt(content);
            this.raf.write(content, start, end);
            return;
        }
        catch (IOException e) {
            Toast.makeText(this.parent, "Could not set record for" + this.name + "\nError: " + e.toString(), 2000).show();
            System.out.println("Could not set record for" + this.name + "\nError: " + e.toString());
            return;
        }
    }

    public void deleteRecord(int id) {
        try {
            if (id < 0) {
                Toast.makeText(this.parent, "Could not delete record " + id + " for" + this.name, 2000).show();
                System.out.println("Could not delete record " + id + " for" + this.name);
                return;
            }
            this.raf.seek(id);
            this.raf.writeBoolean(false);
            int length = this.raf.readInt();
            this.raf.skipBytes(length);
            this.deletedSpace += length + 5;
            --this.activeRecords;
            this.putHeader();
            return;
        }
        catch (IOException e) {
            Toast.makeText(this.parent, "Could not delete record for" + this.name + "\nError: " + e.toString(), 2000).show();
            System.out.println("Could not delete record for" + this.name + "\nError: " + e.toString());
            return;
        }
    }

    public int getNumRecords() {
        return this.activeRecords;
    }

    public void deleteRecordStore(String name) {
        String toDelete = this.parent.getDir(name, 0).toString();
        File dir = new File(toDelete);
        File[] list = dir.listFiles();
        int n = list.length;
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            list[i].delete();
        }
    }

    public static void deleteRecordStore(Jabp parent1, String name) {
        String toDelete = parent1.getDir(name, 0).toString();
        File dir = new File(toDelete);
        File[] list = dir.listFiles();
        int n = list.length;
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            list[i].delete();
        }
    }

    public int getSize() {
        File dir = new File(this.directory);
        File[] list = dir.listFiles();
        int n = list.length;
        if (n == 0) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < n; ++i) {
            size += (int)list[i].length();
        }
        return size;
    }
}

