/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.JList;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.GenericShowForm;
import org.freepoc.Jabp4.ImportExportForm;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.RegularList;
import org.freepoc.Jabp4.RegularStore;
import org.freepoc.Jabp4.SplitStore;
import org.freepoc.Jabp4.StandingOrderStore;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.TransactionForm;

public class QuickStartForm
extends Component {
    Jabp parent;
    int selectedOption = 0;

    public QuickStartForm(Jabp context) {
        this.parent = context;
        this.parent.lastUsedScreen = 28;
        this.parent.lastUsedView = 28;
        final DialogManager dm = new DialogManager(this.parent, "Quick Start Form");
        final JList optionsJList = dm.addJList("Option", 8, false);
        optionsJList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 1) {
                    int i = optionsJList.getHeight() / 8;
                    QuickStartForm.this.selectedOption = me.getPoint().y / i;
                    dm.dispatchEvent(new WindowEvent(dm, 201));
                    dm.dispose();
                }
            }
        });
        dm.addJListItem(optionsJList, "Main Program");
        dm.addJListItem(optionsJList, "New Transaction");
        dm.addJListItem(optionsJList, "New Trans (Regular)");
        dm.addJListItem(optionsJList, "New Split");
        dm.addJListItem(optionsJList, "Pending Transactions");
        dm.addJListItem(optionsJList, "Match Transaction by Voice");
        dm.addJListItem(optionsJList, "Show last Transaction");
        dm.addJListItem(optionsJList, "Exit");
        dm.centerShow();
        switch (this.selectedOption) {
            case 0: {
                if (this.parent.passwordMode) {
                    this.parent.checkPassword();
                    return;
                }
                this.parent.completeStart();
                return;
            }
            case 1: {
                Transaction t2 = new Transaction();
                this.parent.trf = new TransactionForm(this.parent, t2, true, "New");
                break;
            }
            case 2: {
                RegularStore rs = new RegularStore(this.parent, true);
                int n1 = rs.getNumRegulars();
                rs.closeRegularStore();
                if (n1 == 0) {
                    Toast.makeText(this.parent, "No Regulars set up", 2000).show();
                    new QuickStartForm(this.parent);
                    break;
                }
                new RegularList(this.parent, true);
                break;
            }
            case 3: {
                Transaction t2 = new Transaction();
                t2.splitFlag = true;
                t2.ss = new SplitStore();
                this.parent.trf = new TransactionForm(this.parent, t2, true, "New");
                break;
            }
            case 4: {
                this.parent.sos = new StandingOrderStore(this.parent, true);
                if (this.parent.sos.checkStandingOrders(this.parent.todayDate.getTime())) {
                    this.parent.processStandingOrders();
                }
                this.parent.sos.closeStandingOrderStore();
                this.parent.ief = new ImportExportForm(this.parent, false);
                if (this.parent.ief.checkAlexa() || this.parent.ief.checkAndroidPay()) {
                    if (!this.parent.ief.processPendingTransactions()) {
                        Toast.makeText(this.parent, "There are no pending transactions", 2000).show();
                    }
                    new QuickStartForm(this.parent);
                    break;
                }
                Toast.makeText(this.parent, "There are no pending transactions", 2000).show();
                new QuickStartForm(this.parent);
                break;
            }
            case 5: {
                Toast.makeText(this.parent, "Not yet implemented", 2000).show();
                new QuickStartForm(this.parent);
                break;
            }
            case 6: {
                if (this.parent.lastCreatedTransaction == null) {
                    Toast.makeText(this.parent, "No previous transaction created", 2000).show();
                    new QuickStartForm(this.parent);
                    break;
                }
                this.parent.gsf = new GenericShowForm(this.parent, this.parent.lastCreatedTransaction, 2);
                this.parent.setContentView(this.parent.gsf);
                new QuickStartForm(this.parent);
                break;
            }
            case 7: {
                this.parent.finishAndQuit();
            }
        }
    }
}

