/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Frame;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import javax.swing.JTextField;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.AccountStore;
import org.freepoc.Jabp4.Category;
import org.freepoc.Jabp4.CategoryStore;
import org.freepoc.Jabp4.DateChooser;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.ShowProgressForm;
import org.freepoc.Jabp4.Split;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.TransactionStore;
import org.freepoc.Jabp4.Utilities;

public class PurgeForm
extends Component {
    Jabp parent;
    AccountStore as;
    CategoryStore cs;
    boolean includeReconciledOnly = true;
    boolean warningMessageDisplayed = false;
    Date fromDate;
    Date toDate;

    public PurgeForm(Jabp context) {
        this.parent = context;
        this.parent.lastUsedScreen = 27;
        this.fromDate = new Date();
        this.toDate = new Date();
        while (true) {
            DateChooser dc;
            GregorianCalendar gc;
            DialogManager dm = new DialogManager(this.parent, "Purge data");
            Date date = new Date(this.parent.lastUsedDate.getTime());
            SimpleDateFormat sdf = null;
            SimpleDateFormat sdf2 = null;
            if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
                sdf = new SimpleDateFormat("dd/MM/yyyy");
                sdf2 = new SimpleDateFormat("dd/MM/yy HH");
            }
            if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
                sdf = new SimpleDateFormat("MM/dd/yyyy");
                sdf2 = new SimpleDateFormat("MM/dd/yy HH");
            }
            JTextField tfFromDate = dm.addJTextFieldWithButton("From date", sdf.format(this.fromDate), "1>");
            JTextField tfToDate = dm.addJTextFieldWithButton("To date", sdf.format(this.toDate), "2>");
            CheckboxGroup cbReconciledOnly = dm.addCheckboxGroup();
            dm.addCheckboxItem("Reconciled only", "Yes", this.includeReconciledOnly, "No", !this.includeReconciledOnly, cbReconciledOnly);
            dm.addButton("Cancel");
            dm.addButton("Purge");
            dm.addButton("Delete All Data");
            dm.centerShow();
            if (!dm.checkButtons()) {
                dm.dispose();
                Toast.makeText(this.parent, "Cancelled", 1000).show();
                return;
            }
            this.includeReconciledOnly = dm.getSelectedCheckbox(cbReconciledOnly).getLabel().equals("Yes");
            if (dm.checkButtonText().equals("1>")) {
                gc = new GregorianCalendar();
                gc.setTime(this.fromDate);
                dc = new DateChooser((Frame)this.parent, gc);
                if (dc.showDateChooser() == 1) {
                    gc = dc.getDate();
                }
                this.fromDate = gc.getTime();
                dm.dispose();
                continue;
            }
            try {
                this.fromDate = sdf2.parse(dm.getUserText(tfFromDate) + " 02");
            }
            catch (ParseException e) {
                Toast.makeText(this.parent, "Incorrect date", 2000).show();
                dm.dispose();
                continue;
            }
            if (dm.checkButtonText().equals("2>")) {
                gc = new GregorianCalendar();
                gc.setTime(this.toDate);
                dc = new DateChooser((Frame)this.parent, gc);
                if (dc.showDateChooser() == 1) {
                    gc = dc.getDate();
                }
                this.toDate = gc.getTime();
                dm.dispose();
                continue;
            }
            try {
                this.toDate = sdf2.parse(dm.getUserText(tfToDate) + " 02");
            }
            catch (ParseException e) {
                Toast.makeText(this.parent, "Incorrect date", 2000).show();
                dm.dispose();
                continue;
            }
            if (dm.checkButtonText().equals("Purge")) {
                if (this.warningMessageDisplayed) {
                    this.parent.spf = new ShowProgressForm(this.parent, 1);
                    this.parent.setContentView(this.parent.spf);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            PurgeForm.this.processPurge();
                        }
                    }).start();
                    dm.dispose();
                    break;
                }
                Toast.makeText(this.parent, "Warning: this deletes your transactions\nbetween the specified dates.\nClick purge to proceed", 2000).show();
                this.warningMessageDisplayed = true;
                dm.dispose();
                continue;
            }
            if (!dm.checkButtonText().equals("Delete All Data")) continue;
            if (this.warningMessageDisplayed) {
                this.parent.deleteAllData = true;
                this.parent.finishAndQuit();
                break;
            }
            Toast.makeText(this.parent, "Warning: this option **Deletes All Data**\nClick again to delete all your data\nand quit the program", 2000).show();
            this.warningMessageDisplayed = true;
            dm.dispose();
        }
    }

    void processPurge() {
        this.parent.busyWithProcess = true;
        this.parent.show("Starting purge...");
        long ld1 = Utilities.longToDays(this.fromDate.getTime());
        long ld2 = Utilities.longToDays(this.toDate.getTime());
        if (this.parent.av != null) {
            this.parent.av.as.closeAccountStore();
        }
        if (this.parent.cv != null) {
            this.parent.cv.cs.closeCategoryStore();
            this.parent.cv = null;
        }
        if (this.parent.tv != null) {
            this.parent.tv.ts.closeTransactionStore();
            this.parent.tv.rs.closeRegularStore();
            this.parent.tv = null;
        }
        this.as = new AccountStore(this.parent, true);
        this.cs = new CategoryStore(this.parent, true);
        TransactionStore ts = new TransactionStore(this.parent, new Account(), true);
        ts.rs.activeRecords = 0;
        this.parent.transactionHt = new Hashtable();
        Account a = null;
        this.as.setToStart();
        while ((a = this.as.readNextAccount()) != null) {
            this.parent.transactionHt.put(a.name, new Hashtable());
        }
        Transaction t = null;
        ts.setToStart();
        int overallCount = 0;
        int transactionsPurged = 0;
        int transactionsKept = 0;
        while ((t = ts.readNextTransaction()) != null) {
            a = this.as.getAccountFromName(t.account);
            if (++overallCount == overallCount / 1000 * 1000) {
                this.parent.show(overallCount + " transactions read");
            }
            long lt = Utilities.longToDays(t.longDate);
            boolean keep = true;
            if (lt >= ld1 && lt <= ld2 && (!this.includeReconciledOnly || this.includeReconciledOnly && t.reconciled)) {
                this.updateOpenBalances(t, a);
                keep = false;
            }
            if (keep) {
                ts.getIndex(a);
                byte[] bytes = ts.toByteArray(t);
                t.id = ts.rs.writeRecordToTemporary(bytes);
                ts.addIndex(t);
                ts.setIndex(a);
                ++ts.rs.activeRecords;
                ++transactionsKept;
                continue;
            }
            ++transactionsPurged;
        }
        ts.rs.deletedSpace = 0;
        ts.rs.putHeader();
        ts.closeTransactionStore();
        ts.rs.switchFiles();
        this.cs.closeCategoryStore();
        this.as.closeAccountStore();
        this.parent.show("\nTransactions purged: " + transactionsPurged);
        this.parent.show("\nTransactions kept: " + transactionsKept);
        this.parent.show("\nSuccess: click Done to continue");
        this.parent.showDoneButton();
        this.parent.busyWithProcess = false;
    }

    void updateOpenBalances(Transaction t, Account a) {
        a.open += t.amount;
        this.as.saveExistingAccount(a);
        if (!t.transferFlag) {
            if (t.splitFlag) {
                for (int i = 0; i < t.ss.size(); ++i) {
                    Split s = t.ss.getSplit(i);
                    Category c = this.cs.getCategoryFromName(s.category);
                    c.current += s.amount;
                    this.cs.saveExistingCategory(c);
                }
            } else {
                Category c = this.cs.getCategoryFromName(t.category);
                c.current += t.amount;
                this.cs.saveExistingCategory(c);
            }
        }
    }
}

