/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.RecordStore;

public class PreferenceStore {
    RecordStore rs;
    Jabp parent;

    public PreferenceStore(Jabp context, boolean fastDiskAccess) {
        this.parent = context;
        this.rs = new RecordStore(this.parent, "Preferences", fastDiskAccess);
    }

    void closePreferenceStore() {
        if (this.rs != null) {
            this.rs.closeRecordStore();
        }
    }

    int getNumPreferences() {
        if (this.rs == null) {
            return 0;
        }
        return this.rs.getNumRecords();
    }

    byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeUTF(this.parent.homeCurrency);
            dos.writeBoolean(this.parent.useOnlineBanksJabpLite);
            dos.writeInt(this.parent.fontAdjustmentJabpLite);
            dos.writeInt(this.parent.widthAdjustmentJabpLite);
            dos.writeInt(this.parent.colorHeadingJabpLite);
            dos.writeInt(this.parent.colorCursorJabpLite);
            dos.writeInt(this.parent.colorBackgroundJabpLite);
            dos.writeBoolean(this.parent.passwordMode);
            dos.writeUTF(this.parent.password);
            dos.writeInt(this.parent.dateFormatJabpLite);
            dos.writeInt(this.parent.heightAdjustmentJabpLite);
            dos.writeBoolean(this.parent.numericEntryJabpLite);
            dos.writeBoolean(this.parent.allowInputExpressionsJabpLite);
            dos.writeBoolean(this.parent.quickStartJabpLite);
            dos.writeUTF(this.parent.lastAccountJabpLite);
            dos.writeBoolean(this.parent.createFormsInBackgroundJabpLite);
            dos.writeBoolean(this.parent.showFullCanvasJabpLite);
            dos.writeBoolean(false);
            dos.writeBoolean(this.parent.changedKeysJabpLite);
            dos.writeBoolean(this.parent.runningTotalJabpLite);
            dos.writeBoolean(this.parent.isEuropeanNumberFormatJabpLite);
            dos.writeBoolean(this.parent.isGroupingUsedJabpLite);
            dos.writeBoolean(this.parent.syncModeJabpLite);
            dos.writeBoolean(this.parent.showBalanceTypeJabpLite);
            dos.writeBoolean(this.parent.passwordWhenBackgroundJabpLite);
            dos.writeBoolean(this.parent.oldStyleChoiceJabpLite);
            dos.writeInt(this.parent.holdingDecimalPlaces);
            dos.writeInt(this.parent.priceDecimalPlaces);
            dos.writeInt(this.parent.accountColumnsPortraitJabpLite);
            dos.writeInt(this.parent.accountColumnsLandscapeJabpLite);
            dos.writeInt(this.parent.colorFontJabpLite);
            dos.writeInt(this.parent.colorMessageJabpLite);
            dos.writeBoolean(this.parent.preferCategoryInTransactionViewJabpLite);
            dos.writeBoolean(this.parent.showMenuAccountViewJabpLite);
            dos.writeBoolean(this.parent.longTapEqualsOneSecondJabpLite);
            dos.writeBoolean(this.parent.showMenuTransactionViewJabpLite);
            dos.writeBoolean(false);
            dos.writeInt(this.parent.matchDescriptionNumberJabpLite);
            dos.writeInt(this.parent.lineSpacingJabpLite);
            dos.writeBoolean(this.parent.useCanvasMenuJabpLite);
            dos.writeBoolean(this.parent.autoBackupOnExitJabpLite);
            dos.writeBoolean(false);
            dos.writeBoolean(this.parent.saveStateOnPauseJabpLite);
            dos.writeBoolean(this.parent.normalSortOrderJabpLite);
            dos.writeBoolean(this.parent.autoSyncJabpLite);
            this.parent.useBackupEncryptionJabpLite = this.parent.useEncryption;
            dos.writeBoolean(this.parent.useBackupEncryptionJabpLite);
            dos.writeBoolean(this.parent.usePhoneKeypadForNumbersJabpLite);
            dos.writeBoolean(this.parent.hideAmountsInQuickStartJabpLite);
            dos.writeBoolean(this.parent.copyToDropboxJabpLite);
            dos.writeUTF(this.parent.dropboxDirectoryJabpLite);
            dos.writeBoolean(this.parent.saveStateOnHomeJabpLite);
            dos.writeBoolean(this.parent.showActionBarJabpLite);
            dos.writeInt(this.parent.fontSizeJabpLite);
            dos.writeUTF(this.parent.lastQuickStartAccountJabpLite);
            dos.writeInt(this.parent.colorNegativeJabpLite);
            dos.writeBoolean(this.parent.useAlertMenuJabpLite);
            dos.writeBoolean(this.parent.showMessageIfAPHelperServiceNotRunningJabpLite);
            dos.writeBoolean(this.parent.askBeforeProcessingStandingOrders);
            dos.writeBoolean(this.parent.useFingerprintCheckJabpLite);
            dos.writeBoolean(this.parent.matchDescriptionAnywhere);
            dos.writeBoolean(this.parent.hideInactiveAccountsJabpLite);
            dos.writeBoolean(this.parent.showInactiveAccountsWithAsteriskJabpLite);
            dos.writeBoolean(this.parent.enableShortcutsJabpLite);
            dos.writeBoolean(this.parent.allowPendingTransactionsFromOtherDevicesJabpLite);
            dos.writeBoolean(this.parent.useBiometricCheckJabpLite);
            dos.writeBoolean(this.parent.reconcileGooglePayTransactionsJabpLite);
            dos.writeBoolean(this.parent.reconcileOnlineBankTransactionsJabpLite);
            dos.writeBoolean(this.parent.isUsingSingleLineJabpLite);
            dos.writeUTF(this.parent.alphaVantageKey);
            dos.writeBoolean(this.parent.uploadJabpLiteSyncToDropboxJabpLite);
            dos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    void fromByteArray(byte[] bytes) {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            this.parent.homeCurrency = dis.readUTF();
            this.parent.useOnlineBanksJabpLite = dis.readBoolean();
            this.parent.fontAdjustmentJabpLite = dis.readInt();
            this.parent.widthAdjustmentJabpLite = dis.readInt();
            this.parent.colorHeadingJabpLite = dis.readInt();
            this.parent.colorCursorJabpLite = dis.readInt();
            this.parent.colorBackgroundJabpLite = dis.readInt();
            this.parent.passwordMode = dis.readBoolean();
            this.parent.password = dis.readUTF();
            this.parent.dateFormatJabpLite = dis.readInt();
            this.parent.heightAdjustmentJabpLite = dis.readInt();
            this.parent.numericEntryJabpLite = dis.readBoolean();
            this.parent.allowInputExpressionsJabpLite = dis.readBoolean();
            this.parent.quickStartJabpLite = dis.readBoolean();
            this.parent.lastAccountJabpLite = dis.readUTF();
            this.parent.createFormsInBackgroundJabpLite = dis.readBoolean();
            this.parent.showFullCanvasJabpLite = dis.readBoolean();
            dis.readBoolean();
            this.parent.changedKeysJabpLite = dis.readBoolean();
            this.parent.runningTotalJabpLite = dis.readBoolean();
            this.parent.isEuropeanNumberFormatJabpLite = dis.readBoolean();
            this.parent.isGroupingUsedJabpLite = dis.readBoolean();
            this.parent.syncModeJabpLite = dis.readBoolean();
            this.parent.showBalanceTypeJabpLite = dis.readBoolean();
            this.parent.passwordWhenBackgroundJabpLite = dis.readBoolean();
            this.parent.oldStyleChoiceJabpLite = dis.readBoolean();
            this.parent.holdingDecimalPlaces = dis.readInt();
            this.parent.priceDecimalPlaces = dis.readInt();
            this.parent.accountColumnsPortraitJabpLite = dis.readInt();
            this.parent.accountColumnsLandscapeJabpLite = dis.readInt();
            this.parent.colorFontJabpLite = dis.readInt();
            this.parent.colorMessageJabpLite = dis.readInt();
            this.parent.preferCategoryInTransactionViewJabpLite = dis.readBoolean();
            this.parent.showMenuAccountViewJabpLite = dis.readBoolean();
            this.parent.longTapEqualsOneSecondJabpLite = dis.readBoolean();
            this.parent.showMenuTransactionViewJabpLite = dis.readBoolean();
            dis.readBoolean();
            this.parent.matchDescriptionNumberJabpLite = dis.readInt();
            this.parent.lineSpacingJabpLite = dis.readInt();
            this.parent.useCanvasMenuJabpLite = dis.readBoolean();
            this.parent.autoBackupOnExitJabpLite = dis.readBoolean();
            dis.readBoolean();
            this.parent.saveStateOnPauseJabpLite = dis.readBoolean();
            this.parent.normalSortOrderJabpLite = dis.readBoolean();
            this.parent.autoSyncJabpLite = dis.readBoolean();
            this.parent.useEncryption = this.parent.useBackupEncryptionJabpLite = dis.readBoolean();
            this.parent.usePhoneKeypadForNumbersJabpLite = dis.readBoolean();
            this.parent.hideAmountsInQuickStartJabpLite = dis.readBoolean();
            this.parent.copyToDropboxJabpLite = dis.readBoolean();
            this.parent.dropboxDirectoryJabpLite = dis.readUTF();
            this.parent.saveStateOnHomeJabpLite = dis.readBoolean();
            this.parent.showActionBarJabpLite = dis.readBoolean();
            this.parent.fontSizeJabpLite = dis.readInt();
            this.parent.lastQuickStartAccountJabpLite = dis.readUTF();
            this.parent.colorNegativeJabpLite = dis.readInt();
            this.parent.useAlertMenuJabpLite = dis.readBoolean();
            this.parent.showMessageIfAPHelperServiceNotRunningJabpLite = dis.readBoolean();
            this.parent.askBeforeProcessingStandingOrders = dis.readBoolean();
            this.parent.useFingerprintCheckJabpLite = dis.readBoolean();
            this.parent.matchDescriptionAnywhere = dis.readBoolean();
            this.parent.hideInactiveAccountsJabpLite = dis.readBoolean();
            this.parent.showInactiveAccountsWithAsteriskJabpLite = dis.readBoolean();
            this.parent.enableShortcutsJabpLite = dis.readBoolean();
            this.parent.allowPendingTransactionsFromOtherDevicesJabpLite = dis.readBoolean();
            this.parent.useBiometricCheckJabpLite = dis.readBoolean();
            this.parent.reconcileGooglePayTransactionsJabpLite = dis.readBoolean();
            this.parent.reconcileOnlineBankTransactionsJabpLite = dis.readBoolean();
            this.parent.isUsingSingleLineJabpLite = dis.readBoolean();
            this.parent.alphaVantageKey = dis.readUTF();
            this.parent.uploadJabpLiteSyncToDropboxJabpLite = dis.readBoolean();
            dis.close();
        }
        catch (IOException ie) {
            System.err.println(ie + " ps4a");
        }
    }

    void getPasswordOnly(byte[] bytes) {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            this.parent.homeCurrency = dis.readUTF();
            dis.readBoolean();
            dis.readInt();
            dis.readInt();
            dis.readInt();
            dis.readInt();
            dis.readInt();
            this.parent.passwordMode = dis.readBoolean();
            this.parent.password = dis.readUTF();
            dis.readInt();
            dis.readInt();
            dis.readBoolean();
            dis.readBoolean();
            dis.readBoolean();
            dis.readUTF();
            dis.readBoolean();
            dis.readBoolean();
            dis.readBoolean();
            dis.readBoolean();
            dis.readBoolean();
            dis.readBoolean();
            dis.readBoolean();
            dis.readBoolean();
            dis.readBoolean();
            dis.readBoolean();
            dis.readBoolean();
            this.parent.holdingDecimalPlaces = dis.readInt();
            this.parent.priceDecimalPlaces = dis.readInt();
            dis.close();
        }
        catch (IOException ie) {
            System.err.println(ie + " ps4a");
        }
    }

    void getPreferences() {
        if (this.rs.getNumRecords() == 0) {
            return;
        }
        byte[] bytes = this.rs.getRecord(0);
        this.fromByteArray(bytes);
        this.getJabp4Properties();
    }

    void getJabp4Properties() {
        this.parent.jabpFile = this.getString("jabpFile", this.parent.jabpFile);
        this.parent.homeCurrency = this.getString("homeCurrency", this.parent.homeCurrency);
        this.parent.lastAccount = this.getString("lastAccount", this.parent.lastAccount);
        this.parent.holdingDecimalPlaces = this.getInt("holdingDecimalPlaces", this.parent.holdingDecimalPlaces);
        this.parent.priceDecimalPlaces = this.getInt("priceDecimalPlaces", this.parent.priceDecimalPlaces);
        this.parent.useCanvasMenu = this.getBoolean("useCanvasMenu", this.parent.useCanvasMenu);
        this.parent.showMenuAccountView = this.getBoolean("showMenuAccountView", this.parent.showMenuAccountView);
        this.parent.showMenuTransactionView = this.getBoolean("showMenuTransactionView", this.parent.showMenuTransactionView);
        this.parent.colorHeading = this.getInt("colorHeading", this.parent.colorHeading);
        this.parent.colorCursor = this.getInt("colorCursor", this.parent.colorCursor);
        this.parent.colorBackground = this.getInt("colorBackground", this.parent.colorBackground);
        this.parent.colorFont = this.getInt("colorFont", this.parent.colorFont);
        this.parent.colorMessage = this.getInt("colorMessage", this.parent.colorMessage);
        this.parent.colorNegative = this.getInt("colorNegative", this.parent.colorNegative);
        this.parent.fontSize = this.getInt("fontSize", this.parent.fontSize);
        this.parent.lineSpacing = this.getInt("lineSpacing", this.parent.lineSpacing);
        this.parent.widthAdjustment = this.getInt("widthAdjustment", this.parent.widthAdjustment);
        this.parent.fontAdjustment = this.getInt("fontAdjustment", this.parent.fontAdjustment);
        this.parent.heightAdjustment = this.getInt("heightAdjustment", this.parent.heightAdjustment);
        this.parent.numericEntry = this.getBoolean("numericEntry", this.parent.numericEntry);
        this.parent.allowInputExpressions = this.getBoolean("allowInputExpressions", this.parent.allowInputExpressions);
        this.parent.isEuropeanNumberFormat = this.getBoolean("isEuropeanNumberFormat", this.parent.isEuropeanNumberFormat);
        this.parent.isGroupingUsed = this.getBoolean("isGroupingUsed", this.parent.isGroupingUsed);
        this.parent.dateFormat = this.getInt("dateFormat", this.parent.dateFormat);
        this.parent.autoBackupOnExit = this.getBoolean("autoBackupOnExit", this.parent.autoBackupOnExit);
        this.parent.useBackupEncryption = this.getBoolean("useBackupEncryption", this.parent.useBackupEncryption);
        this.parent.quickStart = this.getBoolean("quickStart", this.parent.quickStart);
        this.parent.hideAmountsInQuickStart = this.getBoolean("hideAmountsInQuickStart", this.parent.hideAmountsInQuickStart);
        this.parent.matchDescriptionNumber = this.getInt("matchDescriptionNumber", this.parent.matchDescriptionNumber);
        this.parent.accountColumnsPortrait = this.getInt("accountColumnsPortrait", this.parent.accountColumnsPortrait);
        this.parent.accountColumnsLandscape = this.getInt("accountColumnsLandscape", this.parent.accountColumnsLandscape);
        this.parent.normalSortOrder = this.getBoolean("normalSortOrder", this.parent.normalSortOrder);
        this.parent.showBalanceType = this.getBoolean("showBalanceType", this.parent.showBalanceType);
        this.parent.preferCategoryInTransactionView = this.getBoolean("preferCategoryInTransactionView", this.parent.preferCategoryInTransactionView);
        this.parent.syncMode = this.getBoolean("syncMode", this.parent.syncMode);
        this.parent.copyToDropbox = this.getBoolean("copyToDropbox", this.parent.copyToDropbox);
        this.parent.dropboxDirectory = this.getString("dropboxDirectory", this.parent.dropboxDirectory);
        this.parent.allowPendingTransactionsFromOtherDevices = this.getBoolean("allowPendingTransactionsFromOtherDevices", this.parent.allowPendingTransactionsFromOtherDevices);
        this.parent.serializedCredential = this.getString("serializedCredential", this.parent.serializedCredential);
        this.parent.hideInactiveAccounts = this.getBoolean("hideInactiveAccounts", this.parent.hideInactiveAccounts);
        this.parent.showInactiveAccountsWithAsterisk = this.getBoolean("showInactiveAccountsWithAsterisk", this.parent.showInactiveAccountsWithAsterisk);
        this.parent.longTapEqualsOneSecond = this.getBoolean("longTapEqualsOneSecond", this.parent.longTapEqualsOneSecond);
        this.parent.fontAdjustmentJabpLite = this.getInt("fontAdjustmentJabpLite", this.parent.fontAdjustmentJabpLite);
        this.parent.widthAdjustmentJabpLite = this.getInt("widthAdjustmentJabpLite", this.parent.widthAdjustmentJabpLite);
        this.parent.heightAdjustmentJabpLite = this.getInt("heightAdjustmentJabpLite", this.parent.heightAdjustmentJabpLite);
        this.parent.quickStartJabpLite = this.getBoolean("quickStartJabpLite", this.parent.quickStartJabpLite);
        this.parent.passwordWhenBackgroundJabpLite = this.getBoolean("passwordWhenBackgroundJabpLite", this.parent.passwordWhenBackgroundJabpLite);
        this.parent.accountColumnsPortraitJabpLite = this.getInt("accountColumnsPortraitJabpLite", this.parent.accountColumnsPortraitJabpLite);
        this.parent.accountColumnsLandscapeJabpLite = this.getInt("accountColumnsLandscapeJabpLite", this.parent.accountColumnsLandscapeJabpLite);
        this.parent.longTapEqualsOneSecondJabpLite = this.getBoolean("longTapEqualsOneSecondJabpLite", this.parent.longTapEqualsOneSecondJabpLite);
        this.parent.lineSpacingJabpLite = this.getInt("lineSpacingJabpLite", this.parent.lineSpacingJabpLite);
        this.parent.usePhoneKeypadForNumbersJabpLite = this.getBoolean("usePhoneKeypadForNumbersJabpLite", this.parent.usePhoneKeypadForNumbersJabpLite);
        this.parent.copyToDropboxJabpLite = this.getBoolean("copyToDropboxJabpLite", this.parent.copyToDropboxJabpLite);
        this.parent.showActionBarJabpLite = this.getBoolean("showActionBarJabpLite", this.parent.showActionBarJabpLite);
        this.parent.fontSizeJabpLite = this.getInt("fontSizeJabpLite", this.parent.fontSizeJabpLite);
        this.parent.useAlertMenuJabpLite = this.getBoolean("useAlertMenuJabpLite", this.parent.useAlertMenuJabpLite);
        this.parent.showMessageIfAPHelperServiceNotRunningJabpLite = this.getBoolean("showMessageIfAPHelperServiceNotRunningJabpLite", this.parent.showMessageIfAPHelperServiceNotRunningJabpLite);
        this.parent.useFingerprintCheckJabpLite = this.getBoolean("useFingerprintCheckJabpLite", this.parent.useFingerprintCheckJabpLite);
        this.parent.hideInactiveAccountsJabpLite = this.getBoolean("hideInactiveAccountsJabpLite", this.parent.hideInactiveAccountsJabpLite);
        this.parent.showInactiveAccountsWithAsteriskJabpLite = this.getBoolean("showInactiveAccountsWithAsteriskJabpLite", this.parent.showInactiveAccountsWithAsteriskJabpLite);
        this.parent.enableShortcutsJabpLite = this.getBoolean("enableShortcutsJabpLite", this.parent.enableShortcutsJabpLite);
        this.parent.allowPendingTransactionsFromOtherDevicesJabpLite = this.getBoolean("allowPendingTransactionsFromOtherDevicesJabpLite", this.parent.allowPendingTransactionsFromOtherDevicesJabpLite);
        this.parent.useBiometricCheckJabpLite = this.getBoolean("useBiometricCheckJabpLite", this.parent.useBiometricCheckJabpLite);
        this.parent.useOnlineBanksJabpLite = this.getBoolean("useOnlineBanksJabpLite", this.parent.useOnlineBanksJabpLite);
        this.parent.reconcileGooglePayTransactionsJabpLite = this.getBoolean("reconcileGooglePayTransactionsJabpLite", this.parent.reconcileGooglePayTransactionsJabpLite);
        this.parent.reconcileOnlineBankTransactionsJabpLite = this.getBoolean("reconcileOnlineBankTransactionsJabpLite", this.parent.reconcileOnlineBankTransactionsJabpLite);
        this.parent.isUsingSingleLineJabpLite = this.getBoolean("isUsingSingleLineJabpLite", this.parent.isUsingSingleLineJabpLite);
        this.parent.uploadJabpLiteSyncToDropboxJabpLite = this.getBoolean("uploadJabpLiteSyncToDropboxJabpLite", this.parent.uploadJabpLiteSyncToDropboxJabpLite);
    }

    void savePreferences() {
        if (this.rs != null) {
            byte[] bytes = this.toByteArray();
            if (this.rs.getNumRecords() > 0) {
                this.rs.setRecord(0, bytes, 0, bytes.length);
            } else {
                this.rs.addRecord(bytes, 0, bytes.length);
            }
        }
        this.saveJabp4Properties();
    }

    void saveJabp4Properties() {
        this.putInt("width", this.parent.getSize().width);
        this.putInt("height", this.parent.getSize().height);
        this.putString("jabpFile", this.parent.jabpFile);
        this.putString("homeCurrency", this.parent.homeCurrency);
        this.putString("lastAccount", this.parent.lastAccount);
        this.putInt("holdingDecimalPlaces", this.parent.holdingDecimalPlaces);
        this.putInt("priceDecimalPlaces", this.parent.priceDecimalPlaces);
        this.putBoolean("useCanvasMenu", this.parent.useCanvasMenu);
        this.putBoolean("showMenuAccountView", this.parent.showMenuAccountView);
        this.putBoolean("showMenuTransactionView", this.parent.showMenuTransactionView);
        this.putInt("colorHeading", this.parent.colorHeading);
        this.putInt("colorCursor", this.parent.colorCursor);
        this.putInt("colorBackground", this.parent.colorBackground);
        this.putInt("colorFont", this.parent.colorFont);
        this.putInt("colorMessage", this.parent.colorMessage);
        this.putInt("colorNegative", this.parent.colorNegative);
        this.putInt("fontSize", this.parent.fontSize);
        this.putInt("lineSpacing", this.parent.lineSpacing);
        this.putInt("widthAdjustment", this.parent.widthAdjustment);
        this.putInt("fontAdjustment", this.parent.fontAdjustment);
        this.putInt("heightAdjustment", this.parent.heightAdjustment);
        this.putBoolean("numericEntry", this.parent.numericEntry);
        this.putBoolean("allowInputExpressions", this.parent.allowInputExpressions);
        this.putBoolean("isEuropeanNumberFormat", this.parent.isEuropeanNumberFormat);
        this.putBoolean("isGroupingUsed", this.parent.isGroupingUsed);
        this.putInt("dateFormat", this.parent.dateFormat);
        this.putBoolean("autoBackupOnExit", this.parent.autoBackupOnExit);
        this.putBoolean("useBackupEncryption", this.parent.useBackupEncryption);
        this.putBoolean("quickStart", this.parent.quickStart);
        this.putBoolean("hideAmountsInQuickStart", this.parent.hideAmountsInQuickStart);
        this.putInt("matchDescriptionNumber", this.parent.matchDescriptionNumber);
        this.putInt("accountColumnsPortrait", this.parent.accountColumnsPortrait);
        this.putInt("accountColumnsLandscape", this.parent.accountColumnsLandscape);
        this.putBoolean("normalSortOrder", this.parent.normalSortOrder);
        this.putBoolean("showBalanceType", this.parent.showBalanceType);
        this.putBoolean("preferCategoryInTransactionView", this.parent.preferCategoryInTransactionView);
        this.putBoolean("syncMode", this.parent.syncMode);
        this.putBoolean("copyToDropbox", this.parent.copyToDropbox);
        this.putString("dropboxDirectory", this.parent.dropboxDirectory);
        this.putBoolean("allowPendingTransactionsFromOtherDevices", this.parent.allowPendingTransactionsFromOtherDevices);
        this.putString("serializedCredential", this.parent.serializedCredential);
        this.putBoolean("hideInactiveAccounts", this.parent.hideInactiveAccounts);
        this.putBoolean("showInactiveAccountsWithAsterisk", this.parent.showInactiveAccountsWithAsterisk);
        this.putBoolean("longTapEqualsOneSecond", this.parent.longTapEqualsOneSecond);
        this.putInt("fontAdjustmentJabpLite", this.parent.fontAdjustmentJabpLite);
        this.putInt("widthAdjustmentJabpLite", this.parent.widthAdjustmentJabpLite);
        this.putInt("heightAdjustmentJabpLite", this.parent.heightAdjustmentJabpLite);
        this.putBoolean("quickStartJabpLite", this.parent.quickStartJabpLite);
        this.putBoolean("passwordWhenBackgroundJabpLite", this.parent.passwordWhenBackgroundJabpLite);
        this.putInt("accountColumnsPortraitJabpLite", this.parent.accountColumnsPortraitJabpLite);
        this.putInt("accountColumnsLandscapeJabpLite", this.parent.accountColumnsLandscapeJabpLite);
        this.putBoolean("longTapEqualsOneSecondJabpLite", this.parent.longTapEqualsOneSecondJabpLite);
        this.putInt("lineSpacingJabpLite", this.parent.lineSpacingJabpLite);
        this.putBoolean("usePhoneKeypadForNumbersJabpLite", this.parent.usePhoneKeypadForNumbersJabpLite);
        this.putBoolean("copyToDropboxJabpLite", this.parent.copyToDropboxJabpLite);
        this.putBoolean("showActionBarJabpLite", this.parent.showActionBarJabpLite);
        this.putInt("fontSizeJabpLite", this.parent.fontSizeJabpLite);
        this.putBoolean("useAlertMenuJabpLite", this.parent.useAlertMenuJabpLite);
        this.putBoolean("showMessageIfAPHelperServiceNotRunningJabpLite", this.parent.showMessageIfAPHelperServiceNotRunningJabpLite);
        this.putBoolean("useFingerprintCheckJabpLite", this.parent.useFingerprintCheckJabpLite);
        this.putBoolean("hideInactiveAccountsJabpLite", this.parent.hideInactiveAccountsJabpLite);
        this.putBoolean("showInactiveAccountsWithAsteriskJabpLite", this.parent.showInactiveAccountsWithAsteriskJabpLite);
        this.putBoolean("enableShortcutsJabpLite", this.parent.enableShortcutsJabpLite);
        this.putBoolean("allowPendingTransactionsFromOtherDevicesJabpLite", this.parent.allowPendingTransactionsFromOtherDevicesJabpLite);
        this.putBoolean("useBiometricCheckJabpLite", this.parent.useBiometricCheckJabpLite);
        this.putBoolean("useOnlineBanksJabpLite", this.parent.useOnlineBanksJabpLite);
        this.putBoolean("reconcileGooglePayTransactionsJabpLite", this.parent.reconcileGooglePayTransactionsJabpLite);
        this.putBoolean("reconcileOnlineBankTransactionsJabpLite", this.parent.reconcileOnlineBankTransactionsJabpLite);
        this.putBoolean("isUsingSingleLineJabpLite", this.parent.isUsingSingleLineJabpLite);
        this.putBoolean("uploadJabpLiteSyncToDropboxJabpLite", this.parent.uploadJabpLiteSyncToDropboxJabpLite);
        try {
            FileOutputStream fos = new FileOutputStream(this.parent.prefsFile);
            this.parent.prefs.save(fos, "Jabp4 properties file - do not edit");
            fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void copyJabp4ToJabpLite() {
        this.parent.colorHeadingJabpLite = this.parent.colorHeading;
        this.parent.colorCursorJabpLite = this.parent.colorCursor;
        this.parent.colorBackgroundJabpLite = this.parent.colorBackground;
        this.parent.dateFormatJabpLite = this.parent.dateFormat;
        this.parent.numericEntryJabpLite = this.parent.numericEntry;
        this.parent.allowInputExpressionsJabpLite = this.parent.allowInputExpressions;
        this.parent.lastAccountJabpLite = this.parent.lastAccount;
        this.parent.isEuropeanNumberFormatJabpLite = this.parent.isEuropeanNumberFormat;
        this.parent.isGroupingUsedJabpLite = this.parent.isGroupingUsed;
        this.parent.showBalanceTypeJabpLite = this.parent.showBalanceType;
        this.parent.colorFontJabpLite = this.parent.colorFont;
        this.parent.colorMessageJabpLite = this.parent.colorMessage;
        this.parent.preferCategoryInTransactionViewJabpLite = this.parent.preferCategoryInTransactionView;
        this.parent.showMenuAccountViewJabpLite = this.parent.showMenuAccountView;
        this.parent.showMenuTransactionViewJabpLite = this.parent.showMenuTransactionView;
        this.parent.matchDescriptionNumberJabpLite = this.parent.matchDescriptionNumber;
        this.parent.useCanvasMenuJabpLite = this.parent.useCanvasMenu;
        this.parent.autoBackupOnExitJabpLite = this.parent.autoBackupOnExit;
        this.parent.normalSortOrderJabpLite = this.parent.normalSortOrder;
        this.parent.useBackupEncryptionJabpLite = this.parent.useBackupEncryption;
        this.parent.hideAmountsInQuickStartJabpLite = this.parent.hideAmountsInQuickStart;
        this.parent.lastQuickStartAccountJabpLite = this.parent.lastQuickStartAccount;
        this.parent.colorNegativeJabpLite = this.parent.colorNegative;
    }

    void copyJabpLiteToJabp4() {
        this.parent.colorHeading = this.parent.colorHeadingJabpLite;
        this.parent.colorCursor = this.parent.colorCursorJabpLite;
        this.parent.colorBackground = this.parent.colorBackgroundJabpLite;
        this.parent.dateFormat = this.parent.dateFormatJabpLite;
        this.parent.numericEntry = this.parent.numericEntryJabpLite;
        this.parent.allowInputExpressions = this.parent.allowInputExpressionsJabpLite;
        this.parent.lastAccount = this.parent.lastAccountJabpLite;
        this.parent.isEuropeanNumberFormat = this.parent.isEuropeanNumberFormatJabpLite;
        this.parent.isGroupingUsed = this.parent.isGroupingUsedJabpLite;
        this.parent.showBalanceType = this.parent.showBalanceTypeJabpLite;
        this.parent.colorFont = this.parent.colorFontJabpLite;
        this.parent.colorMessage = this.parent.colorMessageJabpLite;
        this.parent.preferCategoryInTransactionView = this.parent.preferCategoryInTransactionViewJabpLite;
        this.parent.showMenuAccountView = this.parent.showMenuAccountViewJabpLite;
        this.parent.showMenuTransactionView = this.parent.showMenuTransactionViewJabpLite;
        this.parent.matchDescriptionNumber = this.parent.matchDescriptionNumberJabpLite;
        this.parent.useCanvasMenu = this.parent.useCanvasMenuJabpLite;
        this.parent.autoBackupOnExit = this.parent.autoBackupOnExitJabpLite;
        this.parent.normalSortOrder = this.parent.normalSortOrderJabpLite;
        this.parent.useBackupEncryption = this.parent.useBackupEncryptionJabpLite;
        this.parent.hideAmountsInQuickStart = this.parent.hideAmountsInQuickStartJabpLite;
        this.parent.lastQuickStartAccount = this.parent.lastQuickStartAccountJabpLite;
        this.parent.colorNegative = this.parent.colorNegativeJabpLite;
    }

    int getSize() {
        return this.rs.getSize();
    }

    void putString(String key, String string) {
        this.parent.prefs.put(key, string);
    }

    void putBoolean(String key, boolean b) {
        this.parent.prefs.put(key, String.valueOf(b));
    }

    void putInt(String key, int i) {
        this.parent.prefs.put(key, String.valueOf(i));
    }

    void putLong(String key, long lo) {
        this.parent.prefs.put(key, String.valueOf(lo));
    }

    String getString(String key, String initialValue) {
        String s = this.parent.prefs.getProperty(key);
        if (s == null) {
            return initialValue;
        }
        return s;
    }

    boolean getBoolean(String key, boolean initialValue) {
        String s = this.parent.prefs.getProperty(key);
        if (s == null) {
            return initialValue;
        }
        return Boolean.valueOf(this.parent.prefs.getProperty(key));
    }

    int getInt(String key, int initialValue) {
        String s = this.parent.prefs.getProperty(key);
        if (s == null) {
            return initialValue;
        }
        try {
            return Integer.valueOf(this.parent.prefs.getProperty(key));
        }
        catch (NumberFormatException nfe) {
            return initialValue;
        }
    }

    long getLong(String key, long initialValue) {
        String s = this.parent.prefs.getProperty(key);
        if (s == null) {
            return initialValue;
        }
        try {
            return Long.valueOf(this.parent.prefs.getProperty(key));
        }
        catch (NumberFormatException nfe) {
            return initialValue;
        }
    }
}

