/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.AccountStore;
import org.freepoc.Jabp4.AccountView;
import org.freepoc.Jabp4.Category;
import org.freepoc.Jabp4.CategoryStore;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.QuickStartForm;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.TransactionStore;
import org.freepoc.Jabp4.Utilities;

public class PendingTransactionForm
extends Component {
    Jabp parent;
    JTextField[] tfDescription;
    DialogManager dm;
    Transaction t;

    public PendingTransactionForm(Jabp context) {
        this.parent = context;
        this.parent.lastUsedScreen = 39;
        this.showPendingTransactions();
    }

    void showPendingTransactions() {
        int n = this.parent.pendingTransactions.size();
        if (n == 0) {
            if (this.parent.lastUsedView == 28) {
                if (this.parent.qsf == null) {
                    this.parent.qsf = new QuickStartForm(this.parent);
                }
                this.parent.setContentView(this.parent.qsf);
            } else {
                if (this.parent.av == null) {
                    this.parent.av = new AccountView(this.parent);
                }
                this.parent.setContentView(this.parent.av);
            }
            return;
        }
        Collections.sort(this.parent.pendingTransactions, new Comparator<Transaction>(){

            @Override
            public int compare(Transaction t1, Transaction t2) {
                return Long.compare(t1.longDate, t2.longDate);
            }
        });
        this.dm = new DialogManager(this.parent, "");
        if (n == 1) {
            this.dm.setTitle("Process 1 pending transaction");
        } else {
            this.dm.setTitle("Process " + n + " pending transactions");
        }
        ArrayList<String> categoryList = new ArrayList<String>();
        CategoryStore cs = null;
        cs = this.parent.cv == null ? new CategoryStore(this.parent, true) : this.parent.cv.cs;
        int m = cs.getNumCategories();
        if (m == 0) {
            cs.setUpCategories();
            m = cs.getNumCategories();
        }
        for (int j = 0; j < m; ++j) {
            Category c = cs.getCategoryFromIndex(j);
            categoryList.add(c.name);
        }
        if (this.parent.cv == null) {
            cs.closeCategoryStore();
        }
        URL url = this.getClass().getResource("/images/match_icon_32x32.png");
        ImageIcon icon = new ImageIcon(url);
        this.tfDescription = new JTextField[n];
        JLabel[] iconLabel = new JLabel[n];
        JTextField[] tfReference = new JTextField[n];
        JComboBox[] chCategory = new JComboBox[n];
        CheckboxGroup[] cbCreate = new CheckboxGroup[n];
        for (int i = 0; i < n; ++i) {
            this.t = (Transaction)this.parent.pendingTransactions.elementAt(i);
            int k = i;
            int i1 = i + 1;
            this.dm.addText("Pending transaction " + i1 + " of " + n);
            this.dm.addText("");
            this.dm.addText("Date: " + this.showDate(this.t.longDate));
            this.dm.addText("Account: " + this.t.account);
            iconLabel[i] = new JLabel(icon);
            iconLabel[i].addMouseListener(new CustomMouseAdapter(k));
            this.tfDescription[i] = this.dm.addJTextFieldWithIcon("Description", this.t.description, iconLabel[i]);
            this.dm.addText("Amount: " + Utilities.numberToString(Math.abs(this.t.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed));
            tfReference[i] = this.dm.addJTextField("Reference", this.t.reference);
            if (this.t.transferFlag) {
                this.dm.addText("Transfer account: " + this.t.transferAccount);
            } else {
                chCategory[i] = this.dm.addJComboBox("Category");
                for (int j = 0; j < m; ++j) {
                    this.dm.addJComboBoxItem(chCategory[i], (String)categoryList.get(j));
                    if (this.t.category.equals("")) {
                        if (!((String)categoryList.get(j)).equals("None")) continue;
                        this.dm.setSelectedJComboBox(chCategory[i], (String)categoryList.get(j));
                        continue;
                    }
                    if (!((String)categoryList.get(j)).equals(this.t.category)) continue;
                    this.dm.setSelectedJComboBox(chCategory[i], (String)categoryList.get(j));
                }
            }
            String s = "Source: ";
            switch (Math.abs(this.t.source)) {
                case 1: {
                    s = s + "From JabpLite";
                    break;
                }
                case 2: {
                    s = s + "Google Pay";
                    break;
                }
                case 3: {
                    s = s + "Google Pay, from secondary device";
                    break;
                }
                case 4: {
                    s = s + "Google Pay, from watch";
                    break;
                }
                case 5: {
                    s = s + "Online bank";
                    break;
                }
                case 6: {
                    s = s + "My Spending (watch)";
                    break;
                }
                case 7: {
                    s = s + "Alexa";
                    break;
                }
                default: {
                    s = s + "Unknown";
                }
            }
            this.dm.addText(s);
            boolean isPossibleDuplicate = false;
            if (this.t.source < 0) {
                this.dm.addText("*** This is a possible duplicate transaction ***");
                isPossibleDuplicate = true;
            }
            cbCreate[i] = this.dm.addCheckboxGroup();
            this.dm.addCheckboxItem("Create", "Yes", !isPossibleDuplicate, "No", isPossibleDuplicate, cbCreate[i]);
            this.dm.addText("");
        }
        this.dm.addButton("Done");
        this.dm.centerShow();
        if (this.dm.checkButtonText().equals("OK")) {
            this.showPendingTransactions();
            return;
        }
        int createdYes = 0;
        int createdNo = 0;
        for (int i = 0; i < n; ++i) {
            Transaction t = (Transaction)this.parent.pendingTransactions.elementAt(i);
            t.description = this.dm.getUserText(this.tfDescription[i]);
            t.reference = this.dm.getUserText(tfReference[i]);
            if (!t.transferFlag) {
                t.category = this.dm.getSelectedJComboBoxString(chCategory[i]);
            }
            if (this.dm.getSelectedCheckbox(cbCreate[i]).getLabel().equals("Yes")) {
                t.source = 0;
                this.parent.newTransaction(t);
                ++createdYes;
                continue;
            }
            ++createdNo;
        }
        this.dm.dispose();
        Toast.makeText(this.parent, "Created: " + createdYes + ", not created: " + createdNo, 2000).show();
        this.parent.pendingTransactions = null;
        if (this.parent.lastUsedView == 28) {
            if (this.parent.qsf == null) {
                this.parent.qsf = new QuickStartForm(this.parent);
            }
            this.parent.setContentView(this.parent.qsf);
        } else {
            if (this.parent.av == null) {
                this.parent.av = new AccountView(this.parent);
            }
            this.parent.setContentView(this.parent.av);
        }
    }

    String showDate(long ldate) {
        if (this.parent.adjustDaylightSavings) {
            this.parent.genericDate.setTime(ldate + 3600000L);
        } else {
            this.parent.genericDate.setTime(ldate);
        }
        this.parent.cal.setTime(this.parent.genericDate);
        String s0 = "" + this.parent.cal.get(5);
        if (s0.length() < 2) {
            s0 = "0" + s0;
        }
        int i = this.parent.cal.get(2) + 1;
        String s1 = "" + i;
        if (s1.length() < 2) {
            s1 = "0" + s1;
        }
        String s3 = ("" + this.parent.cal.get(1)).substring(2, 4);
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            return s0 + "/" + s1 + "/" + s3;
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            return s1 + "/" + s0 + "/" + s3;
        }
        return "";
    }

    class CustomMouseAdapter
    extends MouseAdapter {
        int id;

        CustomMouseAdapter(int id) {
            this.id = id;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            Transaction t1 = new Transaction();
            t1.description = PendingTransactionForm.this.dm.getUserText(PendingTransactionForm.this.tfDescription[this.id]);
            if (t1.description.equals("")) {
                Toast.makeText(PendingTransactionForm.this.parent, "Blank description", 2000).show();
                return;
            }
            AccountStore as = null;
            as = PendingTransactionForm.this.parent.av == null ? new AccountStore(PendingTransactionForm.this.parent, true) : PendingTransactionForm.this.parent.av.as;
            Account a = as.getAccountFromName(((Transaction)PendingTransactionForm.this.parent.pendingTransactions.elementAt((int)this.id)).account);
            TransactionStore ts = null;
            ts = PendingTransactionForm.this.parent.tv == null ? new TransactionStore(PendingTransactionForm.this.parent, a, true) : PendingTransactionForm.this.parent.tv.ts;
            int numItems = ts.getNumTransactions();
            if (PendingTransactionForm.this.parent.storeMatchedPosition == 0) {
                PendingTransactionForm.this.parent.matchedString = t1.description.toUpperCase();
            }
            if (t1.description.length() < PendingTransactionForm.this.parent.matchedString.length()) {
                PendingTransactionForm.this.parent.matchedString = t1.description.toUpperCase();
                PendingTransactionForm.this.parent.storeMatchedPosition = 0;
            } else if (!t1.description.toUpperCase().contains(PendingTransactionForm.this.parent.matchedString)) {
                PendingTransactionForm.this.parent.matchedString = t1.description.toUpperCase();
                PendingTransactionForm.this.parent.storeMatchedPosition = 0;
            }
            int m = Math.min(numItems, PendingTransactionForm.this.parent.storeMatchedPosition + PendingTransactionForm.this.parent.matchDescriptionNumber);
            boolean matchFlag = false;
            Transaction t2 = new Transaction();
            if (PendingTransactionForm.this.parent.storeMatchedPosition <= numItems) {
                for (int i = PendingTransactionForm.this.parent.storeMatchedPosition; i < m; ++i) {
                    int j = i;
                    if (!ts.normalSortOrder) {
                        j = numItems - 1 - i;
                    }
                    t2 = ts.getTransactionFromIndex(j);
                    if (PendingTransactionForm.this.parent.matchedString.length() > t2.description.length()) continue;
                    if (PendingTransactionForm.this.parent.matchDescriptionAnywhere) {
                        if (!t2.description.toUpperCase().contains(PendingTransactionForm.this.parent.matchedString)) continue;
                        PendingTransactionForm.this.parent.storeMatchedPosition = i + 1;
                        matchFlag = true;
                        break;
                    }
                    if (!t2.description.toUpperCase().startsWith(PendingTransactionForm.this.parent.matchedString)) continue;
                    PendingTransactionForm.this.parent.storeMatchedPosition = i + 1;
                    matchFlag = true;
                    break;
                }
            }
            if (PendingTransactionForm.this.parent.tv == null) {
                ts.closeTransactionStore();
                ts = null;
            }
            if (PendingTransactionForm.this.parent.av == null) {
                as.closeAccountStore();
                as = null;
            }
            if (!matchFlag) {
                PendingTransactionForm.this.parent.storeMatchedPosition += PendingTransactionForm.this.parent.matchDescriptionNumber;
                if (PendingTransactionForm.this.parent.storeMatchedPosition >= numItems) {
                    PendingTransactionForm.this.parent.storeMatchedPosition = 0;
                    PendingTransactionForm.this.parent.matchedString = "";
                    Toast.makeText(PendingTransactionForm.this.parent, "Not matched in this account", 2000).show();
                } else {
                    Toast.makeText(PendingTransactionForm.this.parent, "Not matched in " + PendingTransactionForm.this.parent.storeMatchedPosition + " entries", 2000).show();
                }
                return;
            }
            Toast.makeText(PendingTransactionForm.this.parent, "Matched", 1000).show();
            Transaction t3 = (Transaction)PendingTransactionForm.this.parent.pendingTransactions.elementAt(this.id);
            t3.description = t2.description;
            t3.category = t2.category;
            PendingTransactionForm.this.parent.pendingTransactions.setElementAt(t3, this.id);
            PendingTransactionForm.this.dm.setVisible(false);
        }
    }
}

