/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.AccountStore;
import org.freepoc.Jabp4.Currency;
import org.freepoc.Jabp4.CurrencyStore;
import org.freepoc.Jabp4.Investment;
import org.freepoc.Jabp4.InvestmentStore;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.Utilities;

public class NetWorthView
extends Canvas
implements ActionListener,
KeyListener,
MouseListener {
    Jabp parent;
    boolean skipLine = false;
    int width;
    int height;
    int lineHeight;
    int fontHeight;
    int currentX;
    int currentY;
    int currentPos;
    int startPos;
    int totalAmount;
    int numItemsPage;
    int numberWidth;
    int nameWidth;
    int amountPosition;
    int lastDragX;
    int lastDragY;
    int currentMenuPos;
    int menuHeightPos;
    int menuWidth;
    int menuHeight;
    int menuWidthPos;
    int startMenuPos;
    int numMenuItems;
    Font font;
    FontMetrics fm;
    Image image;
    Graphics g1;
    Point point;
    Vector canvasMenu;
    boolean showCanvasMenu = false;
    boolean showingPopupMenu = false;
    boolean calculateCanvasMenuPosition = true;
    boolean oneClickFlag;
    boolean start;
    boolean showByCurrency = false;

    public NetWorthView(Jabp context) {
        this.parent = context;
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.font = this.parent.font;
        this.setFont(this.font);
        this.fm = this.getFontMetrics(this.font);
        this.lineHeight = this.parent.fontHeight + this.parent.lineSpacing * 2;
        this.currentX = 0;
        this.currentY = this.lineHeight;
        this.currentPos = 0;
        this.startPos = 0;
        this.setupCanvasMenu();
        this.start = true;
        this.oneClickFlag = false;
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    @Override
    public void paint(Graphics g) {
        if (this.start) {
            this.start = false;
        }
        this.parent.lastUsedScreen = 9;
        this.setPositions();
        this.g1.clearRect(0, 0, this.width, this.height);
        this.g1.setFont(this.font);
        this.showHeader();
        if (this.showByCurrency) {
            this.showPage2();
        } else {
            this.showPage();
        }
        this.showFooter();
        if (this.parent.useCanvasMenu && this.showCanvasMenu) {
            this.displayCanvasMenu();
        }
        g.drawImage(this.image, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    void showPage() {
        this.g1.setColor(new Color(this.parent.colorBackground));
        this.g1.fillRect(0, this.lineHeight, this.width, this.height - this.lineHeight * 2);
        this.g1.setColor(new Color(this.parent.colorFont));
        this.currentY = this.lineHeight;
        AccountStore as = this.parent.av.as;
        int t1 = 0;
        int t2 = 0;
        int t3 = 0;
        int t4 = 0;
        int t5 = 0;
        int t6 = 0;
        int t7 = 0;
        Hashtable<String, Integer> specialAccounts = new Hashtable<String, Integer>();
        int n = as.getNumAccounts();
        for (int i = 0; i < n; ++i) {
            Account a = as.getAccountFromIndex(i);
            if (a.type.equals("Bank")) {
                t1 += a.today;
                continue;
            }
            if (a.type.equals("Credit Card")) {
                t2 += a.today;
                continue;
            }
            if (a.type.equals("Cash")) {
                t3 += a.today;
                continue;
            }
            if (a.type.equals("Asset")) {
                t4 += a.today;
                continue;
            }
            if (a.type.equals("Liability")) {
                t5 += a.today;
                continue;
            }
            int k = 0;
            if (specialAccounts.containsKey(a.type)) {
                k = (Integer)specialAccounts.get(a.type);
            }
            specialAccounts.put(a.type, new Integer(k += a.today));
            t6 += a.today;
        }
        InvestmentStore is = null;
        is = this.parent.iv == null ? new InvestmentStore(this.parent, true) : this.parent.iv.is;
        n = is.getNumInvestments();
        for (int i = 0; i < n; ++i) {
            Investment inv = is.getInvestmentFromIndex(i);
            t7 += inv.calcValue(inv);
        }
        if (this.parent.iv == null) {
            is.closeInvestmentStore();
            is = null;
        }
        this.totalAmount = t1 + t2 + t3 + t4 + t5 + t6 + t7;
        int numItemsPage = this.height / this.lineHeight;
        if (numItemsPage >= 15) {
            this.skipLine = true;
        }
        this.buildLine("Banks", t1);
        this.buildLine("Credit Cards", t2);
        this.buildLine("Cash", t3);
        this.buildLine("Assets", t4);
        this.buildLine("Liabilities", t5);
        Enumeration e = specialAccounts.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            this.buildLine(s, (Integer)specialAccounts.get(s));
        }
        this.buildLine("Investments", t7);
    }

    void showPage2() {
        this.g1.setColor(new Color(this.parent.colorBackground));
        this.g1.fillRect(0, this.lineHeight, this.width, this.height - this.lineHeight * 2);
        this.g1.setColor(new Color(this.parent.colorFont));
        this.currentY = this.lineHeight;
        int numItemsPage = this.height / this.lineHeight;
        if (numItemsPage >= 15) {
            this.skipLine = true;
        }
        this.totalAmount = 0;
        AccountStore as = this.parent.av.as;
        int n1 = as.getNumAccounts();
        InvestmentStore is = null;
        is = this.parent.iv == null ? new InvestmentStore(this.parent, true) : this.parent.iv.is;
        int n2 = is.getNumInvestments();
        CurrencyStore ccys = null;
        ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
        int n3 = ccys.getNumCurrencies();
        for (int k = 0; k < n3; ++k) {
            int i;
            Currency ccy = ccys.getCurrencyFromIndex(k);
            int ccyTotal = 0;
            for (i = 0; i < n1; ++i) {
                Account a = as.getAccountFromIndex(i);
                if (!a.currency.equals(ccy.code)) continue;
                ccyTotal += a.today;
            }
            for (i = 0; i < n2; ++i) {
                Investment inv = is.getInvestmentFromIndex(i);
                if (!inv.currency.equals(ccy.code)) continue;
                ccyTotal += inv.calcValue(inv);
            }
            String s = ccy.code;
            if (!ccy.code.equals(this.parent.homeCurrency)) {
                s = s + "  (" + Utilities.numberToString(Utilities.homeToForeign(ccyTotal, ccy.rate), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + ")";
            }
            if (ccyTotal > 0) {
                this.buildLine(s, ccyTotal);
            }
            this.totalAmount += ccyTotal;
        }
        if (this.parent.iv == null) {
            is.closeInvestmentStore();
            is = null;
        }
        if (this.parent.ccyv == null) {
            ccys.closeCurrencyStore();
            ccys = null;
        }
    }

    void showHeader() {
        int vpos = this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorHeading));
        this.g1.fillRect(0, 0, this.width, this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        this.g1.drawString("Net Worth", this.parent.widthAdjustment, vpos);
        this.g1.drawString("Amount", this.amountPosition + this.numberWidth - this.fm.stringWidth("Amount"), vpos);
    }

    void showFooter() {
        int vpos = this.height - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorHeading));
        this.g1.fillRect(0, this.height - this.lineHeight, this.width, this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        this.g1.drawString("Net Worth", this.parent.widthAdjustment, vpos);
        if (this.totalAmount < 0) {
            this.g1.setColor(new Color(this.parent.colorNegative));
        }
        String s = Utilities.numberToString(this.totalAmount, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        this.g1.drawString(s, this.amountPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
    }

    void buildLine(String s, int i) {
        if (this.skipLine) {
            this.currentY += this.lineHeight;
        }
        int vpos = this.currentY + this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorFont));
        this.g1.drawString(s, this.parent.widthAdjustment, vpos);
        if (i < 0) {
            this.g1.setColor(new Color(this.parent.colorNegative));
        }
        String s1 = Utilities.numberToString(i, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        this.g1.drawString(s1, this.amountPosition + this.numberWidth - this.fm.stringWidth(s1), vpos);
        this.currentY += this.lineHeight;
    }

    void setPositions() {
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.image = this.createImage(this.width, this.height);
        this.g1 = this.image.getGraphics();
        Utilities.enableAntialiasing(this.g1);
        this.fontHeight = this.parent.fontHeight;
        if (this.parent.lineSpacing == 0) {
            this.parent.lineSpacing = this.fontHeight / 5;
        }
        this.lineHeight = this.fontHeight + this.parent.lineSpacing * 2;
        this.numItemsPage = this.height / this.lineHeight - 2;
        this.numberWidth = this.parent.isGroupingUsed ? this.fm.stringWidth("999,999.99") : this.fm.stringWidth("999999.99");
        this.nameWidth = this.width - this.numberWidth - this.parent.widthAdjustment * 2 - 10;
        this.amountPosition = this.nameWidth + this.parent.widthAdjustment + 10;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int j;
        String s = ae.getSource().toString();
        String s1 = s.substring((j = s.indexOf("[")) + 1, j + 5);
        if (s1.equals("menu")) {
            MenuItem mi = (MenuItem)ae.getSource();
            this.commandAction(mi.getLabel());
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.point = me.getPoint();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.point = me.getPoint();
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.point = me.getPoint();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        this.lastDragX = x;
        this.calculateCanvasMenuPosition = true;
        if (this.showCanvasMenu) {
            this.calculateCanvasMenuPosition = false;
            this.currentMenuPos = (y - this.menuHeightPos) / this.lineHeight;
            this.repaint();
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        if (Math.abs(this.lastDragX - x) > 100) {
            this.commandAction("Home");
            return;
        }
        if (this.showCanvasMenu) {
            this.showCanvasMenu = false;
            this.repaint();
            if (x < this.menuWidthPos || x > this.menuWidthPos + this.menuWidth || y < this.menuHeightPos || y > this.menuHeightPos + this.menuHeight) {
                this.setupCanvasMenu();
                return;
            }
            int k = (y - this.menuHeightPos) / this.lineHeight + this.startMenuPos;
            this.processMenuCommand(k);
            return;
        }
        if (this.parent.useCanvasMenu) {
            this.showCanvasMenu = true;
            this.repaint();
        } else {
            this.displayPopupMenu();
        }
    }

    void displayPopupMenu() {
        if (this.showingPopupMenu) {
            this.showingPopupMenu = false;
            return;
        }
        PopupMenu pm = new PopupMenu();
        MenuItem miHome = new MenuItem("Home");
        miHome.addActionListener(this);
        pm.add(miHome);
        MenuItem miToggle = new MenuItem("Toggle Display");
        miToggle.addActionListener(this);
        pm.add(miToggle);
        MenuItem miExit = new MenuItem("Exit");
        miExit.addActionListener(this);
        pm.add(miExit);
        this.add(pm);
        int x = 0;
        int y = 0;
        if (this.point == null) {
            pm.show(this, x, y);
        } else {
            pm.show(this, x + this.point.x, y + this.point.y);
        }
        this.showingPopupMenu = true;
    }

    void setupCanvasMenu() {
        this.startMenuPos = 0;
        this.currentMenuPos = 0;
        this.canvasMenu = new Vector(3);
        this.canvasMenu.addElement("Home");
        this.canvasMenu.addElement("Toggle Display");
        this.canvasMenu.addElement("Exit");
        this.menuWidth = this.fm.stringWidth("Toggle Display") + 6;
    }

    void displayCanvasMenu() {
        this.numMenuItems = this.canvasMenu.size();
        this.menuWidthPos = (this.width - this.menuWidth) / 2;
        if (this.menuWidthPos < 0) {
            this.menuWidthPos = 0;
        }
        this.menuHeightPos = (this.height - this.lineHeight * 2 - this.numMenuItems * this.lineHeight) / 2;
        if (this.menuHeightPos < this.lineHeight) {
            this.menuHeightPos = this.lineHeight;
        }
        this.menuHeight = Math.min(this.height - this.lineHeight * 2, this.numMenuItems * this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorMessage));
        this.g1.fillRect(this.menuWidthPos, this.menuHeightPos, this.menuWidth, this.menuHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        for (int i = 0; i < this.numItemsPage && i + this.startMenuPos <= this.numMenuItems - 1; ++i) {
            int vpos = i * this.lineHeight + this.lineHeight + this.menuHeightPos - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
            if (i == this.currentMenuPos) {
                this.g1.setColor(new Color(this.parent.colorCursor));
                this.g1.fillRect(this.menuWidthPos, this.lineHeight * i + this.menuHeightPos, this.menuWidth, this.lineHeight);
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            this.g1.drawString((String)this.canvasMenu.elementAt(i + this.startMenuPos), this.menuWidthPos + 3, vpos);
        }
    }

    void processMenuCommand(int k) {
        this.repaint();
        this.commandAction((String)this.canvasMenu.elementAt(k));
    }

    void commandAction(String cmd) {
        this.showingPopupMenu = false;
        if (cmd.equals("Home")) {
            this.parent.setContentView(this.parent.av);
            return;
        }
        if (cmd.equals("Toggle Display")) {
            this.showByCurrency = !this.showByCurrency;
            this.repaint();
            return;
        }
        if (cmd.equals("Exit")) {
            this.parent.finishAndQuit();
            return;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if ((e.getKeyCode() == 10 || e.getKeyCode() == 525) && e.getKeyCode() == 525) {
            this.displayPopupMenu();
        }
        if (e.getKeyCode() == 27) {
            this.parent.onBackPressed();
            return;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

