/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import com.crazzyghost.alphavantage.AlphaVantage;
import com.crazzyghost.alphavantage.AlphaVantageException;
import com.crazzyghost.alphavantage.Config;
import com.crazzyghost.alphavantage.Fetcher;
import com.crazzyghost.alphavantage.timeseries.TimeSeries;
import com.crazzyghost.alphavantage.timeseries.response.QuoteResponse;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Vector;
import org.freepoc.Jabp4.AccountView;
import org.freepoc.Jabp4.CategoryView;
import org.freepoc.Jabp4.CurrencyView;
import org.freepoc.Jabp4.GenericShowForm;
import org.freepoc.Jabp4.Investment;
import org.freepoc.Jabp4.InvestmentForm;
import org.freepoc.Jabp4.InvestmentSettingsForm;
import org.freepoc.Jabp4.InvestmentStore;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.StandingOrderView;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Utilities;

public class InvestmentView
extends Canvas
implements ActionListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
Runnable {
    Jabp parent;
    Investment inv;
    Investment inv1;
    Investment oldInv;
    Config cfg;
    Vector canvasMenu;
    InvestmentStore is;
    Font font;
    FontMetrics fm;
    Point point;
    Image image;
    Graphics g1;
    String ticker = "";
    double price = 0.0;
    boolean paintWholeScreen = true;
    boolean priceFlag = false;
    boolean dragScreen = false;
    boolean showCanvasMenu = false;
    boolean showingPopupMenu = false;
    boolean showSwitchViewsMenu = false;
    boolean calculateCanvasMenuPosition = true;
    int numMenuItems;
    int startMenuPos;
    int currentMenuPos;
    int menuWidth;
    int menuHeight;
    int menuWidthPos;
    int menuHeightPos;
    int fs;
    int width;
    int height;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int lastDragX;
    int lastDragY;
    int numItems;
    int numItemsPage;
    int lineHeight;
    int fontHeight;
    int fontWidth;
    int currentPos;
    int previousPos;
    int oldId;
    int startPos;
    int totalValue;
    int minInvestmentAmount;
    int maxInvestmentAmount;
    int spacing;
    int numberWidth;
    int holdingWidth;
    int priceWidth;
    int investmentWidth;
    int holdingsPosition;
    int pricePosition;
    int valuePosition;
    int minInvestmentWidth;
    int investmentDisplayType;
    int runMode;
    boolean reducedHeading;
    long timePointerOnScreen;
    boolean pointerExecute;
    boolean start;
    boolean oneClickFlag;
    boolean alwaysDisplayMenu = false;

    InvestmentView(Jabp context) {
        this.parent = context;
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.is = new InvestmentStore(this.parent, false);
        this.parent.dataIntegrityCheck("Investments", this.is.getNumInvestments(), this.parent.investmentHt.size());
        this.numItems = this.is.getNumInvestments();
        this.font = this.parent.font;
        this.setFont(this.font);
        this.fm = this.getFontMetrics(this.font);
        this.lineHeight = this.parent.fontHeight + this.parent.lineSpacing * 2;
        this.currentX = 0;
        this.currentY = this.lineHeight;
        this.currentPos = 0;
        this.startPos = 0;
        this.setupCanvasMenu();
        this.runMode = 0;
        this.start = true;
        this.oneClickFlag = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
    }

    @Override
    public void paint(Graphics g) {
        if (this.start) {
            this.start = false;
            this.setTotals();
        }
        this.parent.lastUsedScreen = 3;
        this.parent.lastUsedView = 3;
        this.setPositions();
        this.g1.clearRect(0, 0, this.width, this.height);
        this.g1.setFont(this.font);
        this.showHeader();
        this.showPage();
        this.showFooter();
        if (this.parent.useCanvasMenu && this.showCanvasMenu) {
            this.displayCanvasMenu();
        }
        g.drawImage(this.image, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    void showPage() {
        this.g1.setColor(new Color(this.parent.colorBackground));
        this.g1.fillRect(0, this.lineHeight, this.width, this.height - this.lineHeight * 2);
        this.g1.setColor(new Color(this.parent.colorFont));
        if (this.numItems == 0) {
            this.g1.drawString("Click here to add investment", this.parent.widthAdjustment, this.lineHeight * 2);
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                this.g1.setColor(new Color(this.parent.colorCursor));
                this.g1.fillRect(0, this.lineHeight * i + this.lineHeight, this.width, this.lineHeight);
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            this.inv = this.is.getInvestmentFromIndex(i + this.startPos);
            this.buildLine(this.inv, this.lineHeight * i + this.lineHeight);
        }
        this.inv = this.is.getInvestmentFromIndex(this.startPos + this.currentPos);
    }

    void showHeader() {
        int vpos = this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorHeading));
        this.g1.fillRect(0, 0, this.width, this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        String s1 = "Investments";
        String s2 = "Holding";
        if (this.reducedHeading) {
            s1 = "Invest";
            s2 = "Hold";
        }
        this.g1.drawString(s1, this.parent.widthAdjustment, vpos);
        this.g1.drawString(s2, this.holdingsPosition + this.holdingWidth - this.fm.stringWidth("Holding"), vpos);
        if (this.investmentDisplayType == 0) {
            this.g1.drawString("Price", this.pricePosition + this.priceWidth - this.fm.stringWidth("Price"), vpos);
            this.g1.drawString("Value", this.valuePosition + this.numberWidth - this.fm.stringWidth("Value"), vpos);
        } else {
            this.g1.drawString("Value", this.valuePosition + this.numberWidth - this.fm.stringWidth("Value"), vpos);
        }
    }

    void showFooter() {
        int vpos = this.height - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorHeading));
        this.g1.fillRect(0, this.height - this.lineHeight, this.width, this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        this.g1.drawString("Totals", this.parent.widthAdjustment, vpos);
        String s = Utilities.numberToString(this.totalValue, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        this.g1.drawString(s, this.valuePosition + this.numberWidth - this.fm.stringWidth(s), vpos);
    }

    void drawUp() {
        if (this.showCanvasMenu) {
            if (this.currentMenuPos > 0) {
                --this.currentMenuPos;
            } else {
                --this.startMenuPos;
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (this.startPos + this.currentPos > 0) {
            this.oldY = this.currentY;
            this.currentY -= this.lineHeight;
            --this.currentPos;
            if (this.currentY < this.lineHeight) {
                this.currentY = this.lineHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
                this.repaint();
            } else {
                this.repaint(0, this.lineHeight * this.currentPos + this.lineHeight, this.width, this.lineHeight * 2);
            }
            return;
        }
    }

    void drawDown() {
        if (this.showCanvasMenu) {
            if (this.currentMenuPos < Math.min(this.numItemsPage, this.numMenuItems) - 1) {
                ++this.currentMenuPos;
            } else {
                ++this.startMenuPos;
                if (this.startMenuPos + this.currentPos > Math.min(this.numItemsPage, this.numMenuItems) - 1) {
                    this.startMenuPos = Math.min(this.numItemsPage, this.numMenuItems) - 1 - this.currentPos;
                }
            }
            this.repaint();
            return;
        }
        if (this.startPos + this.currentPos < this.numItems - 1) {
            this.oldY = this.currentY;
            this.currentY += this.lineHeight;
            ++this.currentPos;
            if (this.currentY + this.lineHeight * 2 > this.height) {
                this.currentY -= this.lineHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
                this.repaint();
            } else {
                this.repaint(0, this.lineHeight * (this.currentPos - 1) + this.lineHeight, this.width, this.lineHeight * 2);
            }
            return;
        }
    }

    void buildLine(Investment investment, int y) {
        int vpos = y + this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        int j = investment.name.length();
        for (int i = 0; i < j; ++i) {
            int k = j - i;
            if (this.fm.stringWidth(investment.name.substring(0, k)) > this.investmentWidth) continue;
            this.g1.drawString(investment.name.substring(0, k), this.parent.widthAdjustment, vpos);
            break;
        }
        String s = Utilities.holdingToString(investment.holding, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, this.parent.holdingDecimalPlaces);
        this.g1.drawString(s, this.holdingsPosition + this.holdingWidth - this.fm.stringWidth(s), vpos);
        if (this.investmentDisplayType == 0) {
            s = Utilities.numberToString(investment.price, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, this.parent.priceDecimalPlaces);
            this.g1.drawString(s, this.pricePosition + this.priceWidth - this.fm.stringWidth(s), vpos);
        }
        int value = investment.calcValue(investment);
        s = Utilities.numberToString(value, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        this.g1.drawString(s, this.valuePosition + this.numberWidth - this.fm.stringWidth(s), vpos);
    }

    void setPositions() {
        this.fontHeight = this.parent.fontHeight;
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.image = this.createImage(this.width, this.height);
        this.g1 = this.image.getGraphics();
        Utilities.enableAntialiasing(this.g1);
        this.numberWidth = this.minInvestmentAmount < -9999999 || this.maxInvestmentAmount > 99999999 ? (this.parent.isGroupingUsed ? this.fm.stringWidth("9,999,999.99") : this.fm.stringWidth("9999999.99")) : (this.minInvestmentAmount < -999999 || this.maxInvestmentAmount > 9999999 ? (this.parent.isGroupingUsed ? this.fm.stringWidth("999,999.99") : this.fm.stringWidth("999999.99")) : (this.minInvestmentAmount < -99999 || this.maxInvestmentAmount > 999999 ? (this.parent.isGroupingUsed ? this.fm.stringWidth("99,999.99") : this.fm.stringWidth("99999.99")) : (this.parent.isGroupingUsed ? this.fm.stringWidth("9,999.99") : this.fm.stringWidth("9999.99"))));
        this.holdingWidth = this.numberWidth - this.fm.stringWidth(".99");
        this.priceWidth = this.fm.stringWidth("999.99");
        this.investmentDisplayType = 0;
        this.minInvestmentWidth = this.fm.stringWidth("Description");
        if (this.parent.lineSpacing == 0) {
            this.parent.lineSpacing = this.fontHeight / 5;
        }
        this.lineHeight = this.fontHeight + this.parent.lineSpacing * 2;
        this.numItemsPage = this.height / this.lineHeight - 2;
        this.spacing = this.fm.stringWidth("  ");
        this.investmentWidth = this.width - this.parent.widthAdjustment * 2 - this.holdingWidth - this.priceWidth - this.numberWidth - this.spacing * 3;
        if (this.investmentWidth < this.minInvestmentWidth) {
            this.investmentDisplayType = 1;
            this.investmentWidth += this.priceWidth + this.spacing;
        }
        this.holdingsPosition = this.investmentWidth + this.parent.widthAdjustment + this.spacing;
        if (this.investmentDisplayType == 0) {
            this.pricePosition = this.holdingsPosition + this.holdingWidth + this.spacing;
            this.valuePosition = this.pricePosition + this.priceWidth + this.spacing;
        } else {
            this.valuePosition = this.holdingsPosition + this.holdingWidth + this.spacing;
        }
        if (this.fm.stringWidth("Investments") + this.parent.widthAdjustment + this.spacing > this.holdingsPosition + this.holdingWidth - this.fm.stringWidth("Holding")) {
            this.reducedHeading = true;
        }
    }

    void newInvestment(Investment investment) {
        this.inv1 = investment;
        this.inv1.id = this.is.saveNewInvestment(this.inv1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.is.toByteArray(this.inv1), 4);
        }
        if (this.inv == null) {
            this.inv = this.inv1;
        }
        ++this.numItems;
        this.totalValue += this.inv1.calcValue(this.inv1);
        this.checkMinMax(this.inv1);
        this.repaint();
    }

    void editInvestment(Investment investment) {
        this.inv1 = investment;
        this.is.deleteInvestment(this.oldInv);
        this.is.deleteIndex(this.startPos + this.currentPos);
        this.inv1.id = this.is.saveNewInvestment(this.inv1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.is.toByteArray(this.oldInv), -4);
            this.parent.sync.saveSyncRecord(this.is.toByteArray(this.inv1), 4);
        }
        this.totalValue += this.inv1.calcValue(this.inv1) - this.oldInv.calcValue(this.oldInv);
        this.checkMinMax(this.inv1);
        this.repaint();
    }

    void priceInvestment(Investment investment) {
        this.inv1 = investment;
        this.is.saveExistingInvestment(this.inv1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.is.toByteArray(this.inv1), 11);
        }
        this.totalValue += this.inv1.calcValue(this.inv1) - this.oldInv.calcValue(this.oldInv);
        this.checkMinMax(this.inv1);
        this.repaint();
    }

    void updateInternetPrice(Investment investment) {
        this.inv1 = investment;
        int k1 = this.inv1.description.indexOf("<");
        int k2 = this.inv1.description.indexOf(">");
        if (k1 < 0 || k2 < 0) {
            Toast.makeText(this.parent, "Ticker delimiters (<>) not found", 2000).show();
            return;
        }
        if (k1 > k2) {
            Toast.makeText(this.parent, "Check ticker delimiters (<>)", 2000).show();
            return;
        }
        this.ticker = this.inv1.description.substring(k1 + 1, k2);
        Thread thread2 = new Thread(this);
        thread2.start();
    }

    @Override
    public void run() {
        if (this.cfg == null) {
            this.cfg = Config.builder().key(this.parent.alphaVantageKey).timeOut(10).build();
            AlphaVantage.api().init(this.cfg);
        }
        this.price = 0.0;
        ((TimeSeries.GlobalQuoteRequestProxy)((TimeSeries.GlobalQuoteRequestProxy)((TimeSeries.GlobalQuoteRequestProxy)AlphaVantage.api().timeSeries().quote().forSymbol(this.ticker)).onSuccess(new Fetcher.SuccessCallback<QuoteResponse>(){

            @Override
            public void onSuccess(QuoteResponse response) {
                InvestmentView.this.price = response.getPrice();
                InvestmentView.this.oldInv = new Investment(InvestmentView.this.parent);
                InvestmentView.this.oldInv.clone(InvestmentView.this.inv1);
                if (InvestmentView.this.inv1.currency.equalsIgnoreCase("gbp")) {
                    InvestmentView.this.price /= 100.0;
                }
                int i = InvestmentView.this.inv1.price;
                InvestmentView.this.inv1.price = Utilities.stringToDecimal("" + InvestmentView.this.price, i, false, false, InvestmentView.this.parent.priceDecimalPlaces);
                InvestmentView.this.inv1.priceLongDate = System.currentTimeMillis();
                InvestmentView.this.is.saveExistingInvestment(InvestmentView.this.inv1);
                if (InvestmentView.this.parent.syncMode) {
                    InvestmentView.this.parent.sync.saveSyncRecord(InvestmentView.this.is.toByteArray(InvestmentView.this.inv1), 11);
                }
                InvestmentView.this.totalValue += InvestmentView.this.inv1.calcValue(InvestmentView.this.inv1) - InvestmentView.this.oldInv.calcValue(InvestmentView.this.oldInv);
                InvestmentView.this.checkMinMax(InvestmentView.this.inv1);
                Toast.makeText(InvestmentView.this.parent, "Updated price for " + InvestmentView.this.ticker + " from the internet", 2000).show();
                InvestmentView.this.repaint();
            }
        })).onFailure(new Fetcher.FailureCallback(){

            @Override
            public void onFailure(AlphaVantageException ex) {
                Toast.makeText(InvestmentView.this.parent, "Error getting price: " + ex.toString(), 2000).show();
            }
        })).fetch();
    }

    void deleteInvestment(Investment investment) {
        this.inv1 = investment;
        this.is.deleteInvestment(this.inv1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.is.toByteArray(this.inv1), -4);
        }
        this.is.deleteIndex(this.startPos + this.currentPos);
        this.totalValue -= this.inv1.calcValue(this.inv1);
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.lineHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
        this.repaint();
    }

    void checkMinMax(Investment investment) {
        this.minInvestmentAmount = Math.min(this.minInvestmentAmount, investment.calcValue(investment));
        this.maxInvestmentAmount = Math.max(this.maxInvestmentAmount, investment.calcValue(investment));
        this.minInvestmentAmount = Math.min(this.minInvestmentAmount, this.totalValue);
        this.maxInvestmentAmount = Math.max(this.maxInvestmentAmount, this.totalValue);
    }

    void setTotals() {
        this.totalValue = 0;
        this.minInvestmentAmount = 0;
        this.maxInvestmentAmount = 0;
        if (this.numItems <= 0) {
            return;
        }
        for (int i = 0; i < this.numItems; ++i) {
            this.inv = this.is.getInvestmentFromIndex(i);
            int v = this.inv.calcValue(this.inv);
            this.totalValue += v;
            this.minInvestmentAmount = Math.min(this.minInvestmentAmount, v);
            this.maxInvestmentAmount = Math.max(this.maxInvestmentAmount, v);
        }
        this.minInvestmentAmount = Math.min(this.minInvestmentAmount, this.totalValue);
        this.maxInvestmentAmount = Math.max(this.maxInvestmentAmount, this.totalValue);
        this.inv = this.is.getInvestmentFromIndex(0);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int j;
        String s = ae.getSource().toString();
        String s1 = s.substring((j = s.indexOf("[")) + 1, j + 5);
        if (s1.equals("menu")) {
            MenuItem mi = (MenuItem)ae.getSource();
            this.commandAction(mi.getLabel());
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        this.lastDragX = x;
        this.lastDragY = y;
        this.pointerExecute = false;
        this.alwaysDisplayMenu = false;
        this.timePointerOnScreen = System.currentTimeMillis();
        this.calculateCanvasMenuPosition = true;
        if (this.showCanvasMenu) {
            this.calculateCanvasMenuPosition = false;
            this.currentMenuPos = (y - this.menuHeightPos) / this.lineHeight;
            this.repaint();
            return;
        }
        if (y < this.lineHeight) {
            if (this.numItems == 0) {
                return;
            }
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.lineHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (y > this.height - this.lineHeight) {
            if (this.numItems == 0) {
                return;
            }
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
            this.repaint();
            return;
        }
        this.pointerExecute = true;
        int newPos = (y - this.lineHeight) / this.lineHeight;
        if (newPos >= this.numItems) {
            this.alwaysDisplayMenu = true;
            return;
        }
        this.currentPos = newPos;
        this.currentY = (this.currentPos + 1) * this.lineHeight;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        if (Math.abs(this.lastDragX - x) > 250) {
            this.commandAction("Switch Views");
            return;
        }
        if (this.dragScreen) {
            this.dragScreen = false;
            return;
        }
        if (this.showCanvasMenu) {
            this.showCanvasMenu = false;
            this.repaint();
            if (x < this.menuWidthPos || x > this.menuWidthPos + this.menuWidth || y < this.menuHeightPos || y > this.menuHeightPos + this.menuHeight) {
                this.setupCanvasMenu();
                this.showSwitchViewsMenu = false;
                return;
            }
            int k = (y - this.menuHeightPos) / this.lineHeight + this.startMenuPos;
            if (this.showSwitchViewsMenu) {
                this.showSwitchViewsMenu = false;
                this.processSwitchViewsMenu(k);
            } else {
                this.processMenuCommand(k);
            }
            return;
        }
        this.timePointerOnScreen = System.currentTimeMillis() - this.timePointerOnScreen;
        if (this.timePointerOnScreen > (long)this.parent.longTapDelay) {
            if (y < this.lineHeight) {
                this.startPos = 0;
                this.currentPos = 0;
                this.currentY = this.lineHeight;
                this.repaint();
                return;
            }
            if (y > this.height - this.lineHeight) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                this.repaint();
                return;
            }
        }
        if (this.alwaysDisplayMenu || this.timePointerOnScreen > (long)this.parent.longTapDelay) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.repaint();
            } else {
                this.displayPopupMenu();
            }
            return;
        }
        if (!this.pointerExecute) {
            return;
        }
        int newPos = (y - this.lineHeight) / this.lineHeight;
        if (newPos == this.currentPos || newPos >= this.numItems) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.repaint();
            } else {
                this.displayPopupMenu();
            }
            return;
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        int scroll = (y - this.lastDragY) / this.lineHeight;
        if (scroll == 0) {
            return;
        }
        if (scroll > 0) {
            if (this.showCanvasMenu) {
                this.startMenuPos -= scroll;
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
                this.currentMenuPos += scroll;
                if (this.currentMenuPos > Math.min(this.numMenuItems, this.numItemsPage) - 1) {
                    this.currentMenuPos = Math.min(this.numMenuItems, this.numItemsPage) - 1;
                }
            } else {
                this.startPos -= scroll;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                this.currentPos += scroll;
                if (this.currentPos > Math.min(this.numItems, this.numItemsPage) - 1) {
                    this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                }
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
        }
        if (scroll < 0) {
            if (this.showCanvasMenu) {
                this.startMenuPos -= scroll;
                if (this.startMenuPos + this.numItemsPage > this.numMenuItems - 1) {
                    this.startMenuPos = this.numMenuItems - this.numItemsPage;
                }
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
                this.currentMenuPos += scroll;
                if (this.currentMenuPos < 0) {
                    this.currentMenuPos = 0;
                }
            } else {
                this.startPos -= scroll;
                if (this.startPos + this.currentPos > this.numItems - 1) {
                    this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                    this.startPos = this.numItems - 1 - this.currentPos;
                    this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                }
                this.currentPos += scroll;
                if (this.currentPos < 0) {
                    this.currentPos = 0;
                }
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
        }
        this.lastDragY = y;
        this.repaint();
        this.dragScreen = true;
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        int notches = mwe.getWheelRotation();
        if (notches == 0) {
            return;
        }
        if (notches > 0) {
            for (int i = 0; i < notches; ++i) {
                this.drawDown();
            }
        } else {
            notches = -notches;
            for (int i = 0; i < notches; ++i) {
                this.drawUp();
            }
        }
    }

    void displayPopupMenu() {
        if (this.showingPopupMenu) {
            this.showingPopupMenu = false;
            return;
        }
        PopupMenu pm = new PopupMenu();
        MenuItem miHome = new MenuItem("Home");
        MenuItem miManualPrice = new MenuItem("Manual Price");
        MenuItem miInternetPrice = new MenuItem("Internet Price");
        MenuItem miNew = new MenuItem("New");
        MenuItem miEdit = new MenuItem("Edit");
        MenuItem miDelete = new MenuItem("Delete");
        MenuItem miShow = new MenuItem("Show");
        MenuItem miSwitchViews = new MenuItem("Switch Views");
        MenuItem miInvestmentSettings = new MenuItem("Investment Settings");
        MenuItem miGetApiKey = new MenuItem("Get API Key");
        miHome.addActionListener(this);
        miManualPrice.addActionListener(this);
        miInternetPrice.addActionListener(this);
        miNew.addActionListener(this);
        miEdit.addActionListener(this);
        miDelete.addActionListener(this);
        miShow.addActionListener(this);
        miSwitchViews.addActionListener(this);
        miInvestmentSettings.addActionListener(this);
        miGetApiKey.addActionListener(this);
        pm.add(miHome);
        pm.add(miManualPrice);
        pm.add(miInternetPrice);
        pm.add(miNew);
        pm.add(miEdit);
        pm.add(miDelete);
        pm.add(miShow);
        pm.add(miSwitchViews);
        pm.add(miInvestmentSettings);
        pm.add(miGetApiKey);
        this.add(pm);
        int x = 0;
        int y = 0;
        if (this.point == null) {
            pm.show(this, x, y);
        } else {
            Point move = this.movePopup(10, x, y);
            pm.show(this, move.x + this.point.x, move.y + this.point.y);
        }
        this.showingPopupMenu = true;
    }

    void displaySwitchViewsMenu() {
        if (this.showingPopupMenu) {
            this.showingPopupMenu = false;
            return;
        }
        PopupMenu pm = new PopupMenu();
        MenuItem miAccounts = new MenuItem("Accounts");
        MenuItem miTransactions = new MenuItem("Transactions");
        MenuItem miCategories = new MenuItem("Categories");
        MenuItem miStandingOrders = new MenuItem("Standing Orders");
        MenuItem miInvestments = new MenuItem("Investments");
        MenuItem miCurrencies = new MenuItem("Currencies");
        miAccounts.addActionListener(this);
        miTransactions.addActionListener(this);
        miCategories.addActionListener(this);
        miStandingOrders.addActionListener(this);
        miInvestments.addActionListener(this);
        miCurrencies.addActionListener(this);
        pm.add(miAccounts);
        pm.add(miTransactions);
        pm.add(miCategories);
        pm.add(miStandingOrders);
        pm.add(miInvestments);
        pm.add(miCurrencies);
        this.add(pm);
        int x = 0;
        int y = 0;
        if (this.point == null) {
            pm.show(this, x, y);
        } else {
            Point move = this.movePopup(7, x, y);
            pm.show(this, move.x + this.point.x, move.y + this.point.y);
        }
        this.showingPopupMenu = true;
    }

    Point movePopup(int n, int x, int y) {
        int popupHeight = n * this.lineHeight * 4 / 3;
        if (this.parent.useCanvasMenu && x + this.point.x + this.menuWidth > this.width) {
            x = this.width - this.menuWidth - this.point.x;
        }
        if (y + this.point.y + popupHeight > this.height) {
            y = this.height - popupHeight - this.point.y;
        }
        Point move = new Point(x, y);
        return move;
    }

    void setupCanvasMenu() {
        this.startMenuPos = 0;
        this.currentMenuPos = 0;
        this.canvasMenu = new Vector(7);
        this.canvasMenu.addElement("Home");
        this.canvasMenu.addElement("Manual Price");
        this.canvasMenu.addElement("Internet Price");
        this.canvasMenu.addElement("New");
        this.canvasMenu.addElement("Edit");
        this.canvasMenu.addElement("Delete");
        this.canvasMenu.addElement("Show");
        this.canvasMenu.addElement("Switch Views");
        this.canvasMenu.addElement("Investment Settings");
        this.canvasMenu.addElement("Get API Key");
        this.canvasMenu.addElement("Exit");
        this.menuWidth = this.fm.stringWidth("Investment Settings") + 6;
    }

    void setupSwitchViewsMenu() {
        this.startMenuPos = 0;
        this.currentMenuPos = 0;
        this.canvasMenu = new Vector(6);
        this.canvasMenu.addElement("Accounts");
        this.canvasMenu.addElement("Transactions");
        this.canvasMenu.addElement("Categories");
        this.canvasMenu.addElement("Standing Orders");
        this.canvasMenu.addElement("Investments");
        this.canvasMenu.addElement("Currencies");
        this.menuWidth = this.fm.stringWidth("Standing Orders") + 6;
    }

    void displayCanvasMenu() {
        this.numMenuItems = this.canvasMenu.size();
        this.menuWidthPos = (this.width - this.menuWidth) / 2;
        if (this.menuWidthPos < 0) {
            this.menuWidthPos = 0;
        }
        this.menuHeightPos = (this.height - this.lineHeight * 2 - this.numMenuItems * this.lineHeight) / 2;
        if (this.menuHeightPos < this.lineHeight) {
            this.menuHeightPos = this.lineHeight;
        }
        this.menuHeight = Math.min(this.height - this.lineHeight * 2, this.numMenuItems * this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorMessage));
        this.g1.fillRect(this.menuWidthPos, this.menuHeightPos, this.menuWidth, this.menuHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        for (int i = 0; i < this.numItemsPage && i + this.startMenuPos <= this.numMenuItems - 1; ++i) {
            int vpos = i * this.lineHeight + this.lineHeight + this.menuHeightPos - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
            if (i == this.currentMenuPos) {
                this.g1.setColor(new Color(this.parent.colorCursor));
                this.g1.fillRect(this.menuWidthPos, this.lineHeight * i + this.menuHeightPos, this.menuWidth, this.lineHeight);
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            this.g1.drawString((String)this.canvasMenu.elementAt(i + this.startMenuPos), this.menuWidthPos + 3, vpos);
        }
    }

    void processMenuCommand(int k) {
        this.repaint();
        this.commandAction((String)this.canvasMenu.elementAt(k));
    }

    void processSwitchViewsMenu(int k) {
        this.setupCanvasMenu();
        switch (k) {
            case 0: {
                this.commandAction("Accounts");
                break;
            }
            case 1: {
                this.commandAction("Transactions");
                break;
            }
            case 2: {
                this.commandAction("Categories");
                break;
            }
            case 3: {
                this.commandAction("Standing Orders");
                break;
            }
            case 4: {
                this.commandAction("Investments");
                break;
            }
            case 5: {
                this.commandAction("Currencies");
            }
        }
    }

    public void commandAction(String cmd) {
        this.showingPopupMenu = false;
        if (this.parent.saveStateOnHome) {
            this.parent.ixs.selfDestruct();
        }
        if (cmd.equals("Exit")) {
            this.parent.finishAndQuit();
            return;
        }
        if (cmd.equals("Home")) {
            if (this.parent.av == null) {
                this.parent.av = new AccountView(this.parent);
            }
            this.parent.setContentView(this.parent.av);
            return;
        }
        if (cmd.equals("New")) {
            this.parent.invf = new InvestmentForm(this.parent, new Investment(this.parent), "New");
            return;
        }
        if (cmd.equals("Edit")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to edit", 2000).show();
                return;
            }
            this.oldInv = new Investment(this.parent);
            this.oldInv.clone(this.inv);
            this.parent.invf = new InvestmentForm(this.parent, this.inv, "Edit");
            return;
        }
        if (cmd.equals("Manual Price")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to edit", 2000).show();
                return;
            }
            this.oldInv = new Investment(this.parent);
            this.oldInv.clone(this.inv);
            this.parent.invf = new InvestmentForm(this.parent, this.inv, "Price");
            return;
        }
        if (cmd.equals("Internet Price")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to edit", 2000).show();
                return;
            }
            if (this.parent.alphaVantageKey.equals("")) {
                this.parent.getAlphaVantageKey();
                return;
            }
            this.updateInternetPrice(this.inv);
            return;
        }
        if (cmd.equals("Delete")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to delete", 2000).show();
                return;
            }
            this.parent.invf = new InvestmentForm(this.parent, this.inv, "Delete");
            return;
        }
        if (cmd.equals("Show")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to show", 2000).show();
                return;
            }
            this.parent.gsf = new GenericShowForm(this.parent, this.inv, 4);
            this.parent.setContentView(this.parent.gsf);
            return;
        }
        if (cmd.equals("Switch Views")) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.showSwitchViewsMenu = true;
                this.setupSwitchViewsMenu();
                this.repaint();
                return;
            }
            this.displaySwitchViewsMenu();
            return;
        }
        if (cmd.equals("Investment Settings")) {
            new InvestmentSettingsForm(this.parent);
            this.repaint();
            return;
        }
        if (cmd.equals("Get API Key")) {
            this.parent.getAlphaVantageKey();
            return;
        }
        if (cmd.equals("Accounts") || cmd.equals("Home")) {
            if (this.parent.av == null) {
                this.parent.av = new AccountView(this.parent);
            }
            this.parent.setContentView(this.parent.av);
            this.repaint();
            return;
        }
        if (cmd.equals("Transactions")) {
            if (this.parent.tv == null) {
                Toast.makeText(this.parent, "No account selected", 2000).show();
            } else {
                this.parent.setContentView(this.parent.tv);
            }
            this.repaint();
            return;
        }
        if (cmd.equals("Categories")) {
            if (this.parent.cv == null) {
                this.parent.cv = new CategoryView(this.parent);
            }
            this.parent.setContentView(this.parent.cv);
            this.repaint();
            return;
        }
        if (cmd.equals("Standing Orders")) {
            if (this.parent.sov == null) {
                this.parent.sov = new StandingOrderView(this.parent);
            }
            this.parent.setContentView(this.parent.sov);
            this.repaint();
            return;
        }
        if (cmd.equals("Investments")) {
            Toast.makeText(this.parent, "Already in Investments View", 2000).show();
            this.repaint();
            return;
        }
        if (cmd.equals("Currencies")) {
            if (this.parent.ccyv == null) {
                this.parent.ccyv = new CurrencyView(this.parent);
            }
            this.parent.setContentView(this.parent.ccyv);
            this.repaint();
            return;
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int keyCode = keyEvent.getKeyCode();
        switch (keyCode) {
            case 33: 
            case 37: {
                if (this.startPos == 0) {
                    this.currentPos = 0;
                    this.currentY = this.lineHeight;
                    break;
                }
                this.startPos -= this.numItemsPage;
                if (this.startPos >= 0) break;
                this.startPos = 0;
                break;
            }
            case 34: 
            case 39: {
                this.startPos += this.numItemsPage;
                if (this.startPos + this.currentPos <= this.numItems - 1) break;
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                break;
            }
            case 38: {
                this.drawUp();
                break;
            }
            case 40: {
                this.drawDown();
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int keyCode = keyEvent.getKeyCode();
        switch (keyCode) {
            case 36: {
                this.startPos = 0;
                this.currentPos = 0;
                this.currentY = this.lineHeight;
                break;
            }
            case 35: {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                break;
            }
            case 10: 
            case 525: {
                if (this.showCanvasMenu) {
                    this.showCanvasMenu = false;
                    if (this.showSwitchViewsMenu) {
                        this.showSwitchViewsMenu = false;
                        this.processSwitchViewsMenu(this.startMenuPos + this.currentMenuPos);
                        break;
                    }
                    this.processMenuCommand(this.startMenuPos + this.currentMenuPos);
                    break;
                }
                if (this.numItems == 0) break;
                if (this.parent.useCanvasMenu) {
                    this.showCanvasMenu = true;
                    break;
                }
                if (keyCode != 525) break;
                this.displayPopupMenu();
                break;
            }
            case 27: {
                this.parent.onBackPressed();
                break;
            }
            case 80: {
                this.commandAction("Price");
                break;
            }
            case 78: {
                this.commandAction("New");
                break;
            }
            case 69: {
                this.commandAction("Edit");
                break;
            }
            case 68: {
                this.commandAction("Delete");
                break;
            }
            case 70: {
                this.commandAction("Find");
                break;
            }
            case 83: {
                this.commandAction("Show");
                break;
            }
            case 72: {
                this.commandAction("Home");
                break;
            }
            case 86: {
                this.commandAction("Switch Views");
                break;
            }
            case 75: {
                this.parent.gsf = new GenericShowForm(this.parent, null, 9);
                this.parent.setContentView(this.parent.gsf);
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

