/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.freepoc.Jabp4.Investment;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.NameId;
import org.freepoc.Jabp4.RecordStore;

public class InvestmentStore {
    RecordStore rs;
    Jabp parent;
    Hashtable ht;

    public InvestmentStore(Jabp context, boolean fastDiskAccess) {
        this.parent = context;
        this.ht = this.parent.investmentHt;
        this.openInvestmentStore(fastDiskAccess);
    }

    void openInvestmentStore(boolean fastDiskAccess) {
        this.rs = new RecordStore(this.parent, "Investments", fastDiskAccess);
    }

    void closeInvestmentStore() {
        if (this.rs != null) {
            this.rs.closeRecordStore();
        }
    }

    int getNumInvestments() {
        return this.rs.getNumRecords();
    }

    byte[] toByteArray(Investment inv) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeUTF(inv.name);
            dos.writeUTF(inv.description);
            dos.writeUTF(inv.currency);
            dos.writeInt(inv.holding);
            dos.writeInt(inv.price);
            dos.writeLong(inv.priceLongDate);
            dos.close();
        }
        catch (IOException ie) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    Investment fromByteArray(byte[] bytes) {
        Investment inv = new Investment(this.parent);
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            inv.name = dis.readUTF();
            inv.description = dis.readUTF();
            inv.currency = dis.readUTF();
            inv.holding = dis.readInt();
            inv.price = dis.readInt();
            inv.priceLongDate = dis.readLong();
            dis.close();
        }
        catch (IOException ie) {
            System.err.println(ie + " is4a");
        }
        return inv;
    }

    Investment getInvestment(int id) {
        Investment inv = new Investment(this.parent);
        byte[] bytes = this.rs.getRecord(id);
        inv = this.fromByteArray(bytes);
        inv.id = id;
        return inv;
    }

    void setToStart() {
        this.rs.setToStart();
    }

    Investment readNextInvestment() {
        Investment inv = new Investment(this.parent);
        byte[] bytes = this.rs.readRecord();
        if (bytes == null) {
            return null;
        }
        int id = this.rs.getCurrentFilePosition() - bytes.length - 5;
        inv = this.fromByteArray(bytes);
        inv.id = id;
        return inv;
    }

    Investment getInvestmentFromIndex(int i) {
        int id = ((NameId)this.ht.get((Object)new Integer((int)i))).id;
        return this.getInvestment(id);
    }

    Investment getInvestmentFromName(String string) {
        int n = this.getNumInvestments();
        for (int i = 0; i < n; ++i) {
            String s1 = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!s1.equals(string)) continue;
            int id = ((NameId)this.ht.get((Object)new Integer((int)i))).id;
            return this.getInvestment(id);
        }
        Investment inv = new Investment(this.parent);
        inv.name = string;
        inv.id = this.saveNewInvestment(inv);
        if (this.parent.iv != null) {
            ++this.parent.iv.numItems;
        }
        return inv;
    }

    void deleteInvestment(Investment inv) {
        this.rs.deleteRecord(inv.id);
    }

    int saveNewInvestment(Investment inv) {
        inv.id = this.rs.getNextRecordID();
        byte[] bytes = this.toByteArray(inv);
        this.rs.addRecord(bytes, 0, bytes.length);
        this.addIndex(inv);
        return inv.id;
    }

    int saveNewInvestmentWithoutIndex(Investment inv) {
        inv.id = this.rs.getNextRecordID();
        byte[] bytes = this.toByteArray(inv);
        this.rs.addRecord(bytes, 0, bytes.length);
        return inv.id;
    }

    void saveExistingInvestment(Investment inv) {
        byte[] bytes = this.toByteArray(inv);
        this.rs.setRecord(inv.id, bytes, 0, bytes.length);
    }

    int lookUpId(Investment inv) {
        inv.id = 0;
        int n = this.ht.size();
        for (int i = 0; i < n; ++i) {
            String string = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!string.equals(inv.name)) continue;
            inv.id = ((NameId)this.ht.get((Object)new Integer((int)i))).id;
            break;
        }
        return inv.id;
    }

    int lookUpIndex(Investment inv) {
        int n = this.ht.size();
        int j = -1;
        for (int i = 0; i < n; ++i) {
            String string = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!string.equals(inv.name)) continue;
            j = i;
            break;
        }
        return j;
    }

    void deleteIndex(Investment inv) {
        this.deleteIndex(this.lookUpIndex(inv));
    }

    void deleteIndex(int index) {
        int n = this.ht.size();
        for (int i = index; i < n - 1; ++i) {
            int j = i + 1;
            NameId nameId = (NameId)this.ht.get(new Integer(j));
            this.ht.put(new Integer(i), nameId);
        }
        this.ht.remove(new Integer(n - 1));
    }

    void addIndex(Investment inv) {
        int i;
        int n;
        int p = n = this.ht.size();
        for (i = 0; i < n; ++i) {
            NameId nameId = (NameId)this.ht.get(new Integer(i));
            if (inv.name.compareTo(nameId.name) >= 0) continue;
            p = i;
            break;
        }
        if (p < n) {
            for (i = n - 1; i >= p; --i) {
                int j = i + 1;
                NameId nameId = (NameId)this.ht.get(new Integer(i));
                this.ht.put(new Integer(j), nameId);
            }
        }
        NameId nameId = new NameId(inv.name, inv.id);
        this.ht.put(new Integer(p), nameId);
    }

    void updateIndex(int index, Investment inv) {
        this.ht.put(new Integer(index), new NameId(inv.name, inv.id));
    }

    int getSize() {
        return this.rs.getSize();
    }
}

