/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.Component;
import javax.swing.JList;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.Investment;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Utilities;

public class InvestmentSettingsForm
extends Component {
    Jabp parent;

    public InvestmentSettingsForm(Jabp context) {
        this.parent = context;
        this.parent.lastUsedScreen = 23;
        DialogManager dm = new DialogManager(this.parent, "Investment settings");
        JList JListHoldings = dm.addJList("Holding dec places", 4, false);
        dm.addJListItem(JListHoldings, "0");
        dm.addJListItem(JListHoldings, "1");
        dm.addJListItem(JListHoldings, "2");
        dm.addJListItem(JListHoldings, "3");
        dm.selectJListItem(JListHoldings, this.parent.holdingDecimalPlaces);
        JList JListPrices = dm.addJList("Price dec places", 4, false);
        dm.addJListItem(JListPrices, "2");
        dm.addJListItem(JListPrices, "3");
        dm.addJListItem(JListPrices, "4");
        dm.addJListItem(JListPrices, "5");
        dm.selectJListItem(JListPrices, this.parent.priceDecimalPlaces - 2);
        dm.addOKCancelButtons();
        dm.addButton("Reset");
        dm.centerShow();
        if (dm.checkButtonText().equals("Reset")) {
            this.parent.holdingDecimalPlaces = dm.getSelectedJListIndex(JListHoldings);
            this.parent.priceDecimalPlaces = dm.getSelectedJListIndex(JListPrices) + 2;
            this.parent.iv.totalValue = 0;
            for (int i = 0; i < this.parent.iv.numItems; ++i) {
                Investment inv = this.parent.iv.is.getInvestmentFromIndex(i);
                this.parent.iv.totalValue += inv.calcValue(inv);
            }
            dm.dispose();
            Toast.makeText(this.parent, "Settings updated", 2000).show();
            this.parent.setContentView(this.parent.iv);
            return;
        }
        if (dm.checkButtonText().equals("OK")) {
            int oldHDP = this.parent.holdingDecimalPlaces;
            int oldPDP = this.parent.priceDecimalPlaces;
            int newHDP = dm.getSelectedJListIndex(JListHoldings);
            int newPDP = dm.getSelectedJListIndex(JListPrices) + 2;
            this.parent.holdingDecimalPlaces = newHDP;
            this.parent.priceDecimalPlaces = newPDP;
            this.parent.iv.totalValue = 0;
            for (int i = 0; i < this.parent.iv.numItems; ++i) {
                Investment inv = this.parent.iv.is.getInvestmentFromIndex(i);
                long holding = inv.holding;
                long multiplier = Utilities.pow(10, newHDP);
                long divider = Utilities.pow(10, oldHDP);
                holding = holding * multiplier / divider;
                inv.holding = (int)holding;
                long price = inv.price;
                multiplier = Utilities.pow(10, newPDP - 2);
                divider = Utilities.pow(10, oldPDP - 2);
                price = price * multiplier / divider;
                inv.price = (int)price;
                this.parent.iv.is.saveExistingInvestment(inv);
                this.parent.iv.totalValue += inv.calcValue(inv);
            }
            dm.dispose();
            Toast.makeText(this.parent, "Settings updated", 2000).show();
            this.parent.setContentView(this.parent.iv);
            return;
        }
        dm.dispose();
        Toast.makeText(this.parent, "Cancelled", 1000).show();
        this.parent.setContentView(this.parent.iv);
    }
}

