/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.Container;
import java.awt.Frame;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.freepoc.Jabp4.Currency;
import org.freepoc.Jabp4.CurrencyStore;
import org.freepoc.Jabp4.DateChooser;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.Investment;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Utilities;

public class InvestmentForm
extends Container {
    Jabp parent;
    Investment inv;

    public InvestmentForm(Jabp context, Investment investment, String action) {
        this.parent = context;
        this.parent.lastUsedScreen = 22;
        this.inv = investment;
        if (action.equals("New")) {
            this.createInvestment(new Investment(this.parent));
        }
        if (action.equals("Edit")) {
            this.updateInvestment(this.inv);
        }
        if (action.equals("Delete")) {
            this.deleteInvestment(this.inv);
        }
        if (action.equals("Price")) {
            this.priceInvestment(this.inv);
        }
    }

    void createInvestment(Investment inv) {
        DialogManager dm = new DialogManager(this.parent, "New investment");
        JTextField tfName = dm.addJTextField("Name", inv.name);
        JTextField tfDescription = dm.addJTextField("Description", inv.description);
        if (this.parent.holdingDecimalPlaces == 0) {
            dm.addText("Enter holding as an integer quantity");
        } else if (this.parent.holdingDecimalPlaces == 1) {
            dm.addText("Enter holding with up to 1 decimal place");
        } else {
            dm.addText("Enter holding with up to " + this.parent.holdingDecimalPlaces + " decimal places");
        }
        JTextField tfHolding = dm.addJTextField("Holding", Utilities.decimalToString(Math.abs(inv.holding), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, this.parent.holdingDecimalPlaces));
        dm.addText("Enter price with up to " + this.parent.priceDecimalPlaces + " decimal places");
        JTextField tfPrice = dm.addJTextField("Price", Utilities.decimalToString(Math.abs(inv.price), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, this.parent.priceDecimalPlaces));
        Date date = new Date();
        date.setTime(this.parent.lastUsedDate.getTime());
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf2 = null;
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf2 = new SimpleDateFormat("dd/MM/yy HH");
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            sdf = new SimpleDateFormat("MM/dd/yyyy");
            sdf2 = new SimpleDateFormat("MM/dd/yy HH");
        }
        JTextField tfPriceDate = dm.addJTextFieldWithButton("Date", sdf.format(date));
        JComboBox chCurrency = dm.addJComboBox("Currency");
        CurrencyStore ccys = null;
        ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
        Currency ccy = null;
        int n = ccys.getNumCurrencies();
        for (int i = 0; i < n; ++i) {
            ccy = ccys.getCurrencyFromIndex(i);
            dm.addJComboBoxItem(chCurrency, ccy.code);
            if (!ccy.code.equals(this.parent.homeCurrency)) continue;
            dm.setSelectedJComboBox(chCurrency, i);
        }
        if (this.parent.ccyv == null) {
            ccys.closeCurrencyStore();
        }
        dm.addButton("Cancel");
        dm.addButton("Create");
        dm.centerShow();
        if (!dm.checkButtons()) {
            dm.dispose();
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            return;
        }
        String s = dm.getUserText(tfName).trim();
        if (s.equals("")) {
            Toast.makeText(this.parent, "Blank investment name", 2000).show();
            dm.dispose();
            this.createInvestment(inv);
            return;
        }
        inv.name = s;
        if (this.parent.iv.is.lookUpId(inv) != 0) {
            Toast.makeText(this.parent, s + " already exists", 2000).show();
            dm.dispose();
            this.createInvestment(inv);
            return;
        }
        inv.description = dm.getUserText(tfDescription).trim();
        int i = inv.holding;
        inv.holding = Utilities.stringToDecimal(dm.getUserText(tfHolding), i, false, this.parent.isEuropeanNumberFormat, this.parent.holdingDecimalPlaces);
        if (inv.holding < 0) {
            Toast.makeText(this.parent, "Holding cannot be negative", 2000).show();
            inv.holding = 0;
            dm.dispose();
            this.createInvestment(inv);
            return;
        }
        i = inv.price;
        inv.price = Utilities.stringToDecimal(dm.getUserText(tfPrice), i, false, this.parent.isEuropeanNumberFormat, this.parent.priceDecimalPlaces);
        if (inv.price < 0) {
            Toast.makeText(this.parent, "Price cannot be negative", 2000).show();
            inv.price = 0;
            dm.dispose();
            this.createInvestment(inv);
            return;
        }
        try {
            inv.priceLongDate = sdf2.parse(dm.getUserText(tfPriceDate) + " 02").getTime();
        }
        catch (ParseException pe) {
            Toast.makeText(this.parent, "Incorrect date", 2000).show();
            inv.priceLongDate = date.getTime();
            dm.dispose();
            this.createInvestment(inv);
            return;
        }
        inv.currency = dm.getSelectedJComboBoxString(chCurrency);
        if (dm.checkButtonText().equals(">")) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis(inv.priceLongDate);
            DateChooser dc = new DateChooser((Frame)this.parent, gc);
            if (dc.showDateChooser() == 1) {
                gc = dc.getDate();
            }
            inv.priceLongDate = gc.getTimeInMillis();
            this.parent.lastUsedDate.setTime(inv.priceLongDate);
            dm.dispose();
            this.createInvestment(inv);
            return;
        }
        this.parent.iv.newInvestment(inv);
        Toast.makeText(this.parent, inv.name + " created", 1000).show();
        dm.dispose();
    }

    void updateInvestment(Investment inv) {
        DialogManager dm = new DialogManager(this.parent, "Edit investment");
        JTextField tfName = dm.addJTextField("Name", inv.name);
        JTextField tfDescription = dm.addJTextField("Description", inv.description);
        if (this.parent.holdingDecimalPlaces == 0) {
            dm.addText("Enter holding as an integer quantity");
        } else if (this.parent.holdingDecimalPlaces == 1) {
            dm.addText("Enter holding with up to 1 decimal place");
        } else {
            dm.addText("Enter holding with up to " + this.parent.holdingDecimalPlaces + " decimal places");
        }
        JTextField tfHolding = dm.addJTextField("Holding", Utilities.decimalToString(Math.abs(inv.holding), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, this.parent.holdingDecimalPlaces));
        if (inv.currency.equals(this.parent.homeCurrency)) {
            dm.addText("Enter price with up to " + this.parent.priceDecimalPlaces + " decimal places");
        } else {
            dm.addText("Enter price in " + inv.currency + " with up to " + this.parent.priceDecimalPlaces + " decimal places");
        }
        JTextField tfPrice = dm.addJTextField("Price", Utilities.decimalToString(Math.abs(inv.price), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, this.parent.priceDecimalPlaces));
        Date date = new Date();
        date.setTime(inv.priceLongDate);
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf2 = null;
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf2 = new SimpleDateFormat("dd/MM/yy HH");
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            sdf = new SimpleDateFormat("MM/dd/yyyy");
            sdf2 = new SimpleDateFormat("MM/dd/yy HH");
        }
        JTextField tfPriceDate = dm.addJTextFieldWithButton("Date", sdf.format(date));
        JComboBox chCurrency = dm.addJComboBox("Currency");
        CurrencyStore ccys = null;
        ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
        Currency ccy = null;
        int n = ccys.getNumCurrencies();
        for (int i = 0; i < n; ++i) {
            ccy = ccys.getCurrencyFromIndex(i);
            dm.addJComboBoxItem(chCurrency, ccy.code);
            if (!ccy.code.equals(inv.currency)) continue;
            dm.setSelectedJComboBox(chCurrency, i);
        }
        if (this.parent.ccyv == null) {
            ccys.closeCurrencyStore();
        }
        dm.addButton("Cancel");
        dm.addButton("Update");
        dm.centerShow();
        if (!dm.checkButtons()) {
            dm.dispose();
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            return;
        }
        String oldName = inv.name;
        String newName = dm.getUserText(tfName).trim();
        if (newName.equals("")) {
            Toast.makeText(this.parent, "Blank investment name", 2000).show();
            dm.dispose();
            this.updateInvestment(inv);
            return;
        }
        inv.name = newName;
        int k = inv.id;
        if (!oldName.equals(newName) && this.parent.iv.is.lookUpId(inv) != 0) {
            Toast.makeText(this.parent, newName + " already exists", 2000).show();
            inv.name = oldName;
            dm.dispose();
            this.updateInvestment(inv);
            return;
        }
        inv.id = k;
        inv.description = dm.getUserText(tfDescription).trim();
        int i = inv.holding;
        inv.holding = Utilities.stringToDecimal(dm.getUserText(tfHolding), i, false, this.parent.isEuropeanNumberFormat, this.parent.holdingDecimalPlaces);
        if (inv.holding < 0) {
            Toast.makeText(this.parent, "Holding cannot be negative", 2000).show();
            inv.holding = i;
            dm.dispose();
            this.updateInvestment(inv);
            return;
        }
        i = inv.price;
        inv.price = Utilities.stringToDecimal(dm.getUserText(tfPrice), i, false, this.parent.isEuropeanNumberFormat, this.parent.priceDecimalPlaces);
        if (inv.price < 0) {
            Toast.makeText(this.parent, "Price cannot be negative", 2000).show();
            inv.price = i;
            dm.dispose();
            this.updateInvestment(inv);
            return;
        }
        try {
            inv.priceLongDate = sdf2.parse(dm.getUserText(tfPriceDate) + " 02").getTime();
        }
        catch (ParseException pe) {
            Toast.makeText(this.parent, "Incorrect date", 2000).show();
            inv.priceLongDate = date.getTime();
            dm.dispose();
            this.updateInvestment(inv);
            return;
        }
        inv.currency = dm.getSelectedJComboBoxString(chCurrency);
        if (dm.checkButtonText().equals(">")) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis(inv.priceLongDate);
            DateChooser dc = new DateChooser((Frame)this.parent, gc);
            if (dc.showDateChooser() == 1) {
                gc = dc.getDate();
            }
            inv.priceLongDate = gc.getTimeInMillis();
            this.parent.lastUsedDate.setTime(inv.priceLongDate);
            dm.dispose();
            this.updateInvestment(inv);
            return;
        }
        this.parent.iv.editInvestment(inv);
        Toast.makeText(this.parent, inv.name + " updated", 1000).show();
        dm.dispose();
    }

    void deleteInvestment(Investment inv) {
        DialogManager dm = new DialogManager(this.parent, "Delete investment");
        JTextField tfName = dm.addJTextField("Name", inv.name);
        JTextField tfDescription = dm.addJTextField("Description", inv.description);
        JTextField tfHolding = dm.addJTextField("Holding", Utilities.decimalToString(Math.abs(inv.holding), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, this.parent.holdingDecimalPlaces));
        JTextField tfPrice = dm.addJTextField("Price", Utilities.decimalToString(Math.abs(inv.price), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, this.parent.priceDecimalPlaces));
        Date date = new Date();
        date.setTime(inv.priceLongDate);
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf2 = null;
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf2 = new SimpleDateFormat("dd/MM/yy HH");
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            sdf = new SimpleDateFormat("MM/dd/yyyy");
            sdf2 = new SimpleDateFormat("MM/dd/yy HH");
        }
        JTextField tfPriceDate = dm.addJTextFieldWithButton("Date", sdf.format(date));
        JComboBox chCurrency = dm.addJComboBox("Currency");
        CurrencyStore ccys = null;
        ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
        Currency ccy = null;
        int n = ccys.getNumCurrencies();
        for (int i = 0; i < n; ++i) {
            ccy = ccys.getCurrencyFromIndex(i);
            dm.addJComboBoxItem(chCurrency, ccy.code);
            if (!ccy.code.equals(this.parent.homeCurrency)) continue;
            dm.setSelectedJComboBox(chCurrency, i);
        }
        if (this.parent.ccyv == null) {
            ccys.closeCurrencyStore();
        }
        dm.addButton("Cancel");
        dm.addButton("Delete");
        dm.centerShow();
        if (!dm.checkButtons()) {
            dm.dispose();
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            return;
        }
        this.parent.iv.deleteInvestment(inv);
        Toast.makeText(this.parent, "Investment deleted", 1000).show();
        dm.dispose();
    }

    void priceInvestment(Investment inv) {
        DialogManager dm = new DialogManager(this.parent, "Price investment");
        dm.addText("Name", inv.name);
        dm.addText("Description", inv.description);
        dm.addText("Holding", Utilities.decimalToString(Math.abs(inv.holding), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, this.parent.holdingDecimalPlaces));
        if (inv.currency.equals(this.parent.homeCurrency)) {
            dm.addText("Enter price with up to " + this.parent.priceDecimalPlaces + " decimal places");
        } else {
            dm.addText("Enter price in " + inv.currency + " with up to " + this.parent.priceDecimalPlaces + " decimal places");
        }
        JTextField tfPrice = dm.addJTextField("Price", Utilities.decimalToString(Math.abs(inv.price), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, this.parent.priceDecimalPlaces));
        if (inv.currency.equals(this.parent.homeCurrency)) {
            dm.addText("Enter value with up to 2 decimal places");
        } else {
            dm.addText("Enter value in " + inv.currency + " with up to 2 decimal places");
        }
        JTextField tfValue = dm.addJTextField("Value", Utilities.numberToString(inv.calcValue2(inv), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed));
        Date date = new Date();
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf2 = null;
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf2 = new SimpleDateFormat("dd/MM/yy HH");
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            sdf = new SimpleDateFormat("MM/dd/yyyy");
            sdf2 = new SimpleDateFormat("MM/dd/yy HH");
        }
        JTextField tfPriceDate = dm.addJTextFieldWithButton("Date", sdf.format(date));
        date.setTime(inv.priceLongDate);
        dm.addText("Last price date", sdf.format(date));
        dm.addText("Currency", inv.currency);
        dm.addButton("Cancel");
        dm.addButton("New Price");
        dm.addButton("New Value");
        dm.centerShow();
        if (!dm.checkButtons()) {
            dm.dispose();
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            return;
        }
        if (dm.checkButtonText().equals("New Price")) {
            int i = inv.price;
            inv.price = Utilities.stringToDecimal(dm.getUserText(tfPrice), i, false, this.parent.isEuropeanNumberFormat, this.parent.priceDecimalPlaces);
            if (inv.price < 0) {
                Toast.makeText(this.parent, "Price cannot be negative", 2000).show();
                inv.price = i;
                dm.dispose();
                this.priceInvestment(inv);
                return;
            }
        }
        if (dm.checkButtonText().equals("New Value")) {
            int value = Utilities.stringToNumber(dm.getUserText(tfValue), 0, false, this.parent.isEuropeanNumberFormat);
            if (value < 0) {
                Toast.makeText(this.parent, "Value cannot be negative", 2000).show();
                dm.dispose();
                this.priceInvestment(inv);
                return;
            }
            long longValue = value;
            long longHolding = inv.holding;
            longValue = longValue * (long)Utilities.pow(10, this.parent.priceDecimalPlaces) * (long)Utilities.pow(10, this.parent.holdingDecimalPlaces) / 100L;
            inv.price = (int)(longValue / longHolding);
        }
        try {
            inv.priceLongDate = sdf2.parse(dm.getUserText(tfPriceDate) + " 02").getTime();
        }
        catch (ParseException pe) {
            Toast.makeText(this.parent, "Incorrect date", 2000).show();
            inv.priceLongDate = date.getTime();
            dm.dispose();
            this.priceInvestment(inv);
            return;
        }
        if (dm.checkButtonText().equals(">")) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis(inv.priceLongDate);
            DateChooser dc = new DateChooser((Frame)this.parent, gc);
            if (dc.showDateChooser() == 1) {
                gc = dc.getDate();
            }
            inv.priceLongDate = gc.getTimeInMillis();
            this.parent.lastUsedDate.setTime(inv.priceLongDate);
            dm.dispose();
            this.priceInvestment(inv);
            return;
        }
        this.parent.iv.priceInvestment(inv);
        Toast.makeText(this.parent, inv.name + " updated", 1000).show();
        dm.dispose();
    }
}

