/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.LongId;
import org.freepoc.Jabp4.NameId;
import org.freepoc.Jabp4.RecordStore;

public class IndexStore {
    RecordStore rs;
    Jabp parent;
    String name1;

    public IndexStore(Jabp context, boolean fastDiskAccess) {
        this.parent = context;
        this.openIndexStore(fastDiskAccess);
    }

    void openIndexStore(boolean fastDiskAccess) {
        this.rs = new RecordStore(this.parent, "Indices", fastDiskAccess);
    }

    void closeIndexStore() {
        if (this.rs != null) {
            this.rs.closeRecordStore();
        }
    }

    void selfDestruct() {
        this.rs.deleteRecordStore("Indices");
    }

    int getNumIndices() {
        if (this.rs == null) {
            return 0;
        }
        return this.rs.getNumRecords();
    }

    byte[] ht1ToByteArray(Hashtable ht) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(ht.size());
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                Integer i1 = (Integer)e.nextElement();
                int i = i1;
                dos.writeInt(i);
                NameId nameId = (NameId)ht.get(i1);
                dos.writeUTF(nameId.name);
                dos.writeInt(nameId.id);
            }
            dos.close();
        }
        catch (IOException ie) {
            System.out.println(ie + " in8a");
        }
        return baos.toByteArray();
    }

    byte[] ht2ToByteArray(Hashtable ht) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(ht.size());
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                Integer i1 = (Integer)e.nextElement();
                int i = i1;
                dos.writeInt(i);
                LongId longId = (LongId)ht.get(i1);
                dos.writeLong(longId.lo);
                dos.writeInt(longId.id);
            }
            dos.close();
        }
        catch (IOException ie) {
            System.out.println(ie + " in8b");
        }
        return baos.toByteArray();
    }

    byte[] ht3ToByteArray(Hashtable ht, String name) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeUTF(name);
            dos.writeInt(ht.size());
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                Integer i1 = (Integer)e.nextElement();
                int i = i1;
                dos.writeInt(i);
                LongId longId = (LongId)ht.get(i1);
                dos.writeLong(longId.lo);
                dos.writeInt(longId.id);
            }
            dos.close();
        }
        catch (IOException ie) {
            System.out.println(ie + " in8c");
        }
        return baos.toByteArray();
    }

    Hashtable ht1FromByteArray(byte[] bytes) {
        Hashtable<Integer, NameId> ht = null;
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            int n = dis.readInt();
            ht = new Hashtable<Integer, NameId>(n);
            for (int i = 0; i < n; ++i) {
                int j = dis.readInt();
                String name = dis.readUTF();
                int id = dis.readInt();
                ht.put(new Integer(j), new NameId(name, id));
            }
            dis.close();
        }
        catch (IOException ie) {
            System.err.println(ie + " in9a");
        }
        return ht;
    }

    Hashtable ht2FromByteArray(byte[] bytes) {
        Hashtable<Integer, LongId> ht = null;
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            int n = dis.readInt();
            ht = new Hashtable<Integer, LongId>(n);
            for (int i = 0; i < n; ++i) {
                int j = dis.readInt();
                long lo = dis.readLong();
                int id = dis.readInt();
                ht.put(new Integer(j), new LongId(lo, id));
            }
            dis.close();
        }
        catch (IOException ie) {
            System.err.println(ie + " in9b");
        }
        return ht;
    }

    Hashtable ht3FromByteArray(byte[] bytes) {
        Hashtable<Integer, LongId> ht = null;
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            this.name1 = dis.readUTF();
            int n = dis.readInt();
            ht = new Hashtable<Integer, LongId>(n);
            for (int i = 0; i < n; ++i) {
                int j = dis.readInt();
                long lo = dis.readLong();
                int id = dis.readInt();
                ht.put(new Integer(j), new LongId(lo, id));
            }
            dis.close();
        }
        catch (IOException ie) {
            System.err.println(ie + " in9c");
        }
        return ht;
    }

    boolean getIndices() {
        if (this.rs.getNumRecords() == 0) {
            return false;
        }
        byte[] bytes = this.rs.readRecord();
        this.parent.accountHt = this.ht1FromByteArray(bytes);
        bytes = this.rs.readRecord();
        this.parent.categoryHt = this.ht1FromByteArray(bytes);
        bytes = this.rs.readRecord();
        this.parent.currencyHt = this.ht1FromByteArray(bytes);
        bytes = this.rs.readRecord();
        this.parent.standingOrderHt = this.ht2FromByteArray(bytes);
        bytes = this.rs.readRecord();
        this.parent.regularHt = this.ht1FromByteArray(bytes);
        bytes = this.rs.readRecord();
        this.parent.investmentHt = this.ht1FromByteArray(bytes);
        int n = this.parent.accountHt.size();
        for (int j = 0; j < n; ++j) {
            bytes = this.rs.readRecord();
            String s1 = ((NameId)this.parent.accountHt.get((Object)new Integer((int)j))).name;
            Hashtable ht = this.ht3FromByteArray(bytes);
            if (ht == null) {
                ht = new Hashtable();
            }
            if (!s1.equals(this.name1)) {
                System.out.println("Name mismatch in getIndices()");
            }
            this.parent.transactionHt.put(this.name1, ht);
        }
        return true;
    }

    void saveIndices() {
        if (this.rs == null) {
            return;
        }
        this.rs.activeRecords = 0;
        byte[] bytes = this.ht1ToByteArray(this.parent.accountHt);
        this.rs.addRecord(bytes, 0, bytes.length);
        bytes = this.ht1ToByteArray(this.parent.categoryHt);
        this.rs.addRecord(bytes, 0, bytes.length);
        bytes = this.ht1ToByteArray(this.parent.currencyHt);
        this.rs.addRecord(bytes, 0, bytes.length);
        bytes = this.ht2ToByteArray(this.parent.standingOrderHt);
        this.rs.addRecord(bytes, 0, bytes.length);
        bytes = this.ht1ToByteArray(this.parent.regularHt);
        this.rs.addRecord(bytes, 0, bytes.length);
        bytes = this.ht1ToByteArray(this.parent.investmentHt);
        this.rs.addRecord(bytes, 0, bytes.length);
        int n = this.parent.accountHt.size();
        for (int i = 0; i < n; ++i) {
            String s1 = ((NameId)this.parent.accountHt.get((Object)new Integer((int)i))).name;
            Hashtable ht = (Hashtable)this.parent.transactionHt.get(s1);
            if (ht == null) {
                ht = new Hashtable();
            }
            bytes = this.ht3ToByteArray(ht, s1);
            this.rs.addRecord(bytes, 0, bytes.length);
        }
    }

    int getSize() {
        if (this.rs == null) {
            return 0;
        }
        if (this.rs.getNumRecords() == 0) {
            return 0;
        }
        return this.rs.getSize();
    }
}

