/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.UploadErrorException;
import com.dropbox.core.v2.files.WriteMode;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JList;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.AccountStore;
import org.freepoc.Jabp4.AccountView;
import org.freepoc.Jabp4.Category;
import org.freepoc.Jabp4.CategoryStore;
import org.freepoc.Jabp4.Currency;
import org.freepoc.Jabp4.CurrencyStore;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.Encrypt;
import org.freepoc.Jabp4.ExportQifOptionsForm;
import org.freepoc.Jabp4.IndexStore;
import org.freepoc.Jabp4.Investment;
import org.freepoc.Jabp4.InvestmentStore;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.LongId;
import org.freepoc.Jabp4.PendingTransactionForm;
import org.freepoc.Jabp4.PreferenceStore;
import org.freepoc.Jabp4.RecordStore;
import org.freepoc.Jabp4.Regular;
import org.freepoc.Jabp4.RegularStore;
import org.freepoc.Jabp4.SetDirectoryForm;
import org.freepoc.Jabp4.ShowProgressForm;
import org.freepoc.Jabp4.Sort;
import org.freepoc.Jabp4.Split;
import org.freepoc.Jabp4.SplitStore;
import org.freepoc.Jabp4.StandingOrder;
import org.freepoc.Jabp4.StandingOrderStore;
import org.freepoc.Jabp4.SyncStore;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.TransactionStore;
import org.freepoc.Jabp4.Utilities;

public class ImportExportForm
extends Component
implements Runnable {
    Jabp parent;
    Calendar cal;
    Date todayDate;
    Date genericDate;
    long todayDays;
    File fc;
    File fc1;
    File fc2;
    File fc3;
    String root = "";
    String internalRoot = "";
    String directory = "";
    RecordStore rs;
    DataInputStream dis;
    DataOutputStream dos;
    InputStream in;
    InputStreamReader isr;
    InputStreamReader isr2;
    InputStreamReader isr3;
    OutputStream out;
    OutputStreamWriter osw;
    Account account;
    IndexStore ixs;
    String textLine = "";
    int exportFileType;
    boolean overwritePreferences = false;
    boolean eofflag = false;
    boolean exportKeys = false;
    boolean isGroupingUsed = false;
    boolean syncMode = false;
    int runMode;
    int qifDateFormat = 0;
    int androidPaySuccess = 0;
    int androidPayEdit = 0;
    int alexaSuccess = 0;
    int alexaEdit = 0;
    int syncImport = 0;
    int syncExport = 0;
    int syncDuplicates = 0;
    int syncToCheckManually = 0;
    long lastExportedFromDate = 0L;
    String lastExportedAccount = "";
    boolean exportOpeningBalance = false;
    boolean includeTransfers = false;
    boolean separateSplits = false;
    boolean useSlashForYear = true;
    boolean useUTF8 = false;
    long hoursOffset = 0L;
    String label;
    boolean isBackup = false;
    boolean isJabpSyncDownloaded = false;
    boolean isJabpLiteSyncDownloaded = false;
    boolean isJabpSyncUploaded = false;
    boolean isJabpLiteSyncUploaded = false;
    boolean isGooglePaySyncDownloaded = false;
    boolean isGooglePaySyncFinished = false;
    int exportType = 0;
    int numberOfOptions;
    int selectedOption;
    long selectedFromDate;
    long selectedToDate;
    boolean isTransactionReport = true;
    boolean useAllAccounts = true;
    String selectedAccount = "";
    Thread thread;

    public ImportExportForm(Jabp context, boolean inflate) {
        this.parent = context;
        this.cal = Calendar.getInstance();
        this.genericDate = this.cal.getTime();
        this.todayDate = this.cal.getTime();
        this.todayDays = Utilities.longToDays(this.todayDate.getTime());
        this.getRoot();
        this.parent.previousPassword = this.parent.password;
        this.selectedOption = 0;
    }

    public void start() {
        this.parent.lastUsedScreen = 7;
        this.parent.lastUsedView = 7;
        if (!this.parent.password.equals("") && !this.parent.previousPassword.equals(this.parent.password)) {
            this.parent.checkPassword();
            return;
        }
        if (this.parent.getComponentCount() > 0) {
            for (int i = 0; i < this.parent.getComponentCount(); ++i) {
                this.parent.getComponent(i).setVisible(false);
            }
        }
        this.closeAllOpenViews();
        final DialogManager dm = new DialogManager(this.parent, "Import/Export Menu");
        this.numberOfOptions = 6;
        if (this.parent.copyToDropbox && !this.parent.hasDropboxToken()) {
            ++this.numberOfOptions;
        }
        final JList optionsJList = dm.addJList("Option", this.numberOfOptions, false);
        optionsJList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 1) {
                    int i = optionsJList.getHeight() / ImportExportForm.this.numberOfOptions;
                    ImportExportForm.this.selectedOption = me.getPoint().y / i;
                    dm.dispatchEvent(new WindowEvent(dm, 201));
                    dm.dispose();
                }
            }
        });
        optionsJList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    dm.dispatchEvent(new WindowEvent(dm, 201));
                    dm.dispose();
                    ImportExportForm.this.parent.onBackPressed();
                    return;
                }
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        dm.addJListItem(optionsJList, "Home");
        dm.addJListItem(optionsJList, "Import/Export QIF/OFX/CSV");
        dm.addJListItem(optionsJList, "Import data - keep Preferences");
        dm.addJListItem(optionsJList, "Import data - overwrite Preferences");
        dm.addJListItem(optionsJList, "Export data");
        dm.addJListItem(optionsJList, "Set directory");
        if (this.parent.copyToDropbox && !this.parent.hasDropboxToken()) {
            dm.addJListItem(optionsJList, "Login to Dropbox");
        }
        dm.centerShow();
        dm.dispose();
        switch (this.selectedOption) {
            case 0: {
                if (this.parent.av == null) {
                    this.parent.av = new AccountView(this.parent);
                }
                this.parent.av.resetDisplay();
                this.parent.setContentView(this.parent.av);
                return;
            }
            case 1: {
                new ExportQifOptionsForm(this.parent);
                return;
            }
            case 2: {
                this.overwritePreferences = false;
                this.parent.spf = new ShowProgressForm(this.parent, 2);
                this.parent.setContentView(this.parent.spf);
                if (this.parent.copyToDropbox) {
                    if (this.parent.useBackupEncryption) {
                        this.dropboxDownloadFile("JabpLite.dat#");
                    } else {
                        this.dropboxDownloadFile("JabpLite.dat");
                    }
                } else {
                    this.runMode = 4;
                    this.runThread();
                }
                return;
            }
            case 3: {
                this.overwritePreferences = true;
                this.parent.spf = new ShowProgressForm(this.parent, 2);
                this.parent.setContentView(this.parent.spf);
                if (this.parent.copyToDropbox) {
                    if (this.parent.useBackupEncryption) {
                        this.dropboxDownloadFile("JabpLite.dat#");
                    } else {
                        this.dropboxDownloadFile("JabpLite.dat");
                    }
                } else {
                    this.runMode = 4;
                    this.runThread();
                }
                return;
            }
            case 4: {
                this.parent.spf = new ShowProgressForm(this.parent, 2);
                this.parent.setContentView(this.parent.spf);
                this.runMode = 3;
                this.runThread();
                return;
            }
            case 5: {
                Toast.makeText(this.parent, "Please wait while file list is built", 1000).show();
                new SetDirectoryForm(this.parent);
                this.start();
                return;
            }
            case 6: {
                this.parent.authoriseDropbox();
            }
        }
    }

    void runThread() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        this.parent.busyWithProcess = true;
        if (this.runMode == 2) {
            this.processExport2();
        }
        if (this.runMode == 3) {
            this.exportData(false);
        }
        if (this.runMode == 4) {
            this.importData();
        }
        if (this.runMode == 10) {
            this.syncWithDropbox();
        }
        this.parent.busyWithProcess = false;
    }

    void syncWithDropbox() {
        this.syncToCheckManually = 0;
        this.syncDuplicates = 0;
        this.syncExport = 0;
        this.syncImport = 0;
        this.createEmptySyncFilesIfNeeded();
        if (this.checkJabpLite()) {
            this.syncData2(false, true);
        } else if (this.parent.sync != null && this.parent.sync.getNumSyncRecords() > 0) {
            this.syncData2(false, true);
        }
        String messageString = "";
        if (this.syncImport > 0 || this.syncExport > 0) {
            messageString = messageString + "Sync: imported " + this.syncImport + ", exported " + this.syncExport;
        }
        if (this.syncDuplicates == 1) {
            messageString = messageString + "\nSync: 1 duplicate ignored";
        }
        if (this.syncDuplicates > 1) {
            messageString = messageString + "\nSync: " + this.syncDuplicates + " duplicates ignored";
        }
        if (this.syncToCheckManually == 1) {
            messageString = messageString + "\nSync: 1 pending manual check";
        }
        if (this.syncToCheckManually > 1) {
            messageString = messageString + "\nSync: " + this.syncToCheckManually + " pending manual check";
        }
        if (messageString.equals("")) {
            messageString = "There is nothing to synchronise";
        }
        this.show(messageString);
        if (this.syncImport > 0 || this.syncExport > 0 || this.syncDuplicates > 0 || this.syncToCheckManually > 0) {
            this.dropboxUploadFile(new File(this.root + this.directory + "Jabp.sync"));
            this.dropboxUploadFile(new File(this.root + this.directory + "JabpLite.sync"));
        } else {
            this.showDoneButton();
        }
    }

    void syncGooglePayWithDropbox() {
        if (this.isGooglePaySyncDownloaded) {
            File file = new File(this.root + this.directory + "gpaydb.sync");
            if (file.length() > 0L) {
                this.show("Found pending transaction(s) from another device");
                this.fc3 = new File(this.root + this.directory + "googlepay.sync");
                this.copyFileUsingStream(file, this.fc3, true);
                this.writeEmptyFile(file);
                this.dropboxUploadFile(file);
            } else {
                this.isGooglePaySyncFinished = true;
                this.show("No pending transactions from another device");
                this.showDoneButton();
            }
        } else if (!this.parent.checkPendingTransactions()) {
            Toast.makeText(this.parent, "No pending transactions to process", 2000).show();
            this.parent.setContentView(this.parent.av);
        }
    }

    boolean processPendingTransactions() {
        this.alexaEdit = 0;
        this.alexaSuccess = 0;
        if (this.checkAlexa()) {
            this.syncAlexa(false);
            this.deleteAlexa();
        }
        this.androidPayEdit = 0;
        this.androidPaySuccess = 0;
        if (this.checkAndroidPay()) {
            this.syncAndroidPay();
            this.deleteAndroidPay();
        }
        if (this.parent.pendingTransactions != null) {
            this.parent.ptf = new PendingTransactionForm(this.parent);
            return true;
        }
        return false;
    }

    boolean checkJabpLite() {
        if (!this.parent.syncMode) {
            return false;
        }
        this.getRoot();
        this.fc = new File(this.root + this.directory + "JabpLite.sync");
        return this.fc.exists() && this.fc.length() > 0L;
    }

    boolean checkAndroidPay() {
        this.fc3 = new File(this.root + this.directory + "googlepay.sync");
        if (!this.fc3.exists()) {
            return false;
        }
        return this.fc3.length() > 0L;
    }

    boolean openAndroidPay() {
        try {
            this.dis = new DataInputStream(new FileInputStream(this.fc3));
            return true;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
    }

    void deleteAndroidPay() {
        if (!this.fc3.exists()) {
            return;
        }
        try {
            this.dis.close();
            this.fc3.delete();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.writeEmptyFile(this.fc3);
    }

    byte[] getNextAndroidPayRecord() {
        String s = "";
        try {
            int n = this.dis.readInt();
            byte[] bytes = new byte[n];
            this.dis.read(bytes, 0, n);
            Encrypt.encrypt(bytes);
            return bytes;
        }
        catch (IOException ie) {
            return null;
        }
    }

    void syncAndroidPay() {
        this.closeAllOpenViews();
        this.syncAndroidPay2();
    }

    void syncAndroidPay2() {
        byte[] bytes;
        if (!this.openAndroidPay()) {
            Toast.makeText(this.parent, "Could not open gpaydb.sync", 2000).show();
            return;
        }
        String cardNumber = "";
        String account = "";
        String description = "";
        String currencySymbol = "";
        String sAmount = "";
        int gPaySource = 2;
        AccountStore as = null;
        as = this.parent.av == null ? new AccountStore(this.parent, true) : this.parent.av.as;
        if (this.parent.tv != null) {
            this.parent.tv.ts.closeTransactionStore();
            this.parent.tv.rs.closeRegularStore();
            this.parent.tv = null;
        }
        TransactionStore ts = new TransactionStore(this.parent, new Account(), true);
        CurrencyStore ccys = null;
        ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
        while ((bytes = this.getNextAndroidPayRecord()) != null) {
            int i;
            long longDate;
            try {
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
                longDate = dis.readLong();
                cardNumber = dis.readUTF();
                account = dis.readUTF();
                description = dis.readUTF();
                currencySymbol = dis.readUTF();
                sAmount = dis.readUTF();
                gPaySource = dis.readInt();
                dis.close();
            }
            catch (IOException ie) {
                break;
            }
            Transaction t1 = new Transaction();
            String validAccountName = "";
            account = account.toLowerCase();
            Account a = null;
            int n = as.getNumAccounts();
            for (int i2 = 0; i2 < n; ++i2) {
                a = as.getAccountFromIndex(i2);
                if (cardNumber.equals("")) {
                    if (!a.name.toLowerCase().contains(account) && !a.description.toLowerCase().contains(account)) continue;
                    validAccountName = a.name;
                    break;
                }
                if (!a.description.contains(cardNumber)) continue;
                validAccountName = a.name;
                break;
            }
            if (validAccountName.equals("")) continue;
            t1.account = validAccountName;
            this.parent.lastAccount = validAccountName;
            t1.amount = -Utilities.holdingToNumber(sAmount, 0);
            t1.description = description;
            t1.source = gPaySource;
            this.parent.matchedString = description.toUpperCase();
            if (this.parent.tv != null) {
                this.parent.tv.ts.closeTransactionStore();
                this.parent.tv.rs.closeRegularStore();
                this.parent.tv = null;
            }
            ts.getIndex(a);
            n = ts.getNumTransactions();
            int m = Math.min(n, this.parent.matchDescriptionNumber);
            boolean matchFlag = false;
            Transaction t2 = new Transaction();
            for (i = 0; i < m; ++i) {
                int k = i;
                if (!ts.normalSortOrder) {
                    k = n - 1 - i;
                }
                t2 = ts.getTransactionFromIndex(k);
                if (this.parent.matchedString.length() > t2.description.length() || !t2.description.toUpperCase().startsWith(this.parent.matchedString)) continue;
                matchFlag = true;
                break;
            }
            if (matchFlag) {
                t1.description = t2.description;
                t1.reference = t2.reference;
                t1.category = t2.category;
                if (t2.splitFlag) {
                    t1.category = "None";
                }
                if (t2.transferFlag) {
                    t1.category = "None";
                }
                t1.transferFlag = t2.transferFlag;
                t1.transferAccount = t2.transferAccount;
            }
            if (this.parent.reconcileGooglePayTransactionsJabpLite) {
                t1.reconciled = true;
            }
            t1.longDate = longDate;
            for (i = 0; i < ccys.getNumCurrencies(); ++i) {
                Currency ccy = ccys.getCurrencyFromIndex(i);
                if (!ccy.code.equals(currencySymbol) && !ccy.description.contains(currencySymbol)) continue;
                if (ccy.code.equals(this.parent.homeCurrency)) break;
                t1.reference = ccy.code + " " + Utilities.numberToString(Math.abs(t1.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
                t1.amount = Utilities.foreignToHome(t1.amount, ccy.rate);
                break;
            }
            if (t1.category.equals("")) {
                t1.category = "None";
                this.addPendingTransactionAndCheckForDuplicate(t1);
                this.parent.showMatchedCategories = "";
                this.parent.storeMatchedPosition = 0;
                this.parent.matchedString = "";
                ++this.androidPayEdit;
                continue;
            }
            if (this.checkForMatchedTransaction(t1, ts) > 0) {
                t1.source = -t1.source;
            }
            this.addPendingTransactionAndCheckForDuplicate(t1);
            if (t1.transferFlag) {
                t2 = new Transaction();
                t2.description = t1.description;
                t2.amount = -t1.amount;
                t2.reference = t1.reference;
                t2.longDate = t1.longDate;
                t2.account = t1.transferAccount;
                t2.transferAccount = t1.account;
                t2.transferFlag = true;
                t2.source = t1.source;
                a = as.getAccountFromName(t2.account);
                if (a.type.equals("Cash")) {
                    t2.reconciled = true;
                }
                this.addPendingTransactionAndCheckForDuplicate(t2);
            }
            this.parent.showMatchedCategories = "";
            this.parent.storeMatchedPosition = 0;
            this.parent.matchedString = "";
            ++this.androidPaySuccess;
        }
        if (this.parent.ccyv == null) {
            ccys.closeCurrencyStore();
            ccys = null;
        }
        ts.closeTransactionStoreWithoutSavingIndex();
        if (this.parent.av == null) {
            as.closeAccountStore();
            as = null;
        }
    }

    boolean checkAlexa() {
        this.fc2 = new File(this.internalRoot + this.directory + "alexa.sync");
        if (!this.fc2.exists()) {
            return false;
        }
        return this.fc2.length() > 0L;
    }

    boolean openAlexa() {
        try {
            FileInputStream in = new FileInputStream(this.fc2);
            this.isr2 = new InputStreamReader((InputStream)in, "UTF8");
            return true;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
    }

    void deleteAlexa() {
        if (!this.fc2.exists()) {
            return;
        }
        try {
            this.isr2.close();
            this.fc2.delete();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    String getNextAlexaString() {
        int b = 0;
        StringBuffer sb = new StringBuffer();
        while (true) {
            try {
                b = this.isr2.read();
            }
            catch (IOException ie) {
                System.out.println(ie);
            }
            if (b < 0) {
                return "";
            }
            char c = (char)b;
            if (c == '\r') continue;
            if (c == '\n') break;
            sb.append(c);
        }
        return sb.toString();
    }

    void syncAlexa(boolean isFinishing) {
        this.closeAllOpenViews();
        this.syncAlexa2(isFinishing);
    }

    void syncAlexa2(boolean isFinishing) {
        if (!this.openAlexa()) {
            Toast.makeText(this.parent, "Could not open alexa.sync", 2000).show();
            return;
        }
        String textLine;
        while (!(textLine = this.getNextAlexaString()).equals("")) {
            String alexaDate = textLine.substring(0, 10);
            textLine = textLine.substring(11);
            Transaction t1 = new Transaction();
            t1.source = 7;
            t1 = this.parent.parseVoiceInput(textLine, true);
            this.cal = Calendar.getInstance();
            this.cal.set(1, Utilities.holdingToNumber(alexaDate.substring(0, 4), 0));
            this.cal.set(2, Utilities.holdingToNumber(alexaDate.substring(5, 7), 0) - 1);
            this.cal.set(5, Utilities.holdingToNumber(alexaDate.substring(8, 10), 0));
            this.parent.genericDate = this.cal.getTime();
            t1.longDate = this.parent.genericDate.getTime();
            if (t1.category.equals("") && !t1.transferFlag) {
                t1.category = "None";
                t1.amount = -t1.amount;
                this.addPendingTransactionAndCheckForDuplicate(t1);
                this.parent.showMatchedCategories = "";
                this.parent.storeMatchedPosition = 0;
                this.parent.matchedString = "";
                ++this.alexaEdit;
                continue;
            }
            this.addPendingTransactionAndCheckForDuplicate(t1);
            if (t1.transferFlag) {
                Transaction t2 = new Transaction();
                t2.description = t1.description;
                t2.amount = -t1.amount;
                t2.reference = t1.reference;
                t2.longDate = t1.longDate;
                t2.account = t1.transferAccount;
                t2.transferAccount = t1.account;
                t2.transferFlag = true;
                t2.source = t1.source;
                AccountStore as = new AccountStore(this.parent, true);
                Account a = as.getAccountFromName(t2.account);
                t2.reconciled = a.type.equals("Cash");
                as.closeAccountStore();
                this.addPendingTransactionAndCheckForDuplicate(t2);
            }
            this.parent.showMatchedCategories = "";
            this.parent.storeMatchedPosition = 0;
            this.parent.matchedString = "";
            ++this.alexaSuccess;
        }
        return;
    }

    void addPendingTransactionAndCheckForDuplicate(Transaction t) {
        int n;
        if (this.parent.pendingTransactions == null) {
            this.parent.pendingTransactions = new Vector();
        }
        if ((n = this.parent.pendingTransactions.size()) == 0) {
            this.parent.pendingTransactions.addElement(t);
            return;
        }
        for (int i = 0; i < n; ++i) {
            Transaction t1 = (Transaction)this.parent.pendingTransactions.elementAt(i);
            if (!t1.account.equals(t.account) || t1.amount != t.amount || Utilities.longToDays(t1.longDate) != Utilities.longToDays(t.longDate)) continue;
            if (t.source <= 0) break;
            t.source = -t.source;
            break;
        }
        this.parent.pendingTransactions.addElement(t);
    }

    void syncData2(boolean isFinishing) {
        this.syncData2(isFinishing, false);
    }

    void syncData2(boolean isFinishing, boolean uploadToDropbox) {
        byte[] bytes;
        this.closeAllOpenViews();
        if (this.parent.sync != null) {
            this.parent.sync.closeSyncStore();
        }
        this.getRoot();
        try {
            this.fc = new File(this.root + this.directory + "JabpLite.sync");
            if (this.fc.exists()) {
                this.dis = new DataInputStream(new FileInputStream(this.fc));
                this.eofflag = false;
            } else {
                this.eofflag = true;
            }
        }
        catch (IOException ie) {
            Toast.makeText(this.parent, "Error opening JabpLite.sync", 2000).show();
            return;
        }
        catch (SecurityException se) {
            Toast.makeText(this.parent, "Security error opening JabpLite.sync", 2000).show();
            return;
        }
        AccountStore as = new AccountStore(this.parent, true);
        CategoryStore cs = new CategoryStore(this.parent, true);
        CurrencyStore ccys = new CurrencyStore(this.parent, true);
        InvestmentStore is = new InvestmentStore(this.parent, true);
        RegularStore rs = new RegularStore(this.parent, true);
        TransactionStore ts = new TransactionStore(this.parent, new Account(), true);
        StandingOrderStore sos = new StandingOrderStore(this.parent, true);
        PreferenceStore ps = new PreferenceStore(this.parent, true);
        if (!isFinishing) {
            this.show("Reading JabpLite.sync");
        }
        this.syncImport = 0;
        this.syncExport = 0;
        while (!this.eofflag) {
            Account a;
            Transaction t;
            Investment inv;
            Currency ccy1;
            Currency ccy;
            int k;
            Currency ccy2;
            int type = this.receiveNumber();
            if (this.eofflag) break;
            bytes = this.receiveRecord();
            bytes = Encrypt.encrypt(bytes);
            boolean b1 = true;
            if (type < 0) {
                b1 = false;
                type = -type;
            }
            if (type == 1) {
                Account a2 = as.fromByteArray(bytes);
                ccy2 = new Currency();
                ccy2.code = a2.currency;
                if (ccys.lookUpId(ccy2) == 0) {
                    a2.currency = this.parent.homeCurrency;
                }
                if (b1) {
                    as.saveNewAccount(a2);
                } else {
                    Account a1 = as.getAccountFromName(a2.name);
                    as.deleteAccount(a1);
                    k = as.lookUpIndex(a1);
                    as.deleteIndex(k);
                }
            }
            if (type == 2) {
                Category c = cs.fromByteArray(bytes);
                if (b1) {
                    cs.saveNewCategory(c);
                } else {
                    Category c1 = cs.getCategoryFromName(c.name);
                    cs.deleteCategory(c1);
                    int k2 = cs.lookUpIndex(c1);
                    cs.deleteIndex(k2);
                }
            }
            if (type == 3) {
                ccy = ccys.fromByteArray(bytes);
                if (b1) {
                    ccys.saveNewCurrency(ccy);
                } else {
                    ccy1 = ccys.getCurrencyFromName(ccy.code);
                    ccys.deleteCurrency(ccy1);
                    int k3 = ccys.lookUpIndex(ccy1);
                    ccys.deleteIndex(k3);
                }
            }
            if (type == 12) {
                ccy = ccys.fromByteArray(bytes);
                ccy1 = ccys.getCurrencyFromName(ccy.code);
                ccy1.oldRate = ccy1.rate;
                ccy1.rate = ccy.rate;
                ccys.saveExistingCurrency(ccy1);
            }
            if (type == 4) {
                inv = is.fromByteArray(bytes);
                ccy2 = new Currency();
                ccy2.code = inv.currency;
                if (ccys.lookUpId(ccy2) == 0) {
                    inv.currency = this.parent.homeCurrency;
                }
                if (b1) {
                    is.saveNewInvestment(inv);
                } else {
                    Investment inv1 = is.getInvestmentFromName(inv.name);
                    is.deleteInvestment(inv1);
                    k = is.lookUpIndex(inv1);
                    is.deleteIndex(k);
                }
            }
            if (type == 11) {
                inv = is.fromByteArray(bytes);
                Investment inv1 = is.getInvestmentFromName(inv.name);
                inv1.price = inv.price;
                inv1.priceLongDate = inv.priceLongDate;
                is.saveExistingInvestment(inv1);
            }
            if (type == 5) {
                Regular r = rs.fromByteArray(bytes);
                if (b1) {
                    rs.saveNewRegular(r);
                } else {
                    Regular r1 = rs.getRegularFromName(r.description);
                    rs.deleteRegular(r1);
                    int k4 = rs.lookUpIndex(r1);
                    rs.deleteIndex(k4);
                }
            }
            if (type == 6) {
                StandingOrder so = sos.fromByteArray(bytes);
                if (b1) {
                    sos.saveNewStandingOrder(so);
                } else {
                    StandingOrder so1 = sos.getStandingOrderFromName(so.description);
                    if (so1 != null) {
                        sos.deleteStandingOrder(so1);
                        sos.deleteIndex(so1);
                    }
                }
            }
            if (type == 7 || type == 8) {
                int isMatchedTransaction;
                t = ts.fromByteArray(bytes);
                a = new Account();
                a.name = t.account;
                ts.getIndex(a);
                if (b1 && type == 7 && (isMatchedTransaction = this.checkForMatchedTransaction(t, ts)) > 0) {
                    if (isMatchedTransaction == 2) {
                        ++this.syncDuplicates;
                    }
                    if (isMatchedTransaction != 1) continue;
                    t.source = -1;
                    this.addPendingTransactionAndCheckForDuplicate(t);
                    ++this.syncToCheckManually;
                    continue;
                }
                if (b1) {
                    t.longDate += this.hoursOffset;
                    t.id = ts.saveNewTransaction(t);
                    ts.setIndex(a);
                    if (type == 7) {
                        a = as.getAccountFromName(a.name);
                        a.updateBalance(t, null, this.parent.todayDays);
                        as.saveExistingAccount(a);
                        if (!t.transferFlag) {
                            if (t.splitFlag) {
                                for (int i = 0; i < t.ss.size(); ++i) {
                                    Split s = t.ss.getSplit(i);
                                    Category c = cs.getCategoryFromName(s.category);
                                    c.updateBalance(s, null);
                                    cs.saveExistingCategory(c);
                                }
                            } else {
                                Category c = cs.getCategoryFromName(t.category);
                                c.updateBalance(t, null);
                                cs.saveExistingCategory(c);
                            }
                        }
                    }
                } else {
                    Transaction t1 = this.getMatchedTransaction(t, ts);
                    if (t1 != null) {
                        if (type == 7) {
                            if (t1.splitFlag) {
                                for (int j = 0; j < t1.ss.size(); ++j) {
                                    Split s = t1.ss.getSplit(j);
                                    Category c = cs.getCategoryFromName(s.category);
                                    c.updateBalance(null, s);
                                    cs.saveExistingCategory(c);
                                }
                            } else if (!t1.transferFlag) {
                                Category c = cs.getCategoryFromName(t1.category);
                                c.updateBalance(null, t1);
                                cs.saveExistingCategory(c);
                            }
                        }
                        ts.deleteTransaction(t1);
                        ts.deleteIndex(t1);
                        ts.setIndex(a);
                        if (type == 7) {
                            a = as.getAccountFromName(a.name);
                            a.updateBalance(null, t1, this.parent.todayDays);
                            as.saveExistingAccount(a);
                        }
                    }
                }
            }
            if (type == 10) {
                t = ts.fromByteArray(bytes);
                a = new Account();
                a.name = t.account;
                ts.getIndex(a);
                Transaction t1 = this.getMatchedTransaction(t, ts);
                if (t1 != null) {
                    a = as.getAccountFromName(a.name);
                    a.updateBalance(t, null, this.parent.todayDays);
                    a.updateBalance(null, t1, this.parent.todayDays);
                    as.saveExistingAccount(a);
                    t1.reconciled = t.reconciled;
                    ts.saveExistingTransaction(t1);
                }
            }
            if (type == 9) {
                ps.fromByteArray(bytes);
            }
            ++this.syncImport;
            if (isFinishing || this.syncImport / 20 * 20 != this.syncImport) continue;
            this.show(this.syncImport + " records read");
        }
        try {
            if (this.fc.exists()) {
                this.dis.close();
            }
        }
        catch (IOException ie) {
            Toast.makeText(this.parent, "Error closing JabpLite.sync", 2000).show();
            return;
        }
        this.writeEmptyFile(this.fc);
        if (!isFinishing) {
            this.show("Writing Jabp.sync");
        }
        try {
            this.fc = new File(this.root + this.directory + "Jabp.sync");
            this.dos = this.fc.length() > 0L ? new DataOutputStream(new FileOutputStream(this.fc, true)) : new DataOutputStream(new FileOutputStream(this.fc));
        }
        catch (IOException ie) {
            Toast.makeText(this.parent, "Error opening Jabp.sync", 2000).show();
            return;
        }
        catch (SecurityException se) {
            Toast.makeText(this.parent, "Security error opening Jabp.sync", 2000).show();
            return;
        }
        this.parent.sync = new SyncStore(this.parent, true);
        while ((bytes = this.parent.sync.readNextSyncRecord()) != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStream dis = new DataInputStream(bais);
            try {
                int type = dis.readInt();
                int length = dis.readInt();
                byte[] b = new byte[length];
                dis.read(b, 0, length);
                dis.close();
                bais.close();
                Encrypt.encrypt(b);
                this.dos.writeInt(type);
                this.dos.writeInt(length);
                this.dos.write(b, 0, b.length);
            }
            catch (IOException ie) {
                Toast.makeText(this.parent, "Error writing Jabp.sync", 2000).show();
                return;
            }
            ++this.syncExport;
            if (isFinishing || this.syncExport / 20 * 20 != this.syncExport) continue;
            this.show(this.syncExport + " records written");
        }
        try {
            this.dos.close();
        }
        catch (IOException ie) {
            Toast.makeText(this.parent, "Error closing Jabp.sync", 2000).show();
            return;
        }
        this.parent.sync.closeSyncStore();
        as.closeAccountStore();
        cs.closeCategoryStore();
        ccys.closeCurrencyStore();
        is.closeInvestmentStore();
        rs.closeRegularStore();
        sos.closeStandingOrderStore();
        ts.closeTransactionStore();
        ps.closePreferenceStore();
        if (!uploadToDropbox) {
            this.parent.sync.deleteSyncStore();
            this.parent.sync = new SyncStore(this.parent, false);
            if (!isFinishing) {
                this.show("Finished");
            }
        }
    }

    int checkForMatchedTransaction(Transaction t, TransactionStore ts) {
        int result = 0;
        int n = ts.ht.size();
        for (int i = 0; i < n; ++i) {
            int k = i;
            if (!ts.normalSortOrder) {
                k = n - 1 - i;
            }
            Transaction t1 = ts.getTransactionFromIndex(k);
            if (Utilities.longToDays(t1.longDate) < Utilities.longToDays(t.longDate)) break;
            if (Utilities.longToDays(t1.longDate) != Utilities.longToDays(t.longDate) || t1.amount != t.amount) continue;
            if (t1.description.equals(t.description) && (t1.category.equals(t.category) || t1.transferFlag && t.transferFlag) && t1.reference.equals(t.reference)) {
                result = 2;
                break;
            }
            result = 1;
        }
        return result;
    }

    Transaction getMatchedTransaction(Transaction t, TransactionStore ts) {
        int n = ts.ht.size();
        for (int i = 0; i < n; ++i) {
            int k = i;
            if (!ts.normalSortOrder) {
                k = n - 1 - i;
            }
            Transaction t1 = ts.getTransactionFromIndex(k);
            if (Utilities.longToDays(t1.longDate) < Utilities.longToDays(t.longDate)) break;
            if (Utilities.longToDays(t1.longDate) != Utilities.longToDays(t.longDate) || t1.amount != t.amount || !t1.description.equals(t.description) || !t1.category.equals(t.category) && (!t1.transferFlag || !t.transferFlag) || !t1.reference.equals(t.reference)) continue;
            return t1;
        }
        return null;
    }

    boolean copyFileUsingStream(File source, File dest) {
        return this.copyFileUsingStream(source, dest, false);
    }

    boolean copyFileUsingStream(File source, File dest, boolean append) {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest, append);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)is).read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, length);
            }
            ((InputStream)is).close();
            ((OutputStream)os).close();
            return true;
        }
        catch (IOException e) {
            System.out.println("Error " + e.toString() + " copying " + source.toString() + " to " + dest.toString());
            return false;
        }
    }

    void writeSingleLongFile(File dest, long lastSyncUpdate) {
        try {
            DataOutputStream dos2 = new DataOutputStream(new FileOutputStream(dest));
            dos2.writeLong(lastSyncUpdate);
            dos2.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    boolean writeEmptyFile(File dest) {
        try {
            FileOutputStream os = new FileOutputStream(dest);
            ((OutputStream)os).close();
            return true;
        }
        catch (IOException e) {
            System.out.println("Error writng empty file: " + e.toString());
            return false;
        }
    }

    String setQIFDate(Date date, int dateType) {
        String sep1 = "/";
        String sep2 = "/";
        if (dateType == 2 || dateType == 3) {
            sep1 = ".";
            sep2 = ".";
        }
        if (!this.useSlashForYear) {
            sep2 = "'";
        }
        this.cal.setTime(date);
        String s0 = "" + this.cal.get(5);
        if (s0.length() < 2) {
            s0 = "0" + s0;
        }
        int i = this.cal.get(2) + 1;
        String s1 = "" + i;
        if (s1.length() < 2) {
            s1 = "0" + s1;
        }
        String s2 = ("" + this.cal.get(1)).substring(2, 4);
        if (dateType > 3) {
            s2 = "" + this.cal.get(1);
        }
        if (dateType == 6) {
            return s2 + "-" + s1 + "-" + s0;
        }
        if (dateType == 0 || dateType == 2 || dateType == 4) {
            return s0 + sep1 + s1 + sep2 + s2;
        }
        return s1 + sep1 + s0 + sep2 + s2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void importData() {
        byte[] bytes;
        int i;
        this.parent.previousPassword = this.parent.password;
        try {
            this.fc = new File(this.root + this.directory + "JabpLite.dat");
            this.fc1 = new File(this.root + this.directory + "JabpLite.dat#");
            if (this.fc1.exists()) {
                this.show("Encrypted backup file JabpLite.dat# found");
                if (this.parent.password.equals("")) {
                    this.show("Password not set, can't decrypt file");
                    this.show("Looking for unencrypted file JabpLite.dat");
                } else {
                    this.show("Decrypting backup file");
                    boolean result = Encrypt.decrypt(this.root, this.directory, this.parent.password);
                    if (!result) {
                        this.show("\nDecryption failed\nImport file password does not match current password");
                        this.showDoneButton();
                        return;
                    }
                    this.show("Decryption successful");
                }
            } else {
                this.show("JabpLite.dat# does not exist in this directory");
                this.show("Looking for unencrypted file JabpLite.dat");
            }
            if (!this.fc.exists()) {
                this.show("JabpLite.dat does not exist in this directory");
                this.showDoneButton();
                return;
            }
            this.dis = new DataInputStream(new FileInputStream(this.fc));
        }
        catch (IOException ie) {
            this.show("Error in importData: " + ie.toString());
            this.showDoneButton();
            return;
        }
        this.parent.accountHt = new Hashtable();
        this.parent.categoryHt = new Hashtable();
        this.parent.currencyHt = new Hashtable();
        this.parent.standingOrderHt = new Hashtable();
        this.parent.regularHt = new Hashtable();
        this.parent.investmentHt = new Hashtable();
        this.parent.transactionHt = new Hashtable();
        this.show("Deleting previous data");
        if (this.parent.syncMode) {
            this.parent.sync.closeSyncStore();
        }
        RecordStore.deleteRecordStore(this.parent, "Accounts");
        RecordStore.deleteRecordStore(this.parent, "Categories");
        RecordStore.deleteRecordStore(this.parent, "StandingOrders");
        RecordStore.deleteRecordStore(this.parent, "Investments");
        RecordStore.deleteRecordStore(this.parent, "Currencies");
        RecordStore.deleteRecordStore(this.parent, "Regulars");
        RecordStore.deleteRecordStore(this.parent, "Transactions");
        RecordStore.deleteRecordStore(this.parent, "JabpSync");
        this.show("Started importing data");
        AccountStore as = new AccountStore(this.parent, true);
        CategoryStore cs = new CategoryStore(this.parent, true);
        CurrencyStore ccys = new CurrencyStore(this.parent, true);
        StandingOrderStore sos = new StandingOrderStore(this.parent, true);
        RegularStore rs = new RegularStore(this.parent, true);
        InvestmentStore is = new InvestmentStore(this.parent, true);
        TransactionStore ts = new TransactionStore(this.parent, new Account(), true);
        this.show("Loading Accounts");
        int n = this.receiveNumber();
        for (i = 0; i < n; ++i) {
            bytes = this.receiveRecord();
            Account a = as.fromByteArray(bytes);
            as.saveNewAccount(a);
        }
        this.show("Loading Categories");
        n = this.receiveNumber();
        for (i = 0; i < n; ++i) {
            bytes = this.receiveRecord();
            Category c = cs.fromByteArray(bytes);
            cs.saveNewCategory(c);
        }
        this.show("Loading Currencies");
        n = this.receiveNumber();
        for (i = 0; i < n; ++i) {
            bytes = this.receiveRecord();
            Currency ccy = ccys.fromByteArray(bytes);
            ccys.saveNewCurrency(ccy);
        }
        this.show("Loading Standing Orders");
        n = this.receiveNumber();
        for (i = 0; i < n; so.longProcessingDate += this.hoursOffset, so.longStartDate += this.hoursOffset, so.longEndDate += this.hoursOffset, ++i) {
            bytes = this.receiveRecord();
            StandingOrder so = sos.fromByteArray(bytes);
            sos.saveNewStandingOrder(so);
        }
        this.show("Loading Regulars");
        n = this.receiveNumber();
        for (i = 0; i < n; ++i) {
            bytes = this.receiveRecord();
            Regular r = rs.fromByteArray(bytes);
            rs.saveNewRegular(r);
        }
        this.show("Loading Investments");
        n = this.receiveNumber();
        for (i = 0; i < n; inv.priceLongDate += this.hoursOffset, ++i) {
            bytes = this.receiveRecord();
            Investment inv = is.fromByteArray(bytes);
            is.saveNewInvestment(inv);
        }
        this.show("Loading Transactions");
        n = this.receiveNumber();
        Account a1 = new Account();
        for (int i2 = 0; i2 < n; ++i2) {
            bytes = this.receiveRecord();
            Transaction t = ts.fromByteArray(bytes);
            t.longDate += this.hoursOffset;
            if (!a1.name.equals(t.account)) {
                ts.setIndex(a1);
                a1.name = t.account;
                ts.getIndex(a1);
            }
            ts.saveNewTransaction(t);
            int j = i2 + 1;
            if (j != j / 1000 * 1000) continue;
            this.show(j + " transactions");
        }
        ts.setIndex(a1);
        boolean previousSortOrder = this.parent.normalSortOrder;
        boolean previousUseBackupEncryption = this.parent.useBackupEncryption;
        this.show("Loading Preferences");
        PreferenceStore ps = new PreferenceStore(this.parent, true);
        ps.getPreferences();
        bytes = this.receiveRecord();
        if (this.overwritePreferences) {
            ps.fromByteArray(bytes);
            ps.copyJabpLiteToJabp4();
            this.show("Current Preferences overwritten");
        } else {
            ps.getPasswordOnly(bytes);
            this.show("Current Preferences maintained");
        }
        ps.savePreferences();
        ps.closePreferenceStore();
        ps = null;
        this.parent.useBackupEncryption = previousUseBackupEncryption;
        this.parent.setGlobalFontHeight();
        if (this.parent.syncMode) {
            this.parent.sync = new SyncStore(this.parent, false);
        }
        if (previousSortOrder != this.parent.normalSortOrder) {
            int numItems = as.ht.size();
            for (int j = 0; j < numItems; ++j) {
                int i3;
                a1 = as.getAccountFromIndex(j);
                Hashtable ht = (Hashtable)this.parent.transactionHt.get(a1.name);
                n = ht.size();
                Vector<LongId> v = new Vector<LongId>(n);
                for (i3 = 0; i3 < n; ++i3) {
                    v.addElement((LongId)ht.get(new Integer(i3)));
                }
                Sort.sortLongId(v, 0, n - 1, this.parent.normalSortOrder);
                for (i3 = 0; i3 < n; ++i3) {
                    ht.put(new Integer(i3), v.elementAt(i3));
                }
                v = null;
                this.parent.transactionHt.put(a1.name, ht);
                ht = null;
            }
        }
        try {
            this.dis.close();
            if (this.parent.useBackupEncryption && !this.parent.password.equals("") && this.fc != null && this.fc.exists()) {
                this.fc.delete();
            }
        }
        catch (IOException ie) {
            this.show("Error in importData: " + ie.toString());
            this.showDoneButton();
            return;
        }
        ts.closeTransactionStore();
        ts = null;
        is.closeInvestmentStore();
        is = null;
        rs.closeRegularStore();
        rs = null;
        sos.closeStandingOrderStore();
        sos = null;
        ccys.closeCurrencyStore();
        ccys = null;
        cs.closeCategoryStore();
        cs = null;
        as.closeAccountStore();
        as = null;
        this.show("Finished importing data");
        this.showDoneButton();
    }

    void exportData(boolean isFinishing) {
        File f = new File(this.root + this.directory);
        this.show("Started exporting data");
        try {
            this.fc = new File(this.root + this.directory + "JabpLite.tmp");
            if (this.fc.exists()) {
                this.fc.delete();
            }
            this.dos = new DataOutputStream(new FileOutputStream(this.fc));
        }
        catch (IOException ie) {
            this.show("Error 1 in exportData: " + ie.toString());
            this.showDoneButton();
            return;
        }
        this.show("Saving Accounts");
        AccountStore as = new AccountStore(this.parent, true);
        int n = as.getNumAccounts();
        this.sendNumber(n);
        for (int i = 0; i < n; ++i) {
            Account a = as.getAccountFromIndex(i);
            this.sendRecord(as.toByteArray(a));
        }
        this.show("Saving Categories");
        CategoryStore cs = new CategoryStore(this.parent, true);
        n = cs.getNumCategories();
        this.sendNumber(n);
        for (int i = 0; i < n; ++i) {
            Category c = cs.getCategoryFromIndex(i);
            this.sendRecord(cs.toByteArray(c));
        }
        cs.closeCategoryStore();
        cs = null;
        this.show("Saving Currencies");
        CurrencyStore ccys = new CurrencyStore(this.parent, true);
        n = ccys.getNumCurrencies();
        this.sendNumber(n);
        for (int i = 0; i < n; ++i) {
            Currency ccy = ccys.getCurrencyFromIndex(i);
            this.sendRecord(ccys.toByteArray(ccy));
        }
        ccys.closeCurrencyStore();
        ccys = null;
        this.show("Saving Standing Orders");
        StandingOrderStore sos = new StandingOrderStore(this.parent, true);
        n = sos.getNumStandingOrders();
        this.sendNumber(n);
        for (int i = 0; i < n; ++i) {
            StandingOrder so = sos.getStandingOrderFromIndex(i);
            this.sendRecord(sos.toByteArray(so));
        }
        sos.closeStandingOrderStore();
        sos = null;
        this.show("Saving Regulars");
        RegularStore rs = new RegularStore(this.parent, true);
        n = rs.getNumRegulars();
        this.sendNumber(n);
        for (int i = 0; i < n; ++i) {
            Regular r = rs.getRegularFromIndex(i);
            this.sendRecord(rs.toByteArray(r));
        }
        rs.closeRegularStore();
        rs = null;
        this.show("Saving Investments");
        InvestmentStore is = new InvestmentStore(this.parent, true);
        n = is.getNumInvestments();
        this.sendNumber(n);
        for (int i = 0; i < n; ++i) {
            Investment inv = is.getInvestmentFromIndex(i);
            this.sendRecord(is.toByteArray(inv));
        }
        is.closeInvestmentStore();
        is = null;
        this.show("Saving Transactions");
        TransactionStore ts = new TransactionStore(this.parent, new Account(), true);
        this.sendNumber(ts.getNumAllTransactions());
        int count = 0;
        n = as.getNumAccounts();
        for (int i = 0; i < n; ++i) {
            Account a = as.getAccountFromIndex(i);
            ts.getIndex(a);
            int m = ts.getNumTransactions();
            for (int j = 0; j < m; ++j) {
                Transaction t = ts.getTransactionFromIndex(j);
                this.sendRecord(ts.toByteArray(t));
                if (++count != count / 1000 * 1000) continue;
                this.show(count + " transactions");
            }
        }
        ts.closeTransactionStore();
        ts = null;
        as.closeAccountStore();
        as = null;
        this.show("Saving Preferences");
        PreferenceStore ps = new PreferenceStore(this.parent, true);
        ps.copyJabp4ToJabpLite();
        boolean exportIsOk = this.sendRecord(ps.toByteArray());
        ps.closePreferenceStore();
        ps = null;
        if (!exportIsOk) {
            this.show("There were errors exporting the data");
            this.show("Incomplete data will be in JabpLite.tmp");
            this.runMode = 0;
            this.showDoneButton();
            return;
        }
        try {
            this.dos.close();
            this.fc1 = new File(this.root + this.directory + "JabpLite_older.dat");
            if (this.fc1.exists()) {
                this.fc1.delete();
            }
            this.fc1 = new File(this.root + this.directory + "JabpLite_old.dat");
            if (this.fc1.exists()) {
                this.fc1.renameTo(new File(this.root + this.directory + "JabpLite_older.dat"));
            }
            this.fc1 = new File(this.root + this.directory + "JabpLite_old.dat");
            if (this.fc1.exists()) {
                this.fc1.delete();
            }
            this.fc1 = new File(this.root + this.directory + "JabpLite.dat");
            if (this.fc1.exists()) {
                this.fc1.renameTo(new File(this.root + this.directory + "JabpLite_old.dat"));
            }
            this.fc.renameTo(new File(this.root + this.directory + "JabpLite.dat"));
            if (this.parent.password.equals("")) {
                this.parent.useBackupEncryption = false;
            }
            if (this.parent.useBackupEncryption) {
                this.fc1 = new File(this.root + this.directory + "JabpLite_older.dat#");
                if (this.fc1.exists()) {
                    this.fc1.delete();
                }
                this.fc1 = new File(this.root + this.directory + "JabpLite_old.dat#");
                if (this.fc1.exists()) {
                    this.fc1.renameTo(new File(this.root + this.directory + "JabpLite_older.dat#"));
                }
                this.fc1 = new File(this.root + this.directory + "JabpLite_old.dat#");
                if (this.fc1.exists()) {
                    this.fc1.delete();
                }
                this.fc1 = new File(this.root + this.directory + "JabpLite.dat#");
                if (this.fc1.exists()) {
                    this.fc1.renameTo(new File(this.root + this.directory + "JabpLite_old.dat#"));
                }
                this.show("Encrypting backup file");
                boolean result = Encrypt.encrypt(this.root, this.directory, this.parent.password);
                if (result) {
                    this.show("Encryption successful");
                } else {
                    this.show("Encryption failed");
                    this.showDoneButton();
                    return;
                }
            }
            if (!isFinishing) {
                if (this.parent.copyToDropbox && !this.parent.hasDropboxToken()) {
                    this.show("Didn't upload to Dropbox: login required");
                }
                if (this.parent.copyToDropbox && this.parent.hasDropboxToken()) {
                    this.fc1 = new File(this.root + this.directory + "JabpLite.dat#");
                    if (this.fc1.exists()) {
                        this.dropboxUploadFile(this.fc1);
                    } else {
                        this.fc1 = new File(this.root + this.directory + "JabpLite.dat");
                        if (this.fc1.exists()) {
                            this.dropboxUploadFile(this.fc1);
                        }
                    }
                }
            }
        }
        catch (IOException ie) {
            this.show("Error in exportData: " + ie.toString());
            this.showDoneButton();
            return;
        }
        if (!this.parent.copyToDropbox) {
            this.show("Finished exporting data");
            this.runMode = 0;
            this.showDoneButton();
        }
    }

    void processExport() {
        this.parent.spf = new ShowProgressForm(this.parent, 2);
        this.parent.setContentView(this.parent.spf);
        this.runMode = 2;
        this.run();
    }

    void processExport2() {
        if (this.exportType == 0 && !this.isTransactionReport) {
            this.exportType = 1;
        }
        this.lastExportedFromDate = this.selectedFromDate;
        AccountStore as = new AccountStore(this.parent, true);
        int n = as.getNumAccounts();
        Vector<Account> v = new Vector<Account>(n);
        for (int i = 0; i < n; ++i) {
            this.account = as.getAccountFromIndex(i);
            v.addElement(this.account);
            if (!this.account.name.equals(this.selectedAccount)) continue;
            this.selectedOption = i;
        }
        as.closeAccountStore();
        if (this.useAllAccounts) {
            if (this.isTransactionReport) {
                if (this.exportType == 0) {
                    for (int j = 0; j < n; ++j) {
                        this.account = (Account)v.elementAt(j);
                        this.exportQIF(this.account, new Date(this.selectedFromDate), new Date(this.selectedToDate));
                    }
                } else {
                    this.exportCSV(new Account(), new Date(this.selectedFromDate), new Date(this.selectedToDate), this.exportType, true);
                }
            } else {
                this.exportIncomeExpenseReport(null, new Date(this.selectedFromDate), new Date(this.selectedToDate), this.qifDateFormat, this.exportType, true);
            }
        } else {
            this.account = (Account)v.elementAt(this.selectedOption);
            this.lastExportedAccount = this.account.name;
            if (this.label.equals("Export")) {
                if (this.isTransactionReport) {
                    if (this.exportType == 0) {
                        this.exportQIF(this.account, new Date(this.selectedFromDate), new Date(this.selectedToDate));
                    } else {
                        this.exportCSV(this.account, new Date(this.selectedFromDate), new Date(this.selectedToDate), this.exportType, false);
                    }
                } else {
                    this.exportIncomeExpenseReport(this.account, new Date(this.selectedFromDate), new Date(this.selectedToDate), this.qifDateFormat, this.exportType, false);
                }
            }
            if (this.label.equals("Import")) {
                if (this.exportType == 0) {
                    this.importQIF(this.account.name);
                } else {
                    this.importOFX(this.account.name);
                }
            }
        }
        v = null;
        this.showDoneButton();
    }

    void closeAllOpenViews() {
        if (this.parent.av != null) {
            this.parent.av.as.closeAccountStore();
            this.parent.av = null;
        }
        if (this.parent.cv != null) {
            this.parent.cv.cs.closeCategoryStore();
            this.parent.cv = null;
        }
        if (this.parent.ccyv != null) {
            this.parent.ccyv.ccys.closeCurrencyStore();
            this.parent.ccyv = null;
        }
        if (this.parent.sov != null) {
            this.parent.sov.sos.closeStandingOrderStore();
            this.parent.sov = null;
        }
        if (this.parent.iv != null) {
            this.parent.iv.is.closeInvestmentStore();
            this.parent.iv = null;
        }
        if (this.parent.tv != null) {
            this.parent.tv.ts.closeTransactionStore();
            this.parent.tv.rs.closeRegularStore();
            this.parent.tv = null;
        }
    }

    void backupData(boolean isFinishing) {
        this.isBackup = true;
        this.exportKeys = false;
        this.closeAllOpenViews();
        this.getRoot();
        this.exportData(isFinishing);
        this.saveDirectory();
    }

    void importQIF(String name) {
        String textLine;
        int count;
        int dateType;
        block49: {
            if (name.equals("")) {
                return;
            }
            dateType = this.qifDateFormat;
            count = 0;
            this.eofflag = false;
            this.show("Importing " + name);
            try {
                this.fc = new File(this.root + this.directory + name + ".qif");
                if (!this.fc.exists()) {
                    this.show("QIF file does not exist");
                    this.showDoneButton();
                    return;
                }
                FileInputStream in = new FileInputStream(this.fc);
                try {
                    if (this.useUTF8) {
                        this.isr = new InputStreamReader((InputStream)in, "UTF8");
                        break block49;
                    }
                    this.isr = new InputStreamReader(in);
                }
                catch (UnsupportedEncodingException uee) {
                    System.out.println("UTF8 not supported");
                    this.isr = new InputStreamReader(in);
                }
            }
            catch (IOException ie) {
                this.show("Error in importQIF: " + ie.toString());
                this.showDoneButton();
                return;
            }
        }
        AccountStore as = new AccountStore(this.parent, true);
        Account a = as.getAccountFromName(name);
        CategoryStore cs = new CategoryStore(this.parent, true);
        TransactionStore ts = new TransactionStore(this.parent, a, true);
        CurrencyStore ccys = new CurrencyStore(this.parent, true);
        Currency ccy = ccys.getCurrencyFromName(a.currency);
        ccys.closeCurrencyStore();
        ccys = null;
        do {
            textLine = this.receiveText();
            if (!this.eofflag) continue;
            return;
        } while (textLine.length() <= 0);
        if (textLine.indexOf("!") < 0) {
            return;
        }
        while (true) {
            Transaction t = new Transaction();
            t.account = a.name;
            Split split = new Split();
            boolean splitflagamount = false;
            boolean splitflagdescription = false;
            boolean splitflagcategory = false;
            while (true) {
                Account a1;
                textLine = this.receiveText();
                if (this.eofflag) break;
                if (textLine.length() == 0) continue;
                String s = textLine.substring(0, 1);
                String s1 = textLine.substring(1, textLine.length());
                if (s.equals("^")) break;
                if (s.equals("P")) {
                    t.description = s1;
                }
                if (s.equals("M")) {
                    t.reference = s1;
                }
                if (s.equals("T")) {
                    t.amount = Utilities.stringToNumber(s1, 0, false, this.parent.isEuropeanNumberFormat);
                }
                if (s.equals("L")) {
                    if (s1.startsWith("[")) {
                        a1 = as.getAccountFromName(s1.substring(1, s1.length() - 1));
                        t.transferAccount = a1.name;
                        t.transferFlag = true;
                    } else {
                        t.category = cs.getCategoryFromName((String)s1).name;
                    }
                }
                if (s.equals("D")) {
                    int p1 = 0;
                    int p2 = 0;
                    String s1a = "";
                    String s1b = "";
                    s1 = s1.replace(' ', '0');
                    s1 = s1.replace('.', '/');
                    if (dateType < 6) {
                        p1 = s1.indexOf("/");
                        p2 = this.lastIndexOf(s1, "'");
                        if (p2 == -1) {
                            p2 = this.lastIndexOf(s1, "/");
                        }
                        if (p1 == -1 || p2 == -1 || p1 == p2) {
                            this.show("Bad date in import file: " + s1);
                            this.showDoneButton();
                            return;
                        }
                        s1a = s1.substring(0, p1);
                        if (p1 == 1) {
                            s1a = "0" + s1.substring(0, p1);
                        }
                        s1b = s1.substring(p1 + 1, p2);
                        if (p2 - p1 == 2) {
                            s1b = "0" + s1.substring(p1 + 1, p2);
                        }
                    }
                    if (dateType < 4) {
                        s1 = s1a + "/" + s1b + "/" + s1.substring(p2 + 1, p2 + 3);
                    }
                    if (dateType > 3 && dateType < 6) {
                        s1 = s1a + "/" + s1b + "/" + s1.substring(p2 + 1, p2 + 5);
                    }
                    if (dateType == 6) {
                        // empty if block
                    }
                    if (dateType == 0 || dateType == 2) {
                        this.cal.set(5, this.getInt(s1.substring(0, 2)));
                        this.cal.set(2, this.getInt(s1.substring(3, 5)) - 1);
                        this.cal.set(1, this.getInt("20" + s1.substring(6, 8)));
                    }
                    if (dateType == 1 || dateType == 3) {
                        this.cal.set(2, this.getInt(s1.substring(0, 2)) - 1);
                        this.cal.set(5, this.getInt(s1.substring(3, 5)));
                        this.cal.set(1, this.getInt("20" + s1.substring(6, 8)));
                    }
                    if (dateType == 4) {
                        this.cal.set(5, this.getInt(s1.substring(0, 2)));
                        this.cal.set(2, this.getInt(s1.substring(3, 5)) - 1);
                        this.cal.set(1, this.getInt(s1.substring(6, 10)));
                    }
                    if (dateType == 5) {
                        this.cal.set(2, this.getInt(s1.substring(0, 2)) - 1);
                        this.cal.set(5, this.getInt(s1.substring(3, 5)));
                        this.cal.set(1, this.getInt(s1.substring(6, 10)));
                    }
                    if (dateType == 6) {
                        this.cal.set(1, this.getInt(s1.substring(0, 4)));
                        this.cal.set(2, this.getInt(s1.substring(5, 7)) - 1);
                        this.cal.set(5, this.getInt(s1.substring(8, 10)));
                    }
                    t.longDate = this.cal.getTime().getTime();
                }
                if (s.equals("C") && !s1.equals("")) {
                    t.reconciled = true;
                }
                if (s.equals("S")) {
                    if (s1.startsWith("[")) {
                        a1 = as.getAccountFromName(s1.substring(1, s1.length() - 1));
                        split.category = cs.getCategoryFromName((String)"SplitTransfer").name;
                    } else {
                        split.category = cs.getCategoryFromName((String)s1).name;
                    }
                    splitflagcategory = true;
                }
                if (s.equals("E")) {
                    splitflagdescription = true;
                }
                if (s.equals("$")) {
                    split.amount = Utilities.stringToNumber(s1, 0, false, this.parent.isEuropeanNumberFormat);
                    splitflagamount = true;
                }
                if (!splitflagcategory || !splitflagdescription || !splitflagamount) continue;
                t.splitFlag = true;
                if (t.ss == null) {
                    t.ss = new SplitStore();
                }
                t.ss.addSplit(split);
                split = new Split();
                splitflagamount = false;
                splitflagdescription = false;
                splitflagcategory = false;
            }
            if (this.eofflag) break;
            if (!a.currency.equals(this.parent.homeCurrency)) {
                t.reference = t.reference.equals("") ? a.currency + " " + Utilities.numberToString(Math.abs(t.amount), false, this.parent.isEuropeanNumberFormat, this.isGroupingUsed) : a.currency + " " + Utilities.numberToString(Math.abs(t.amount), false, this.parent.isEuropeanNumberFormat, this.isGroupingUsed) + "|" + t.reference;
                t.amount = Utilities.foreignToHome(t.amount, ccy.rate);
                if (t.category.equals("Split")) {
                    int n = t.ss.size();
                    for (int i = 0; i < n; ++i) {
                        split = t.ss.getSplit(i);
                        split.amount = Utilities.foreignToHome(split.amount, ccy.rate);
                        t.ss.setSplit(split, i);
                    }
                }
            }
            if (t.description.toLowerCase().startsWith("opening balance")) {
                if (!this.exportOpeningBalance) continue;
                a.current += t.amount - a.open;
                a.today += t.amount - a.open;
                a.reconciled += t.amount - a.open;
                a.open = t.amount;
                as.saveExistingAccount(a);
                continue;
            }
            if (t.category.equals("") && !t.transferFlag & !t.splitFlag) {
                Category c1 = cs.getCategoryFromName("None");
                t.category = c1.name;
            }
            if (t.splitFlag) {
                for (int i = 0; i < t.ss.size(); ++i) {
                    split = t.ss.getSplit(i);
                    Category c1 = cs.getCategoryFromName(split.category);
                    c1.updateBalance(split, null);
                    cs.saveExistingCategory(c1);
                }
            }
            if (t.transferFlag && t.description.equals("")) {
                t.description = t.transferAccount + " (transfer)";
            }
            if (ts.isDuplicateTransfer(t) || t.transferFlag && !this.includeTransfers) continue;
            t.id = ts.saveNewTransaction(t);
            if (++count == count / 100 * 100) {
                this.show(count + " transactions");
            }
            a.updateBalance(t, null, this.todayDays);
            as.saveExistingAccount(a);
            if (!t.splitFlag && !t.transferFlag) {
                Category c1 = cs.getCategoryFromName(t.category);
                c1.updateBalance(t, null);
                cs.saveExistingCategory(c1);
            }
            if (!t.transferFlag) continue;
            Transaction t1 = new Transaction();
            t1 = t1.clone(t);
            t1.amount = -t.amount;
            t1.transferAccount = a.name;
            t1.transferFlag = true;
            t1.account = t.transferAccount;
            if (t1.description.equals("")) {
                t1.description = t1.transferAccount + " (transfer)";
            }
            Account a1 = as.getAccountFromName(t1.account);
            ts.setIndex(a);
            ts.getIndex(a1);
            t1.id = ts.saveNewTransaction(t1);
            ts.setIndex(a1);
            ts.getIndex(a);
            a1.updateBalance(t1, null, this.todayDays);
            as.saveExistingAccount(a1);
        }
        ts.closeTransactionStore();
        cs.closeCategoryStore();
        as.closeAccountStore();
        this.show("Finished importing file");
    }

    void importOFX(String name) {
        int count;
        block19: {
            if (name.equals("")) {
                return;
            }
            count = 0;
            this.eofflag = false;
            this.show("Importing " + name);
            try {
                this.fc = new File(this.root + this.directory + name + ".ofx");
                if (!this.fc.exists()) {
                    this.fc = new File(this.root + this.directory + name + ".ofc");
                    if (!this.fc.exists()) {
                        this.show("OFX/OFC file does not exist");
                        this.showDoneButton();
                        return;
                    }
                }
                FileInputStream in = new FileInputStream(this.fc);
                try {
                    if (this.useUTF8) {
                        this.isr = new InputStreamReader((InputStream)in, "UTF8");
                        break block19;
                    }
                    this.isr = new InputStreamReader(in);
                }
                catch (UnsupportedEncodingException uee) {
                    System.out.println("UTF8 not supported");
                    this.isr = new InputStreamReader(in);
                }
            }
            catch (IOException ie) {
                this.show("Error in importOFX: " + ie.toString());
                this.showDoneButton();
                return;
            }
        }
        AccountStore as = new AccountStore(this.parent, true);
        Account a = as.getAccountFromName(name);
        CategoryStore cs = new CategoryStore(this.parent, true);
        TransactionStore ts = new TransactionStore(this.parent, a, true);
        CurrencyStore ccys = new CurrencyStore(this.parent, true);
        Currency ccy = ccys.getCurrencyFromName(a.currency);
        ccys.closeCurrencyStore();
        ccys = null;
        while (true) {
            String textLine = this.receiveText();
            if (this.eofflag) break;
            if (textLine.length() == 0 || textLine.indexOf("<STMTTRN>") < 0) continue;
            Transaction t = new Transaction();
            t.reconciled = true;
            t.account = a.name;
            while (true) {
                int k2;
                int k1;
                textLine = this.receiveText();
                if (this.eofflag) break;
                if (textLine.length() == 0) continue;
                if (textLine.indexOf("</STMTTRN>") >= 0) break;
                if (textLine.indexOf("<NAME>") >= 0) {
                    k1 = textLine.indexOf("<NAME>");
                    k2 = textLine.indexOf("</NAME>");
                    if (k2 < 0) {
                        k2 = textLine.length();
                    }
                    t.description = textLine.substring(k1 + 6, k2);
                }
                if (textLine.indexOf("<MEMO>") >= 0) {
                    k1 = textLine.indexOf("<MEMO>");
                    k2 = textLine.indexOf("</MEMO>");
                    if (k2 < 0) {
                        k2 = textLine.length();
                    }
                    t.reference = textLine.substring(k1 + 6, k2);
                }
                if (textLine.indexOf("<TRNAMT>") >= 0) {
                    k1 = textLine.indexOf("<TRNAMT>");
                    k2 = textLine.indexOf("</TRNAMT>");
                    if (k2 < 0) {
                        k2 = textLine.length();
                    }
                    t.amount = Utilities.stringToNumber(textLine.substring(k1 + 8, k2), 0, false, this.parent.isEuropeanNumberFormat);
                }
                if (textLine.indexOf("<DTPOSTED>") < 0) continue;
                k1 = textLine.indexOf("<DTPOSTED>");
                String s1 = textLine.substring(k1 + 10, k1 + 18);
                this.cal.set(1, this.getInt(s1.substring(0, 4)));
                this.cal.set(2, this.getInt(s1.substring(4, 6)) - 1);
                this.cal.set(5, this.getInt(s1.substring(6, 8)));
                t.longDate = this.cal.getTime().getTime();
            }
            if (this.eofflag) break;
            if (!a.currency.equals(this.parent.homeCurrency)) {
                t.reference = t.reference.equals("") ? a.currency + " " + Utilities.numberToString(Math.abs(t.amount), false, this.parent.isEuropeanNumberFormat, this.isGroupingUsed) : a.currency + " " + Utilities.numberToString(Math.abs(t.amount), false, this.parent.isEuropeanNumberFormat, this.isGroupingUsed) + "|" + t.reference;
                t.amount = Utilities.foreignToHome(t.amount, ccy.rate);
            }
            if (t.category.equals("") && !t.transferFlag & !t.splitFlag) {
                Category c1 = cs.getCategoryFromName("None");
                t.category = c1.name;
            }
            t.id = ts.saveNewTransaction(t);
            if (++count == count / 100 * 100) {
                this.show(count + " transactions");
            }
            a.updateBalance(t, null, this.todayDays);
            as.saveExistingAccount(a);
            if (t.splitFlag || t.transferFlag) continue;
            Category c1 = cs.getCategoryFromName(t.category);
            c1.updateBalance(t, null);
            cs.saveExistingCategory(c1);
        }
        ts.closeTransactionStore();
        cs.closeCategoryStore();
        as.closeAccountStore();
        this.show("Finished importing file");
    }

    void exportQIF(Account a, Date from, Date to) {
        int count = 0;
        this.show("Exporting " + a.name);
        try {
            this.fc = new File(this.root + this.directory + a.name + ".qif");
            if (this.fc.exists()) {
                this.fc.delete();
            }
            this.dos = new DataOutputStream(new FileOutputStream(this.fc));
        }
        catch (IOException ie) {
            this.show("Error in exportQIF: " + ie.toString());
            this.showDoneButton();
            return;
        }
        TransactionStore ts = new TransactionStore(this.parent, a, true);
        int n = ts.getNumTransactions();
        CurrencyStore ccys = new CurrencyStore(this.parent, true);
        Currency ccy = ccys.getCurrencyFromName(a.currency);
        ccys.closeCurrencyStore();
        ccys = null;
        String qt = a.type;
        if (a.type.equals("Credit Card")) {
            qt = "CCard";
        }
        if (a.type.equals("Asset")) {
            qt = "Oth A";
        }
        if (a.type.equals("Liability")) {
            qt = "Oth L";
        }
        this.exportLine("!Type:" + qt);
        if (this.exportOpeningBalance) {
            Transaction t = new Transaction();
            if (n > 0) {
                t = ts.normalSortOrder ? ts.getTransactionFromIndex(n - 1) : ts.getTransactionFromIndex(0);
            } else {
                t.longDate = this.todayDate.getTime();
            }
            this.genericDate.setTime(t.longDate);
            this.exportLine("D" + this.setQIFDate(this.genericDate, this.qifDateFormat));
            this.exportLine("POpening Balance");
            if (!a.currency.equals(this.parent.homeCurrency)) {
                a.open = Utilities.homeToForeign(a.open, ccy.rate);
            }
            this.exportLine("T" + Utilities.numberToString(a.open, false, this.parent.isEuropeanNumberFormat, false));
            this.exportLine("Cx");
            this.exportLine("^");
        }
        long fromLong = Utilities.longToDays(from.getTime());
        long toLong = Utilities.longToDays(to.getTime());
        int freq = 100;
        freq = 500;
        for (int i = n - 1; i >= 0; --i) {
            int k = i;
            if (!ts.normalSortOrder) {
                k = n - 1 - i;
            }
            Transaction t = ts.getTransactionFromIndex(k);
            long tLong = Utilities.longToDays(t.longDate);
            if (tLong < fromLong || tLong > toLong || t.transferFlag && !this.includeTransfers) continue;
            this.genericDate.setTime(t.longDate);
            this.exportLine("D" + this.setQIFDate(this.genericDate, this.qifDateFormat));
            this.exportLine("P" + t.description);
            if (a.currency.equals(this.parent.homeCurrency)) {
                this.exportLine("T" + Utilities.numberToString(t.amount, false, this.parent.isEuropeanNumberFormat, false));
            } else if (t.reference.startsWith(a.currency)) {
                String s4;
                int pos = t.reference.indexOf("|");
                String s3 = "T";
                if (t.amount < 0) {
                    s3 = s3 + "-";
                }
                if (pos < 0) {
                    s4 = t.reference.substring(a.currency.length());
                    t.reference = "";
                } else {
                    s4 = t.reference.substring(a.currency.length(), pos);
                    t.reference = t.reference.substring(pos + 1);
                }
                if (s4.startsWith(" ")) {
                    s4 = s4.substring(1);
                }
                this.exportLine(s3 + s4);
            }
            if (!t.reference.equals("")) {
                this.exportLine("M" + t.reference);
            }
            if (t.transferFlag) {
                this.exportLine("L[" + t.transferAccount + "]");
            } else if (t.splitFlag) {
                for (int j = 0; j < t.ss.size(); ++j) {
                    Split s = t.ss.getSplit(j);
                    this.exportLine("S" + s.category);
                    this.exportLine("E" + t.reference);
                    s.amount = Utilities.homeToForeign(s.amount, ccy.rate);
                    this.exportLine("$" + Utilities.numberToString(s.amount, false, this.parent.isEuropeanNumberFormat, false));
                }
            } else {
                this.exportLine("L" + t.category);
            }
            if (t.reconciled) {
                this.exportLine("Cx");
            }
            this.exportLine("^");
            if (++count != count / freq * freq) continue;
            this.show(count + " transactions");
        }
        ts.closeTransactionStore();
        ts = null;
        try {
            this.dos.close();
        }
        catch (IOException ie) {
            this.show("Error in exportQIF: " + ie.toString());
            this.showDoneButton();
            return;
        }
        this.show("Finished exporting file");
    }

    void exportIncomeExpenseReport(Account a, Date from, Date to, int qifDateFormat, int exportType, boolean allAccounts) {
        int k2;
        int k1;
        int k;
        int i;
        this.exportFileType = exportType - 2;
        if (this.exportFileType < 0) {
            this.exportFileType = 0;
        }
        CategoryStore cs = new CategoryStore(this.parent, true);
        TransactionStore ts = new TransactionStore(this.parent, new Account(), true);
        try {
            this.show("Building Report");
            String s = "";
            s = allAccounts ? "Export" : a.name;
            if (this.exportFileType == 0) {
                s = s + ".csv";
            }
            if (this.exportFileType == 1) {
                s = s + ".tab";
            }
            this.fc = new File(this.root + this.directory + s);
            if (this.fc.exists()) {
                this.fc.delete();
            }
            this.dos = new DataOutputStream(new FileOutputStream(this.fc));
        }
        catch (IOException ie) {
            this.show("Error in exportIncomeExpenseReport: " + ie.toString());
            this.showDoneButton();
            return;
        }
        Vector v = ts.buildCategoriesFromDates(from, to, a, allAccounts);
        this.writeStartLine();
        this.addString("JabpLite Income and Expense Report", false);
        this.exportLine(this.textLine);
        this.exportLine("");
        this.writeStartLine();
        this.addString("From Date: " + this.setQIFDate(from, qifDateFormat), false);
        this.exportLine(this.textLine);
        this.writeStartLine();
        this.addString("To Date: " + this.setQIFDate(to, qifDateFormat), false);
        this.exportLine(this.textLine);
        this.exportLine("");
        int n = v.size();
        int incomeTotal = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            int k3 = (Integer)v.elementAt(i2);
            if (k3 >= 0) continue;
            incomeTotal += k3;
        }
        this.writeStartLine();
        this.addString("Total Income", true);
        this.addString(Utilities.numberToString(-incomeTotal, false, this.parent.isEuropeanNumberFormat, true), false);
        this.exportLine(this.textLine);
        int expenseTotal = 0;
        for (i = 0; i < n; ++i) {
            k = (Integer)v.elementAt(i);
            if (k < 0) continue;
            expenseTotal += k;
        }
        this.writeStartLine();
        this.addString("Total Expense", true);
        this.addString(Utilities.numberToString(expenseTotal, false, this.parent.isEuropeanNumberFormat, true), false);
        this.exportLine(this.textLine);
        this.writeStartLine();
        this.addString("Income less Expense", true);
        this.addString(Utilities.numberToString(-(incomeTotal + expenseTotal), false, this.parent.isEuropeanNumberFormat, true), false);
        this.exportLine(this.textLine);
        this.exportLine("");
        this.writeStartLine();
        this.addString("Income Category Name", true);
        this.addString("Amount", true);
        this.addString("Percent", false);
        this.exportLine(this.textLine);
        this.exportLine("");
        for (i = 0; i < n; ++i) {
            k = (Integer)v.elementAt(i);
            if (k >= 0) continue;
            this.writeStartLine();
            this.addString(cs.getCategoryFromIndex((int)i).name, true);
            this.addString(Utilities.numberToString(-k, false, this.parent.isEuropeanNumberFormat, true), true);
            if (incomeTotal == 0) {
                this.addString("", false);
            } else {
                k1 = k;
                k2 = incomeTotal;
                while (Math.abs(k1) > 0x200B20) {
                    k1 /= 10;
                    k2 /= 10;
                }
                this.addString(Utilities.decimalToString(k1 * 1000 / k2, false, this.parent.isEuropeanNumberFormat, false, 1), false);
            }
            this.exportLine(this.textLine);
        }
        this.writeStartLine();
        this.addString("Total Income", true);
        this.addString(Utilities.numberToString(-incomeTotal, false, this.parent.isEuropeanNumberFormat, true), false);
        this.exportLine(this.textLine);
        this.exportLine("");
        this.writeStartLine();
        this.addString("Expense Category Name", true);
        this.addString("Amount", true);
        this.addString("Percent", false);
        this.exportLine(this.textLine);
        this.exportLine("");
        for (i = 0; i < n; ++i) {
            k = (Integer)v.elementAt(i);
            if (k < 0) continue;
            this.writeStartLine();
            this.addString(cs.getCategoryFromIndex((int)i).name, true);
            this.addString(Utilities.numberToString(k, false, this.parent.isEuropeanNumberFormat, true), true);
            if (expenseTotal == 0) {
                this.addString("", false);
            } else {
                k1 = k;
                k2 = expenseTotal;
                while (Math.abs(k1) > 0x200B20) {
                    k1 /= 10;
                    k2 /= 10;
                }
                this.addString(Utilities.decimalToString(k1 * 1000 / k2, false, this.parent.isEuropeanNumberFormat, false, 1), false);
            }
            this.exportLine(this.textLine);
        }
        this.writeStartLine();
        this.addString("Total Expense", true);
        this.addString(Utilities.numberToString(expenseTotal, false, this.parent.isEuropeanNumberFormat, true), false);
        this.exportLine(this.textLine);
        cs.closeCategoryStore();
        cs = null;
        ts.closeTransactionStore();
        ts = null;
        try {
            this.dos.close();
        }
        catch (IOException ie) {
            this.show("Error in exportIncomeExpenseReport: " + ie.toString());
            this.showDoneButton();
            return;
        }
        this.show("Finished report");
    }

    void exportCSV(Account a, Date from, Date to, int exportType, boolean allAccounts) {
        this.exportFileType = exportType - 2;
        int count = 0;
        int total = 0;
        try {
            String s = "";
            if (allAccounts) {
                this.show("Exporting all accounts");
                s = "Export";
            } else {
                this.show("Exporting " + a.name);
                s = a.name;
            }
            if (this.exportFileType == 0) {
                s = s + ".csv";
            }
            if (this.exportFileType == 1) {
                s = s + ".tab";
            }
            this.fc = new File(this.root + this.directory + s);
            if (this.fc.exists()) {
                this.fc.delete();
            }
            this.dos = new DataOutputStream(new FileOutputStream(this.fc));
        }
        catch (IOException ie) {
            this.show("Error in exportCSV: " + ie.toString());
            this.showDoneButton();
            return;
        }
        AccountStore as = new AccountStore(this.parent, true);
        this.writeStartLine();
        this.addString("Date", true);
        this.addString("Description", true);
        this.addString("Reference", true);
        this.addString("Category", true);
        this.addString("Amount", true);
        this.addString("Running Total", true);
        this.addString("Reconciled", true);
        this.addString("Account", false);
        this.exportLine(this.textLine);
        int n = 0;
        if (this.exportOpeningBalance) {
            if (allAccounts) {
                n = as.getNumAccounts();
                for (int i = 0; i < n; ++i) {
                    a = as.getAccountFromIndex(i);
                    total += a.open;
                }
            } else {
                total = a.open;
            }
            this.writeStartLine();
            this.addString("", true);
            this.addString("Opening Balance", true);
            this.addString("", true);
            this.addString("", true);
            this.addString(Utilities.numberToString(total, false, this.parent.isEuropeanNumberFormat, false), true);
            this.addString(Utilities.numberToString(total, false, this.parent.isEuropeanNumberFormat, false), true);
            this.addString("Yes", true);
            if (allAccounts) {
                this.addString("All Accounts", false);
            } else {
                this.addString(a.name, false);
            }
            this.exportLine(this.textLine);
        }
        long fromLong = Utilities.longToDays(from.getTime());
        long toLong = Utilities.longToDays(to.getTime());
        n = as.getNumAccounts();
        int freq = 100;
        freq = 500;
        for (int k = 0; k < n; ++k) {
            if (allAccounts) {
                a = as.getAccountFromIndex(k);
            }
            TransactionStore ts = new TransactionStore(this.parent, a, true);
            int n1 = ts.getNumTransactions();
            for (int i = n1 - 1; i >= 0; --i) {
                int i1 = i;
                if (!ts.normalSortOrder) {
                    i1 = n1 - 1 - i;
                }
                Transaction t = ts.getTransactionFromIndex(i1);
                long tLong = Utilities.longToDays(t.longDate);
                if (tLong < fromLong || tLong > toLong || t.transferFlag && !this.includeTransfers) continue;
                if (this.separateSplits && t.splitFlag) {
                    for (int j = 0; j < t.ss.size(); ++j) {
                        Split s = t.ss.getSplit(j);
                        this.writeStartLine();
                        this.genericDate.setTime(t.longDate);
                        this.addString(this.setQIFDate(this.genericDate, this.qifDateFormat), true);
                        this.addString(t.description, true);
                        this.addString(t.reference, true);
                        this.addString(s.category, true);
                        this.addString(Utilities.numberToString(s.amount, false, this.parent.isEuropeanNumberFormat, false), true);
                        this.addString(Utilities.numberToString(total += s.amount, false, this.parent.isEuropeanNumberFormat, false), true);
                        if (t.reconciled) {
                            this.addString("Yes", true);
                        } else {
                            this.addString("No", true);
                        }
                        this.addString(a.name, false);
                        this.exportLine(this.textLine);
                    }
                } else {
                    this.writeStartLine();
                    this.genericDate.setTime(t.longDate);
                    this.addString(this.setQIFDate(this.genericDate, this.qifDateFormat), true);
                    this.addString(t.description, true);
                    this.addString(t.reference, true);
                    if (t.transferFlag) {
                        this.addString("[" + t.transferAccount + "]", true);
                    } else if (t.splitFlag) {
                        this.addString("(Split)", true);
                    } else {
                        this.addString(t.category, true);
                    }
                    this.addString(Utilities.numberToString(t.amount, false, this.parent.isEuropeanNumberFormat, false), true);
                    this.addString(Utilities.numberToString(total += t.amount, false, this.parent.isEuropeanNumberFormat, false), true);
                    if (t.reconciled) {
                        this.addString("Yes", true);
                    } else {
                        this.addString("No", true);
                    }
                    this.addString(a.name, false);
                    this.exportLine(this.textLine);
                }
                if (++count != count / freq * freq) continue;
                this.show(count + " transactions");
            }
            ts.closeTransactionStore();
            ts = null;
            if (!allAccounts) break;
        }
        as.closeAccountStore();
        try {
            this.dos.close();
        }
        catch (IOException ie) {
            this.show("Error in exportCSV: " + ie.toString());
            this.showDoneButton();
            return;
        }
        this.show("Finished exporting file");
    }

    void addString(String s, boolean b) {
        this.textLine = this.textLine + s;
        if (this.exportFileType == 0) {
            this.textLine = b ? this.textLine + "\",\"" : this.textLine + "\"";
        } else if (b) {
            this.textLine = this.textLine + "\t";
        }
    }

    void writeStartLine() {
        this.textLine = "";
        if (this.exportFileType == 0) {
            this.textLine = this.textLine + "\"";
        }
    }

    int lastIndexOf(String s1, String s2) {
        int n1 = s1.length();
        int n2 = s2.length();
        for (int i = n1 - n2; i > 0; --i) {
            if (!s1.substring(i, i + s2.length()).equals(s2)) continue;
            return i;
        }
        return -1;
    }

    int getInt(String s) {
        Integer integer = new Integer(0);
        integer = Integer.valueOf(s);
        return integer;
    }

    void exportLine(String s) {
        this.sendText(s);
    }

    void getRoot() {
        this.rs = new RecordStore(this.parent, "Directory", true);
        if (this.rs.getNumRecords() == 0) {
            this.root = "";
            this.internalRoot = "";
            this.directory = this.parent.getDir("Backups/", 0);
            this.qifDateFormat = 0;
            this.useUTF8 = false;
            this.lastExportedFromDate = 0L;
            this.lastExportedAccount = "";
            this.exportOpeningBalance = false;
        } else {
            byte[] bytes = this.rs.getRecord(0);
            this.fromByteArray(bytes);
            File f = new File(this.directory);
            if (f == null || !f.canRead()) {
                this.directory = this.parent.getDir("Backups/", 0);
            }
        }
        this.rs.closeRecordStore();
        this.rs = null;
    }

    void fromByteArray(byte[] bytes) {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            this.root = dis.readUTF();
            this.directory = dis.readUTF();
            this.qifDateFormat = dis.readInt();
            this.useUTF8 = dis.readBoolean();
            this.lastExportedFromDate = dis.readLong();
            this.lastExportedAccount = dis.readUTF();
            this.exportOpeningBalance = dis.readBoolean();
            dis.close();
        }
        catch (IOException ie) {
            System.err.println(ie + " dir3");
        }
    }

    byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeUTF(this.root);
            dos.writeUTF(this.directory);
            dos.writeInt(this.qifDateFormat);
            dos.writeBoolean(this.useUTF8);
            dos.writeLong(this.lastExportedFromDate);
            dos.writeUTF(this.lastExportedAccount);
            dos.writeBoolean(this.exportOpeningBalance);
            dos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    private boolean sendRecord(byte[] record) {
        try {
            this.dos.writeInt(record.length);
            this.dos.write(record, 0, record.length);
            return true;
        }
        catch (IOException ie) {
            return false;
        }
    }

    private boolean sendText(String s) {
        String s1 = s + "\r\n";
        try {
            byte[] b;
            if (this.useUTF8) {
                try {
                    b = s1.getBytes("UTF8");
                }
                catch (UnsupportedEncodingException uee) {
                    b = s1.getBytes();
                }
            } else {
                b = s1.getBytes();
            }
            this.dos.write(b);
            return true;
        }
        catch (IOException ie) {
            return false;
        }
    }

    private boolean sendNumber(int n) {
        try {
            this.dos.writeInt(n);
            return true;
        }
        catch (IOException ie) {
            return false;
        }
    }

    String receiveText() {
        int b = 0;
        StringBuffer sb = new StringBuffer();
        while (true) {
            try {
                b = this.isr.read();
            }
            catch (IOException ie) {
                System.out.println(ie);
            }
            if (b < 0) {
                this.eofflag = true;
                break;
            }
            char c = (char)b;
            if (c == '\r') continue;
            if (c == '\n') break;
            sb.append(c);
        }
        return sb.toString();
    }

    byte[] receiveRecord() {
        int n = this.receiveNumber();
        if (n < 0) {
            return null;
        }
        byte[] b = new byte[n];
        try {
            this.dis.read(b, 0, n);
        }
        catch (IOException ie) {
            System.out.println(ie);
        }
        return b;
    }

    int receiveNumber() {
        try {
            return this.dis.readInt();
        }
        catch (IOException ie) {
            this.eofflag = true;
            return -1;
        }
    }

    public void dropboxDownloadFile(final String fileName) {
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                ImportExportForm.this.show("Downloading " + fileName + " from Dropbox");
                DbxDownloader<FileMetadata> downloader = null;
                try {
                    downloader = ImportExportForm.this.parent.client.files().download("/" + fileName);
                }
                catch (DbxException e) {
                    Toast.makeText(ImportExportForm.this.parent, "Dropbox error: " + e, 2000).show();
                    System.out.println(e);
                    return;
                }
                try {
                    FileOutputStream out = new FileOutputStream(ImportExportForm.this.root + ImportExportForm.this.directory + fileName);
                    downloader.download(out);
                    ImportExportForm.this.show("Download of " + fileName + " successful");
                    out.close();
                }
                catch (DbxException ex) {
                    ImportExportForm.this.show("Error copying " + fileName);
                    System.out.println(ex);
                    return;
                }
                catch (IOException e) {
                    ImportExportForm.this.show("Error copying " + fileName);
                    System.out.println(e);
                    return;
                }
                if (fileName.contains("JabpLite.dat")) {
                    ImportExportForm.this.runMode = 4;
                    ImportExportForm.this.runThread();
                }
                if (fileName.contains("JabpLite.sync")) {
                    ImportExportForm.this.isJabpLiteSyncDownloaded = true;
                    if (ImportExportForm.this.isJabpLiteSyncDownloaded && ImportExportForm.this.isJabpSyncDownloaded) {
                        ImportExportForm.this.runMode = 10;
                        ImportExportForm.this.runThread();
                    }
                }
                if (fileName.contains("Jabp.sync")) {
                    ImportExportForm.this.isJabpSyncDownloaded = true;
                    if (ImportExportForm.this.isJabpLiteSyncDownloaded && ImportExportForm.this.isJabpSyncDownloaded) {
                        ImportExportForm.this.runMode = 10;
                        ImportExportForm.this.runThread();
                    }
                }
                if (fileName.contains("gpaydb.sync")) {
                    ImportExportForm.this.isGooglePaySyncDownloaded = true;
                    ImportExportForm.this.syncGooglePayWithDropbox();
                }
            }
        });
        thread2.start();
    }

    public void dropboxUploadFile(final File file) {
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                String fileName = file.getName();
                ImportExportForm.this.show("Uploading " + fileName + " to Dropbox");
                try (FileInputStream in = new FileInputStream(ImportExportForm.this.root + ImportExportForm.this.directory + fileName);){
                    FileMetadata metadata = (FileMetadata)ImportExportForm.this.parent.client.files().uploadBuilder("/" + fileName).withMode(WriteMode.OVERWRITE).uploadAndFinish(in);
                    ImportExportForm.this.show("Upload of " + fileName + " successful");
                }
                catch (FileNotFoundException e) {
                    System.out.println(e.toString());
                    ImportExportForm.this.show("File not found");
                    return;
                }
                catch (IOException e) {
                    System.out.println(e.toString());
                    ImportExportForm.this.show("IOError: " + e);
                    return;
                }
                catch (UploadErrorException e) {
                    System.out.println(e.toString());
                    ImportExportForm.this.show("Upload error: " + e);
                    return;
                }
                catch (DbxException e) {
                    System.out.println(e.toString());
                    ImportExportForm.this.show("Dropbox error: " + e);
                    return;
                }
                if (fileName.contains("JabpLite.dat")) {
                    ImportExportForm.this.show("Finished exporting data");
                    ImportExportForm.this.showDoneButton();
                }
                if (fileName.contains("JabpLite.sync")) {
                    ImportExportForm.this.isJabpLiteSyncUploaded = true;
                    ImportExportForm.this.parent.syncStatus = "";
                    if (ImportExportForm.this.isJabpLiteSyncUploaded && ImportExportForm.this.isJabpSyncUploaded) {
                        ImportExportForm.this.runMode = 0;
                        ImportExportForm.this.show("Finished");
                        if (ImportExportForm.this.parent.pendingTransactions != null) {
                            ImportExportForm.this.processPendingTransactions();
                        } else {
                            ImportExportForm.this.showDoneButton();
                        }
                    }
                }
                if (fileName.contains("Jabp.sync")) {
                    ImportExportForm.this.parent.sync.deleteSyncStore();
                    ImportExportForm.this.parent.sync = new SyncStore(ImportExportForm.this.parent, false);
                    ImportExportForm.this.isJabpSyncUploaded = true;
                    if (ImportExportForm.this.isJabpLiteSyncUploaded && ImportExportForm.this.isJabpSyncUploaded) {
                        ImportExportForm.this.runMode = 0;
                        ImportExportForm.this.show("Finished");
                        if (ImportExportForm.this.parent.pendingTransactions != null) {
                            ImportExportForm.this.processPendingTransactions();
                        } else {
                            ImportExportForm.this.showDoneButton();
                        }
                    }
                }
                if (fileName.contains("gpaydb.sync")) {
                    ImportExportForm.this.isGooglePaySyncFinished = true;
                    ImportExportForm.this.parent.gpayStatus = "";
                    ImportExportForm.this.show("Finished");
                    ImportExportForm.this.showDoneButton();
                }
            }
        });
        thread2.start();
    }

    void createEmptySyncFilesIfNeeded() {
        File fc2;
        File fc1 = new File(this.root + this.directory + "Jabp.sync");
        if (!fc1.exists()) {
            this.writeEmptyFile(fc1);
        }
        if (!(fc2 = new File(this.root + this.directory + "JabpLite.sync")).exists()) {
            this.writeEmptyFile(fc2);
        }
    }

    void show(String s1) {
        final String s = s1;
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                ImportExportForm.this.parent.spf.append(s + "\n");
            }
        });
        thread2.start();
        try {
            thread2.join();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    void showDoneButton() {
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                ImportExportForm.this.parent.spf.button.setVisible(true);
            }
        });
        thread2.start();
    }

    void saveDirectory() {
        this.rs = new RecordStore(this.parent, "Directory", true);
        if (this.rs != null) {
            byte[] bytes = this.toByteArray();
            if (this.rs.getNumRecords() > 0) {
                this.rs.setRecord(0, bytes, 0, bytes.length);
            } else {
                this.rs.addRecord(bytes, 0, bytes.length);
            }
            this.rs.closeRecordStore();
            this.rs = null;
        }
    }
}

