/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.Category;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.GraphDetails;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.LongId;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.TransactionStore;
import org.freepoc.Jabp4.Utilities;

class GraphView
extends Canvas
implements ActionListener,
KeyListener,
MouseListener {
    Jabp parent;
    Vector v;
    Vector vdate;
    Vector vamount;
    String letters;
    Account a;
    int total;
    int openingBalance;
    int finishingBalance;
    int maxSize;
    int minSize;
    Date fromDate;
    Date toDate;
    Date maxDate;
    Date minDate;
    Point point;
    Font font;
    FontMetrics fm;
    Vector canvasMenu;
    boolean showCanvasMenu = false;
    boolean showingPopupMenu = false;
    boolean calculateCanvasMenuPosition = true;
    int count;
    int numberOfItems;
    int numberOfDays;
    int graphType;
    int textStart;
    int maxScale;
    int minScale;
    int availableWidth;
    int availableHeight;
    int width;
    int height;
    int lineHeight;
    int fontHeight;
    int currentX;
    int currentY;
    int numItemsPage;
    int fontSize;
    int currentMenuPos;
    int menuHeightPos;
    int menuWidth;
    int menuHeight;
    int menuWidthPos;
    int startMenuPos;
    int numMenuItems;
    int bottomMargin;
    int leftMargin;
    int rightMargin;
    boolean isExpenses;

    GraphView(Jabp context) {
        this.parent = context;
        this.fontSize = 14;
        this.font = new Font(this.parent.fontName, this.parent.fontWeight, this.fontSize);
        this.setFont(this.font);
        this.fm = this.getFontMetrics(this.font);
        this.fontHeight = this.fm.getHeight() + this.parent.fontSpace;
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.setupCanvasMenu();
        this.setVariables();
    }

    void setVariables() {
        this.a = this.parent.gf.a;
        this.numberOfItems = this.parent.gf.numberOfItems;
        this.v = this.parent.gf.v;
        this.total = this.parent.gf.total;
        this.graphType = this.parent.gf.graphType;
        this.vdate = this.parent.gf.vdate;
        this.vamount = this.parent.gf.vamount;
        this.fromDate = this.parent.gf.fromDate;
        this.toDate = this.parent.gf.toDate;
        this.maxDate = this.parent.gf.maxDate;
        this.minDate = this.parent.gf.minDate;
        this.maxSize = this.parent.gf.maxSize;
        this.minSize = this.parent.gf.minSize;
        this.finishingBalance = this.parent.gf.finishingBalance;
        this.isExpenses = this.parent.gf.isExpenses;
        this.setupCanvasMenu();
    }

    void drawAccountLineGraph(Graphics g) {
        this.parent.setTitle("Jabp: Account Graph for " + this.a.name);
        g.setFont(this.font);
        if (this.parent.tv != null) {
            this.parent.tv.ts.closeTransactionStore();
            this.parent.tv = null;
        }
        TransactionStore ts = new TransactionStore(this.parent, this.a, true);
        int n = ts.ht.size();
        int i1 = n - 1;
        int i2 = 0;
        if (!ts.normalSortOrder) {
            i1 = 0;
            i2 = n - 1;
        }
        Date d1 = new Date(ts.getTransactionFromIndex((int)i1).longDate);
        Date d2 = new Date(ts.getTransactionFromIndex((int)i2).longDate);
        if (this.fromDate.after(d1)) {
            d1 = this.fromDate;
        }
        if (this.toDate.before(d2)) {
            d2 = this.toDate;
        }
        this.numberOfDays = this.calculateDayDifference(d1, d2);
        this.setScales(g, d1, d2);
        if (this.graphType == -1) {
            return;
        }
        g.setColor(new Color(0, 0, 255));
        int currentHeight = this.calculateHeight(this.a.open);
        int currentWidth = this.leftMargin;
        int newWidth = 0;
        int newHeight = 0;
        this.count = 0;
        int runningTotal = this.a.open;
        this.openingBalance = this.a.open;
        int dayTotal = 0;
        long longDate = 0L;
        int dayCount = 0;
        Transaction t = null;
        for (int i = 0; i < n; ++i) {
            int j = n - 1 - i;
            if (!ts.normalSortOrder) {
                j = i;
            }
            t = ts.getTransactionFromIndex(j);
            if (Utilities.longToDays(t.longDate) < Utilities.longToDays(this.fromDate.getTime())) {
                dayTotal += t.amount;
                this.openingBalance += t.amount;
                continue;
            }
            if (Utilities.longToDays(t.longDate) > Utilities.longToDays(this.toDate.getTime())) continue;
            if (Utilities.longToDays(t.longDate) != Utilities.longToDays(longDate)) {
                newWidth = this.leftMargin + this.count * (this.availableWidth - this.leftMargin - this.rightMargin) / this.numberOfDays;
                newHeight = this.calculateHeight(runningTotal += dayTotal);
                g.drawLine(currentWidth, currentHeight, newWidth, currentHeight);
                g.drawLine(newWidth, currentHeight, newWidth, newHeight);
                currentWidth = newWidth;
                currentHeight = newHeight;
                dayTotal = t.amount;
                dayCount = this.calculateDayDifference(longDate, t.longDate);
                this.count += dayCount;
                longDate = t.longDate;
                continue;
            }
            dayTotal += t.amount;
        }
        ts.closeTransactionStore();
        newWidth = this.leftMargin + this.count * (this.availableWidth - this.leftMargin - this.rightMargin) / this.numberOfDays;
        newHeight = this.calculateHeight(runningTotal += dayTotal);
        g.drawLine(currentWidth, currentHeight, newWidth, currentHeight);
        g.drawLine(newWidth, currentHeight, newWidth, newHeight);
        currentWidth = newWidth;
        currentHeight = newHeight;
        newWidth = this.leftMargin + this.availableWidth - this.bottomMargin;
        g.drawLine(currentWidth, currentHeight, newWidth, currentHeight);
        g.drawString(this.a.name, this.availableWidth - this.fm.stringWidth(this.a.name), this.fontHeight);
    }

    void drawFutureLineGraph(Graphics g) {
        this.parent.setTitle("Jabp: Future Balance Graph for " + this.a.name);
        g.setFont(this.font);
        Date d1 = new Date();
        Date d2 = (Date)this.vdate.elementAt(this.vdate.size() - 1);
        this.fromDate = d1;
        this.numberOfDays = this.calculateDayDifference(this.fromDate, this.toDate);
        this.setScales(g, this.fromDate, this.toDate);
        if (this.graphType == -1) {
            return;
        }
        g.setColor(new Color(0, 0, 255));
        int currentHeight = this.calculateHeight(this.a.today);
        int currentWidth = this.leftMargin;
        int newWidth = 0;
        int newHeight = 0;
        this.count = 0;
        int runningTotal = this.a.today;
        int dayTotal = 0;
        int dayCount = 0;
        Date date = new Date(0L);
        for (int i = 0; i < this.vdate.size(); ++i) {
            Date tdate = (Date)this.vdate.elementAt(i);
            int tamount = (Integer)this.vamount.elementAt(i);
            if (Utilities.longToDays(tdate.getTime()) != Utilities.longToDays(date.getTime())) {
                newWidth = this.leftMargin + this.count * (this.availableWidth - this.leftMargin - this.rightMargin) / this.numberOfDays;
                newHeight = this.calculateHeight(runningTotal += dayTotal);
                g.drawLine(currentWidth, currentHeight, newWidth, currentHeight);
                g.drawLine(newWidth, currentHeight, newWidth, newHeight);
                currentWidth = newWidth;
                currentHeight = newHeight;
                dayTotal = tamount;
                dayCount = this.calculateDayDifference(date, tdate);
                this.count += dayCount;
                date = tdate;
                continue;
            }
            dayTotal += tamount;
        }
        newWidth = this.leftMargin + this.count * (this.availableWidth - this.leftMargin - this.rightMargin) / this.numberOfDays;
        newHeight = this.calculateHeight(runningTotal += dayTotal);
        g.drawLine(currentWidth, currentHeight, newWidth, currentHeight);
        g.drawLine(newWidth, currentHeight, newWidth, newHeight);
        g.drawString(this.a.name, this.availableWidth - this.fm.stringWidth(this.a.name), this.fontHeight);
    }

    void drawCategoryBlockGraph(Graphics g) {
        int i;
        String s = "expenses";
        if (!this.isExpenses) {
            s = "income";
        }
        this.parent.setTitle("Jabp: Category Graph for " + s);
        float multiplier = 1.0f;
        this.textStart = 0;
        this.letters = "ABCDEFGHIJ";
        Color c = new Color(0, 0, 0);
        g.setFont(this.font);
        g.setColor(new Color(0, 0, 255));
        int numberOfItems2 = Math.min(10, this.numberOfItems);
        this.availableHeight = this.height - 25 * (int)multiplier;
        this.availableWidth = this.width - 20 * (int)multiplier;
        int maxPercentage = (int)((double)((Category)this.v.elementAt((int)0)).current * 100.0 / (double)this.total);
        maxPercentage = (maxPercentage / 20 + 1) * 20;
        maxPercentage = Math.min(maxPercentage, 100);
        double d = this.total;
        d = d / 100.0 * (double)maxPercentage;
        double scaling = (double)this.availableHeight / d;
        int columnWidth = this.availableWidth / numberOfItems2;
        for (int i2 = 0; i2 < numberOfItems2; ++i2) {
            int current = ((Category)this.v.elementAt((int)i2)).current;
            int origin = (int)((double)current * scaling);
            switch (i2) {
                case 0: {
                    c = new Color(255, 0, 0);
                    break;
                }
                case 1: {
                    c = new Color(0, 255, 0);
                    break;
                }
                case 2: {
                    c = new Color(0, 0, 255);
                    break;
                }
                case 3: {
                    c = new Color(0, 255, 255);
                    break;
                }
                case 4: {
                    c = new Color(255, 0, 255);
                    break;
                }
                case 5: {
                    c = new Color(128, 128, 0);
                    break;
                }
                case 6: {
                    c = new Color(128, 0, 0);
                    break;
                }
                case 7: {
                    c = new Color(0, 128, 0);
                    break;
                }
                case 8: {
                    c = new Color(0, 0, 128);
                    break;
                }
                case 9: {
                    c = new Color(0, 128, 128);
                }
            }
            g.setColor(c);
            g.fill3DRect(20 * (int)multiplier + columnWidth * i2, this.availableHeight - origin + 5 * (int)multiplier, columnWidth - 5 * (int)multiplier, origin, true);
            g.drawString(String.valueOf((int)((double)current * 100.0 / (double)this.total + 0.5)), 20 * (int)multiplier + columnWidth * i2 + (columnWidth - 5 * (int)multiplier) / 2 - 5 * (int)multiplier, this.availableHeight - origin - 2 * (int)multiplier);
            g.drawString(this.letters.substring(i2, i2 + 1), 20 * (int)multiplier + columnWidth * i2 + (columnWidth - 5 * (int)multiplier) / 2 - 3 * (int)multiplier, this.height - 5 * (int)multiplier);
            if (origin <= this.availableHeight - numberOfItems2 * this.fontHeight - 25 * (int)multiplier) continue;
            this.textStart = 30 * (int)multiplier + columnWidth * i2 + columnWidth;
        }
        g.setColor(new Color(0, 0, 255));
        int stringWidth = 0;
        for (i = 0; i < numberOfItems2; ++i) {
            s = this.letters.substring(i, i + 1) + ". " + ((Category)this.v.elementAt((int)i)).name;
            s = s + "  " + Utilities.numberToString(((Category)this.v.elementAt((int)i)).current, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            stringWidth = Math.max(stringWidth, this.fm.stringWidth(s));
        }
        if (this.availableWidth - stringWidth > this.textStart) {
            this.textStart = this.availableWidth - stringWidth;
        }
        for (i = 0; i < numberOfItems2; ++i) {
            s = this.letters.substring(i, i + 1) + ". " + ((Category)this.v.elementAt((int)i)).name;
            s = s + "  " + Utilities.numberToString(Math.abs(((Category)this.v.elementAt((int)i)).current), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            g.drawString(s, this.textStart, (i + 1) * this.fontHeight);
        }
        s = String.valueOf(maxPercentage);
        g.drawString(s, 0, 20 * (int)multiplier);
        s = String.valueOf(maxPercentage * 3 / 4);
        g.drawString(s, 0, 20 * (int)multiplier + (this.availableHeight - 20 * (int)multiplier) * 1 / 4);
        s = String.valueOf(maxPercentage * 2 / 4);
        g.drawString(s, 0, 20 * (int)multiplier + (this.availableHeight - 20 * (int)multiplier) * 2 / 4);
        s = String.valueOf(maxPercentage * 1 / 4);
        g.drawString(s, 0, 20 * (int)multiplier + (this.availableHeight - 20 * (int)multiplier) * 3 / 4);
        s = "%";
        g.drawString(s, 0, 20 * (int)multiplier + (this.availableHeight - 20 * (int)multiplier));
    }

    int calculateHeight(int runningTotal) {
        double d = runningTotal - this.minScale;
        d = (double)(this.availableHeight - this.bottomMargin) * d;
        d /= (double)(this.maxScale - this.minScale);
        d = (double)(this.availableHeight - this.bottomMargin / 2) - d;
        return (int)d;
    }

    void setScales(Graphics g, Date d1, Date d2) {
        float multiplier = 1.0f;
        int fontAdjustment = this.fontHeight - this.fontSize;
        this.bottomMargin = (int)(40.0f * multiplier);
        this.leftMargin = (int)(35.0f * multiplier);
        this.rightMargin = (int)(5.0f * multiplier);
        this.availableHeight = this.height - this.bottomMargin;
        if (this.numberOfDays > 365) {
            this.availableHeight = this.availableHeight - this.fontHeight - 3 * (int)multiplier;
        }
        this.availableWidth = this.width - 25;
        this.maxScale = 0;
        this.minScale = 0;
        int rangeScale = this.maxSize - this.minSize;
        if (rangeScale <= 100) {
            this.maxScale = (rangeScale / 20 + 1) * 20;
        }
        if (rangeScale > 100 && rangeScale <= 1000) {
            this.maxScale = (rangeScale / 200 + 1) * 200;
        }
        if (rangeScale > 1000 && rangeScale <= 10000) {
            this.maxScale = (rangeScale / 2000 + 1) * 2000;
        }
        if (rangeScale > 10000 && rangeScale <= 100000) {
            this.maxScale = (rangeScale / 20000 + 1) * 20000;
        }
        if (rangeScale > 100000 && rangeScale <= 1000000) {
            this.maxScale = (rangeScale / 200000 + 1) * 200000;
        }
        if ((double)rangeScale > 1000000.0) {
            this.maxScale = (rangeScale / 2000000 + 1) * 2000000;
        }
        if (rangeScale > 10000000 && rangeScale <= 100000000) {
            this.maxScale = (rangeScale / 20000000 + 1) * 20000000;
        }
        if (rangeScale > 100000000) {
            this.maxScale = (rangeScale / 200000000 + 1) * 200000000;
        }
        int increment = this.maxScale / 4;
        while (this.maxScale > this.maxSize) {
            this.maxScale -= increment;
        }
        while (this.maxScale < this.maxSize) {
            this.maxScale += increment;
        }
        this.minScale = this.maxScale - increment * 4;
        if (this.minScale > this.minSize) {
            this.minScale -= increment * 2;
            this.maxScale += increment * 2;
            increment = (this.maxScale - this.minScale) / 4;
        }
        String s = new String();
        s = String.valueOf(this.maxScale);
        s = s.endsWith("00000") ? String.valueOf(this.maxScale / 100000) + "K" : String.valueOf(this.maxScale / 100);
        g.drawString(s, 0, this.bottomMargin / 2);
        s = String.valueOf(this.maxScale - increment);
        s = s.endsWith("00000") ? String.valueOf((this.maxScale - increment) / 100000) + "K" : String.valueOf((this.maxScale - increment) / 100);
        g.drawString(s, 0, this.bottomMargin / 2 + (this.availableHeight - this.bottomMargin) * 1 / 4);
        s = String.valueOf(this.maxScale - increment * 2);
        s = s.endsWith("00000") ? String.valueOf((this.maxScale - increment * 2) / 100000) + "K" : String.valueOf((this.maxScale - increment * 2) / 100);
        g.drawString(s, 0, this.bottomMargin / 2 + (this.availableHeight - this.bottomMargin) * 2 / 4);
        s = String.valueOf(this.maxScale - increment * 3);
        s = s.endsWith("00000") ? String.valueOf((this.maxScale - increment * 3) / 100000) + "K" : String.valueOf((this.maxScale - increment * 3) / 100);
        g.drawString(s, 0, this.bottomMargin / 2 + (this.availableHeight - this.bottomMargin) * 3 / 4);
        s = String.valueOf(this.maxScale - increment * 4);
        s = s.endsWith("00000") ? String.valueOf((this.maxScale - increment * 4) / 100000) + "K" : String.valueOf((this.maxScale - increment * 4) / 100);
        g.drawString(s, 0, this.bottomMargin / 2 + (this.availableHeight - this.bottomMargin));
        Date d = d1;
        int dayWidth = (this.availableWidth - this.leftMargin - this.rightMargin) / this.numberOfDays;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        SimpleDateFormat sdf = new SimpleDateFormat("MMM");
        SimpleDateFormat sdf2 = new SimpleDateFormat("dd");
        SimpleDateFormat sdf3 = new SimpleDateFormat("yyyy");
        int lastw = -1;
        int w2 = 0;
        String lasts = "";
        String s1 = "";
        String s2 = "";
        while (true) {
            int w;
            if ((w = this.leftMargin + this.calculateDayDifference(d1, d) * (this.availableWidth - this.leftMargin - this.rightMargin) / this.numberOfDays) <= this.availableWidth - this.rightMargin) {
                g.drawLine(w, this.availableHeight - this.bottomMargin / 2, w, this.availableHeight - this.bottomMargin / 2 + 6 * (int)multiplier);
            }
            if (w - lastw > 20 * (int)multiplier) {
                if (lastw > -1 && w - lastw > 30 * (int)multiplier) {
                    if (dayWidth > 5) {
                        w2 = w - (w - lastw) * 6 / 7;
                        if (w2 <= this.availableWidth - 5) {
                            g.drawLine(w2, this.availableHeight - this.bottomMargin / 2, w2, this.availableHeight - this.bottomMargin / 2 + 3 * (int)multiplier);
                        }
                        if ((w2 = w - (w - lastw) * 5 / 7) <= this.availableWidth - 5) {
                            g.drawLine(w2, this.availableHeight - this.bottomMargin / 2, w2, this.availableHeight - this.bottomMargin / 2 + 3 * (int)multiplier);
                        }
                        if ((w2 = w - (w - lastw) * 4 / 7) <= this.availableWidth - 5) {
                            g.drawLine(w2, this.availableHeight - this.bottomMargin / 2, w2, this.availableHeight - this.bottomMargin / 2 + 3 * (int)multiplier);
                        }
                        if ((w2 = w - (w - lastw) * 3 / 7) <= this.availableWidth - 5) {
                            g.drawLine(w2, this.availableHeight - this.bottomMargin / 2, w2, this.availableHeight - this.bottomMargin / 2 + 3 * (int)multiplier);
                        }
                        if ((w2 = w - (w - lastw) * 2 / 7) <= this.availableWidth - 5) {
                            g.drawLine(w2, this.availableHeight - this.bottomMargin / 2, w2, this.availableHeight - this.bottomMargin / 2 + 3 * (int)multiplier);
                        }
                        if ((w2 = w - (w - lastw) * 1 / 7) <= this.availableWidth - 5) {
                            g.drawLine(w2, this.availableHeight - this.bottomMargin / 2, w2, this.availableHeight - this.bottomMargin / 2 + 3 * (int)multiplier);
                        }
                    } else {
                        w2 = w - (w - lastw) * 3 / 4;
                        if (w2 <= this.availableWidth - 5) {
                            g.drawLine(w2, this.availableHeight - this.bottomMargin / 2, w2, this.availableHeight - this.bottomMargin / 2 + 3 * (int)multiplier);
                        }
                        if ((w2 = w - (w - lastw) * 2 / 4) <= this.availableWidth - 5) {
                            g.drawLine(w2, this.availableHeight - this.bottomMargin / 2, w2, this.availableHeight - this.bottomMargin / 2 + 3 * (int)multiplier);
                        }
                        if ((w2 = w - (w - lastw) * 1 / 4) <= this.availableWidth - 5) {
                            g.drawLine(w2, this.availableHeight - this.bottomMargin / 2, w2, this.availableHeight - this.bottomMargin / 2 + 3 * (int)multiplier);
                        }
                    }
                }
                s = sdf.format(d);
                s1 = sdf2.format(d);
                if (dayWidth > 5 * (int)multiplier) {
                    if (s.length() > 1) {
                        w2 = w - 6 * (int)multiplier;
                        if (w2 <= this.availableWidth - this.rightMargin) {
                            g.drawString(s1, w2, this.availableHeight);
                        }
                    } else {
                        w2 = w - 3 * (int)multiplier;
                        if (w2 <= this.availableWidth - this.rightMargin) {
                            g.drawString(s1, w2, this.availableHeight);
                        }
                    }
                    if (!s.equals(lasts) && (w2 = w - 10 * (int)multiplier) <= this.availableWidth - this.rightMargin) {
                        g.drawString(s, w2, this.availableHeight + this.fontHeight);
                    }
                } else {
                    w2 = w - 3 * (int)multiplier;
                    if (w2 <= this.availableWidth - this.rightMargin) {
                        g.drawString(s.substring(0, 1), w - 3 * (int)multiplier, this.availableHeight);
                    }
                    if (w2 <= this.availableWidth - this.rightMargin) {
                        g.drawString(s.substring(1, 2), w - 3 * (int)multiplier, this.availableHeight + (this.fontHeight - fontAdjustment));
                    }
                    if (w2 <= this.availableWidth - this.rightMargin) {
                        g.drawString(s.substring(2, 3), w - 3 * (int)multiplier, this.availableHeight + 2 * (this.fontHeight - fontAdjustment));
                    }
                }
                lastw = w;
                lasts = s;
            }
            if (d.after(d2)) break;
            calendar.setTime(d);
            if (dayWidth > 5) {
                calendar.add(5, 7);
            } else {
                if (calendar.get(2) == 0 && this.numberOfDays > 365) {
                    s2 = sdf3.format(d);
                    if ((this.availableWidth - this.leftMargin - this.rightMargin) * 365 / this.numberOfDays < 35 * (int)multiplier) {
                        s2 = s2.substring(2);
                    }
                    g.drawString(s2, w - 3 * (int)multiplier, this.availableHeight + 3 * (this.fontHeight - fontAdjustment) + 5 * (int)multiplier);
                }
                calendar.set(5, 1);
                calendar.add(2, 1);
            }
            d = calendar.getTime();
        }
        int currentHeight = 0;
        g.setColor(new Color(255, 255, 0));
        currentHeight = this.bottomMargin / 2;
        g.drawLine(this.leftMargin, currentHeight, this.availableWidth - this.rightMargin, currentHeight);
        currentHeight = this.bottomMargin / 2 + (this.availableHeight - this.bottomMargin) * 1 / 4;
        g.drawLine(this.leftMargin, currentHeight, this.availableWidth - this.rightMargin, currentHeight);
        currentHeight = this.bottomMargin / 2 + (this.availableHeight - this.bottomMargin) * 2 / 4;
        g.drawLine(this.leftMargin, currentHeight, this.availableWidth - this.rightMargin, currentHeight);
        currentHeight = this.bottomMargin / 2 + (this.availableHeight - this.bottomMargin) * 3 / 4;
        g.drawLine(this.leftMargin, currentHeight, this.availableWidth - this.rightMargin, currentHeight);
        if (this.minScale < 0 && this.maxScale > 0) {
            g.setColor(new Color(255, 0, 0));
            currentHeight = (int)((double)(this.availableHeight - this.bottomMargin / 2) - (double)(this.availableHeight - this.bottomMargin) * (double)(0 - this.minScale) / (double)(this.maxScale - this.minScale));
            g.drawLine(this.leftMargin, currentHeight, this.availableWidth - this.rightMargin, currentHeight);
        }
        g.setColor(new Color(0, 0, 0));
        g.drawLine(this.leftMargin, this.bottomMargin / 2, this.leftMargin, this.availableHeight - this.bottomMargin / 2);
        g.drawLine(this.leftMargin, this.availableHeight - this.bottomMargin / 2, this.availableWidth - this.rightMargin, this.availableHeight - this.bottomMargin / 2);
    }

    int calculateDayDifference(Date date1, Date date2) {
        long ld1 = Utilities.longToDays(date1.getTime());
        if (ld1 == 0L) {
            return 0;
        }
        long ld2 = Utilities.longToDays(date2.getTime());
        return (int)(ld2 - ld1);
    }

    int calculateDayDifference(long long1, long long2) {
        long ld1 = Utilities.longToDays(long1);
        if (ld1 == 0L) {
            return 0;
        }
        long ld2 = Utilities.longToDays(long2);
        return (int)(ld2 - ld1);
    }

    void setPositions() {
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        if (this.parent.lineSpacing == 0) {
            this.parent.lineSpacing = this.parent.fontHeight / 5;
        }
        this.lineHeight = this.parent.fontHeight + this.parent.lineSpacing * 2;
        this.numItemsPage = this.height / this.lineHeight - 2;
    }

    @Override
    public void paint(Graphics g) {
        this.setPositions();
        Utilities.enableAntialiasing(g);
        if (this.graphType == 0) {
            this.drawCategoryBlockGraph(g);
        }
        if (this.graphType == 1) {
            this.drawFutureLineGraph(g);
        }
        if (this.graphType == 2) {
            this.drawAccountLineGraph(g);
        }
        if (this.parent.useCanvasMenu && this.showCanvasMenu) {
            this.setupCanvasMenu();
            this.displayCanvasMenu(g);
            return;
        }
    }

    void setupCanvasMenu() {
        this.startMenuPos = 0;
        this.currentMenuPos = 0;
        if (this.graphType == 0) {
            this.canvasMenu = new Vector(5);
            this.canvasMenu.addElement("Home");
            this.canvasMenu.addElement("New Category Graph");
            this.canvasMenu.addElement("New Other Graph");
            this.canvasMenu.addElement("Details");
            this.canvasMenu.addElement("Exit");
            this.menuWidth = this.parent.fm.stringWidth("New Category Graph") + 6;
        }
        if (this.graphType == 1) {
            this.canvasMenu = new Vector(5);
            this.canvasMenu.addElement("Home");
            this.canvasMenu.addElement("New Future Balance Graph");
            this.canvasMenu.addElement("New Other Graph");
            this.canvasMenu.addElement("Future Balances");
            this.canvasMenu.addElement("Exit");
            this.menuWidth = this.parent.fm.stringWidth("New Future Balance Graph") + 6;
        }
        if (this.graphType == 2) {
            this.canvasMenu = new Vector(5);
            this.canvasMenu.addElement("Home");
            this.canvasMenu.addElement("New Account Graph");
            this.canvasMenu.addElement("New Other Graph");
            this.canvasMenu.addElement("Account Balances");
            this.canvasMenu.addElement("Exit");
            this.menuWidth = this.parent.fm.stringWidth("New Account Graph") + 6;
        }
    }

    void displayCanvasMenu(Graphics g) {
        this.numMenuItems = this.canvasMenu.size();
        this.menuWidthPos = (this.width - this.menuWidth) / 2;
        if (this.menuWidthPos < 0) {
            this.menuWidthPos = 0;
        }
        this.menuHeightPos = (this.height - this.lineHeight * 2 - this.numMenuItems * this.lineHeight) / 2;
        if (this.menuHeightPos < this.lineHeight) {
            this.menuHeightPos = this.lineHeight;
        }
        this.menuHeight = Math.min(this.height - this.lineHeight * 2, this.numMenuItems * this.lineHeight);
        g.setColor(new Color(this.parent.colorMessage));
        g.fillRect(this.menuWidthPos, this.menuHeightPos, this.menuWidth, this.menuHeight);
        g.setColor(new Color(this.parent.colorFont));
        g.setFont(this.parent.font);
        for (int i = 0; i < this.numItemsPage && i + this.startMenuPos <= this.numMenuItems - 1; ++i) {
            int vpos = i * this.lineHeight + this.lineHeight + this.menuHeightPos - this.parent.lineSpacing - this.parent.fm.getMaxDescent() + this.parent.fontAdjustment;
            g.drawString((String)this.canvasMenu.elementAt(i + this.startMenuPos), this.menuWidthPos + 3, vpos);
        }
        g.setFont(this.font);
    }

    void processMenuCommand(int k) {
        this.invalidate();
        this.commandAction((String)this.canvasMenu.elementAt(k + this.startMenuPos));
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.parent.setTitle(this.parent.version + ", Filename: " + this.parent.getShortFileName());
            this.parent.setContentView(this.parent.av);
            this.graphType = -1;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    void displayPopupMenu() {
        int y;
        int x;
        MenuItem miExit;
        MenuItem miNewOtherGraph;
        MenuItem miHome;
        Font font;
        PopupMenu pm;
        if (this.graphType == 0) {
            if (this.showingPopupMenu) {
                this.showingPopupMenu = false;
                return;
            }
            pm = new PopupMenu();
            font = new Font(this.parent.fontName, this.parent.fontWeight, this.parent.fontSize);
            pm.setFont(font);
            miHome = new MenuItem("Home");
            MenuItem miNewIncomeExpenseGraph = new MenuItem("New Category Graph");
            miNewOtherGraph = new MenuItem("New Other Graph");
            MenuItem miTopExpenses = new MenuItem("Details");
            miExit = new MenuItem("Exit");
            miHome.addActionListener(this);
            miNewIncomeExpenseGraph.addActionListener(this);
            miNewOtherGraph.addActionListener(this);
            miTopExpenses.addActionListener(this);
            miExit.addActionListener(this);
            pm.add(miHome);
            pm.add(miNewIncomeExpenseGraph);
            pm.add(miNewOtherGraph);
            pm.add(miTopExpenses);
            pm.add(miExit);
            this.add(pm);
            x = 0;
            y = 0;
            if (this.point == null) {
                pm.show(this, x, y);
            } else {
                y = this.movePopup(2, y);
                pm.show(this, x + this.point.x, y + this.point.y);
            }
            this.showingPopupMenu = true;
        }
        if (this.graphType == 1) {
            if (this.showingPopupMenu) {
                this.showingPopupMenu = false;
                return;
            }
            pm = new PopupMenu();
            font = new Font(this.parent.fontName, this.parent.fontWeight, this.parent.fontSize);
            pm.setFont(font);
            miHome = new MenuItem("Home");
            MenuItem miNewFutureBalanceGraph = new MenuItem("New Future Balance Graph");
            miNewOtherGraph = new MenuItem("New Other Graph");
            MenuItem miFutureBalances = new MenuItem("Future Balances");
            miExit = new MenuItem("Exit");
            miHome.addActionListener(this);
            miNewFutureBalanceGraph.addActionListener(this);
            miNewOtherGraph.addActionListener(this);
            miFutureBalances.addActionListener(this);
            miExit.addActionListener(this);
            pm.add(miHome);
            pm.add(miNewFutureBalanceGraph);
            pm.add(miNewOtherGraph);
            pm.add(miFutureBalances);
            pm.add(miExit);
            this.add(pm);
            x = 0;
            y = 0;
            if (this.point == null) {
                pm.show(this, x, y);
            } else {
                y = this.movePopup(2, y);
                pm.show(this, x + this.point.x, y + this.point.y);
            }
            this.showingPopupMenu = true;
        }
        if (this.graphType == 2) {
            if (this.showingPopupMenu) {
                this.showingPopupMenu = false;
                return;
            }
            pm = new PopupMenu();
            font = new Font(this.parent.fontName, this.parent.fontWeight, this.parent.fontSize);
            pm.setFont(font);
            miHome = new MenuItem("Home");
            MenuItem miNewAccountGraph = new MenuItem("New Account Graph");
            miNewOtherGraph = new MenuItem("New Other Graph");
            MenuItem miAccountBalances = new MenuItem("Account Balances");
            miExit = new MenuItem("Exit");
            miHome.addActionListener(this);
            miNewAccountGraph.addActionListener(this);
            miNewOtherGraph.addActionListener(this);
            miAccountBalances.addActionListener(this);
            miExit.addActionListener(this);
            pm.add(miHome);
            pm.add(miNewAccountGraph);
            pm.add(miNewOtherGraph);
            pm.add(miAccountBalances);
            pm.add(miExit);
            this.add(pm);
            x = 0;
            y = 0;
            if (this.point == null) {
                pm.show(this, x, y);
            } else {
                y = this.movePopup(2, y);
                pm.show(this, x + this.point.x, y + this.point.y);
            }
            this.showingPopupMenu = true;
        }
    }

    int movePopup(int n, int y) {
        int popupHeight = n * this.fontHeight * 4 / 3;
        if (y + this.point.y + popupHeight > this.height) {
            y = this.height - popupHeight - this.point.y;
        }
        return y;
    }

    void commandAction(String cmd) {
        SimpleDateFormat sdf;
        Font font;
        DialogManager dm;
        this.showingPopupMenu = false;
        if (cmd.equals("Home")) {
            this.parent.setTitle(this.parent.version + ", Filename: " + this.parent.getShortFileName());
            this.parent.setContentView(this.parent.av);
            this.graphType = -1;
        }
        if (cmd.equals("New Category Graph")) {
            this.graphType = 0;
            this.parent.gf.prepareGetTopCategories();
            return;
        }
        if (cmd.equals("New Future Balance Graph")) {
            this.graphType = 1;
            this.parent.gf.prepareFutureGraph();
            return;
        }
        if (cmd.equals("New Account Graph")) {
            this.graphType = 2;
            this.parent.gf.prepareAccountGraph();
            return;
        }
        if (cmd.equals("New Other Graph")) {
            this.parent.gf.start();
            return;
        }
        if (cmd.equals("Details")) {
            this.parent.gd = new GraphDetails(this.parent);
            this.parent.gd.showGraphDetails();
            this.parent.setContentView(this.parent.gd);
            return;
        }
        if (cmd.equals("Future Balances")) {
            dm = new DialogManager(this.parent, "Future Balances");
            font = new Font(this.parent.fontName, this.parent.fontWeight, this.parent.fontSize);
            dm.setFont(font);
            sdf = null;
            if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
                sdf = new SimpleDateFormat("dd/MM/yyyy");
            }
            if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
                sdf = new SimpleDateFormat("MM/dd/yyyy");
            }
            String s = Utilities.numberToString(Math.abs(this.a.today), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            s = this.a.today >= 0 ? s + " CR" : s + " DR";
            dm.addText("Today's balance:", s);
            s = Utilities.numberToString(Math.abs(this.finishingBalance), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            s = this.finishingBalance >= 0 ? s + " CR" : s + " DR";
            dm.addText("Balance @ " + sdf.format(this.toDate) + ":", s);
            s = Utilities.numberToString(Math.abs(this.minSize), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            s = this.minSize >= 0 ? s + " CR" : s + " DR";
            dm.addText("Minimum @ " + sdf.format(this.minDate) + ":", s);
            s = Utilities.numberToString(Math.abs(this.maxSize), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            s = this.maxSize >= 0 ? s + " CR" : s + " DR";
            dm.addText("Maximum @ " + sdf.format(this.maxDate) + ":", s);
            dm.addButton("OK");
            dm.centerShow();
            dm.dispose();
        }
        if (cmd.equals("Account Balances")) {
            dm = new DialogManager(this.parent, "Account Balances");
            font = new Font(this.parent.fontName, this.parent.fontWeight, this.parent.fontSize);
            dm.setFont(font);
            sdf = null;
            if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
                sdf = new SimpleDateFormat("dd/MM/yyyy");
            }
            if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
                sdf = new SimpleDateFormat("MM/dd/yyyy");
            }
            String s1 = "Opening balance:";
            Hashtable ht = (Hashtable)this.parent.transactionHt.get(this.a.name);
            long lDate = ((LongId)ht.get((Object)new Integer((int)(ht.size() - 1)))).lo;
            if (this.fromDate.after(new Date(lDate))) {
                s1 = "Balance @ " + sdf.format(this.fromDate) + ":";
            }
            String s = Utilities.numberToString(Math.abs(this.openingBalance), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            s = this.openingBalance >= 0 ? s + " CR" : s + " DR";
            dm.addText(s1, s);
            s = Utilities.numberToString(Math.abs(this.finishingBalance), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            s = this.finishingBalance >= 0 ? s + " CR" : s + " DR";
            dm.addText("Balance @ " + sdf.format(this.toDate) + ":", s);
            s = Utilities.numberToString(Math.abs(this.minSize), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            s = this.minSize >= 0 ? s + " CR" : s + " DR";
            dm.addText("Minimum @ " + sdf.format(this.minDate) + ":", s);
            s = Utilities.numberToString(Math.abs(this.maxSize), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            s = this.maxSize >= 0 ? s + " CR" : s + " DR";
            dm.addText("Maximum @ " + sdf.format(this.maxDate) + ":", s);
            dm.addButton("OK");
            dm.centerShow();
            dm.dispose();
        }
        if (cmd.equals("Exit")) {
            this.parent.finishAndQuit();
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int j;
        String s = ae.getSource().toString();
        String s1 = s.substring((j = s.indexOf("[")) + 1, j + 5);
        if (s1.equals("menu")) {
            MenuItem mi = (MenuItem)ae.getSource();
            this.commandAction(mi.getLabel());
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        this.calculateCanvasMenuPosition = true;
        if (this.showCanvasMenu) {
            this.calculateCanvasMenuPosition = false;
            this.currentMenuPos = (y - this.menuHeightPos) / this.lineHeight;
            this.repaint();
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        if (this.showCanvasMenu) {
            this.showCanvasMenu = false;
            this.repaint();
            if (x < this.menuWidthPos || x > this.menuWidthPos + this.menuWidth || y < this.menuHeightPos || y > this.menuHeightPos + this.menuHeight) {
                this.setupCanvasMenu();
                return;
            }
            int k = (y - this.menuHeightPos) / this.lineHeight + this.startMenuPos;
            this.processMenuCommand(k);
            return;
        }
        if (this.parent.useCanvasMenu) {
            this.showCanvasMenu = true;
            this.repaint();
        } else {
            this.displayPopupMenu();
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.point = me.getPoint();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.point = me.getPoint();
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.point = me.getPoint();
    }
}

