/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Frame;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.AccountStore;
import org.freepoc.Jabp4.Category;
import org.freepoc.Jabp4.CategoryStore;
import org.freepoc.Jabp4.DateChooser;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.GraphView;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.LongId;
import org.freepoc.Jabp4.Sort;
import org.freepoc.Jabp4.StandingOrder;
import org.freepoc.Jabp4.StandingOrderStore;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.TransactionStore;
import org.freepoc.Jabp4.Utilities;

public class GraphForm
extends Component {
    Jabp parent;
    Date fromDate;
    Date toDate;
    Date maxDate;
    Date minDate;
    Vector v;
    Vector vdate;
    Vector vamount;
    Account a;
    int total;
    int openingBalance;
    int finishingBalance;
    int graphType;
    int maxSize;
    int minSize;
    int numberOfItems;
    int numberOfDays;
    boolean isExpenses = true;

    public GraphForm(Jabp context) {
        this.parent = context;
    }

    void start() {
        this.graphType = -1;
        int chooseGraphType = -1;
        DialogManager dm = new DialogManager(this.parent, "Graph type");
        dm.addText("The Category graph can be for expense categories");
        dm.addText("or income categories; a further Details screen");
        dm.addText("can be selected once the graph is displayed");
        dm.addText("");
        dm.addText("The Future Balance graph is calculated from future");
        dm.addText(" transactions and standing orders for up to a year");
        dm.addText("in the future");
        dm.addText("");
        dm.addText("The Account graph shows historical balances between ");
        dm.addText("your specified dates");
        dm.addText("");
        CheckboxGroup cbGraphType = dm.addCheckboxGroup();
        dm.addCheckboxItem("Graph:", "Category", true, "Future Balance", false, "Account", false, cbGraphType);
        dm.addOKCancelButtons();
        dm.centerShow();
        if (!dm.checkButtons()) {
            dm.dispose();
            this.parent.setContentView(this.parent.av);
            this.graphType = -1;
            return;
        }
        if (dm.getSelectedCheckbox(cbGraphType).getLabel().equals("Category")) {
            chooseGraphType = 0;
        }
        if (dm.getSelectedCheckbox(cbGraphType).getLabel().equals("Future Balance")) {
            chooseGraphType = 1;
        }
        if (dm.getSelectedCheckbox(cbGraphType).getLabel().equals("Account")) {
            chooseGraphType = 2;
        }
        dm.dispose();
        this.setFromAndToDates();
        if (chooseGraphType == 0) {
            this.prepareGetTopCategories();
        }
        if (chooseGraphType == 1) {
            this.prepareFutureGraph();
        }
        if (chooseGraphType == 2) {
            this.prepareAccountGraph();
        }
    }

    void prepareGetTopCategories() {
        DialogManager dm = new DialogManager(this.parent, "Choose settings");
        CheckboxGroup cbCategoryType = dm.addCheckboxGroup();
        dm.addCheckboxItem("Category", "Expenses", this.isExpenses, "Income", !this.isExpenses, cbCategoryType);
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf2 = null;
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf2 = new SimpleDateFormat("dd/MM/yy HH");
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            sdf = new SimpleDateFormat("MM/dd/yyyy");
            sdf2 = new SimpleDateFormat("MM/dd/yy HH");
        }
        JTextField textDate1 = dm.addJTextFieldWithButton("From date", sdf.format(this.fromDate), "1>");
        JTextField textDate2 = dm.addJTextFieldWithButton("To date", sdf.format(this.toDate), "2>");
        dm.addOKCancelButtons();
        dm.centerShow();
        if (!dm.checkButtons()) {
            dm.dispose();
            this.parent.setContentView(this.parent.av);
            this.graphType = -1;
            return;
        }
        this.graphType = 0;
        this.isExpenses = dm.getSelectedCheckbox(cbCategoryType).getLabel().equals("Expenses");
        try {
            this.fromDate = sdf2.parse(dm.getUserText(textDate1) + " 02");
            this.toDate = sdf2.parse(dm.getUserText(textDate2) + " 02");
        }
        catch (ParseException pe) {
            this.fromDate = new Date();
            this.toDate = new Date();
        }
        if (dm.checkButtonText().equals("1>")) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(this.fromDate);
            DateChooser dc = new DateChooser((Frame)this.parent, gc);
            if (dc.showDateChooser() == 1) {
                gc = dc.getDate();
            }
            this.fromDate = gc.getTime();
            this.prepareGetTopCategories();
            return;
        }
        if (dm.checkButtonText().equals("2>")) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(this.toDate);
            DateChooser dc = new DateChooser((Frame)this.parent, gc);
            if (dc.showDateChooser() == 1) {
                gc = dc.getDate();
            }
            this.toDate = gc.getTime();
            this.prepareGetTopCategories();
            return;
        }
        dm.dispose();
        this.getTopCategoriesByDate();
    }

    void prepareAccountGraph() {
        DialogManager dm = new DialogManager(this.parent, "Choose account");
        JComboBox account = dm.addJComboBox("Account");
        AccountStore as = this.parent.av.as;
        int n = as.getNumAccounts();
        for (int i = 0; i < n; ++i) {
            Account a1 = as.getAccountFromIndex(i);
            dm.addJComboBoxItem(account, a1.name);
        }
        dm.setSelectedJComboBox(account, this.parent.lastAccount);
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf2 = null;
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf2 = new SimpleDateFormat("dd/MM/yy HH");
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            sdf = new SimpleDateFormat("MM/dd/yyyy");
            sdf2 = new SimpleDateFormat("MM/dd/yy HH");
        }
        JTextField textDate1 = dm.addJTextFieldWithButton("From date", sdf.format(this.fromDate), "1>");
        JTextField textDate2 = dm.addJTextFieldWithButton("To date", sdf.format(this.toDate), "2>");
        dm.addOKCancelButtons();
        dm.centerShow();
        if (!dm.checkButtons()) {
            dm.dispose();
            this.parent.setContentView(this.parent.av);
            this.graphType = -1;
            return;
        }
        this.graphType = 2;
        this.parent.lastAccount = dm.getSelectedJComboBoxString(account);
        this.a = as.getAccountFromName(this.parent.lastAccount);
        try {
            this.fromDate = sdf2.parse(dm.getUserText(textDate1) + " 02");
            this.toDate = sdf2.parse(dm.getUserText(textDate2) + " 02");
        }
        catch (ParseException pe) {
            this.fromDate = new Date();
            this.toDate = new Date();
        }
        if (dm.checkButtonText().equals("1>")) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(this.fromDate);
            DateChooser dc = new DateChooser((Frame)this.parent, gc);
            if (dc.showDateChooser() == 1) {
                gc = dc.getDate();
            }
            this.fromDate = gc.getTime();
            this.prepareAccountGraph();
            return;
        }
        if (dm.checkButtonText().equals("2>")) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(this.toDate);
            DateChooser dc = new DateChooser((Frame)this.parent, gc);
            if (dc.showDateChooser() == 1) {
                gc = dc.getDate();
            }
            this.toDate = gc.getTime();
            this.prepareAccountGraph();
            return;
        }
        dm.dispose();
        if (this.parent.tv != null) {
            this.parent.tv.ts.closeTransactionStore();
            this.parent.tv = null;
        }
        TransactionStore ts = new TransactionStore(this.parent, this.a, true);
        ts.getIndex(this.a);
        n = ts.ht.size();
        if (n == 0) {
            ts.closeTransactionStore();
            Toast.makeText(this.parent, "No entries in account", 2000).show();
            this.start();
            return;
        }
        int i1 = n - 1;
        int i2 = 0;
        if (!ts.normalSortOrder) {
            i1 = 0;
            i2 = n - 1;
        }
        Date d1 = new Date(ts.getTransactionFromIndex((int)i1).longDate);
        Date d2 = new Date(ts.getTransactionFromIndex((int)i2).longDate);
        if (this.fromDate.after(d1)) {
            d1 = this.fromDate;
        }
        if (this.toDate.before(d2)) {
            d2 = this.toDate;
        }
        this.numberOfDays = this.calculateDayDifference(d1, d2);
        if (this.numberOfDays <= 2) {
            ts.closeTransactionStore();
            Toast.makeText(this.parent, "Not enough days to graph", 2000).show();
            this.start();
            return;
        }
        this.maxSize = this.a.open;
        this.minSize = this.a.open;
        int runningTotal = this.a.open;
        int dayTotal = 0;
        long longDate = 0L;
        int k = n - 1;
        if (!ts.normalSortOrder) {
            k = 0;
        }
        this.maxDate = this.minDate = new Date(ts.getTransactionFromIndex((int)k).longDate);
        for (int i = 0; i < n; ++i) {
            int j = n - 1 - i;
            if (!ts.normalSortOrder) {
                j = i;
            }
            Transaction t = ts.getTransactionFromIndex(j);
            if (Utilities.longToDays(t.longDate) < Utilities.longToDays(this.fromDate.getTime())) {
                dayTotal += t.amount;
                continue;
            }
            if (Utilities.longToDays(t.longDate) > Utilities.longToDays(this.toDate.getTime())) continue;
            if (Utilities.longToDays(t.longDate) != Utilities.longToDays(longDate)) {
                if ((runningTotal += dayTotal) > this.maxSize) {
                    this.maxSize = runningTotal;
                    this.maxDate = new Date(longDate);
                }
                if (runningTotal < this.minSize) {
                    this.minSize = runningTotal;
                    this.minDate = new Date(longDate);
                }
                dayTotal = t.amount;
                longDate = t.longDate;
                continue;
            }
            dayTotal += t.amount;
        }
        ts.closeTransactionStore();
        if ((runningTotal += dayTotal) > this.maxSize) {
            this.maxSize = runningTotal;
            this.maxDate = new Date(longDate);
        }
        if (runningTotal < this.minSize) {
            this.minSize = runningTotal;
            this.minDate = new Date(longDate);
        }
        this.finishingBalance = runningTotal;
        if (this.maxSize == this.minSize) {
            Toast.makeText(this.parent, "Minimum & maximum values identical", 2000).show();
            this.start();
            return;
        }
        this.parent.gv = new GraphView(this.parent);
        this.parent.setContentView(this.parent.gv);
    }

    void prepareFutureGraph() {
        DialogManager dm = new DialogManager(this.parent, "Choose account");
        JComboBox account = dm.addJComboBox("Account");
        AccountStore as = this.parent.av.as;
        int n = as.getNumAccounts();
        for (int i = 0; i < n; ++i) {
            this.a = as.getAccountFromIndex(i);
            dm.addJComboBoxItem(account, this.a.name);
        }
        dm.setSelectedJComboBox(account, this.parent.lastAccount);
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf2 = null;
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf2 = new SimpleDateFormat("dd/MM/yy HH");
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            sdf = new SimpleDateFormat("MM/dd/yyyy");
            sdf2 = new SimpleDateFormat("MM/dd/yy HH");
        }
        JTextField textDate2 = dm.addJTextFieldWithButton("To date", sdf.format(this.toDate));
        dm.addOKCancelButtons();
        dm.centerShow();
        if (!dm.checkButtons()) {
            dm.dispose();
            this.parent.setContentView(this.parent.av);
            this.graphType = -1;
            return;
        }
        this.graphType = 1;
        this.parent.lastAccount = dm.getSelectedJComboBoxString(account);
        this.a = as.getAccountFromName(this.parent.lastAccount);
        try {
            this.toDate = sdf2.parse(dm.getUserText(textDate2) + " 02");
        }
        catch (ParseException pe) {
            this.toDate = new Date();
        }
        if (dm.checkButtonText().equals(">")) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(this.toDate);
            DateChooser dc = new DateChooser((Frame)this.parent, gc);
            if (dc.showDateChooser() == 1) {
                gc = dc.getDate();
            }
            this.toDate = gc.getTime();
            this.prepareFutureGraph();
            return;
        }
        dm.dispose();
        Date today = new Date();
        if (this.calculateDayDifference(today, this.toDate) > 365) {
            Toast.makeText(this.parent, "Too far in the future", 2000).show();
            this.start();
            return;
        }
        if (this.calculateDayDifference(today, this.toDate) < 1) {
            Toast.makeText(this.parent, "Please specify a future date", 2000).show();
            this.start();
            return;
        }
        this.vdate = new Vector();
        this.vamount = new Vector();
        this.vdate.addElement(today);
        this.vamount.addElement(new Integer(0));
        this.vdate.addElement(this.toDate);
        this.vamount.addElement(new Integer(0));
        if (this.parent.tv != null) {
            this.parent.tv.ts.closeTransactionStore();
            this.parent.tv = null;
        }
        TransactionStore ts = new TransactionStore(this.parent, this.a, true);
        ts.getIndex(this.a);
        n = ts.ht.size();
        for (int i = 0; i < n; ++i) {
            int j = i;
            if (!ts.normalSortOrder) {
                j = n - 1 - i;
            }
            Transaction t = ts.getTransactionFromIndex(j);
            if (Utilities.longToDays(t.longDate) <= Utilities.longToDays(today.getTime())) break;
            if (Utilities.longToDays(t.longDate) < Utilities.longToDays(today.getTime()) || Utilities.longToDays(t.longDate) > Utilities.longToDays(this.toDate.getTime())) continue;
            this.vdate.addElement(new Date(t.longDate));
            this.vamount.addElement(new Integer(t.amount));
        }
        ts.closeTransactionStore();
        if (this.parent.sov != null) {
            this.parent.sov.sos.closeStandingOrderStore();
            this.parent.sov = null;
        }
        StandingOrderStore sos = new StandingOrderStore(this.parent, true);
        long futureDate = Utilities.longToDays(this.toDate.getTime());
        StandingOrder so = null;
        sos.setToStart();
        block4: while ((so = sos.readNextStandingOrder()) != null) {
            if (!so.account.equals(this.a.name)) continue;
            while (Utilities.longToDays(so.longProcessingDate) <= futureDate) {
                this.vdate.addElement(new Date(so.longProcessingDate));
                this.vamount.addElement(new Integer(so.amount));
                so.longProcessingDate = sos.nextProcessingDate(so);
                if (Utilities.longToDays(so.longProcessingDate) <= Utilities.longToDays(so.longEndDate)) continue;
                continue block4;
            }
        }
        sos.closeStandingOrderStore();
        if (this.vdate.size() < 2) {
            Toast.makeText(this.parent, "Too few future entries", 2000).show();
            this.start();
            return;
        }
        Sort.sortDateAmount(this.vdate, this.vamount, 0, this.vdate.size() - 1, true);
        this.maxSize = this.a.today;
        this.minSize = this.a.today;
        this.maxDate = today;
        this.minDate = today;
        int runningTotal = this.a.today;
        int dayTotal = 0;
        Date date = new Date(0L);
        for (int i = 0; i < this.vdate.size(); ++i) {
            Date tdate = (Date)this.vdate.elementAt(i);
            int tamount = (Integer)this.vamount.elementAt(i);
            if (Utilities.longToDays(tdate.getTime()) != Utilities.longToDays(date.getTime())) {
                if ((runningTotal += dayTotal) > this.maxSize) {
                    this.maxSize = runningTotal;
                    this.maxDate = date;
                }
                if (runningTotal < this.minSize) {
                    this.minSize = runningTotal;
                    this.minDate = date;
                }
                dayTotal = tamount;
                date = tdate;
                continue;
            }
            dayTotal += tamount;
        }
        if ((runningTotal += dayTotal) > this.maxSize) {
            this.maxSize = runningTotal;
            this.maxDate = date;
        }
        if (runningTotal < this.minSize) {
            this.minSize = runningTotal;
            this.minDate = date;
        }
        this.finishingBalance = runningTotal;
        if (this.maxSize == this.minSize) {
            Toast.makeText(this.parent, "Minimum & maximum values identical", 2000).show();
            this.start();
            return;
        }
        this.parent.gv = new GraphView(this.parent);
        this.parent.setContentView(this.parent.gv);
    }

    void getTopCategoriesByDate() {
        if (this.parent.tv != null) {
            this.parent.tv.ts.closeTransactionStore();
            this.parent.tv = null;
        }
        TransactionStore ts = new TransactionStore(this.parent, new Account(), true);
        Vector v1 = ts.buildCategoriesFromDates(this.fromDate, this.toDate, new Account(), true);
        ts.closeTransactionStore();
        this.total = 0;
        this.numberOfItems = 0;
        this.v = new Vector();
        CategoryStore cs = null;
        cs = this.parent.cv == null ? new CategoryStore(this.parent, true) : this.parent.cv.cs;
        Category c = null;
        int n = cs.getNumCategories();
        for (int i = 0; i < n; ++i) {
            c = cs.getCategoryFromIndex(i);
            c.current = (Integer)v1.elementAt(i);
            if ((c.current <= 0 || !this.isExpenses) && (c.current >= 0 || this.isExpenses)) continue;
            this.v.addElement(c);
            this.total += c.current;
            ++this.numberOfItems;
        }
        if (this.parent.cv == null) {
            cs.closeCategoryStore();
        }
        if (Math.abs(this.total) < 0) {
            Toast.makeText(this.parent, "Expense category total is zero", 2000).show();
            this.start();
            return;
        }
        if (this.numberOfItems < 2) {
            Toast.makeText(this.parent, "Less than two expense categories", 2000).show();
            this.start();
            return;
        }
        Sort.sortCategoryBySize(this.v, 0, this.numberOfItems - 1, this.isExpenses);
        this.parent.gv = new GraphView(this.parent);
        this.parent.setContentView(this.parent.gv);
    }

    void setFromAndToDates() {
        long longFromDate = new Date().getTime();
        long longToDate = 0L;
        Enumeration e = this.parent.transactionHt.elements();
        while (e.hasMoreElements()) {
            Hashtable ht = (Hashtable)e.nextElement();
            int n = ht.size();
            if (n <= 0) continue;
            if (((LongId)ht.get((Object)new Integer((int)0))).lo < ((LongId)ht.get((Object)new Integer((int)(n - 1)))).lo) {
                longFromDate = Math.min(longFromDate, ((LongId)ht.get((Object)new Integer((int)0))).lo);
                longToDate = Math.max(longToDate, ((LongId)ht.get((Object)new Integer((int)(n - 1)))).lo);
                continue;
            }
            longFromDate = Math.min(longFromDate, ((LongId)ht.get((Object)new Integer((int)(n - 1)))).lo);
            longToDate = Math.max(longToDate, ((LongId)ht.get((Object)new Integer((int)0))).lo);
        }
        this.fromDate = new Date(longFromDate);
        this.toDate = new Date(longToDate);
    }

    int calculateDayDifference(Date date1, Date date2) {
        long ld1 = Utilities.longToDays(date1.getTime());
        if (ld1 == 0L) {
            return 0;
        }
        long ld2 = Utilities.longToDays(date2.getTime());
        return (int)(ld2 - ld1);
    }

    int calculateDayDifference(long long1, long long2) {
        long ld1 = Utilities.longToDays(long1);
        if (ld1 == 0L) {
            return 0;
        }
        long ld2 = Utilities.longToDays(long2);
        return (int)(ld2 - ld1);
    }
}

