/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.freepoc.Jabp4.Category;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.Sort;
import org.freepoc.Jabp4.Utilities;

public class GraphDetails
extends JPanel
implements KeyListener {
    Jabp parent;
    JButton okButton;
    JButton sortButton1;
    JButton sortButton2;
    JButton datesButton;
    JTextPane textPane;
    Vector v;
    int numberOfItems;
    int total;
    boolean sortBySizeFlag = true;
    boolean showMonthlyFlag = false;

    public GraphDetails(Jabp context) {
        this.parent = context;
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.textPane);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraphDetails.this.total > 0) {
                    Sort.sortCategoryBySize(GraphDetails.this.v, 0, GraphDetails.this.numberOfItems - 1, true);
                } else {
                    Sort.sortCategoryBySize(GraphDetails.this.v, 0, GraphDetails.this.numberOfItems - 1, false);
                }
                GraphDetails.this.parent.setContentView(GraphDetails.this.parent.gv);
            }
        });
        this.sortButton1 = new JButton("Alpha");
        this.sortButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraphDetails.this.sortBySizeFlag) {
                    Sort.sortCategoryByName(GraphDetails.this.v, 0, GraphDetails.this.numberOfItems - 1, false);
                    GraphDetails.this.sortButton1.setText("Size");
                } else {
                    if (GraphDetails.this.total > 0) {
                        Sort.sortCategoryBySize(GraphDetails.this.v, 0, GraphDetails.this.numberOfItems - 1, true);
                    } else {
                        Sort.sortCategoryBySize(GraphDetails.this.v, 0, GraphDetails.this.numberOfItems - 1, false);
                    }
                    GraphDetails.this.sortButton1.setText("Alpha");
                }
                GraphDetails.this.sortBySizeFlag = !GraphDetails.this.sortBySizeFlag;
                GraphDetails.this.textPane.setText("");
                GraphDetails.this.showGraphDetails();
            }
        });
        this.sortButton2 = new JButton("Monthly");
        this.sortButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraphDetails.this.showMonthlyFlag) {
                    GraphDetails.this.sortButton2.setText("Monthly");
                } else {
                    GraphDetails.this.sortButton2.setText("Total");
                }
                GraphDetails.this.showMonthlyFlag = !GraphDetails.this.showMonthlyFlag;
                GraphDetails.this.textPane.setText("");
                GraphDetails.this.showGraphDetails();
            }
        });
        this.datesButton = new JButton("Dates");
        this.datesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDetails.this.parent.gf.prepareGetTopCategories();
            }
        });
        this.addKeyListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)scrollPane, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridy = 1;
        JPanel panel = new JPanel();
        panel.add(this.okButton);
        panel.add(this.sortButton1);
        panel.add(this.sortButton2);
        panel.add(this.datesButton);
        this.add((Component)panel, gbc);
        this.parent.pack();
    }

    void showGraphDetails() {
        this.append("Graph Details\n\n", Color.BLUE, 20);
        this.numberOfItems = this.parent.gv.numberOfItems;
        this.total = this.parent.gv.total;
        this.v = this.parent.gv.v;
        String s = "";
        s = this.showMonthlyFlag ? "Average Monthly " : "Total ";
        s = this.total > 0 ? s + "Expenses" : s + "Income";
        int days = this.parent.gv.calculateDayDifference(this.parent.gv.fromDate, this.parent.gv.toDate) + 1;
        int adjTotal = Math.abs(this.total);
        if (this.showMonthlyFlag) {
            adjTotal = (int)Math.rint((double)adjTotal * 30.0 / (double)days);
        }
        this.append(s + ": " + Utilities.numberToString(adjTotal, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + " (Days: " + days + ")" + "\n");
        for (int i = 0; i < this.numberOfItems; ++i) {
            int current = Math.abs(((Category)this.v.elementAt((int)i)).current);
            if (this.showMonthlyFlag) {
                current = (int)Math.rint((double)current * 30.0 / (double)days);
            }
            int j = (int)Math.rint((double)current * 1000.0 / (double)adjTotal);
            s = Utilities.decimalToString(j, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, 1);
            String s1 = "";
            if (this.sortBySizeFlag && i < 10) {
                s1 = " (" + this.parent.gv.letters.substring(i, i + 1) + ")";
            }
            String s2 = ((Category)this.v.elementAt((int)i)).name;
            this.append("\n" + String.format("%1$-16.16s", s2) + "  " + String.format("%1$15s", Utilities.numberToString(current, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed)) + " " + String.format("%1$5s", s) + "%" + s1, 16, true);
        }
        this.textPane.setCaretPosition(0);
    }

    void append(String msg) {
        this.append(msg, Color.BLACK, 16, false);
    }

    void append(String msg, Color color) {
        this.append(msg, color, 16, false);
    }

    void append(String msg, boolean monospaced) {
        this.append(msg, Color.BLACK, 16, monospaced);
    }

    void append(String msg, int fontSize, boolean monospaced) {
        this.append(msg, Color.BLACK, fontSize, monospaced);
    }

    void append(String msg, Color color, int fontSize) {
        this.append(msg, color, fontSize, false);
    }

    void append(String msg, Color color, int fontSize, boolean monospaced) {
        SimpleAttributeSet attributes = new SimpleAttributeSet(this.textPane.getInputAttributes());
        StyleConstants.setForeground(attributes, color);
        StyleConstants.setFontSize(attributes, fontSize);
        if (monospaced) {
            StyleConstants.setFontFamily(attributes, "Monospaced");
        }
        try {
            this.textPane.getStyledDocument().insertString(this.textPane.getDocument().getLength(), msg, attributes);
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.parent.setContentView(this.parent.gv);
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

