/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.Category;
import org.freepoc.Jabp4.CategoryStore;
import org.freepoc.Jabp4.Currency;
import org.freepoc.Jabp4.CurrencyStore;
import org.freepoc.Jabp4.ImportExportForm;
import org.freepoc.Jabp4.Investment;
import org.freepoc.Jabp4.InvestmentStore;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.Regular;
import org.freepoc.Jabp4.RegularStore;
import org.freepoc.Jabp4.Split;
import org.freepoc.Jabp4.StandingOrder;
import org.freepoc.Jabp4.StandingOrderStore;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.TransactionStore;
import org.freepoc.Jabp4.Utilities;

public class GenericShowForm
extends JPanel
implements KeyListener {
    Jabp parent;
    JTextPane genericShow;
    Account a;
    Category c;
    Transaction t;
    Regular r;
    StandingOrder so;
    Investment inv;
    Currency ccy;
    int type;

    public GenericShowForm(Jabp context, Object object, int type1) {
        this.parent = context;
        this.parent.lastUsedScreen = 20;
        this.genericShow = new JTextPane();
        this.genericShow.setEditable(false);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.genericShow);
        JButton button = new JButton("Done");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericShowForm.this.processDoneButton();
            }
        });
        this.addKeyListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)scrollPane, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridy = 1;
        this.add((Component)button, gbc);
        this.parent.pack();
        this.type = type1;
        switch (this.type) {
            case 0: {
                this.a = (Account)object;
                this.append("Show Account\n\n", Color.BLUE, 20);
                this.append("Name: " + this.a.name + "\n\nDescription: " + this.a.description + "\n\nOpening balance: " + Utilities.numberToString(Math.abs(this.a.open), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed));
                if (this.a.open < 0) {
                    this.append(" DR");
                } else {
                    this.append(" CR");
                }
                this.append("\n\nCurrent balance: " + Utilities.numberToString(Math.abs(this.a.current), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed));
                if (this.a.current < 0) {
                    this.append(" DR");
                } else {
                    this.append(" CR");
                }
                this.append("\n\nToday balance: " + Utilities.numberToString(Math.abs(this.a.today), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed));
                if (this.a.today < 0) {
                    this.append(" DR");
                } else {
                    this.append(" CR");
                }
                this.append("\n\nReconciled balance: " + Utilities.numberToString(Math.abs(this.a.reconciled), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed));
                if (this.a.reconciled < 0) {
                    this.append(" DR");
                } else {
                    this.append(" CR");
                }
                this.append("\n\nCurrency: " + this.a.currency + "\n\nType: " + this.a.type);
                if (this.parent.transactionHt.containsKey(this.a.name)) {
                    this.append("\n\nNumber of entries: " + ((Hashtable)this.parent.transactionHt.get(this.a.name)).size());
                }
                this.append("\n\nInternal record position: " + this.a.id);
                break;
            }
            case 1: {
                this.c = (Category)object;
                this.append("Show Category\n\n", Color.BLUE, 20);
                this.append("Name: " + this.c.name + "\n\nDescription: " + this.c.description + "\n\nOpening balance: " + Utilities.numberToString(Math.abs(this.c.open), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed));
                if (this.c.open < 0) {
                    this.append(" DR");
                } else {
                    this.append(" CR");
                }
                this.append("\n\nCurrent balance: " + Utilities.numberToString(Math.abs(this.c.current), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed));
                if (this.c.current < 0) {
                    this.append(" DR");
                } else {
                    this.append(" CR");
                }
                this.append("\n\nInternal record position: " + this.c.id);
                break;
            }
            case 2: {
                this.t = (Transaction)object;
                this.append("Show Transaction\n\n", Color.BLUE, 20);
                this.append("Account: " + this.t.account + "\n\nDescription: " + this.t.description + "\n\nAmount: " + Utilities.numberToString(Math.abs(this.t.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed));
                if (this.t.amount < 0) {
                    this.append(" DR");
                } else {
                    this.append(" CR");
                }
                this.append("\n\nReference: " + this.t.reference);
                if (!this.t.splitFlag) {
                    this.append("\n\nCategory: " + this.t.category);
                }
                this.append("\n\nDate: " + this.showDate(this.t.longDate) + "\n\nReconciled: ");
                if (this.t.reconciled) {
                    this.append("Yes");
                } else {
                    this.append("No");
                }
                this.append("\n\nTransfer: ");
                if (this.t.transferFlag) {
                    this.append("Yes (" + this.t.transferAccount + ")");
                } else {
                    this.append("No");
                }
                this.append("\n\nSplit: ");
                if (this.t.splitFlag) {
                    this.append("Yes");
                } else {
                    this.append("No");
                }
                if (this.t.splitFlag) {
                    for (int i = 0; i < this.t.ss.size(); ++i) {
                        Split s = this.t.ss.getSplit(i);
                        this.append("\n\nCategory: " + s.category + "\nAmount: " + Utilities.numberToString(Math.abs(s.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed));
                        if (s.amount < 0) {
                            this.append(" DR");
                            continue;
                        }
                        this.append(" CR");
                    }
                }
                this.append("\n\nInternal record position: " + this.t.id);
                break;
            }
            case 3: {
                this.so = (StandingOrder)object;
                this.append("Show Standing Order\n\n", Color.BLUE, 20);
                this.append("Description: " + this.so.description + "\n\nAmount: " + Utilities.numberToString(Math.abs(this.so.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed));
                if (this.so.amount < 0) {
                    this.append(" DR");
                } else {
                    this.append(" CR");
                }
                this.append("\n\nReference: " + this.so.reference + "\n\nCategory: " + this.so.category + "\n\nAccount: " + this.so.account);
                this.append("\n\nStart date: " + this.showDate(this.so.longStartDate) + "\n\nProcessing date: " + this.showDate(this.so.longProcessingDate) + "\n\nEnd date: " + this.showDate(this.so.longEndDate));
                this.append("\n\nPeriod: ");
                switch (this.so.period) {
                    case 0: {
                        this.append("Yearly");
                        break;
                    }
                    case 1: {
                        this.append("Monthly");
                        break;
                    }
                    case 2: {
                        this.append("Weekly");
                        break;
                    }
                    case 3: {
                        this.append("Daily");
                    }
                }
                this.append("\n\nInterval: " + this.so.interval + "\n\nTransfer: ");
                if (this.so.transferFlag) {
                    this.append("Yes (" + this.so.transferAccount + ")");
                } else {
                    this.append("No");
                }
                this.append("\n\nInternal record position: " + this.so.id);
                break;
            }
            case 4: {
                this.inv = (Investment)object;
                this.append("Show Investment\n\n", Color.BLUE, 20);
                this.append("Investment name: " + this.inv.name + "\n\nDescription: " + this.inv.description);
                this.append("\n\nHolding: " + Utilities.decimalToString(this.inv.holding, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, this.parent.holdingDecimalPlaces));
                if (this.inv.currency.equals(this.parent.homeCurrency)) {
                    this.append("\n\nPrice: " + Utilities.decimalToString(this.inv.price, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, this.parent.priceDecimalPlaces));
                    this.append("\n\nValue: " + Utilities.numberToString(this.inv.calcValue(this.inv), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed));
                } else {
                    this.append("\n\nPrice in " + this.inv.currency + ": " + Utilities.decimalToString(this.inv.price, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed, this.parent.priceDecimalPlaces));
                    this.append("\n\nValue in " + this.inv.currency + ": " + Utilities.numberToString(this.inv.calcValue2(this.inv), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed));
                    this.append("\n\nValue in " + this.parent.homeCurrency + ": " + Utilities.numberToString(this.inv.calcValue(this.inv), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed));
                }
                this.append("\n\nDate: " + this.showDate(this.inv.priceLongDate));
                this.append("\n\nCurrency: " + this.inv.currency);
                this.append("\n\nInternal record position: " + this.inv.id);
                break;
            }
            case 5: {
                this.ccy = (Currency)object;
                this.append("Show Currency\n\n", Color.BLUE, 20);
                this.append("Currency code: " + this.ccy.code + "\n\nDescription: " + this.ccy.description);
                this.append("\n\nCurrent rate: " + Utilities.rateToString(this.ccy.rate, false, this.parent.isEuropeanNumberFormat));
                this.append("\n\nPrevious rate: " + Utilities.rateToString(this.ccy.oldRate, false, this.parent.isEuropeanNumberFormat));
                this.append("\n\nInternal record position: " + this.ccy.id);
                break;
            }
            case 6: {
                this.t = (Transaction)object;
                this.append("Show Found Transaction\n\n", Color.BLUE, 20);
                this.append("Account: " + this.t.account + "\n\nDescription: " + this.t.description + "\n\nAmount: " + Utilities.numberToString(Math.abs(this.t.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed));
                if (this.t.amount < 0) {
                    this.append(" DR");
                } else {
                    this.append(" CR");
                }
                this.append("\n\nReference: " + this.t.reference);
                if (!this.t.splitFlag) {
                    this.append("\n\nCategory: " + this.t.category);
                }
                this.append("\n\nDate: " + this.showDate(this.t.longDate) + "\n\nReconciled: ");
                if (this.t.reconciled) {
                    this.append("Yes");
                } else {
                    this.append("No");
                }
                this.append("\n\nTransfer: ");
                if (this.t.transferFlag) {
                    this.append("Yes (" + this.t.transferAccount + ")");
                } else {
                    this.append("No");
                }
                this.append("\n\nSplit: ");
                if (this.t.splitFlag) {
                    this.append("Yes");
                } else {
                    this.append("No");
                }
                if (!this.t.splitFlag) break;
                for (int i = 0; i < this.t.ss.size(); ++i) {
                    Split s = this.t.ss.getSplit(i);
                    this.append("\n\nCategory: " + s.category + "\nAmount: " + Utilities.numberToString(Math.abs(s.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed));
                    if (s.amount < 0) {
                        this.append(" DR");
                        continue;
                    }
                    this.append(" CR");
                }
                break;
            }
            case 7: {
                this.append("Jabp4 information\n\n", Color.BLUE, 20);
                int deletedSpace = this.parent.av.as.rs.deletedSpace;
                int k = this.parent.av.as.ht.size() - this.parent.av.as.ht2.size();
                this.append(this.parent.av.as.ht.size() + " Accounts");
                if (k > 0) {
                    this.append(" (" + k + " inactive/hidden)");
                }
                TransactionStore ts = null;
                RegularStore rs = null;
                if (this.parent.tv == null) {
                    ts = new TransactionStore(this.parent, new Account(), true);
                    rs = new RegularStore(this.parent, true);
                } else {
                    ts = this.parent.tv.ts;
                    rs = this.parent.tv.rs;
                }
                deletedSpace += ts.rs.deletedSpace + rs.rs.deletedSpace;
                this.append("\n" + ts.getNumAllTransactions() + " Transactions" + "\n" + rs.getNumRegulars() + " Regulars");
                if (this.parent.tv == null) {
                    ts.closeTransactionStore();
                    ts = null;
                    rs.closeRegularStore();
                    rs = null;
                }
                CategoryStore cs = null;
                cs = this.parent.cv == null ? new CategoryStore(this.parent, true) : this.parent.cv.cs;
                deletedSpace += cs.rs.deletedSpace;
                this.append("\n" + cs.getNumCategories() + " Categories");
                if (this.parent.cv == null) {
                    cs.closeCategoryStore();
                    cs = null;
                }
                StandingOrderStore sos = null;
                sos = this.parent.sov == null ? new StandingOrderStore(this.parent, true) : this.parent.sov.sos;
                deletedSpace += sos.rs.deletedSpace;
                this.append("\n" + sos.getNumStandingOrders() + " Standing Orders");
                if (this.parent.sov == null) {
                    sos.closeStandingOrderStore();
                    sos = null;
                }
                InvestmentStore is = null;
                is = this.parent.iv == null ? new InvestmentStore(this.parent, true) : this.parent.iv.is;
                deletedSpace += is.rs.deletedSpace;
                this.append("\n" + is.getNumInvestments() + " Investments");
                if (this.parent.iv == null) {
                    is.closeInvestmentStore();
                    is = null;
                }
                CurrencyStore ccys = null;
                ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
                deletedSpace += ccys.rs.deletedSpace;
                this.append("\n" + ccys.getNumCurrencies() + " Currencies");
                if (this.parent.ccyv == null) {
                    ccys.closeCurrencyStore();
                    ccys = null;
                }
                if (this.parent.sync != null) {
                    int j = this.parent.sync.getNumSyncRecords();
                    if (j == 1) {
                        this.append("\n\n1 record to sync");
                    }
                    if (j > 1) {
                        this.append("\n\n" + j + " records to sync");
                    }
                }
                this.append("\n\nFilename: " + this.parent.getShortFileName());
                this.append("\nFile location: " + this.parent.jabpFile);
                if (this.parent.ief == null) {
                    this.parent.ief = new ImportExportForm(this.parent, false);
                }
                this.append("\nImport / Export directory: " + this.parent.ief.root + this.parent.ief.directory);
                this.append("\n\nOverall file size (excludes backups): " + GenericShowForm.folderSizeExcludingBackups(new File(this.parent.jabpFile)) + " bytes");
                this.append("\nReclaimable space (use Recreate Balances to reclaim): " + deletedSpace + " bytes");
                this.append("\n\nOperating system (reported): " + System.getProperty("os.name"));
                this.append("\nJava vendor name: " + System.getProperty("java.vm.vendor"));
                this.append("\nJava version: " + System.getProperty("java.runtime.version"));
                this.append("\nJava VM name: " + System.getProperty("java.vm.name"));
                this.append("\nJava directory: " + System.getProperty("sun.boot.library.path"));
                this.append("\nDisplay size: " + this.parent.getSize().width + " x " + this.parent.getSize().height + " (to Java)");
                break;
            }
            case 8: {
                this.r = (Regular)object;
                this.append("Show Regular\n\n", Color.BLUE, 20);
                this.append("Description: " + this.r.description + "\n\nAmount: " + Utilities.numberToString(Math.abs(this.r.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed));
                if (this.r.amount < 0) {
                    this.append(" DR");
                } else {
                    this.append(" CR");
                }
                this.append("\n\nReference: " + this.r.reference);
                if (!this.r.splitFlag) {
                    this.append("\n\nCategory: " + this.r.category);
                }
                this.append("\n\nTransfer: ");
                if (this.r.transferFlag) {
                    this.append("Yes (" + this.r.transferAccount + ")");
                } else {
                    this.append("No");
                }
                this.append("\n\nSplit: ");
                if (this.r.splitFlag) {
                    this.append("Yes");
                } else {
                    this.append("No");
                }
                if (this.r.splitFlag) {
                    for (int i = 0; i < this.r.ss.size(); ++i) {
                        Split s = this.r.ss.getSplit(i);
                        this.append("\n\nCategory: " + s.category + "\nAmount: " + Utilities.numberToString(Math.abs(s.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed));
                        if (s.amount < 0) {
                            this.append(" DR");
                            continue;
                        }
                        this.append(" CR");
                    }
                }
                this.append("\n\nInternal record position: " + this.r.id);
                break;
            }
            case 9: {
                this.append("Jabp4 keyboard shortcuts\n\n", Color.BLUE, 20);
                this.append("Note: these shortcuts also work if using keyboard in JabpLite4\n\n");
                this.append("Navigation\n", Color.BLACK, 18);
                this.append("\nHome key        Go to top of list");
                this.append("\nEnd key            Go to bottom of list");
                this.append("\nPage up            Up one page");
                this.append("\nCursor left         Up one page");
                this.append("\nPage down       Down one page");
                this.append("\nCursor right      Down one page");
                this.append("\nCursor up         Up one line");
                this.append("\nCursor down    Down one line");
                this.append("\n\nAll views\n", Color.BLACK, 18);
                this.append("\nh   Go to Home screen (Accounts View)");
                this.append("\nn   New item");
                this.append("\ne   Edit item");
                this.append("\nd   Delete item");
                this.append("\ns   Show item details");
                this.append("\nv   Switch views");
                this.append("\nk   Show keyboard shortcuts");
                this.append("\n\nAccount view\n", Color.BLACK, 18);
                this.append("\nt   Transaction list");
                this.append("\n1-9   Go to Transactions view of this numbered account");
                this.append("\n\nTransaction view\n", Color.BLACK, 18);
                this.append("\ng   Go to date");
                this.append("\nl    Select Regular transaction");
                this.append("\nc   Copy transaction");
                this.append("\nm  Move transaction to another account");
                this.append("\nr    Reconcile transaction");
                this.append("\n+   Increment date");
                this.append("\n-    Decrement date");
                this.append("\n1-9   Go to Transactions view of this numbered account");
                this.append("\n\nCategory view\n", Color.BLACK, 18);
                this.append("\nf   Find transactions for this category");
                this.append("\nt   Top Expenses");
                this.append("\n\nStanding Order view\n", Color.BLACK, 18);
                this.append("\np   Process now");
                this.append("\n\nInvestment view\n", Color.BLACK, 18);
                this.append("\np   Update Price");
                break;
            }
            case 10: {
                this.append("Account Balances By Month\n", Color.BLUE, 20);
                if (this.parent.abbmf.useAllAccounts) {
                    this.append("\nBalances for all accounts");
                } else {
                    String s = "Accounts: ";
                    for (int i = 0; i < this.parent.abbmf.selectedAccounts.size(); ++i) {
                        if (i > 0) {
                            s = s + ", ";
                        }
                        s = s + (String)this.parent.abbmf.selectedAccounts.elementAt(i);
                    }
                    this.append("\n" + s);
                }
                this.append("\nBalances as at end of month\n");
                int rtAll = 0;
                int rt3Months = 0;
                int rt6Months = 0;
                int rt12Months = 0;
                int month = this.parent.abbmf.cFrom.get(2) + 1;
                int year = this.parent.abbmf.cFrom.get(1);
                int n = this.parent.abbmf.totals.length;
                boolean isEndDateLastDayOfMonth = this.parent.abbmf.isEndDateLastDayOfMonth();
                int incompleteMonthAdjustment = 0;
                if (!isEndDateLastDayOfMonth) {
                    ++incompleteMonthAdjustment;
                }
                for (int i = 0; i < n; ++i) {
                    rtAll += this.parent.abbmf.totals[i];
                    if (i < n - 3 - incompleteMonthAdjustment) {
                        rt3Months += this.parent.abbmf.totals[i];
                    }
                    if (i < n - 6 - incompleteMonthAdjustment) {
                        rt6Months += this.parent.abbmf.totals[i];
                    }
                    if (i < n - 12 - incompleteMonthAdjustment) {
                        rt12Months += this.parent.abbmf.totals[i];
                    }
                    String s = "" + month + "/" + year;
                    if (month < 10) {
                        s = "0" + s;
                    }
                    this.append("\n" + s + String.format("%1$17s", Utilities.numberToString(rtAll, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed)), true);
                    if (++month <= 12) continue;
                    ++year;
                    month = 1;
                    this.append("\n");
                }
                if (!isEndDateLastDayOfMonth) {
                    rtAll -= this.parent.abbmf.totals[n - 1];
                }
                this.append("\n\nAverage monthly deltas:\n");
                int delta = 0;
                if (n > 3) {
                    delta = (rtAll - rt3Months) / 3;
                    this.append("\nLast 3 mths: " + String.format("%1$11s", Utilities.numberToString(delta, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed)), true);
                }
                if (n > 6) {
                    delta = (rtAll - rt6Months) / 6;
                    this.append("\nLast 6 mths: " + String.format("%1$11s", Utilities.numberToString(delta, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed)), true);
                }
                if (n > 12) {
                    delta = (rtAll - rt12Months) / 12;
                    this.append("\nLast 12 mths:" + String.format("%1$11s", Utilities.numberToString(delta, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed)), true);
                }
                delta = (rtAll - this.parent.abbmf.totals[0]) / this.parent.abbmf.monthsBetweenDates(this.parent.abbmf.fromDate, this.parent.abbmf.toDate);
                this.append("\nWhole period:" + String.format("%1$11s", Utilities.numberToString(delta, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed)), true);
                if (isEndDateLastDayOfMonth) break;
                this.append("\n\nLast incomplete month excluded", true);
            }
        }
        this.genericShow.setCaretPosition(0);
    }

    void append(String msg) {
        this.append(msg, Color.BLACK, 16, false);
    }

    void append(String msg, Color color) {
        this.append(msg, color, 16, false);
    }

    void append(String msg, boolean monospaced) {
        this.append(msg, Color.BLACK, 16, monospaced);
    }

    void append(String msg, Color color, int fontSize) {
        this.append(msg, color, fontSize, false);
    }

    void append(String msg, Color color, int fontSize, boolean monospaced) {
        SimpleAttributeSet attributes = new SimpleAttributeSet(this.genericShow.getInputAttributes());
        StyleConstants.setForeground(attributes, color);
        StyleConstants.setFontSize(attributes, fontSize);
        if (monospaced) {
            StyleConstants.setFontFamily(attributes, "Monospaced");
        }
        try {
            this.genericShow.getStyledDocument().insertString(this.genericShow.getDocument().getLength(), msg, attributes);
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
    }

    public static long folderSizeExcludingBackups(File directory) {
        long length = 0L;
        for (File file : directory.listFiles()) {
            if (file.toString().contains("Backups")) continue;
            if (file.isFile()) {
                length += file.length();
                continue;
            }
            length += GenericShowForm.folderSizeExcludingBackups(file);
        }
        return length;
    }

    String showDate(long ldate) {
        if (this.parent.adjustDaylightSavings) {
            this.parent.genericDate.setTime(ldate + 3600000L);
        } else {
            this.parent.genericDate.setTime(ldate);
        }
        this.parent.cal.setTime(this.parent.genericDate);
        String s0 = "" + this.parent.cal.get(5);
        if (s0.length() < 2) {
            s0 = "0" + s0;
        }
        int i = this.parent.cal.get(2) + 1;
        String s1 = "" + i;
        if (s1.length() < 2) {
            s1 = "0" + s1;
        }
        String s3 = ("" + this.parent.cal.get(1)).substring(2, 4);
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            return s0 + "/" + s1 + "/" + s3;
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            return s1 + "/" + s0 + "/" + s3;
        }
        return "";
    }

    void processDoneButton() {
        this.parent.goToLastUsedView();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.processDoneButton();
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

