/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.AccountStore;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.FutureBalanceForm;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.Sort;
import org.freepoc.Jabp4.StandingOrder;
import org.freepoc.Jabp4.StandingOrderStore;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.TransactionStore;
import org.freepoc.Jabp4.Utilities;

public class FutureBalanceView
extends Canvas
implements ActionListener,
KeyListener,
MouseListener {
    Jabp parent;
    boolean showResults = false;
    Vector canvasMenu;
    Image image;
    Graphics g1;
    Font font;
    FontMetrics fm;
    Point point;
    int numMenuItems;
    int startMenuPos;
    int currentMenuPos;
    int menuWidth;
    int menuHeight;
    int menuWidthPos;
    int menuHeightPos;
    int fs;
    int width;
    int height;
    int lastDragX;
    int lineHeight;
    int numItemsPage;
    int fontHeight;
    int fontWidth;
    int numberWidth;
    int nameWidth;
    int amountPosition;
    int currentX;
    int currentY;
    int totalAmount;
    long timePointerOnScreen;
    boolean useAllAccounts = false;
    int selectedAccountPosition;
    long longToDate = 0L;
    boolean showCanvasMenu = false;
    boolean showingPopupMenu = false;
    boolean calculateCanvasMenuPosition = true;
    boolean oneClickFlag;
    boolean start;

    public FutureBalanceView(Jabp context, boolean useAllAccounts1, int selectedAccountPosition1, long longToDate1) {
        this.parent = context;
        this.useAllAccounts = useAllAccounts1;
        this.selectedAccountPosition = selectedAccountPosition1;
        this.longToDate = longToDate1;
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.font = this.parent.font;
        this.setFont(this.font);
        this.fm = this.getFontMetrics(this.font);
        this.lineHeight = this.parent.fontHeight + this.parent.lineSpacing * 2;
        this.currentX = 0;
        this.currentY = this.lineHeight;
        this.setupCanvasMenu();
        this.start = true;
        this.oneClickFlag = false;
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    @Override
    public void paint(Graphics g) {
        if (this.start) {
            this.start = false;
        }
        this.parent.lastUsedScreen = 19;
        this.setPositions();
        this.g1.clearRect(0, 0, this.width, this.height);
        this.g1.setFont(this.font);
        this.showHeader();
        this.showPage();
        this.showFooter();
        if (this.parent.useCanvasMenu && this.showCanvasMenu) {
            this.displayCanvasMenu();
        }
        g.drawImage(this.image, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    void showPage() {
        this.currentY = this.lineHeight;
        this.g1.setColor(new Color(this.parent.colorBackground));
        this.g1.fillRect(0, this.lineHeight, this.width, this.height - this.lineHeight * 2);
        this.g1.setColor(new Color(this.parent.colorFont));
        AccountStore as = this.parent.av.as;
        int t1 = 0;
        int t2 = 0;
        int t3 = 0;
        int n = as.getNumAccounts();
        String s = "All accounts";
        for (int i = 0; i < n; ++i) {
            Account a = as.getAccountFromIndex(i);
            if (this.useAllAccounts) {
                t1 += a.today;
                continue;
            }
            if (this.selectedAccountPosition != i) continue;
            t1 += a.today;
            s = a.name;
        }
        TransactionStore ts = null;
        Account a2 = null;
        if (this.parent.tv == null) {
            ts = new TransactionStore(this.parent, new Account(), true);
        } else {
            ts = this.parent.tv.ts;
            a2 = ts.a;
        }
        t2 = ts.futureTransactions(this.longToDate, s);
        if (this.parent.tv == null) {
            ts.closeTransactionStore();
            ts = null;
        } else {
            ts.getIndex(a2);
        }
        StandingOrderStore sos = null;
        sos = this.parent.sov == null ? new StandingOrderStore(this.parent, true) : this.parent.sov.sos;
        t3 = sos.futureStandingOrders(this.longToDate, s);
        if (this.parent.sov == null) {
            sos.closeStandingOrderStore();
            sos = null;
        }
        this.totalAmount = t1 + t2 + t3;
        this.buildLine("Today's Balance", t1);
        this.buildLine("Future Transactions", t2);
        this.buildLine("Future S. Orders", t3);
    }

    void showHeader() {
        int vpos = this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorHeading));
        this.g1.fillRect(0, 0, this.width, this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        String s = "All accounts";
        if (!this.useAllAccounts) {
            s = this.parent.av.as.getAccountFromIndex((int)this.selectedAccountPosition).name;
        }
        this.g1.drawString(s, this.parent.widthAdjustment, vpos);
        this.g1.drawString("Amount", this.amountPosition + this.numberWidth - this.fm.stringWidth("Amount"), vpos);
    }

    void showFooter() {
        int vpos = this.height - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorHeading));
        this.g1.fillRect(0, this.height - this.lineHeight, this.width, this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        this.g1.drawString("Balance on " + this.setDate(new Date(this.longToDate)), this.parent.widthAdjustment, vpos);
        if (this.totalAmount < 0) {
            this.g1.setColor(new Color(this.parent.colorNegative));
        }
        String s = Utilities.numberToString(this.totalAmount, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        this.g1.drawString(s, this.amountPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
    }

    void buildLine(String s, int i) {
        this.currentY += this.lineHeight;
        int vpos = this.currentY + this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorFont));
        this.g1.drawString(s, this.parent.widthAdjustment, vpos);
        if (i < 0) {
            this.g1.setColor(new Color(this.parent.colorNegative));
        }
        String s1 = Utilities.numberToString(i, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        this.g1.drawString(s1, this.amountPosition + this.numberWidth - this.fm.stringWidth(s1), vpos);
        this.currentY += this.lineHeight;
    }

    void setPositions() {
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.fontHeight = this.parent.fontHeight;
        this.image = this.createImage(this.width, this.height);
        this.g1 = this.image.getGraphics();
        Utilities.enableAntialiasing(this.g1);
        if (this.parent.lineSpacing == 0) {
            this.parent.lineSpacing = this.fontHeight / 5;
        }
        this.lineHeight = this.fontHeight + this.parent.lineSpacing * 2;
        this.numItemsPage = this.height / this.lineHeight - 2;
        this.numberWidth = this.parent.isGroupingUsed ? this.fm.stringWidth("999,999.99") : this.fm.stringWidth("999999.99");
        this.nameWidth = this.width - this.numberWidth - this.parent.widthAdjustment * 2 - 10;
        this.amountPosition = this.nameWidth + this.parent.widthAdjustment + 10;
    }

    String setDate(Date d) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        String s0 = "" + calendar.get(5);
        if (s0.length() < 2) {
            s0 = "0" + s0;
        }
        int i = calendar.get(2) + 1;
        String s1 = "" + i;
        if (s1.length() < 2) {
            s1 = "0" + s1;
        }
        if (this.parent.dateFormat == 0) {
            return s0 + "/" + s1;
        }
        if (this.parent.dateFormat == 1) {
            return s1 + "/" + s0;
        }
        String s3 = ("" + calendar.get(1)).substring(2, 4);
        if (this.parent.dateFormat == 2) {
            return s0 + "/" + s1 + "/" + s3;
        }
        if (this.parent.dateFormat == 3) {
            return s1 + "/" + s0 + "/" + s3;
        }
        return "";
    }

    void showMaxAndMinBalances() {
        if (this.useAllAccounts) {
            Toast.makeText(this.parent, "Only available for single account", 2000).show();
            return;
        }
        Account a = this.parent.av.as.getAccountFromIndex(this.selectedAccountPosition);
        Date today = new Date();
        Date toDate = new Date(this.longToDate);
        Vector<Date> vdate = new Vector<Date>();
        Vector<Integer> vamount = new Vector<Integer>();
        vdate.addElement(today);
        vamount.addElement(new Integer(0));
        vdate.addElement(toDate);
        vamount.addElement(new Integer(0));
        if (this.parent.tv != null) {
            this.parent.tv.ts.closeTransactionStore();
            this.parent.tv = null;
        }
        TransactionStore ts = new TransactionStore(this.parent, a, true);
        ts.getIndex(a);
        int n = ts.ht.size();
        for (int i = 0; i < n; ++i) {
            int j = i;
            if (!ts.normalSortOrder) {
                j = n - 1 - i;
            }
            Transaction t = ts.getTransactionFromIndex(j);
            if (Utilities.longToDays(t.longDate) <= Utilities.longToDays(today.getTime())) break;
            if (Utilities.longToDays(t.longDate) < Utilities.longToDays(today.getTime()) || Utilities.longToDays(t.longDate) > Utilities.longToDays(toDate.getTime())) continue;
            vdate.addElement(new Date(t.longDate));
            vamount.addElement(new Integer(t.amount));
        }
        ts.closeTransactionStore();
        if (this.parent.sov != null) {
            this.parent.sov.sos.closeStandingOrderStore();
            this.parent.sov = null;
        }
        StandingOrderStore sos = new StandingOrderStore(this.parent, true);
        long futureDate = Utilities.longToDays(toDate.getTime());
        StandingOrder so = null;
        sos.setToStart();
        block1: while ((so = sos.readNextStandingOrder()) != null) {
            if (!so.account.equals(a.name)) continue;
            while (Utilities.longToDays(so.longProcessingDate) <= futureDate) {
                vdate.addElement(new Date(so.longProcessingDate));
                vamount.addElement(new Integer(so.amount));
                so.longProcessingDate = sos.nextProcessingDate(so);
                if (Utilities.longToDays(so.longProcessingDate) <= Utilities.longToDays(so.longEndDate)) continue;
                continue block1;
            }
        }
        sos.closeStandingOrderStore();
        if (vdate.size() < 2) {
            Toast.makeText(this.parent, "Too few future entries", 2000).show();
            return;
        }
        Sort.sortDateAmount(vdate, vamount, 0, vdate.size() - 1, true);
        int maxSize = a.today;
        int minSize = a.today;
        Date maxDate = new Date();
        Date minDate = new Date();
        maxDate = today;
        minDate = today;
        int runningTotal = a.today;
        int dayTotal = 0;
        Date date = new Date(0L);
        for (int i = 0; i < vdate.size(); ++i) {
            Date tdate = (Date)vdate.elementAt(i);
            int tamount = (Integer)vamount.elementAt(i);
            if (Utilities.longToDays(tdate.getTime()) != Utilities.longToDays(date.getTime())) {
                if ((runningTotal += dayTotal) > maxSize) {
                    maxSize = runningTotal;
                    maxDate = date;
                }
                if (runningTotal < minSize) {
                    minSize = runningTotal;
                    minDate = date;
                }
                dayTotal = tamount;
                date = tdate;
                continue;
            }
            dayTotal += tamount;
        }
        if ((runningTotal += dayTotal) > maxSize) {
            maxSize = runningTotal;
            maxDate = date;
        }
        if (runningTotal < minSize) {
            minSize = runningTotal;
            minDate = date;
        }
        int finishingBalance = runningTotal;
        DialogManager dm = new DialogManager(this.parent, "Max & Min Balances");
        SimpleDateFormat sdf = null;
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            sdf = new SimpleDateFormat("dd/MM/yyyy");
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            sdf = new SimpleDateFormat("MM/dd/yyyy");
        }
        String s = Utilities.numberToString(Math.abs(a.today), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        s = a.today >= 0 ? s + " CR" : s + " DR";
        dm.addText("Today's balance:", s);
        s = Utilities.numberToString(Math.abs(finishingBalance), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        s = finishingBalance >= 0 ? s + " CR" : s + " DR";
        dm.addText("Balance @ " + sdf.format(toDate) + ":", s);
        s = Utilities.numberToString(Math.abs(minSize), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        s = minSize >= 0 ? s + " CR" : s + " DR";
        dm.addText("Minimum @ " + sdf.format(minDate) + ":", s);
        s = Utilities.numberToString(Math.abs(maxSize), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        s = maxSize >= 0 ? s + " CR" : s + " DR";
        dm.addText("Maximum @ " + sdf.format(maxDate) + ":", s);
        dm.addButton("OK");
        dm.centerShow();
        dm.dispose();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int j;
        String s = ae.getSource().toString();
        String s1 = s.substring((j = s.indexOf("[")) + 1, j + 5);
        if (s1.equals("menu")) {
            MenuItem mi = (MenuItem)ae.getSource();
            this.commandAction(mi.getLabel());
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.point = me.getPoint();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.point = me.getPoint();
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.point = me.getPoint();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        this.lastDragX = x;
        this.calculateCanvasMenuPosition = true;
        if (this.showCanvasMenu) {
            this.calculateCanvasMenuPosition = false;
            this.currentMenuPos = (y - this.menuHeightPos) / this.lineHeight;
            this.repaint();
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        if (Math.abs(this.lastDragX - x) > 100) {
            this.commandAction("Home");
            return;
        }
        if (this.showCanvasMenu) {
            this.showCanvasMenu = false;
            this.repaint();
            if (x < this.menuWidthPos || x > this.menuWidthPos + this.menuWidth || y < this.menuHeightPos || y > this.menuHeightPos + this.menuHeight) {
                this.setupCanvasMenu();
                return;
            }
            int k = (y - this.menuHeightPos) / this.lineHeight + this.startMenuPos;
            this.processMenuCommand(k);
            return;
        }
        if (this.parent.useCanvasMenu) {
            this.showCanvasMenu = true;
            this.repaint();
        } else {
            this.displayPopupMenu();
        }
    }

    void displayPopupMenu() {
        if (this.showingPopupMenu) {
            this.showingPopupMenu = false;
            return;
        }
        PopupMenu pm = new PopupMenu();
        MenuItem miHome = new MenuItem("Home");
        miHome.addActionListener(this);
        pm.add(miHome);
        MenuItem miShow = new MenuItem("Show Max & Min Balances");
        miShow.addActionListener(this);
        pm.add(miShow);
        MenuItem miNew = new MenuItem("New Future Balance");
        miNew.addActionListener(this);
        pm.add(miNew);
        MenuItem miExit = new MenuItem("Exit");
        miExit.addActionListener(this);
        pm.add(miExit);
        this.add(pm);
        int x = 0;
        int y = 0;
        if (this.point == null) {
            pm.show(this, x, y);
        } else {
            pm.show(this, x + this.point.x, y + this.point.y);
        }
        this.showingPopupMenu = true;
    }

    void setupCanvasMenu() {
        this.startMenuPos = 0;
        this.currentMenuPos = 0;
        this.canvasMenu = new Vector(4);
        this.canvasMenu.addElement("Home");
        this.canvasMenu.addElement("Show Max & Min Balances");
        this.canvasMenu.addElement("New Future Balance");
        this.canvasMenu.addElement("Exit");
        this.menuWidth = this.fm.stringWidth("Show Max & Min Balances") + 6;
    }

    void displayCanvasMenu() {
        this.numMenuItems = this.canvasMenu.size();
        this.menuWidthPos = (this.width - this.menuWidth) / 2;
        if (this.menuWidthPos < 0) {
            this.menuWidthPos = 0;
        }
        this.menuHeightPos = (this.height - this.lineHeight * 2 - this.numMenuItems * this.lineHeight) / 2;
        if (this.menuHeightPos < this.lineHeight) {
            this.menuHeightPos = this.lineHeight;
        }
        this.menuHeight = Math.min(this.height - this.lineHeight * 2, this.numMenuItems * this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorMessage));
        this.g1.fillRect(this.menuWidthPos, this.menuHeightPos, this.menuWidth, this.menuHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        for (int i = 0; i < this.numItemsPage && i + this.startMenuPos <= this.numMenuItems - 1; ++i) {
            int vpos = i * this.lineHeight + this.lineHeight + this.menuHeightPos - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
            if (i == this.currentMenuPos) {
                this.g1.setColor(new Color(this.parent.colorCursor));
                this.g1.fillRect(this.menuWidthPos, this.lineHeight * i + this.menuHeightPos, this.menuWidth, this.lineHeight);
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            this.g1.drawString((String)this.canvasMenu.elementAt(i + this.startMenuPos), this.menuWidthPos + 3, vpos);
        }
    }

    void processMenuCommand(int k) {
        this.repaint();
        this.commandAction((String)this.canvasMenu.elementAt(k));
    }

    void commandAction(String cmd) {
        this.showingPopupMenu = false;
        if (cmd.equals("Home")) {
            if (this.parent.useCanvasMenu && this.showCanvasMenu) {
                this.showCanvasMenu = false;
                this.repaint();
                return;
            }
            this.parent.setContentView(this.parent.av);
            return;
        }
        if (cmd.equals("Show Max & Min Balances")) {
            this.showMaxAndMinBalances();
            return;
        }
        if (cmd.equals("New Future Balance")) {
            new FutureBalanceForm(this.parent);
            return;
        }
        if (cmd.equals("Exit")) {
            this.parent.finishAndQuit();
            return;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if ((e.getKeyCode() == 10 || e.getKeyCode() == 525) && e.getKeyCode() == 525) {
            this.displayPopupMenu();
        }
        if (e.getKeyCode() == 27) {
            this.parent.onBackPressed();
            return;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

