/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Calendar;
import java.util.Vector;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.FindForm;
import org.freepoc.Jabp4.GenericShowForm;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.LongIntId;
import org.freepoc.Jabp4.Split;
import org.freepoc.Jabp4.TimedMessage;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.TransactionStore;
import org.freepoc.Jabp4.TransactionView;
import org.freepoc.Jabp4.Utilities;

public class FindView
extends Canvas
implements ActionListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    Jabp parent;
    boolean start = true;
    boolean oneClickFlag = false;
    boolean fromCategoryView = false;
    boolean showCanvasMenu = false;
    boolean showingPopupMenu = false;
    boolean pointerExecute = false;
    boolean alwaysDisplayMenu = false;
    boolean calculateCanvasMenuPosition = true;
    boolean paintWholeScreen = true;
    boolean showedOutOfSpaceMessage = false;
    boolean dragScreen = false;
    boolean isSplit = false;
    long timePointerOnScreen;
    Vector canvasMenu;
    Vector selectedCategories;
    Calendar calendar;
    String categoryString;
    String msg = "";
    TimedMessage tm;
    TransactionStore ts;
    Account a;
    Font font;
    FontMetrics fm;
    Graphics g1;
    Image image;
    Point point;
    Transaction t;
    int runMode = 0;
    int numMenuItems;
    int startMenuPos;
    int currentMenuPos;
    int menuWidth;
    int menuHeight;
    int menuWidthPos;
    int menuHeightPos;
    int rt;
    int width;
    int height;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int lastDragY;
    int numItems;
    int numItemsPage;
    int lineHeight;
    int fontAdjust;
    int fontWidth;
    int currentPos;
    int startPos;
    int dateWidth;
    int numberWidth;
    int reconciledWidth;
    int descriptionWidth;
    int descriptionPosition;
    int amountPosition;
    int spacing;
    int referenceWidth;
    int referencePosition;
    int categoryWidth;
    int categoryPosition;
    int accountWidth;
    int accountPosition;
    int minDescriptionWidth;

    public FindView(Jabp context, String categoryString1, boolean fcv, Vector selectedCategories1) {
        this.parent = context;
        this.fromCategoryView = fcv;
        this.categoryString = categoryString1;
        if (selectedCategories1 != null) {
            this.selectedCategories = selectedCategories1;
        }
        this.calendar = Calendar.getInstance();
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.ts = this.parent.tv == null ? new TransactionStore(this.parent, new Account(), true) : this.parent.tv.ts;
        this.numItems = this.parent.findHt.size();
        this.rt = this.parent.totalFound;
        this.font = this.parent.font;
        this.setFont(this.font);
        this.fm = this.getFontMetrics(this.font);
        this.lineHeight = this.parent.fontHeight + this.parent.lineSpacing * 2;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.setPositionsBasedOnSortOrder();
        this.setupCanvasMenu();
    }

    void setStartParameters() {
        this.numItemsPage = this.getSize().height / this.lineHeight - 2;
        this.setPositionsBasedOnSortOrder();
    }

    void setPositionsBasedOnSortOrder() {
        this.currentX = 0;
        if (this.ts.normalSortOrder) {
            this.startPos = 0;
            this.currentPos = 0;
            this.currentY = this.lineHeight;
        } else {
            this.startPos = Math.max(this.numItems - this.parent.av.numItemsPage, 0);
            this.currentPos = this.numItems - this.startPos - 1;
            this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
        }
    }

    void adjustPositionsIfNecessary() {
        if (this.currentPos > this.numItemsPage - 1) {
            this.startPos += this.currentPos - this.numItemsPage + 1;
            this.currentPos = this.numItemsPage - 1;
            this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.start) {
            this.start = false;
            this.setStartParameters();
        }
        this.parent.lastUsedScreen = 6;
        this.parent.lastUsedView = 6;
        this.setPositions();
        this.g1.clearRect(0, 0, this.width, this.height);
        this.g1.setFont(this.font);
        this.showHeader();
        if (!this.parent.busyWithProcess) {
            this.showPage();
            this.showFooter();
        }
        if (this.parent.useCanvasMenu && this.showCanvasMenu) {
            this.displayCanvasMenu();
        }
        g.drawImage(this.image, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    void showPage() {
        this.g1.setColor(new Color(this.parent.colorBackground));
        this.g1.fillRect(0, this.lineHeight, this.width, this.height - this.lineHeight * 2);
        this.g1.setColor(new Color(this.parent.colorFont));
        if (this.numItems == 0) {
            this.g1.drawString("No find results to display", this.parent.widthAdjustment, this.lineHeight * 2);
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                this.g1.setColor(new Color(this.parent.colorCursor));
                this.g1.fillRect(0, this.lineHeight * i + this.lineHeight, this.width, this.lineHeight);
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            this.t = this.getTransactionFromIndex(i + this.startPos);
            this.buildLine(this.t, this.lineHeight * i + this.lineHeight);
        }
        this.t = this.getTransactionFromIndex(this.startPos + this.currentPos);
    }

    Transaction getTransactionFromIndex(int j) {
        LongIntId lii = (LongIntId)this.parent.findHt.get(new Integer(j));
        int id = lii.id;
        Transaction t2 = this.ts.getTransaction(id);
        if (!t2.splitFlag) {
            return t2;
        }
        int n = t2.ss.size();
        if (lii.splitNumber < 0 || lii.splitNumber >= n) {
            return t2;
        }
        Split split = t2.ss.getSplit(lii.splitNumber);
        t2.amount = split.amount;
        t2.category = split.category;
        return t2;
    }

    void showHeader() {
        int vpos = this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        if (this.msg.equals("")) {
            this.g1.setColor(new Color(this.parent.colorHeading));
            this.g1.fillRect(0, 0, this.width, this.lineHeight);
            this.g1.setColor(new Color(this.parent.colorFont));
            this.g1.drawString(this.numItems + " matches", this.parent.widthAdjustment, vpos);
            if (this.rt < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            } else {
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            String s = Utilities.numberToString(this.rt, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            this.g1.drawString(s, this.amountPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
        } else {
            this.g1.setColor(new Color(this.parent.colorMessage));
            this.g1.fillRect(0, 0, this.width, this.lineHeight);
            this.g1.setColor(new Color(this.parent.colorFont));
            this.g1.drawString(this.msg, this.parent.widthAdjustment, vpos);
        }
    }

    void showFooter() {
        int vpos = this.height - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorHeading));
        this.g1.fillRect(0, this.height - this.lineHeight, this.width, this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        this.g1.drawString("Total", this.parent.widthAdjustment, vpos);
        if (this.parent.totalFound < 0) {
            this.g1.setColor(new Color(this.parent.colorNegative));
        }
        String s = Utilities.numberToString(this.parent.totalFound, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        this.g1.drawString(s, this.amountPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
    }

    void drawUp() {
        if (this.showCanvasMenu) {
            if (this.currentMenuPos > 0) {
                --this.currentMenuPos;
            } else {
                --this.startMenuPos;
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (this.startPos + this.currentPos > 0) {
            int from = this.startPos + this.currentPos;
            this.oldY = this.currentY;
            this.currentY -= this.lineHeight;
            --this.currentPos;
            if (this.currentY < this.lineHeight) {
                this.currentY = this.lineHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
                this.repaint();
            } else {
                this.repaint(0, this.lineHeight * this.currentPos + this.lineHeight, this.width, this.lineHeight * 2);
            }
            int to = this.startPos + this.currentPos;
            this.adjustRunningTotal(from, to);
            return;
        }
    }

    void drawDown() {
        if (this.showCanvasMenu) {
            if (this.currentMenuPos < Math.min(this.numItemsPage, this.numMenuItems) - 1) {
                ++this.currentMenuPos;
            } else {
                ++this.startMenuPos;
                if (this.startMenuPos + this.currentPos > Math.min(this.numItemsPage, this.numMenuItems) - 1) {
                    this.startMenuPos = Math.min(this.numItemsPage, this.numMenuItems) - 1 - this.currentPos;
                }
            }
            this.repaint();
            return;
        }
        if (this.startPos + this.currentPos < this.numItems - 1) {
            int from = this.startPos + this.currentPos;
            this.oldY = this.currentY;
            this.currentY += this.lineHeight;
            ++this.currentPos;
            if (this.currentY + this.lineHeight * 2 > this.height) {
                this.currentY -= this.lineHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
                this.repaint();
            } else {
                this.repaint(0, this.lineHeight * (this.currentPos - 1) + this.lineHeight, this.width, this.lineHeight * 2);
            }
            int to = this.startPos + this.currentPos;
            this.adjustRunningTotal(from, to);
            return;
        }
    }

    String setReconciled(boolean b) {
        if (b) {
            return "r";
        }
        return "";
    }

    void buildLine(Transaction transaction, int y) {
        int k;
        int i;
        int vpos = y + this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorFont));
        this.g1.drawString(this.setPageDate(transaction.longDate), this.parent.widthAdjustment, vpos);
        int j = transaction.description.length();
        int adjDescriptionWidth = this.descriptionWidth;
        if (this.referenceWidth > 0 && transaction.reference.equals("")) {
            adjDescriptionWidth += this.referenceWidth;
        }
        for (i = 0; i < j; ++i) {
            k = j - i;
            if (this.fm.stringWidth(transaction.description.substring(0, k)) > adjDescriptionWidth) continue;
            this.g1.drawString(transaction.description.substring(0, k), this.descriptionPosition, vpos);
            break;
        }
        if (this.referenceWidth > 0) {
            j = transaction.reference.length();
            for (i = 0; i < j; ++i) {
                k = j - i;
                if (this.fm.stringWidth(transaction.reference.substring(0, k)) > this.referenceWidth) continue;
                this.g1.drawString(transaction.reference.substring(0, k), this.referencePosition, vpos);
                break;
            }
        }
        if (this.categoryWidth > 0) {
            String s1 = transaction.category;
            if (transaction.transferFlag) {
                s1 = "[Transfer]";
            }
            if (transaction.splitFlag) {
                s1 = "[Split]";
            }
            j = s1.length();
            for (int i2 = 0; i2 < j; ++i2) {
                int k2 = j - i2;
                if (this.fm.stringWidth(s1.substring(0, k2)) > this.categoryWidth) continue;
                this.g1.drawString(s1.substring(0, k2), this.categoryPosition, vpos);
                break;
            }
        }
        if (this.accountWidth > 0) {
            j = transaction.account.length();
            for (int i3 = 0; i3 < j; ++i3) {
                k = j - i3;
                if (this.fm.stringWidth(transaction.account.substring(0, k)) > this.accountWidth) continue;
                this.g1.drawString(transaction.account.substring(0, k), this.accountPosition, vpos);
                break;
            }
        }
        if ((double)transaction.amount < -0.001) {
            this.g1.setColor(new Color(this.parent.colorNegative));
        }
        String s = Utilities.numberToString(transaction.amount, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        this.g1.drawString(s, this.amountPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
        this.g1.setColor(new Color(this.parent.colorFont));
        this.g1.drawString(this.setReconciled(transaction.reconciled), this.width - this.reconciledWidth - this.parent.widthAdjustment, vpos);
    }

    String setPageDate(long ldate) {
        if (this.parent.adjustDaylightSavings) {
            this.parent.genericDate.setTime(ldate + 3600000L);
        } else {
            this.parent.genericDate.setTime(ldate);
        }
        this.parent.cal.setTime(this.parent.genericDate);
        String s0 = "" + this.parent.cal.get(5);
        if (s0.length() < 2) {
            s0 = "0" + s0;
        }
        int i = this.parent.cal.get(2) + 1;
        String s1 = "" + i;
        if (s1.length() < 2) {
            s1 = "0" + s1;
        }
        if (this.parent.dateFormat == 0) {
            return s0 + "/" + s1;
        }
        if (this.parent.dateFormat == 1) {
            return s1 + "/" + s0;
        }
        String s3 = ("" + this.parent.cal.get(1)).substring(2, 4);
        if (this.parent.dateFormat == 2) {
            return s0 + "/" + s1 + "/" + s3;
        }
        if (this.parent.dateFormat == 3) {
            return s1 + "/" + s0 + "/" + s3;
        }
        return "";
    }

    void setPositions() {
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.image = this.createImage(this.width, this.height);
        this.g1 = this.image.getGraphics();
        Utilities.enableAntialiasing(this.g1);
        this.numberWidth = this.parent.isGroupingUsed ? this.fm.stringWidth("999,999.99") : this.fm.stringWidth("999999.99");
        this.dateWidth = this.fm.stringWidth("99/99");
        if (this.parent.dateFormat > 1) {
            this.dateWidth = this.fm.stringWidth("99/99/99");
        }
        this.reconciledWidth = this.fm.stringWidth("r");
        this.minDescriptionWidth = this.fm.stringWidth("Long Description");
        this.numItemsPage = this.height / this.lineHeight - 2;
        this.spacing = this.fm.stringWidth("  ");
        this.referenceWidth = (this.width - this.minDescriptionWidth - this.parent.widthAdjustment * 2 - this.numberWidth - this.dateWidth - this.reconciledWidth - this.spacing * 6) / 3;
        this.categoryWidth = this.accountWidth = Math.max(this.referenceWidth, this.fm.stringWidth("Reference"));
        this.referenceWidth = this.accountWidth;
        this.descriptionWidth = this.width - this.parent.widthAdjustment * 2 - this.numberWidth - this.dateWidth - this.reconciledWidth - this.referenceWidth - this.categoryWidth - this.accountWidth - this.spacing * 6;
        if (this.parent.preferCategoryInTransactionView) {
            if (this.descriptionWidth < this.minDescriptionWidth || this.referenceWidth == 0) {
                this.descriptionWidth += this.referenceWidth + this.spacing;
                this.referenceWidth = 0;
            }
            if (this.descriptionWidth < this.minDescriptionWidth || this.categoryWidth == 0) {
                this.descriptionWidth += this.categoryWidth + this.spacing;
                this.categoryWidth = 0;
            }
        } else {
            if (this.descriptionWidth < this.minDescriptionWidth || this.categoryWidth == 0) {
                this.descriptionWidth += this.categoryWidth + this.spacing;
                this.categoryWidth = 0;
            }
            if (this.descriptionWidth < this.minDescriptionWidth || this.referenceWidth == 0) {
                this.descriptionWidth += this.referenceWidth + this.spacing;
                this.referenceWidth = 0;
            }
        }
        if (this.descriptionWidth < this.minDescriptionWidth) {
            this.descriptionWidth += this.accountWidth + this.spacing;
            this.accountWidth = 0;
        }
        this.descriptionPosition = this.dateWidth + this.parent.widthAdjustment + this.spacing;
        this.referencePosition = this.descriptionPosition + this.descriptionWidth + this.spacing;
        this.categoryPosition = this.referencePosition + this.referenceWidth;
        if (this.referenceWidth > 0) {
            this.categoryPosition += this.spacing;
        }
        this.accountPosition = this.categoryPosition + this.categoryWidth;
        if (this.categoryWidth > 0) {
            this.accountPosition += this.spacing;
        }
        this.amountPosition = this.accountWidth > 0 ? this.accountPosition + this.accountWidth + this.spacing : this.accountPosition;
    }

    void adjustRunningTotal(int from, int to) {
        if (!this.parent.runningTotal) {
            return;
        }
        if (from == to) {
            return;
        }
        if (from < 0 || to < 0) {
            return;
        }
        int k = 0;
        if (this.ts.normalSortOrder) {
            if (from < to) {
                for (int i = from; i < to; ++i) {
                    this.t = this.getTransactionFromIndex(i);
                    k -= this.t.amount;
                }
            } else {
                for (int i = to; i < from; ++i) {
                    this.t = this.getTransactionFromIndex(i);
                    k += this.t.amount;
                }
            }
        } else if (from < to) {
            for (int i = from; i < to; ++i) {
                this.t = this.getTransactionFromIndex(i + 1);
                k += this.t.amount;
            }
        } else {
            for (int i = to; i < from; ++i) {
                this.t = this.getTransactionFromIndex(i + 1);
                k -= this.t.amount;
            }
        }
        this.rt += k;
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int j;
        String s = ae.getSource().toString();
        String s1 = s.substring((j = s.indexOf("[")) + 1, j + 5);
        if (s1.equals("menu")) {
            MenuItem mi = (MenuItem)ae.getSource();
            this.commandAction(mi.getLabel());
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int y;
        this.point = me.getPoint();
        int x = this.point.x;
        this.lastDragY = y = this.point.y;
        this.pointerExecute = false;
        this.alwaysDisplayMenu = false;
        this.timePointerOnScreen = System.currentTimeMillis();
        this.calculateCanvasMenuPosition = true;
        if (this.showCanvasMenu) {
            this.calculateCanvasMenuPosition = false;
            this.currentMenuPos = (y - this.menuHeightPos) / this.lineHeight;
            this.repaint();
            return;
        }
        if (y < this.lineHeight) {
            if (this.numItems == 0) {
                return;
            }
            int from = this.startPos + this.currentPos;
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.lineHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            int to = this.startPos + this.currentPos;
            this.adjustRunningTotal(from, to);
            this.repaint();
            return;
        }
        if (y > this.height - this.lineHeight) {
            if (this.numItems == 0) {
                return;
            }
            int from = this.startPos + this.currentPos;
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
            int to = this.startPos + this.currentPos;
            this.adjustRunningTotal(from, to);
            this.repaint();
            return;
        }
        this.pointerExecute = true;
        int newPos = (y - this.lineHeight) / this.lineHeight;
        if (this.startPos + newPos >= this.numItems) {
            this.alwaysDisplayMenu = true;
            return;
        }
        int from = this.startPos + this.currentPos;
        int to = this.startPos + newPos;
        this.adjustRunningTotal(from, to);
        this.currentPos = newPos;
        this.currentY = (this.currentPos + 1) * this.lineHeight;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        if (this.dragScreen) {
            this.dragScreen = false;
            return;
        }
        if (this.showCanvasMenu) {
            this.showCanvasMenu = false;
            this.repaint();
            if (x < this.menuWidthPos || x > this.menuWidthPos + this.menuWidth || y < this.menuHeightPos || y > this.menuHeightPos + this.menuHeight) {
                this.setupCanvasMenu();
                return;
            }
            int k = (y - this.menuHeightPos) / this.lineHeight + this.startMenuPos;
            this.processMenuCommand(k);
            return;
        }
        this.timePointerOnScreen = System.currentTimeMillis() - this.timePointerOnScreen;
        if (this.timePointerOnScreen > (long)this.parent.longTapDelay) {
            if (y < this.lineHeight) {
                this.startPos = 0;
                this.currentPos = 0;
                this.currentY = this.lineHeight;
                if (this.parent.normalSortOrder) {
                    this.rt = this.parent.totalFound;
                } else {
                    this.t = this.getTransactionFromIndex(0);
                    this.rt = this.t.amount;
                }
                this.repaint();
                return;
            }
            if (y > this.height - this.lineHeight) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                if (this.parent.normalSortOrder) {
                    this.t = this.getTransactionFromIndex(this.numItems - 1);
                    this.rt = this.t.amount;
                } else {
                    this.rt = this.parent.totalFound;
                }
                this.repaint();
                return;
            }
        }
        if (this.alwaysDisplayMenu || this.timePointerOnScreen > (long)this.parent.longTapDelay) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.repaint();
            } else {
                this.displayPopupMenu();
            }
            return;
        }
        if (!this.pointerExecute) {
            return;
        }
        int newPos = (y - this.lineHeight) / this.lineHeight;
        if (newPos == this.currentPos || newPos >= this.numItems) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.repaint();
            } else {
                this.displayPopupMenu();
            }
            return;
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        int from = this.startPos + this.currentPos;
        int scroll = (y - this.lastDragY) / this.lineHeight;
        if (scroll == 0) {
            return;
        }
        if (scroll > 0) {
            if (this.showCanvasMenu) {
                this.startMenuPos -= scroll;
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
                this.currentMenuPos += scroll;
                if (this.currentMenuPos > Math.min(this.numMenuItems, this.numItemsPage) - 1) {
                    this.currentMenuPos = Math.min(this.numMenuItems, this.numItemsPage) - 1;
                }
            } else {
                this.startPos -= scroll;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                this.currentPos += scroll;
                if (this.currentPos > Math.min(this.numItems, this.numItemsPage) - 1) {
                    this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                }
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
        }
        if (scroll < 0) {
            if (this.showCanvasMenu) {
                this.startMenuPos -= scroll;
                if (this.startMenuPos + this.numItemsPage > this.numMenuItems - 1) {
                    this.startMenuPos = this.numMenuItems - this.numItemsPage;
                }
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
                this.currentMenuPos += scroll;
                if (this.currentMenuPos < 0) {
                    this.currentMenuPos = 0;
                }
            } else {
                this.startPos -= scroll;
                if (this.startPos + this.currentPos > this.numItems - 1) {
                    this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                    this.startPos = this.numItems - 1 - this.currentPos;
                    this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                }
                this.currentPos += scroll;
                if (this.currentPos < 0) {
                    this.currentPos = 0;
                }
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
        }
        this.lastDragY = y;
        int to = this.startPos + this.currentPos;
        this.adjustRunningTotal(from, to);
        this.repaint();
        this.dragScreen = true;
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        int notches = mwe.getWheelRotation();
        if (notches == 0) {
            return;
        }
        if (notches > 0) {
            for (int i = 0; i < notches; ++i) {
                this.drawDown();
            }
        } else {
            notches = -notches;
            for (int i = 0; i < notches; ++i) {
                this.drawUp();
            }
        }
    }

    void displayPopupMenu() {
        if (this.showingPopupMenu) {
            this.showingPopupMenu = false;
            return;
        }
        PopupMenu pm = new PopupMenu();
        MenuItem miShow = new MenuItem("Show");
        MenuItem miGoToEntry = new MenuItem("Go To Entry");
        MenuItem miNewFind = new MenuItem("New Find");
        MenuItem miClose = new MenuItem("Home");
        miShow.addActionListener(this);
        miGoToEntry.addActionListener(this);
        miNewFind.addActionListener(this);
        miClose.addActionListener(this);
        pm.add(miShow);
        pm.add(miGoToEntry);
        pm.add(miNewFind);
        pm.add(miClose);
        this.add(pm);
        int x = 0;
        int y = 0;
        if (this.point == null) {
            pm.show(this, x, y);
        } else {
            Point move = this.movePopup(4, x, y);
            pm.show(this, move.x + this.point.x, move.y + this.point.y);
        }
        this.showingPopupMenu = true;
    }

    Point movePopup(int n, int x, int y) {
        int popupHeight = n * this.lineHeight * 4 / 3;
        if (this.parent.useCanvasMenu && x + this.point.x + this.menuWidth > this.width) {
            x = this.width - this.menuWidth - this.point.x;
        }
        if (y + this.point.y + popupHeight > this.height) {
            y = this.height - popupHeight - this.point.y;
        }
        Point move = new Point(x, y);
        return move;
    }

    void setupCanvasMenu() {
        this.startMenuPos = 0;
        this.currentMenuPos = 0;
        this.canvasMenu = new Vector(4);
        this.canvasMenu.addElement("Show");
        this.canvasMenu.addElement("Go To Entry");
        this.canvasMenu.addElement("New Find");
        this.canvasMenu.addElement("Home");
        this.menuWidth = this.fm.stringWidth("Go To Entry") + 6;
    }

    void displayCanvasMenu() {
        this.numMenuItems = this.canvasMenu.size();
        this.menuWidthPos = (this.width - this.menuWidth) / 2;
        if (this.menuWidthPos < 0) {
            this.menuWidthPos = 0;
        }
        this.menuHeightPos = (this.height - this.lineHeight * 2 - this.numMenuItems * this.lineHeight) / 2;
        if (this.menuHeightPos < this.lineHeight) {
            this.menuHeightPos = this.lineHeight;
        }
        this.menuHeight = Math.min(this.height - this.lineHeight * 2, this.numMenuItems * this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorMessage));
        this.g1.fillRect(this.menuWidthPos, this.menuHeightPos, this.menuWidth, this.menuHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        for (int i = 0; i < this.numItemsPage && i + this.startMenuPos <= this.numMenuItems - 1; ++i) {
            int vpos = i * this.lineHeight + this.lineHeight + this.menuHeightPos - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
            if (i == this.currentMenuPos) {
                this.g1.setColor(new Color(this.parent.colorCursor));
                this.g1.fillRect(this.menuWidthPos, this.lineHeight * i + this.menuHeightPos, this.menuWidth, this.lineHeight);
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            this.g1.drawString((String)this.canvasMenu.elementAt(i + this.startMenuPos), this.menuWidthPos + 3, vpos);
        }
    }

    void processMenuCommand(int k) {
        this.repaint();
        this.commandAction((String)this.canvasMenu.elementAt(k));
    }

    public void commandAction(String cmd) {
        this.showingPopupMenu = false;
        if (cmd.equals("Exit")) {
            this.parent.findHt = null;
            if (this.parent.tv == null) {
                this.ts.closeTransactionStore();
            }
            this.parent.finishAndQuit();
            return;
        }
        if (cmd.equals("Home")) {
            if (this.parent.useCanvasMenu && this.showCanvasMenu) {
                this.showCanvasMenu = false;
                this.repaint();
                return;
            }
            this.parent.findHt = null;
            if (this.parent.tv == null) {
                this.ts.closeTransactionStore();
            }
            if (this.fromCategoryView) {
                this.parent.cv.paintWholeScreen = true;
                this.parent.cv.paintHeaderOnly = false;
                this.parent.setContentView(this.parent.cv);
            } else {
                this.parent.av.paintWholeScreen = true;
                this.parent.av.paintHeaderOnly = false;
                if (this.parent.saveStateOnHome) {
                    this.parent.saveState();
                }
                this.parent.setContentView(this.parent.av);
            }
            return;
        }
        if (cmd.equals("Go To Entry")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "No entry to go to", 2000).show();
                return;
            }
            this.parent.findHt = null;
            if (this.parent.tv == null) {
                this.ts.closeTransactionStore();
            }
            Account a = this.parent.av.as.getAccountFromName(this.t.account);
            if (this.parent.tv != null) {
                this.parent.tv.ts.closeTransactionStore();
                this.parent.tv.rs.closeRegularStore();
            }
            this.parent.tv = new TransactionView(this.parent, a);
            this.parent.setContentView(this.parent.tv);
            this.parent.tv.goToTransaction(this.t);
            this.parent.tv.start = false;
            this.parent.tv.repaint();
            return;
        }
        if (cmd.equals("Show")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to show", 2000).show();
                return;
            }
            this.parent.gsf = new GenericShowForm(this.parent, this.t, 6);
            this.parent.setContentView(this.parent.gsf);
            return;
        }
        if (cmd.equals("New Find")) {
            new FindForm(this.parent);
            return;
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int keyCode = keyEvent.getKeyCode();
        switch (keyCode) {
            case 33: 
            case 37: {
                int from = this.startPos + this.currentPos;
                if (this.startPos == 0) {
                    this.currentPos = 0;
                    this.currentY = this.lineHeight;
                } else {
                    this.startPos -= this.numItemsPage;
                    if (this.startPos < 0) {
                        this.startPos = 0;
                    }
                }
                int to = this.startPos + this.currentPos;
                this.adjustRunningTotal(from, to);
                break;
            }
            case 34: 
            case 39: {
                int from = this.startPos + this.currentPos;
                this.startPos += this.numItemsPage;
                if (this.startPos + this.currentPos > this.numItems - 1) {
                    this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                    this.startPos = this.numItems - 1 - this.currentPos;
                    this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                }
                int to = this.startPos + this.currentPos;
                this.adjustRunningTotal(from, to);
                break;
            }
            case 38: {
                this.drawUp();
                break;
            }
            case 40: {
                this.drawDown();
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int keyCode = keyEvent.getKeyCode();
        switch (keyCode) {
            case 36: {
                this.startPos = 0;
                this.currentPos = 0;
                this.currentY = this.lineHeight;
                if (this.parent.normalSortOrder) {
                    this.rt = this.parent.totalFound;
                    break;
                }
                this.t = this.getTransactionFromIndex(0);
                this.rt = this.t.amount;
                break;
            }
            case 35: {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                if (this.parent.normalSortOrder) {
                    this.t = this.getTransactionFromIndex(this.numItems - 1);
                    this.rt = this.t.amount;
                    break;
                }
                this.rt = this.parent.totalFound;
                break;
            }
            case 10: 
            case 525: {
                if (this.showCanvasMenu) {
                    this.showCanvasMenu = false;
                    this.processMenuCommand(this.startMenuPos + this.currentMenuPos);
                    this.repaint();
                    return;
                }
                if (this.numItems == 0) break;
                if (this.parent.useCanvasMenu) {
                    this.showCanvasMenu = true;
                    break;
                }
                if (keyCode != 525) break;
                this.displayPopupMenu();
                break;
            }
            case 27: {
                this.parent.onBackPressed();
                break;
            }
            case 71: {
                this.commandAction("Go To Entry");
                break;
            }
            case 83: {
                this.commandAction("Show");
                break;
            }
            case 86: {
                this.commandAction("Switch Views");
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

