/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Frame;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JTextField;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.AccountStore;
import org.freepoc.Jabp4.AccountView;
import org.freepoc.Jabp4.Category;
import org.freepoc.Jabp4.CategoryStore;
import org.freepoc.Jabp4.DateChooser;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.FindView;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.LongId;
import org.freepoc.Jabp4.LongIntId;
import org.freepoc.Jabp4.Split;
import org.freepoc.Jabp4.TimedMessage;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.TransactionStore;
import org.freepoc.Jabp4.Utilities;

public class FindForm
extends Component
implements Runnable {
    Jabp parent;
    Thread thread;
    long ldFrom = 0L;
    long ldTo = 0L;
    int previousLastUsedScreen = 0;
    boolean useAllAccounts = true;
    boolean useAllCategories = true;

    public FindForm(Jabp context) {
        this.parent = context;
        this.previousLastUsedScreen = this.parent.lastUsedScreen;
        this.parent.lastUsedScreen = 17;
        this.createFindForm();
    }

    void createFindForm() {
        int i;
        DialogManager dm = new DialogManager(this.parent, "Find Options");
        JTextField tfFindString = dm.addJTextField("Find text", this.parent.lastFindString);
        CheckboxGroup cbFindType = dm.addCheckboxGroup();
        boolean state0 = true;
        boolean state1 = false;
        boolean state2 = false;
        if (this.parent.lastFindType == 1) {
            state0 = false;
            state1 = true;
            state2 = false;
        }
        if (this.parent.lastFindType == 2) {
            state0 = false;
            state1 = false;
            state2 = true;
        }
        dm.addCheckboxItem("Find in", "Description", state0, "Reference", state1, "Either", state2, cbFindType);
        String s = "";
        if (this.parent.lastFindFromAmount != 0) {
            s = Utilities.numberToString(Math.abs(this.parent.lastFindFromAmount), this.parent.numericEntry, this.parent.isEuropeanNumberFormat, false);
        }
        JTextField tfFromAmount = dm.addJTextField("From amount", s);
        CheckboxGroup cbFromAmount = dm.addCheckboxGroup();
        boolean state = this.parent.lastFindFromAmount <= 0;
        dm.addCheckboxItem("DR/CR", "DR", state, "CR", !state, cbFromAmount);
        s = "";
        if (this.parent.lastFindToAmount != 0) {
            s = Utilities.numberToString(Math.abs(this.parent.lastFindToAmount), this.parent.numericEntry, this.parent.isEuropeanNumberFormat, false);
        }
        JTextField tfToAmount = dm.addJTextField("To amount", s);
        CheckboxGroup cbToAmount = dm.addCheckboxGroup();
        state = this.parent.lastFindToAmount <= 0;
        dm.addCheckboxItem("DR/CR", "DR", state, "CR", !state, cbToAmount);
        this.setLastFindDates();
        Date date = new Date();
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf2 = null;
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf2 = new SimpleDateFormat("dd/MM/yy HH");
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            sdf = new SimpleDateFormat("MM/dd/yyyy");
            sdf2 = new SimpleDateFormat("MM/dd/yy HH");
        }
        JTextField tfFromDate = dm.addJTextFieldWithButton("From date", sdf.format(this.parent.lastFindFromDate), "1>");
        JTextField tfToDate = dm.addJTextFieldWithButton("To date", sdf.format(this.parent.lastFindToDate), "2>");
        CheckboxGroup cbReconciled = dm.addCheckboxGroup();
        state = this.parent.lastFindIncludeReconciled;
        dm.addCheckboxItem("Reconciled", "All items", state, "Unreconciled", !state, cbReconciled);
        CheckboxGroup cbTransfers = dm.addCheckboxGroup();
        state = this.parent.lastFindIncludeTransfers;
        dm.addCheckboxItem("Transfers", "All items", state, "Exc. transfers", !state, cbTransfers);
        state = true;
        if (this.previousLastUsedScreen == 1 || this.parent.lastFindSelectedAccounts != null) {
            state = false;
        }
        CheckboxGroup cbAccounts = dm.addCheckboxGroup();
        dm.addCheckboxItemWithButton("Accounts", "All", state, "Selected", !state, cbAccounts, "Reset accs");
        JList JListAccounts = dm.addJList("Account");
        AccountStore as = null;
        as = this.parent.av == null ? new AccountStore(this.parent, true) : this.parent.av.as;
        Account a = null;
        int n = as.getNumAccounts();
        for (int i2 = 0; i2 < n; ++i2) {
            a = as.getAccountFromIndex(i2);
            dm.addJListItem(JListAccounts, a.name);
            if (this.previousLastUsedScreen == 1 && a.name.equals(this.parent.tv.a.name)) {
                dm.selectJListItem(JListAccounts, i2);
            }
            if (this.parent.lastFindSelectedAccounts == null || !this.parent.lastFindSelectedAccounts.contains(a.name)) continue;
            dm.selectJListItem(JListAccounts, i2);
        }
        if (this.parent.av == null) {
            as.closeAccountStore();
        }
        state = true;
        if (this.parent.lastFindSelectedCategories != null) {
            state = false;
        }
        CheckboxGroup cbCategories = dm.addCheckboxGroup();
        dm.addCheckboxItemWithButton("Categories", "All", state, "Selected", !state, cbCategories, "Reset cats");
        JList JListCategories = dm.addJList("Category");
        CategoryStore cs = null;
        cs = this.parent.cv == null ? new CategoryStore(this.parent, true) : this.parent.cv.cs;
        Category c = null;
        n = cs.getNumCategories();
        for (i = 0; i < n; ++i) {
            c = cs.getCategoryFromIndex(i);
            dm.addJListItem(JListCategories, c.name);
            if (this.parent.lastFindSelectedCategories == null || !this.parent.lastFindSelectedCategories.contains(c.name)) continue;
            dm.selectJListItem(JListCategories, i);
        }
        if (this.parent.cv == null) {
            cs.closeCategoryStore();
        }
        dm.addOKCancelButtons();
        dm.addButton("Clear");
        dm.centerShow();
        if (dm.checkButtonText().equals("Cancel")) {
            dm.dispose();
            this.parent.goToLastUsedView();
            return;
        }
        if (dm.checkButtonText().equals("Clear")) {
            this.parent.lastFindString = "";
            this.parent.lastFindToAmount = 0;
            this.parent.lastFindFromAmount = 0;
            this.parent.lastFindType = 0;
            this.parent.lastFindFromDate = null;
            this.parent.lastFindSelectedCategories = null;
            this.parent.lastFindSelectedAccounts = null;
            this.setLastFindDates();
            this.parent.lastFindIncludeTransfers = true;
            this.parent.lastFindIncludeReconciled = true;
            dm.dispose();
            this.createFindForm();
            return;
        }
        if (dm.checkButtonText().equals("Reset accs")) {
            this.parent.lastFindSelectedAccounts = null;
            dm.dispose();
            this.createFindForm();
            return;
        }
        if (dm.checkButtonText().equals("Reset cats")) {
            this.parent.lastFindSelectedCategories = null;
            dm.dispose();
            this.createFindForm();
            return;
        }
        if (dm.checkButtons()) {
            this.parent.lastFindString = dm.getUserText(tfFindString).toLowerCase();
            if (dm.getSelectedCheckbox(cbFindType).getLabel().equals("Description")) {
                this.parent.lastFindType = 0;
            }
            if (dm.getSelectedCheckbox(cbFindType).getLabel().equals("Reference")) {
                this.parent.lastFindType = 1;
            }
            if (dm.getSelectedCheckbox(cbFindType).getLabel().equals("Either")) {
                this.parent.lastFindType = 2;
            }
            if (this.parent.numericEntry) {
                this.parent.lastFindFromAmount = Utilities.stringToNumber(dm.getUserText(tfFromAmount), 0, true, this.parent.isEuropeanNumberFormat);
                this.parent.lastFindToAmount = Utilities.stringToNumber(dm.getUserText(tfToAmount), 0, true, this.parent.isEuropeanNumberFormat);
            } else {
                this.parent.lastFindFromAmount = Utilities.expressionToNumber(dm.getUserText(tfFromAmount), this.parent.isEuropeanNumberFormat);
                this.parent.lastFindToAmount = Utilities.expressionToNumber(dm.getUserText(tfToAmount), this.parent.isEuropeanNumberFormat);
            }
            if (dm.getSelectedCheckbox(cbFromAmount).getLabel().equals("DR")) {
                this.parent.lastFindFromAmount = -this.parent.lastFindFromAmount;
            }
            if (dm.getSelectedCheckbox(cbToAmount).getLabel().equals("DR")) {
                this.parent.lastFindToAmount = -this.parent.lastFindToAmount;
            }
            if (this.parent.lastFindFromAmount > this.parent.lastFindToAmount) {
                int tmp = this.parent.lastFindToAmount;
                this.parent.lastFindToAmount = this.parent.lastFindFromAmount;
                this.parent.lastFindFromAmount = tmp;
            }
            try {
                this.parent.lastFindFromDate = sdf2.parse(dm.getUserText(tfFromDate) + " 02");
                this.ldFrom = Utilities.longToDays(this.parent.lastFindFromDate.getTime());
            }
            catch (ParseException e) {
                Toast.makeText(this.parent, "Incorrect date", 2000).show();
                dm.dispose();
                new FindForm(this.parent);
                return;
            }
            try {
                this.parent.lastFindToDate = sdf2.parse(dm.getUserText(tfToDate) + " 02");
                this.ldTo = Utilities.longToDays(this.parent.lastFindToDate.getTime());
            }
            catch (ParseException e) {
                Toast.makeText(this.parent, "Incorrect date", 2000).show();
                dm.dispose();
                new FindForm(this.parent);
                return;
            }
            this.parent.lastFindIncludeReconciled = dm.getSelectedCheckbox(cbReconciled).getLabel().equals("All items");
            this.parent.lastFindIncludeTransfers = dm.getSelectedCheckbox(cbTransfers).getLabel().equals("All items");
            if (dm.getSelectedCheckbox(cbAccounts).getLabel().equals("All")) {
                this.useAllAccounts = true;
                this.parent.lastFindSelectedAccounts = null;
            } else {
                this.parent.lastFindSelectedAccounts = new Vector();
                for (i = 0; i < n; ++i) {
                    if (!dm.isJListIndexSelected(JListAccounts, i)) continue;
                    this.parent.lastFindSelectedAccounts.addElement(dm.getSelectedJListString(JListAccounts, i));
                    this.useAllAccounts = false;
                }
                if (this.parent.lastFindSelectedAccounts.size() == 0) {
                    this.parent.lastFindSelectedAccounts = null;
                    this.useAllAccounts = true;
                }
            }
            if (dm.getSelectedCheckbox(cbCategories).getLabel().equals("All")) {
                this.useAllCategories = true;
                this.parent.lastFindSelectedCategories = null;
            } else {
                this.parent.lastFindSelectedCategories = new Vector();
                for (i = 0; i < n; ++i) {
                    if (!dm.isJListIndexSelected(JListCategories, i)) continue;
                    this.parent.lastFindSelectedCategories.addElement(dm.getSelectedJListString(JListCategories, i));
                    this.useAllCategories = false;
                }
                if (this.parent.lastFindSelectedCategories.size() == 0) {
                    this.parent.lastFindSelectedCategories = null;
                    this.useAllCategories = true;
                }
            }
            if (dm.checkButtonText().equals("1>")) {
                GregorianCalendar gc = new GregorianCalendar();
                gc.setTime(this.parent.lastFindFromDate);
                DateChooser dc = new DateChooser((Frame)this.parent, gc);
                if (dc.showDateChooser() == 1) {
                    gc = dc.getDate();
                }
                this.parent.lastFindFromDate = gc.getTime();
                dm.dispose();
                new FindForm(this.parent);
                return;
            }
            if (dm.checkButtonText().equals("2>")) {
                GregorianCalendar gc = new GregorianCalendar();
                gc.setTime(this.parent.lastFindToDate);
                DateChooser dc = new DateChooser((Frame)this.parent, gc);
                if (dc.showDateChooser() == 1) {
                    gc = dc.getDate();
                }
                this.parent.lastFindToDate = gc.getTime();
                dm.dispose();
                new FindForm(this.parent);
                return;
            }
            dm.dispose();
            if (this.parent.av == null) {
                this.parent.av = new AccountView(this.parent);
            }
            this.parent.setContentView(this.parent.av);
            this.run();
            return;
        }
        dm.dispose();
    }

    void runThread() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        this.execute();
        this.parent.fv = new FindView(this.parent, "", false, this.parent.lastFindSelectedCategories);
        this.parent.setContentView(this.parent.fv);
    }

    void execute() {
        this.parent.totalFound = 0;
        this.parent.findHt = new Hashtable();
        TransactionStore ts = null;
        ts = this.parent.tv == null ? new TransactionStore(this.parent, new Account(), true) : this.parent.tv.ts;
        Transaction t = null;
        ts.setToStart();
        int count = 0;
        while ((t = ts.readNextTransaction()) != null) {
            long tldate;
            if (++count == count / 1000 * 1000) {
                new TimedMessage(this.parent, count + " transactions read");
            }
            if ((tldate = Utilities.longToDays(t.longDate)) < this.ldFrom || tldate > this.ldTo || this.parent.lastFindType == 0 && t.description.toLowerCase().indexOf(this.parent.lastFindString) < 0 || this.parent.lastFindType == 1 && t.reference.toLowerCase().indexOf(this.parent.lastFindString) < 0 || this.parent.lastFindType == 2 && t.description.toLowerCase().indexOf(this.parent.lastFindString) < 0 && t.reference.toLowerCase().indexOf(this.parent.lastFindString) < 0 || !this.parent.lastFindIncludeReconciled && t.reconciled || !this.parent.lastFindIncludeTransfers && t.transferFlag || !this.useAllAccounts && !this.parent.lastFindSelectedAccounts.contains(t.account) || (this.parent.lastFindFromAmount != 0 || this.parent.lastFindToAmount != 0) && (this.parent.lastFindFromAmount > t.amount || this.parent.lastFindToAmount < t.amount)) continue;
            if (this.useAllCategories) {
                this.addFindIndex(t, t.amount, -1);
                continue;
            }
            if (t.splitFlag) {
                for (int i = 0; i < t.ss.size(); ++i) {
                    Split split = t.ss.getSplit(i);
                    if (!this.parent.lastFindSelectedCategories.contains(split.category)) continue;
                    this.addFindIndex(t, split.amount, i);
                }
                continue;
            }
            if (!this.parent.lastFindSelectedCategories.contains(t.category)) continue;
            this.addFindIndex(t, t.amount, -1);
        }
        if (this.parent.tv == null) {
            ts.closeTransactionStore();
            ts = null;
        }
    }

    void addFindIndex(Transaction t, int amount, int splitNumber) {
        LongIntId li1;
        int i;
        int p = 0;
        int n = this.parent.findHt.size();
        long tlong = Utilities.longToDays(t.longDate);
        if (this.parent.normalSortOrder) {
            p = n;
            for (i = 0; i < n; ++i) {
                li1 = (LongIntId)this.parent.findHt.get(new Integer(i));
                if (tlong < Utilities.longToDays(li1.lo)) continue;
                p = i;
                break;
            }
        } else {
            p = 0;
            for (i = n - 1; i >= 0; --i) {
                li1 = (LongIntId)this.parent.findHt.get(new Integer(i));
                long tlong2 = Utilities.longToDays(li1.lo);
                if (tlong < tlong2) continue;
                p = i + 1;
                break;
            }
        }
        if (p < n) {
            for (i = n - 1; i >= p; --i) {
                int j = i + 1;
                LongIntId li2 = (LongIntId)this.parent.findHt.get(new Integer(i));
                this.parent.findHt.put(new Integer(j), li2);
            }
        }
        long tlong2 = t.longDate;
        LongIntId li3 = new LongIntId(tlong2, splitNumber, t.id);
        this.parent.findHt.put(new Integer(p), li3);
        this.parent.totalFound += amount;
    }

    void setLastFindDates() {
        if (this.parent.lastFindFromDate == null) {
            long tlong = this.parent.todayDate.getTime();
            Enumeration e = this.parent.transactionHt.elements();
            while (e.hasMoreElements()) {
                Hashtable ht = (Hashtable)e.nextElement();
                int n = ht.size();
                if (n <= 0) continue;
                tlong = Math.min(tlong, ((LongId)ht.get((Object)new Integer((int)0))).lo);
                tlong = Math.min(tlong, ((LongId)ht.get((Object)new Integer((int)(n - 1)))).lo);
            }
            this.parent.lastFindFromDate = new Date(tlong);
        }
        if (this.parent.lastFindToDate == null) {
            this.parent.lastFindToDate = new Date();
        }
    }

    void showInAccountView(String s1) {
        this.parent.av.show(s1, true);
    }
}

