/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Frame;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.AccountStore;
import org.freepoc.Jabp4.DateChooser;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.LongId;
import org.freepoc.Jabp4.Toast;

public class ExportQifOptionsForm
extends Component {
    Jabp parent;

    public ExportQifOptionsForm(Jabp context) {
        this.parent = context;
        this.parent.lastUsedScreen = 15;
        DialogManager dm = new DialogManager(this.parent, "Import/Export options");
        CheckboxGroup cbAllAccounts = dm.addCheckboxGroup();
        dm.addCheckboxItem("Accounts", "All", this.parent.ief.useAllAccounts, "Single", !this.parent.ief.useAllAccounts, cbAllAccounts);
        JComboBox chAccount = dm.addJComboBox("Account");
        AccountStore as = new AccountStore(this.parent, true);
        Account a = null;
        int n = as.getNumAccounts();
        for (int i = 0; i < n; ++i) {
            a = as.getAccountFromIndex(i);
            dm.addJComboBoxItem(chAccount, a.name);
            if (!a.name.equals(this.parent.ief.lastExportedAccount)) continue;
            dm.setSelectedJComboBox(chAccount, i);
        }
        as.closeAccountStore();
        CheckboxGroup cbReportType = dm.addCheckboxGroup();
        dm.addCheckboxItem("Report", "Transactions", this.parent.ief.isTransactionReport, "Income/Expense", !this.parent.ief.isTransactionReport, cbReportType);
        Date date = new Date();
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf2 = null;
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf2 = new SimpleDateFormat("dd/MM/yy HH");
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            sdf = new SimpleDateFormat("MM/dd/yyyy");
            sdf2 = new SimpleDateFormat("MM/dd/yy HH");
        }
        if (this.parent.ief.selectedFromDate == 0L) {
            this.setExportDates();
        }
        JTextField tfFromDate = dm.addJTextFieldWithButton("Date", sdf.format(new Date(this.parent.ief.selectedFromDate)), "1>");
        JTextField tfToDate = dm.addJTextFieldWithButton("Date", sdf.format(new Date(this.parent.ief.selectedToDate)), "2>");
        JComboBox chDateType = dm.addJComboBox("Date type");
        dm.addJComboBoxItem(chDateType, "dd/mm/yy");
        dm.addJComboBoxItem(chDateType, "mm/dd/yy");
        dm.addJComboBoxItem(chDateType, "dd.mm.yy");
        dm.addJComboBoxItem(chDateType, "mm.dd.yy");
        dm.addJComboBoxItem(chDateType, "dd/mm/yyyy");
        dm.addJComboBoxItem(chDateType, "mm/dd/yyyy");
        dm.addJComboBoxItem(chDateType, "yyyy-mm-dd");
        dm.setSelectedJComboBox(chDateType, this.parent.ief.qifDateFormat);
        CheckboxGroup cbYearSeparator = dm.addCheckboxGroup();
        dm.addCheckboxItem("Year separator", "/", this.parent.ief.useSlashForYear, "'", !this.parent.ief.useSlashForYear, cbYearSeparator);
        CheckboxGroup cbOpeningBalance = dm.addCheckboxGroup();
        dm.addCheckboxItem("Opening Balance", "Include", this.parent.ief.exportOpeningBalance, "Exclude", !this.parent.ief.exportOpeningBalance, cbOpeningBalance);
        CheckboxGroup cbIncludeTransfers = dm.addCheckboxGroup();
        dm.addCheckboxItem("Include Transfers", "Yes", this.parent.ief.includeTransfers, "No", !this.parent.ief.includeTransfers, cbIncludeTransfers);
        CheckboxGroup cbSeparateSplits = dm.addCheckboxGroup();
        dm.addCheckboxItem("Separate Splits", "Yes", this.parent.ief.separateSplits, "No", !this.parent.ief.separateSplits, cbSeparateSplits);
        JComboBox chFileType = dm.addJComboBox("File type");
        dm.addJComboBoxItem(chFileType, "QIF (Import/Export)");
        dm.addJComboBoxItem(chFileType, "OFX/OFC (Import only)");
        dm.addJComboBoxItem(chFileType, "CSV (Export only)");
        dm.addJComboBoxItem(chFileType, "TAB (Export only)");
        CheckboxGroup cbUseUTF8 = dm.addCheckboxGroup();
        dm.addCheckboxItem("Encoding", "UTF8", this.parent.ief.useUTF8, "ANSI", !this.parent.ief.useUTF8, cbUseUTF8);
        dm.addButton("Cancel");
        dm.addButton("Import");
        dm.addButton("Export");
        dm.centerShow();
        if (dm.checkButtonText().equals("Cancel")) {
            dm.dispose();
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            this.parent.ief.start();
            return;
        }
        this.parent.ief.useAllAccounts = dm.getSelectedCheckbox(cbAllAccounts).getLabel().equals("All");
        if (this.parent.ief.useAllAccounts && dm.checkButtonText().equals("Import")) {
            Toast.makeText(this.parent, "Cannot use All Accounts with Import", 2000).show();
            dm.dispose();
            new ExportQifOptionsForm(this.parent);
            return;
        }
        this.parent.ief.selectedAccount = dm.getSelectedJComboBoxString(chAccount);
        this.parent.ief.isTransactionReport = dm.getSelectedCheckbox(cbReportType).getLabel().equals("Transactions");
        try {
            this.parent.ief.selectedFromDate = sdf2.parse(dm.getUserText(tfFromDate) + " 02").getTime();
        }
        catch (ParseException e) {
            Toast.makeText(this.parent, "Incorrect date", 2000).show();
            dm.dispose();
            new ExportQifOptionsForm(this.parent);
            return;
        }
        try {
            this.parent.ief.selectedToDate = sdf2.parse(dm.getUserText(tfToDate) + " 02").getTime();
        }
        catch (ParseException e) {
            Toast.makeText(this.parent, "Incorrect date", 2000).show();
            dm.dispose();
            new ExportQifOptionsForm(this.parent);
            return;
        }
        this.parent.ief.qifDateFormat = dm.getSelectedJComboBoxItem(chDateType);
        this.parent.ief.useSlashForYear = dm.getSelectedCheckbox(cbYearSeparator).getLabel().equals("/");
        this.parent.ief.exportOpeningBalance = dm.getSelectedCheckbox(cbOpeningBalance).getLabel().equals("Include");
        this.parent.ief.includeTransfers = dm.getSelectedCheckbox(cbIncludeTransfers).getLabel().equals("Yes");
        this.parent.ief.separateSplits = dm.getSelectedCheckbox(cbSeparateSplits).getLabel().equals("Yes");
        this.parent.ief.exportType = dm.getSelectedJComboBoxItem(chFileType);
        this.parent.ief.useUTF8 = dm.getSelectedCheckbox(cbUseUTF8).getLabel().equals("UTF8");
        dm.dispose();
        if (dm.checkButtonText().equals("1>")) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis(this.parent.ief.selectedFromDate);
            DateChooser dc = new DateChooser((Frame)this.parent, gc);
            if (dc.showDateChooser() == 1) {
                gc = dc.getDate();
            }
            this.parent.ief.selectedFromDate = gc.getTime().getTime();
            new ExportQifOptionsForm(this.parent);
            return;
        }
        if (dm.checkButtonText().equals("2>")) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis(this.parent.ief.selectedToDate);
            DateChooser dc = new DateChooser((Frame)this.parent, gc);
            if (dc.showDateChooser() == 1) {
                gc = dc.getDate();
            }
            this.parent.ief.selectedToDate = gc.getTime().getTime();
            new ExportQifOptionsForm(this.parent);
            return;
        }
        if (dm.checkButtonText().equals("Import")) {
            this.parent.ief.label = "Import";
            this.parent.ief.processExport();
            return;
        }
        if (dm.checkButtonText().equals("Export")) {
            this.parent.ief.label = "Export";
            this.parent.ief.processExport();
            return;
        }
    }

    void setExportDates() {
        this.parent.ief.selectedFromDate = new Date().getTime();
        this.parent.ief.selectedToDate = 0L;
        Enumeration e = this.parent.transactionHt.elements();
        while (e.hasMoreElements()) {
            Hashtable ht = (Hashtable)e.nextElement();
            int n = ht.size();
            if (n <= 0) continue;
            this.parent.ief.selectedFromDate = Math.min(this.parent.ief.selectedFromDate, ((LongId)ht.get((Object)new Integer((int)0))).lo);
            this.parent.ief.selectedFromDate = Math.min(this.parent.ief.selectedFromDate, ((LongId)ht.get((Object)new Integer((int)(n - 1)))).lo);
            this.parent.ief.selectedToDate = Math.max(this.parent.ief.selectedToDate, ((LongId)ht.get((Object)new Integer((int)0))).lo);
            this.parent.ief.selectedToDate = Math.max(this.parent.ief.selectedToDate, ((LongId)ht.get((Object)new Integer((int)(n - 1)))).lo);
        }
    }
}

