/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.freepoc.Jabp4.Jabp;

class DialogManager
extends JDialog
implements ActionListener,
FocusListener,
ItemListener,
KeyListener,
ListSelectionListener {
    Jabp parent;
    ScrollPane scrollPane;
    Panel mainPanel;
    Panel buttonPanel;
    GridBagLayout gbl;
    GridBagConstraints gbc;
    Font font;
    static boolean cb;
    static String cbtext;
    boolean labelFlag;
    boolean textFlag;
    long startTime;

    DialogManager(Jabp context, String dialogTitle) {
        super(context, dialogTitle, true);
        this.parent = context;
        this.font = new Font("dialog", 0, 16);
        this.setFont(this.font);
        this.startTime = System.currentTimeMillis();
        this.setLayout(new BorderLayout(2, 2));
        this.labelFlag = false;
        this.textFlag = false;
        this.scrollPane = new ScrollPane();
        Adjustable vAdjust = this.scrollPane.getVAdjustable();
        Adjustable hAdjust = this.scrollPane.getHAdjustable();
        vAdjust.setUnitIncrement(20);
        hAdjust.setUnitIncrement(20);
        vAdjust.setBlockIncrement(100);
        hAdjust.setBlockIncrement(100);
        this.mainPanel = new Panel();
        this.buttonPanel = new Panel();
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 1;
        this.gbc.insets = new Insets(2, 5, 2, 5);
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
    }

    void addButton(String buttonText) {
        Button button = new Button(buttonText);
        button.setFont(this.font);
        button.addActionListener(this);
        button.addFocusListener(this);
        button.addKeyListener(this);
        this.buttonPanel.add(button);
    }

    void addInvisibleButton() {
        Button button = new Button();
        button.setFont(this.font);
        button.addActionListener(this);
        button.addFocusListener(this);
        button.addKeyListener(this);
        this.buttonPanel.add(button);
    }

    void addOKCancelButtons() {
        this.addButton("Cancel");
        this.addButton("OK");
    }

    void addText(String message) {
        this.textFlag = true;
        Label label = new Label(message);
        label.setFont(this.font);
        label.setAlignment(0);
        this.gbc.gridwidth = 0;
        this.gbl.setConstraints(label, this.gbc);
        this.mainPanel.add(label);
    }

    void addJTextArea(String message, int size, boolean colorBlue) {
        this.textFlag = true;
        JTextArea ta = new JTextArea(message);
        ta.setFont(new Font("dialog", 0, size));
        ta.setEditable(false);
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        ta.setOpaque(false);
        if (colorBlue) {
            ta.setForeground(Color.BLUE);
        }
        this.gbc.gridwidth = 0;
        this.gbl.setConstraints(ta, this.gbc);
        this.mainPanel.add(ta);
        if (colorBlue) {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 2));
            p.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.gbl.setConstraints(p, this.gbc);
            this.mainPanel.add(p);
        }
    }

    void addJTextArea(String message, int size) {
        this.addJTextArea(message, size, false);
    }

    void addHorizontalSeparator() {
        JSeparator separator = new JSeparator();
        this.gbc.gridwidth = 0;
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 2));
        p.add(separator);
        p.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.gbl.setConstraints(p, this.gbc);
        this.mainPanel.add(p);
    }

    void addText(String message1, String message2) {
        this.addLabel(message1);
        this.addLabel2(message2);
    }

    void addText2(String message) {
        this.textFlag = true;
        Label label = new Label(message);
        label.setFont(this.font);
        label.setAlignment(1);
        this.gbc.gridwidth = 0;
        this.gbl.setConstraints(label, this.gbc);
        this.mainPanel.add(label);
    }

    JPasswordField addJPasswordField(String label, String message) {
        this.addLabel(label);
        JPasswordField myJPasswordField = new JPasswordField(message, 5);
        myJPasswordField.setFont(this.font);
        this.gbc.gridwidth = 0;
        this.gbl.setConstraints(myJPasswordField, this.gbc);
        this.mainPanel.add(myJPasswordField);
        myJPasswordField.addKeyListener(this);
        myJPasswordField.addFocusListener(this);
        return myJPasswordField;
    }

    JTextField addJTextField(String label, String message, int length) {
        this.addLabel(label);
        JTextField myJTextField = new JTextField(message, length);
        myJTextField.setFont(this.font);
        this.gbc.gridwidth = 0;
        this.gbl.setConstraints(myJTextField, this.gbc);
        this.mainPanel.add(myJTextField);
        myJTextField.addKeyListener(this);
        myJTextField.addFocusListener(this);
        return myJTextField;
    }

    JTextField addJTextField(String message) {
        JTextField myJTextField = new JTextField(message, 5);
        myJTextField.setFont(this.font);
        this.gbc.gridwidth = 0;
        this.gbl.setConstraints(myJTextField, this.gbc);
        this.mainPanel.add(myJTextField);
        myJTextField.addKeyListener(this);
        myJTextField.addFocusListener(this);
        return myJTextField;
    }

    JTextField addJTextField(String label, String message) {
        this.addLabel(label);
        JTextField myJTextField = new JTextField(message, 5);
        myJTextField.setFont(this.font);
        this.gbc.gridwidth = 0;
        this.gbl.setConstraints(myJTextField, this.gbc);
        this.mainPanel.add(myJTextField);
        myJTextField.addKeyListener(this);
        myJTextField.addFocusListener(this);
        return myJTextField;
    }

    JTextField addJTextField(int color, String label, String message) {
        this.labelFlag = true;
        Label lab = new Label("  ");
        lab.setAlignment(0);
        this.gbc.gridwidth = 1;
        this.gbl.setConstraints(lab, this.gbc);
        lab.setBackground(new Color(color));
        this.mainPanel.add(lab);
        lab = new Label(label);
        lab.setAlignment(0);
        this.gbc.gridwidth = 1;
        this.gbl.setConstraints(lab, this.gbc);
        this.mainPanel.add(lab);
        JTextField myJTextField = new JTextField(message, 20);
        myJTextField.setFont(this.font);
        this.gbc.gridwidth = 0;
        this.gbl.setConstraints(myJTextField, this.gbc);
        this.mainPanel.add(myJTextField);
        myJTextField.addKeyListener(this);
        myJTextField.addFocusListener(this);
        return myJTextField;
    }

    JTextField addJTextFieldWithButton(String label, String message, String buttonText) {
        this.addLabel(label);
        Button button = new Button(buttonText);
        button.addActionListener(this);
        button.addFocusListener(this);
        button.addKeyListener(this);
        this.gbc.gridwidth = 17;
        this.gbl.setConstraints(button, this.gbc);
        this.mainPanel.add(button);
        JTextField myJTextField = new JTextField(message, 15);
        myJTextField.setFont(this.font);
        this.gbc.gridwidth = 0;
        this.gbl.setConstraints(myJTextField, this.gbc);
        this.mainPanel.add(myJTextField);
        myJTextField.addKeyListener(this);
        myJTextField.addFocusListener(this);
        return myJTextField;
    }

    JTextField addJTextFieldWithIcon(String label, String message, JLabel iconLabel) {
        this.addLabel(label);
        this.mainPanel.add(iconLabel);
        JTextField myJTextField = new JTextField(message, 15);
        myJTextField.setFont(this.font);
        this.gbc.gridwidth = 0;
        this.gbl.setConstraints(myJTextField, this.gbc);
        this.mainPanel.add(myJTextField);
        myJTextField.addKeyListener(this);
        myJTextField.addFocusListener(this);
        return myJTextField;
    }

    JTextField addJTextFieldWithButton(String label, String message) {
        return this.addJTextFieldWithButton(label, message, ">");
    }

    JTextField addJTextFieldWithButtons(String label, String message, String buttonText1, String buttonText2, String buttonText3) {
        this.addLabel(label);
        Button button1 = new Button(buttonText1);
        button1.addActionListener(this);
        button1.addFocusListener(this);
        button1.addKeyListener(this);
        Button button2 = new Button(buttonText2);
        button2.addActionListener(this);
        button2.addFocusListener(this);
        button2.addKeyListener(this);
        Button button3 = new Button(buttonText3);
        button3.addActionListener(this);
        button3.addFocusListener(this);
        button3.addKeyListener(this);
        this.mainPanel.add(button1);
        this.mainPanel.add(button2);
        this.mainPanel.add(button3);
        JTextField myJTextField = new JTextField(message, 15);
        myJTextField.setFont(this.font);
        this.gbc.gridwidth = 0;
        this.gbl.setConstraints(myJTextField, this.gbc);
        this.mainPanel.add(myJTextField);
        myJTextField.addKeyListener(this);
        myJTextField.addFocusListener(this);
        return myJTextField;
    }

    JTextField addJTextFieldWithButtons(String label, String message) {
        return this.addJTextFieldWithButtons(label, message, "-", "+", ">");
    }

    String getUserText(JTextField myJTextField) {
        return myJTextField.getText();
    }

    double getUserDouble(JTextField myJTextField) {
        double d;
        NumberFormat nf = NumberFormat.getInstance();
        try {
            d = nf.parse(myJTextField.getText()).doubleValue();
        }
        catch (ParseException pe) {
            d = 0.0;
        }
        return d;
    }

    int getUserInt(JTextField myJTextField) {
        int i;
        NumberFormat nf = NumberFormat.getInstance();
        try {
            i = nf.parse(myJTextField.getText()).intValue();
        }
        catch (ParseException pe) {
            i = 0;
        }
        return i;
    }

    CheckboxGroup addCheckboxGroup() {
        CheckboxGroup myCheckboxGroup = new CheckboxGroup();
        return myCheckboxGroup;
    }

    void addCheckboxItem(String checkboxItem1, boolean state1, String checkboxItem2, boolean state2, CheckboxGroup myCheckboxGroup) {
        this.addCheckboxItem("", checkboxItem1, state1, checkboxItem2, state2, myCheckboxGroup);
    }

    void addCheckboxItem(String message, String checkboxItem1, boolean state1, String checkboxItem2, boolean state2, CheckboxGroup myCheckboxGroup) {
        if (!message.equals("")) {
            this.addLabel(message);
        }
        Checkbox cbox1 = new Checkbox(checkboxItem1, myCheckboxGroup, state1);
        cbox1.setFont(this.font);
        this.gbc.gridwidth = 17;
        this.gbl.setConstraints(cbox1, this.gbc);
        this.mainPanel.add(cbox1);
        cbox1.addItemListener(this);
        Checkbox cbox2 = new Checkbox(checkboxItem2, myCheckboxGroup, state2);
        cbox2.setFont(this.font);
        this.gbc.gridwidth = 17;
        this.gbl.setConstraints(cbox2, this.gbc);
        this.mainPanel.add(cbox2);
        cbox2.addItemListener(this);
        Label label = new Label("");
        this.gbc.gridwidth = 0;
        this.gbl.setConstraints(label, this.gbc);
        this.mainPanel.add(label);
    }

    void addCheckboxItem(String checkboxItem1, boolean state1, String checkboxItem2, boolean state2, String checkboxItem3, boolean state3, CheckboxGroup myCheckboxGroup) {
        this.addCheckboxItem("", checkboxItem1, state1, checkboxItem2, state2, checkboxItem3, state3, myCheckboxGroup);
    }

    void addCheckboxItem(String message, String checkboxItem1, boolean state1, String checkboxItem2, boolean state2, String checkboxItem3, boolean state3, CheckboxGroup myCheckboxGroup) {
        if (!message.equals("")) {
            this.addLabel(message);
        }
        Checkbox cbox1 = new Checkbox(checkboxItem1, myCheckboxGroup, state1);
        cbox1.setFont(this.font);
        this.gbc.gridwidth = 17;
        this.gbl.setConstraints(cbox1, this.gbc);
        this.mainPanel.add(cbox1);
        cbox1.addItemListener(this);
        Checkbox cbox2 = new Checkbox(checkboxItem2, myCheckboxGroup, state2);
        cbox2.setFont(this.font);
        this.gbc.gridwidth = 17;
        this.gbl.setConstraints(cbox2, this.gbc);
        this.mainPanel.add(cbox2);
        cbox2.addItemListener(this);
        Checkbox cbox3 = new Checkbox(checkboxItem3, myCheckboxGroup, state3);
        cbox3.setFont(this.font);
        this.gbc.gridwidth = 17;
        this.gbl.setConstraints(cbox3, this.gbc);
        this.mainPanel.add(cbox3);
        cbox3.addItemListener(this);
        Label label = new Label("");
        this.gbc.gridwidth = 0;
        this.gbl.setConstraints(label, this.gbc);
        this.mainPanel.add(label);
    }

    void addCheckboxItemWithButton(String checkboxItem1, boolean state1, String checkboxItem2, boolean state2, CheckboxGroup myCheckboxGroup, String buttonText) {
        this.addCheckboxItemWithButton("", checkboxItem1, state1, checkboxItem2, state2, myCheckboxGroup, buttonText);
    }

    void addCheckboxItemWithButton(String message, String checkboxItem1, boolean state1, String checkboxItem2, boolean state2, CheckboxGroup myCheckboxGroup, String buttonText) {
        if (!message.equals("")) {
            this.addLabel(message);
        }
        Checkbox cbox1 = new Checkbox(checkboxItem1, myCheckboxGroup, state1);
        cbox1.setFont(this.font);
        this.gbc.gridwidth = 17;
        this.gbl.setConstraints(cbox1, this.gbc);
        this.mainPanel.add(cbox1);
        cbox1.addItemListener(this);
        Checkbox cbox2 = new Checkbox(checkboxItem2, myCheckboxGroup, state2);
        cbox2.setFont(this.font);
        this.gbc.gridwidth = 17;
        this.gbl.setConstraints(cbox2, this.gbc);
        this.mainPanel.add(cbox2);
        cbox2.addItemListener(this);
        Button button = new Button(buttonText);
        button.setFont(this.font);
        button.addActionListener(this);
        button.addFocusListener(this);
        button.addKeyListener(this);
        this.mainPanel.add(button);
        Label label = new Label("");
        this.gbc.gridwidth = 0;
        this.gbl.setConstraints(label, this.gbc);
        this.mainPanel.add(label);
    }

    Checkbox getSelectedCheckbox(CheckboxGroup myCheckboxGroup) {
        return myCheckboxGroup.getSelectedCheckbox();
    }

    JList addJList(String message) {
        return this.addJList(message, 0, true);
    }

    JList addJList(String message, int rows, boolean multipleMode) {
        this.addLabel(message);
        DefaultListModel dlm = new DefaultListModel();
        JList myJList = new JList(dlm);
        myJList.setFont(this.font);
        if (rows > 0) {
            myJList.setVisibleRowCount(rows);
        }
        if (multipleMode) {
            myJList.setSelectionMode(2);
        } else {
            myJList.setSelectionMode(0);
        }
        this.gbc.gridwidth = 0;
        this.gbl.setConstraints(myJList, this.gbc);
        this.mainPanel.add(myJList);
        myJList.addListSelectionListener(this);
        return myJList;
    }

    void addJListItem(JList myJList, String listItem) {
        DefaultListModel dlm = (DefaultListModel)myJList.getModel();
        dlm.addElement(listItem);
    }

    void selectJListItem(JList myJList, int i) {
        myJList.setSelectedIndex(i);
    }

    String getSelectedJListString(JList myJList, int i) {
        DefaultListModel dlm = (DefaultListModel)myJList.getModel();
        return (String)dlm.getElementAt(i);
    }

    int getSelectedJListIndex(JList myJList) {
        return myJList.getSelectedIndex();
    }

    boolean isJListIndexSelected(JList myJList, int i) {
        return myJList.isSelectedIndex(i);
    }

    JComboBox addJComboBox(String message) {
        if (!message.equals("")) {
            this.addLabel(message);
        }
        JComboBox myJComboBox = new JComboBox();
        myJComboBox.setLightWeightPopupEnabled(false);
        myJComboBox.setFont(this.font);
        this.gbc.gridwidth = 0;
        this.gbl.setConstraints(myJComboBox, this.gbc);
        this.mainPanel.add(myJComboBox);
        myJComboBox.addItemListener(this);
        myJComboBox.addKeyListener(this);
        myJComboBox.addFocusListener(this);
        return myJComboBox;
    }

    void addJComboBoxItem(JComboBox myJComboBox, String choiceItem) {
        myJComboBox.addItem(choiceItem);
    }

    int getSelectedJComboBoxItem(JComboBox myJComboBox) {
        return myJComboBox.getSelectedIndex();
    }

    String getSelectedJComboBoxString(JComboBox myJComboBox) {
        return (String)myJComboBox.getSelectedItem();
    }

    void setSelectedJComboBox(JComboBox myJComboBox, int selectedIndex) {
        myJComboBox.setSelectedIndex(selectedIndex);
    }

    void setSelectedJComboBox(JComboBox myJComboBox, String selectedItem) {
        myJComboBox.setSelectedItem(selectedItem);
    }

    void addLabel(String message) {
        this.labelFlag = true;
        Label label = new Label(message);
        label.setFont(this.font);
        label.setAlignment(0);
        this.gbc.gridwidth = 1;
        this.gbl.setConstraints(label, this.gbc);
        this.mainPanel.add(label);
    }

    void addLabel2(String message) {
        this.labelFlag = true;
        Label label = new Label(message);
        label.setFont(this.font);
        label.setAlignment(0);
        this.gbc.gridwidth = 0;
        this.gbl.setConstraints(label, this.gbc);
        this.mainPanel.add(label);
    }

    void centerShow() {
        GridLayout gl;
        if (this.mainPanel.getComponentCount() > 0) {
            this.scrollPane.add(this.mainPanel);
            this.add("Center", this.scrollPane);
        }
        this.add("South", this.buttonPanel);
        if (this.labelFlag) {
            this.mainPanel.setLayout(this.gbl);
        } else {
            this.mainPanel.setLayout(new FlowLayout());
        }
        if (this.textFlag && !this.labelFlag) {
            gl = new GridLayout(0, 1);
            gl.setVgap(5);
            this.mainPanel.setLayout(gl);
        }
        if (this.buttonPanel.getComponentCount() > 8) {
            this.buttonPanel.setLayout(new GridLayout(0, 3));
        }
        if (this.buttonPanel.getComponentCount() > 5 && this.buttonPanel.getComponentCount() <= 8) {
            gl = new GridLayout(0, 2);
            this.buttonPanel.setLayout(gl);
        }
        if (this.buttonPanel.getComponentCount() <= 5) {
            this.buttonPanel.setLayout(new FlowLayout());
        }
        this.pack();
        Rectangle parentBounds = this.parent.getBounds();
        Rectangle panelBounds = this.mainPanel.getBounds();
        Rectangle scrollPaneBounds = this.scrollPane.getBounds();
        Rectangle buttonPanelBounds = this.buttonPanel.getBounds();
        Rectangle dialogBounds = this.getBounds();
        if (this.mainPanel.getComponentCount() > 0) {
            if ((double)panelBounds.width > (double)parentBounds.width * 0.75) {
                panelBounds.width = (int)((double)parentBounds.width * 0.75);
            }
            if ((double)panelBounds.height > (double)parentBounds.height * 0.6) {
                panelBounds.height = (int)((double)parentBounds.height * 0.6);
            }
            scrollPaneBounds.width = panelBounds.width + this.scrollPane.getVScrollbarWidth() + 12;
            scrollPaneBounds.height = panelBounds.height;
            if (this.mainPanel.getComponentCount() > 0) {
                scrollPaneBounds.height += 20;
            }
            if ((double)scrollPaneBounds.width > (double)parentBounds.width * 0.9) {
                scrollPaneBounds.width = (int)((double)parentBounds.width * 0.9);
            }
            if ((double)scrollPaneBounds.height > (double)parentBounds.height * 0.75) {
                scrollPaneBounds.height = (int)((double)parentBounds.height * 0.75);
            }
            if (scrollPaneBounds.height + buttonPanelBounds.height + 20 > parentBounds.height) {
                scrollPaneBounds.height = parentBounds.height - buttonPanelBounds.height - 20;
            }
            dialogBounds.width = Math.max(scrollPaneBounds.width, buttonPanelBounds.width);
            if (dialogBounds.width < parentBounds.width - this.scrollPane.getVScrollbarWidth() - 40) {
                dialogBounds.width += this.scrollPane.getVScrollbarWidth() + 20;
            }
            dialogBounds.height = scrollPaneBounds.height + buttonPanelBounds.height + 20;
            if (dialogBounds.height < parentBounds.height - this.scrollPane.getHScrollbarHeight() - 40) {
                dialogBounds.height += this.scrollPane.getHScrollbarHeight() + 20;
            }
        }
        dialogBounds.x = parentBounds.x + (parentBounds.width - dialogBounds.width) / 2;
        dialogBounds.y = parentBounds.y + (parentBounds.height - dialogBounds.height) / 2;
        this.mainPanel.setBounds(panelBounds);
        this.scrollPane.setBounds(scrollPaneBounds);
        this.setBounds(dialogBounds);
        this.show();
    }

    boolean checkButtons() {
        return cb;
    }

    String checkButtonText() {
        return cbtext;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Cancel") || e.getActionCommand().equals("X")) {
            cb = false;
            cbtext = "Cancel";
            this.dispose();
        } else {
            cb = true;
            cbtext = e.getActionCommand();
            this.dispose();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        cbtext = "OK";
        String string = e.getComponent().toString();
        int index = string.indexOf("label=");
        if (index > -1) {
            cbtext = string.substring(index + 6, string.length() - 1);
        }
        if (this.scrollPane.getComponentCount() == 0) {
            return;
        }
        if (!this.scrollPane.isAncestorOf(e.getComponent())) {
            return;
        }
        Point p = this.scrollPane.getScrollPosition();
        Rectangle r = e.getComponent().getBounds();
        Dimension d = this.scrollPane.getViewportSize();
        if (r.y + r.height + 4 > p.y + d.height) {
            p.y = Math.max(0, r.y - d.height + r.height + 4);
            this.scrollPane.setScrollPosition(p);
            return;
        }
        if (r.y - r.height - 4 < p.y) {
            p.y = Math.max(0, r.y - r.height - 4);
            this.scrollPane.setScrollPosition(p);
            return;
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (System.currentTimeMillis() - this.startTime < 500L) {
            return;
        }
        if (e.getKeyCode() == 27) {
            cb = false;
            cbtext = "Cancel";
            this.dispose();
        }
        if (e.getKeyCode() == 10) {
            cb = true;
            if (cbtext.equals("Cancel") || cbtext.equals("X")) {
                cb = false;
            }
            this.dispose();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
    }
}

