/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.GregorianCalendar;
import java.util.Vector;

class DateChooser
extends Dialog
implements ActionListener {
    Panel mainPanel;
    Panel yearPanel;
    Panel monthPanel;
    Panel dayPanel;
    GregorianCalendar date;
    Label monthLabel;
    Label yearLabel;
    Frame frame;
    int width;
    boolean ready;
    static Vector monthNames;
    static final int OK_OPTION = 1;
    static final int CANCEL_OPTION = 2;

    DateChooser(Frame owner, GregorianCalendar d) {
        super(owner, "Date Chooser", true);
        this.frame = owner;
        this.width = this.frame.getBounds().width;
        this.date = d;
        int n = 12;
        if (this.width < 500) {
            n = 10;
        }
        Font font = new Font("Dialog", 0, n);
        this.setFont(font);
        monthNames = new Vector(12);
        if (this.width < 500) {
            monthNames.addElement("Jan");
            monthNames.addElement("Feb");
            monthNames.addElement("Mar");
            monthNames.addElement("Apr");
            monthNames.addElement("May");
            monthNames.addElement("Jun");
            monthNames.addElement("Jul");
            monthNames.addElement("Aug");
            monthNames.addElement("Sep");
            monthNames.addElement("Oct");
            monthNames.addElement("Nov");
            monthNames.addElement("Dec");
        } else {
            monthNames.addElement("January");
            monthNames.addElement("February");
            monthNames.addElement("March");
            monthNames.addElement("April");
            monthNames.addElement("May");
            monthNames.addElement("June");
            monthNames.addElement("July");
            monthNames.addElement("August");
            monthNames.addElement("September");
            monthNames.addElement("October");
            monthNames.addElement("November");
            monthNames.addElement("December");
        }
        this.setLayout(new BorderLayout(0, 0));
        FlowLayout fl = new FlowLayout();
        n = 5;
        if (this.width < 500) {
            n = 0;
        }
        fl.setHgap(n);
        fl.setVgap(8);
        this.mainPanel = new Panel();
        this.mainPanel.setLayout(fl);
        this.yearPanel = new Panel();
        this.yearPanel.setLayout(fl);
        this.monthPanel = new Panel();
        this.monthPanel.setLayout(fl);
        this.dayPanel = new Panel();
        this.dayPanel.setLayout(new GridLayout(7, 7));
        Button[] navButton = new Button[4];
        navButton[0] = new Button("<");
        this.monthPanel.add(navButton[0]);
        String s = String.valueOf(monthNames.elementAt(this.date.get(2)));
        this.monthLabel = new Label(s, 1);
        this.monthPanel.add(this.monthLabel);
        navButton[1] = new Button(">");
        this.monthPanel.add(navButton[1]);
        navButton[2] = new Button("<<");
        this.yearPanel.add(navButton[2]);
        s = String.valueOf(this.date.get(1));
        this.yearLabel = new Label(s, 1);
        this.yearPanel.add((Component)this.yearLabel, "Center");
        navButton[3] = new Button(">>");
        this.yearPanel.add(navButton[3]);
        for (int i = 0; i < 4; ++i) {
            navButton[i].addActionListener(this);
        }
        this.updateDayPanel();
        this.setResizable(false);
        this.setVisible(false);
        this.ready = false;
        this.mainPanel.add(this.monthPanel);
        this.mainPanel.add(this.yearPanel);
        this.add("Center", this.mainPanel);
        this.add("South", this.dayPanel);
        this.pack();
        Rectangle parentBounds = this.frame.getBounds();
        Rectangle mainPanelBounds = this.mainPanel.getBounds();
        Rectangle dayPanelBounds = this.dayPanel.getBounds();
        Rectangle dialogBounds = this.getBounds();
        if ((double)mainPanelBounds.width > (double)parentBounds.width * 0.75) {
            mainPanelBounds.width = (int)((double)parentBounds.width * 0.75);
        }
        if ((double)mainPanelBounds.height > (double)parentBounds.height * 0.6) {
            mainPanelBounds.height = (int)((double)parentBounds.height * 0.6);
        }
        dialogBounds.width = Math.max(mainPanelBounds.width, dayPanelBounds.width);
        dialogBounds.height = mainPanelBounds.height + dayPanelBounds.height + 20;
        dialogBounds.x = parentBounds.x + (parentBounds.width - dialogBounds.width) / 2;
        dialogBounds.y = parentBounds.y + (parentBounds.height - dialogBounds.height) / 2;
        this.mainPanel.setBounds(mainPanelBounds);
        this.setBounds(dialogBounds);
    }

    GregorianCalendar getDate() {
        return this.date;
    }

    int showDateChooser() {
        this.ready = false;
        this.setVisible(true);
        if (this.ready) {
            return 1;
        }
        return 2;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String label = ((Button)e.getSource()).getLabel();
        if (label.equals("<")) {
            int m = monthNames.indexOf(this.monthLabel.getText());
            m = this.prevMonth(m);
            String s = (String)monthNames.elementAt(m);
            this.monthLabel.setText(s);
            this.updateDayPanel();
        } else if (label.equals(">")) {
            int m = monthNames.indexOf(this.monthLabel.getText());
            m = this.nextMonth(m);
            String s = (String)monthNames.elementAt(m);
            this.monthLabel.setText(s);
            this.updateDayPanel();
        } else if (label.equals("<<")) {
            this.prevYear();
            this.updateDayPanel();
        } else if (label.equals(">>")) {
            this.nextYear();
            this.updateDayPanel();
        } else if (label.equals("Today") || label.equals("T")) {
            this.date = new GregorianCalendar();
            this.date.setLenient(false);
            this.ready = true;
            this.dispose();
        } else {
            int m = monthNames.indexOf(this.monthLabel.getText());
            int y = 0;
            int d = 0;
            try {
                y = Integer.parseInt(this.yearLabel.getText());
                d = Integer.parseInt(label);
            }
            catch (NumberFormatException nfe) {
                System.out.println(nfe.toString());
            }
            this.date = new GregorianCalendar(y, m, d);
            this.date.setLenient(false);
            this.ready = true;
            this.dispose();
        }
    }

    void updateDayPanel() {
        int i;
        this.dayPanel.removeAll();
        int m = monthNames.indexOf(this.monthLabel.getText());
        int y = 0;
        try {
            y = Integer.parseInt(this.yearLabel.getText());
        }
        catch (NumberFormatException e) {
            System.out.println(e.toString());
        }
        GregorianCalendar temp = new GregorianCalendar(y, m, 1);
        temp.setLenient(false);
        int offset = 0;
        switch (temp.get(7)) {
            case 2: {
                offset = 0;
                break;
            }
            case 3: {
                offset = 1;
                break;
            }
            case 4: {
                offset = 2;
                break;
            }
            case 5: {
                offset = 3;
                break;
            }
            case 6: {
                offset = 4;
                break;
            }
            case 7: {
                offset = 5;
                break;
            }
            case 1: {
                offset = 6;
            }
        }
        if (this.width < 500) {
            this.dayPanel.add(new Label("M", 1));
            this.dayPanel.add(new Label("T", 1));
            this.dayPanel.add(new Label("W", 1));
            this.dayPanel.add(new Label("T", 1));
            this.dayPanel.add(new Label("F", 1));
            this.dayPanel.add(new Label("S", 1));
            this.dayPanel.add(new Label("S", 1));
        } else {
            this.dayPanel.add(new Label("Mon", 1));
            this.dayPanel.add(new Label("Tue", 1));
            this.dayPanel.add(new Label("Wed", 1));
            this.dayPanel.add(new Label("Thu", 1));
            this.dayPanel.add(new Label("Fri", 1));
            this.dayPanel.add(new Label("Sat", 1));
            this.dayPanel.add(new Label("Sun", 1));
        }
        for (int i2 = 1; i2 <= offset; ++i2) {
            this.dayPanel.add(new Label(""));
        }
        GregorianCalendar today = new GregorianCalendar();
        for (i = 1; i <= this.getLastDay(); ++i) {
            Button day = new Button(String.valueOf(i));
            this.dayPanel.add(day);
            day.addActionListener(this);
            if (i == this.date.get(5) && m == this.date.get(2) && y == this.date.get(1)) {
                day.setForeground(Color.blue);
            }
            if (i != today.get(5) || m != today.get(2) || y != today.get(1)) continue;
            day.setForeground(Color.red);
        }
        for (i = offset + this.getLastDay() + 1; i <= 41; ++i) {
            this.dayPanel.add(new Label(""));
        }
        if (this.width < 500) {
            Button day = new Button("T");
            this.dayPanel.add(day);
            day.addActionListener(this);
            day.setForeground(Color.red);
        } else {
            Button day = new Button("Today");
            this.dayPanel.add(day);
            day.addActionListener(this);
            day.setForeground(Color.red);
        }
        this.repaint();
        this.validate();
    }

    int nextMonth(int month) {
        if (month == 11) {
            this.nextYear();
            return 0;
        }
        return ++month;
    }

    int prevMonth(int month) {
        if (month == 0) {
            this.prevYear();
            return 11;
        }
        return --month;
    }

    void prevYear() {
        int y = 0;
        try {
            y = Integer.parseInt(this.yearLabel.getText());
        }
        catch (NumberFormatException nfe) {
            System.out.println(nfe.toString());
        }
        this.yearLabel.setText(String.valueOf(--y));
    }

    void nextYear() {
        int y = 0;
        try {
            y = Integer.parseInt(this.yearLabel.getText());
        }
        catch (NumberFormatException nfe) {
            System.out.println(nfe.toString());
        }
        this.yearLabel.setText(String.valueOf(++y));
    }

    int getLastDay() {
        int m = monthNames.indexOf(this.monthLabel.getText()) + 1;
        int y = 0;
        try {
            y = Integer.parseInt(this.yearLabel.getText());
        }
        catch (NumberFormatException e) {
            System.out.println(e.toString());
        }
        if (m == 4 || m == 6 || m == 9 || m == 11) {
            return 30;
        }
        if (m == 2) {
            if (this.date.isLeapYear(y)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }
}

