/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import com.crazzyghost.alphavantage.AlphaVantage;
import com.crazzyghost.alphavantage.AlphaVantageException;
import com.crazzyghost.alphavantage.Config;
import com.crazzyghost.alphavantage.Fetcher;
import com.crazzyghost.alphavantage.exchangerate.ExchangeRateResponse;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Hashtable;
import java.util.Vector;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.AccountStore;
import org.freepoc.Jabp4.AccountView;
import org.freepoc.Jabp4.Category;
import org.freepoc.Jabp4.CategoryStore;
import org.freepoc.Jabp4.CategoryView;
import org.freepoc.Jabp4.Currency;
import org.freepoc.Jabp4.CurrencyForm;
import org.freepoc.Jabp4.CurrencyStore;
import org.freepoc.Jabp4.GenericShowForm;
import org.freepoc.Jabp4.Investment;
import org.freepoc.Jabp4.InvestmentStore;
import org.freepoc.Jabp4.InvestmentView;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.PreferenceStore;
import org.freepoc.Jabp4.StandingOrderView;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.TransactionStore;
import org.freepoc.Jabp4.Utilities;

class CurrencyView
extends Canvas
implements ActionListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
Runnable {
    Jabp parent;
    Config cfg;
    Thread thread;
    CurrencyStore ccys;
    Currency ccy;
    Currency ccy1;
    Currency oldCcy;
    String homeCode = "";
    String foreignCode = "";
    String msg = "";
    Point point;
    Graphics g1;
    Image image;
    Font font;
    FontMetrics fm;
    Vector canvasMenu;
    double apiRate = 0.0;
    boolean start;
    boolean oneClickFlag;
    boolean dragScreen = false;
    boolean pointerExecute;
    boolean alwaysDisplayMenu = false;
    boolean showCanvasMenu = false;
    boolean showingPopupMenu = false;
    boolean calculateCanvasMenuPosition = true;
    boolean showSwitchViewsMenu = false;
    boolean paintWholeScreen = true;
    boolean updateAllRates = false;
    long timePointerOnScreen;
    int numMenuItems;
    int startMenuPos;
    int currentMenuPos;
    int menuWidth;
    int menuHeight;
    int menuWidthPos;
    int menuHeightPos;
    int width;
    int height;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int lastDragX;
    int lastDragY;
    int numItems;
    int numItemsPage;
    int lineHeight;
    int fontHeight;
    int fontWidth;
    int currentPos;
    int previousPos;
    int startPos;
    int spacing;
    int numberWidth;
    int ratePosition;
    int currencyWidth;
    int runMode;

    CurrencyView(Jabp context) {
        this.parent = context;
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.ccys = new CurrencyStore(this.parent, false);
        this.parent.dataIntegrityCheck("Currencies", this.ccys.getNumCurrencies(), this.parent.currencyHt.size());
        this.numItems = this.ccys.getNumCurrencies();
        this.font = this.parent.font;
        this.setFont(this.font);
        this.fm = this.getFontMetrics(this.font);
        this.lineHeight = this.parent.fontHeight + this.parent.lineSpacing * 2;
        this.currentX = 0;
        this.currentY = this.lineHeight;
        this.currentPos = 0;
        this.startPos = 0;
        this.setupCanvasMenu();
        this.runMode = 0;
        this.start = true;
        this.oneClickFlag = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
    }

    @Override
    public void paint(Graphics g) {
        if (this.start) {
            this.start = false;
        }
        if (this.width != this.getWidth() || this.height != this.getHeight() - this.parent.heightAdjustment) {
            this.width = this.getWidth();
            this.height = this.getHeight() - this.parent.heightAdjustment;
            this.paintWholeScreen = true;
        }
        this.parent.lastUsedScreen = 5;
        this.parent.lastUsedView = 5;
        this.setPositions();
        this.g1.clearRect(0, 0, this.width, this.height);
        this.g1.setFont(this.font);
        this.showHeader();
        this.showPage();
        this.showFooter();
        if (this.parent.useCanvasMenu && this.showCanvasMenu) {
            this.displayCanvasMenu();
        }
        g.drawImage(this.image, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    void showPage() {
        this.g1.setColor(new Color(this.parent.colorBackground));
        this.g1.fillRect(0, this.lineHeight, this.width, this.height - this.lineHeight * 2);
        this.g1.setColor(new Color(this.parent.colorFont));
        if (this.numItems == 0) {
            this.g1.drawString("Click here to add currency", this.parent.widthAdjustment, this.lineHeight * 2);
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                this.g1.setColor(new Color(this.parent.colorCursor));
                this.g1.fillRect(0, this.lineHeight * i + this.lineHeight, this.width, this.lineHeight);
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            this.ccy = this.ccys.getCurrencyFromIndex(i + this.startPos);
            this.buildLine(this.ccy, this.lineHeight * i + this.lineHeight);
        }
        this.ccy = this.ccys.getCurrencyFromIndex(this.startPos + this.currentPos);
    }

    void showHeader() {
        int vpos = this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorHeading));
        this.g1.fillRect(0, 0, this.width, this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        if (this.msg.equals("")) {
            this.g1.drawString("Currencies", this.parent.widthAdjustment, vpos);
            this.g1.drawString("Rate", this.ratePosition + this.numberWidth - this.fm.stringWidth("Rate"), vpos);
        } else {
            this.g1.setColor(new Color(this.parent.colorMessage));
            this.g1.fillRect(0, 0, this.width, this.lineHeight);
            this.g1.setColor(new Color(this.parent.colorFont));
            this.g1.drawString(this.msg, this.parent.widthAdjustment, vpos);
        }
    }

    void showFooter() {
        this.g1.setColor(new Color(this.parent.colorHeading));
        this.g1.fillRect(0, this.height - this.lineHeight, this.width, this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
    }

    void drawUp() {
        if (this.showCanvasMenu) {
            if (this.currentMenuPos > 0) {
                --this.currentMenuPos;
            } else {
                --this.startMenuPos;
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (this.startPos + this.currentPos > 0) {
            this.oldY = this.currentY;
            this.currentY -= this.lineHeight;
            --this.currentPos;
            if (this.currentY < this.lineHeight) {
                this.currentY = this.lineHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
                this.repaint();
            } else {
                this.repaint(0, this.lineHeight * this.currentPos + this.lineHeight, this.width, this.lineHeight * 2);
            }
            return;
        }
    }

    void drawDown() {
        if (this.showCanvasMenu) {
            if (this.currentMenuPos < Math.min(this.numItemsPage, this.numMenuItems) - 1) {
                ++this.currentMenuPos;
            } else {
                ++this.startMenuPos;
                if (this.startMenuPos + this.currentPos > Math.min(this.numItemsPage, this.numMenuItems) - 1) {
                    this.startMenuPos = Math.min(this.numItemsPage, this.numMenuItems) - 1 - this.currentPos;
                }
            }
            this.repaint();
            return;
        }
        if (this.startPos + this.currentPos < this.numItems - 1) {
            this.oldY = this.currentY;
            this.currentY += this.lineHeight;
            ++this.currentPos;
            if (this.currentY + this.lineHeight * 2 > this.height) {
                this.currentY -= this.lineHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
                this.repaint();
            } else {
                this.repaint(0, this.lineHeight * (this.currentPos - 1) + this.lineHeight, this.width, this.lineHeight * 2);
            }
            return;
        }
    }

    void buildLine(Currency currency, int y) {
        int vpos = y + this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        String s = currency.code;
        if (s.equals(this.parent.homeCurrency)) {
            s = s + " (*)";
        }
        int j = s.length();
        for (int i = 0; i < j; ++i) {
            int k = j - i;
            if (this.fm.stringWidth(s.substring(0, k)) > this.currencyWidth) continue;
            this.g1.drawString(s.substring(0, k), this.parent.widthAdjustment, vpos);
            break;
        }
        s = Utilities.rateToString(currency.rate, false, this.parent.isEuropeanNumberFormat);
        this.g1.drawString(s, this.ratePosition + this.numberWidth - this.fm.stringWidth(s), vpos);
    }

    void setPositions() {
        this.fontHeight = this.parent.fontHeight;
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.image = this.createImage(this.width, this.height);
        this.g1 = this.image.getGraphics();
        Utilities.enableAntialiasing(this.g1);
        if (this.parent.lineSpacing == 0) {
            this.parent.lineSpacing = this.fontHeight / 5;
        }
        this.lineHeight = this.fontHeight + this.parent.lineSpacing * 2;
        this.numberWidth = this.parent.isGroupingUsed ? this.fm.stringWidth("999,999.99") : this.fm.stringWidth("999999.99");
        this.numItemsPage = this.height / this.lineHeight - 2;
        this.spacing = this.fm.stringWidth("  ");
        this.currencyWidth = this.width - this.numberWidth - this.parent.widthAdjustment * 2 - this.spacing;
        this.currencyWidth = Math.min(this.currencyWidth, this.width * 2 / 3);
        this.ratePosition = this.currencyWidth + this.parent.widthAdjustment;
    }

    int newCurrency(Currency currency) {
        this.ccy1 = currency;
        this.ccy1.id = this.ccys.saveNewCurrency(this.ccy1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.ccys.toByteArray(this.ccy1), 3);
        }
        if (this.ccy == null) {
            this.ccy = this.ccy1;
        }
        ++this.numItems;
        this.repaint();
        return this.ccy1.id;
    }

    void editCurrency(Currency currency) {
        this.ccy1 = currency;
        if (this.ccy1.code.equals(this.oldCcy.code) && this.ccy1.description.equals(this.oldCcy.description)) {
            this.ccys.saveExistingCurrency(this.ccy1);
            if (this.parent.syncMode) {
                this.parent.sync.saveSyncRecord(this.ccys.toByteArray(this.ccy1), 12);
            }
        } else {
            this.ccys.deleteCurrency(this.oldCcy);
            this.ccys.deleteIndex(this.startPos + this.currentPos);
            this.ccy1.id = this.ccys.saveNewCurrency(this.ccy1);
            if (this.parent.syncMode) {
                this.parent.sync.saveSyncRecord(this.ccys.toByteArray(this.oldCcy), -3);
                this.parent.sync.saveSyncRecord(this.ccys.toByteArray(this.ccy1), 3);
            }
        }
        if (!this.ccy1.code.equals(this.oldCcy.code)) {
            if (this.oldCcy.code.equals(this.parent.homeCurrency)) {
                this.parent.homeCurrency = this.ccy1.code;
                PreferenceStore ps = new PreferenceStore(this.parent, true);
                ps.savePreferences();
                ps.closePreferenceStore();
            }
            this.updateCurrencyName();
        } else {
            this.msg = "";
        }
        if (this.ccy1.rate != this.oldCcy.rate) {
            this.updateCurrencyTransactions();
        } else {
            this.msg = "";
        }
        this.repaint();
    }

    void deleteCurrency(Currency currency) {
        this.ccy1 = currency;
        this.ccys.deleteCurrency(this.ccy1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.ccys.toByteArray(this.ccy1), -3);
        }
        this.ccys.deleteIndex(this.startPos + this.currentPos);
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.lineHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
        this.repaint();
    }

    void updateInternetRate(Currency currency) {
        if (currency.code.equals(this.parent.homeCurrency)) {
            Toast.makeText(this.parent, "No need to update home currency", 2000).show();
            return;
        }
        this.getHomeCurrencyCode();
        if (this.homeCode.equals("")) {
            Toast.makeText(this.parent, "Code not found for home currency", 2000).show();
            return;
        }
        this.updateAllRates = false;
        this.ccy1 = currency;
        this.foreignCode = this.getCurrencyCodeFromDescription(this.ccy1);
        if (this.foreignCode.equals("")) {
            Toast.makeText(this.parent, "Code not found for this currency", 2000).show();
            return;
        }
        this.runMode = 3;
        Thread thread2 = new Thread(this);
        thread2.start();
    }

    String getCurrencyCodeFromDescription(Currency currency) {
        int k1 = currency.description.indexOf("<");
        int k2 = currency.description.indexOf(">");
        if (k1 < 0 || k2 < 0) {
            return "";
        }
        if (k1 > k2) {
            return "";
        }
        String s = currency.description.substring(k1 + 1, k2).toUpperCase();
        if (s.length() != 3) {
            return "";
        }
        return s;
    }

    void getHomeCurrencyCode() {
        for (int j = 0; j < this.numItems; ++j) {
            Currency ccy2 = this.ccys.getCurrencyFromIndex(j);
            if (!ccy2.code.equals(this.parent.homeCurrency)) continue;
            this.homeCode = this.getCurrencyCodeFromDescription(ccy2);
            break;
        }
    }

    void processRatesFromInternet() {
        if (this.cfg == null) {
            this.cfg = Config.builder().key(this.parent.alphaVantageKey).timeOut(10).build();
            AlphaVantage.api().init(this.cfg);
        }
        this.apiRate = 0.0;
        AlphaVantage.api().exchangeRate().fromCurrency(this.homeCode).toCurrency(this.foreignCode).onSuccess(new Fetcher.SuccessCallback<ExchangeRateResponse>(){

            @Override
            public void onSuccess(ExchangeRateResponse response) {
                CurrencyView.this.oldCcy = new Currency();
                CurrencyView.this.oldCcy.clone(CurrencyView.this.ccy1);
                CurrencyView.this.apiRate = response.getExchangeRate();
                CurrencyView.this.ccy1.oldRate = CurrencyView.this.ccy1.rate;
                CurrencyView.this.ccy1.rate = (int)(CurrencyView.this.apiRate * 100000.0);
                CurrencyView.this.ccys.saveExistingCurrency(CurrencyView.this.ccy1);
                CurrencyView.this.updateCurrencyTransactions();
                if (CurrencyView.this.parent.syncMode) {
                    CurrencyView.this.parent.sync.saveSyncRecord(CurrencyView.this.ccys.toByteArray(CurrencyView.this.ccy1), 12);
                }
                Toast.makeText(CurrencyView.this.parent, "Updated fx rate for " + CurrencyView.this.foreignCode + " from the internet", 2000).show();
                CurrencyView.this.repaint();
            }
        }).onFailure(new Fetcher.FailureCallback(){

            @Override
            public void onFailure(AlphaVantageException ex) {
                Toast.makeText(CurrencyView.this.parent, "Error getting fx rate: " + ex.toString(), 2000).show();
            }
        }).fetch();
    }

    void updateCurrencyName() {
        AccountStore as = this.parent.av.as;
        Account a2 = null;
        as.setToStart();
        int c1 = 0;
        while ((a2 = as.readNextAccount()) != null) {
            if (!a2.currency.equals(this.oldCcy.code)) continue;
            ++c1;
            a2.currency = this.ccy1.code;
            as.deleteAccount(a2);
            as.deleteIndex(a2);
            int pos = as.rs.getCurrentFilePosition();
            Hashtable ht = (Hashtable)this.parent.transactionHt.get(a2.name);
            if (ht == null) {
                ht = new Hashtable();
            }
            a2.id = as.saveNewAccount(a2);
            this.parent.transactionHt.put(a2.name, ht);
            as.rs.seek(pos);
        }
        if (this.parent.iv != null) {
            this.parent.iv.is.closeInvestmentStore();
            this.parent.iv = null;
        }
        InvestmentStore is = new InvestmentStore(this.parent, true);
        Investment inv2 = null;
        is.setToStart();
        int c2 = 0;
        while ((inv2 = is.readNextInvestment()) != null) {
            if (!inv2.currency.equals(this.oldCcy.code)) continue;
            ++c2;
            inv2.currency = this.ccy1.code;
            is.deleteInvestment(inv2);
            is.deleteIndex(inv2);
            int pos = is.rs.getCurrentFilePosition();
            inv2.id = is.saveNewInvestment(inv2);
            is.rs.seek(pos);
        }
        is.closeInvestmentStore();
        this.msg = "";
        this.repaint();
        if (c1 > 0 || c2 > 0) {
            Toast.makeText(this.parent, c1 + " accounts and " + c2 + " investments updated", 2000).show();
        }
    }

    void updateCurrencyTransactions() {
        this.parent.busyWithProcess = true;
        AccountStore as = this.parent.av.as;
        if (this.parent.cv != null) {
            this.parent.cv.cs.closeCategoryStore();
            this.parent.cv = null;
        }
        CategoryStore cs = new CategoryStore(this.parent, true);
        if (this.parent.tv != null) {
            this.parent.tv.ts.closeTransactionStore();
            this.parent.tv.rs.closeRegularStore();
        }
        TransactionStore ts = new TransactionStore(this.parent, new Account(), true);
        Account a2 = null;
        for (int i = 0; i < as.ht.size(); ++i) {
            a2 = as.getAccountFromIndex(i);
            if (!a2.currency.equals(this.ccy1.code)) continue;
            Category c = cs.getCategoryFromName("FX Adjustment");
            ts.getIndex(a2);
            Transaction t = new Transaction();
            t.longDate = this.parent.todayDate.getTime();
            t.account = a2.name;
            t.description = "FX Adjustment";
            long long1 = a2.current;
            long long2 = this.oldCcy.rate;
            long long3 = this.ccy1.rate;
            long long4 = long1 * long2 / long3;
            t.amount = (int)long4 - a2.current;
            if (t.amount == 0) continue;
            t.category = c.name;
            t.reconciled = true;
            t.id = ts.saveNewTransaction(t);
            if (this.parent.syncMode) {
                this.parent.sync.saveSyncRecord(ts.toByteArray(t), 7);
            }
            ts.setIndex(a2);
            if (this.parent.tv != null && this.parent.tv.a.name.equals(a2.name)) {
                ++this.parent.tv.numItems;
            }
            this.parent.av.totalCurrent -= a2.current;
            this.parent.av.totalToday -= a2.today;
            this.parent.av.totalReconciled -= a2.reconciled;
            a2.updateBalance(t, null, this.parent.todayDays);
            this.parent.av.totalCurrent += a2.current;
            this.parent.av.totalToday += a2.today;
            this.parent.av.totalReconciled += a2.reconciled;
            as.saveExistingAccount(a2);
            c = cs.getCategoryFromName(c.name);
            if (this.parent.cv != null) {
                this.parent.cv.totalCurrent -= c.current;
            }
            c.updateBalance(t, null);
            if (this.parent.cv != null) {
                this.parent.cv.totalCurrent += c.current;
            }
            cs.saveExistingCategory(c);
            c = null;
        }
        ts.closeTransactionStore();
        cs.closeCategoryStore();
        this.parent.busyWithProcess = false;
    }

    void runThread() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        if (this.runMode == 1) {
            this.updateCurrencyName();
        }
        if (this.runMode == 2) {
            this.updateCurrencyTransactions();
        }
        if (this.runMode == 3) {
            this.processRatesFromInternet();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int j;
        String s = ae.getSource().toString();
        String s1 = s.substring((j = s.indexOf("[")) + 1, j + 5);
        if (s1.equals("menu")) {
            MenuItem mi = (MenuItem)ae.getSource();
            this.commandAction(mi.getLabel());
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        this.lastDragX = x;
        this.lastDragY = y;
        this.pointerExecute = false;
        this.alwaysDisplayMenu = false;
        this.timePointerOnScreen = System.currentTimeMillis();
        this.calculateCanvasMenuPosition = true;
        if (this.showCanvasMenu) {
            this.calculateCanvasMenuPosition = false;
            this.currentMenuPos = (y - this.menuHeightPos) / this.lineHeight;
            this.repaint();
            return;
        }
        if (y < this.lineHeight) {
            if (this.numItems == 0) {
                return;
            }
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.lineHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (y > this.height - this.lineHeight) {
            if (this.numItems == 0) {
                return;
            }
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
            this.repaint();
            return;
        }
        this.timePointerOnScreen = System.currentTimeMillis() - this.timePointerOnScreen;
        if (this.timePointerOnScreen > (long)this.parent.longTapDelay) {
            if (y < this.lineHeight) {
                this.startPos = 0;
                this.currentPos = 0;
                this.currentY = this.lineHeight;
                this.repaint();
                return;
            }
            if (y > this.height - this.lineHeight) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                this.repaint();
                return;
            }
        }
        if (this.alwaysDisplayMenu || this.timePointerOnScreen > (long)this.parent.longTapDelay) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.repaint();
            } else {
                this.displayPopupMenu();
            }
            return;
        }
        this.pointerExecute = true;
        int newPos = (y - this.lineHeight) / this.lineHeight;
        if (newPos >= this.numItems) {
            this.alwaysDisplayMenu = true;
            return;
        }
        this.previousPos = this.currentPos;
        this.currentPos = newPos;
        this.currentY = (this.currentPos + 1) * this.lineHeight;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        if (Math.abs(this.lastDragX - x) > 250) {
            this.commandAction("Switch Views");
            return;
        }
        if (this.dragScreen) {
            this.dragScreen = false;
            return;
        }
        if (this.showCanvasMenu) {
            this.showCanvasMenu = false;
            this.repaint();
            if (x < this.menuWidthPos || x > this.menuWidthPos + this.menuWidth || y < this.menuHeightPos || y > this.menuHeightPos + this.menuHeight) {
                this.setupCanvasMenu();
                this.showSwitchViewsMenu = false;
                return;
            }
            int k = (y - this.menuHeightPos) / this.lineHeight + this.startMenuPos;
            if (this.showSwitchViewsMenu) {
                this.showSwitchViewsMenu = false;
                this.processSwitchViewsMenu(k);
            } else {
                this.processMenuCommand(k);
            }
            return;
        }
        if (this.alwaysDisplayMenu) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.repaint();
            } else {
                this.displayPopupMenu();
            }
            return;
        }
        if (!this.pointerExecute) {
            return;
        }
        int newPos = (y - this.lineHeight) / this.lineHeight;
        if (newPos == this.currentPos || newPos >= this.numItems) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.repaint();
            } else {
                this.displayPopupMenu();
            }
            return;
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        int scroll = (y - this.lastDragY) / this.lineHeight;
        if (scroll == 0) {
            return;
        }
        if (scroll > 0) {
            if (this.showCanvasMenu) {
                this.startMenuPos -= scroll;
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
                this.currentMenuPos += scroll;
                if (this.currentMenuPos > Math.min(this.numMenuItems, this.numItemsPage) - 1) {
                    this.currentMenuPos = Math.min(this.numMenuItems, this.numItemsPage) - 1;
                }
            } else {
                this.startPos -= scroll;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                this.currentPos += scroll;
                if (this.currentPos > Math.min(this.numItems, this.numItemsPage) - 1) {
                    this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                }
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
        }
        if (scroll < 0) {
            if (this.showCanvasMenu) {
                this.startMenuPos -= scroll;
                if (this.startMenuPos + this.numItemsPage > this.numMenuItems - 1) {
                    this.startMenuPos = this.numMenuItems - this.numItemsPage;
                }
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
                this.currentMenuPos += scroll;
                if (this.currentMenuPos < 0) {
                    this.currentMenuPos = 0;
                }
            } else {
                this.startPos -= scroll;
                if (this.startPos + this.currentPos > this.numItems - 1) {
                    this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                    this.startPos = this.numItems - 1 - this.currentPos;
                    this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                }
                this.currentPos += scroll;
                if (this.currentPos < 0) {
                    this.currentPos = 0;
                }
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
        }
        this.lastDragY = y;
        this.repaint();
        this.dragScreen = true;
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        int notches = mwe.getWheelRotation();
        if (notches == 0) {
            return;
        }
        if (notches > 0) {
            for (int i = 0; i < notches; ++i) {
                this.drawDown();
            }
        } else {
            notches = -notches;
            for (int i = 0; i < notches; ++i) {
                this.drawUp();
            }
        }
    }

    void displayPopupMenu() {
        if (this.showingPopupMenu) {
            this.showingPopupMenu = false;
            return;
        }
        PopupMenu pm = new PopupMenu();
        MenuItem miHome = new MenuItem("Home");
        MenuItem miNew = new MenuItem("New");
        MenuItem miEdit = new MenuItem("Edit");
        MenuItem miDelete = new MenuItem("Delete");
        MenuItem miInternetRate = new MenuItem("Internet Rate");
        MenuItem miShow = new MenuItem("Show");
        MenuItem miGetApiKey = new MenuItem("Get API Key");
        MenuItem miSwitchViews = new MenuItem("Switch Views");
        miHome.addActionListener(this);
        miNew.addActionListener(this);
        miEdit.addActionListener(this);
        miDelete.addActionListener(this);
        miInternetRate.addActionListener(this);
        miShow.addActionListener(this);
        miGetApiKey.addActionListener(this);
        miSwitchViews.addActionListener(this);
        pm.add(miHome);
        pm.add(miNew);
        pm.add(miEdit);
        pm.add(miDelete);
        pm.add(miInternetRate);
        pm.add(miShow);
        pm.add(miGetApiKey);
        pm.add(miSwitchViews);
        this.add(pm);
        int x = 0;
        int y = 0;
        if (this.point == null) {
            pm.show(this, x, y);
        } else {
            Point move = this.movePopup(8, x, y);
            pm.show(this, move.x + this.point.x, move.y + this.point.y);
        }
        this.showingPopupMenu = true;
    }

    void displaySwitchViewsMenu() {
        if (this.showingPopupMenu) {
            this.showingPopupMenu = false;
            return;
        }
        PopupMenu pm = new PopupMenu();
        MenuItem miAccounts = new MenuItem("Accounts");
        MenuItem miTransactions = new MenuItem("Transactions");
        MenuItem miCategories = new MenuItem("Categories");
        MenuItem miStandingOrders = new MenuItem("Standing Orders");
        MenuItem miInvestments = new MenuItem("Investments");
        MenuItem miCurrencies = new MenuItem("Currencies");
        miAccounts.addActionListener(this);
        miTransactions.addActionListener(this);
        miCategories.addActionListener(this);
        miStandingOrders.addActionListener(this);
        miInvestments.addActionListener(this);
        miCurrencies.addActionListener(this);
        pm.add(miAccounts);
        pm.add(miTransactions);
        pm.add(miCategories);
        pm.add(miStandingOrders);
        pm.add(miInvestments);
        pm.add(miCurrencies);
        this.add(pm);
        int x = 0;
        int y = 0;
        if (this.point == null) {
            pm.show(this, x, y);
        } else {
            Point move = this.movePopup(7, x, y);
            pm.show(this, move.x + this.point.x, move.y + this.point.y);
        }
        this.showingPopupMenu = true;
    }

    Point movePopup(int n, int x, int y) {
        int popupHeight = n * this.lineHeight * 4 / 3;
        if (this.parent.useCanvasMenu && x + this.point.x + this.menuWidth > this.width) {
            x = this.width - this.menuWidth - this.point.x;
        }
        if (y + this.point.y + popupHeight > this.height) {
            y = this.height - popupHeight - this.point.y;
        }
        Point move = new Point(x, y);
        return move;
    }

    void setupCanvasMenu() {
        this.startMenuPos = 0;
        this.currentMenuPos = 0;
        this.canvasMenu = new Vector(6);
        this.canvasMenu.addElement("Home");
        this.canvasMenu.addElement("New");
        this.canvasMenu.addElement("Edit");
        this.canvasMenu.addElement("Delete");
        this.canvasMenu.addElement("Internet Rate");
        this.canvasMenu.addElement("Show");
        this.canvasMenu.addElement("Get API Key");
        this.canvasMenu.addElement("Switch Views");
        this.menuWidth = this.fm.stringWidth("Update All Rates") + 6;
    }

    void setupSwitchViewsMenu() {
        this.startMenuPos = 0;
        this.currentMenuPos = 0;
        this.canvasMenu = new Vector(6);
        this.canvasMenu.addElement("Accounts");
        this.canvasMenu.addElement("Transactions");
        this.canvasMenu.addElement("Categories");
        this.canvasMenu.addElement("Standing Orders");
        this.canvasMenu.addElement("Investments");
        this.canvasMenu.addElement("Currencies");
        this.menuWidth = this.fm.stringWidth("Standing Orders") + 6;
    }

    void displayCanvasMenu() {
        this.numMenuItems = this.canvasMenu.size();
        this.menuWidthPos = (this.width - this.menuWidth) / 2;
        if (this.menuWidthPos < 0) {
            this.menuWidthPos = 0;
        }
        this.menuHeightPos = (this.height - this.lineHeight * 2 - this.numMenuItems * this.lineHeight) / 2;
        if (this.menuHeightPos < this.lineHeight) {
            this.menuHeightPos = this.lineHeight;
        }
        this.menuHeight = Math.min(this.height - this.lineHeight * 2, this.numMenuItems * this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorMessage));
        this.g1.fillRect(this.menuWidthPos, this.menuHeightPos, this.menuWidth, this.menuHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        for (int i = 0; i < this.numItemsPage && i + this.startMenuPos <= this.numMenuItems - 1; ++i) {
            int vpos = i * this.lineHeight + this.lineHeight + this.menuHeightPos - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
            if (i == this.currentMenuPos) {
                this.g1.setColor(new Color(this.parent.colorCursor));
                this.g1.fillRect(this.menuWidthPos, this.lineHeight * i + this.menuHeightPos, this.menuWidth, this.lineHeight);
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            this.g1.drawString((String)this.canvasMenu.elementAt(i + this.startMenuPos), this.menuWidthPos + 3, vpos);
        }
    }

    void processMenuCommand(int k) {
        this.repaint();
        this.commandAction((String)this.canvasMenu.elementAt(k));
    }

    void processSwitchViewsMenu(int k) {
        this.setupCanvasMenu();
        switch (k) {
            case 0: {
                this.commandAction("Accounts");
                break;
            }
            case 1: {
                this.commandAction("Transactions");
                break;
            }
            case 2: {
                this.commandAction("Categories");
                break;
            }
            case 3: {
                this.commandAction("Standing Orders");
                break;
            }
            case 4: {
                this.commandAction("Investments");
                break;
            }
            case 5: {
                this.commandAction("Currencies");
            }
        }
    }

    public void commandAction(String cmd) {
        this.showingPopupMenu = false;
        if (this.parent.saveStateOnHome) {
            this.parent.ixs.selfDestruct();
        }
        if (cmd.equals("Exit")) {
            if (this.parent.useCanvasMenu && this.showCanvasMenu) {
                this.showCanvasMenu = false;
                this.repaint();
                return;
            }
            this.parent.finishAndQuit();
            return;
        }
        if (cmd.equals("Home")) {
            if (this.parent.av == null) {
                this.parent.av = new AccountView(this.parent);
            }
            this.parent.setContentView(this.parent.av);
            return;
        }
        if (cmd.equals("New")) {
            this.parent.ccyf = new CurrencyForm(this.parent, new Currency(), "New");
            return;
        }
        if (cmd.equals("Edit")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to edit", 2000).show();
                return;
            }
            this.oldCcy = new Currency();
            this.oldCcy.clone(this.ccy);
            this.parent.ccyf = new CurrencyForm(this.parent, this.ccy, "Edit");
            return;
        }
        if (cmd.equals("Delete")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to delete", 2000).show();
                return;
            }
            this.parent.ccyf = new CurrencyForm(this.parent, this.ccy, "Delete");
            return;
        }
        if (cmd.equals("Internet Rate")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to edit", 2000).show();
                return;
            }
            if (this.parent.alphaVantageKey.equals("")) {
                this.parent.getAlphaVantageKey();
                return;
            }
            this.updateInternetRate(this.ccy);
            return;
        }
        if (cmd.equals("Show")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to show", 2000).show();
                return;
            }
            this.parent.gsf = new GenericShowForm(this.parent, this.ccy, 5);
            this.parent.setContentView(this.parent.gsf);
            return;
        }
        if (cmd.equals("Get API Key")) {
            this.parent.getAlphaVantageKey();
            return;
        }
        if (cmd.equals("Switch Views")) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.showSwitchViewsMenu = true;
                this.setupSwitchViewsMenu();
                this.repaint();
                return;
            }
            this.displaySwitchViewsMenu();
            return;
        }
        if (cmd.equals("Exit")) {
            this.parent.finishAndQuit();
        }
        if (cmd.equals("Accounts") || cmd.equals("Home")) {
            if (this.parent.av == null) {
                this.parent.av = new AccountView(this.parent);
            }
            this.parent.setContentView(this.parent.av);
            this.repaint();
            return;
        }
        if (cmd.equals("Transactions")) {
            if (this.parent.tv == null) {
                Toast.makeText(this.parent, "No account selected", 2000).show();
            } else {
                this.parent.setContentView(this.parent.tv);
            }
            this.repaint();
            return;
        }
        if (cmd.equals("Categories")) {
            if (this.parent.cv == null) {
                this.parent.cv = new CategoryView(this.parent);
            }
            this.parent.setContentView(this.parent.cv);
            this.repaint();
            return;
        }
        if (cmd.equals("Standing Orders")) {
            if (this.parent.sov == null) {
                this.parent.sov = new StandingOrderView(this.parent);
            }
            this.parent.setContentView(this.parent.sov);
            this.repaint();
            return;
        }
        if (cmd.equals("Investments")) {
            if (this.parent.iv == null) {
                this.parent.iv = new InvestmentView(this.parent);
            }
            this.parent.setContentView(this.parent.iv);
            this.repaint();
            return;
        }
        if (cmd.equals("Currencies")) {
            Toast.makeText(this.parent, "Already in Currencies View", 2000).show();
            this.repaint();
            return;
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int keyCode = keyEvent.getKeyCode();
        switch (keyCode) {
            case 33: 
            case 37: {
                if (this.startPos == 0) {
                    this.currentPos = 0;
                    this.currentY = this.lineHeight;
                    break;
                }
                this.startPos -= this.numItemsPage;
                if (this.startPos >= 0) break;
                this.startPos = 0;
                break;
            }
            case 34: 
            case 39: {
                this.startPos += this.numItemsPage;
                if (this.startPos + this.currentPos <= this.numItems - 1) break;
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                break;
            }
            case 38: {
                this.drawUp();
                break;
            }
            case 40: {
                this.drawDown();
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int keyCode = keyEvent.getKeyCode();
        switch (keyCode) {
            case 36: {
                this.startPos = 0;
                this.currentPos = 0;
                this.currentY = this.lineHeight;
                break;
            }
            case 35: {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                break;
            }
            case 10: 
            case 525: {
                if (this.showCanvasMenu) {
                    this.showCanvasMenu = false;
                    if (this.showSwitchViewsMenu) {
                        this.showSwitchViewsMenu = false;
                        this.processSwitchViewsMenu(this.startMenuPos + this.currentMenuPos);
                        break;
                    }
                    this.processMenuCommand(this.startMenuPos + this.currentMenuPos);
                    break;
                }
                if (this.numItems == 0) break;
                if (this.parent.useCanvasMenu) {
                    this.showCanvasMenu = true;
                    break;
                }
                if (keyCode != 525) break;
                this.displayPopupMenu();
                break;
            }
            case 27: {
                this.parent.onBackPressed();
                break;
            }
            case 78: {
                this.commandAction("New");
                break;
            }
            case 69: {
                this.commandAction("Edit");
                break;
            }
            case 68: {
                this.commandAction("Delete");
                break;
            }
            case 70: {
                this.commandAction("Find");
                break;
            }
            case 83: {
                this.commandAction("Show");
                break;
            }
            case 72: {
                this.commandAction("Home");
                break;
            }
            case 86: {
                this.commandAction("Switch Views");
                break;
            }
            case 75: {
                this.parent.gsf = new GenericShowForm(this.parent, null, 9);
                this.parent.setContentView(this.parent.gsf);
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

