/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.freepoc.Jabp4.Currency;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.NameId;
import org.freepoc.Jabp4.RecordStore;

public class CurrencyStore {
    RecordStore rs;
    Jabp parent;
    Hashtable ht;

    public CurrencyStore(Jabp context, boolean fastDiskAccess) {
        this.parent = context;
        this.ht = this.parent.currencyHt;
        this.openCurrencyStore(fastDiskAccess);
    }

    void openCurrencyStore(boolean fastDiskAccess) {
        this.rs = new RecordStore(this.parent, "Currencies", fastDiskAccess);
    }

    void closeCurrencyStore() {
        if (this.rs != null) {
            this.rs.closeRecordStore();
        }
    }

    int getNumCurrencies() {
        return this.rs.getNumRecords();
    }

    byte[] toByteArray(Currency ccy) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeUTF(ccy.code);
            dos.writeUTF(ccy.description);
            dos.writeInt(ccy.rate);
            dos.writeInt(ccy.oldRate);
            dos.close();
        }
        catch (IOException ie) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    Currency fromByteArray(byte[] bytes) {
        Currency ccy = new Currency();
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            ccy.code = dis.readUTF();
            ccy.description = dis.readUTF();
            ccy.rate = dis.readInt();
            ccy.oldRate = dis.readInt();
            dis.close();
        }
        catch (IOException ie) {
            System.err.println(ie + " ccy4a");
        }
        return ccy;
    }

    Currency getCurrency(int id) {
        Currency ccy = new Currency();
        byte[] bytes = this.rs.getRecord(id);
        ccy = this.fromByteArray(bytes);
        ccy.id = id;
        return ccy;
    }

    void setToStart() {
        this.rs.setToStart();
    }

    Currency readNextCurrency() {
        Currency ccy = new Currency();
        byte[] bytes = this.rs.readRecord();
        if (bytes == null) {
            return null;
        }
        int id = this.rs.getCurrentFilePosition() - bytes.length - 5;
        ccy = this.fromByteArray(bytes);
        ccy.id = id;
        return ccy;
    }

    Currency getCurrencyFromIndex(int i) {
        int id = ((NameId)this.ht.get((Object)new Integer((int)i))).id;
        return this.getCurrency(id);
    }

    Currency getCurrencyFromName(String string) {
        int n = this.getNumCurrencies();
        for (int i = 0; i < n; ++i) {
            String s1 = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!s1.equals(string)) continue;
            int id = ((NameId)this.ht.get((Object)new Integer((int)i))).id;
            return this.getCurrency(id);
        }
        Currency ccy = new Currency();
        ccy.code = string;
        ccy.id = this.saveNewCurrency(ccy);
        if (this.parent.ccyv != null) {
            ++this.parent.ccyv.numItems;
        }
        return ccy;
    }

    boolean doesCurrencyNameExist(String name) {
        int n = this.getNumCurrencies();
        for (int i = 0; i < n; ++i) {
            String s1 = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!s1.equals(name)) continue;
            return true;
        }
        return false;
    }

    void deleteCurrency(Currency ccy) {
        this.rs.deleteRecord(ccy.id);
    }

    int saveNewCurrency(Currency ccy) {
        ccy.id = this.rs.getNextRecordID();
        byte[] bytes = this.toByteArray(ccy);
        this.rs.addRecord(bytes, 0, bytes.length);
        this.addIndex(ccy);
        return ccy.id;
    }

    void saveExistingCurrency(Currency ccy) {
        byte[] bytes = this.toByteArray(ccy);
        this.rs.setRecord(ccy.id, bytes, 0, bytes.length);
    }

    int lookUpId(Currency ccy) {
        ccy.id = 0;
        int n = this.ht.size();
        for (int i = 0; i < n; ++i) {
            String string = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!string.equals(ccy.code)) continue;
            ccy.id = ((NameId)this.ht.get((Object)Integer.valueOf((int)i))).id;
            break;
        }
        return ccy.id;
    }

    int lookUpIndex(Currency ccy) {
        int n = this.ht.size();
        int j = -1;
        for (int i = 0; i < n; ++i) {
            String string = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!string.equals(ccy.code)) continue;
            j = i;
            break;
        }
        return j;
    }

    void deleteIndex(int index) {
        int n = this.ht.size();
        for (int i = index; i < n - 1; ++i) {
            int j = i + 1;
            NameId nameId = (NameId)this.ht.get(new Integer(j));
            this.ht.put(new Integer(i), nameId);
        }
        this.ht.remove(new Integer(n - 1));
    }

    void addIndex(Currency ccy) {
        int i;
        int n;
        int p = n = this.ht.size();
        for (i = 0; i < n; ++i) {
            NameId nameId = (NameId)this.ht.get(new Integer(i));
            if (ccy.code.compareTo(nameId.name) >= 0) continue;
            p = i;
            break;
        }
        if (p < n) {
            for (i = n - 1; i >= p; --i) {
                int j = i + 1;
                NameId nameId = (NameId)this.ht.get(new Integer(i));
                this.ht.put(new Integer(j), nameId);
            }
        }
        NameId nameId = new NameId(ccy.code, ccy.id);
        this.ht.put(new Integer(p), nameId);
    }

    int getSize() {
        return this.rs.getSize();
    }
}

