/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JTextField;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.AccountStore;
import org.freepoc.Jabp4.Currency;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.Investment;
import org.freepoc.Jabp4.InvestmentStore;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.Toast;

public class CurrencyForm
extends Component {
    Jabp parent;
    Currency ccy;
    int iNew;
    int iHome;

    public CurrencyForm(Jabp context, Currency ccy1, String action) {
        this.parent = context;
        this.ccy = ccy1;
        this.parent.lastUsedScreen = 13;
        if (action.equals("New")) {
            this.createCurrency(new Currency());
        }
        if (action.equals("Edit")) {
            this.updateCurrency(this.ccy);
        }
        if (action.equals("Delete")) {
            this.deleteCurrency(this.ccy);
        }
    }

    void createCurrency(Currency ccy) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(5);
        nf.setMinimumFractionDigits(5);
        DialogManager dm = new DialogManager(this.parent, "New currency");
        JTextField code = dm.addJTextField("Code", ccy.code);
        JTextField description = dm.addJTextField("Description", ccy.description);
        JTextField tfNew = dm.addJTextField("Amount of new currency", nf.format((double)ccy.rate / 100000.0));
        JTextField tfHome = dm.addJTextField("Amount of home currency", "1.00");
        dm.addButton("Cancel");
        dm.addButton("Create");
        dm.centerShow();
        if (!dm.checkButtons()) {
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            dm.dispose();
            return;
        }
        String name = dm.getUserText(code).trim();
        if (name.equals("")) {
            Toast.makeText(this.parent, "Blank currency code", 2000).show();
            dm.dispose();
            this.createCurrency(ccy);
            return;
        }
        ccy.code = name;
        if (this.parent.ccyv.ccys.lookUpId(ccy) != 0) {
            Toast.makeText(this.parent, name + " already exists", 2000).show();
            dm.dispose();
            this.createCurrency(ccy);
            return;
        }
        ccy.description = dm.getUserText(description).trim();
        ccy.oldRate = ccy.rate;
        double d1 = dm.getUserDouble(tfNew);
        double d2 = dm.getUserDouble(tfHome);
        ccy.rate = (int)(d1 * 100000.0 / d2);
        this.parent.ccyv.newCurrency(ccy);
        Toast.makeText(this.parent, ccy.code + " created", 1000).show();
        dm.dispose();
    }

    void updateCurrency(Currency ccy) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(5);
        nf.setMinimumFractionDigits(5);
        DialogManager dm = new DialogManager(this.parent, "Edit currency");
        JTextField code = dm.addJTextField("Code", ccy.code);
        JTextField description = dm.addJTextField("Description", ccy.description);
        JTextField tfNew = dm.addJTextField("Amount of new currency", nf.format((double)ccy.rate / 100000.0));
        JTextField tfHome = dm.addJTextField("Amount of home currency", "1.00");
        dm.addButton("Cancel");
        dm.addButton("Update");
        dm.centerShow();
        if (!dm.checkButtons()) {
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            dm.dispose();
            return;
        }
        boolean updateHome = false;
        if (ccy.code.equals(this.parent.homeCurrency)) {
            updateHome = true;
        }
        String oldName = ccy.code;
        String newName = dm.getUserText(code).trim();
        if (newName.equals("")) {
            Toast.makeText(this.parent, "Blank currency code", 2000).show();
            this.updateCurrency(ccy);
            return;
        }
        ccy.code = newName;
        int k = ccy.id;
        if (!oldName.equals(newName) && this.parent.ccyv.ccys.lookUpId(ccy) != 0) {
            Toast.makeText(this.parent, newName + " already exists", 2000).show();
            ccy.code = oldName;
            this.updateCurrency(ccy);
            return;
        }
        ccy.id = k;
        ccy.description = dm.getUserText(description).trim();
        double d1 = dm.getUserDouble(tfNew);
        double d2 = dm.getUserDouble(tfHome);
        ccy.rate = (int)(d1 * 100000.0 / d2);
        if (updateHome && ccy.rate != 100000) {
            Toast.makeText(this.parent, "Home currency rate must be 1.00000", 2000).show();
            this.updateCurrency(ccy);
            return;
        }
        this.parent.ccyv.editCurrency(ccy);
        if (updateHome) {
            this.parent.homeCurrency = ccy.code;
        }
        Toast.makeText(this.parent, ccy.code + " updated", 1000).show();
        dm.dispose();
    }

    void deleteCurrency(Currency ccy) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(5);
        nf.setMinimumFractionDigits(5);
        DialogManager dm = new DialogManager(this.parent, "Delete currency");
        JTextField code = dm.addJTextField("Code", ccy.code);
        JTextField description = dm.addJTextField("Description", ccy.description);
        JTextField tfNew = dm.addJTextField("Amount of new currency", nf.format((double)ccy.rate / 100000.0));
        JTextField tfHome = dm.addJTextField("Amount of home currency", "1.00");
        dm.addButton("Cancel");
        dm.addButton("Delete");
        dm.centerShow();
        if (!dm.checkButtons()) {
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            dm.dispose();
            return;
        }
        if (ccy.code.equals(this.parent.homeCurrency)) {
            Toast.makeText(this.parent, "Cannot delete home currency", 2000).show();
            return;
        }
        AccountStore as = this.parent.av.as;
        Account a2 = null;
        as.setToStart();
        while ((a2 = as.readNextAccount()) != null) {
            if (!a2.currency.equals(ccy.code)) continue;
            Toast.makeText(this.parent, "Cannot delete, there are accounts", 2000).show();
            return;
        }
        InvestmentStore is = null;
        is = this.parent.iv == null ? new InvestmentStore(this.parent, true) : this.parent.iv.is;
        Investment inv2 = null;
        is.setToStart();
        while ((inv2 = is.readNextInvestment()) != null) {
            if (!inv2.currency.equals(ccy.code)) continue;
            Toast.makeText(this.parent, "Cannot delete, there are investments", 2000).show();
            if (this.parent.iv == null) {
                is.closeInvestmentStore();
                is = null;
            }
            return;
        }
        if (this.parent.iv == null) {
            is.closeInvestmentStore();
            is = null;
        }
        this.parent.ccyv.deleteCurrency(ccy);
        Toast.makeText(this.parent, ccy.code + " deleted", 1000).show();
        dm.dispose();
    }
}

