/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.AccountView;
import org.freepoc.Jabp4.Category;
import org.freepoc.Jabp4.CategoryForm;
import org.freepoc.Jabp4.CategoryStore;
import org.freepoc.Jabp4.CurrencyView;
import org.freepoc.Jabp4.DateChooser;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.FilterForm;
import org.freepoc.Jabp4.FindView;
import org.freepoc.Jabp4.GenericShowForm;
import org.freepoc.Jabp4.InvestmentView;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.LongIntId;
import org.freepoc.Jabp4.Regular;
import org.freepoc.Jabp4.RegularStore;
import org.freepoc.Jabp4.ShowProgressForm;
import org.freepoc.Jabp4.Split;
import org.freepoc.Jabp4.StandingOrder;
import org.freepoc.Jabp4.StandingOrderStore;
import org.freepoc.Jabp4.StandingOrderView;
import org.freepoc.Jabp4.SyncStore;
import org.freepoc.Jabp4.TimedMessage;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.TopExpensesView;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.TransactionStore;
import org.freepoc.Jabp4.Utilities;

public class CategoryView
extends Canvas
implements ActionListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
Runnable {
    Jabp parent;
    Font font;
    FontMetrics fm;
    Category c;
    Category c1;
    Category oldC;
    CategoryStore cs;
    String msg = "";
    Vector canvasMenu;
    Vector filterVector;
    Thread thread;
    Graphics g1;
    Point point;
    Image image;
    TimedMessage tm;
    Date filterFromDate;
    Date filterToDate;
    int menuWidth;
    int menuWidthPos;
    int menuHeightPos;
    int menuHeight;
    int startMenuPos;
    int currentMenuPos;
    int numMenuItems;
    int cameFrom;
    int filterTotal;
    int categoryWidth;
    int width;
    int height;
    int fontHeight;
    int lineHeight;
    int numberWidth;
    int spacing;
    int currentX;
    int currentY;
    int currentPos;
    int startPos;
    int runMode;
    int numItems;
    int numItemsPage;
    int minCategoryAmount;
    int maxCategoryAmount;
    int totalOpen;
    int totalCurrent;
    int openPosition;
    int currentPosition;
    int oldY;
    int previousPos;
    int lastDragX;
    int lastDragY;
    boolean filterFlag = false;
    long timePointerOnScreen;
    boolean pointerExecute;
    boolean oneClickFlag;
    boolean start;
    boolean showSwitchViewsMenu = false;
    boolean calculateCanvasMenuPosition = true;
    boolean alwaysDisplayMenu = false;
    boolean paintWholeScreen = true;
    boolean paintHeaderOnly = false;
    boolean showCanvasMenu = false;
    boolean showingPopupMenu = false;
    boolean dragScreen = false;
    boolean showThreeColumns = false;

    CategoryView(Jabp context) {
        this.parent = context;
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.filterFromDate = this.parent.todayDate;
        this.filterToDate = this.parent.todayDate;
        this.cs = new CategoryStore(this.parent, false);
        this.parent.dataIntegrityCheck("Categories", this.cs.getNumCategories(), this.parent.categoryHt.size());
        if (this.cs.getNumCategories() == 0) {
            this.cs.setUpCategories();
        }
        this.numItems = this.cs.getNumCategories();
        this.font = this.parent.font;
        this.setFont(this.font);
        this.fm = this.getFontMetrics(this.font);
        this.lineHeight = this.parent.fontHeight + this.parent.lineSpacing * 2;
        this.setTotals();
        this.currentX = 0;
        this.currentY = this.lineHeight;
        this.currentPos = 0;
        this.startPos = 0;
        this.setupCanvasMenu();
        this.runMode = 0;
        this.start = true;
        this.oneClickFlag = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
    }

    @Override
    public void paint(Graphics g) {
        if (this.start) {
            this.start = false;
            this.setTotals();
        }
        this.parent.lastUsedScreen = 2;
        this.parent.lastUsedView = 2;
        this.setPositions();
        this.g1.clearRect(0, 0, this.width, this.height);
        this.g1.setFont(this.font);
        this.showHeader();
        this.showPage();
        this.showFooter();
        if (this.parent.useCanvasMenu && this.showCanvasMenu) {
            this.displayCanvasMenu();
        }
        g.drawImage(this.image, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    void showPage() {
        this.g1.setColor(new Color(this.parent.colorBackground));
        this.g1.fillRect(0, this.lineHeight, this.width, this.height - this.lineHeight * 2);
        this.g1.setColor(new Color(this.parent.colorFont));
        if (this.numItems == 0) {
            this.g1.drawString("Click here to add category", this.parent.widthAdjustment, this.lineHeight * 2);
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                this.g1.setColor(new Color(this.parent.colorCursor));
                this.g1.fillRect(0, this.lineHeight * i + this.lineHeight, this.width, this.lineHeight);
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            this.c = this.cs.getCategoryFromIndex(i + this.startPos);
            this.c.open = 0;
            if (this.filterFlag) {
                int j = (Integer)this.filterVector.elementAt(i + this.startPos);
                if (this.showThreeColumns) {
                    this.c.open = j;
                } else {
                    this.c.current = j;
                }
            }
            this.buildLine(this.c, this.lineHeight * i + this.lineHeight);
        }
        this.c = this.cs.getCategoryFromIndex(this.startPos + this.currentPos);
    }

    void showHeader() {
        int vpos = this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorHeading));
        this.g1.fillRect(0, 0, this.width, this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        String s = "Categories";
        if (this.filterFlag) {
            s = s + "[*]";
        }
        this.g1.drawString(s, this.parent.widthAdjustment, vpos);
        String s1 = "Filter";
        String s2 = "Current";
        if (this.filterFlag && !this.showThreeColumns) {
            s2 = "Filter";
        }
        if (this.filterFlag && this.showThreeColumns) {
            this.g1.drawString(s1, this.openPosition + this.numberWidth - this.fm.stringWidth(s1), vpos);
        }
        this.g1.drawString(s2, this.currentPosition + this.numberWidth - this.fm.stringWidth(s2), vpos);
    }

    void showFooter() {
        int vpos = this.height - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorHeading));
        this.g1.fillRect(0, this.height - this.lineHeight, this.width, this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        this.g1.drawString("Totals", this.parent.widthAdjustment, vpos);
        String s1 = "";
        String s2 = "";
        boolean s1Flag = false;
        boolean s2Flag = false;
        if (this.filterFlag) {
            if (this.showThreeColumns) {
                if (this.filterTotal < 0) {
                    s1Flag = true;
                }
                s1 = Utilities.numberToString(this.filterTotal, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
                if (this.totalCurrent < 0) {
                    s2Flag = true;
                }
                s2 = Utilities.numberToString(this.totalCurrent, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            } else {
                if (this.filterTotal < 0) {
                    s2Flag = true;
                }
                s2 = Utilities.numberToString(this.filterTotal, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            }
        } else {
            if (this.totalOpen < 0) {
                s1Flag = true;
            }
            s1 = Utilities.numberToString(this.totalOpen, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            if (this.totalCurrent < 0) {
                s2Flag = true;
            }
            s2 = Utilities.numberToString(this.totalCurrent, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        }
        if (this.filterFlag && this.showThreeColumns) {
            if (s1Flag) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            } else {
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            this.g1.drawString(s1, this.openPosition + this.numberWidth - this.fm.stringWidth(s1), vpos);
        }
        if (s2Flag) {
            this.g1.setColor(new Color(this.parent.colorNegative));
        } else {
            this.g1.setColor(new Color(this.parent.colorFont));
        }
        this.g1.drawString(s2, this.currentPosition + this.numberWidth - this.fm.stringWidth(s2), vpos);
    }

    void drawUp() {
        if (this.showCanvasMenu) {
            if (this.currentMenuPos > 0) {
                --this.currentMenuPos;
            } else {
                --this.startMenuPos;
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (this.startPos + this.currentPos > 0) {
            this.oldY = this.currentY;
            this.currentY -= this.lineHeight;
            --this.currentPos;
            if (this.currentY < this.lineHeight) {
                this.currentY = this.lineHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
                this.repaint();
            } else {
                this.repaint(0, this.lineHeight * this.currentPos + this.lineHeight, this.width, this.lineHeight * 2);
            }
            return;
        }
    }

    void drawDown() {
        if (this.showCanvasMenu) {
            if (this.currentMenuPos < Math.min(this.numItemsPage, this.numMenuItems) - 1) {
                ++this.currentMenuPos;
            } else {
                ++this.startMenuPos;
                if (this.startMenuPos + this.currentPos > Math.min(this.numItemsPage, this.numMenuItems) - 1) {
                    this.startMenuPos = Math.min(this.numItemsPage, this.numMenuItems) - 1 - this.currentPos;
                }
            }
            this.repaint();
            return;
        }
        if (this.startPos + this.currentPos < this.numItems - 1) {
            this.oldY = this.currentY;
            this.currentY += this.lineHeight;
            ++this.currentPos;
            if (this.currentY + this.lineHeight * 2 > this.height) {
                this.currentY -= this.lineHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
                this.repaint();
            } else {
                this.repaint(0, this.lineHeight * (this.currentPos - 1) + this.lineHeight, this.width, this.lineHeight * 2);
            }
            return;
        }
    }

    void buildLine(Category category, int y) {
        int vpos = y + this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorFont));
        int j = category.name.length();
        for (int i = 0; i < j; ++i) {
            int k = j - i;
            if (this.fm.stringWidth(category.name.substring(0, k)) > this.categoryWidth) continue;
            this.g1.drawString(category.name.substring(0, k), this.parent.widthAdjustment, vpos);
            break;
        }
        String s = "";
        if (this.filterFlag && this.showThreeColumns) {
            if (category.open < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            } else {
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            s = Utilities.numberToString(category.open, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            this.g1.drawString(s, this.openPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
        }
        if (category.current < 0) {
            this.g1.setColor(new Color(this.parent.colorNegative));
        } else {
            this.g1.setColor(new Color(this.parent.colorFont));
        }
        s = Utilities.numberToString(category.current, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        this.g1.drawString(s, this.currentPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
    }

    void setPositions() {
        this.fontHeight = this.parent.fontHeight;
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.image = this.createImage(this.width, this.height);
        this.g1 = this.image.getGraphics();
        Utilities.enableAntialiasing(this.g1);
        if (this.parent.lineSpacing == 0) {
            this.parent.lineSpacing = this.fontHeight / 5;
        }
        this.lineHeight = this.fontHeight + this.parent.lineSpacing * 2;
        this.numItemsPage = this.height / this.lineHeight - 2;
        this.spacing = this.fm.stringWidth("  ");
        this.numberWidth = this.minCategoryAmount < -9999999 || this.maxCategoryAmount > 99999999 ? (this.parent.isGroupingUsed ? this.fm.stringWidth("9,999,999.99") : this.fm.stringWidth("9999999.99")) : (this.minCategoryAmount < -999999 || this.maxCategoryAmount > 9999999 ? (this.parent.isGroupingUsed ? this.fm.stringWidth("999,999.99") : this.fm.stringWidth("999999.99")) : (this.minCategoryAmount < -99999 || this.maxCategoryAmount > 999999 ? (this.parent.isGroupingUsed ? this.fm.stringWidth("99,999.99") : this.fm.stringWidth("99999.99")) : (this.parent.isGroupingUsed ? this.fm.stringWidth("9,999.99") : this.fm.stringWidth("9999.99"))));
        this.categoryWidth = this.width - this.numberWidth - this.parent.widthAdjustment * 2 - this.spacing;
        if (this.filterFlag && this.categoryWidth - this.numberWidth - this.spacing > this.width / 3) {
            this.categoryWidth = this.categoryWidth - this.numberWidth - this.spacing;
            this.openPosition = this.categoryWidth + this.parent.widthAdjustment + this.spacing;
            this.currentPosition = this.openPosition + this.numberWidth + this.spacing;
            this.showThreeColumns = true;
        } else {
            this.categoryWidth = Math.min(this.categoryWidth, this.width * 2 / 3);
            this.currentPosition = this.categoryWidth + this.parent.widthAdjustment + this.spacing;
            this.showThreeColumns = false;
        }
    }

    void newCategory(Category category) {
        this.c1 = category;
        this.c1.id = this.cs.saveNewCategory(this.c1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.cs.toByteArray(this.c1), 2);
        }
        if (this.c == null) {
            this.c = this.c1;
        }
        ++this.numItems;
        this.totalCurrent += this.c1.current;
        this.checkMinMax(this.c1);
        this.repaint();
    }

    void editCategory(Category category) {
        this.c1 = category;
        this.cs.deleteCategory(this.oldC);
        this.cs.deleteIndex(this.startPos + this.currentPos);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.cs.toByteArray(this.oldC), -2);
        }
        this.c1.id = this.cs.saveNewCategory(this.c1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.cs.toByteArray(this.c1), 2);
        }
        this.totalCurrent += this.c1.current - this.oldC.current;
        this.checkMinMax(this.c1);
        if (!this.c1.name.equals(this.oldC.name)) {
            this.parent.spf = new ShowProgressForm(this.parent, 3);
            this.parent.setContentView(this.parent.spf);
            this.runMode = 1;
            this.runThread();
        } else {
            this.msg = "";
            this.parent.setContentView(this);
            this.repaint();
        }
    }

    void deleteCategory(Category category) {
        this.c1 = category;
        this.cs.deleteCategory(this.c1);
        this.cs.deleteIndex(this.startPos + this.currentPos);
        this.totalCurrent -= this.c1.current;
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.lineHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
        this.parent.spf = new ShowProgressForm(this.parent, 3);
        this.parent.setContentView(this.parent.spf);
        this.runMode = 6;
        this.runThread();
    }

    void checkMinMax(Category category) {
        this.minCategoryAmount = Math.min(this.minCategoryAmount, category.current);
        this.maxCategoryAmount = Math.max(this.maxCategoryAmount, category.current);
        this.minCategoryAmount = Math.min(this.minCategoryAmount, this.totalCurrent);
        this.maxCategoryAmount = Math.max(this.maxCategoryAmount, this.totalCurrent);
    }

    void setTotals() {
        this.totalOpen = 0;
        this.totalCurrent = 0;
        this.minCategoryAmount = 0;
        this.maxCategoryAmount = 0;
        if (this.numItems <= 0) {
            return;
        }
        for (int i = 0; i < this.numItems; ++i) {
            this.c = this.cs.getCategoryFromIndex(i);
            this.totalOpen += this.c.open;
            this.totalCurrent += this.c.current;
            this.minCategoryAmount = Math.min(this.minCategoryAmount, this.c.current);
            this.maxCategoryAmount = Math.max(this.maxCategoryAmount, this.c.current);
        }
        this.minCategoryAmount = Math.min(this.minCategoryAmount, this.totalCurrent);
        this.maxCategoryAmount = Math.max(this.maxCategoryAmount, this.totalCurrent);
        this.c = this.cs.getCategoryFromIndex(0);
    }

    void deleteCategoryName() {
        Category cNone = this.cs.getCategoryFromName("None");
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.cs.toByteArray(cNone), -2);
        }
        cNone.current += this.c1.current;
        this.cs.saveExistingCategory(cNone);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.cs.toByteArray(cNone), 2);
        }
        this.totalCurrent += this.c1.current;
        this.updateCategoryName(this.c1.name, "None", false);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.cs.toByteArray(this.c1), -2);
        }
    }

    void updateCategoryName(String oldName, String newName, boolean isEdit) {
        if (this.parent.syncMode) {
            this.parent.sync.closeSyncStore();
            this.parent.sync = new SyncStore(this.parent, true);
        }
        this.parent.show("Checking database\nUpdating standing orders");
        int found = 0;
        boolean foundFlag = false;
        if (this.parent.sov != null) {
            this.parent.sov.sos.closeStandingOrderStore();
            this.parent.sov = null;
        }
        this.parent.standingOrderHt = new Hashtable();
        StandingOrderStore sos = new StandingOrderStore(this.parent, true);
        sos.rs.activeRecords = 0;
        StandingOrder so2 = null;
        sos.setToStart();
        while ((so2 = sos.readNextStandingOrder()) != null) {
            if (so2.category.equals(oldName)) {
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(sos.toByteArray(so2), -6);
                }
                so2.category = newName;
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(sos.toByteArray(so2), 6);
                }
                this.parent.cv.cs.getCategoryFromName(newName);
                ++found;
            }
            byte[] bytes = sos.toByteArray(so2);
            so2.id = sos.rs.writeRecordToTemporary(bytes);
            ++sos.rs.activeRecords;
            sos.addIndex(so2);
        }
        sos.rs.deletedSpace = 0;
        sos.rs.putHeader();
        sos.closeStandingOrderStore();
        sos.rs.switchFiles();
        this.parent.show(found + " standing orders were updated\nUpdating regulars");
        found = 0;
        if (this.parent.tv != null) {
            this.parent.tv.rs.closeRegularStore();
        }
        this.parent.regularHt = new Hashtable();
        RegularStore rs = new RegularStore(this.parent, true);
        rs.rs.activeRecords = 0;
        Regular r2 = null;
        Regular r3 = new Regular();
        rs.setToStart();
        while ((r2 = rs.readNextRegular()) != null) {
            r3 = r3.clone(r2);
            if (r2.splitFlag) {
                boolean flag = false;
                for (int i = 0; i < r2.ss.size(); ++i) {
                    Split s = r2.ss.getSplit(i);
                    if (!s.category.equals(oldName)) continue;
                    s.category = newName;
                    r2.ss.setSplit(s, i);
                    flag = true;
                }
                if (flag) {
                    if (this.parent.syncMode) {
                        this.parent.sync.saveSyncRecord(rs.toByteArray(r3), -5);
                    }
                    if (this.parent.syncMode) {
                        this.parent.sync.saveSyncRecord(rs.toByteArray(r2), 5);
                    }
                    this.parent.cv.cs.getCategoryFromName(newName);
                    ++found;
                }
            } else if (r2.category.equals(oldName)) {
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(rs.toByteArray(r2), -5);
                }
                r2.category = newName;
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(rs.toByteArray(r2), 5);
                }
                this.parent.cv.cs.getCategoryFromName(newName);
                ++found;
            }
            byte[] bytes = rs.toByteArray(r2);
            r2.id = rs.rs.writeRecordToTemporary(bytes);
            ++rs.rs.activeRecords;
            rs.addIndex(r2);
        }
        rs.rs.deletedSpace = 0;
        rs.rs.putHeader();
        rs.closeRegularStore();
        rs.rs.switchFiles();
        this.parent.show(found + " regulars were updated\nUpdating transactions");
        found = 0;
        if (this.parent.tv != null) {
            this.parent.tv.ts.closeTransactionStore();
            this.parent.tv = null;
        }
        this.parent.transactionHt = new Hashtable();
        TransactionStore ts = new TransactionStore(this.parent, new Account(), true);
        ts.rs.activeRecords = 0;
        Transaction t2 = null;
        Transaction t3 = new Transaction();
        ts.setToStart();
        int count = 0;
        Account a2 = new Account();
        while ((t2 = ts.readNextTransaction()) != null) {
            t3 = t3.clone(t2);
            if (t2.splitFlag) {
                boolean flag = false;
                for (int i = 0; i < t2.ss.size(); ++i) {
                    Split s = t2.ss.getSplit(i);
                    if (!s.category.equals(oldName)) continue;
                    s.category = newName;
                    t2.ss.setSplit(s, i);
                    flag = true;
                }
                if (flag) {
                    if (this.parent.syncMode) {
                        this.parent.sync.saveSyncRecord(ts.toByteArray(t3), -8);
                    }
                    if (this.parent.syncMode) {
                        this.parent.sync.saveSyncRecord(ts.toByteArray(t2), 8);
                    }
                    this.parent.cv.cs.getCategoryFromName(newName);
                    ++found;
                }
            } else if (t2.category.equals(oldName)) {
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(ts.toByteArray(t2), -8);
                }
                t2.category = newName;
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(ts.toByteArray(t2), 8);
                }
                this.parent.cv.cs.getCategoryFromName(newName);
                ++found;
            }
            a2.name = t2.account;
            ts.getIndex(a2);
            byte[] bytes = ts.toByteArray(t2);
            t2.id = ts.rs.writeRecordToTemporary(bytes);
            ++ts.rs.activeRecords;
            ts.addIndex(t2);
            ts.setIndex(a2);
            if (++count / 1000 * 1000 != count) continue;
            this.parent.show(count + " transactions read");
        }
        ts.rs.deletedSpace = 0;
        ts.rs.putHeader();
        ts.closeTransactionStore();
        ts.rs.switchFiles();
        this.parent.show(found + " transactions were updated\nFinished");
        if (this.parent.syncMode) {
            this.parent.sync.closeSyncStore();
            this.parent.sync = new SyncStore(this.parent, false);
        }
        this.parent.showDoneButton();
    }

    void getFilterDates() {
        DialogManager dm = new DialogManager(this.parent, "Filter");
        JComboBox cgFilter = dm.addJComboBox("Set");
        dm.addJComboBoxItem(cgFilter, "Filter Off");
        dm.addJComboBoxItem(cgFilter, "Filter On");
        if (this.filterFlag) {
            dm.setSelectedJComboBox(cgFilter, 1);
        } else {
            dm.setSelectedJComboBox(cgFilter, 0);
        }
        dm.addOKCancelButtons();
        dm.centerShow();
        if (!dm.checkButtons()) {
            dm.dispose();
            this.repaint();
            this.filterFlag = false;
            return;
        }
        int j = dm.getSelectedJComboBoxItem(cgFilter);
        dm.dispose();
        if (j == 0) {
            this.filterFlag = false;
            return;
        }
        this.filterFlag = this.selectDates(this.filterFromDate, this.filterToDate);
    }

    boolean selectDates(Date date1, Date date2) {
        this.filterFromDate = date1;
        this.filterToDate = date2;
        if (this.filterFromDate == null) {
            this.filterFromDate = new Date();
        }
        if (this.filterToDate == null) {
            this.filterToDate = new Date();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdf2 = new SimpleDateFormat("dd/MM/yyyy HH");
        DialogManager dm = new DialogManager(this.parent, "Select Dates");
        JTextField tfFromDate = dm.addJTextFieldWithButton("From Date", sdf.format(this.filterFromDate), "1>");
        JTextField tfToDate = dm.addJTextFieldWithButton("To Date", sdf.format(this.filterToDate), "2>");
        dm.addOKCancelButtons();
        dm.centerShow();
        if (!dm.checkButtons()) {
            dm.dispose();
            return false;
        }
        try {
            this.filterFromDate = sdf2.parse(dm.getUserText(tfFromDate) + " 02");
            this.filterToDate = sdf2.parse(dm.getUserText(tfToDate) + " 02");
        }
        catch (ParseException pe) {
            this.tm = new TimedMessage(this.parent, "Illegal date format");
            return false;
        }
        if (dm.checkButtonText().equals("1>")) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(this.filterFromDate);
            DateChooser dc = new DateChooser((Frame)this.parent, gc);
            if (dc.showDateChooser() == 1) {
                gc = dc.getDate();
            }
            this.filterFromDate = gc.getTime();
            return this.selectDates(this.filterFromDate, this.filterToDate);
        }
        if (dm.checkButtonText().equals("2>")) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(this.filterToDate);
            DateChooser dc = new DateChooser((Frame)this.parent, gc);
            if (dc.showDateChooser() == 1) {
                gc = dc.getDate();
            }
            this.filterToDate = gc.getTime();
            return this.selectDates(this.filterFromDate, this.filterToDate);
        }
        dm.dispose();
        return true;
    }

    void processFilter() {
        if (!this.filterFlag) {
            if (this.cameFrom == 1) {
                return;
            }
            this.parent.tev = new TopExpensesView(this.parent, false, null);
            this.parent.setContentView(this.parent.tev);
            return;
        }
        this.runMode = 3;
        this.run();
    }

    void processFilter2() {
        this.filterFlag = false;
        this.show("Processing, please wait...", true);
        if (this.parent.tv != null) {
            this.parent.tv.ts.closeTransactionStore();
            this.parent.tv = null;
        }
        TransactionStore ts = new TransactionStore(this.parent, new Account(), true);
        this.filterVector = ts.buildCategoriesFromDates(this.filterFromDate, this.filterToDate, null, true);
        ts.closeTransactionStore();
        this.filterTotal = 0;
        int n = this.filterVector.size();
        for (int i = 0; i < n; ++i) {
            this.filterTotal += ((Integer)this.filterVector.elementAt(i)).intValue();
        }
        this.filterFlag = true;
        this.paintHeaderOnly = false;
        this.show("", false);
        if (this.cameFrom == 1) {
            return;
        }
        this.parent.tev = new TopExpensesView(this.parent, true, this.filterVector);
        this.parent.setContentView(this.parent.tev);
    }

    void processFind(String s, boolean filterFlag2, long ldFrom, long ldTo) {
        this.parent.busyWithProcess = true;
        this.parent.totalFound = 0;
        this.parent.findHt = new Hashtable();
        if (this.parent.tv != null) {
            this.parent.tv.ts.closeTransactionStore();
            this.parent.tv = null;
        }
        TransactionStore ts = new TransactionStore(this.parent, new Account(), true);
        Transaction t = null;
        ts.setToStart();
        int count = 0;
        while ((t = ts.readNextTransaction()) != null) {
            long tldate;
            if (++count == count / 1000 * 1000) {
                new TimedMessage(this.parent, count + " transactions read");
            }
            if (filterFlag2 && ((tldate = Utilities.longToDays(t.longDate)) < ldFrom || tldate > ldTo)) continue;
            if (t.splitFlag) {
                for (int i = 0; i < t.ss.size(); ++i) {
                    Split split = t.ss.getSplit(i);
                    if (!split.category.equals(s)) continue;
                    this.addFindIndex(t, split.amount, i);
                }
                continue;
            }
            if (!t.category.equals(s)) continue;
            this.addFindIndex(t, t.amount, -1);
        }
        ts.closeTransactionStore();
        this.parent.busyWithProcess = false;
        this.parent.fv = new FindView(this.parent, this.c.name, true, null);
        this.parent.setContentView(this.parent.fv);
    }

    void addFindIndex(Transaction t, int amount, int splitNumber) {
        LongIntId li1;
        int i;
        int p = 0;
        int n = this.parent.findHt.size();
        long tlong = Utilities.longToDays(t.longDate);
        if (this.parent.normalSortOrder) {
            p = n;
            for (i = 0; i < n; ++i) {
                li1 = (LongIntId)this.parent.findHt.get(new Integer(i));
                if (tlong < Utilities.longToDays(li1.lo)) continue;
                p = i;
                break;
            }
        } else {
            p = 0;
            for (i = n - 1; i >= 0; --i) {
                li1 = (LongIntId)this.parent.findHt.get(new Integer(i));
                long tlong2 = Utilities.longToDays(li1.lo);
                if (tlong < tlong2) continue;
                p = i + 1;
                break;
            }
        }
        if (p < n) {
            for (i = n - 1; i >= p; --i) {
                int j = i + 1;
                LongIntId li2 = (LongIntId)this.parent.findHt.get(new Integer(i));
                this.parent.findHt.put(new Integer(j), li2);
            }
        }
        long tlong2 = t.longDate;
        LongIntId li3 = new LongIntId(tlong2, splitNumber, t.id);
        this.parent.findHt.put(new Integer(p), li3);
        this.parent.totalFound += amount;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int j;
        String s = ae.getSource().toString();
        String s1 = s.substring((j = s.indexOf("[")) + 1, j + 5);
        if (s1.equals("menu")) {
            MenuItem mi = (MenuItem)ae.getSource();
            this.commandAction(mi.getLabel());
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        this.lastDragX = x;
        this.lastDragY = y;
        this.pointerExecute = false;
        this.alwaysDisplayMenu = false;
        this.timePointerOnScreen = System.currentTimeMillis();
        this.calculateCanvasMenuPosition = true;
        if (this.showCanvasMenu) {
            this.calculateCanvasMenuPosition = false;
            this.currentMenuPos = (y - this.menuHeightPos) / this.lineHeight;
            this.repaint();
            return;
        }
        if (y < this.lineHeight) {
            if (this.numItems == 0) {
                return;
            }
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.lineHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (y > this.height - this.lineHeight) {
            if (this.numItems == 0) {
                return;
            }
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
            this.repaint();
            return;
        }
        this.pointerExecute = true;
        int newPos = (y - this.lineHeight) / this.lineHeight;
        if (newPos >= this.numItems) {
            this.alwaysDisplayMenu = true;
            return;
        }
        this.currentPos = newPos;
        this.currentY = (this.currentPos + 1) * this.lineHeight;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        if (Math.abs(this.lastDragX - x) > 250) {
            this.commandAction("Switch Views");
            return;
        }
        if (this.dragScreen) {
            this.dragScreen = false;
            return;
        }
        if (this.showCanvasMenu) {
            this.showCanvasMenu = false;
            this.repaint();
            if (x < this.menuWidthPos || x > this.menuWidthPos + this.menuWidth || y < this.menuHeightPos || y > this.menuHeightPos + this.menuHeight) {
                this.setupCanvasMenu();
                this.showSwitchViewsMenu = false;
                return;
            }
            int k = (y - this.menuHeightPos) / this.lineHeight + this.startMenuPos;
            if (this.showSwitchViewsMenu) {
                this.showSwitchViewsMenu = false;
                this.processSwitchViewsMenu(k);
            } else {
                this.processMenuCommand(k);
            }
            return;
        }
        this.timePointerOnScreen = System.currentTimeMillis() - this.timePointerOnScreen;
        if (this.timePointerOnScreen > (long)this.parent.longTapDelay) {
            if (y < this.lineHeight) {
                this.startPos = 0;
                this.currentPos = 0;
                this.currentY = this.lineHeight;
                this.repaint();
                return;
            }
            if (y > this.height - this.lineHeight) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                this.repaint();
                return;
            }
        }
        if (this.alwaysDisplayMenu || this.timePointerOnScreen > (long)this.parent.longTapDelay) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.repaint();
            } else {
                this.displayPopupMenu();
            }
            return;
        }
        if (!this.pointerExecute) {
            return;
        }
        int newPos = (y - this.lineHeight) / this.lineHeight;
        if (newPos == this.currentPos || newPos >= this.numItems) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.repaint();
            } else {
                this.displayPopupMenu();
            }
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        int scroll = (y - this.lastDragY) / this.lineHeight;
        if (scroll == 0) {
            return;
        }
        if (scroll > 0) {
            if (this.showCanvasMenu) {
                this.startMenuPos -= scroll;
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
                this.currentMenuPos += scroll;
                if (this.currentMenuPos > Math.min(this.numMenuItems, this.numItemsPage) - 1) {
                    this.currentMenuPos = Math.min(this.numMenuItems, this.numItemsPage) - 1;
                }
            } else {
                this.startPos -= scroll;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                this.currentPos += scroll;
                if (this.currentPos > Math.min(this.numItems, this.numItemsPage) - 1) {
                    this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                }
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
        }
        if (scroll < 0) {
            if (this.showCanvasMenu) {
                this.startMenuPos -= scroll;
                if (this.startMenuPos + this.numItemsPage > this.numMenuItems - 1) {
                    this.startMenuPos = this.numMenuItems - this.numItemsPage;
                }
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
                this.currentMenuPos += scroll;
                if (this.currentMenuPos < 0) {
                    this.currentMenuPos = 0;
                }
            } else {
                this.startPos -= scroll;
                if (this.startPos + this.currentPos > this.numItems - 1) {
                    this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                    this.startPos = this.numItems - 1 - this.currentPos;
                    this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                }
                this.currentPos += scroll;
                if (this.currentPos < 0) {
                    this.currentPos = 0;
                }
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
        }
        this.lastDragY = y;
        this.repaint();
        this.dragScreen = true;
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        int notches = mwe.getWheelRotation();
        if (notches == 0) {
            return;
        }
        if (notches > 0) {
            for (int i = 0; i < notches; ++i) {
                this.drawDown();
            }
        } else {
            notches = -notches;
            for (int i = 0; i < notches; ++i) {
                this.drawUp();
            }
        }
    }

    void displayPopupMenu() {
        if (this.showingPopupMenu) {
            this.showingPopupMenu = false;
            return;
        }
        PopupMenu pm = new PopupMenu();
        MenuItem miHome = new MenuItem("Home");
        MenuItem miNew = new MenuItem("New");
        MenuItem miEdit = new MenuItem("Edit");
        MenuItem miDelete = new MenuItem("Delete");
        MenuItem miShow = new MenuItem("Show");
        MenuItem miSwitchViews = new MenuItem("Switch Views");
        MenuItem miFilter = new MenuItem("Filter");
        MenuItem miFind = new MenuItem("Find");
        MenuItem miTopExpenses = new MenuItem("Top Expenses");
        MenuItem miExit = new MenuItem("Exit");
        miHome.addActionListener(this);
        miNew.addActionListener(this);
        miEdit.addActionListener(this);
        miDelete.addActionListener(this);
        miShow.addActionListener(this);
        miSwitchViews.addActionListener(this);
        miFilter.addActionListener(this);
        miFind.addActionListener(this);
        miTopExpenses.addActionListener(this);
        miExit.addActionListener(this);
        pm.add(miHome);
        pm.add(miNew);
        pm.add(miEdit);
        pm.add(miDelete);
        pm.add(miShow);
        pm.add(miSwitchViews);
        pm.add(miFilter);
        pm.add(miFind);
        pm.add(miTopExpenses);
        pm.add(miExit);
        this.add(pm);
        int x = 0;
        int y = 0;
        if (this.point == null) {
            pm.show(this, x, y);
        } else {
            Point move = this.movePopup(11, x, y);
            pm.show(this, move.x + this.point.x, move.y + this.point.y);
        }
        this.showingPopupMenu = true;
    }

    void displaySwitchViewsMenu() {
        if (this.showingPopupMenu) {
            this.showingPopupMenu = false;
            return;
        }
        PopupMenu pm = new PopupMenu();
        MenuItem miAccounts = new MenuItem("Accounts");
        MenuItem miTransactions = new MenuItem("Transactions");
        MenuItem miCategories = new MenuItem("Categories");
        MenuItem miStandingOrders = new MenuItem("Standing Orders");
        MenuItem miInvestments = new MenuItem("Investments");
        MenuItem miCurrencies = new MenuItem("Currencies");
        miAccounts.addActionListener(this);
        miTransactions.addActionListener(this);
        miCategories.addActionListener(this);
        miStandingOrders.addActionListener(this);
        miInvestments.addActionListener(this);
        miCurrencies.addActionListener(this);
        pm.add(miAccounts);
        pm.add(miTransactions);
        pm.add(miCategories);
        pm.add(miStandingOrders);
        pm.add(miInvestments);
        pm.add(miCurrencies);
        this.add(pm);
        int x = 0;
        int y = 0;
        if (this.point == null) {
            pm.show(this, x, y);
        } else {
            Point move = this.movePopup(7, x, y);
            pm.show(this, move.x + this.point.x, move.y + this.point.y);
        }
        this.showingPopupMenu = true;
    }

    Point movePopup(int n, int x, int y) {
        int popupHeight = n * this.lineHeight * 4 / 3;
        if (this.parent.useCanvasMenu && x + this.point.x + this.menuWidth > this.width) {
            x = this.width - this.menuWidth - this.point.x;
        }
        if (y + this.point.y + popupHeight > this.height) {
            y = this.height - popupHeight - this.point.y;
        }
        Point move = new Point(x, y);
        return move;
    }

    void setupCanvasMenu() {
        this.startMenuPos = 0;
        this.currentMenuPos = 0;
        this.canvasMenu = new Vector(10);
        this.canvasMenu.addElement("Home");
        this.canvasMenu.addElement("New");
        this.canvasMenu.addElement("Edit");
        this.canvasMenu.addElement("Delete");
        this.canvasMenu.addElement("Show");
        this.canvasMenu.addElement("Switch Views");
        this.canvasMenu.addElement("Filter");
        this.canvasMenu.addElement("Find");
        this.canvasMenu.addElement("Top Expenses");
        this.canvasMenu.addElement("Exit");
        this.menuWidth = this.fm.stringWidth("Top Expenses") + 6;
    }

    void setupSwitchViewsMenu() {
        this.startMenuPos = 0;
        this.currentMenuPos = 0;
        this.canvasMenu = new Vector(6);
        this.canvasMenu.addElement("Accounts");
        this.canvasMenu.addElement("Transactions");
        this.canvasMenu.addElement("Categories");
        this.canvasMenu.addElement("Standing Orders");
        this.canvasMenu.addElement("Investments");
        this.canvasMenu.addElement("Currencies");
        this.menuWidth = this.fm.stringWidth("Standing Orders") + 6;
    }

    void displayCanvasMenu() {
        this.numMenuItems = this.canvasMenu.size();
        this.menuWidthPos = (this.width - this.menuWidth) / 2;
        if (this.menuWidthPos < 0) {
            this.menuWidthPos = 0;
        }
        this.menuHeightPos = (this.height - this.lineHeight * 2 - this.numMenuItems * this.lineHeight) / 2;
        if (this.menuHeightPos < this.lineHeight) {
            this.menuHeightPos = this.lineHeight;
        }
        this.menuHeight = Math.min(this.height - this.lineHeight * 2, this.numMenuItems * this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorMessage));
        this.g1.fillRect(this.menuWidthPos, this.menuHeightPos, this.menuWidth, this.menuHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        for (int i = 0; i < this.numItemsPage && i + this.startMenuPos <= this.numMenuItems - 1; ++i) {
            int vpos = i * this.lineHeight + this.lineHeight + this.menuHeightPos - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
            if (i == this.currentMenuPos) {
                this.g1.setColor(new Color(this.parent.colorCursor));
                this.g1.fillRect(this.menuWidthPos, this.lineHeight * i + this.menuHeightPos, this.menuWidth, this.lineHeight);
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            this.g1.drawString((String)this.canvasMenu.elementAt(i + this.startMenuPos), this.menuWidthPos + 3, vpos);
        }
    }

    void processMenuCommand(int k) {
        this.repaint();
        this.commandAction((String)this.canvasMenu.elementAt(k));
    }

    void processSwitchViewsMenu(int k) {
        this.setupCanvasMenu();
        switch (k) {
            case 0: {
                this.commandAction("Accounts");
                break;
            }
            case 1: {
                this.commandAction("Transactions");
                break;
            }
            case 2: {
                this.commandAction("Categories");
                break;
            }
            case 3: {
                this.commandAction("Standing Orders");
                break;
            }
            case 4: {
                this.commandAction("Investments");
                break;
            }
            case 5: {
                this.commandAction("Currencies");
            }
        }
    }

    void runThread() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        if (this.runMode == 1) {
            this.updateCategoryName(this.oldC.name, this.c1.name, true);
        }
        if (this.runMode == 2) {
            this.processFind(this.c1.name, this.filterFlag, Utilities.longToDays(this.filterFromDate.getTime()), Utilities.longToDays(this.filterToDate.getTime()));
        }
        if (this.runMode == 3) {
            this.processFilter2();
        }
        if (this.runMode == 6) {
            this.deleteCategoryName();
        }
    }

    void show(String s1, boolean paintHeaderOnly1) {
        String s = s1;
        this.paintHeaderOnly = paintHeaderOnly1;
        this.msg = s;
        this.repaint();
    }

    public void commandAction(String cmd) {
        this.showingPopupMenu = false;
        if (this.parent.saveStateOnHome) {
            this.parent.ixs.selfDestruct();
        }
        if (cmd.equals("Exit")) {
            this.parent.finishAndQuit();
            return;
        }
        if (cmd.equals("Home")) {
            if (this.parent.av == null) {
                this.parent.av = new AccountView(this.parent);
            }
            this.parent.setContentView(this.parent.av);
            return;
        }
        if (cmd.equals("New")) {
            this.parent.cf = new CategoryForm(this.parent, new Category(), false, "New");
            return;
        }
        if (cmd.equals("Edit")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to edit", 2000).show();
                return;
            }
            this.oldC = new Category();
            this.oldC.clone(this.c);
            this.parent.cf = new CategoryForm(this.parent, this.c, false, "Edit");
            return;
        }
        if (cmd.equals("Delete")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to delete", 2000).show();
                return;
            }
            this.oldC = new Category();
            this.oldC.clone(this.c);
            this.parent.cf = new CategoryForm(this.parent, this.c, false, "Delete");
            return;
        }
        if (cmd.equals("Show")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to show", 2000).show();
                return;
            }
            this.parent.gsf = new GenericShowForm(this.parent, this.c, 1);
            this.parent.setContentView(this.parent.gsf);
            return;
        }
        if (cmd.equals("Find")) {
            this.c1 = new Category();
            this.c1.name = this.c.name;
            this.runMode = 2;
            this.run();
            return;
        }
        if (cmd.equals("Filter")) {
            this.cameFrom = 1;
            new FilterForm(this.parent);
            return;
        }
        if (cmd.equals("Switch Views")) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.showSwitchViewsMenu = true;
                this.setupSwitchViewsMenu();
                this.repaint();
                return;
            }
            this.displaySwitchViewsMenu();
            return;
        }
        if (cmd.equals("Top Expenses")) {
            this.cameFrom = 2;
            new FilterForm(this.parent);
            return;
        }
        if (cmd.equals("Accounts") || cmd.equals("Home")) {
            if (this.parent.av == null) {
                this.parent.av = new AccountView(this.parent);
            }
            this.parent.setContentView(this.parent.av);
            this.repaint();
            return;
        }
        if (cmd.equals("Transactions")) {
            if (this.parent.tv == null) {
                Toast.makeText(this.parent, "No account selected", 2000).show();
            } else {
                this.parent.setContentView(this.parent.tv);
            }
            this.repaint();
            return;
        }
        if (cmd.equals("Categories")) {
            Toast.makeText(this.parent, "Already in Categories View", 2000).show();
            this.repaint();
            return;
        }
        if (cmd.equals("Standing Orders")) {
            if (this.parent.sov == null) {
                this.parent.sov = new StandingOrderView(this.parent);
            }
            this.parent.setContentView(this.parent.sov);
            this.repaint();
            return;
        }
        if (cmd.equals("Investments")) {
            if (this.parent.iv == null) {
                this.parent.iv = new InvestmentView(this.parent);
            }
            this.parent.setContentView(this.parent.iv);
            this.repaint();
            return;
        }
        if (cmd.equals("Currencies")) {
            if (this.parent.ccyv == null) {
                this.parent.ccyv = new CurrencyView(this.parent);
            }
            this.parent.setContentView(this.parent.ccyv);
            this.repaint();
            return;
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int keyCode = keyEvent.getKeyCode();
        switch (keyCode) {
            case 33: 
            case 37: {
                if (this.startPos == 0) {
                    this.currentPos = 0;
                    this.currentY = this.lineHeight;
                    break;
                }
                this.startPos -= this.numItemsPage;
                if (this.startPos >= 0) break;
                this.startPos = 0;
                break;
            }
            case 34: 
            case 39: {
                this.startPos += this.numItemsPage;
                if (this.startPos + this.currentPos <= this.numItems - 1) break;
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                break;
            }
            case 38: {
                this.drawUp();
                break;
            }
            case 40: {
                this.drawDown();
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int keyCode = keyEvent.getKeyCode();
        switch (keyCode) {
            case 36: {
                this.startPos = 0;
                this.currentPos = 0;
                this.currentY = this.lineHeight;
                break;
            }
            case 35: {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                break;
            }
            case 10: 
            case 525: {
                if (this.showCanvasMenu) {
                    this.showCanvasMenu = false;
                    if (this.showSwitchViewsMenu) {
                        this.showSwitchViewsMenu = false;
                        this.processSwitchViewsMenu(this.startMenuPos + this.currentMenuPos);
                        break;
                    }
                    this.processMenuCommand(this.startMenuPos + this.currentMenuPos);
                    break;
                }
                if (this.numItems == 0) break;
                if (this.parent.useCanvasMenu) {
                    this.showCanvasMenu = true;
                    break;
                }
                if (keyCode != 525) break;
                this.displayPopupMenu();
                break;
            }
            case 27: {
                this.parent.onBackPressed();
                break;
            }
            case 78: {
                this.commandAction("New");
                break;
            }
            case 69: {
                this.commandAction("Edit");
                break;
            }
            case 68: {
                this.commandAction("Delete");
                break;
            }
            case 70: {
                this.commandAction("Find");
                break;
            }
            case 84: {
                this.commandAction("Top Expenses");
                break;
            }
            case 83: {
                this.commandAction("Show");
                break;
            }
            case 72: {
                this.commandAction("Home");
                break;
            }
            case 86: {
                this.commandAction("Switch Views");
                break;
            }
            case 75: {
                this.parent.gsf = new GenericShowForm(this.parent, null, 9);
                this.parent.setContentView(this.parent.gsf);
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

