/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.freepoc.Jabp4.Category;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.NameId;
import org.freepoc.Jabp4.RecordStore;

public class CategoryStore {
    RecordStore rs;
    Jabp parent;
    Hashtable ht;

    public CategoryStore(Jabp context, boolean fastDiskAccess) {
        this.parent = context;
        this.ht = this.parent.categoryHt;
        this.openCategoryStore(fastDiskAccess);
    }

    void openCategoryStore(boolean fastDiskAccess) {
        this.rs = new RecordStore(this.parent, "Categories", fastDiskAccess);
    }

    void closeCategoryStore() {
        if (this.rs != null) {
            this.rs.closeRecordStore();
        }
    }

    int getNumCategories() {
        if (this.rs == null) {
            return 0;
        }
        return this.rs.getNumRecords();
    }

    byte[] toByteArray(Category c) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeUTF(c.name);
            dos.writeUTF(c.description);
            dos.writeInt(c.open);
            dos.writeInt(c.current);
            dos.close();
        }
        catch (IOException ie) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    Category fromByteArray(byte[] bytes) {
        Category c = new Category();
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            c.name = dis.readUTF();
            c.description = dis.readUTF();
            c.open = dis.readInt();
            c.current = dis.readInt();
            dis.close();
        }
        catch (IOException ie) {
            System.err.println(ie + " cs4a");
        }
        return c;
    }

    Category getCategory(int id) {
        Category c = new Category();
        byte[] bytes = this.rs.getRecord(id);
        c = this.fromByteArray(bytes);
        c.id = id;
        return c;
    }

    void setToStart() {
        this.rs.setToStart();
    }

    Category readNextCategory() {
        Category c = new Category();
        byte[] bytes = this.rs.readRecord();
        if (bytes == null) {
            return null;
        }
        int id = this.rs.getCurrentFilePosition() - bytes.length - 5;
        c = this.fromByteArray(bytes);
        c.id = id;
        return c;
    }

    Category getCategoryFromIndex(int i) {
        int id = ((NameId)this.ht.get((Object)new Integer((int)i))).id;
        return this.getCategory(id);
    }

    Category getCategoryFromName(String string) {
        int n = this.getNumCategories();
        for (int i = 0; i < n; ++i) {
            String s1 = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!s1.equals(string)) continue;
            int id = ((NameId)this.ht.get((Object)new Integer((int)i))).id;
            return this.getCategory(id);
        }
        Category c = new Category();
        c.name = string;
        c.id = this.saveNewCategory(c);
        if (this.parent.cv != null) {
            ++this.parent.cv.numItems;
        }
        return c;
    }

    boolean doesCategoryNameExist(String name) {
        int n = this.getNumCategories();
        for (int i = 0; i < n; ++i) {
            String s1 = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!s1.equals(name)) continue;
            return true;
        }
        return false;
    }

    void deleteCategory(Category c) {
        if (this.rs == null) {
            return;
        }
        this.rs.deleteRecord(c.id);
    }

    int saveNewCategory(Category c) {
        if (this.rs == null) {
            return 0;
        }
        c.id = this.rs.getNextRecordID();
        byte[] bytes = this.toByteArray(c);
        this.rs.addRecord(bytes, 0, bytes.length);
        this.addIndex(c);
        return c.id;
    }

    void saveExistingCategory(Category c) {
        if (this.rs == null) {
            return;
        }
        byte[] bytes = this.toByteArray(c);
        this.rs.setRecord(c.id, bytes, 0, bytes.length);
    }

    int lookUpId(Category c) {
        c.id = 0;
        int n = this.ht.size();
        for (int i = 0; i < n; ++i) {
            String string = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!string.equals(c.name)) continue;
            c.id = ((NameId)this.ht.get((Object)new Integer((int)i))).id;
            break;
        }
        return c.id;
    }

    int lookUpIndex(Category c) {
        int n = this.ht.size();
        int j = -1;
        for (int i = 0; i < n; ++i) {
            String string = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!string.equals(c.name)) continue;
            j = i;
            break;
        }
        return j;
    }

    int lookUpIndex(String name) {
        int n = this.ht.size();
        int j = -1;
        for (int i = 0; i < n; ++i) {
            String string = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!string.equals(name)) continue;
            j = i;
            break;
        }
        return j;
    }

    void deleteIndex(int index) {
        int n = this.ht.size();
        for (int i = index; i < n - 1; ++i) {
            int j = i + 1;
            NameId nameId = (NameId)this.ht.get(new Integer(j));
            this.ht.put(new Integer(i), nameId);
        }
        this.ht.remove(new Integer(n - 1));
    }

    void deleteAllIndices() {
        int n = this.ht.size();
        for (int i = 0; i < n; ++i) {
            this.ht.remove(new Integer(i));
        }
    }

    void addIndex(Category c) {
        int i;
        int n;
        int p = n = this.ht.size();
        for (i = 0; i < n; ++i) {
            NameId nameId = (NameId)this.ht.get(new Integer(i));
            if (c.name.compareTo(nameId.name) >= 0) continue;
            p = i;
            break;
        }
        if (p < n) {
            for (i = n - 1; i >= p; --i) {
                int j = i + 1;
                NameId nameId = (NameId)this.ht.get(new Integer(i));
                this.ht.put(new Integer(j), nameId);
            }
        }
        NameId nameId = new NameId(c.name, c.id);
        this.ht.put(new Integer(p), nameId);
    }

    void setUpCategories() {
        Category c = new Category();
        c.name = "Bills";
        this.saveNewCategory(c);
        c.name = "Car Expenses";
        this.saveNewCategory(c);
        c.name = "Entertainment";
        this.saveNewCategory(c);
        c.name = "Food";
        this.saveNewCategory(c);
        c.name = "Gifts";
        this.saveNewCategory(c);
        c.name = "Holiday Expenses";
        this.saveNewCategory(c);
        c.name = "Household";
        this.saveNewCategory(c);
        c.name = "Insurance";
        this.saveNewCategory(c);
        c.name = "Mortgage";
        this.saveNewCategory(c);
        c.name = "Salary";
        this.saveNewCategory(c);
        c.name = "Travel";
        this.saveNewCategory(c);
    }

    int getSize() {
        return this.rs.getSize();
    }
}

