/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.CheckboxGroup;
import java.awt.Component;
import javax.swing.JTextField;
import org.freepoc.Jabp4.Category;
import org.freepoc.Jabp4.CategoryView;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Utilities;

public class CategoryForm
extends Component {
    Jabp parent;
    Category c;
    boolean fromTransactionForm = false;
    boolean warningMessageDisplayed = false;

    public CategoryForm(Jabp context, Category c1, boolean fromTransactionForm1, String action) {
        this.parent = context;
        this.c = c1;
        this.parent.lastUsedScreen = 12;
        this.fromTransactionForm = fromTransactionForm1;
        if (action.equals("New")) {
            this.createCategory(new Category());
        }
        if (action.equals("Edit")) {
            this.updateCategory(this.c);
        }
        if (action.equals("Delete")) {
            this.deleteCategory(this.c);
        }
    }

    void createCategory(Category c) {
        DialogManager dm = new DialogManager(this.parent, "New category");
        JTextField name = dm.addJTextField("Name", c.name);
        JTextField description = dm.addJTextField("Description", c.description);
        JTextField tfOpen = dm.addJTextField("Opening balance", "" + Math.abs(c.open));
        boolean state = false;
        if (c.open > 0) {
            state = true;
        }
        CheckboxGroup debitOrCredit = dm.addCheckboxGroup();
        dm.addCheckboxItem("DR/CR", "DR", !state, "CR", state, debitOrCredit);
        dm.addButton("Cancel");
        dm.addButton("Create");
        dm.centerShow();
        if (!dm.checkButtons()) {
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            dm.dispose();
            return;
        }
        String s = dm.getUserText(name).trim();
        if (s.equals("")) {
            Toast.makeText(this.parent, "Blank category name", 2000).show();
            dm.dispose();
            this.createCategory(c);
            return;
        }
        c.name = s;
        if (this.parent.cv == null) {
            this.parent.cv = new CategoryView(this.parent);
        }
        if (this.parent.cv.cs.lookUpId(c) != 0) {
            Toast.makeText(this.parent, s + " already exists", 2000).show();
            dm.dispose();
            this.createCategory(c);
            return;
        }
        c.description = dm.getUserText(description).trim();
        c.open = this.parent.numericEntry ? Utilities.stringToNumber(dm.getUserText(tfOpen), 0, true, this.parent.isEuropeanNumberFormat) : Utilities.expressionToNumber(dm.getUserText(tfOpen), this.parent.isEuropeanNumberFormat);
        if (dm.getSelectedCheckbox(debitOrCredit).getLabel().equals("DR")) {
            c.open = -c.open;
        }
        c.current = c.open;
        this.parent.cv.newCategory(c);
        Toast.makeText(this.parent, c.name + " created", 1000).show();
        dm.dispose();
        if (this.fromTransactionForm) {
            this.parent.lastCategory = c.name;
        }
    }

    void updateCategory(Category c) {
        DialogManager dm = new DialogManager(this.parent, "Edit category");
        JTextField name = dm.addJTextField("Name", c.name);
        JTextField description = dm.addJTextField("Description", c.description);
        JTextField tfOpen = dm.addJTextField("Opening balance", "" + Math.abs(c.open));
        boolean state = false;
        if (c.open > 0) {
            state = true;
        }
        CheckboxGroup debitOrCredit = dm.addCheckboxGroup();
        dm.addCheckboxItem("DR/CR", "DR", !state, "CR", state, debitOrCredit);
        dm.addButton("Cancel");
        dm.addButton("Update");
        dm.centerShow();
        if (!dm.checkButtons()) {
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            dm.dispose();
            return;
        }
        String oldName = c.name;
        String newName = dm.getUserText(name).trim();
        if (newName.equals("")) {
            Toast.makeText(this.parent, "Blank category name", 2000).show();
            dm.dispose();
            this.updateCategory(c);
            return;
        }
        c.name = newName;
        int k = c.id;
        if (!oldName.equals(newName) && this.parent.cv.cs.lookUpId(c) != 0) {
            Toast.makeText(this.parent, newName + " already exists", 2000).show();
            c.name = oldName;
            dm.dispose();
            this.updateCategory(c);
            return;
        }
        c.id = k;
        c.description = dm.getUserText(description).trim();
        int i = c.open;
        c.open = this.parent.numericEntry ? Utilities.stringToNumber(dm.getUserText(tfOpen), 0, true, this.parent.isEuropeanNumberFormat) : Utilities.expressionToNumber(dm.getUserText(tfOpen), this.parent.isEuropeanNumberFormat);
        if (dm.getSelectedCheckbox(debitOrCredit).getLabel().equals("DR")) {
            c.open = -c.open;
        }
        c.current += c.open - i;
        this.parent.cv.editCategory(c);
        Toast.makeText(this.parent, c.name + " updated", 1000).show();
        dm.dispose();
    }

    void deleteCategory(Category c) {
        DialogManager dm = new DialogManager(this.parent, "Delete category");
        JTextField name = dm.addJTextField("Name", c.name);
        JTextField description = dm.addJTextField("Description", c.description);
        JTextField tfOpen = dm.addJTextField("Opening balance", "" + Math.abs(c.open));
        boolean state = false;
        if (c.open > 0) {
            state = true;
        }
        CheckboxGroup debitOrCredit = dm.addCheckboxGroup();
        dm.addCheckboxItem("DR/CR", "DR", !state, "CR", state, debitOrCredit);
        dm.addButton("Cancel");
        dm.addButton("Delete");
        dm.centerShow();
        if (!dm.checkButtons()) {
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            dm.dispose();
            return;
        }
        if (c.name.equals("None")) {
            Toast.makeText(this.parent, "Cannot delete category None", 2000).show();
            this.parent.setContentView(this.parent.cv);
            return;
        }
        if (this.warningMessageDisplayed) {
            this.parent.cv.deleteCategory(c);
            Toast.makeText(this.parent, c.name + " deleted", 1000).show();
        } else {
            Toast.makeText(this.parent, "References to " + c.name + "\nwill be replaced by 'None'\nClick Delete to proceed", 2000).show();
            this.warningMessageDisplayed = true;
            this.deleteCategory(c);
        }
        dm.dispose();
    }
}

