/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.oauth.DbxCredential;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.UploadErrorException;
import com.dropbox.core.v2.files.WriteMode;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.freepoc.Jabp4.Encrypt;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.RecordStore;
import org.freepoc.Jabp4.SyncStore;

public class BackgroundSyncWorker {
    Jabp parent;
    RecordStore rs;
    SyncStore sync;
    DbxClientV2 client;
    DbxCredential dbxCredential;
    String serializedCredential = "";
    String root = "";
    String internalRoot = "";
    String directory = "";

    public BackgroundSyncWorker(Jabp context) {
        this.parent = context;
    }

    void doWork() {
        System.out.println("Starting background sync process");
        this.setUpDropbox();
        this.dropboxDownloadFile("Jabp.sync");
    }

    public void dropboxDownloadFile(final String fileName) {
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                DbxDownloader<FileMetadata> downloader = null;
                try {
                    downloader = BackgroundSyncWorker.this.client.files().download("/" + fileName);
                }
                catch (DbxException e) {
                    System.out.println(e);
                    return;
                }
                try {
                    FileOutputStream out = new FileOutputStream(BackgroundSyncWorker.this.root + BackgroundSyncWorker.this.directory + fileName);
                    downloader.download(out);
                    out.close();
                    BackgroundSyncWorker.this.uploadSyncRecordsToJabpLite();
                }
                catch (DbxException ex) {
                    System.out.println(ex);
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
        });
        thread2.start();
    }

    void uploadSyncRecordsToJabpLite() {
        this.getRoot();
        boolean hasRecordsToSync = false;
        this.sync = new SyncStore(this.parent, true);
        if (this.sync.getNumSyncRecords() > 0) {
            System.out.println(this.sync.getNumSyncRecords() + " records to sync");
            hasRecordsToSync = true;
            File fc = null;
            DataOutputStream dos = null;
            try {
                byte[] bytes;
                fc = new File(this.root + this.directory + "Jabp.sync");
                dos = fc.length() > 0L ? new DataOutputStream(new FileOutputStream(fc, true)) : new DataOutputStream(new FileOutputStream(fc));
                while ((bytes = this.sync.readNextSyncRecord()) != null) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                    DataInputStream dis = new DataInputStream(bais);
                    int type = dis.readInt();
                    int length = dis.readInt();
                    byte[] b = new byte[length];
                    dis.read(b, 0, length);
                    dis.close();
                    bais.close();
                    Encrypt.encrypt(b);
                    dos.writeInt(type);
                    dos.writeInt(length);
                    dos.write(b, 0, b.length);
                }
                dos.close();
            }
            catch (IOException ie) {
                System.out.println("Error: " + ie.toString());
                System.exit(0);
            }
        }
        this.sync.closeSyncStore();
        if (hasRecordsToSync) {
            this.dropboxUploadFile(new File(this.root + this.directory + "Jabp.sync"));
        } else {
            System.out.println("No records to sync - finishing");
            System.exit(0);
        }
    }

    public void dropboxUploadFile(final File file) {
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                String fileName = file.getName();
                System.out.println("Uploading " + fileName + " to Dropbox");
                try (FileInputStream in = new FileInputStream(BackgroundSyncWorker.this.root + BackgroundSyncWorker.this.directory + fileName);){
                    FileMetadata metadata = (FileMetadata)BackgroundSyncWorker.this.client.files().uploadBuilder("/" + fileName).withMode(WriteMode.OVERWRITE).uploadAndFinish(in);
                    System.out.println("Upload of " + fileName + " successful");
                }
                catch (FileNotFoundException e) {
                    System.out.println(e.toString());
                    System.exit(0);
                }
                catch (IOException e) {
                    System.out.println(e.toString());
                    System.exit(0);
                }
                catch (UploadErrorException e) {
                    System.out.println(e.toString());
                    System.exit(0);
                }
                catch (DbxException e) {
                    System.out.println(e.toString());
                    System.exit(0);
                }
                if (fileName.contains("Jabp.sync")) {
                    BackgroundSyncWorker.this.sync.deleteSyncStore();
                    System.out.println("Finished");
                    System.exit(0);
                }
            }
        });
        thread2.start();
    }

    void setUpDropbox() {
        this.serializedCredential = this.parent.prefs.getProperty("serializedCredential", "");
        if (this.serializedCredential.equals("")) {
            System.out.println("Dropbox is not set up");
            System.exit(0);
        } else {
            try {
                this.dbxCredential = DbxCredential.Reader.readFully(this.serializedCredential);
            }
            catch (JsonReadException e) {
                System.out.println("Error reading Dropbox credential");
                System.exit(0);
            }
        }
        DbxRequestConfig config = DbxRequestConfig.newBuilder("Jabp_client").build();
        this.client = new DbxClientV2(config, this.dbxCredential);
    }

    void fromByteArray(byte[] bytes) {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            this.root = dis.readUTF();
            this.directory = dis.readUTF();
            dis.close();
        }
        catch (IOException ie) {
            System.err.println(ie + " dir3");
        }
    }

    void getRoot() {
        this.rs = new RecordStore(this.parent, "Directory", true);
        if (this.rs.getNumRecords() == 0) {
            this.root = "";
            this.internalRoot = "";
            this.directory = this.parent.getDir("Backups/", 0);
        } else {
            byte[] bytes = this.rs.getRecord(0);
            this.fromByteArray(bytes);
            File f = new File(this.directory);
            if (f == null || !f.canRead()) {
                this.directory = this.parent.getDir("Backups/", 0);
            }
        }
        this.rs.closeRecordStore();
        this.rs = null;
    }
}

