/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.net.URI;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.AccountBalancesByMonthForm;
import org.freepoc.Jabp4.AccountForm;
import org.freepoc.Jabp4.AccountStore;
import org.freepoc.Jabp4.Category;
import org.freepoc.Jabp4.CategoryStore;
import org.freepoc.Jabp4.CategoryView;
import org.freepoc.Jabp4.CurrencyView;
import org.freepoc.Jabp4.FindForm;
import org.freepoc.Jabp4.FutureBalanceForm;
import org.freepoc.Jabp4.GenericShowForm;
import org.freepoc.Jabp4.GraphForm;
import org.freepoc.Jabp4.ImportExportForm;
import org.freepoc.Jabp4.InvestmentView;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.NetWorthView;
import org.freepoc.Jabp4.PasswordForm;
import org.freepoc.Jabp4.PreferenceForm;
import org.freepoc.Jabp4.PurgeForm;
import org.freepoc.Jabp4.ShowProgressForm;
import org.freepoc.Jabp4.Split;
import org.freepoc.Jabp4.StandingOrder;
import org.freepoc.Jabp4.StandingOrderStore;
import org.freepoc.Jabp4.StandingOrderView;
import org.freepoc.Jabp4.SyncStore;
import org.freepoc.Jabp4.TimedMessage;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.TransactionStore;
import org.freepoc.Jabp4.TransactionView;
import org.freepoc.Jabp4.Utilities;

class AccountView
extends Canvas
implements ActionListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
Runnable {
    Jabp parent;
    AccountStore as;
    Account a;
    Account a1;
    Account oldA;
    String msg = "";
    Vector canvasMenu;
    Thread thread;
    Font font;
    FontMetrics fm;
    Point point;
    Graphics g1;
    Image image;
    TimedMessage tm;
    int width;
    int height;
    int numItems;
    int totalOpen;
    int totalCurrent;
    int totalToday;
    int totalReconciled;
    int minAccountAmount;
    int maxAccountAmount;
    int fontHeight;
    int lineHeight;
    int numberWidth;
    int numItemsPage;
    int spacing;
    int minAccountWidth;
    int accountDisplayType;
    int accountWidth;
    int openPosition;
    int currentPosition;
    int reconciledPosition;
    int todayPosition;
    int currentX;
    int currentY;
    int currentPos;
    int startPos;
    int runMode;
    int previousPos;
    int oldX;
    int oldY;
    int lastDragX;
    int lastDragY;
    int currentMenuPos;
    int menuHeightPos;
    int menuWidthPos;
    int menuWidth;
    int menuHeight;
    int startMenuPos;
    int numMenuItems;
    int frameWidth;
    int frameHeight;
    int frameWidthSurround;
    int frameHeightSurround;
    long timePointerOnScreen;
    boolean pointerExecute;
    boolean start;
    boolean showExtraOptionsMenu = false;
    boolean showSwitchViewsMenu = false;
    boolean alwaysDisplayMenu = false;
    boolean paintWholeScreen = true;
    boolean paintHeaderOnly = false;
    boolean showCanvasMenu = false;
    boolean showingPopupMenu = false;
    boolean calculateCanvasMenuPosition = true;
    boolean dragScreen = false;

    AccountView(Jabp context) {
        this.parent = context;
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.as = new AccountStore(this.parent, false);
        this.parent.dataIntegrityCheck("Accounts", this.as.getNumAccounts(), this.parent.accountHt.size());
        if (this.as.getNumAccounts() == 0) {
            this.as.setUpAccounts();
        }
        this.buildIndexExcludingInactiveAccounts();
        this.numItems = this.as.ht2.size();
        this.font = this.parent.font;
        this.setFont(this.font);
        this.fm = this.getFontMetrics(this.font);
        this.lineHeight = this.parent.fontHeight + this.parent.lineSpacing * 2;
        this.setTotals();
        this.currentX = 0;
        this.currentY = this.lineHeight;
        this.currentPos = 0;
        this.startPos = 0;
        this.setupCanvasMenu();
        this.runMode = 0;
        this.start = true;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.checkIfRecordsToSync();
    }

    void checkIfRecordsToSync() {
        if (this.parent.syncStatus.equals("[s]")) {
            JDialog dialog = new JDialog((Frame)this.parent, "Records to sync");
            dialog.setLayout(new BorderLayout());
            JLabel messageLabel = new JLabel("Records are ready to import from JabpLite");
            messageLabel.setHorizontalAlignment(0);
            messageLabel.setVerticalAlignment(0);
            JPanel messagePanel = new JPanel(new GridBagLayout());
            messagePanel.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 30));
            messagePanel.add(messageLabel);
            JPanel buttonPanel = new JPanel(new FlowLayout(1));
            JButton deferButton = new JButton("Defer");
            JButton importButton = new JButton("Import");
            buttonPanel.add(deferButton);
            buttonPanel.add(importButton);
            Box verticalBox = Box.createVerticalBox();
            verticalBox.add(Box.createVerticalStrut(50));
            verticalBox.add(messagePanel);
            verticalBox.add(Box.createVerticalStrut(30));
            verticalBox.add(buttonPanel);
            dialog.add((Component)verticalBox, "Center");
            dialog.pack();
            dialog.setLocationRelativeTo(this.parent);
            deferButton.addActionListener(e -> dialog.setVisible(false));
            importButton.addActionListener(e -> {
                this.commandAction("Sync to JabpLite");
                dialog.setVisible(false);
            });
            dialog.setVisible(true);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.start) {
            this.start = false;
            this.setTotals();
            this.frameWidth = this.parent.getSize().width;
            this.frameHeight = this.parent.getSize().height;
            this.frameWidthSurround = this.frameWidth - this.getSize().width;
            this.frameHeightSurround = this.frameHeight - this.getSize().height;
        }
        this.parent.lastUsedScreen = 0;
        this.parent.lastUsedView = 0;
        this.setPositions();
        this.g1.clearRect(0, 0, this.width, this.height);
        this.g1.setFont(this.font);
        this.showHeader();
        if (!this.parent.busyWithProcess) {
            this.showPage();
            this.showFooter();
        }
        if (this.parent.useCanvasMenu && this.showCanvasMenu) {
            this.displayCanvasMenu();
        }
        g.drawImage(this.image, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    void showPage() {
        this.g1.setColor(new Color(this.parent.colorBackground));
        this.g1.fillRect(0, this.lineHeight, this.width, this.height - this.lineHeight * 2);
        this.g1.setColor(new Color(this.parent.colorFont));
        if (this.numItems == 0) {
            this.g1.drawString("Click here to add account", this.parent.widthAdjustment, this.lineHeight * 2);
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                this.g1.setColor(new Color(this.parent.colorCursor));
                this.g1.fillRect(0, this.lineHeight * i + this.lineHeight, this.width, this.lineHeight);
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            this.a = this.as.getAccountFromIndex2(i + this.startPos);
            this.buildLine(this.a, this.lineHeight * i + this.lineHeight);
        }
        this.a = this.as.getAccountFromIndex2(this.startPos + this.currentPos);
    }

    void showHeader() {
        int vpos = this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        if (this.msg.equals("")) {
            this.g1.setColor(new Color(this.parent.colorHeading));
            this.g1.fillRect(0, 0, this.width, this.lineHeight);
            this.g1.setColor(new Color(this.parent.colorFont));
            this.g1.drawString("Accounts", this.parent.widthAdjustment, vpos);
            if (this.accountDisplayType == 0) {
                this.g1.drawString("Open", this.openPosition + this.numberWidth - this.fm.stringWidth("Open"), vpos);
            }
            if (this.accountDisplayType <= 1) {
                this.g1.drawString("Current", this.currentPosition + this.numberWidth - this.fm.stringWidth("Current"), vpos);
                this.g1.drawString("Today", this.todayPosition + this.numberWidth - this.fm.stringWidth("Today"), vpos);
                String s = "Reconciled";
                if (this.fm.stringWidth(s) > this.numberWidth) {
                    s = "Rec";
                }
                this.g1.drawString(s, this.reconciledPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
            } else {
                if (this.parent.showBalanceType) {
                    this.g1.drawString("Current", this.currentPosition + this.numberWidth - this.fm.stringWidth("Current"), vpos);
                } else {
                    this.g1.drawString("Today", this.todayPosition + this.numberWidth - this.fm.stringWidth("Today"), vpos);
                }
                if (this.accountDisplayType < 3) {
                    this.g1.drawString("Rec", this.reconciledPosition + this.numberWidth - this.fm.stringWidth("Rec"), vpos);
                }
            }
        } else {
            this.g1.setColor(new Color(this.parent.colorMessage));
            this.g1.fillRect(0, 0, this.width, this.lineHeight);
            this.g1.setColor(new Color(this.parent.colorFont));
            this.g1.drawString(this.msg, this.parent.widthAdjustment, vpos);
        }
    }

    void showFooter() {
        int vpos = this.height - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        this.g1.setColor(new Color(this.parent.colorHeading));
        this.g1.fillRect(0, this.height - this.lineHeight, this.width, this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        this.g1.drawString("Totals  " + this.parent.syncStatus + " " + this.parent.gpayStatus, this.parent.widthAdjustment, vpos);
        String s = "";
        if (this.accountDisplayType == 0) {
            if (this.totalOpen < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            } else {
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            s = Utilities.numberToString(this.totalOpen, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            this.g1.drawString(s, this.openPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
        }
        if (this.accountDisplayType <= 1) {
            if (this.totalCurrent < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            } else {
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            s = Utilities.numberToString(this.totalCurrent, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            this.g1.drawString(s, this.currentPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
            if (this.totalToday < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            } else {
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            s = Utilities.numberToString(this.totalToday, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            this.g1.drawString(s, this.todayPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
        } else if (this.parent.showBalanceType) {
            if (this.totalCurrent < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            } else {
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            s = Utilities.numberToString(this.totalCurrent, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            this.g1.drawString(s, this.currentPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
        } else {
            if (this.totalToday < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            } else {
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            s = Utilities.numberToString(this.totalToday, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            this.g1.drawString(s, this.todayPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
        }
        if (this.accountDisplayType < 3) {
            if (this.totalReconciled < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            } else {
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            s = Utilities.numberToString(this.totalReconciled, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            this.g1.drawString(s, this.reconciledPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
        }
    }

    void drawUp() {
        if (this.showCanvasMenu) {
            if (this.currentMenuPos > 0) {
                --this.currentMenuPos;
            } else {
                --this.startMenuPos;
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (this.startPos + this.currentPos > 0) {
            this.oldY = this.currentY;
            this.currentY -= this.lineHeight;
            --this.currentPos;
            if (this.currentY < this.lineHeight) {
                this.currentY = this.lineHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
                this.repaint();
            } else {
                this.repaint(0, this.lineHeight * this.currentPos + this.lineHeight, this.width, this.lineHeight * 2);
            }
            return;
        }
    }

    void drawDown() {
        if (this.showCanvasMenu) {
            if (this.currentMenuPos < Math.min(this.numItemsPage, this.numMenuItems) - 1) {
                ++this.currentMenuPos;
            } else {
                ++this.startMenuPos;
                if (this.startMenuPos + this.currentPos > Math.min(this.numItemsPage, this.numMenuItems) - 1) {
                    this.startMenuPos = Math.min(this.numItemsPage, this.numMenuItems) - 1 - this.currentPos;
                }
            }
            this.repaint();
            return;
        }
        if (this.startPos + this.currentPos < this.numItems - 1) {
            this.oldY = this.currentY;
            this.currentY += this.lineHeight;
            ++this.currentPos;
            if (this.currentY + this.lineHeight * 2 > this.height) {
                this.currentY -= this.lineHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
                this.repaint();
            } else {
                this.repaint(0, this.lineHeight * (this.currentPos - 1) + this.lineHeight, this.width, this.lineHeight * 2);
            }
            return;
        }
    }

    void buildLine(Account account, int y) {
        int vpos = y + this.lineHeight - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
        String s = "";
        s = account.name;
        if (this.parent.showInactiveAccountsWithAsterisk && account.type.equals("Inactive")) {
            s = "* " + s;
        }
        this.g1.setColor(new Color(this.parent.colorFont));
        int j = s.length();
        for (int i = 0; i < j; ++i) {
            int k = j - i;
            if (this.fm.stringWidth(s.substring(0, k)) > this.accountWidth) continue;
            this.g1.drawString(s.substring(0, k), this.parent.widthAdjustment, vpos);
            break;
        }
        if (this.accountDisplayType == 0) {
            if (account.open < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            } else {
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            s = Utilities.numberToString(account.open, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            this.g1.drawString(s, this.openPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
        }
        if (this.accountDisplayType <= 1) {
            if (account.current < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            } else {
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            s = Utilities.numberToString(account.current, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            this.g1.drawString(s, this.currentPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
            if (account.today < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            } else {
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            s = Utilities.numberToString(account.today, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            this.g1.drawString(s, this.todayPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
        } else if (this.parent.showBalanceType) {
            if (account.current < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            } else {
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            s = Utilities.numberToString(account.current, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            this.g1.drawString(s, this.currentPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
        } else {
            if (account.today < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            } else {
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            s = Utilities.numberToString(account.today, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            this.g1.drawString(s, this.todayPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
        }
        if (this.accountDisplayType < 3) {
            if (account.reconciled < 0) {
                this.g1.setColor(new Color(this.parent.colorNegative));
            } else {
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            s = Utilities.numberToString(account.reconciled, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            this.g1.drawString(s, this.reconciledPosition + this.numberWidth - this.fm.stringWidth(s), vpos);
        }
    }

    void setPositions() {
        this.fontHeight = this.parent.fontHeight;
        if (this.frameWidth != this.parent.getSize().width || this.frameHeight != this.parent.getSize().height) {
            this.frameWidth = this.parent.getSize().width;
            this.frameHeight = this.parent.getSize().height;
            this.setSize(this.frameWidth - this.frameWidthSurround, this.frameHeight - this.frameHeightSurround);
        }
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.image = this.createImage(this.width, this.height);
        this.g1 = this.image.getGraphics();
        Utilities.enableAntialiasing(this.g1);
        if (this.parent.lineSpacing == 0) {
            this.parent.lineSpacing = this.fontHeight / 5;
        }
        this.lineHeight = this.fontHeight + this.parent.lineSpacing * 2;
        this.numberWidth = this.minAccountAmount < -9999999 || this.maxAccountAmount > 99999999 ? (this.parent.isGroupingUsed ? this.fm.stringWidth("9,999,999.99") : this.fm.stringWidth("9999999.99")) : (this.minAccountAmount < -999999 || this.maxAccountAmount > 9999999 ? (this.parent.isGroupingUsed ? this.fm.stringWidth("999,999.99") : this.fm.stringWidth("999999.99")) : (this.minAccountAmount < -99999 || this.maxAccountAmount > 999999 ? (this.parent.isGroupingUsed ? this.fm.stringWidth("99,999.99") : this.fm.stringWidth("99999.99")) : (this.parent.isGroupingUsed ? this.fm.stringWidth("9,999.99") : this.fm.stringWidth("9999.99"))));
        this.numItemsPage = this.height / this.lineHeight - 2;
        this.spacing = this.fm.stringWidth("  ");
        this.minAccountWidth = this.fm.stringWidth("My Accounts");
        if (this.parent.accountColumnsPortrait > 0 && this.getHeight() > this.getWidth()) {
            this.minAccountWidth = this.fm.stringWidth("Accts");
            this.accountDisplayType = 4 - this.parent.accountColumnsPortrait;
            this.accountWidth = this.width - this.parent.widthAdjustment * 2 - this.numberWidth * this.parent.accountColumnsPortrait - this.spacing * this.parent.accountColumnsPortrait;
        } else if (this.parent.accountColumnsLandscape > 0 && this.getWidth() > this.getHeight()) {
            this.accountDisplayType = 4 - this.parent.accountColumnsLandscape;
            this.accountWidth = this.width - this.parent.widthAdjustment * 2 - this.numberWidth * this.parent.accountColumnsLandscape - this.spacing * this.parent.accountColumnsLandscape;
        } else {
            this.accountDisplayType = 0;
            this.accountWidth = this.width - this.parent.widthAdjustment * 2 - this.numberWidth * 4 - this.spacing * 4;
            if (this.accountWidth < this.minAccountWidth) {
                this.accountDisplayType = 1;
                this.accountWidth += this.numberWidth + this.spacing;
            }
            if (this.accountWidth < this.minAccountWidth) {
                this.accountDisplayType = 2;
                this.accountWidth += this.numberWidth + this.spacing;
            }
            if (this.accountWidth < this.minAccountWidth) {
                this.accountDisplayType = 3;
                this.accountWidth += this.numberWidth + this.spacing;
            }
        }
        if (this.accountDisplayType == 0) {
            this.openPosition = this.accountWidth + this.parent.widthAdjustment + this.spacing;
            this.currentPosition = this.openPosition + this.numberWidth + this.spacing;
            this.todayPosition = this.currentPosition + this.numberWidth + this.spacing;
            this.reconciledPosition = this.todayPosition + this.numberWidth + this.spacing;
        } else if (this.accountDisplayType == 1) {
            this.currentPosition = this.accountWidth + this.parent.widthAdjustment + this.spacing;
            this.todayPosition = this.currentPosition + this.numberWidth + this.spacing;
            this.reconciledPosition = this.todayPosition + this.numberWidth + this.spacing;
        } else if (this.parent.showBalanceType) {
            this.currentPosition = this.accountWidth + this.parent.widthAdjustment + this.spacing;
            this.reconciledPosition = this.currentPosition + this.numberWidth + this.spacing;
        } else {
            this.todayPosition = this.accountWidth + this.parent.widthAdjustment + this.spacing;
            this.reconciledPosition = this.todayPosition + this.numberWidth + this.spacing;
        }
    }

    void checkMinMax(Account account) {
        this.minAccountAmount = Math.min(this.minAccountAmount, account.current);
        this.maxAccountAmount = Math.max(this.maxAccountAmount, account.current);
        this.minAccountAmount = Math.min(this.minAccountAmount, this.totalCurrent);
        this.maxAccountAmount = Math.max(this.maxAccountAmount, this.totalCurrent);
    }

    void newAccount(Account account) {
        this.a1 = account;
        this.a1.id = this.as.saveNewAccount(this.a1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.as.toByteArray(this.a1), 1);
        }
        this.totalOpen += account.open;
        this.totalCurrent += account.current;
        this.totalToday += account.today;
        this.totalReconciled += account.reconciled;
        this.checkMinMax(this.a1);
        if (this.a == null) {
            this.a = this.a1;
        }
        if (this.a1.type.equals("Inactive") && this.parent.hideInactiveAccounts) {
            this.repaint();
            return;
        }
        if (this.parent.hideInactiveAccounts) {
            this.as.addIndex2(this.a1);
        }
        ++this.numItems;
        this.repaint();
    }

    void editAccount(Account account) {
        Hashtable ht;
        this.a1 = account;
        this.as.deleteAccount(this.oldA);
        if (this.parent.hideInactiveAccounts) {
            this.as.deleteIndex(this.oldA);
        } else {
            this.as.deleteIndex(this.startPos + this.currentPos);
        }
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.as.toByteArray(this.oldA), -1);
        }
        if ((ht = (Hashtable)this.parent.transactionHt.get(this.oldA.name)) == null) {
            ht = new Hashtable();
        }
        this.a1.id = this.as.saveNewAccount(this.a1);
        this.parent.transactionHt.put(this.a1.name, ht);
        if (!this.a1.name.equals(this.oldA.name)) {
            this.parent.transactionHt.remove(this.oldA.name);
        }
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.as.toByteArray(this.a1), 1);
        }
        this.resetDisplay();
        if (!this.a1.name.equals(this.oldA.name)) {
            this.parent.spf = new ShowProgressForm(this.parent, 1);
            this.parent.setContentView(this.parent.spf);
            this.runMode = 1;
            this.runThread();
        } else {
            this.parent.setContentView(this);
            this.repaint();
        }
    }

    void deleteAccount(Account account) {
        this.a1 = account;
        this.as.deleteAccount(this.a1);
        if (this.parent.hideInactiveAccounts) {
            this.as.deleteIndex(this.a1);
        } else {
            this.as.deleteIndex(this.startPos + this.currentPos);
        }
        this.parent.transactionHt.remove(this.a1.name);
        this.totalOpen -= this.a1.open;
        this.totalCurrent -= this.a1.current;
        this.totalToday -= this.a1.today;
        this.totalReconciled -= this.a1.reconciled;
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.lineHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
        this.parent.spf = new ShowProgressForm(this.parent, 1);
        this.parent.setContentView(this.parent.spf);
        this.runMode = 6;
        this.runThread();
    }

    void setTotals() {
        this.totalOpen = 0;
        this.totalCurrent = 0;
        this.totalToday = 0;
        this.totalReconciled = 0;
        this.minAccountAmount = 0;
        this.maxAccountAmount = 0;
        if (this.numItems <= 0) {
            return;
        }
        for (int i = 0; i < this.numItems; ++i) {
            this.a = this.as.getAccountFromIndex2(i);
            this.totalOpen += this.a.open;
            this.totalCurrent += this.a.current;
            this.totalToday += this.a.today;
            this.totalReconciled += this.a.reconciled;
            this.minAccountAmount = Math.min(this.minAccountAmount, this.a.current);
            this.maxAccountAmount = Math.max(this.maxAccountAmount, this.a.current);
        }
        this.minAccountAmount = Math.min(this.minAccountAmount, this.totalCurrent);
        this.maxAccountAmount = Math.max(this.maxAccountAmount, this.totalCurrent);
    }

    void deleteAccountName() {
        if (this.parent.syncMode) {
            this.parent.sync.closeSyncStore();
            this.parent.sync = new SyncStore(this.parent, true);
        }
        this.parent.show("Checking database\nUpdating standing orders");
        int found = 0;
        if (this.parent.sov != null) {
            this.parent.sov.sos.closeStandingOrderStore();
            this.parent.sov = null;
        }
        this.parent.standingOrderHt = new Hashtable();
        StandingOrderStore sos = new StandingOrderStore(this.parent, true);
        sos.rs.activeRecords = 0;
        StandingOrder so2 = null;
        sos.setToStart();
        while ((so2 = sos.readNextStandingOrder()) != null) {
            boolean writeFlag = true;
            if (so2.account.equals(this.a1.name)) {
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(sos.toByteArray(so2), -6);
                }
                writeFlag = false;
                ++found;
            }
            if (so2.transferFlag && so2.transferAccount.equals(this.a1.name)) {
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(sos.toByteArray(so2), -6);
                }
                writeFlag = false;
                ++found;
            }
            if (!writeFlag) continue;
            byte[] bytes = sos.toByteArray(so2);
            so2.id = sos.rs.writeRecordToTemporary(bytes);
            ++sos.rs.activeRecords;
            sos.addIndex(so2);
        }
        sos.rs.deletedSpace = 0;
        sos.rs.putHeader();
        sos.closeStandingOrderStore();
        sos.rs.switchFiles();
        this.parent.show(found + " standing orders were deleted\nUpdating transactions");
        found = 0;
        int found2 = 0;
        if (this.parent.cv != null) {
            this.parent.cv.cs.closeCategoryStore();
            this.parent.cv = null;
        }
        CategoryStore cs = new CategoryStore(this.parent, true);
        if (this.parent.tv != null) {
            this.parent.tv.ts.closeTransactionStore();
            this.parent.tv = null;
        }
        this.parent.transactionHt = new Hashtable();
        Account a2 = null;
        this.as.setToStart();
        while ((a2 = this.as.readNextAccount()) != null) {
            this.parent.transactionHt.put(a2.name, new Hashtable());
        }
        TransactionStore ts = new TransactionStore(this.parent, new Account(), true);
        ts.rs.activeRecords = 0;
        Transaction t2 = null;
        ts.setToStart();
        int count = 0;
        a2 = new Account();
        while ((t2 = ts.readNextTransaction()) != null) {
            boolean writeFlag = true;
            if (t2.account.equals(this.a1.name)) {
                writeFlag = false;
                if (!t2.transferFlag) {
                    if (t2.splitFlag) {
                        for (int i = 0; i < t2.ss.size(); ++i) {
                            Split s = t2.ss.getSplit(i);
                            Category c = cs.getCategoryFromName(s.category);
                            this.updateCategoryTotal1(c);
                            c.updateBalance(null, s);
                            this.updateCategoryTotal2(c);
                            cs.saveExistingCategory(c);
                        }
                    } else {
                        Category c = cs.getCategoryFromName(t2.category);
                        this.updateCategoryTotal1(c);
                        c.updateBalance(null, t2);
                        this.updateCategoryTotal2(c);
                        cs.saveExistingCategory(c);
                    }
                }
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(ts.toByteArray(t2), -7);
                }
                ++found;
            }
            if (t2.transferFlag && t2.transferAccount.equals(this.a1.name)) {
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(ts.toByteArray(t2), -7);
                }
                t2.transferFlag = false;
                t2.transferAccount = "";
                Category c = cs.getCategoryFromName("[Deleted:" + this.a1.name + "]");
                t2.category = c.name;
                this.updateCategoryTotal1(c);
                c.updateBalance(t2, null);
                this.updateCategoryTotal2(c);
                cs.saveExistingCategory(c);
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(ts.toByteArray(t2), 7);
                }
                ++found2;
            }
            if (writeFlag) {
                a2.name = t2.account;
                ts.getIndex(a2);
                byte[] bytes = ts.toByteArray(t2);
                t2.id = ts.rs.writeRecordToTemporary(bytes);
                ++ts.rs.activeRecords;
                ts.addIndex(t2);
                ts.setIndex(a2);
            }
            if (++count / 1000 * 1000 != count) continue;
            this.parent.show(count + " transactions read");
        }
        ts.rs.deletedSpace = 0;
        ts.rs.putHeader();
        ts.closeTransactionStore();
        ts.rs.switchFiles();
        cs.closeCategoryStore();
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.as.toByteArray(this.a1), -1);
        }
        this.parent.show(found + " transactions were deleted\n" + found2 + " transfers in other accounts were updated\nFinished");
        if (this.parent.syncMode) {
            this.parent.sync.closeSyncStore();
            this.parent.sync = new SyncStore(this.parent, false);
        }
        this.parent.showDoneButton();
    }

    void updateCategoryTotal1(Category category) {
        if (this.parent.cv != null) {
            this.parent.cv.totalCurrent -= category.current;
        }
    }

    void updateCategoryTotal2(Category category) {
        if (this.parent.cv != null) {
            this.parent.cv.totalCurrent += category.current;
            this.parent.cv.checkMinMax(category);
        }
    }

    void updateAccountName() {
        if (this.parent.syncMode) {
            this.parent.sync.closeSyncStore();
            this.parent.sync = new SyncStore(this.parent, true);
        }
        this.parent.show("Checking database\nUpdating standing orders");
        int found = 0;
        if (this.parent.sov != null) {
            this.parent.sov.sos.closeStandingOrderStore();
            this.parent.sov = null;
        }
        this.parent.standingOrderHt = new Hashtable();
        StandingOrderStore sos = new StandingOrderStore(this.parent, true);
        sos.rs.activeRecords = 0;
        StandingOrder so2 = null;
        sos.setToStart();
        while ((so2 = sos.readNextStandingOrder()) != null) {
            if (so2.account.equals(this.oldA.name)) {
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(sos.toByteArray(so2), -6);
                }
                so2.account = this.a1.name;
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(sos.toByteArray(so2), 6);
                }
                ++found;
            }
            if (so2.transferFlag && so2.transferAccount.equals(this.oldA.name)) {
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(sos.toByteArray(so2), -6);
                }
                so2.transferAccount = this.a1.name;
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(sos.toByteArray(so2), 6);
                }
                ++found;
            }
            byte[] bytes = sos.toByteArray(so2);
            so2.id = sos.rs.writeRecordToTemporary(bytes);
            ++sos.rs.activeRecords;
            sos.addIndex(so2);
        }
        sos.rs.deletedSpace = 0;
        sos.rs.putHeader();
        sos.closeStandingOrderStore();
        sos.rs.switchFiles();
        this.parent.show(found + " standing orders were updated\nUpdating transactions");
        found = 0;
        if (this.parent.tv != null) {
            this.parent.tv.ts.closeTransactionStore();
            this.parent.tv = null;
        }
        this.parent.transactionHt = new Hashtable();
        TransactionStore ts = new TransactionStore(this.parent, new Account(), true);
        ts.rs.activeRecords = 0;
        Transaction t2 = null;
        ts.setToStart();
        int count = 0;
        Account a2 = new Account();
        while ((t2 = ts.readNextTransaction()) != null) {
            if (t2.account.equals(this.oldA.name)) {
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(ts.toByteArray(t2), -8);
                }
                t2.account = this.a1.name;
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(ts.toByteArray(t2), 8);
                }
                ++found;
            }
            if (t2.transferFlag && t2.transferAccount.equals(this.oldA.name)) {
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(ts.toByteArray(t2), -8);
                }
                t2.transferAccount = this.a1.name;
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(ts.toByteArray(t2), 8);
                }
                ++found;
            }
            a2.name = t2.account;
            ts.getIndex(a2);
            byte[] bytes = ts.toByteArray(t2);
            t2.id = ts.rs.writeRecordToTemporary(bytes);
            ++ts.rs.activeRecords;
            ts.addIndex(t2);
            ts.setIndex(a2);
            if (++count / 1000 * 1000 != count) continue;
            this.parent.show(count + " transactions read");
        }
        ts.rs.deletedSpace = 0;
        ts.rs.putHeader();
        ts.closeTransactionStore();
        ts.rs.switchFiles();
        this.parent.show(found + " transactions were updated\nFinished");
        if (this.parent.syncMode) {
            this.parent.sync.closeSyncStore();
            this.parent.sync = new SyncStore(this.parent, false);
        }
        this.parent.showDoneButton();
    }

    void buildIndexExcludingInactiveAccounts() {
        if (!this.parent.hideInactiveAccounts) {
            this.as.ht2 = this.as.ht;
            return;
        }
        this.as.ht2 = new Hashtable();
        this.as.setToStart();
        while (true) {
            this.a = this.as.readNextAccount();
            if (this.a == null) break;
            this.as.addIndex2(this.a);
        }
    }

    void resetDisplay() {
        if (this.as != null) {
            this.as.closeAccountStore();
        }
        this.as = new AccountStore(this.parent, false);
        this.buildIndexExcludingInactiveAccounts();
        this.numItems = this.as.ht2.size();
        this.setTotals();
        this.setupCanvasMenu();
        this.font = this.parent.font;
        this.setFont(this.font);
        this.fm = this.getFontMetrics(this.font);
        this.lineHeight = this.parent.fontHeight + this.parent.lineSpacing * 2;
        this.currentX = 0;
        this.currentY = this.lineHeight;
        this.currentPos = 0;
        this.startPos = 0;
        this.repaint();
    }

    void runThread() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        if (this.runMode == 1) {
            this.updateAccountName();
            return;
        }
        if (this.runMode == 2) {
            this.parent.ief = new ImportExportForm(this.parent, false);
            this.parent.ief.syncData2(false);
            return;
        }
        if (this.runMode == 3) {
            this.parent.ief = new ImportExportForm(this.parent, false);
            this.parent.ief.backupData(false);
            return;
        }
        if (this.runMode == 5) {
            this.parent.recreateIndices(true);
            return;
        }
        if (this.runMode == 6) {
            this.deleteAccountName();
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int j;
        String s = ae.getSource().toString();
        String s1 = s.substring((j = s.indexOf("[")) + 1, j + 5);
        if (s1.equals("menu")) {
            MenuItem mi = (MenuItem)ae.getSource();
            this.commandAction(mi.getLabel());
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        this.lastDragX = x;
        this.lastDragY = y;
        this.pointerExecute = false;
        this.alwaysDisplayMenu = false;
        this.timePointerOnScreen = System.currentTimeMillis();
        this.calculateCanvasMenuPosition = true;
        if (this.showCanvasMenu) {
            this.calculateCanvasMenuPosition = false;
            this.currentMenuPos = (y - this.menuHeightPos) / this.lineHeight;
            this.repaint();
            return;
        }
        if (y < this.lineHeight) {
            if (this.numItems == 0) {
                return;
            }
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.lineHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (y > this.height - this.lineHeight) {
            if (this.numItems == 0) {
                return;
            }
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
            this.repaint();
            return;
        }
        this.pointerExecute = true;
        int newPos = (y - this.lineHeight) / this.lineHeight;
        if (newPos >= this.numItems) {
            this.alwaysDisplayMenu = true;
            return;
        }
        this.currentPos = newPos;
        this.currentY = (this.currentPos + 1) * this.lineHeight;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        if (Math.abs(this.lastDragX - x) > 250) {
            this.commandAction("Switch Views");
            return;
        }
        if (this.dragScreen) {
            this.dragScreen = false;
            return;
        }
        if (this.showCanvasMenu) {
            this.showCanvasMenu = false;
            this.repaint();
            if (x < this.menuWidthPos || x > this.menuWidthPos + this.menuWidth || y < this.menuHeightPos || y > this.menuHeightPos + this.menuHeight) {
                this.setupCanvasMenu();
                this.showExtraOptionsMenu = false;
                this.showSwitchViewsMenu = false;
                return;
            }
            int k = (y - this.menuHeightPos) / this.lineHeight + this.startMenuPos;
            if (this.showExtraOptionsMenu) {
                this.showExtraOptionsMenu = false;
                this.processExtraOptionsMenu(k);
            } else if (this.showSwitchViewsMenu) {
                this.showSwitchViewsMenu = false;
                this.processSwitchViewsMenu(k);
            } else {
                this.processMenuCommand(k);
            }
            return;
        }
        this.timePointerOnScreen = System.currentTimeMillis() - this.timePointerOnScreen;
        if (this.timePointerOnScreen > (long)this.parent.longTapDelay) {
            if (y < this.lineHeight) {
                this.startPos = 0;
                this.currentPos = 0;
                this.currentY = this.lineHeight;
                this.repaint();
                return;
            }
            if (y > this.height - this.lineHeight) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                this.repaint();
                return;
            }
        }
        if (this.alwaysDisplayMenu) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.repaint();
            } else {
                this.displayPopupMenu();
            }
            return;
        }
        if (!this.pointerExecute) {
            return;
        }
        if (this.parent.showMenuAccountView && this.timePointerOnScreen <= (long)this.parent.longTapDelay || !this.parent.showMenuAccountView && this.timePointerOnScreen > (long)this.parent.longTapDelay) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.repaint();
            } else {
                this.displayPopupMenu();
            }
            return;
        }
        this.a = this.as.getAccountFromIndex2(this.startPos + this.currentPos);
        if (this.parent.tv != null) {
            this.parent.tv.ts.closeTransactionStore();
            this.parent.tv.rs.closeRegularStore();
        }
        this.parent.tv = new TransactionView(this.parent, this.a);
        this.parent.setContentView(this.parent.tv);
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.point = me.getPoint();
        int x = this.point.x;
        int y = this.point.y;
        int scroll = (y - this.lastDragY) / this.lineHeight;
        if (scroll == 0) {
            return;
        }
        if (scroll > 0) {
            if (this.showCanvasMenu) {
                this.startMenuPos -= scroll;
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
                this.currentMenuPos += scroll;
                if (this.currentMenuPos > Math.min(this.numMenuItems, this.numItemsPage) - 1) {
                    this.currentMenuPos = Math.min(this.numMenuItems, this.numItemsPage) - 1;
                }
            } else {
                this.startPos -= scroll;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                this.currentPos += scroll;
                if (this.currentPos > Math.min(this.numItems, this.numItemsPage) - 1) {
                    this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                }
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
        }
        if (scroll < 0) {
            if (this.showCanvasMenu) {
                this.startMenuPos -= scroll;
                if (this.startMenuPos + this.numItemsPage > this.numMenuItems - 1) {
                    this.startMenuPos = this.numMenuItems - this.numItemsPage;
                }
                if (this.startMenuPos < 0) {
                    this.startMenuPos = 0;
                }
                this.currentMenuPos += scroll;
                if (this.currentMenuPos < 0) {
                    this.currentMenuPos = 0;
                }
            } else {
                this.startPos -= scroll;
                if (this.startPos + this.currentPos > this.numItems - 1) {
                    this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                    this.startPos = this.numItems - 1 - this.currentPos;
                    this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                }
                this.currentPos += scroll;
                if (this.currentPos < 0) {
                    this.currentPos = 0;
                }
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
        }
        this.lastDragY = y;
        this.repaint();
        this.dragScreen = true;
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        int notches = mwe.getWheelRotation();
        if (notches == 0) {
            return;
        }
        if (notches > 0) {
            for (int i = 0; i < notches; ++i) {
                this.drawDown();
            }
        } else {
            notches = -notches;
            for (int i = 0; i < notches; ++i) {
                this.drawUp();
            }
        }
    }

    void displayPopupMenu() {
        if (this.showingPopupMenu) {
            this.showingPopupMenu = false;
            return;
        }
        PopupMenu pm = new PopupMenu();
        MenuItem miEntries = new MenuItem("Entries");
        MenuItem miNew = new MenuItem("New");
        MenuItem miEdit = new MenuItem("Edit");
        MenuItem miDelete = new MenuItem("Delete");
        MenuItem miShow = new MenuItem("Show");
        MenuItem miSwitchViews = new MenuItem("Switch Views");
        MenuItem miExtraOptions = new MenuItem("Extra Options");
        MenuItem miFind = new MenuItem("Find");
        MenuItem miAccountBalancesByMonth = new MenuItem("Balances By Month");
        MenuItem miToggleDefaultAction = new MenuItem("Toggle Default Action");
        MenuItem miToggleInactiveAccounts = new MenuItem("Toggle Inactive Accounts");
        MenuItem miAbout = new MenuItem("About");
        MenuItem miExit = new MenuItem("Exit");
        miEntries.addActionListener(this);
        miNew.addActionListener(this);
        miEdit.addActionListener(this);
        miDelete.addActionListener(this);
        miShow.addActionListener(this);
        miSwitchViews.addActionListener(this);
        miExtraOptions.addActionListener(this);
        miFind.addActionListener(this);
        miAccountBalancesByMonth.addActionListener(this);
        miToggleDefaultAction.addActionListener(this);
        miToggleInactiveAccounts.addActionListener(this);
        miAbout.addActionListener(this);
        miExit.addActionListener(this);
        pm.add(miEntries);
        pm.add(miNew);
        pm.add(miEdit);
        pm.add(miDelete);
        pm.add(miShow);
        pm.add(miSwitchViews);
        pm.add(miExtraOptions);
        pm.add(miFind);
        pm.add(miAccountBalancesByMonth);
        pm.add(miToggleDefaultAction);
        pm.add(miToggleInactiveAccounts);
        pm.add(miAbout);
        pm.add(miExit);
        this.add(pm);
        int x = 0;
        int y = 0;
        if (this.point == null) {
            pm.show(this, x, y);
        } else {
            Point move = this.movePopup(13, x, y);
            pm.show(this, move.x + this.point.x, move.y + this.point.y);
        }
        this.showingPopupMenu = true;
    }

    void displaySwitchViewsMenu() {
        if (this.showingPopupMenu) {
            this.showingPopupMenu = false;
            return;
        }
        PopupMenu pm = new PopupMenu();
        MenuItem miAccounts = new MenuItem("Accounts");
        MenuItem miTransactions = new MenuItem("Transactions");
        MenuItem miCategories = new MenuItem("Categories");
        MenuItem miStandingOrders = new MenuItem("Standing Orders");
        MenuItem miInvestments = new MenuItem("Investments");
        MenuItem miCurrencies = new MenuItem("Currencies");
        miAccounts.addActionListener(this);
        miTransactions.addActionListener(this);
        miCategories.addActionListener(this);
        miStandingOrders.addActionListener(this);
        miInvestments.addActionListener(this);
        miCurrencies.addActionListener(this);
        pm.add(miAccounts);
        pm.add(miTransactions);
        pm.add(miCategories);
        pm.add(miStandingOrders);
        pm.add(miInvestments);
        pm.add(miCurrencies);
        this.add(pm);
        int x = 0;
        int y = 0;
        if (this.point == null) {
            pm.show(this, x, y);
        } else {
            Point move = this.movePopup(7, x, y);
            pm.show(this, move.x + this.point.x, move.y + this.point.y);
        }
        this.showingPopupMenu = true;
    }

    void displayExtraOptionsMenu() {
        if (this.showingPopupMenu) {
            this.showingPopupMenu = false;
            return;
        }
        PopupMenu pm = new PopupMenu();
        MenuItem miPreferences = new MenuItem("Preferences");
        MenuItem miPassword = new MenuItem("Password");
        MenuItem miSync = new MenuItem("Sync to JabpLite");
        MenuItem miPendingGPay = new MenuItem("Pending GPay");
        MenuItem miBackup = new MenuItem("Backup Data");
        MenuItem miImportExport = new MenuItem("Import/Export");
        MenuItem miNetWorth = new MenuItem("Net Worth");
        MenuItem miFutureBalance = new MenuItem("Future Balance");
        MenuItem miGraphs = new MenuItem("Graphs");
        MenuItem miPurge = new MenuItem("Purge");
        MenuItem miRecreateBalances = new MenuItem("Recreate Balances");
        MenuItem miInformation = new MenuItem("Information");
        MenuItem miHelp = new MenuItem("User Guide");
        miPreferences.addActionListener(this);
        miPassword.addActionListener(this);
        miSync.addActionListener(this);
        miPendingGPay.addActionListener(this);
        miBackup.addActionListener(this);
        miImportExport.addActionListener(this);
        miNetWorth.addActionListener(this);
        miFutureBalance.addActionListener(this);
        miGraphs.addActionListener(this);
        miPurge.addActionListener(this);
        miRecreateBalances.addActionListener(this);
        miInformation.addActionListener(this);
        miHelp.addActionListener(this);
        pm.add(miPreferences);
        pm.add(miPassword);
        pm.add(miSync);
        pm.add(miPendingGPay);
        pm.add(miBackup);
        pm.add(miImportExport);
        pm.add(miNetWorth);
        pm.add(miFutureBalance);
        pm.add(miGraphs);
        pm.add(miPurge);
        pm.add(miRecreateBalances);
        pm.add(miInformation);
        pm.add(miHelp);
        this.add(pm);
        int x = 0;
        int y = 0;
        if (this.point == null) {
            pm.show(this, x, y);
        } else {
            Point move = this.movePopup(13, x, y);
            pm.show(this, move.x + this.point.x, move.y + this.point.y);
        }
        this.showingPopupMenu = true;
    }

    Point movePopup(int n, int x, int y) {
        int popupHeight = n * this.lineHeight * 4 / 3;
        if (this.parent.useCanvasMenu && x + this.point.x + this.menuWidth > this.width) {
            x = this.width - this.menuWidth - this.point.x;
        }
        if (y + this.point.y + popupHeight > this.height) {
            y = this.height - popupHeight - this.point.y;
        }
        Point move = new Point(x, y);
        return move;
    }

    void setupCanvasMenu() {
        this.startMenuPos = 0;
        this.currentMenuPos = 0;
        this.canvasMenu = new Vector(12);
        this.canvasMenu.addElement("Entries");
        this.canvasMenu.addElement("New");
        this.canvasMenu.addElement("Edit");
        this.canvasMenu.addElement("Delete");
        this.canvasMenu.addElement("Show");
        this.canvasMenu.addElement("Switch Views");
        this.canvasMenu.addElement("Extra Options");
        this.canvasMenu.addElement("Find");
        this.canvasMenu.addElement("Balances By Month");
        this.canvasMenu.addElement("Toggle Default Action");
        this.canvasMenu.addElement("Toggle Inactive Accounts");
        this.canvasMenu.addElement("About");
        this.canvasMenu.addElement("Exit");
        this.menuWidth = this.fm.stringWidth("Toggle Inactive Accounts") + 6;
    }

    void setupSwitchViewsMenu() {
        this.startMenuPos = 0;
        this.currentMenuPos = 0;
        this.canvasMenu = new Vector(6);
        this.canvasMenu.addElement("Accounts");
        this.canvasMenu.addElement("Transactions");
        this.canvasMenu.addElement("Categories");
        this.canvasMenu.addElement("Standing Orders");
        this.canvasMenu.addElement("Investments");
        this.canvasMenu.addElement("Currencies");
        this.menuWidth = this.fm.stringWidth("Standing Orders") + 6;
    }

    void setupExtraOptionsMenu() {
        this.startMenuPos = 0;
        this.currentMenuPos = 0;
        this.canvasMenu = new Vector(13);
        this.canvasMenu.addElement("Preferences");
        this.canvasMenu.addElement("Password");
        this.canvasMenu.addElement("Sync to JabpLite");
        this.canvasMenu.addElement("Pending GPay");
        this.canvasMenu.addElement("Backup Data");
        this.canvasMenu.addElement("Import/Export");
        this.canvasMenu.addElement("Net Worth");
        this.canvasMenu.addElement("Future Balance");
        this.canvasMenu.addElement("Graphs");
        this.canvasMenu.addElement("Purge");
        this.canvasMenu.addElement("Recreate Balances");
        this.canvasMenu.addElement("Information");
        this.canvasMenu.addElement("User Guide");
        this.menuWidth = this.fm.stringWidth("Recreate Balances") + 10;
    }

    void displayCanvasMenu() {
        this.numMenuItems = this.canvasMenu.size();
        this.menuWidthPos = (this.width - this.menuWidth) / 2;
        if (this.menuWidthPos < 0) {
            this.menuWidthPos = 0;
        }
        this.menuHeightPos = (this.height - this.lineHeight * 2 - this.numMenuItems * this.lineHeight) / 2;
        if (this.menuHeightPos < this.lineHeight) {
            this.menuHeightPos = this.lineHeight;
        }
        this.menuHeight = Math.min(this.height - this.lineHeight * 2, this.numMenuItems * this.lineHeight);
        this.g1.setColor(new Color(this.parent.colorMessage));
        this.g1.fillRect(this.menuWidthPos, this.menuHeightPos, this.menuWidth, this.menuHeight);
        this.g1.setColor(new Color(this.parent.colorFont));
        for (int i = 0; i < this.numItemsPage && i + this.startMenuPos <= this.numMenuItems - 1; ++i) {
            int vpos = i * this.lineHeight + this.lineHeight + this.menuHeightPos - this.parent.lineSpacing - this.fm.getMaxDescent() + this.parent.fontAdjustment;
            if (i == this.currentMenuPos) {
                this.g1.setColor(new Color(this.parent.colorCursor));
                this.g1.fillRect(this.menuWidthPos, this.lineHeight * i + this.menuHeightPos, this.menuWidth, this.lineHeight);
                this.g1.setColor(new Color(this.parent.colorFont));
            }
            this.g1.drawString((String)this.canvasMenu.elementAt(i + this.startMenuPos), this.menuWidthPos + 3, vpos);
        }
    }

    void processMenuCommand(int k) {
        this.invalidate();
        this.commandAction((String)this.canvasMenu.elementAt(k));
    }

    void processSwitchViewsMenu(int k) {
        this.setupCanvasMenu();
        switch (k) {
            case 0: {
                this.commandAction("Accounts");
                break;
            }
            case 1: {
                this.commandAction("Transactions");
                break;
            }
            case 2: {
                this.commandAction("Categories");
                break;
            }
            case 3: {
                this.commandAction("Standing Orders");
                break;
            }
            case 4: {
                this.commandAction("Investments");
                break;
            }
            case 5: {
                this.commandAction("Currencies");
            }
        }
    }

    void processExtraOptionsMenu(int k) {
        String cmd = (String)this.canvasMenu.elementAt(k);
        this.setupCanvasMenu();
        this.commandAction(cmd);
    }

    public void commandAction(String cmd) {
        this.showingPopupMenu = false;
        if (this.parent.saveStateOnHome) {
            this.parent.ixs.selfDestruct();
        }
        if (cmd.equals("Exit")) {
            this.parent.finishAndQuit();
            return;
        }
        if (cmd.equals("Entries")) {
            this.a = this.as.getAccountFromIndex2(this.startPos + this.currentPos);
            if (this.parent.tv != null) {
                this.parent.tv.ts.closeTransactionStore();
                this.parent.tv.rs.closeRegularStore();
            }
            this.parent.tv = new TransactionView(this.parent, this.a);
            this.parent.setContentView(this.parent.tv);
            return;
        }
        if (cmd.equals("New")) {
            this.parent.af = new AccountForm(this.parent, new Account(), "New");
            return;
        }
        if (cmd.equals("Edit")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to edit", 2000).show();
                return;
            }
            this.oldA = new Account();
            this.oldA.clone(this.a);
            this.parent.af = new AccountForm(this.parent, this.a, "Edit");
            return;
        }
        if (cmd.equals("Delete")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to delete", 2000).show();
                return;
            }
            this.parent.af = new AccountForm(this.parent, this.a, "Delete");
            return;
        }
        if (cmd.equals("Show")) {
            if (this.numItems == 0) {
                Toast.makeText(this.parent, "Nothing to show", 2000).show();
                return;
            }
            this.parent.gsf = new GenericShowForm(this.parent, this.a, 0);
            this.parent.setContentView(this.parent.gsf);
            return;
        }
        if (cmd.equals("Find")) {
            new FindForm(this.parent);
            return;
        }
        if (cmd.equals("Balances By Month")) {
            this.parent.abbmf = new AccountBalancesByMonthForm(this.parent);
            if (this.parent.abbmf.goAheadAndShowResults) {
                this.parent.gsf = new GenericShowForm(this.parent, null, 10);
                this.parent.setContentView(this.parent.gsf);
            }
            return;
        }
        if (cmd.equals("Switch Views")) {
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.showSwitchViewsMenu = true;
                this.setupSwitchViewsMenu();
                this.repaint();
                return;
            }
            this.displaySwitchViewsMenu();
            return;
        }
        if (cmd.equals("Extra Options")) {
            this.setupExtraOptionsMenu();
            if (this.parent.useCanvasMenu) {
                this.showCanvasMenu = true;
                this.showExtraOptionsMenu = true;
                this.repaint();
                return;
            }
            this.displayExtraOptionsMenu();
            return;
        }
        if (cmd.equals("User Guide")) {
            try {
                Desktop desktop = Desktop.getDesktop();
                URI oURL = new URI("https://docs.google.com/document/d/1Uuvd2mDPMnTTFWyXgELMwVuoCpjiLGG4hjhxtXzmMCQ/edit?usp=sharing");
                desktop.browse(oURL);
            }
            catch (Exception exception) {
                Toast.makeText(this.parent, "Cannot open user guide", 2000).show();
            }
            return;
        }
        if (cmd.equals("About")) {
            Toast.makeText(this.parent, this.parent.version + "\n(c) Malcolm Bryant & Freepoc, 2002-2026\nwww.freepoc.org\nmalcolm@freepoc.org", 2000).show();
            return;
        }
        if (cmd.equals("Toggle Default Action")) {
            if (this.parent.showMenuAccountView) {
                this.parent.showMenuAccountView = false;
                Toast.makeText(this.parent, "Default action: show account entries\nLong click action: show menu", 2000).show();
            } else {
                this.parent.showMenuAccountView = true;
                Toast.makeText(this.parent, "Default action: show menu\nLong click action: show account entries", 2000).show();
            }
            return;
        }
        if (cmd.equals("Toggle Inactive Accounts")) {
            if (this.parent.hideInactiveAccounts) {
                this.parent.hideInactiveAccounts = false;
                this.resetDisplay();
                Toast.makeText(this.parent, "Showing inactive accounts", 2000).show();
            } else {
                this.parent.hideInactiveAccounts = true;
                this.resetDisplay();
                Toast.makeText(this.parent, "Hiding inactive accounts", 2000).show();
            }
            return;
        }
        if (cmd.equals("Accounts") || cmd.equals("Home")) {
            Toast.makeText(this.parent, "Already in Accounts View", 2000).show();
            this.repaint();
            return;
        }
        if (cmd.equals("Transactions")) {
            if (this.parent.tv == null) {
                Toast.makeText(this.parent, "No account selected", 2000).show();
            } else {
                this.parent.setContentView(this.parent.tv);
            }
            this.repaint();
            return;
        }
        if (cmd.equals("Categories")) {
            if (this.parent.cv == null) {
                this.parent.cv = new CategoryView(this.parent);
            }
            this.parent.setContentView(this.parent.cv);
            this.repaint();
            return;
        }
        if (cmd.equals("Standing Orders")) {
            if (this.parent.sov == null) {
                this.parent.sov = new StandingOrderView(this.parent);
            }
            this.parent.setContentView(this.parent.sov);
            this.repaint();
            return;
        }
        if (cmd.equals("Investments")) {
            if (this.parent.iv == null) {
                this.parent.iv = new InvestmentView(this.parent);
            }
            this.parent.setContentView(this.parent.iv);
            this.repaint();
            return;
        }
        if (cmd.equals("Currencies")) {
            if (this.parent.ccyv == null) {
                this.parent.ccyv = new CurrencyView(this.parent);
            }
            this.parent.setContentView(this.parent.ccyv);
            this.repaint();
            return;
        }
        if (cmd.equals("Preferences")) {
            this.msg = "";
            new PreferenceForm(this.parent);
            return;
        }
        if (cmd.equals("Password")) {
            this.msg = "";
            if (this.parent.password.equals("")) {
                new PasswordForm(this.parent, "Confirm", 0, 0);
            } else {
                new PasswordForm(this.parent, "Verify", 0, 0);
            }
            return;
        }
        if (cmd.equals("Sync to JabpLite")) {
            if (this.parent.copyToDropbox && !this.parent.hasDropboxToken()) {
                Toast.makeText(this.parent, "You must login to Dropbox first", 2000).show();
                return;
            }
            this.msg = "";
            this.parent.spf = new ShowProgressForm(this.parent, 1);
            this.parent.setContentView(this.parent.spf);
            if (this.parent.copyToDropbox) {
                if (this.parent.ief == null) {
                    this.parent.ief = new ImportExportForm(this.parent, false);
                }
                this.parent.ief.isJabpSyncUploaded = false;
                this.parent.ief.isJabpLiteSyncUploaded = false;
                this.parent.ief.isJabpSyncDownloaded = false;
                this.parent.ief.isJabpLiteSyncDownloaded = false;
                this.parent.ief.dropboxDownloadFile("Jabp.sync");
                this.parent.ief.dropboxDownloadFile("JabpLite.sync");
            } else {
                this.runMode = 2;
                this.runThread();
            }
            return;
        }
        if (cmd.equals("Pending GPay")) {
            if (!this.parent.allowPendingTransactionsFromOtherDevices) {
                if (!this.parent.checkPendingTransactions()) {
                    Toast.makeText(this.parent, "No pending transactions to process", 2000).show();
                    this.parent.setContentView(this.parent.av);
                }
                return;
            }
            if (this.parent.copyToDropbox) {
                if (!this.parent.hasDropboxToken()) {
                    Toast.makeText(this.parent, "You must login to Dropbox first", 2000).show();
                    return;
                }
                this.parent.spf = new ShowProgressForm(this.parent, 1);
                this.parent.setContentView(this.parent.spf);
                if (this.parent.ief == null) {
                    this.parent.ief = new ImportExportForm(this.parent, false);
                }
                this.parent.ief.isGooglePaySyncFinished = false;
                this.parent.ief.isGooglePaySyncDownloaded = false;
                this.parent.ief.dropboxDownloadFile("gpaydb.sync");
            } else if (!this.parent.checkPendingTransactions()) {
                Toast.makeText(this.parent, "No pending transactions to process", 2000).show();
                this.parent.setContentView(this.parent.av);
            }
            return;
        }
        if (cmd.equals("Backup Data")) {
            this.msg = "";
            this.parent.spf = new ShowProgressForm(this.parent, 1);
            this.parent.setContentView(this.parent.spf);
            this.parent.ief = new ImportExportForm(this.parent, false);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    AccountView.this.parent.ief.backupData(false);
                }
            }).start();
            return;
        }
        if (cmd.equals("Import/Export")) {
            this.msg = "";
            this.parent.ief = new ImportExportForm(this.parent, true);
            this.parent.ief.start();
            return;
        }
        if (cmd.equals("Net Worth")) {
            this.msg = "";
            if (this.parent.nwv == null) {
                this.parent.nwv = new NetWorthView(this.parent);
            }
            this.parent.setContentView(this.parent.nwv);
            return;
        }
        if (cmd.equals("Future Balance")) {
            this.msg = "";
            new FutureBalanceForm(this.parent);
            return;
        }
        if (cmd.equals("Graphs")) {
            this.msg = "";
            this.parent.gf = new GraphForm(this.parent);
            this.parent.setContentView(this.parent.gf);
            this.parent.gf.start();
            return;
        }
        if (cmd.equals("Purge")) {
            new PurgeForm(this.parent);
            return;
        }
        if (cmd.equals("Recreate Balances")) {
            this.msg = "";
            this.parent.spf = new ShowProgressForm(this.parent, 1);
            this.parent.setContentView(this.parent.spf);
            this.runMode = 5;
            this.runThread();
            return;
        }
        if (cmd.equals("Information")) {
            this.msg = "";
            this.parent.gsf = new GenericShowForm(this.parent, null, 7);
            this.parent.setContentView(this.parent.gsf);
            return;
        }
    }

    void show(String s1, boolean paintHeaderOnly1) {
        final String s = s1;
        this.paintHeaderOnly = paintHeaderOnly1;
        new Thread(new Runnable(){

            @Override
            public void run() {
                AccountView.this.msg = s;
                AccountView.this.repaint();
            }
        }).start();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int keyCode = keyEvent.getKeyCode();
        switch (keyCode) {
            case 33: 
            case 37: {
                if (this.startPos == 0) {
                    this.currentPos = 0;
                    this.currentY = this.lineHeight;
                    break;
                }
                this.startPos -= this.numItemsPage;
                if (this.startPos >= 0) break;
                this.startPos = 0;
                break;
            }
            case 34: 
            case 39: {
                this.startPos += this.numItemsPage;
                if (this.startPos + this.currentPos <= this.numItems - 1) break;
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                break;
            }
            case 38: {
                this.drawUp();
                break;
            }
            case 40: {
                this.drawDown();
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int keyCode = keyEvent.getKeyCode();
        switch (keyCode) {
            case 36: {
                this.startPos = 0;
                this.currentPos = 0;
                this.currentY = this.lineHeight;
                break;
            }
            case 35: {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
                break;
            }
            case 10: 
            case 525: {
                if (this.showCanvasMenu) {
                    this.showCanvasMenu = false;
                    if (this.showExtraOptionsMenu) {
                        this.showExtraOptionsMenu = false;
                        this.processExtraOptionsMenu(this.startMenuPos + this.currentMenuPos);
                        break;
                    }
                    if (this.showSwitchViewsMenu) {
                        this.showSwitchViewsMenu = false;
                        this.processSwitchViewsMenu(this.startMenuPos + this.currentMenuPos);
                        break;
                    }
                    this.processMenuCommand(this.startMenuPos + this.currentMenuPos);
                    break;
                }
                if (this.numItems == 0) break;
                if (this.parent.useCanvasMenu) {
                    this.showCanvasMenu = true;
                    break;
                }
                if (keyCode != 525) break;
                this.displayPopupMenu();
                break;
            }
            case 27: {
                this.parent.onBackPressed();
                break;
            }
            case 32: 
            case 84: {
                this.commandAction("Entries");
                break;
            }
            case 78: {
                this.commandAction("New");
                break;
            }
            case 69: {
                this.commandAction("Edit");
                break;
            }
            case 68: {
                this.commandAction("Delete");
                break;
            }
            case 70: {
                this.commandAction("Find");
                break;
            }
            case 83: {
                this.commandAction("Show");
                break;
            }
            case 86: {
                this.commandAction("Switch Views");
                break;
            }
            case 75: {
                this.parent.gsf = new GenericShowForm(this.parent, null, 9);
                this.parent.setContentView(this.parent.gsf);
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.startPos = 0;
                this.currentPos = 0;
                this.currentY = this.lineHeight;
                int n = keyCode - 49;
                if (n > this.as.getNumAccounts() - 1) {
                    Toast.makeText(this.parent, "Too few accounts", 2000).show();
                    break;
                }
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        this.drawDown();
                    }
                }
                this.repaint();
                this.commandAction("Entries");
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

