/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.LongId;
import org.freepoc.Jabp4.NameId;
import org.freepoc.Jabp4.RecordStore;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.TransactionStore;
import org.freepoc.Jabp4.Utilities;

public class AccountStore {
    Jabp parent;
    Hashtable ht;
    Hashtable ht2;
    RecordStore rs;

    public AccountStore(Jabp context, boolean fastDiskAccess) {
        this.parent = context;
        this.ht2 = new Hashtable();
        this.ht = this.parent.accountHt;
        this.openAccountStore(fastDiskAccess);
    }

    void openAccountStore(boolean fastDiskAccess) {
        this.rs = new RecordStore(this.parent, "Accounts", fastDiskAccess);
    }

    void closeAccountStore() {
        if (this.rs != null) {
            this.rs.closeRecordStore();
        }
    }

    Account getAccount(int id) {
        Account a = new Account();
        byte[] bytes = this.rs.getRecord(id);
        a = this.fromByteArray(bytes);
        a.id = id;
        return a;
    }

    void setToStart() {
        this.rs.setToStart();
    }

    Account readNextAccount() {
        Account a = new Account();
        byte[] bytes = this.rs.readRecord();
        if (bytes == null) {
            return null;
        }
        int id = this.rs.getCurrentFilePosition() - bytes.length - 5;
        a = this.fromByteArray(bytes);
        a.id = id;
        return a;
    }

    Account getAccountFromIndex(int i) {
        int id = ((NameId)this.ht.get((Object)new Integer((int)i))).id;
        return this.getAccount(id);
    }

    Account getAccountFromIndex2(int i) {
        int id = ((NameId)this.ht2.get((Object)new Integer((int)i))).id;
        return this.getAccount(id);
    }

    Account getAccountFromName(String string) {
        int n = this.ht.size();
        for (int i = 0; i < n; ++i) {
            String s1 = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!s1.equals(string)) continue;
            int id = ((NameId)this.ht.get((Object)new Integer((int)i))).id;
            return this.getAccount(id);
        }
        Account a = new Account();
        a.name = string;
        a.currency = this.parent.homeCurrency;
        a.type = "Bank";
        a.id = this.saveNewAccount(a);
        if (this.parent.av != null) {
            ++this.parent.av.numItems;
        }
        return a;
    }

    boolean doesAccountNameExist(String name) {
        int n = this.ht.size();
        for (int i = 0; i < n; ++i) {
            String s1 = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!s1.equals(name)) continue;
            return true;
        }
        return false;
    }

    String checkAccountNameFromString(String string) {
        int n = this.ht.size();
        for (int i = 0; i < n; ++i) {
            String s1 = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!s1.toLowerCase().equals(string.toLowerCase())) continue;
            return s1;
        }
        return "";
    }

    byte[] toByteArray(Account a) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeUTF(a.name);
            dos.writeUTF(a.description);
            dos.writeUTF(a.currency);
            dos.writeUTF(a.type);
            dos.writeInt(a.open);
            dos.writeInt(a.current);
            dos.writeInt(a.today);
            dos.writeInt(a.reconciled);
            dos.close();
        }
        catch (IOException ie) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    Account fromByteArray(byte[] bytes) {
        Account a = new Account();
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            a.name = dis.readUTF();
            a.description = dis.readUTF();
            a.currency = dis.readUTF();
            a.type = dis.readUTF();
            a.open = dis.readInt();
            a.current = dis.readInt();
            a.today = dis.readInt();
            a.reconciled = dis.readInt();
            dis.close();
        }
        catch (IOException ie) {
            System.err.println(ie + " as4a");
        }
        return a;
    }

    int getNumAccounts() {
        return this.rs.getNumRecords();
    }

    void deleteAccount(Account a) {
        if (this.rs == null) {
            return;
        }
        this.rs.deleteRecord(a.id);
    }

    int saveNewAccount(Account a) {
        a.id = this.rs.getNextRecordID();
        byte[] bytes = this.toByteArray(a);
        this.rs.addRecord(bytes, 0, bytes.length);
        this.addIndex(a);
        this.parent.transactionHt.put(a.name, new Hashtable());
        return a.id;
    }

    void saveExistingAccount(Account a) {
        if (this.rs == null) {
            return;
        }
        byte[] bytes = this.toByteArray(a);
        this.rs.setRecord(a.id, bytes, 0, bytes.length);
    }

    int lookUpId(Account a) {
        a.id = 0;
        int n = this.ht.size();
        for (int i = 0; i < n; ++i) {
            String string = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!string.equals(a.name)) continue;
            a.id = ((NameId)this.ht.get((Object)new Integer((int)i))).id;
            break;
        }
        return a.id;
    }

    int lookUpIndex(Account a) {
        int n = this.ht.size();
        int j = -1;
        for (int i = 0; i < n; ++i) {
            String string = ((NameId)this.ht.get((Object)new Integer((int)i))).name;
            if (!string.equals(a.name)) continue;
            j = i;
            break;
        }
        return j;
    }

    void deleteIndex(Account a) {
        this.deleteIndex(this.lookUpIndex(a));
    }

    void deleteIndex(int index) {
        int n = this.ht.size();
        for (int i = index; i < n - 1; ++i) {
            int j = i + 1;
            NameId nameId = (NameId)this.ht.get(new Integer(j));
            this.ht.put(new Integer(i), nameId);
        }
        this.ht.remove(new Integer(n - 1));
    }

    void deleteAllIndices() {
        int n = this.ht.size();
        for (int i = 0; i < n; ++i) {
            this.ht.remove(new Integer(i));
        }
    }

    void addIndex(Account a) {
        int i;
        int n;
        int p = n = this.ht.size();
        for (i = 0; i < n; ++i) {
            NameId nameId = (NameId)this.ht.get(new Integer(i));
            if (a.name.compareTo(nameId.name) >= 0) continue;
            p = i;
            break;
        }
        if (p < n) {
            for (i = n - 1; i >= p; --i) {
                int j = i + 1;
                NameId nameId = (NameId)this.ht.get(new Integer(i));
                this.ht.put(new Integer(j), nameId);
            }
        }
        NameId nameId = new NameId(a.name, a.id);
        this.ht.put(new Integer(p), nameId);
    }

    void addIndex2(Account a) {
        int i;
        int n;
        if (this.parent.hideInactiveAccounts && a.type.equals("Inactive")) {
            return;
        }
        int p = n = this.ht2.size();
        for (i = 0; i < n; ++i) {
            NameId nameId = (NameId)this.ht2.get(new Integer(i));
            if (a.name.compareTo(nameId.name) >= 0) continue;
            p = i;
            break;
        }
        if (p < n) {
            for (i = n - 1; i >= p; --i) {
                int j = i + 1;
                NameId nameId = (NameId)this.ht2.get(new Integer(i));
                this.ht2.put(new Integer(j), nameId);
            }
        }
        NameId nameId = new NameId(a.name, a.id);
        this.ht2.put(new Integer(p), nameId);
    }

    void updateTodayBalances() {
        Account a = new Account();
        TransactionStore ts = null;
        if (this.parent.tv == null) {
            ts = new TransactionStore(this.parent, new Account(), true);
        } else {
            ts = this.parent.tv.ts;
            ts.setIndex(this.parent.tv.a);
        }
        int n = this.ht.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                a = this.getAccountFromIndex(i);
                a.today = a.current;
                if (!this.parent.transactionHt.containsKey(a.name)) continue;
                ts.getIndex(a);
                Hashtable ht3 = ts.ht;
                int n3 = ht3.size();
                if (n3 > 0) {
                    for (int j = 0; j < n3; ++j) {
                        long lo;
                        long tDate;
                        int k = j;
                        if (!ts.normalSortOrder) {
                            k = n3 - 1 - j;
                        }
                        if ((tDate = Utilities.longToDays(lo = ((LongId)ht3.get((Object)new Integer((int)k))).lo)) <= this.parent.todayDays) break;
                        int id = ((LongId)ht3.get((Object)new Integer((int)k))).id;
                        Transaction t = ts.getTransaction(id);
                        if (!a.name.equals(t.account)) {
                            System.err.println("Account name mismatch when updating today balances");
                        }
                        a.today -= t.amount;
                    }
                }
                this.saveExistingAccount(a);
            }
        }
        if (this.parent.tv == null) {
            ts.closeTransactionStore();
            ts = null;
        } else {
            this.parent.tv.ts.getIndex(this.parent.tv.a);
        }
        ts = null;
        a = null;
    }

    void setUpAccounts() {
        Account a = new Account();
        a.currency = this.parent.homeCurrency;
        a.name = "MyBank";
        a.type = "Bank";
        this.saveNewAccount(a);
        a.name = "MyCreditCard";
        a.type = "Credit Card";
        this.saveNewAccount(a);
        a.name = "MySavings";
        a.type = "Asset";
        this.saveNewAccount(a);
    }

    int getSize() {
        return this.rs.getSize();
    }
}

