/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.CheckboxGroup;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.Currency;
import org.freepoc.Jabp4.CurrencyStore;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Utilities;

public class AccountForm
extends Component {
    Jabp parent;
    Account a;
    boolean warningMessageDisplayed = false;

    public AccountForm(Jabp context, Account a1, String action) {
        this.parent = context;
        this.a = a1;
        this.parent.lastUsedScreen = 10;
        if (action.equals("New")) {
            this.createAccount(new Account());
        }
        if (action.equals("Edit")) {
            this.updateAccount(this.a);
        }
        if (action.equals("Delete")) {
            this.deleteAccount(this.a);
        }
    }

    void createAccount(Account a) {
        DialogManager dm = new DialogManager(this.parent, "New account");
        JTextField name = dm.addJTextField("Name", a.name);
        JTextField description = dm.addJTextField("Description", a.description);
        JTextField tfOpen = dm.addJTextField("Opening balance", "" + Math.abs(a.open));
        boolean state = false;
        if (a.open > 0) {
            state = true;
        }
        CheckboxGroup debitOrCredit = dm.addCheckboxGroup();
        dm.addCheckboxItem("DR/CR", "DR", !state, "CR", state, debitOrCredit);
        JComboBox currency = dm.addJComboBox("Currency");
        CurrencyStore ccys = null;
        ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
        Currency ccy = null;
        int n = ccys.getNumCurrencies();
        for (int i = 0; i < n; ++i) {
            ccy = ccys.getCurrencyFromIndex(i);
            dm.addJComboBoxItem(currency, ccy.code);
            if (!ccy.code.equals(this.parent.homeCurrency)) continue;
            dm.setSelectedJComboBox(currency, i);
        }
        if (this.parent.ccyv == null) {
            ccys.closeCurrencyStore();
        }
        JComboBox type = dm.addJComboBox("Account Type");
        dm.addJComboBoxItem(type, "Bank");
        dm.addJComboBoxItem(type, "Credit Card");
        dm.addJComboBoxItem(type, "Cash");
        dm.addJComboBoxItem(type, "Asset");
        dm.addJComboBoxItem(type, "Liability");
        dm.addJComboBoxItem(type, "Inactive");
        JTextField specialType = dm.addJTextField("Special Type", "");
        dm.addButton("Cancel");
        dm.addButton("Create");
        dm.centerShow();
        if (!dm.checkButtons()) {
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            dm.dispose();
            return;
        }
        String s = dm.getUserText(name).trim();
        if (s.equals("")) {
            Toast.makeText(this.parent, "Blank account name", 2000).show();
            dm.dispose();
            this.createAccount(a);
            return;
        }
        a.name = s;
        if (this.parent.av.as.lookUpId(a) != 0) {
            Toast.makeText(this.parent, s + " already exists", 2000).show();
            dm.dispose();
            this.createAccount(a);
            return;
        }
        a.description = dm.getUserText(description).trim();
        this.checkForNumericInputType(dm.getUserText(tfOpen));
        a.open = this.parent.numericEntry ? Utilities.stringToNumber(dm.getUserText(tfOpen), 0, true, this.parent.isEuropeanNumberFormat) : Utilities.expressionToNumber(dm.getUserText(tfOpen), this.parent.isEuropeanNumberFormat);
        if (dm.getSelectedCheckbox(debitOrCredit).getLabel().equals("DR")) {
            a.open = -a.open;
        }
        a.currency = dm.getSelectedJComboBoxString(currency);
        if (!a.currency.equals(this.parent.homeCurrency)) {
            ccys = null;
            ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
            ccy = ccys.getCurrencyFromName(a.currency);
            a.open = Utilities.foreignToHome(a.open, ccy.rate);
            ccy = null;
            if (this.parent.ccyv == null) {
                ccys.closeCurrencyStore();
                ccys = null;
            }
        }
        a.today = a.reconciled = a.open;
        a.current = a.reconciled;
        int i = dm.getSelectedJComboBoxItem(type);
        if (i == 0) {
            a.type = "Bank";
        }
        if (i == 1) {
            a.type = "Credit Card";
        }
        if (i == 2) {
            a.type = "Cash";
        }
        if (i == 3) {
            a.type = "Asset";
        }
        if (i == 4) {
            a.type = "Liability";
        }
        if (i == 5) {
            a.type = "Inactive";
        }
        if (!(s = dm.getUserText(specialType)).equals("")) {
            a.type = s;
        }
        this.parent.av.newAccount(a);
        Toast.makeText(this.parent, a.name + " created", 1000).show();
        dm.dispose();
    }

    void updateAccount(Account a) {
        DialogManager dm = new DialogManager(this.parent, "Edit account");
        JTextField name = dm.addJTextField("Name", a.name);
        JTextField description = dm.addJTextField("Description", a.description);
        String s = "Opening balance";
        if (!a.currency.equals(this.parent.homeCurrency)) {
            s = s + " in " + this.parent.homeCurrency;
        }
        JTextField tfOpen = dm.addJTextField(s, Utilities.numberToString(Math.abs(a.open), this.parent.numericEntry, this.parent.isEuropeanNumberFormat, false));
        boolean state = false;
        if (a.open > 0) {
            state = true;
        }
        CheckboxGroup debitOrCredit = dm.addCheckboxGroup();
        dm.addCheckboxItem("DR/CR", "DR", !state, "CR", state, debitOrCredit);
        JComboBox currency = dm.addJComboBox("Currency");
        CurrencyStore ccys = null;
        ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
        Currency ccy = null;
        int n = ccys.getNumCurrencies();
        for (int i = 0; i < n; ++i) {
            ccy = ccys.getCurrencyFromIndex(i);
            dm.addJComboBoxItem(currency, ccy.code);
            if (!ccy.code.equals(a.currency)) continue;
            dm.setSelectedJComboBox(currency, i);
        }
        if (this.parent.ccyv == null) {
            ccys.closeCurrencyStore();
        }
        JComboBox type = dm.addJComboBox("Account Type");
        dm.addJComboBoxItem(type, "Bank");
        dm.addJComboBoxItem(type, "Credit Card");
        dm.addJComboBoxItem(type, "Cash");
        dm.addJComboBoxItem(type, "Asset");
        dm.addJComboBoxItem(type, "Liability");
        dm.addJComboBoxItem(type, "Inactive");
        boolean flag = false;
        if (a.type.equals("Bank")) {
            dm.setSelectedJComboBox(type, 0);
            flag = true;
        }
        if (a.type.equals("Credit Card")) {
            dm.setSelectedJComboBox(type, 1);
            flag = true;
        }
        if (a.type.equals("Cash")) {
            dm.setSelectedJComboBox(type, 2);
            flag = true;
        }
        if (a.type.equals("Asset")) {
            dm.setSelectedJComboBox(type, 3);
            flag = true;
        }
        if (a.type.equals("Liability")) {
            dm.setSelectedJComboBox(type, 4);
            flag = true;
        }
        if (a.type.equals("Inactive")) {
            dm.setSelectedJComboBox(type, 5);
            flag = true;
        }
        if (!flag) {
            dm.addJComboBoxItem(type, a.type);
            dm.setSelectedJComboBox(type, 6);
        }
        JTextField specialType = dm.addJTextField("Special Type", "");
        dm.addButton("Cancel");
        dm.addButton("Update");
        dm.centerShow();
        if (!dm.checkButtons()) {
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            dm.dispose();
            return;
        }
        String oldName = a.name;
        String newName = dm.getUserText(name).trim();
        if (newName.equals("")) {
            Toast.makeText(this.parent, "Blank account name", 2000).show();
            dm.dispose();
            this.updateAccount(a);
            return;
        }
        a.name = newName;
        int k = a.id;
        if (!oldName.equals(newName) && this.parent.av.as.lookUpId(a) != 0) {
            Toast.makeText(this.parent, newName + " already exists", 2000).show();
            a.name = oldName;
            dm.dispose();
            this.updateAccount(a);
            return;
        }
        a.id = k;
        a.description = dm.getUserText(description).trim();
        int i = a.open;
        this.checkForNumericInputType(dm.getUserText(tfOpen));
        a.open = this.parent.numericEntry ? Utilities.stringToNumber(dm.getUserText(tfOpen), 0, true, this.parent.isEuropeanNumberFormat) : Utilities.expressionToNumber(dm.getUserText(tfOpen), this.parent.isEuropeanNumberFormat);
        if (dm.getSelectedCheckbox(debitOrCredit).getLabel().equals("DR")) {
            a.open = -a.open;
        }
        a.current += a.open - i;
        a.today += a.open - i;
        a.reconciled += a.open - i;
        a.currency = dm.getSelectedJComboBoxString(currency);
        i = dm.getSelectedJComboBoxItem(type);
        if (i == 0) {
            a.type = "Bank";
        }
        if (i == 1) {
            a.type = "Credit Card";
        }
        if (i == 2) {
            a.type = "Cash";
        }
        if (i == 3) {
            a.type = "Asset";
        }
        if (i == 4) {
            a.type = "Liability";
        }
        if (i == 5) {
            a.type = "Inactive";
        }
        if (!(s = dm.getUserText(specialType)).equals("")) {
            a.type = s;
        }
        this.parent.av.editAccount(a);
        Toast.makeText(this.parent, a.name + " updated", 1000).show();
        dm.dispose();
    }

    void deleteAccount(Account a) {
        DialogManager dm = new DialogManager(this.parent, "Delete account");
        JTextField name = dm.addJTextField("Name", a.name);
        JTextField description = dm.addJTextField("Description", a.description);
        String s = "Opening balance";
        if (!a.currency.equals(this.parent.homeCurrency)) {
            s = s + " in " + this.parent.homeCurrency;
        }
        JTextField tfOpen = dm.addJTextField(s, Utilities.numberToString(Math.abs(a.open), this.parent.numericEntry, this.parent.isEuropeanNumberFormat, false));
        boolean state = false;
        if (a.open > 0) {
            state = true;
        }
        CheckboxGroup debitOrCredit = dm.addCheckboxGroup();
        dm.addCheckboxItem("DR/CR", "DR", !state, "CR", state, debitOrCredit);
        JComboBox currency = dm.addJComboBox("Currency");
        CurrencyStore ccys = null;
        ccys = this.parent.ccyv == null ? new CurrencyStore(this.parent, true) : this.parent.ccyv.ccys;
        Currency ccy = null;
        int n = ccys.getNumCurrencies();
        for (int i = 0; i < n; ++i) {
            ccy = ccys.getCurrencyFromIndex(i);
            dm.addJComboBoxItem(currency, ccy.code);
            if (!ccy.code.equals(a.currency)) continue;
            dm.setSelectedJComboBox(currency, i);
        }
        if (this.parent.ccyv == null) {
            ccys.closeCurrencyStore();
        }
        JComboBox type = dm.addJComboBox("Account Type");
        dm.addJComboBoxItem(type, "Bank");
        dm.addJComboBoxItem(type, "Credit Card");
        dm.addJComboBoxItem(type, "Cash");
        dm.addJComboBoxItem(type, "Asset");
        dm.addJComboBoxItem(type, "Liability");
        dm.addJComboBoxItem(type, "Inactive");
        boolean flag = false;
        if (a.type.equals("Bank")) {
            dm.setSelectedJComboBox(type, 0);
            flag = true;
        }
        if (a.type.equals("Credit Card")) {
            dm.setSelectedJComboBox(type, 1);
            flag = true;
        }
        if (a.type.equals("Cash")) {
            dm.setSelectedJComboBox(type, 2);
            flag = true;
        }
        if (a.type.equals("Asset")) {
            dm.setSelectedJComboBox(type, 3);
            flag = true;
        }
        if (a.type.equals("Liability")) {
            dm.setSelectedJComboBox(type, 4);
            flag = true;
        }
        if (a.type.equals("Inactive")) {
            dm.setSelectedJComboBox(type, 5);
            flag = true;
        }
        if (!flag) {
            dm.addJComboBoxItem(type, a.type);
            dm.setSelectedJComboBox(type, 6);
        }
        dm.addButton("Cancel");
        dm.addButton("Delete");
        dm.centerShow();
        if (!dm.checkButtons()) {
            Toast.makeText(this.parent, "Cancelled", 1000).show();
            dm.dispose();
            return;
        }
        if (!this.warningMessageDisplayed) {
            Toast.makeText(this.parent, "Any transactions or standing orders\nfor  " + a.name + " will be deleted\nClick delete to proceed", 2000).show();
            this.warningMessageDisplayed = true;
            this.deleteAccount(a);
            return;
        }
        this.parent.av.deleteAccount(a);
        Toast.makeText(this.parent, a.name + " deleted", 1000).show();
    }

    void checkForNumericInputType(String s) {
        if (s.contains(".")) {
            this.parent.numericEntry = false;
            this.parent.isEuropeanNumberFormat = false;
        }
        if (s.contains(",")) {
            this.parent.numericEntry = false;
            this.parent.isEuropeanNumberFormat = true;
        }
    }
}

