/*
 * Decompiled with CFR 0.152.
 */
package org.freepoc.Jabp4;

import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Frame;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JTextField;
import org.freepoc.Jabp4.Account;
import org.freepoc.Jabp4.AccountStore;
import org.freepoc.Jabp4.DateChooser;
import org.freepoc.Jabp4.DialogManager;
import org.freepoc.Jabp4.Jabp;
import org.freepoc.Jabp4.LongId;
import org.freepoc.Jabp4.Toast;
import org.freepoc.Jabp4.Transaction;
import org.freepoc.Jabp4.TransactionStore;
import org.freepoc.Jabp4.Utilities;

public class AccountBalancesByMonthForm
extends Component
implements Runnable {
    Jabp parent;
    Thread thread;
    Date fromDate;
    Date toDate;
    Calendar cFrom;
    Calendar cTo;
    long ldFrom = 0L;
    long ldTo = 0L;
    long lFrom;
    long lTo;
    int previousLastUsedScreen = 0;
    boolean useAllAccounts = true;
    boolean goAheadAndShowResults = false;
    Vector selectedAccounts;
    int[] totals;

    public AccountBalancesByMonthForm(Jabp context) {
        this.parent = context;
        this.previousLastUsedScreen = this.parent.lastUsedScreen;
        this.parent.lastUsedScreen = 41;
        this.cFrom = new GregorianCalendar();
        this.cTo = new GregorianCalendar();
        this.setFromAndToDates();
        this.createAccountBalancesByMonthForm();
    }

    void createAccountBalancesByMonthForm() {
        int i;
        DialogManager dm = new DialogManager(this.parent, "Account Balances By Month");
        Date date = new Date();
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf2 = null;
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf2 = new SimpleDateFormat("dd/MM/yy HH");
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            sdf = new SimpleDateFormat("MM/dd/yyyy");
            sdf2 = new SimpleDateFormat("MM/dd/yy HH");
        }
        JTextField tfFromDate = dm.addJTextFieldWithButton("From date", sdf.format(this.fromDate), "1>");
        JTextField tfToDate = dm.addJTextFieldWithButton("To date", sdf.format(this.toDate), "2>");
        boolean state = true;
        if (this.previousLastUsedScreen == 1 || this.parent.lastFindSelectedAccounts != null) {
            state = false;
        }
        CheckboxGroup cbAccounts = dm.addCheckboxGroup();
        dm.addCheckboxItem("Accounts", "All", state, "Selected", !state, cbAccounts);
        JList JListAccounts = dm.addJList("Account");
        AccountStore as = null;
        as = this.parent.av == null ? new AccountStore(this.parent, true) : this.parent.av.as;
        Account a = null;
        int n = as.getNumAccounts();
        for (i = 0; i < n; ++i) {
            a = as.getAccountFromIndex(i);
            dm.addJListItem(JListAccounts, a.name);
        }
        if (this.parent.av == null) {
            as.closeAccountStore();
        }
        dm.addOKCancelButtons();
        dm.centerShow();
        if (dm.checkButtons()) {
            try {
                this.fromDate = sdf2.parse(dm.getUserText(tfFromDate) + " 02");
            }
            catch (ParseException e) {
                Toast.makeText(this.parent, "Incorrect date", 2000).show();
                dm.dispose();
                new AccountBalancesByMonthForm(this.parent);
                return;
            }
            try {
                this.toDate = sdf2.parse(dm.getUserText(tfToDate) + " 02");
            }
            catch (ParseException e) {
                Toast.makeText(this.parent, "Incorrect date", 2000).show();
                dm.dispose();
                new AccountBalancesByMonthForm(this.parent);
                return;
            }
            if (dm.getSelectedCheckbox(cbAccounts).getLabel().equals("All")) {
                this.useAllAccounts = true;
            } else {
                this.selectedAccounts = new Vector();
                for (i = 0; i < n; ++i) {
                    if (!dm.isJListIndexSelected(JListAccounts, i)) continue;
                    this.selectedAccounts.addElement(dm.getSelectedJListString(JListAccounts, i));
                    this.useAllAccounts = false;
                }
                if (this.selectedAccounts.size() == 0) {
                    this.selectedAccounts = null;
                    this.useAllAccounts = true;
                }
            }
            if (dm.checkButtonText().equals("1>")) {
                GregorianCalendar gc = new GregorianCalendar();
                gc.setTime(this.parent.lastFindFromDate);
                DateChooser dc = new DateChooser((Frame)this.parent, gc);
                if (dc.showDateChooser() == 1) {
                    gc = dc.getDate();
                }
                this.fromDate = gc.getTime();
                dm.dispose();
                new AccountBalancesByMonthForm(this.parent);
                return;
            }
            if (dm.checkButtonText().equals("2>")) {
                GregorianCalendar gc = new GregorianCalendar();
                gc.setTime(this.parent.lastFindToDate);
                DateChooser dc = new DateChooser((Frame)this.parent, gc);
                if (dc.showDateChooser() == 1) {
                    gc = dc.getDate();
                }
                this.toDate = gc.getTime();
                dm.dispose();
                new AccountBalancesByMonthForm(this.parent);
                return;
            }
            dm.dispose();
            int nMonths = this.monthsBetweenDates(this.fromDate, this.toDate) + 1;
            if (nMonths < 2) {
                Toast.makeText(this.parent, "Time period is too short", 2000).show();
                this.parent.setContentView(this.parent.av);
                return;
            }
            this.totals = new int[nMonths];
            this.lFrom = this.fromDate.getTime();
            this.lTo = this.toDate.getTime();
            this.ldFrom = Utilities.longToDays(this.fromDate.getTime());
            this.ldTo = Utilities.longToDays(this.toDate.getTime());
            as = this.parent.av == null ? new AccountStore(this.parent, true) : this.parent.av.as;
            n = as.getNumAccounts();
            for (int i2 = 0; i2 < n; ++i2) {
                a = as.getAccountFromIndex(i2);
                if (!this.useAllAccounts && !this.selectedAccounts.contains(a.name)) continue;
                this.totals[0] = this.totals[0] + a.open;
            }
            if (this.parent.av == null) {
                as.closeAccountStore();
            }
            this.parent.setContentView(this.parent.av);
            this.run();
            return;
        }
        dm.dispose();
    }

    void runThread() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        this.execute();
    }

    void execute() {
        this.parent.busyWithProcess = true;
        TransactionStore ts = null;
        ts = this.parent.tv == null ? new TransactionStore(this.parent, new Account(), true) : this.parent.tv.ts;
        Transaction t = null;
        ts.setToStart();
        int count = 0;
        while ((t = ts.readNextTransaction()) != null) {
            if (++count == count / 1000 * 1000) {
                this.showInAccountView(count + " transactions read...");
            }
            if (!this.useAllAccounts && !this.selectedAccounts.contains(t.account)) continue;
            long tldate = Utilities.longToDays(t.longDate);
            if (tldate < this.ldFrom) {
                this.totals[0] = this.totals[0] + t.amount;
                continue;
            }
            if (tldate > this.ldTo) continue;
            int n = this.monthsBetweenDates(this.lFrom, t.longDate);
            this.totals[n] = this.totals[n] + t.amount;
        }
        if (this.parent.tv == null) {
            ts.closeTransactionStore();
            ts = null;
        }
        this.showInAccountView("");
        this.parent.busyWithProcess = false;
        this.goAheadAndShowResults = true;
    }

    int monthsBetweenDates(Date dFrom, Date dTo) {
        this.cFrom.setTime(dFrom);
        this.cTo.setTime(dTo);
        return (this.cTo.get(1) - this.cFrom.get(1)) * 12 + this.cTo.get(2) - this.cFrom.get(2);
    }

    int monthsBetweenDates(long lFrom, long lTo) {
        this.cFrom.setTimeInMillis(lFrom);
        this.cTo.setTimeInMillis(lTo);
        return (this.cTo.get(1) - this.cFrom.get(1)) * 12 + this.cTo.get(2) - this.cFrom.get(2);
    }

    boolean isEndDateLastDayOfMonth() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(this.lTo);
        int m1 = cal.get(2);
        ((Calendar)cal).add(5, 1);
        int m2 = cal.get(2);
        return m2 > m1;
    }

    void setFromAndToDates() {
        long longFromDate = new Date().getTime();
        long longToDate = 0L;
        Enumeration e = this.parent.transactionHt.elements();
        while (e.hasMoreElements()) {
            Hashtable ht = (Hashtable)e.nextElement();
            int n = ht.size();
            if (n <= 0) continue;
            if (((LongId)ht.get((Object)new Integer((int)0))).lo < ((LongId)ht.get((Object)new Integer((int)(n - 1)))).lo) {
                longFromDate = Math.min(longFromDate, ((LongId)ht.get((Object)new Integer((int)0))).lo);
                longToDate = Math.max(longToDate, ((LongId)ht.get((Object)new Integer((int)(n - 1)))).lo);
                continue;
            }
            longFromDate = Math.min(longFromDate, ((LongId)ht.get((Object)new Integer((int)(n - 1)))).lo);
            longToDate = Math.max(longToDate, ((LongId)ht.get((Object)new Integer((int)0))).lo);
        }
        this.fromDate = new Date(longFromDate);
        this.toDate = new Date(longToDate);
    }

    void showInAccountView(String s1) {
        this.parent.av.show(s1, false);
    }
}

