/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2;

import com.dropbox.core.BadResponseException;
import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxHost;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.DbxWrappedException;
import com.dropbox.core.InvalidAccessTokenException;
import com.dropbox.core.NetworkIOException;
import com.dropbox.core.RetryException;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.oauth.DbxOAuthException;
import com.dropbox.core.oauth.DbxRefreshResult;
import com.dropbox.core.stone.StoneSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.auth.AuthError;
import com.dropbox.core.v2.common.PathRoot;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public abstract class DbxRawClientV2 {
    public static final String USER_AGENT_ID = "OfficialDropboxJavaSDKv2";
    private static final JsonFactory JSON = new JsonFactory();
    private static final Random RAND = new Random();
    private final DbxRequestConfig requestConfig;
    private final DbxHost host;
    private final String userId;
    private final PathRoot pathRoot;

    protected DbxRawClientV2(DbxRequestConfig requestConfig, DbxHost host, String userId, PathRoot pathRoot) {
        if (requestConfig == null) {
            throw new NullPointerException("requestConfig");
        }
        if (host == null) {
            throw new NullPointerException("host");
        }
        this.requestConfig = requestConfig;
        this.host = host;
        this.userId = userId;
        this.pathRoot = pathRoot;
    }

    protected abstract void addAuthHeaders(List<HttpRequestor.Header> var1);

    public abstract DbxRefreshResult refreshAccessToken() throws DbxException;

    protected abstract boolean canRefreshAccessToken();

    protected abstract boolean needsRefreshAccessToken();

    private void refreshAccessTokenIfNeeded() throws DbxException {
        block3: {
            if (this.needsRefreshAccessToken()) {
                try {
                    this.refreshAccessToken();
                }
                catch (DbxOAuthException e) {
                    if ("invalid_grant".equals(e.getDbxOAuthError().getError())) break block3;
                    throw e;
                }
            }
        }
    }

    protected abstract DbxRawClientV2 withPathRoot(PathRoot var1);

    public <ArgT, ResT, ErrT> ResT rpcStyle(final String host, final String path, ArgT arg, final boolean noAuth, StoneSerializer<ArgT> argSerializer, final StoneSerializer<ResT> responseSerializer, final StoneSerializer<ErrT> errorSerializer) throws DbxWrappedException, DbxException {
        final byte[] body = DbxRawClientV2.writeAsBytes(argSerializer, arg);
        final ArrayList<HttpRequestor.Header> headers = new ArrayList<HttpRequestor.Header>();
        if (!noAuth) {
            this.refreshAccessTokenIfNeeded();
        }
        if (!this.host.getNotify().equals(host)) {
            DbxRequestUtil.addUserLocaleHeader(headers, this.requestConfig);
            DbxRequestUtil.addPathRootHeader(headers, this.pathRoot);
        }
        headers.add(new HttpRequestor.Header("Content-Type", "application/json; charset=utf-8"));
        return (ResT)this.executeRetriableWithRefresh(this.requestConfig.getMaxRetries(), (new RetriableExecution<ResT>(){
            private String userIdAnon;

            @Override
            public ResT execute() throws DbxWrappedException, DbxException {
                if (!noAuth) {
                    DbxRawClientV2.this.addAuthHeaders(headers);
                }
                HttpRequestor.Response response = DbxRequestUtil.startPostRaw(DbxRawClientV2.this.requestConfig, DbxRawClientV2.USER_AGENT_ID, host, path, body, headers);
                try {
                    switch (response.getStatusCode()) {
                        case 200: {
                            return responseSerializer.deserialize(response.getBody());
                        }
                        case 409: {
                            throw DbxWrappedException.fromResponse(errorSerializer, response, this.userIdAnon);
                        }
                    }
                    throw DbxRequestUtil.unexpectedStatus(response, this.userIdAnon);
                }
                catch (JsonProcessingException ex) {
                    String requestId = DbxRequestUtil.getRequestId(response);
                    throw new BadResponseException(requestId, "Bad JSON: " + ex.getMessage(), ex);
                }
                catch (IOException ex) {
                    throw new NetworkIOException(ex);
                }
            }

            private RetriableExecution<ResT> init(String userId) {
                this.userIdAnon = userId;
                return this;
            }
        }).init(this.userId));
    }

    public <ArgT, ResT, ErrT> DbxDownloader<ResT> downloadStyle(final String host, final String path, ArgT arg, final boolean noAuth, List<HttpRequestor.Header> extraHeaders, StoneSerializer<ArgT> argSerializer, final StoneSerializer<ResT> responseSerializer, final StoneSerializer<ErrT> errorSerializer) throws DbxWrappedException, DbxException {
        final ArrayList<HttpRequestor.Header> headers = new ArrayList<HttpRequestor.Header>(extraHeaders);
        if (!noAuth) {
            this.refreshAccessTokenIfNeeded();
        }
        DbxRequestUtil.addUserLocaleHeader(headers, this.requestConfig);
        DbxRequestUtil.addPathRootHeader(headers, this.pathRoot);
        headers.add(new HttpRequestor.Header("Dropbox-API-Arg", DbxRawClientV2.headerSafeJson(argSerializer, arg)));
        headers.add(new HttpRequestor.Header("Content-Type", ""));
        final byte[] body = new byte[]{};
        return (DbxDownloader)this.executeRetriableWithRefresh(this.requestConfig.getMaxRetries(), (new RetriableExecution<DbxDownloader<ResT>>(){
            private String userIdAnon;

            @Override
            public DbxDownloader<ResT> execute() throws DbxWrappedException, DbxException {
                if (!noAuth) {
                    DbxRawClientV2.this.addAuthHeaders(headers);
                }
                HttpRequestor.Response response = DbxRequestUtil.startPostRaw(DbxRawClientV2.this.requestConfig, DbxRawClientV2.USER_AGENT_ID, host, path, body, headers);
                String requestId = DbxRequestUtil.getRequestId(response);
                String contentType = DbxRequestUtil.getContentType(response);
                try {
                    switch (response.getStatusCode()) {
                        case 200: 
                        case 206: {
                            List<String> resultHeaders = response.getHeaders().get("dropbox-api-result");
                            if (resultHeaders == null) {
                                throw new BadResponseException(requestId, "Missing Dropbox-API-Result header; " + response.getHeaders());
                            }
                            if (resultHeaders.size() == 0) {
                                throw new BadResponseException(requestId, "No Dropbox-API-Result header; " + response.getHeaders());
                            }
                            String resultHeader = resultHeaders.get(0);
                            if (resultHeader == null) {
                                throw new BadResponseException(requestId, "Null Dropbox-API-Result header; " + response.getHeaders());
                            }
                            Object result = responseSerializer.deserialize(resultHeader);
                            return new DbxDownloader(result, response.getBody(), contentType);
                        }
                        case 409: {
                            throw DbxWrappedException.fromResponse(errorSerializer, response, this.userIdAnon);
                        }
                    }
                    throw DbxRequestUtil.unexpectedStatus(response, this.userIdAnon);
                }
                catch (JsonProcessingException ex) {
                    throw new BadResponseException(requestId, "Bad JSON: " + ex.getMessage(), ex);
                }
                catch (IOException ex) {
                    throw new NetworkIOException(ex);
                }
            }

            private RetriableExecution<DbxDownloader<ResT>> init(String userId) {
                this.userIdAnon = userId;
                return this;
            }
        }).init(this.userId));
    }

    private static <T> byte[] writeAsBytes(StoneSerializer<T> serializer, T arg) throws DbxException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            serializer.serialize(arg, out);
        }
        catch (IOException ex) {
            throw LangUtil.mkAssert("Impossible", ex);
        }
        return out.toByteArray();
    }

    private static <T> String headerSafeJson(StoneSerializer<T> serializer, T value) {
        StringWriter out = new StringWriter();
        try {
            JsonGenerator g = JSON.createGenerator(out);
            g.setHighestNonEscapedChar(126);
            serializer.serialize(value, g);
            g.flush();
        }
        catch (IOException ex) {
            throw LangUtil.mkAssert("Impossible", ex);
        }
        return out.toString();
    }

    public <ArgT> HttpRequestor.Uploader uploadStyle(String host, String path, ArgT arg, boolean noAuth, StoneSerializer<ArgT> argSerializer) throws DbxException {
        String uri = DbxRequestUtil.buildUri(host, path);
        List<HttpRequestor.Header> headers = new ArrayList<HttpRequestor.Header>();
        if (!noAuth) {
            this.refreshAccessTokenIfNeeded();
            this.addAuthHeaders(headers);
        }
        DbxRequestUtil.addUserLocaleHeader(headers, this.requestConfig);
        DbxRequestUtil.addPathRootHeader(headers, this.pathRoot);
        headers.add(new HttpRequestor.Header("Content-Type", "application/octet-stream"));
        headers = DbxRequestUtil.addUserAgentHeader(headers, this.requestConfig, USER_AGENT_ID);
        headers.add(new HttpRequestor.Header("Dropbox-API-Arg", DbxRawClientV2.headerSafeJson(argSerializer, arg)));
        try {
            return this.requestConfig.getHttpRequestor().startPostInStreamingMode(uri, headers);
        }
        catch (IOException ex) {
            throw new NetworkIOException(ex);
        }
    }

    public DbxRequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public DbxHost getHost() {
        return this.host;
    }

    public String getUserId() {
        return this.userId;
    }

    private static <T> T executeRetriable(int maxRetries, RetriableExecution<T> execution) throws DbxWrappedException, DbxException {
        if (maxRetries == 0) {
            return execution.execute();
        }
        int retries = 0;
        while (true) {
            try {
                return execution.execute();
            }
            catch (RetryException ex) {
                if (retries < maxRetries) {
                    ++retries;
                    DbxRawClientV2.sleepQuietlyWithJitter(ex.getBackoffMillis());
                    continue;
                }
                throw ex;
            }
            break;
        }
    }

    private <T> T executeRetriableWithRefresh(int maxRetries, RetriableExecution<T> execution) throws DbxWrappedException, DbxException {
        try {
            return DbxRawClientV2.executeRetriable(maxRetries, execution);
        }
        catch (InvalidAccessTokenException ex) {
            if (ex.getMessage() == null) {
                throw ex;
            }
            AuthError authError = ex.getAuthError();
            if (AuthError.EXPIRED_ACCESS_TOKEN.equals(authError) && this.canRefreshAccessToken()) {
                this.refreshAccessToken();
                return DbxRawClientV2.executeRetriable(maxRetries, execution);
            }
            throw ex;
        }
    }

    private static void sleepQuietlyWithJitter(long millis) {
        long jitter = RAND.nextInt(1000);
        long sleepMillis = millis + jitter;
        if (sleepMillis <= 0L) {
            return;
        }
        try {
            Thread.sleep(sleepMillis);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private static interface RetriableExecution<T> {
        public T execute() throws DbxWrappedException, DbxException;
    }
}

