/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.json;

import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.util.IOUtil;
import com.dropbox.core.util.LangUtil;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public abstract class JsonReader<T> {
    public static final JsonReader<Long> UnsignedLongReader = new JsonReader<Long>(){

        @Override
        public Long read(JsonParser parser) throws IOException, JsonReadException {
            return 1.readUnsignedLong(parser);
        }
    };
    public static final JsonReader<Long> Int64Reader = new JsonReader<Long>(){

        @Override
        public Long read(JsonParser parser) throws IOException, JsonReadException {
            long v = parser.getLongValue();
            parser.nextToken();
            return v;
        }
    };
    public static final JsonReader<Integer> Int32Reader = new JsonReader<Integer>(){

        @Override
        public Integer read(JsonParser parser) throws IOException, JsonReadException {
            int v = parser.getIntValue();
            parser.nextToken();
            return v;
        }
    };
    public static final JsonReader<Long> UInt64Reader = new JsonReader<Long>(){

        @Override
        public Long read(JsonParser parser) throws IOException, JsonReadException {
            return 4.readUnsignedLong(parser);
        }
    };
    public static final JsonReader<Long> UInt32Reader = new JsonReader<Long>(){

        @Override
        public Long read(JsonParser parser) throws IOException, JsonReadException {
            long v = 5.readUnsignedLong(parser);
            if (v >= 0x100000000L) {
                throw new JsonReadException("expecting a 32-bit unsigned integer, got: " + v, parser.getTokenLocation());
            }
            return v;
        }
    };
    public static final JsonReader<Double> Float64Reader = new JsonReader<Double>(){

        @Override
        public Double read(JsonParser parser) throws IOException, JsonReadException {
            double v = parser.getDoubleValue();
            parser.nextToken();
            return v;
        }
    };
    public static final JsonReader<Float> Float32Reader = new JsonReader<Float>(){

        @Override
        public Float read(JsonParser parser) throws IOException, JsonReadException {
            float v = parser.getFloatValue();
            parser.nextToken();
            return Float.valueOf(v);
        }
    };
    public static final JsonReader<String> StringReader = new JsonReader<String>(){

        @Override
        public String read(JsonParser parser) throws IOException, JsonReadException {
            try {
                String v = parser.getText();
                parser.nextToken();
                return v;
            }
            catch (JsonParseException ex) {
                throw JsonReadException.fromJackson(ex);
            }
        }
    };
    public static final JsonReader<byte[]> BinaryReader = new JsonReader<byte[]>(){

        @Override
        public byte[] read(JsonParser parser) throws IOException, JsonReadException {
            try {
                byte[] v = parser.getBinaryValue();
                parser.nextToken();
                return v;
            }
            catch (JsonParseException ex) {
                throw JsonReadException.fromJackson(ex);
            }
        }
    };
    public static final JsonReader<Boolean> BooleanReader = new JsonReader<Boolean>(){

        @Override
        public Boolean read(JsonParser parser) throws IOException, JsonReadException {
            return 10.readBoolean(parser);
        }
    };
    public static final JsonReader<Object> VoidReader = new JsonReader<Object>(){

        @Override
        public Object read(JsonParser parser) throws IOException, JsonReadException {
            11.skipValue(parser);
            return null;
        }
    };
    static final JsonFactory jsonFactory = new JsonFactory();

    public abstract T read(JsonParser var1) throws IOException, JsonReadException;

    public T readFromTags(String[] tags, JsonParser parser) throws IOException, JsonReadException {
        return null;
    }

    public T readFields(JsonParser parser) throws IOException, JsonReadException {
        return null;
    }

    public void validate(T value) {
    }

    public final T readField(JsonParser parser, String fieldName, Object v) throws IOException, JsonReadException {
        if (v != null) {
            throw new JsonReadException("duplicate field \"" + fieldName + "\"", parser.getTokenLocation());
        }
        return this.read(parser);
    }

    public final T readOptional(JsonParser parser) throws IOException, JsonReadException {
        if (parser.getCurrentToken() == JsonToken.VALUE_NULL) {
            parser.nextToken();
            return null;
        }
        return this.read(parser);
    }

    public static String[] readTags(JsonParser parser) throws IOException, JsonReadException {
        if (parser.getCurrentToken() != JsonToken.FIELD_NAME) {
            return null;
        }
        if (!".tag".equals(parser.getCurrentName())) {
            return null;
        }
        parser.nextToken();
        if (parser.getCurrentToken() != JsonToken.VALUE_STRING) {
            throw new JsonReadException("expected a string value for .tag field", parser.getTokenLocation());
        }
        String tag = parser.getText();
        parser.nextToken();
        return tag.split("\\.");
    }

    public static JsonToken nextToken(JsonParser parser) throws IOException, JsonReadException {
        try {
            return parser.nextToken();
        }
        catch (JsonParseException ex) {
            throw JsonReadException.fromJackson(ex);
        }
    }

    public static JsonLocation expectObjectStart(JsonParser parser) throws IOException, JsonReadException {
        if (parser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new JsonReadException("expecting the start of an object (\"{\")", parser.getTokenLocation());
        }
        JsonLocation loc = parser.getTokenLocation();
        JsonReader.nextToken(parser);
        return loc;
    }

    public static void expectObjectEnd(JsonParser parser) throws IOException, JsonReadException {
        if (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            throw new JsonReadException("expecting the end of an object (\"}\")", parser.getTokenLocation());
        }
        JsonReader.nextToken(parser);
    }

    public static JsonLocation expectArrayStart(JsonParser parser) throws IOException, JsonReadException {
        if (parser.getCurrentToken() != JsonToken.START_ARRAY) {
            throw new JsonReadException("expecting the start of an array (\"[\")", parser.getTokenLocation());
        }
        JsonLocation loc = parser.getTokenLocation();
        JsonReader.nextToken(parser);
        return loc;
    }

    public static JsonLocation expectArrayEnd(JsonParser parser) throws IOException, JsonReadException {
        if (parser.getCurrentToken() != JsonToken.END_ARRAY) {
            throw new JsonReadException("expecting the end of an array (\"[\")", parser.getTokenLocation());
        }
        JsonLocation loc = parser.getTokenLocation();
        JsonReader.nextToken(parser);
        return loc;
    }

    public static boolean isArrayEnd(JsonParser parser) {
        return parser.getCurrentToken() == JsonToken.END_ARRAY;
    }

    public static boolean isArrayStart(JsonParser parser) {
        return parser.getCurrentToken() == JsonToken.START_ARRAY;
    }

    public static void skipValue(JsonParser parser) throws IOException, JsonReadException {
        try {
            parser.skipChildren();
            parser.nextToken();
        }
        catch (JsonParseException ex) {
            throw JsonReadException.fromJackson(ex);
        }
    }

    public static long readUnsignedLong(JsonParser parser) throws IOException, JsonReadException {
        try {
            long v = parser.getLongValue();
            if (v < 0L) {
                throw new JsonReadException("expecting a non-negative number, got: " + v, parser.getTokenLocation());
            }
            parser.nextToken();
            return v;
        }
        catch (JsonParseException ex) {
            throw JsonReadException.fromJackson(ex);
        }
    }

    public static long readUnsignedLongField(JsonParser parser, String fieldName, long v) throws IOException, JsonReadException {
        if (v >= 0L) {
            throw new JsonReadException("duplicate field \"" + fieldName + "\"", parser.getCurrentLocation());
        }
        return JsonReader.readUnsignedLong(parser);
    }

    public static boolean readBoolean(JsonParser parser) throws IOException, JsonReadException {
        try {
            boolean b = parser.getBooleanValue();
            parser.nextToken();
            return b;
        }
        catch (JsonParseException ex) {
            throw JsonReadException.fromJackson(ex);
        }
    }

    public static double readDouble(JsonParser parser) throws IOException, JsonReadException {
        try {
            double v = parser.getDoubleValue();
            parser.nextToken();
            return v;
        }
        catch (JsonParseException ex) {
            throw JsonReadException.fromJackson(ex);
        }
    }

    public static <T> T readEnum(JsonParser parser, HashMap<String, T> values2, T catch_all) throws IOException, JsonReadException {
        if (parser.getCurrentToken() == JsonToken.START_OBJECT) {
            String text;
            parser.nextToken();
            String[] tags = JsonReader.readTags(parser);
            if (tags != null && parser.getCurrentToken() == JsonToken.END_OBJECT) {
                assert (tags.length == 1 && tags[0] != null);
                text = tags[0];
            } else if (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                text = parser.getText();
                assert (tags == null || tags[0].equals(text));
                parser.nextToken();
                JsonReader.skipValue(parser);
            } else {
                throw new JsonReadException("expecting a field name", parser.getTokenLocation());
            }
            T value = values2.get(text);
            if (value == null) {
                value = catch_all;
            }
            if (value == null) {
                throw new JsonReadException("Expected one of " + values2 + ", got: " + text, parser.getTokenLocation());
            }
            JsonReader.expectObjectEnd(parser);
            return value;
        }
        if (parser.getCurrentToken() != JsonToken.VALUE_STRING) {
            throw new JsonReadException("Expected a string value", parser.getTokenLocation());
        }
        String text = parser.getText();
        T value = values2.get(text);
        if (value == null) {
            value = catch_all;
        }
        if (value == null) {
            throw new JsonReadException("Expected one of " + values2 + ", got: " + text, parser.getTokenLocation());
        }
        parser.nextToken();
        return value;
    }

    public T readFully(InputStream utf8Body) throws IOException, JsonReadException {
        try {
            JsonParser parser = jsonFactory.createParser(utf8Body);
            return this.readFully(parser);
        }
        catch (JsonParseException ex) {
            throw JsonReadException.fromJackson(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T readFully(String body) throws JsonReadException {
        try (JsonParser parser = jsonFactory.createParser(body);){
            T t = this.readFully(parser);
            return t;
        }
        catch (JsonParseException ex) {
            throw JsonReadException.fromJackson(ex);
        }
        catch (IOException ex) {
            throw LangUtil.mkAssert("IOException reading from String", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T readFully(byte[] utf8Body) throws JsonReadException {
        try (JsonParser parser = jsonFactory.createParser(utf8Body);){
            T t = this.readFully(parser);
            return t;
        }
        catch (JsonParseException ex) {
            throw JsonReadException.fromJackson(ex);
        }
        catch (IOException ex) {
            throw LangUtil.mkAssert("IOException reading from byte[]", ex);
        }
    }

    public T readFromFile(String filePath) throws FileLoadException {
        return this.readFromFile(new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T readFromFile(File file) throws FileLoadException {
        try {
            FileInputStream in = new FileInputStream(file);
            try {
                T t = this.readFully(in);
                return t;
            }
            finally {
                IOUtil.closeInput(in);
            }
        }
        catch (JsonReadException ex) {
            throw new FileLoadException.JsonError(file, ex);
        }
        catch (IOException ex) {
            throw new FileLoadException.IOError(file, ex);
        }
    }

    public T readFully(JsonParser parser) throws IOException, JsonReadException {
        parser.nextToken();
        T value = this.read(parser);
        if (parser.getCurrentToken() != null) {
            throw new AssertionError((Object)("The JSON library should ensure there's no tokens after the main value: " + (Object)((Object)parser.getCurrentToken()) + "@" + parser.getCurrentLocation()));
        }
        this.validate(value);
        return value;
    }

    public static abstract class FileLoadException
    extends Exception {
        private static final long serialVersionUID = 0L;

        protected FileLoadException(String message) {
            super(message);
        }

        public static final class JsonError
        extends FileLoadException {
            private static final long serialVersionUID = 0L;
            public final JsonReadException reason;

            public JsonError(File file, JsonReadException reason) {
                super(file.getPath() + ": " + reason.getMessage());
                this.reason = reason;
            }
        }

        public static final class IOError
        extends FileLoadException {
            private static final long serialVersionUID = 0L;
            public final IOException reason;

            public IOError(File file, IOException reason) {
                super("unable to read file \"" + file.getPath() + "\": " + reason.getMessage());
                this.reason = reason;
            }
        }
    }

    public static final class FieldMapping {
        public final HashMap<String, Integer> fields;

        private FieldMapping(HashMap<String, Integer> fields) {
            assert (fields != null);
            this.fields = fields;
        }

        public int get(String fieldName) {
            Integer i = this.fields.get(fieldName);
            if (i == null) {
                return -1;
            }
            return i;
        }

        public static final class Builder {
            private HashMap<String, Integer> fields = new HashMap();

            public void add(String fieldName, int expectedIndex) {
                if (this.fields == null) {
                    throw new IllegalStateException("already called build(); can't call add() anymore");
                }
                int i = this.fields.size();
                if (expectedIndex != i) {
                    throw new IllegalStateException("expectedIndex = " + expectedIndex + ", actual = " + i);
                }
                Integer displaced = this.fields.put(fieldName, i);
                if (displaced != null) {
                    throw new IllegalStateException("duplicate field name: \"" + fieldName + "\"");
                }
            }

            public FieldMapping build() {
                if (this.fields == null) {
                    throw new IllegalStateException("already called build(); can't call build() again");
                }
                HashMap<String, Integer> f = this.fields;
                this.fields = null;
                return new FieldMapping(f);
            }
        }
    }
}

