/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.BadResponseException;
import com.dropbox.core.DbxApiException;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.DbxWrappedException;
import com.dropbox.core.NetworkIOException;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.stone.StoneSerializer;
import com.dropbox.core.util.IOUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class DbxUploader<R, E, X extends DbxApiException>
implements Closeable {
    private final HttpRequestor.Uploader httpUploader;
    private final StoneSerializer<R> responseSerializer;
    private final StoneSerializer<E> errorSerializer;
    private boolean closed;
    private boolean finished;
    private final String userId;

    protected DbxUploader(HttpRequestor.Uploader httpUploader, StoneSerializer<R> responseSerializer, StoneSerializer<E> errorSerializer, String userId) {
        this.httpUploader = httpUploader;
        this.responseSerializer = responseSerializer;
        this.errorSerializer = errorSerializer;
        this.closed = false;
        this.finished = false;
        this.userId = userId;
    }

    protected abstract X newException(DbxWrappedException var1);

    public R uploadAndFinish(InputStream in) throws X, DbxException, IOException {
        return this.uploadAndFinish(in, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R uploadAndFinish(InputStream in, IOUtil.ProgressListener progressListener) throws X, DbxException, IOException {
        try {
            try {
                this.httpUploader.setProgressListener(progressListener);
                this.httpUploader.upload(in);
            }
            catch (IOUtil.ReadException ex) {
                throw ex.getCause();
            }
            catch (IOException ex) {
                throw new NetworkIOException(ex);
            }
            R r = this.finish();
            return r;
        }
        finally {
            this.close();
        }
    }

    public R uploadAndFinish(InputStream in, long limit) throws X, DbxException, IOException {
        return this.uploadAndFinish(IOUtil.limit(in, limit));
    }

    public R uploadAndFinish(InputStream in, long limit, IOUtil.ProgressListener progressListener) throws X, DbxException, IOException {
        return this.uploadAndFinish(IOUtil.limit(in, limit), progressListener);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.httpUploader.close();
            this.closed = true;
        }
    }

    public void abort() {
        this.httpUploader.abort();
    }

    public OutputStream getOutputStream() {
        this.assertOpenAndUnfinished();
        return this.httpUploader.getBody();
    }

    public OutputStream getOutputStream(IOUtil.ProgressListener progressListener) {
        this.httpUploader.setProgressListener(progressListener);
        return this.getOutputStream();
    }

    /*
     * Loose catch block
     */
    public R finish() throws X, DbxException {
        this.assertOpenAndUnfinished();
        HttpRequestor.Response response = null;
        try {
            block11: {
                response = this.httpUploader.finish();
                if (response.getStatusCode() != 200) break block11;
                R r = this.responseSerializer.deserialize(response.getBody());
                {
                    catch (JsonProcessingException ex) {
                        String requestId = DbxRequestUtil.getRequestId(response);
                        throw new BadResponseException(requestId, "Bad JSON in response: " + ex, ex);
                    }
                }
                return r;
            }
            try {
                if (response.getStatusCode() == 409) {
                    DbxWrappedException wrapped = DbxWrappedException.fromResponse(this.errorSerializer, response, this.userId);
                    throw this.newException(wrapped);
                }
                throw DbxRequestUtil.unexpectedStatus(response);
            }
            catch (IOException ex) {
                throw new NetworkIOException(ex);
            }
        }
        finally {
            if (response != null) {
                IOUtil.closeQuietly(response.getBody());
            }
            this.finished = true;
        }
    }

    private void assertOpenAndUnfinished() {
        if (this.closed) {
            throw new IllegalStateException("This uploader is already closed.");
        }
        if (this.finished) {
            throw new IllegalStateException("This uploader is already finished and cannot be used to upload more data.");
        }
    }
}

