/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.DbxHost;
import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.json.JsonReader;
import com.dropbox.core.json.JsonWriter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public final class DbxAuthInfo {
    private final String accessToken;
    private final Long expiresAt;
    private final String refreshToken;
    private final DbxHost host;
    public static final JsonReader<DbxAuthInfo> Reader = new JsonReader<DbxAuthInfo>(){

        @Override
        public final DbxAuthInfo read(JsonParser parser) throws IOException, JsonReadException {
            JsonLocation top = JsonReader.expectObjectStart(parser);
            DbxHost host = null;
            String accessToken = null;
            Long expiresAt = null;
            String refreshToken = null;
            while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                String fieldName = parser.getCurrentName();
                parser.nextToken();
                try {
                    if (fieldName.equals("host")) {
                        host = DbxHost.Reader.readField(parser, fieldName, host);
                        continue;
                    }
                    if (fieldName.equals("expires_at")) {
                        expiresAt = (Long)Int64Reader.readField(parser, fieldName, expiresAt);
                        continue;
                    }
                    if (fieldName.equals("refresh_token")) {
                        refreshToken = (String)StringReader.readField(parser, fieldName, refreshToken);
                        continue;
                    }
                    if (fieldName.equals("access_token")) {
                        accessToken = (String)StringReader.readField(parser, fieldName, accessToken);
                        continue;
                    }
                    JsonReader.skipValue(parser);
                }
                catch (JsonReadException ex) {
                    throw ex.addFieldContext(fieldName);
                }
            }
            JsonReader.expectObjectEnd(parser);
            if (accessToken == null) {
                throw new JsonReadException("missing field \"access_token\"", top);
            }
            if (host == null) {
                host = DbxHost.DEFAULT;
            }
            return new DbxAuthInfo(accessToken, expiresAt, refreshToken, host);
        }
    };
    public static final JsonWriter<DbxAuthInfo> Writer = new JsonWriter<DbxAuthInfo>(){

        @Override
        public void write(DbxAuthInfo authInfo, JsonGenerator g) throws IOException {
            g.writeStartObject();
            g.writeStringField("access_token", authInfo.accessToken);
            if (authInfo.expiresAt != null) {
                g.writeNumberField("expires_at", authInfo.expiresAt);
            }
            if (authInfo.refreshToken != null) {
                g.writeStringField("refresh_token", authInfo.refreshToken);
            }
            if (!authInfo.host.equals(DbxHost.DEFAULT)) {
                g.writeFieldName("host");
                DbxHost.Writer.write(authInfo.host, g);
            }
            g.writeEndObject();
        }
    };

    public DbxAuthInfo(String accessToken, DbxHost host) {
        this(accessToken, null, null, host);
    }

    public DbxAuthInfo(String accessToken, Long expiresAt, String refreshToken, DbxHost host) {
        if (accessToken == null) {
            throw new IllegalArgumentException("'accessToken' can't be null");
        }
        if (host == null) {
            throw new IllegalArgumentException("'host' can't be null");
        }
        this.accessToken = accessToken;
        this.expiresAt = expiresAt;
        this.refreshToken = refreshToken;
        this.host = host;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Long getExpiresAt() {
        return this.expiresAt;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public DbxHost getHost() {
        return this.host;
    }
}

