/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.timeseries.response;

public class StockUnit {
    private double open;
    private double high;
    private double low;
    private double close;
    private double adjustedClose;
    private long volume;
    private double dividendAmount;
    private double splitCoefficient;
    private String dateTime;

    private StockUnit(Builder builder) {
        this.open = builder.open;
        this.high = builder.high;
        this.low = builder.low;
        this.close = builder.close;
        this.adjustedClose = builder.adjustedClose;
        this.volume = builder.volume;
        this.dividendAmount = builder.dividendAmount;
        this.splitCoefficient = builder.splitCoefficient;
        this.dateTime = builder.dateTime;
    }

    public double getOpen() {
        return this.open;
    }

    public double getHigh() {
        return this.high;
    }

    public double getLow() {
        return this.low;
    }

    public double getClose() {
        return this.close;
    }

    public double getAdjustedClose() {
        return this.adjustedClose;
    }

    public long getVolume() {
        return this.volume;
    }

    public double getDividendAmount() {
        return this.dividendAmount;
    }

    public double getSplitCoefficient() {
        return this.splitCoefficient;
    }

    public String getDate() {
        return this.dateTime;
    }

    public String toString() {
        return "\nStockUnit{open=" + this.open + ", high=" + this.high + ", low=" + this.low + ", close=" + this.close + ", adjustedClose=" + this.adjustedClose + ", volume=" + this.volume + ", dividendAmount=" + this.dividendAmount + ", splitCoefficient=" + this.splitCoefficient + ", date=" + this.dateTime + '}';
    }

    public static class Builder {
        double open;
        double high;
        double low;
        double close;
        double adjustedClose;
        long volume;
        double dividendAmount;
        double splitCoefficient;
        String dateTime;

        public Builder open(double open) {
            this.open = open;
            return this;
        }

        public Builder high(double high) {
            this.high = high;
            return this;
        }

        public Builder low(double low) {
            this.low = low;
            return this;
        }

        public Builder close(double close) {
            this.close = close;
            return this;
        }

        public Builder adjustedClose(double close) {
            this.adjustedClose = close;
            return this;
        }

        public Builder dividendAmount(double dividendAmount) {
            this.dividendAmount = dividendAmount;
            return this;
        }

        public Builder volume(long volume) {
            this.volume = volume;
            return this;
        }

        public Builder splitCoefficient(double splitCoefficient) {
            this.splitCoefficient = splitCoefficient;
            return this;
        }

        public Builder time(String dateTime) {
            this.dateTime = dateTime;
            return this;
        }

        public StockUnit build() {
            return new StockUnit(this);
        }
    }
}

